import { defineComponent, openBlock, createBlock, unref, withCtx, createElementVNode, createVNode, normalizeClass, normalizeStyle, createTextVNode, toDisplayString, createCommentVNode, renderSlot, reactive } from "vue";
import { Dialog, DialogPanel, DialogTitle, DialogDescription } from "@headlessui/vue";
const _hoisted_1 = { class: "scalar-modal-layout modal-layout" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "FlowModal",
  props: {
    state: {},
    title: {},
    bodyClass: {},
    maxWidth: {},
    variant: { default: "normal" }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Dialog), {
        open: _ctx.state.open,
        onClose: _cache[0] || (_cache[0] = ($event) => _ctx.state.hide())
      }, {
        default: withCtx(() => [
          createElementVNode("div", _hoisted_1, [
            createVNode(unref(DialogPanel), {
              class: normalizeClass(["modal", {
                "modal-content-large": _ctx.variant === "large",
                "modal-content-normal": _ctx.variant === "normal",
                "modal-content-small": _ctx.variant === "small",
                "modal-content-search": _ctx.variant === "search",
                "modal-content-history": _ctx.variant === "history"
              }]),
              style: normalizeStyle({ maxWidth: _ctx.maxWidth })
            }, {
              default: withCtx(() => [
                _ctx.title ? (openBlock(), createBlock(unref(DialogTitle), {
                  key: 0,
                  class: "modal-header"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.title), 1)
                  ]),
                  _: 1
                })) : createCommentVNode("", true),
                createVNode(unref(DialogDescription), {
                  class: normalizeClass(["modal-body custom-scroll", [_ctx.bodyClass]])
                }, {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "default", {}, void 0, true)
                  ]),
                  _: 3
                }, 8, ["class"])
              ]),
              _: 3
            }, 8, ["class", "style"])
          ])
        ]),
        _: 3
      }, 8, ["open"]);
    };
  }
});
const _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const FlowModal = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-40ed1fd7"]]);
const useModal = () => reactive({
  open: false,
  show() {
    this.open = true;
  },
  hide() {
    this.open = false;
  }
});
export {
  FlowModal,
  useModal
};
