/**
 * A component to insert the theme styles.
 */
export { default as ThemeStyles } from './components/ThemeStyles.vue';
/**
 * Available theme IDs as a type.
 */
export type ThemeId = 'alternate' | 'default' | 'moon' | 'purple' | 'solarized' | 'bluePlanet' | 'deepSpace' | 'saturn' | 'kepler' | 'mars' | 'none';
/**
 * List of available theme presets.
 */
export declare const presets: Record<Exclude<ThemeId, 'none'>, string>;
/**
 * List of available theme IDs.
 */
export declare const availableThemes: ThemeId[];
/**
 * Get the theme CSS for a given theme ID.
 */
export declare const getThemeById: (themeId?: ThemeId) => string;
//# sourceMappingURL=index.d.ts.map