import { ReferenceConfiguration } from '@scalar/api-reference';
import { Request, Response } from 'express';
import { FastifyRequest } from 'fastify';
import { ServerResponse } from 'http';

type NestJSReferenceConfiguration = ReferenceConfiguration & {
    withFastify?: boolean;
};
type ApiReferenceOptions = ReferenceConfiguration;
/**
 * The custom theme CSS for the API Reference.
 */
declare const customThemeCSS = "\n:root {\n  --theme-font: \"Inter\", var(--system-fonts);\n}\n/* basic theme */\n.light-mode {\n  --theme-color-1: #2a2f45;\n  --theme-color-2: #757575;\n  --theme-color-3: #8e8e8e;\n  --theme-color-accent: #e0234d;\n  --theme-background-1: #fff;\n  --theme-background-2: #f6f6f6;\n  --theme-background-3: #e7e7e7;\n  --theme-background-accent: #8ab4f81f;\n  --theme-border-color: rgba(0, 0, 0, 0.1);\n}\n.dark-mode {\n  --theme-color-1: rgba(255, 255, 255, 1);\n  --theme-color-2: #b2bac2;\n  --theme-color-3: #6e748b;\n  --theme-color-accent: #e0234d;\n  --theme-background-1: #11131e;\n  --theme-background-2: #1c2132;\n  --theme-background-3: #2f354a;\n  --theme-background-accent: #8ab4f81f;\n  --theme-border-color: rgba(255, 255, 255, 0.1);\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --sidebar-background-1: var(--theme-background-1);\n  --sidebar-item-hover-color: currentColor;\n  --sidebar-item-hover-background: var(--theme-background-2);\n  --sidebar-item-active-background: var(--theme-background-3);\n  --sidebar-border-color: var(--theme-border-color);\n  --sidebar-color-1: var(--theme-color-1);\n  --sidebar-color-2: var(--theme-color-2);\n  --sidebar-color-active: var(--theme-color-1);\n  --sidebar-search-background: var(--theme-background-2);\n  --sidebar-search-border-color: var(--theme-background-2);\n  --sidebar-search-color: var(--theme-color-3);\n}\n\n/* advanced */\n.light-mode {\n  --theme-button-1: rgb(49 53 56);\n  --theme-button-1-color: #fff;\n  --theme-button-1-hover: rgb(28 31 33);\n  --theme-color-green: #069061;\n  --theme-color-red: #ef0006;\n  --theme-color-yellow: #edbe20;\n  --theme-color-blue: #0082d0;\n  --theme-color-orange: #fb892c;\n  --theme-color-purple: #5203d1;\n  --theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n}\n.dark-mode {\n  --theme-button-1: #f6f6f6;\n  --theme-button-1-color: #000;\n  --theme-button-1-hover: #e7e7e7;\n  --theme-color-green: #30beb0;\n  --theme-color-red: #e91e63;\n  --theme-color-yellow: #ffc90d;\n  --theme-color-blue: #2cb6f6;\n  --theme-color-orange: #ff5656;\n  --theme-color-purple: #6223e0;\n  --theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n}\n";
/**
 * The HTML to load the @scalar/api-reference package.
 */
declare const ApiReference: (options: ApiReferenceOptions) => string;
/**
 * The HTML template to render the API Reference.
 */
declare function apiReference(options: NestJSReferenceConfiguration): ((req: FastifyRequest, res: ServerResponse) => void) | ((req: Request, res: Response) => void);

export { ApiReference, type ApiReferenceOptions, type NestJSReferenceConfiguration, apiReference, customThemeCSS };
