import * as hono_utils_html from 'hono/utils/html';
import { ReferenceConfiguration } from '@scalar/api-reference';
import { Env, MiddlewareHandler } from 'hono';

type ApiReferenceOptions = ReferenceConfiguration & {
    pageTitle?: string;
};
/**
 * The custom theme CSS for the API Reference.
 */
declare const customThemeCSS = "\n:root {\n  --theme-font: 'Inter', var(--system-fonts);\n}\n\n.light-mode {\n  color-scheme: light;\n  --theme-color-1: #2a2f45;\n  --theme-color-2: #757575;\n  --theme-color-3: #8e8e8e;\n  --theme-color-disabled: #b4b1b1;\n  --theme-color-ghost: #a7a7a7;\n  --theme-color-accent: #0099ff;\n  --theme-background-1: #fff;\n  --theme-background-2: #f6f6f6;\n  --theme-background-3: #e7e7e7;\n  --theme-background-4: rgba(0, 0, 0, 0.06);\n  --theme-background-accent: #8ab4f81f;\n\n  --theme-border-color: rgba(0, 0, 0, 0.1);\n  --theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --theme-lifted-brightness: 1;\n  --theme-backdrop-brightness: 1;\n\n  --theme-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --theme-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px,\n    rgba(0, 0, 0, 0.08) 0px 3px 8px 0px, #eeeeed 0px 0 0 1px;\n\n  --theme-button-1: rgb(49 53 56);\n  --theme-button-1-color: #fff;\n  --theme-button-1-hover: rgb(28 31 33);\n\n  --theme-color-green: #069061;\n  --theme-color-red: #ef0006;\n  --theme-color-yellow: #edbe20;\n  --theme-color-blue: #0082d0;\n  --theme-color-orange: #fb892c;\n  --theme-color-purple: #5203d1;\n}\n\n.dark-mode {\n  color-scheme: dark;\n  --theme-color-1: rgba(255, 255, 245, .86);\n  --theme-color-2: rgba(255, 255, 245, .6);\n  --theme-color-3: rgba(255, 255, 245, .38);\n  --theme-color-disabled: rgba(255, 255, 245, .25);\n  --theme-color-ghost: rgba(255, 255, 245, .25);\n  --theme-color-accent: #e36002;\n  --theme-background-1: #1e1e20;\n  --theme-background-2: #2a2a2a;\n  --theme-background-3: #505053;\n  --theme-background-4: rgba(255, 255, 255, 0.06);\n  --theme-background-accent: #e360021f;\n\n  --theme-border-color: rgba(255, 255, 255, 0.1);\n  --theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n  --theme-lifted-brightness: 1.45;\n  --theme-backdrop-brightness: 0.5;\n\n  --theme-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, 0.1);\n  --theme-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px,\n    rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px rgba(255, 255, 255, 0.1);\n\n  --theme-button-1: #f6f6f6;\n  --theme-button-1-color: #000;\n  --theme-button-1-hover: #e7e7e7;\n\n  --theme-color-green: #3dd68c;\n  --theme-color-red: #f66f81;\n  --theme-color-yellow: #f9b44e;\n  --theme-color-blue: #5c73e7;\n  --theme-color-orange: #ff8d4d;\n  --theme-color-purple: #b191f9;\n}\n/* Sidebar */\n.light-mode .t-doc__sidebar {\n  --sidebar-background-1: var(--theme-background-1);\n  --sidebar-item-hover-color: currentColor;\n  --sidebar-item-hover-background: var(--theme-background-2);\n  --sidebar-item-active-background: var(--theme-background-accent);\n  --sidebar-border-color: var(--theme-border-color);\n  --sidebar-color-1: var(--theme-color-1);\n  --sidebar-color-2: var(--theme-color-2);\n  --sidebar-color-active: var(--theme-color-accent);\n  --sidebar-search-background: var(--theme-background-2);\n  --sidebar-search-border-color: var(--sidebar-border-color);\n  --sidebar-search-color: var(--theme-color-3);\n}\n\n.dark-mode .sidebar {\n  --sidebar-background-1: #161618;\n  --sidebar-item-hover-color: var(--theme-color-accent);\n  --sidebar-item-hover-background: transparent;\n  --sidebar-item-active-background: transparent;\n  --sidebar-border-color: transparent;\n  --sidebar-color-1: var(--theme-color-1);\n  --sidebar-color-2: var(--theme-color-2);\n  --sidebar-color-active: var(--theme-color-accent);\n  --sidebar-search-background: #252529;\n  --sidebar-search-border-color: transparent;\n  --sidebar-search-color: var(--theme-color-3);\n}\n";
/**
 * The HTML to load the @scalar/api-reference JavaScript package.
 */
declare const javascript: (configuration: ReferenceConfiguration) => hono_utils_html.HtmlEscapedString | Promise<hono_utils_html.HtmlEscapedString>;
/**
 * The middleware for the API Reference.
 */
declare const apiReference: <E extends Env>(options: ApiReferenceOptions) => MiddlewareHandler<E>;

export { type ApiReferenceOptions, apiReference, customThemeCSS, javascript };
