import type { ReferenceConfiguration } from '@scalar/api-reference';
import type { FastifyPluginAsync } from 'fastify';
export type FastifyApiReferenceOptions = {
    /**
     * Prefix for the registered route
     *
     * @default ''
     */
    routePrefix?: string;
    configuration?: ReferenceConfiguration;
};
/**
 * The Fastify custom theme CSS
 */
export declare const defaultCss = "\n:root {\n  --theme-font: 'Inter', var(--system-fonts);\n}\n\n.light-mode {\n  color-scheme: light;\n  --theme-color-1: #1c1e21;\n  --theme-color-2: #757575;\n  --theme-color-3: #8e8e8e;\n  --theme-color-disabled: #b4b1b1;\n  --theme-color-ghost: #a7a7a7;\n  --theme-color-accent: #2f8555;\n  --theme-background-1: #fff;\n  --theme-background-2: #f5f5f5;\n  --theme-background-3: #ededed;\n  --theme-background-4: rgba(0, 0, 0, 0.06);\n  --theme-background-accent: #2f85551f;\n\n  --theme-border-color: rgba(0, 0, 0, 0.1);\n  --theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --theme-lifted-brightness: 1;\n  --theme-backdrop-brightness: 1;\n\n  --theme-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --theme-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px,\n    rgba(0, 0, 0, 0.08) 0px 3px 8px 0px, #eeeeed 0px 0 0 1px;\n\n  --theme-button-1: rgb(49 53 56);\n  --theme-button-1-color: #fff;\n  --theme-button-1-hover: rgb(28 31 33);\n\n  --theme-color-green: #007300;\n  --theme-color-red: #af272b;\n  --theme-color-yellow: #b38200;\n  --theme-color-blue: #3b8ba5;\n  --theme-color-orange: #fb892c;\n  --theme-color-purple: #5203d1;\n}\n\n.dark-mode {\n  color-scheme: dark;\n  --theme-color-1: rgba(255, 255, 255, 0.9);\n  --theme-color-2: rgba(255, 255, 255, 0.62);\n  --theme-color-3: rgba(255, 255, 255, 0.44);\n  --theme-color-disabled: rgba(255, 255, 255, 0.34);\n  --theme-color-ghost: rgba(255, 255, 255, 0.26);\n  --theme-color-accent: #27c2a0;\n  --theme-background-1: #1b1b1d;\n  --theme-background-2: #242526;\n  --theme-background-3: #3b3b3b;\n  --theme-background-4: rgba(255, 255, 255, 0.06);\n  --theme-background-accent: #27c2a01f;\n\n  --theme-border-color: rgba(255, 255, 255, 0.1);\n  --theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n  --theme-lifted-brightness: 1.45;\n  --theme-backdrop-brightness: 0.5;\n\n  --theme-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, 0.1);\n  --theme-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px,\n    rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px rgba(255, 255, 255, 0.1);\n\n  --theme-button-1: #f6f6f6;\n  --theme-button-1-color: #000;\n  --theme-button-1-hover: #e7e7e7;\n\n  --theme-color-green: #26b226;\n  --theme-color-red: #fb565b;\n  --theme-color-yellow: #ffc426;\n  --theme-color-blue: #6ecfef;\n  --theme-color-orange: #ff8d4d;\n  --theme-color-purple: #b191f9;\n}\n";
/**
 * The HTML to load the @scalar/api-reference JavaScript package.
 */
export declare const javascript: (options: FastifyApiReferenceOptions) => string;
/**
 * The HTML template to render the API Reference.
 */
export declare function htmlDocument(options: FastifyApiReferenceOptions): string;
declare const fastifyApiReference: FastifyPluginAsync<FastifyApiReferenceOptions>;
export default fastifyApiReference;
//# sourceMappingURL=fastifyApiReference.d.ts.map