import { ReferenceConfiguration } from '@scalar/api-reference';
import { Request, Response } from 'express';

type ApiReferenceOptions = ReferenceConfiguration;
/**
 * The custom theme CSS for the API Reference.
 */
declare const customThemeCSS = "\n:root {\n  --theme-font: 'Inter', var(--system-fonts);\n}\n/* basic theme */\n.light-mode {\n  --theme-color-1: #353535;\n  --theme-color-2: #555555;\n  --theme-color-3: #aeaeae;\n  --theme-color-accent: #259dff;\n\n  --theme-background-1: #fff;\n  --theme-background-2: #f7f7f7;\n  --theme-background-3: #dadada;\n  --theme-background-accent: #E0F5FF;\n\n  --theme-border-color: rgba(0, 0, 0, 0.1);\n}\n.dark-mode {\n  --theme-color-1: rgba(255, 255, 255, 0.9);\n  --theme-color-2: rgba(255, 255, 255, 0.62);\n  --theme-color-3: rgba(255, 255, 255, 0.44);\n  --theme-color-accent: #8ab4f8;\n\n  --theme-background-1: #1a1a1a;\n  --theme-background-2: #252525;\n  --theme-background-3: #323232;\n  --theme-background-accent: #8ab4f81f;\n\n  --theme-border-color: rgba(255, 255, 255, 0.1);\n}\n\n/* Document Sidebar */\n.light-mode .t-doc__sidebar {\n  --sidebar-background-1: var(--theme-background-1);\n  --sidebar-item-hover-color: currentColor;\n  --sidebar-item-hover-background: var(--theme-background-2);\n  --sidebar-item-active-background: var(--theme-background-accent);\n  --sidebar-border-color: var(--theme-border-color);\n  --sidebar-color-1: var(--theme-color-1);\n  --sidebar-color-2: var(--theme-color-2);\n  --sidebar-color-active: var(--theme-color-accent);\n  --sidebar-search-background: transparent;\n  --sidebar-search-border-color: var(--theme-border-color);\n  --sidebar-search-color: var(--theme-color-3);\n}\n\n.dark-mode .sidebar {\n  --sidebar-background-1: var(--theme-background-1);\n  --sidebar-item-hover-color: currentColor;\n  --sidebar-item-hover-background: var(--theme-background-2);\n  --sidebar-item-active-background: var(--theme-background-accent);\n  --sidebar-border-color: var(--theme-border-color);\n  --sidebar-color-1: var(--theme-color-1);\n  --sidebar-color-2: var(--theme-color-2);\n  --sidebar-color-active: var(--theme-color-accent);\n  --sidebar-search-background: transparent;\n  --sidebar-search-border-color: var(--theme-border-color);\n  --sidebar-search-color: var(--theme-color-3);\n}\n\n/* advanced */\n.light-mode {\n  --theme-button-1: rgb(49 53 56);\n  --theme-button-1-color: #fff;\n  --theme-button-1-hover: rgb(28 31 33);\n\n  --theme-color-green: #669900;\n  --theme-color-red: #dc4a68;\n  --theme-color-yellow: #edbe20;\n  --theme-color-blue: #0277aa;\n  --theme-color-orange: #fb892c;\n  --theme-color-purple: #5203d1;\n\n  --theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n}\n.dark-mode {\n  --theme-button-1: #f6f6f6;\n  --theme-button-1-color: #000;\n  --theme-button-1-hover: #e7e7e7;\n\n  --theme-color-green: #00b648;\n  --theme-color-red: #dc1b19;\n  --theme-color-yellow: #ffc90d;\n  --theme-color-blue: #4eb3ec;\n  --theme-color-orange: #ff8d4d;\n  --theme-color-purple: #b191f9;\n\n  --theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n}\n:root {\n  --theme-radius: 3px;\n  --theme-radius-lg: 3px;\n  --theme-radius-xl: 3px;\n}\n";
/**
 * The HTML to load the @scalar/api-reference package.
 */
declare const ApiReference: (options: ApiReferenceOptions) => string;
/**
 * The HTML template to render the API Reference.
 */
declare function apiReference(options: ReferenceConfiguration): (req: Request, res: Response) => void;

export { ApiReference, type ApiReferenceOptions, apiReference, customThemeCSS };
