import { defineComponent as I, useCssVars as ee, openBlock as w, createElementBlock as C, normalizeClass as k, unref as g, createElementVNode as A, createCommentVNode as T, createStaticVNode as te, reactive as F, computed as H, useAttrs as U, mergeProps as Z, renderSlot as B, createVNode as D, ref as z, watch as re, nextTick as ae, onMounted as W, toDisplayString as M, defineAsyncComponent as ne, h as oe, createBlock as P, withCtx as O, normalizeStyle as X, createTextVNode as se, resolveDynamicComponent as le, withKeys as ie } from "vue";
import { defineConfig as ce } from "cva";
import { extendTailwindMerge as de } from "tailwind-merge";
import q from "prismjs";
import { Dialog as ue, DialogPanel as pe, DialogTitle as me, DialogDescription as he } from "@headlessui/vue";
import { useTextareaAutosize as ge } from "@vueuse/core";
import { nanoid as ve } from "nanoid";
const R = "scalar-component", fe = de({
  extend: {
    classGroups: {
      // Add the scalar class prefix as a custom class to be deduped by tailwind-merge
      [R]: [R]
    }
  }
}), { cva: N, cx: E, compose: gt } = ce({
  hooks: {
    onComplete: (r) => `${fe(r, R)}`
  }
}), be = /* @__PURE__ */ te('<path class="svg-path svg-check-mark" d="m 0 60 l 30 30 l 70 -80" data-v-0f0b7a55></path><path class="svg-path svg-x-mark" d="m 50 50 l 40 -40" data-v-0f0b7a55></path><path class="svg-path svg-x-mark" d="m 50 50 l 40 40" data-v-0f0b7a55></path><path class="svg-path svg-x-mark" d="m 50 50 l -40 -40" data-v-0f0b7a55></path><path class="svg-path svg-x-mark" d="m 50 50 l -40 40" data-v-0f0b7a55></path>', 5), ke = {
  key: 0,
  class: "circular-loader"
};
function vt() {
  return F({
    isValid: !1,
    isInvalid: !1,
    isLoading: !1,
    startLoading() {
      this.isLoading = !0;
    },
    stopLoading() {
      this.isLoading = !1;
    },
    validate(r = 800) {
      this.isValid = !0;
      const t = r - 300;
      return new Promise(
        (e) => setTimeout(() => this.clear().then(() => e(!0)), t)
      );
    },
    invalidate(r = 1100) {
      this.isInvalid = !0;
      const t = r - 300;
      return new Promise(
        (e) => setTimeout(() => this.clear().then(() => e(!0)), t)
      );
    },
    clear(r = 300) {
      return this.isValid = !1, this.isInvalid = !1, this.isLoading = !1, new Promise((t) => {
        setTimeout(() => {
          t(!0);
        }, r);
      });
    }
  });
}
const we = /* @__PURE__ */ I({
  __name: "ScalarLoading",
  props: {
    loadingState: {},
    size: { default: "24px" }
  },
  setup(r) {
    return ee((t) => ({
      "50aa2fee": t.size
    })), (t, e) => t.loadingState ? (w(), C("div", {
      key: 0,
      class: k(g(E)("loader-wrapper"))
    }, [
      (w(), C("svg", {
        class: k(["svg-loader", {
          "icon-is-valid": t.loadingState.isValid,
          "icon-is-invalid": t.loadingState.isInvalid
        }]),
        viewBox: "0 0 100 100",
        xmlns: "http://www.w3.org/2000/svg",
        "xmlns:xlink": "http://www.w3.org/1999/xlink"
      }, [
        be,
        t.loadingState.isLoading ? (w(), C("g", ke, [
          A("circle", {
            class: k(["loader-path", {
              "loader-path-off": t.loadingState.isValid || t.loadingState.isInvalid
            }]),
            cx: "50",
            cy: "50",
            fill: "none",
            r: "20",
            "stroke-width": "2"
          }, null, 2)
        ])) : T("", !0)
      ], 2))
    ], 2)) : T("", !0);
  }
}), $ = (r, t) => {
  const e = r.__vccOpts || r;
  for (const [s, u] of t)
    e[s] = u;
  return e;
}, K = /* @__PURE__ */ $(we, [["__scopeId", "data-v-0f0b7a55"]]), Y = {
  solid: [
    "scalar-button-solid",
    "bg-back-btn-1 text-fore-btn-1 shadow-sm active:bg-back-btn-1 active:shadow-none hocus:bg-hover-btn-1"
  ],
  outlined: [
    "scalar-button-outlined",
    "active:bg-btn-1 border border-solid border-border bg-transparent text-fore-1 hocus:bg-back-2"
  ],
  ghost: [
    "scalar-button-ghost",
    "bg-transparent text-fore-3 active:text-fore-2 hocus:text-fore-2"
  ],
  danger: [
    "scalar-button-danger",
    "bg-error text-white active:brightness-90 hocus:brightness-90"
  ]
}, _e = N({
  base: "scalar-button row cursor-pointer items-center justify-center rounded font-medium",
  variants: {
    disabled: {
      true: "bg-background-2 text-color-3 cursor-not-allowed shadow-none"
    },
    fullWidth: { true: "w-full" },
    size: { md: "h-10 px-6 text-sm" },
    variant: Y
  },
  compoundVariants: [
    {
      disabled: !0,
      variant: "ghost",
      class: "bg-transparent text-ghost"
    }
  ]
}), Se = ["ariaDisabled"], ye = {
  key: 0,
  class: "mr-2 h-4 w-4"
}, xe = {
  key: 1,
  class: "ml-2"
}, Ce = /* @__PURE__ */ I({
  inheritAttrs: !1,
  __name: "ScalarButton",
  props: {
    disabled: { type: Boolean },
    fullWidth: { type: Boolean, default: !1 },
    loading: {},
    size: { default: "md" },
    variant: { default: "solid" }
  },
  setup(r) {
    const t = H(() => {
      const { class: e, ...s } = U();
      return { className: e || "", rest: s };
    });
    return (e, s) => (w(), C("button", Z(t.value.rest, {
      ariaDisabled: e.disabled || void 0,
      class: g(E)(
        g(_e)({ fullWidth: e.fullWidth, disabled: e.disabled, size: e.size, variant: e.variant }),
        { "pl-9 pr-3": e.loading },
        `${t.value.className}`
      ),
      type: "button"
    }), [
      e.$slots.icon ? (w(), C("div", ye, [
        B(e.$slots, "icon")
      ])) : T("", !0),
      B(e.$slots, "default"),
      e.loading ? (w(), C("div", xe, [
        D(g(K), {
          loadingState: e.loading,
          size: "20px"
        }, null, 8, ["loadingState"])
      ])) : T("", !0)
    ], 16, Se));
  }
});
(function(r) {
  var t = "\\b(?:BASH|BASHOPTS|BASH_ALIASES|BASH_ARGC|BASH_ARGV|BASH_CMDS|BASH_COMPLETION_COMPAT_DIR|BASH_LINENO|BASH_REMATCH|BASH_SOURCE|BASH_VERSINFO|BASH_VERSION|COLORTERM|COLUMNS|COMP_WORDBREAKS|DBUS_SESSION_BUS_ADDRESS|DEFAULTS_PATH|DESKTOP_SESSION|DIRSTACK|DISPLAY|EUID|GDMSESSION|GDM_LANG|GNOME_KEYRING_CONTROL|GNOME_KEYRING_PID|GPG_AGENT_INFO|GROUPS|HISTCONTROL|HISTFILE|HISTFILESIZE|HISTSIZE|HOME|HOSTNAME|HOSTTYPE|IFS|INSTANCE|JOB|LANG|LANGUAGE|LC_ADDRESS|LC_ALL|LC_IDENTIFICATION|LC_MEASUREMENT|LC_MONETARY|LC_NAME|LC_NUMERIC|LC_PAPER|LC_TELEPHONE|LC_TIME|LESSCLOSE|LESSOPEN|LINES|LOGNAME|LS_COLORS|MACHTYPE|MAILCHECK|MANDATORY_PATH|NO_AT_BRIDGE|OLDPWD|OPTERR|OPTIND|ORBIT_SOCKETDIR|OSTYPE|PAPERSIZE|PATH|PIPESTATUS|PPID|PS1|PS2|PS3|PS4|PWD|RANDOM|REPLY|SECONDS|SELINUX_INIT|SESSION|SESSIONTYPE|SESSION_MANAGER|SHELL|SHELLOPTS|SHLVL|SSH_AUTH_SOCK|TERM|UID|UPSTART_EVENTS|UPSTART_INSTANCE|UPSTART_JOB|UPSTART_SESSION|USER|WINDOWID|XAUTHORITY|XDG_CONFIG_DIRS|XDG_CURRENT_DESKTOP|XDG_DATA_DIRS|XDG_GREETER_DATA_DIR|XDG_MENU_PREFIX|XDG_RUNTIME_DIR|XDG_SEAT|XDG_SEAT_PATH|XDG_SESSION_DESKTOP|XDG_SESSION_ID|XDG_SESSION_PATH|XDG_SESSION_TYPE|XDG_VTNR|XMODIFIERS)\\b", e = {
    pattern: /(^(["']?)\w+\2)[ \t]+\S.*/,
    lookbehind: !0,
    alias: "punctuation",
    // this looks reasonably well in all themes
    inside: null
    // see below
  }, s = {
    bash: e,
    environment: {
      pattern: RegExp("\\$" + t),
      alias: "constant"
    },
    variable: [
      // [0]: Arithmetic Environment
      {
        pattern: /\$?\(\([\s\S]+?\)\)/,
        greedy: !0,
        inside: {
          // If there is a $ sign at the beginning highlight $(( and )) as variable
          variable: [
            {
              pattern: /(^\$\(\([\s\S]+)\)\)/,
              lookbehind: !0
            },
            /^\$\(\(/
          ],
          number: /\b0x[\dA-Fa-f]+\b|(?:\b\d+(?:\.\d*)?|\B\.\d+)(?:[Ee]-?\d+)?/,
          // Operators according to https://www.gnu.org/software/bash/manual/bashref.html#Shell-Arithmetic
          operator: /--|\+\+|\*\*=?|<<=?|>>=?|&&|\|\||[=!+\-*/%<>^&|]=?|[?~:]/,
          // If there is no $ sign at the beginning highlight (( and )) as punctuation
          punctuation: /\(\(?|\)\)?|,|;/
        }
      },
      // [1]: Command Substitution
      {
        pattern: /\$\((?:\([^)]+\)|[^()])+\)|`[^`]+`/,
        greedy: !0,
        inside: {
          variable: /^\$\(|^`|\)$|`$/
        }
      },
      // [2]: Brace expansion
      {
        pattern: /\$\{[^}]+\}/,
        greedy: !0,
        inside: {
          operator: /:[-=?+]?|[!\/]|##?|%%?|\^\^?|,,?/,
          punctuation: /[\[\]]/,
          environment: {
            pattern: RegExp("(\\{)" + t),
            lookbehind: !0,
            alias: "constant"
          }
        }
      },
      /\$(?:\w+|[#?*!@$])/
    ],
    // Escape sequences from echo and printf's manuals, and escaped quotes.
    entity: /\\(?:[abceEfnrtv\\"]|O?[0-7]{1,3}|U[0-9a-fA-F]{8}|u[0-9a-fA-F]{4}|x[0-9a-fA-F]{1,2})/
  };
  r.languages.bash = {
    shebang: {
      pattern: /^#!\s*\/.*/,
      alias: "important"
    },
    comment: {
      pattern: /(^|[^"{\\$])#.*/,
      lookbehind: !0
    },
    "function-name": [
      // a) function foo {
      // b) foo() {
      // c) function foo() {
      // but not “foo {”
      {
        // a) and c)
        pattern: /(\bfunction\s+)[\w-]+(?=(?:\s*\(?:\s*\))?\s*\{)/,
        lookbehind: !0,
        alias: "function"
      },
      {
        // b)
        pattern: /\b[\w-]+(?=\s*\(\s*\)\s*\{)/,
        alias: "function"
      }
    ],
    // Highlight variable names as variables in for and select beginnings.
    "for-or-select": {
      pattern: /(\b(?:for|select)\s+)\w+(?=\s+in\s)/,
      alias: "variable",
      lookbehind: !0
    },
    // Highlight variable names as variables in the left-hand part
    // of assignments (“=” and “+=”).
    "assign-left": {
      pattern: /(^|[\s;|&]|[<>]\()\w+(?:\.\w+)*(?=\+?=)/,
      inside: {
        environment: {
          pattern: RegExp("(^|[\\s;|&]|[<>]\\()" + t),
          lookbehind: !0,
          alias: "constant"
        }
      },
      alias: "variable",
      lookbehind: !0
    },
    // Highlight parameter names as variables
    parameter: {
      pattern: /(^|\s)-{1,2}(?:\w+:[+-]?)?\w+(?:\.\w+)*(?=[=\s]|$)/,
      alias: "variable",
      lookbehind: !0
    },
    string: [
      // Support for Here-documents https://en.wikipedia.org/wiki/Here_document
      {
        pattern: /((?:^|[^<])<<-?\s*)(\w+)\s[\s\S]*?(?:\r?\n|\r)\2/,
        lookbehind: !0,
        greedy: !0,
        inside: s
      },
      // Here-document with quotes around the tag
      // → No expansion (so no “inside”).
      {
        pattern: /((?:^|[^<])<<-?\s*)(["'])(\w+)\2\s[\s\S]*?(?:\r?\n|\r)\3/,
        lookbehind: !0,
        greedy: !0,
        inside: {
          bash: e
        }
      },
      // “Normal” string
      {
        // https://www.gnu.org/software/bash/manual/html_node/Double-Quotes.html
        pattern: /(^|[^\\](?:\\\\)*)"(?:\\[\s\S]|\$\([^)]+\)|\$(?!\()|`[^`]+`|[^"\\`$])*"/,
        lookbehind: !0,
        greedy: !0,
        inside: s
      },
      {
        // https://www.gnu.org/software/bash/manual/html_node/Single-Quotes.html
        pattern: /(^|[^$\\])'[^']*'/,
        lookbehind: !0,
        greedy: !0
      },
      {
        // https://www.gnu.org/software/bash/manual/html_node/ANSI_002dC-Quoting.html
        pattern: /\$'(?:[^'\\]|\\[\s\S])*'/,
        greedy: !0,
        inside: {
          entity: s.entity
        }
      }
    ],
    environment: {
      pattern: RegExp("\\$?" + t),
      alias: "constant"
    },
    variable: s.variable,
    function: {
      pattern: /(^|[\s;|&]|[<>]\()(?:add|apropos|apt|apt-cache|apt-get|aptitude|aspell|automysqlbackup|awk|basename|bash|bc|bconsole|bg|bzip2|cal|cargo|cat|cfdisk|chgrp|chkconfig|chmod|chown|chroot|cksum|clear|cmp|column|comm|composer|cp|cron|crontab|csplit|curl|cut|date|dc|dd|ddrescue|debootstrap|df|diff|diff3|dig|dir|dircolors|dirname|dirs|dmesg|docker|docker-compose|du|egrep|eject|env|ethtool|expand|expect|expr|fdformat|fdisk|fg|fgrep|file|find|fmt|fold|format|free|fsck|ftp|fuser|gawk|git|gparted|grep|groupadd|groupdel|groupmod|groups|grub-mkconfig|gzip|halt|head|hg|history|host|hostname|htop|iconv|id|ifconfig|ifdown|ifup|import|install|ip|java|jobs|join|kill|killall|less|link|ln|locate|logname|logrotate|look|lpc|lpr|lprint|lprintd|lprintq|lprm|ls|lsof|lynx|make|man|mc|mdadm|mkconfig|mkdir|mke2fs|mkfifo|mkfs|mkisofs|mknod|mkswap|mmv|more|most|mount|mtools|mtr|mutt|mv|nano|nc|netstat|nice|nl|node|nohup|notify-send|npm|nslookup|op|open|parted|passwd|paste|pathchk|ping|pkill|pnpm|podman|podman-compose|popd|pr|printcap|printenv|ps|pushd|pv|quota|quotacheck|quotactl|ram|rar|rcp|reboot|remsync|rename|renice|rev|rm|rmdir|rpm|rsync|scp|screen|sdiff|sed|sendmail|seq|service|sftp|sh|shellcheck|shuf|shutdown|sleep|slocate|sort|split|ssh|stat|strace|su|sudo|sum|suspend|swapon|sync|sysctl|tac|tail|tar|tee|time|timeout|top|touch|tr|traceroute|tsort|tty|umount|uname|unexpand|uniq|units|unrar|unshar|unzip|update-grub|uptime|useradd|userdel|usermod|users|uudecode|uuencode|v|vcpkg|vdir|vi|vim|virsh|vmstat|wait|watch|wc|wget|whereis|which|who|whoami|write|xargs|xdg-open|yarn|yes|zenity|zip|zsh|zypper)(?=$|[)\s;|&])/,
      lookbehind: !0
    },
    keyword: {
      pattern: /(^|[\s;|&]|[<>]\()(?:case|do|done|elif|else|esac|fi|for|function|if|in|select|then|until|while)(?=$|[)\s;|&])/,
      lookbehind: !0
    },
    // https://www.gnu.org/software/bash/manual/html_node/Shell-Builtin-Commands.html
    builtin: {
      pattern: /(^|[\s;|&]|[<>]\()(?:\.|:|alias|bind|break|builtin|caller|cd|command|continue|declare|echo|enable|eval|exec|exit|export|getopts|hash|help|let|local|logout|mapfile|printf|pwd|read|readarray|readonly|return|set|shift|shopt|source|test|times|trap|type|typeset|ulimit|umask|unalias|unset)(?=$|[)\s;|&])/,
      lookbehind: !0,
      // Alias added to make those easier to distinguish from strings.
      alias: "class-name"
    },
    boolean: {
      pattern: /(^|[\s;|&]|[<>]\()(?:false|true)(?=$|[)\s;|&])/,
      lookbehind: !0
    },
    "file-descriptor": {
      pattern: /\B&\d\b/,
      alias: "important"
    },
    operator: {
      // Lots of redirections here, but not just that.
      pattern: /\d?<>|>\||\+=|=[=~]?|!=?|<<[<-]?|[&\d]?>>|\d[<>]&?|[<>][&=]?|&[>&]?|\|[&|]?/,
      inside: {
        "file-descriptor": {
          pattern: /^\d/,
          alias: "important"
        }
      }
    },
    punctuation: /\$?\(\(?|\)\)?|\.\.|[{}[\];\\]/,
    number: {
      pattern: /(^|\s)(?:[1-9]\d*|0)(?:[.,]\d+)?\b/,
      lookbehind: !0
    }
  }, e.inside = r.languages.bash;
  for (var u = [
    "comment",
    "function-name",
    "for-or-select",
    "assign-left",
    "parameter",
    "string",
    "environment",
    "function",
    "keyword",
    "builtin",
    "boolean",
    "file-descriptor",
    "operator",
    "punctuation",
    "number"
  ], f = s.variable[1].inside, a = 0; a < u.length; a++)
    f[u[a]] = r.languages.bash[u[a]];
  r.languages.sh = r.languages.bash, r.languages.shell = r.languages.bash;
})(Prism);
Prism.languages.json = {
  property: {
    pattern: /(^|[^\\])"(?:\\.|[^\\"\r\n])*"(?=\s*:)/,
    lookbehind: !0,
    greedy: !0
  },
  string: {
    pattern: /(^|[^\\])"(?:\\.|[^\\"\r\n])*"(?!\s*:)/,
    lookbehind: !0,
    greedy: !0
  },
  comment: {
    pattern: /\/\/.*|\/\*[\s\S]*?(?:\*\/|$)/,
    greedy: !0
  },
  number: /-?\b\d+(?:\.\d+)?(?:e[+-]?\d+)?\b/i,
  punctuation: /[{}[\],]/,
  operator: /:/,
  boolean: /\b(?:false|true)\b/,
  null: {
    pattern: /\bnull\b/,
    alias: "keyword"
  }
};
Prism.languages.webmanifest = Prism.languages.json;
(function() {
  if (typeof Prism > "u" || typeof document > "u")
    return;
  var r = (
    /*dependencies_placeholder[*/
    {
      javascript: "clike",
      actionscript: "javascript",
      apex: [
        "clike",
        "sql"
      ],
      arduino: "cpp",
      aspnet: [
        "markup",
        "csharp"
      ],
      birb: "clike",
      bison: "c",
      c: "clike",
      csharp: "clike",
      cpp: "c",
      cfscript: "clike",
      chaiscript: [
        "clike",
        "cpp"
      ],
      cilkc: "c",
      cilkcpp: "cpp",
      coffeescript: "javascript",
      crystal: "ruby",
      "css-extras": "css",
      d: "clike",
      dart: "clike",
      django: "markup-templating",
      ejs: [
        "javascript",
        "markup-templating"
      ],
      etlua: [
        "lua",
        "markup-templating"
      ],
      erb: [
        "ruby",
        "markup-templating"
      ],
      fsharp: "clike",
      "firestore-security-rules": "clike",
      flow: "javascript",
      ftl: "markup-templating",
      gml: "clike",
      glsl: "c",
      go: "clike",
      gradle: "clike",
      groovy: "clike",
      haml: "ruby",
      handlebars: "markup-templating",
      haxe: "clike",
      hlsl: "c",
      idris: "haskell",
      java: "clike",
      javadoc: [
        "markup",
        "java",
        "javadoclike"
      ],
      jolie: "clike",
      jsdoc: [
        "javascript",
        "javadoclike",
        "typescript"
      ],
      "js-extras": "javascript",
      json5: "json",
      jsonp: "json",
      "js-templates": "javascript",
      kotlin: "clike",
      latte: [
        "clike",
        "markup-templating",
        "php"
      ],
      less: "css",
      lilypond: "scheme",
      liquid: "markup-templating",
      markdown: "markup",
      "markup-templating": "markup",
      mongodb: "javascript",
      n4js: "javascript",
      objectivec: "c",
      opencl: "c",
      parser: "markup",
      php: "markup-templating",
      phpdoc: [
        "php",
        "javadoclike"
      ],
      "php-extras": "php",
      plsql: "sql",
      processing: "clike",
      protobuf: "clike",
      pug: [
        "markup",
        "javascript"
      ],
      purebasic: "clike",
      purescript: "haskell",
      qsharp: "clike",
      qml: "javascript",
      qore: "clike",
      racket: "scheme",
      cshtml: [
        "markup",
        "csharp"
      ],
      jsx: [
        "markup",
        "javascript"
      ],
      tsx: [
        "jsx",
        "typescript"
      ],
      reason: "clike",
      ruby: "clike",
      sass: "css",
      scss: "css",
      scala: "java",
      "shell-session": "bash",
      smarty: "markup-templating",
      solidity: "clike",
      soy: "markup-templating",
      sparql: "turtle",
      sqf: "clike",
      squirrel: "clike",
      stata: [
        "mata",
        "java",
        "python"
      ],
      "t4-cs": [
        "t4-templating",
        "csharp"
      ],
      "t4-vb": [
        "t4-templating",
        "vbnet"
      ],
      tap: "yaml",
      tt2: [
        "clike",
        "markup-templating"
      ],
      textile: "markup",
      twig: "markup-templating",
      typescript: "javascript",
      v: "clike",
      vala: "clike",
      vbnet: "basic",
      velocity: "markup",
      wiki: "markup",
      xeora: "markup",
      "xml-doc": "markup",
      xquery: "markup"
    }
  ), t = (
    /*aliases_placeholder[*/
    {
      html: "markup",
      xml: "markup",
      svg: "markup",
      mathml: "markup",
      ssml: "markup",
      atom: "markup",
      rss: "markup",
      js: "javascript",
      g4: "antlr4",
      ino: "arduino",
      "arm-asm": "armasm",
      art: "arturo",
      adoc: "asciidoc",
      avs: "avisynth",
      avdl: "avro-idl",
      gawk: "awk",
      sh: "bash",
      shell: "bash",
      shortcode: "bbcode",
      rbnf: "bnf",
      oscript: "bsl",
      cs: "csharp",
      dotnet: "csharp",
      cfc: "cfscript",
      "cilk-c": "cilkc",
      "cilk-cpp": "cilkcpp",
      cilk: "cilkcpp",
      coffee: "coffeescript",
      conc: "concurnas",
      jinja2: "django",
      "dns-zone": "dns-zone-file",
      dockerfile: "docker",
      gv: "dot",
      eta: "ejs",
      xlsx: "excel-formula",
      xls: "excel-formula",
      gamemakerlanguage: "gml",
      po: "gettext",
      gni: "gn",
      ld: "linker-script",
      "go-mod": "go-module",
      hbs: "handlebars",
      mustache: "handlebars",
      hs: "haskell",
      idr: "idris",
      gitignore: "ignore",
      hgignore: "ignore",
      npmignore: "ignore",
      webmanifest: "json",
      kt: "kotlin",
      kts: "kotlin",
      kum: "kumir",
      tex: "latex",
      context: "latex",
      ly: "lilypond",
      emacs: "lisp",
      elisp: "lisp",
      "emacs-lisp": "lisp",
      md: "markdown",
      moon: "moonscript",
      n4jsd: "n4js",
      nani: "naniscript",
      objc: "objectivec",
      qasm: "openqasm",
      objectpascal: "pascal",
      px: "pcaxis",
      pcode: "peoplecode",
      plantuml: "plant-uml",
      pq: "powerquery",
      mscript: "powerquery",
      pbfasm: "purebasic",
      purs: "purescript",
      py: "python",
      qs: "qsharp",
      rkt: "racket",
      razor: "cshtml",
      rpy: "renpy",
      res: "rescript",
      robot: "robotframework",
      rb: "ruby",
      "sh-session": "shell-session",
      shellsession: "shell-session",
      smlnj: "sml",
      sol: "solidity",
      sln: "solution-file",
      rq: "sparql",
      sclang: "supercollider",
      t4: "t4-cs",
      trickle: "tremor",
      troy: "tremor",
      trig: "turtle",
      ts: "typescript",
      tsconfig: "typoscript",
      uscript: "unrealscript",
      uc: "unrealscript",
      url: "uri",
      vb: "visual-basic",
      vba: "visual-basic",
      webidl: "web-idl",
      mathematica: "wolfram",
      nb: "wolfram",
      wl: "wolfram",
      xeoracube: "xeora",
      yml: "yaml"
    }
  ), e = {}, s = "none", u = "components/", f = Prism.util.currentScript();
  if (f) {
    var a = /\bplugins\/autoloader\/prism-autoloader\.(?:min\.)?js(?:\?[^\r\n/]*)?$/i, d = /(^|\/)[\w-]+\.(?:min\.)?js(?:\?[^\r\n/]*)?$/i, n = f.getAttribute("data-autoloader-path");
    if (n != null)
      u = n.trim().replace(/\/?$/, "/");
    else {
      var c = f.src;
      a.test(c) ? u = c.replace(a, "components/") : d.test(c) && (u = c.replace(d, "$1components/"));
    }
  }
  var h = Prism.plugins.autoloader = {
    languages_path: u,
    use_minified: !0,
    loadLanguages: y
  };
  function i(o, p, v) {
    var m = document.createElement("script");
    m.src = o, m.async = !0, m.onload = function() {
      document.body.removeChild(m), p && p();
    }, m.onerror = function() {
      document.body.removeChild(m), v && v();
    }, document.body.appendChild(m);
  }
  function b(o) {
    var p = (o.getAttribute("data-dependencies") || "").trim();
    if (!p) {
      var v = o.parentElement;
      v && v.tagName.toLowerCase() === "pre" && (p = (v.getAttribute("data-dependencies") || "").trim());
    }
    return p ? p.split(/\s*,\s*/g) : [];
  }
  function l(o) {
    if (o.indexOf("!") >= 0)
      return !1;
    if (o = t[o] || o, o in Prism.languages)
      return !0;
    var p = e[o];
    return p && !p.error && p.loading === !1;
  }
  function _(o) {
    return h.languages_path + "prism-" + o + (h.use_minified ? ".min" : "") + ".js";
  }
  function y(o, p, v) {
    typeof o == "string" && (o = [o]);
    var m = o.length, L = 0, x = !1;
    if (m === 0) {
      p && setTimeout(p, 0);
      return;
    }
    function S() {
      x || (L++, L === m && p && p(o));
    }
    o.forEach(function(G) {
      Q(G, S, function() {
        x || (x = !0, v && v(G));
      });
    });
  }
  function Q(o, p, v) {
    var m = o.indexOf("!") >= 0;
    o = o.replace("!", ""), o = t[o] || o;
    function L() {
      var S = e[o];
      S || (S = e[o] = {
        callbacks: []
      }), S.callbacks.push({
        success: p,
        error: v
      }), !m && l(o) ? j(o, "success") : !m && S.error ? j(o, "error") : (m || !S.loading) && (S.loading = !0, S.error = !1, i(_(o), function() {
        S.loading = !1, j(o, "success");
      }, function() {
        S.loading = !1, S.error = !0, j(o, "error");
      }));
    }
    var x = r[o];
    x && x.length ? y(x, L, v) : L();
  }
  function j(o, p) {
    if (e[o]) {
      for (var v = e[o].callbacks, m = 0, L = v.length; m < L; m++) {
        var x = v[m][p];
        x && setTimeout(x, 0);
      }
      v.length = 0;
    }
  }
  Prism.hooks.add("complete", function(o) {
    var p = o.element, v = o.language;
    if (!(!p || !v || v === s)) {
      var m = b(p);
      /^diff-./i.test(v) ? (m.push("diff"), m.push(v.substr(5))) : m.push(v), m.every(l) || y(m, function() {
        Prism.highlightElement(p);
      });
    }
  });
})();
(function() {
  if (typeof Prism > "u" || typeof document > "u")
    return;
  var r = "line-numbers", t = /\n(?!$)/g, e = Prism.plugins.lineNumbers = {
    /**
     * Get node for provided line number
     *
     * @param {Element} element pre element
     * @param {number} number line number
     * @returns {Element|undefined}
     */
    getLine: function(a, d) {
      if (!(a.tagName !== "PRE" || !a.classList.contains(r))) {
        var n = a.querySelector(".line-numbers-rows");
        if (n) {
          var c = parseInt(a.getAttribute("data-start"), 10) || 1, h = c + (n.children.length - 1);
          d < c && (d = c), d > h && (d = h);
          var i = d - c;
          return n.children[i];
        }
      }
    },
    /**
     * Resizes the line numbers of the given element.
     *
     * This function will not add line numbers. It will only resize existing ones.
     *
     * @param {HTMLElement} element A `<pre>` element with line numbers.
     * @returns {void}
     */
    resize: function(a) {
      s([a]);
    },
    /**
     * Whether the plugin can assume that the units font sizes and margins are not depended on the size of
     * the current viewport.
     *
     * Setting this to `true` will allow the plugin to do certain optimizations for better performance.
     *
     * Set this to `false` if you use any of the following CSS units: `vh`, `vw`, `vmin`, `vmax`.
     *
     * @type {boolean}
     */
    assumeViewportIndependence: !0
  };
  function s(a) {
    if (a = a.filter(function(n) {
      var c = u(n), h = c["white-space"];
      return h === "pre-wrap" || h === "pre-line";
    }), a.length != 0) {
      var d = a.map(function(n) {
        var c = n.querySelector("code"), h = n.querySelector(".line-numbers-rows");
        if (!(!c || !h)) {
          var i = n.querySelector(".line-numbers-sizer"), b = c.textContent.split(t);
          i || (i = document.createElement("span"), i.className = "line-numbers-sizer", c.appendChild(i)), i.innerHTML = "0", i.style.display = "block";
          var l = i.getBoundingClientRect().height;
          return i.innerHTML = "", {
            element: n,
            lines: b,
            lineHeights: [],
            oneLinerHeight: l,
            sizer: i
          };
        }
      }).filter(Boolean);
      d.forEach(function(n) {
        var c = n.sizer, h = n.lines, i = n.lineHeights, b = n.oneLinerHeight;
        i[h.length - 1] = void 0, h.forEach(function(l, _) {
          if (l && l.length > 1) {
            var y = c.appendChild(document.createElement("span"));
            y.style.display = "block", y.textContent = l;
          } else
            i[_] = b;
        });
      }), d.forEach(function(n) {
        for (var c = n.sizer, h = n.lineHeights, i = 0, b = 0; b < h.length; b++)
          h[b] === void 0 && (h[b] = c.children[i++].getBoundingClientRect().height);
      }), d.forEach(function(n) {
        var c = n.sizer, h = n.element.querySelector(".line-numbers-rows");
        c.style.display = "none", c.innerHTML = "", n.lineHeights.forEach(function(i, b) {
          h.children[b].style.height = i + "px";
        });
      });
    }
  }
  function u(a) {
    return a ? window.getComputedStyle ? getComputedStyle(a) : a.currentStyle || null : null;
  }
  var f = void 0;
  window.addEventListener("resize", function() {
    e.assumeViewportIndependence && f === window.innerWidth || (f = window.innerWidth, s(Array.prototype.slice.call(document.querySelectorAll("pre." + r))));
  }), Prism.hooks.add("complete", function(a) {
    if (a.code) {
      var d = (
        /** @type {Element} */
        a.element
      ), n = (
        /** @type {HTMLElement} */
        d.parentNode
      );
      if (!(!n || !/pre/i.test(n.nodeName)) && !d.querySelector(".line-numbers-rows") && Prism.util.isActive(d, r)) {
        d.classList.remove(r), n.classList.add(r);
        var c = a.code.match(t), h = c ? c.length + 1 : 1, i, b = new Array(h + 1).join("<span></span>");
        i = document.createElement("span"), i.setAttribute("aria-hidden", "true"), i.className = "line-numbers-rows", i.innerHTML = b, n.hasAttribute("data-start") && (n.style.counterReset = "linenumber " + (parseInt(n.getAttribute("data-start"), 10) - 1)), a.element.appendChild(i), s([n]), Prism.hooks.run("line-numbers", a);
      }
    }
  }), Prism.hooks.add("line-numbers", function(a) {
    a.plugins = a.plugins || {}, a.plugins.lineNumbers = !0;
  });
})();
const ft = /* @__PURE__ */ I({
  __name: "ScalarCodeBlock",
  props: {
    content: {},
    lang: { default: "js" },
    lineNumbers: { type: Boolean, default: !1 },
    hideCredentials: {}
  },
  setup(r) {
    const t = r, { plugins: e, highlightElement: s } = q;
    t.hideCredentials && q.hooks.add("wrap", function(a) {
      if (!t.hideCredentials)
        return;
      let d = !1;
      typeof t.hideCredentials == "string" ? a.content.includes(t.hideCredentials) && (d = !0) : Array.isArray(t.hideCredentials) && (d = t.hideCredentials.some(
        (n) => a.content.includes(n)
      )), d && (a.content = a.content.replace(
        /<span class="credentials">.*?<\/span>/g,
        (n) => n.replace(/<span class="credentials">|<\/span>/g, "")
      ), a.content = a.content.replace(
        new RegExp(
          typeof t.hideCredentials == "string" ? t.hideCredentials : t.hideCredentials.join("|"),
          "g"
        ),
        (n) => `<span class="credentials">${n}</span>`
      ));
    });
    const u = z(null), f = H(() => t.lang === "node" ? "js" : t.lang);
    return e.autoloader.languages_path = "https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/", re(
      () => [t.lang, t.content],
      () => {
        u.value && ae(() => s(u.value));
      }
    ), W(() => {
      u.value && s(u.value);
    }), (a, d) => (w(), C("pre", {
      class: k(["scalar-component scalar-codeblock-pre", {
        "line-numbers": a.lineNumbers
      }])
    }, [
      A("code", {
        ref_key: "el",
        ref: u,
        class: k(`scalar-codeblock-code lang-${f.value}`)
      }, M(a.content), 3)
    ], 2));
  }
}), Ee = (r) => Object.fromEntries(Array.from(r).map((t) => [t.name, t.value])), Le = (r) => ({ raw: t }) => {
  const s = new r().parseFromString(t, "image/svg+xml");
  if (s.getElementsByTagName("parsererror").length)
    return;
  const u = s.documentElement, f = Ee(u.attributes), { width: a, height: d, ...n } = f;
  return oe("svg", { ...n, innerHTML: u.innerHTML });
}, Ae = ne(async () => {
  const r = typeof DOMParser > "u" ? (await import("@xmldom/xmldom")).DOMParser : DOMParser, t = Le(r);
  return t.props = {
    raw: {
      type: String,
      required: !0
    }
  }, t;
}), Te = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48">
    <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3.429"
        d="M24 1.714v44.572M1.714 24h44.572" />
</svg>`, Ie = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32.5 23.5" fill="currentColor">
    <path d="M11.2 23.5 0 12.3l2.15-2.15 9.05 9.05L30.4 0l2.15 2.15z" />
</svg>`, Me = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 8.25L12 15.75L19.5 8.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
`, Ne = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.75 19.5L8.25 12L15.75 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
`, je = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.25 19.5L15.75 12L8.25 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`, Oe = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.5 15.75L12 8.25L4.5 15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
`, Be = `<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 16">
    <path d="M6,5h4c1.7,0,2-1.3,2-3c1.1,0,2,0.9,2,2v10c0,1.1-0.9,2-2,2H4c-1.1,0-2-0.9-2-2V4c0-1.1,0.9-2,2-2C4,3.7,4.3,5,6,5z M6,2V1
	c0-0.6,0.5-1,1-1h2c0.5,0,1,0.4,1,1v1.3C10,2.9,9.6,3,9,3H7C6.4,3,6,2.6,6,2z" />
</svg>`, De = `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
    <path stroke="currentColor" d="m12.5 1.5-11 11m0-11 11 11" />
</svg>`, Pe = `<svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg">
    <path
        d="M9.557,7.243A.456.456,0,0,0,9.1,6.991C9.023,7,8.951,7,8.877,7A4,4,0,0,1,5.546.781.5.5,0,0,0,5.564.256.476.476,0,0,0,5.1,0,5,5,0,1,0,9.539,7.767.5.5,0,0,0,9.557,7.243Z"
        fill="currentColor" stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
</svg>`, ze = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
    <path
        d="M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z" />
</svg>`, Re = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 9 9">
    <g fill="none" fill-rule="evenodd" transform="translate(.67 .67)">
        <rect transform="rotate(180 4 4)" />
        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width=".5"
            d="M2.85 1.73h3.4v3.4m0-3.4L1.74 6.24" />
    </g>
</svg>`, He = `<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 1024 1024">
    <path
        d="M512 0a512 512 0 0 0-162 998c26 4 35-11 35-25l-1-95c-128 23-161-32-172-60-6-15-31-61-52-73-18-10-44-33-1-33 40-1 69 37 78 52 46 78 120 56 149 43 5-33 18-56 33-69-114-13-234-56-234-253 0-56 20-101 53-137-5-13-23-65 5-136 0 0 43-13 141 53a487 487 0 0 1 256 0c98-66 141-53 141-53 28 71 10 123 5 136 33 36 53 81 53 137 0 197-120 240-234 253 18 16 35 47 35 95l-1 140c0 14 9 30 35 25A512 512 0 0 0 512 0z" />
</svg>`, $e = `<svg
  height="24"
  viewBox="0 0 24 24"
  width="24"
  xmlns="http://www.w3.org/2000/svg">
  <path
    d="M24 12a1 1 0 0 0 -1 -1h-3.91a0.51 0.51 0 0 1 -0.49 -0.4 6.83 6.83 0 0 0 -0.94 -2.28 0.5 0.5 0 0 1 0.06 -0.63l2.77 -2.76a1 1 0 1 0 -1.42 -1.42l-2.76 2.77a0.5 0.5 0 0 1 -0.63 0.06 6.83 6.83 0 0 0 -2.28 -0.94 0.5 0.5 0 0 1 -0.4 -0.49V1a1 1 0 0 0 -2 0v3.91a0.51 0.51 0 0 1 -0.4 0.49 6.83 6.83 0 0 0 -2.28 0.94 0.5 0.5 0 0 1 -0.63 -0.06L4.93 3.51a1 1 0 0 0 -1.42 1.42l2.77 2.76a0.5 0.5 0 0 1 0.06 0.63 6.83 6.83 0 0 0 -0.94 2.28 0.5 0.5 0 0 1 -0.49 0.4H1a1 1 0 0 0 0 2h3.91a0.51 0.51 0 0 1 0.49 0.4 6.83 6.83 0 0 0 0.94 2.28 0.5 0.5 0 0 1 -0.06 0.63l-2.77 2.76a1 1 0 1 0 1.42 1.42l2.76 -2.77a0.5 0.5 0 0 1 0.63 -0.06 6.83 6.83 0 0 0 2.28 0.94 0.5 0.5 0 0 1 0.4 0.49V23a1 1 0 0 0 2 0v-3.91a0.51 0.51 0 0 1 0.4 -0.49 6.83 6.83 0 0 0 2.28 -0.94 0.5 0.5 0 0 1 0.63 0.06l2.76 2.77a1 1 0 1 0 1.42 -1.42l-2.77 -2.76a0.5 0.5 0 0 1 -0.06 -0.63 6.83 6.83 0 0 0 0.94 -2.28 0.5 0.5 0 0 1 0.49 -0.4H23a1 1 0 0 0 1 -1Zm-8.74 2.5A5.76 5.76 0 0 1 9.5 8.74a5.66 5.66 0 0 1 0.16 -1.31 0.49 0.49 0 0 1 0.34 -0.36 5.36 5.36 0 0 1 1.8 -0.31 5.47 5.47 0 0 1 5.46 5.46 5.36 5.36 0 0 1 -0.31 1.8 0.49 0.49 0 0 1 -0.35 0.32 5.53 5.53 0 0 1 -1.34 0.16Z"
    fill="currentColor"
    stroke-width="1"></path>
</svg>`, Ge = `<svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg">
    <path d="M3.500 5.000 A1.500 1.500 0 1 0 6.500 5.000 A1.500 1.500 0 1 0 3.500 5.000 Z" fill="currentColor"
        stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path d="M5,2.25a.625.625,0,0,1-.625-.625v-1a.625.625,0,0,1,1.25,0v1A.625.625,0,0,1,5,2.25Z" fill="currentColor"
        stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path d="M6.945,3.055a.623.623,0,0,1,0-.883l.707-.708a.625.625,0,0,1,.884.884l-.708.707A.623.623,0,0,1,6.945,3.055Z"
        fill="currentColor" stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path d="M7.75,5a.625.625,0,0,1,.625-.625h1a.625.625,0,0,1,0,1.25h-1A.625.625,0,0,1,7.75,5Z" fill="currentColor"
        stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path d="M6.945,6.945a.623.623,0,0,1,.883,0l.708.707a.625.625,0,0,1-.884.884l-.707-.708A.623.623,0,0,1,6.945,6.945Z"
        fill="currentColor" stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path d="M5,7.75a.625.625,0,0,1,.625.625v1a.625.625,0,0,1-1.25,0v-1A.625.625,0,0,1,5,7.75Z" fill="currentColor"
        stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path
        d="M3.055,6.945a.623.623,0,0,1,0,.883l-.707.708a.625.625,0,0,1-.884-.884l.708-.707A.623.623,0,0,1,3.055,6.945Z"
        fill="currentColor" stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path d="M2.25,5a.625.625,0,0,1-.625.625h-1a.625.625,0,0,1,0-1.25h1A.625.625,0,0,1,2.25,5Z" fill="currentColor"
        stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
    <path
        d="M3.055,3.055a.623.623,0,0,1-.883,0l-.708-.707a.625.625,0,0,1,.884-.884l.707.708A.623.623,0,0,1,3.055,3.055Z"
        fill="currentColor" stroke="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="0"></path>
</svg>`, qe = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 593 593">
    <path fill="currentColor" fill-rule="evenodd"
        d="M347 0c6 0 12 5 12 12v134l94-95c5-5 13-5 17 0l72 72c4 4 5 12 0 16v1l-95 94h134c7 0 12 5 12 12v101c0 7-5 12-12 12H447l95 94c4 5 5 13 0 17l-72 72c-4 4-12 5-16 0h-1l-94-95v134c0 7-5 12-12 12H246c-7 0-12-5-12-12v-70c0-22 9-43 24-59l130-130c14-14 14-37 0-51L259 142a84 84 0 0 1-25-59V12c0-7 5-12 12-12h101ZM138 52h1l219 219c14 14 14 37 0 51L139 542c-4 5-12 5-17 0l-71-70c-4-5-5-12 0-17l95-96H12c-7 0-12-5-12-12V246c0-7 5-12 12-12h134l-95-94c-4-5-4-12 0-17l71-71c4-5 12-5 16 0Z" />
</svg>`, Ve = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 662 662">
    <path fill-rule="evenodd" fill="currentColor"
        d="M331 0a331 331 0 1 1 0 662 331 331 0 0 1 0-662Zm148.5 109 .6.9a187 187 0 1 1-297.6-.9 267 267 0 1 0 297 0Z" />
</svg>`, Fe = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 620 620">
    <path fill="currentColor"
        d="M-.653 309.29c-.078 82.272 31.848 159.735 89.739 218.178l.283.283c122.379 121.247 319.824 121.184 440.16-.283 119.967-121.1 119.409-316.933-.998-437.339l-.99-.99C468.681 30.845 390.716-1.017 307.893-.67c-82.83.354-160.443 32.994-218.814 91.79C31.209 149.555-.724 227.025-.653 309.29Zm469.271-160.789.778.778c87.9 87.9 88.325 231.005.707 319.33-77.753 78.46-199.786 87.412-288.959 26.862l198.513-198.513-.007 166.361 83.68-.07v-306.22H157.11l-.008 83.6h160.584L121.994 436.323c-59.347-87.689-50.536-208.59 26.51-286.343C236.34 61.294 379.94 60.67 468.61 148.494Z" />
</svg>`, Ue = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 642 642" fill="currentColor">
    <path
        d="M321 0a321 321 0 1 1 0 642 321 321 0 0 1 0-642Zm51.3 63L321 189.5 269.7 63l1 136.5-95.8-97.2L228 228l-125.7-53.1 97.2 95.8-136.5-1L189.5 321 63 372.3l136.5-1-97.2 95.8 125.7-53-53.1 125.6 95.8-97.2-1 136.5L321 452.5 372.3 579l-1-136.5 95.8 97.2-53-125.7 125.6 53.1-97.2-95.8 136.5 1L452.5 321 579 269.7l-136.5 1 97.2-95.8L414 228l53.1-125.7-95.8 97.2 1-136.5Z" />
</svg>`, Ze = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 620 620" fill="currentColor">
    <path
        d="M529.2 90.8A310 310 0 1 0 90.8 529.2 310 310 0 0 0 529.2 90.8M122.4 498.2c-54.9-55-15.4-183.5 88.2-287 103.6-103.7 232.1-143.2 287-88.3 54.9 54.8 15.4 183.4-88.3 287-103.5 103.6-232 143.1-286.9 88.3m261.8-262.7A104.7 104.7 0 1 1 236 383.7a104.7 104.7 0 0 1 148.2-148.2" />
</svg>`, We = `<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" viewBox="0 0 14 14">
    <path fill="none" stroke="currentColor" d="M14 3.4H0m14 7.2H0" />
</svg>`, Xe = `<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
    <path fill="currentColor" fill-rule="evenodd"
        d="M11.8214 0.0977942C12.1097 -0.00745677 12.4219 -0.0286524 12.7219 0.0367783C13.0248 0.102864 13.3024 0.254542 13.5216 0.47378C13.7408 0.693018 13.8925 0.970598 13.9586 1.27352C14.024 1.57344 14.0028 1.88572 13.8976 2.17395L10.3236 12.8859L10.3234 12.8866C10.2363 13.1501 10.083 13.3868 9.8781 13.574C9.6738 13.7606 9.42509 13.8918 9.15572 13.9549C8.8863 14.0206 8.60441 14.0151 8.33774 13.9389C8.07131 13.8628 7.82926 13.7187 7.63529 13.5209L5.71795 11.6124L3.70389 12.6538C3.54684 12.7351 3.35857 12.7273 3.20874 12.6334C3.05892 12.5395 2.96981 12.3735 2.9744 12.1967L3.05697 9.013L10.1019 3.8956C10.3812 3.69273 10.4432 3.30188 10.2403 3.02261C10.0374 2.74333 9.64659 2.68139 9.36731 2.88425L2.20283 8.08846L0.473125 6.35875L0.473067 6.3587L0.472941 6.35857C0.285618 6.17138 0.147716 5.9406 0.0716193 5.68694C-0.00393616 5.43509 -0.0162115 5.16853 0.0358379 4.91085C0.0879545 4.62934 0.213796 4.36664 0.400577 4.14957C0.588637 3.93101 0.83165 3.76664 1.1045 3.67345L1.10787 3.6723L1.10787 3.67231L11.8214 0.0977942Z"
        clip-rule="evenodd"></path>
</svg>`, Ke = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor">
    <path fill-rule="evenodd"
        d="M12.6 11.2h.1l3 3a1 1 0 1 1-1.4 1.5l-3-3a1 1 0 0 1-.1-.1 7 7 0 1 1 1.4-1.4zM7 12A5 5 0 1 0 7 2a5 5 0 0 0 0 10z" />
</svg>`, V = /* @__PURE__ */ Object.assign({ "./Add.svg": Te, "./CheckMark.svg": Ie, "./ChevronDown.svg": Me, "./ChevronLeft.svg": Ne, "./ChevronRight.svg": je, "./ChevronUp.svg": Oe, "./Clipboard.svg": Be, "./Close.svg": De, "./DarkMode.svg": Pe, "./Ellipses.svg": ze, "./ExternalLink.svg": Re, "./GitHub.svg": He, "./LightDarkModeToggle.svg": $e, "./LightMode.svg": Ge, "./Logo.svg": qe, "./LogoAPI.svg": Ve, "./LogoClient.svg": Fe, "./LogoMarket.svg": Ue, "./LogoSwagger.svg": Ze, "./Menu.svg": We, "./PaperAirplane.svg": Xe, "./Search.svg": Ke }), Ye = (r) => {
  const t = `./${r}.svg`;
  return V[t] === void 0 ? (console.warn(`Could not find icon: ${r}`), "") : V[t];
}, J = /* @__PURE__ */ I({
  __name: "ScalarIcon",
  props: {
    icon: {},
    size: {}
  },
  setup(r) {
    const t = r, e = N({
      variants: {
        size: {
          xs: "h-3 w-3",
          sm: "h-3.5 w-3.5",
          md: "h-4 w-4",
          lg: "h-5 w-5",
          xl: "h-6 w-6",
          full: "h-full w-full"
        }
      },
      defaultVariants: {
        size: "full"
      }
    }), s = H(() => Ye(t.icon));
    return (u, f) => s.value ? (w(), P(g(Ae), {
      key: 0,
      class: k(g(E)("scalar-icon", g(e)({ size: u.size }))),
      raw: s.value
    }, null, 8, ["class", "raw"])) : T("", !0);
  }
}), Je = ["ariaDisabled"], Qe = { class: "sr-only" }, et = /* @__PURE__ */ I({
  __name: "ScalarIconButton",
  props: {
    label: {},
    icon: {},
    disabled: { type: Boolean },
    variant: { default: "ghost" },
    size: { default: "md" }
  },
  setup(r) {
    const t = N({
      base: "scalar-icon-button grid aspect-square cursor-pointer rounded",
      variants: {
        size: {
          xs: "h-3.5 w-3.5 p-0.5",
          sm: "h-5 w-5 p-1",
          md: "h-10 w-10 p-3",
          full: "h-full w-full"
        },
        disabled: {
          true: "cursor-not-allowed shadow-none"
        },
        variant: Y
      }
    });
    return (e, s) => (w(), C("button", {
      ariaDisabled: e.disabled || void 0,
      class: k(g(E)(g(t)({ size: e.size, variant: e.variant, disabled: e.disabled }))),
      type: "button"
    }, [
      D(g(J), { icon: e.icon }, null, 8, ["icon"]),
      A("span", Qe, M(e.label), 1)
    ], 10, Je));
  }
}), bt = () => F({
  open: !1,
  show() {
    this.open = !0;
  },
  hide() {
    this.open = !1;
  }
}), tt = /* @__PURE__ */ I({
  __name: "ScalarModal",
  props: {
    state: {},
    title: {},
    bodyClass: {},
    maxWidth: {},
    size: { default: "md" },
    variant: {}
  },
  setup(r) {
    const t = N({
      base: [
        "scalar-modal",
        "col leading-snug relative mx-auto mb-0 mt-20 w-full rounded-lg bg-back-2 text-left text-fore-1 opacity-0"
      ].join(" "),
      variants: {
        size: {
          xs: "max-w-screen-xs",
          sm: "max-w-screen-sm",
          md: "max-w-screen-md",
          lg: "max-w-screen-lg"
        },
        variant: {
          history: "scalar-modal-history bg-back-1",
          search: "scalar-modal-search"
        }
      }
    });
    return (e, s) => (w(), P(g(ue), {
      open: e.state.open,
      onClose: s[0] || (s[0] = (u) => e.state.hide())
    }, {
      default: O(() => [
        A("div", {
          class: k(
            g(E)(
              "scalar-modal-layout fixed left-0 top-0",
              "z-[1001] h-[100dvh] w-[100dvw]",
              "bg-backdrop p-5 opacity-0"
            )
          )
        }, [
          D(g(pe), {
            class: k(g(t)({ size: e.size, variant: e.variant })),
            style: X({ maxWidth: e.maxWidth })
          }, {
            default: O(() => [
              e.title ? (w(), P(g(me), {
                key: 0,
                class: k(["scalar-modal-header font-semiBold m-0 rounded-lg px-6 py-3 text-left text-xs text-fore-1", { "pb-0 pt-6": e.variant === "history" }])
              }, {
                default: O(() => [
                  se(M(e.title), 1)
                ]),
                _: 1
              }, 8, ["class"])) : T("", !0),
              D(g(he), {
                class: k([
                  "scalar-modal-body relative max-h-[calc(100dvh-240px)] overflow-y-auto rounded-lg bg-back-1 px-6 pb-4 pt-6",
                  g(E)(
                    e.bodyClass,
                    e.variant === "history" && "pt-3",
                    e.variant === "search" && "col max-h-[440px] overflow-hidden p-0"
                  )
                ])
              }, {
                default: O(() => [
                  B(e.$slots, "default", {}, void 0, !0)
                ]),
                _: 3
              }, 8, ["class"])
            ]),
            _: 3
          }, 8, ["class", "style"])
        ], 2)
      ]),
      _: 3
    }, 8, ["open"]));
  }
}), rt = /* @__PURE__ */ $(tt, [["__scopeId", "data-v-4f0b1a0d"]]), at = { class: "scalar-input-container relative" }, nt = ["for"], ot = { class: "icon-slot cursor-pointer text-ghost hover:text-fore-1 !empty:flex !empty:w-7 !empty:items-center !empty:pr-3" }, st = /* @__PURE__ */ I({
  __name: "ScalarTextField",
  props: {
    modelValue: {},
    placeholder: {},
    label: {},
    labelShadowColor: { default: "var(--theme-background-2, var(--default-theme-background-2))" },
    error: { type: Boolean },
    isMultiline: { type: Boolean },
    helperText: {},
    emitOnBlur: { type: Boolean, default: !0 },
    handleFieldSubmit: {},
    handleFieldChange: {},
    disableTrim: { type: Boolean, default: !1 }
  },
  emits: ["submit", "update:modelValue"],
  setup(r, { emit: t }) {
    const e = r, s = t, u = N({
      base: "scalar-input-wrapper relative flex items-center rounded border border-solid border-border",
      variants: {
        focus: {
          true: "scalar-input-wrapper-focus border-fore-3 has-actv-btn:border has-actv-btn:border-border"
        },
        error: { true: "scalar-input-wrapper-error border-error" }
      }
    }), f = U(), a = f.id || `id-${ve()}`, d = z(), n = z(!1);
    let c;
    if (e.isMultiline) {
      const { triggerResize: l } = ge({
        element: d,
        input: e.modelValue
      });
      c = l;
    }
    function h(l) {
      const _ = l.target.value;
      e.isMultiline && c(), e.handleFieldChange ? e.handleFieldChange(_) : s("update:modelValue", _);
    }
    function i(l) {
      const _ = l.target, y = e.disableTrim || e.isMultiline ? _.value : _.value.trim();
      e.handleFieldSubmit ? e.handleFieldSubmit(y) : s("submit", y);
    }
    function b(l) {
      n.value = !1, e.emitOnBlur && e.modelValue && i(l);
    }
    return W(() => {
      var l;
      Object.prototype.hasOwnProperty.call(f, "autofocus") && ((l = d.value) == null || l.focus());
    }), (l, _) => (w(), C("div", at, [
      A("div", {
        class: k(g(u)({ error: l.error, focus: n.value }))
      }, [
        (w(), P(le(l.isMultiline ? "textarea" : "input"), Z({ id: g(a) }, l.$attrs, {
          ref_key: "input",
          ref: d,
          class: [
            "scalar-input",
            g(E)(
              { "min-h-[77px]": l.isMultiline },
              "z-10 w-full resize-none appearance-none border-0 bg-transparent p-3 text-sm text-fore-1",
              "outline-none transition-opacity"
            )
          ],
          placeholder: l.placeholder,
          value: l.modelValue,
          onBlur: b,
          onFocus: _[0] || (_[0] = (y) => n.value = !0),
          onInput: h,
          onKeyup: ie(i, ["enter"])
        }), null, 16, ["id", "class", "placeholder", "value"])),
        l.label ? (w(), C("label", {
          key: 0,
          class: k(
            g(E)(
              "scalar-input-label pointer-events-none absolute left-0 top-0 mx-2 my-3 px-1 text-xs",
              "shadow-current z-10 origin-top-left rounded text-fore-3 transition-transform"
            )
          ),
          for: g(a),
          style: X({
            "box-shadow": `0 0 4px 4px ${l.labelShadowColor}`,
            "background-color": l.labelShadowColor
          })
        }, M(l.label), 15, nt)) : T("", !0),
        A("div", ot, [
          B(l.$slots, "default", {}, void 0, !0)
        ])
      ], 2),
      A("span", {
        class: k(
          g(E)(
            "helper-text before:rounded-full mt-1.5 flex items-center text-xs text-error before:font-black",
            "before:mr-1.5 before:block before:h-4 before:w-4 before:text-center before:text-xxs before:leading-4",
            "before:bg-error before:text-white before:content-['!'] empty:hidden"
          )
        )
      }, M(l.helperText), 3)
    ]));
  }
}), lt = /* @__PURE__ */ $(st, [["__scopeId", "data-v-acbd8aa4"]]), kt = {
  boxShadow: {
    DEFAULT: "var(--theme-shadow-1, var(--default-theme-shadow-1))",
    md: "var(--theme-shadow-2, var(--default-theme-shadow-2))",
    sm: "rgba(0, 0, 0, 0.09) 0px 1px 4px",
    none: "0 0 #0000"
  },
  colors: {
    "fore-1": "var(--theme-color-1, var(--default-theme-color-1))",
    "fore-2": "var(--theme-color-2, var(--default-theme-color-2))",
    "fore-3": "var(--theme-color-3, var(--default-theme-color-3))",
    accent: "var(--theme-color-accent, var(--default-theme-color-accent))",
    "back-1": "var(--theme-background-1, var(--default-theme-background-1))",
    "back-2": "var(--theme-background-2, var(--default-theme-background-2))",
    "back-3": "var(--theme-background-3, var(--default-theme-background-3))",
    "back-accent": "var(--theme-background-accent, var(--default-theme-background-accent))",
    backdrop: "rgba(0, 0, 0, 0.44)",
    border: "var(--theme-border-color, var(--default-theme-border-color))",
    "back-btn-1": "var(--theme-button-1, var(--default-theme-button-1))",
    "fore-btn-1": "var(--theme-button-1-color, var(--default-theme-button-1-color))",
    "hover-btn-1": "var(--theme-button-1-hover, var(--default-theme-button-1-hover))",
    white: "#FFF",
    green: "var(--theme-color-green, var(--default-theme-color-green))",
    red: "var(--theme-color-red, var(--default-theme-color-red))",
    yellow: "var(--theme-color-yellow, var(--default-theme-color-yellow))",
    blue: "var(--theme-color-blue, var(--default-theme-color-blue))",
    orange: "var(--theme-color-orange, var(--default-theme-color-orange))",
    purple: "var(--theme-color-purple, var(--default-theme-color-purple))",
    error: "var(--theme-error-color, var(--default-theme-color-red))",
    ghost: "var(--theme-color-ghost, var(--default-theme-color-ghost))",
    transparent: "transparent"
  }
}, wt = {
  borderRadius: {
    DEFAULT: "var(--theme-radius, var(--default-theme-radius))",
    md: "var(--theme-radius, var(--default-theme-radius))",
    lg: "var(--theme-radius-lg, var(--default-theme-radius-lg))",
    xl: "var(--theme-radius-xl, var(--default-theme-radius-xl))"
  },
  fontSize: {
    xxs: "var(--theme-micro, var(--default-theme-micro, var(--theme-font-size-5, var(--default-theme-font-size-5))))",
    xs: "var(--theme-mini, var(--default-theme-mini, var(--theme-font-size-4, var(--default-theme-font-size-4))))",
    sm: "var(--theme-small, var(--default-theme-small, var(--theme-font-size-3, var(--default-theme-font-size-3))))",
    base: "var(--theme-paragraph, var(--default-theme-paragraph, var(--theme-font-size-2, var(--default-theme-font-size-2))))",
    lg: "var(--theme-font-size-1, var(--default-theme-font-size-1))"
  },
  fontWeight: {
    medium: "var(--theme-font-medium, var(--default-theme-font-medium))",
    bold: "var(--theme-font-bold, var(--default-theme-font-bold))"
  },
  maxWidth: {
    "screen-xs": "480px",
    "screen-sm": "540px",
    "screen-md": "640px",
    "screen-lg": "800px"
  }
}, _t = {
  install: (r) => {
    r.component("ScalarButton", Ce), r.component("ScalarIcon", J), r.component("ScalarIconButton", et), r.component("ScalarLoading", K), r.component("ScalarModal", rt), r.component("ScalarTextField", lt);
  }
};
export {
  Ce as ScalarButton,
  ft as ScalarCodeBlock,
  J as ScalarIcon,
  et as ScalarIconButton,
  K as ScalarLoading,
  rt as ScalarModal,
  lt as ScalarTextField,
  _t as default,
  wt as extend,
  kt as theme,
  vt as useLoadingState,
  bt as useModal
};
