import type { App } from 'vue';
import { ComponentOptionsMixin } from 'vue';
import { DefineComponent } from 'vue';
import { ExtractPropTypes } from 'vue';
import { PropType } from 'vue';
import { PublicProps } from 'vue';
import { VariantProps } from 'cva';

declare type __VLS_NonUndefinedable<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_2<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_3<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_4<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_5<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_6<T> = T extends undefined ? never : T;

declare type __VLS_NonUndefinedable_7<T> = T extends undefined ? never : T;

declare type __VLS_Prettify<T> = {
    [K in keyof T]: T[K];
} & {};

declare type __VLS_Prettify_2<T> = {
    [K in keyof T]: T[K];
} & {};

declare type __VLS_Prettify_3<T> = {
    [K in keyof T]: T[K];
} & {};

declare type __VLS_Prettify_4<T> = {
    [K in keyof T]: T[K];
} & {};

declare type __VLS_Prettify_5<T> = {
    [K in keyof T]: T[K];
} & {};

declare type __VLS_Prettify_6<T> = {
    [K in keyof T]: T[K];
} & {};

declare type __VLS_TypePropsToRuntimeProps<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_2<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_2<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_3<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_3<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_4<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_4<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_5<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_5<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_6<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_6<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_TypePropsToRuntimeProps_7<T> = {
    [K in keyof T]-?: {} extends Pick<T, K> ? {
        type: PropType<__VLS_NonUndefinedable_7<T[K]>>;
    } : {
        type: PropType<T[K]>;
        required: true;
    };
};

declare type __VLS_WithDefaults<P, D> = {
    [K in keyof Pick<P, keyof P>]: K extends keyof D ? __VLS_Prettify<P[K] & {
        default: D[K];
    }> : P[K];
};

declare type __VLS_WithDefaults_2<P, D> = {
    [K in keyof Pick<P, keyof P>]: K extends keyof D ? __VLS_Prettify_2<P[K] & {
        default: D[K];
    }> : P[K];
};

declare type __VLS_WithDefaults_3<P, D> = {
    [K in keyof Pick<P, keyof P>]: K extends keyof D ? __VLS_Prettify_3<P[K] & {
        default: D[K];
    }> : P[K];
};

declare type __VLS_WithDefaults_4<P, D> = {
    [K in keyof Pick<P, keyof P>]: K extends keyof D ? __VLS_Prettify_4<P[K] & {
        default: D[K];
    }> : P[K];
};

declare type __VLS_WithDefaults_5<P, D> = {
    [K in keyof Pick<P, keyof P>]: K extends keyof D ? __VLS_Prettify_5<P[K] & {
        default: D[K];
    }> : P[K];
};

declare type __VLS_WithDefaults_6<P, D> = {
    [K in keyof Pick<P, keyof P>]: K extends keyof D ? __VLS_Prettify_6<P[K] & {
        default: D[K];
    }> : P[K];
};

declare type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};

declare type __VLS_WithTemplateSlots_2<T, S> = T & {
    new (): {
        $slots: S;
    };
};

declare type __VLS_WithTemplateSlots_3<T, S> = T & {
    new (): {
        $slots: S;
    };
};

declare const _default: {
    install: (app: App) => void;
};
export default _default;

export declare const extend: {
    readonly borderRadius: {
        readonly DEFAULT: "var(--theme-radius, var(--default-theme-radius))";
        readonly md: "var(--theme-radius, var(--default-theme-radius))";
        readonly lg: "var(--theme-radius-lg, var(--default-theme-radius-lg))";
        readonly xl: "var(--theme-radius-xl, var(--default-theme-radius-xl))";
    };
    readonly fontSize: {
        readonly xxs: "var(--theme-micro, var(--default-theme-micro, var(--theme-font-size-5, var(--default-theme-font-size-5))))";
        readonly xs: "var(--theme-mini, var(--default-theme-mini, var(--theme-font-size-4, var(--default-theme-font-size-4))))";
        readonly sm: "var(--theme-small, var(--default-theme-small, var(--theme-font-size-3, var(--default-theme-font-size-3))))";
        readonly base: "var(--theme-paragraph, var(--default-theme-paragraph, var(--theme-font-size-2, var(--default-theme-font-size-2))))";
        readonly lg: "var(--theme-font-size-1, var(--default-theme-font-size-1))";
    };
    readonly fontWeight: {
        readonly medium: "var(--theme-font-medium, var(--default-theme-font-medium))";
        readonly bold: "var(--theme-font-bold, var(--default-theme-font-bold))";
    };
    readonly maxWidth: {
        readonly 'screen-xs': "480px";
        readonly 'screen-sm': "540px";
        readonly 'screen-md': "640px";
        readonly 'screen-lg': "800px";
    };
};

declare type Icon = (typeof ICONS)[number];

declare const iconProps: (props?: ({
    size?: "md" | "xs" | "sm" | "lg" | "xl" | "full" | undefined;
} & ({
    class?: string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | any | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined;
    className?: undefined;
} | {
    class?: undefined;
    className?: string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | any | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined;
})) | undefined) => string;

declare const ICONS: readonly ["Add", "CheckMark", "ChevronDown", "ChevronLeft", "ChevronRight", "ChevronUp", "Clipboard", "Close", "DarkMode", "Ellipses", "ExternalLink", "GitHub", "LightDarkModeToggle", "LightMode", "Logo", "LogoAPI", "LogoClient", "LogoMarket", "LogoSwagger", "Menu", "PaperAirplane", "Search"];

declare type IconVariants = VariantProps<typeof iconProps>;

declare type LoadingState = ReturnType<typeof useLoadingState>;

export declare const ScalarButton: __VLS_WithTemplateSlots<DefineComponent<__VLS_WithDefaults<__VLS_TypePropsToRuntimeProps<{
    disabled?: boolean | undefined;
    fullWidth?: boolean | undefined;
    loading?: {
        isValid: boolean;
        isInvalid: boolean;
        isLoading: boolean;
        startLoading: () => void;
        stopLoading: () => void;
        validate: (time?: number) => Promise<unknown>;
        invalidate: (time?: number) => Promise<unknown>;
        clear: (time?: number) => Promise<unknown>;
    } | undefined;
    size?: "md" | undefined;
    variant?: string | undefined;
}>, {
    fullWidth: boolean;
    size: string;
    variant: string;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<__VLS_WithDefaults<__VLS_TypePropsToRuntimeProps<{
    disabled?: boolean | undefined;
    fullWidth?: boolean | undefined;
    loading?: {
        isValid: boolean;
        isInvalid: boolean;
        isLoading: boolean;
        startLoading: () => void;
        stopLoading: () => void;
        validate: (time?: number) => Promise<unknown>;
        invalidate: (time?: number) => Promise<unknown>;
        clear: (time?: number) => Promise<unknown>;
    } | undefined;
    size?: "md" | undefined;
    variant?: string | undefined;
}>, {
    fullWidth: boolean;
    size: string;
    variant: string;
}>>>, {
    size: "md";
    variant: string;
    fullWidth: boolean;
}, {}>, {
    icon?(_: {}): any;
    default?(_: {}): any;
}>;

export declare const ScalarCodeBlock: DefineComponent<__VLS_WithDefaults_2<__VLS_TypePropsToRuntimeProps_2<{
    content: string | object;
    lang?: string | undefined;
    lineNumbers?: boolean | undefined;
    hideCredentials?: string | string[] | undefined;
}>, {
    lang: string;
    lineNumbers: boolean;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<__VLS_WithDefaults_2<__VLS_TypePropsToRuntimeProps_2<{
    content: string | object;
    lang?: string | undefined;
    lineNumbers?: boolean | undefined;
    hideCredentials?: string | string[] | undefined;
}>, {
    lang: string;
    lineNumbers: boolean;
}>>>, {
    lang: string;
    lineNumbers: boolean;
}, {}>;

export declare const ScalarIcon: DefineComponent<__VLS_TypePropsToRuntimeProps_3<{
    icon: Icon;
    size?: IconVariants['size'];
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<__VLS_TypePropsToRuntimeProps_3<{
    icon: Icon;
    size?: IconVariants['size'];
}>>>, {}, {}>;

export declare const ScalarIconButton: DefineComponent<__VLS_WithDefaults_3<__VLS_TypePropsToRuntimeProps_4<{
    label: string;
    icon: Icon;
    disabled?: boolean | undefined;
    variant?: Variants['variant'];
    size?: Variants['size'];
}>, {
    variant: string;
    size: string;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<__VLS_WithDefaults_3<__VLS_TypePropsToRuntimeProps_4<{
    label: string;
    icon: Icon;
    disabled?: boolean | undefined;
    variant?: Variants['variant'];
    size?: Variants['size'];
}>, {
    variant: string;
    size: string;
}>>>, {
    size: "md" | "xs" | "sm" | "full";
    variant: string;
}, {}>;

export declare const ScalarLoading: DefineComponent<__VLS_WithDefaults_4<__VLS_TypePropsToRuntimeProps_5<{
    loadingState: LoadingState;
    size?: string | undefined;
}>, {
    size: string;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<__VLS_WithDefaults_4<__VLS_TypePropsToRuntimeProps_5<{
    loadingState: LoadingState;
    size?: string | undefined;
}>, {
    size: string;
}>>>, {
    size: string;
}, {}>;

export declare const ScalarModal: __VLS_WithTemplateSlots_2<DefineComponent<__VLS_WithDefaults_5<__VLS_TypePropsToRuntimeProps_6<{
    state: ReturnType<typeof useModal>;
    title?: string | undefined;
    bodyClass?: string | undefined;
    maxWidth?: string | undefined;
    size?: "md" | "xs" | "sm" | "lg" | undefined;
    variant?: "search" | "history" | undefined;
}>, {
    size: string;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, PublicProps, Readonly<ExtractPropTypes<__VLS_WithDefaults_5<__VLS_TypePropsToRuntimeProps_6<{
    state: ReturnType<typeof useModal>;
    title?: string | undefined;
    bodyClass?: string | undefined;
    maxWidth?: string | undefined;
    size?: "md" | "xs" | "sm" | "lg" | undefined;
    variant?: "search" | "history" | undefined;
}>, {
    size: string;
}>>>, {
    size: "md" | "xs" | "sm" | "lg";
}, {}>, {
    default?(_: {}): any;
}>;

export declare const ScalarTextField: __VLS_WithTemplateSlots_3<DefineComponent<__VLS_WithDefaults_6<__VLS_TypePropsToRuntimeProps_7<{
    modelValue: string;
    placeholder?: string | undefined;
    label?: string | undefined;
    /** This color creates a mask over the input outline and should be set to the background color behind the textField */
    labelShadowColor?: string | undefined;
    error?: boolean | undefined;
    isMultiline?: boolean | undefined;
    helperText?: string | undefined;
    emitOnBlur?: boolean | undefined;
    handleFieldSubmit?: ((e: string) => void) | undefined;
    handleFieldChange?: ((e: string) => void) | undefined;
    /** Option to disable trimming for input fields */
    disableTrim?: boolean | undefined;
}>, {
    emitOnBlur: boolean;
    labelShadowColor: string;
    disableTrim: boolean;
}>, {}, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {
    submit: (v: string) => void;
    "update:modelValue": (v: string) => void;
}, string, PublicProps, Readonly<ExtractPropTypes<__VLS_WithDefaults_6<__VLS_TypePropsToRuntimeProps_7<{
    modelValue: string;
    placeholder?: string | undefined;
    label?: string | undefined;
    /** This color creates a mask over the input outline and should be set to the background color behind the textField */
    labelShadowColor?: string | undefined;
    error?: boolean | undefined;
    isMultiline?: boolean | undefined;
    helperText?: string | undefined;
    emitOnBlur?: boolean | undefined;
    handleFieldSubmit?: ((e: string) => void) | undefined;
    handleFieldChange?: ((e: string) => void) | undefined;
    /** Option to disable trimming for input fields */
    disableTrim?: boolean | undefined;
}>, {
    emitOnBlur: boolean;
    labelShadowColor: string;
    disableTrim: boolean;
}>>> & {
    onSubmit?: ((v: string) => any) | undefined;
    "onUpdate:modelValue"?: ((v: string) => any) | undefined;
}, {
    labelShadowColor: string;
    emitOnBlur: boolean;
    disableTrim: boolean;
}, {}>, {
    default?(_: {}): any;
}>;

export declare const theme: {
    readonly boxShadow: {
        readonly DEFAULT: "var(--theme-shadow-1, var(--default-theme-shadow-1))";
        readonly md: "var(--theme-shadow-2, var(--default-theme-shadow-2))";
        readonly sm: "rgba(0, 0, 0, 0.09) 0px 1px 4px";
        readonly none: "0 0 #0000";
    };
    readonly colors: {
        readonly 'fore-1': "var(--theme-color-1, var(--default-theme-color-1))";
        readonly 'fore-2': "var(--theme-color-2, var(--default-theme-color-2))";
        readonly 'fore-3': "var(--theme-color-3, var(--default-theme-color-3))";
        readonly accent: "var(--theme-color-accent, var(--default-theme-color-accent))";
        readonly 'back-1': "var(--theme-background-1, var(--default-theme-background-1))";
        readonly 'back-2': "var(--theme-background-2, var(--default-theme-background-2))";
        readonly 'back-3': "var(--theme-background-3, var(--default-theme-background-3))";
        readonly 'back-accent': "var(--theme-background-accent, var(--default-theme-background-accent))";
        readonly backdrop: "rgba(0, 0, 0, 0.44)";
        readonly border: "var(--theme-border-color, var(--default-theme-border-color))";
        readonly 'back-btn-1': "var(--theme-button-1, var(--default-theme-button-1))";
        readonly 'fore-btn-1': "var(--theme-button-1-color, var(--default-theme-button-1-color))";
        readonly 'hover-btn-1': "var(--theme-button-1-hover, var(--default-theme-button-1-hover))";
        readonly white: "#FFF";
        readonly green: "var(--theme-color-green, var(--default-theme-color-green))";
        readonly red: "var(--theme-color-red, var(--default-theme-color-red))";
        readonly yellow: "var(--theme-color-yellow, var(--default-theme-color-yellow))";
        readonly blue: "var(--theme-color-blue, var(--default-theme-color-blue))";
        readonly orange: "var(--theme-color-orange, var(--default-theme-color-orange))";
        readonly purple: "var(--theme-color-purple, var(--default-theme-color-purple))";
        readonly error: "var(--theme-error-color, var(--default-theme-color-red))";
        readonly ghost: "var(--theme-color-ghost, var(--default-theme-color-ghost))";
        readonly transparent: "transparent";
    };
};

/**
 * Handles isLoading spinner for the FlowLoader Component
 * - stateIsLoading will trigger the spinner
 * - isValid or isInvalid will show a check or x and then spin out
 */
export declare function useLoadingState(): {
    isValid: boolean;
    isInvalid: boolean;
    isLoading: boolean;
    startLoading: () => void;
    stopLoading: () => void;
    validate: (time?: number) => Promise<unknown>;
    invalidate: (time?: number) => Promise<unknown>;
    clear: (time?: number) => Promise<unknown>;
};

export declare const useModal: () => {
    open: boolean;
    show: () => void;
    hide: () => void;
};

declare type Variants = VariantProps<typeof variants>;

declare const variants: (props?: ({
    size?: "md" | "xs" | "sm" | "full" | undefined;
    disabled?: boolean | undefined;
    variant?: string | undefined;
} & ({
    class?: string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | any | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined;
    className?: undefined;
} | {
    class?: undefined;
    className?: string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | (string | number | boolean | any | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined)[] | {
        [x: string]: any;
    } | null | undefined;
})) | undefined) => string;

export { }
