/**
 * TODO: This is a copy of projects/web/src/stores/template.ts
 */
import { type TargetId } from 'httpsnippet-lite';
export declare enum NavState {
    Guide = "Guide",
    Reference = "Reference"
}
export type SelectedClient = {
    targetKey: TargetId;
    clientKey: string;
};
type TemplateState = {
    isDark: boolean;
    activeNavState: NavState;
    selectedClient: SelectedClient;
};
declare function resetState(): void;
declare function getTargetTitle(client: SelectedClient): string;
declare function getClientTitle(client: SelectedClient): string;
export declare const useTemplateStore: () => {
    state: {
        readonly isDark: boolean;
        readonly activeNavState: NavState;
        readonly selectedClient: {
            readonly targetKey: TargetId;
            readonly clientKey: string;
        };
    };
    resetState: typeof resetState;
    setItem: <K extends keyof TemplateState>(key: K, value: {
        isDark: boolean;
        activeNavState: NavState;
        selectedClient: {
            targetKey: TargetId;
            clientKey: string;
        };
    }[K]) => void;
    toggleItem: (key: "isDark") => void;
    getClientTitle: typeof getClientTitle;
    getTargetTitle: typeof getTargetTitle;
};
export {};
//# sourceMappingURL=template.d.ts.map