import type { AuthenticationState, ServerState } from '../types';
export declare const createEmptyAuthenticationState: () => AuthenticationState;
/** Server */
export declare const createEmptyServerState: () => ServerState;
export declare const useGlobalStore: () => {
    authentication: {
        securitySchemeKey: string | null;
        securitySchemes?: {
            [key: string]: import("openapi-types").OpenAPIV3.SecuritySchemeObject | import("openapi-types").OpenAPIV3.ReferenceObject;
        } | Record<string, import("openapi-types").OpenAPIV3.SecuritySchemeObject | import("openapi-types").OpenAPIV3_1.ReferenceObject> | undefined;
        http: {
            basic: {
                username: string;
                password: string;
            };
            bearer: {
                token: string;
            };
        };
        apiKey: {
            token: string;
        };
        oAuth2: {
            clientId: string;
            scopes: string[];
        };
    };
    setAuthentication: (newState: Partial<AuthenticationState>) => void;
    server: {
        selectedServer: number | null;
        description?: string | undefined;
        servers: {
            url: string;
            description?: string | undefined;
            variables?: import("../types").ServerVariables | undefined;
        }[];
        variables: import("../types").Variable[];
    };
    setServer: (newState: Partial<ServerState>) => void;
};
//# sourceMappingURL=globalStore.d.ts.map