import type { Spec } from '../types';
export type SidebarEntry = {
    id: string;
    title: string;
    children?: SidebarEntry[];
    select?: () => void;
    httpVerb?: string;
    show: boolean;
    deprecated?: boolean;
};
type CollapsedSidebarItems = Record<string, boolean>;
declare function toggleCollapsedSidebarItem(key: string): void;
declare function setCollapsedSidebarItem(key: string, value: boolean): void;
export declare function useSidebar(options?: {
    parsedSpec: Spec;
}): {
    breadcrumb: import("vue").ComputedRef<string>;
    items: import("vue").ComputedRef<{
        entries: SidebarEntry[];
        titles: Record<string, string>;
    }>;
    collapsedSidebarItems: CollapsedSidebarItems;
    toggleCollapsedSidebarItem: typeof toggleCollapsedSidebarItem;
    setCollapsedSidebarItem: typeof setCollapsedSidebarItem;
};
export {};
//# sourceMappingURL=useSidebar.d.ts.map