import { type ComputedRef, type Ref } from 'vue';
import type { Spec } from '../types';
/**
 * Dereference OpenAPI/Swagger specs
 */
export declare function useParser({ input, }: {
    input?: string | Ref<string> | ComputedRef<string>;
}): {
    parsedSpecRef: {
        tags?: {
            name: string;
            description: string;
            operations: {
                httpVerb: string;
                path: string;
                operationId?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                information?: {
                    description?: string | undefined;
                    operationId?: string | number | undefined;
                    parameters?: {
                        name: string;
                        in?: string | undefined;
                        description?: string | undefined;
                        required?: boolean | undefined;
                        deprecated?: boolean | undefined;
                        allowEmptyValue?: boolean | undefined;
                        style?: "form" | "simple" | undefined;
                        explode?: boolean | undefined;
                        allowReserved?: boolean | undefined;
                        schema?: {
                            type: string;
                            name?: string | undefined;
                            example?: any;
                            default?: any;
                            format?: string | undefined;
                            description?: string | undefined;
                            properties?: Record<string, import("../types").Schema> | undefined;
                        } | undefined;
                        example?: any;
                        examples?: (Map<string, any> & Omit<Map<string, any>, keyof Map<any, any>>) | undefined;
                    }[] | undefined;
                    responses?: Record<string, import("../types").Response> | undefined;
                    security?: import("openapi-types").OpenAPIV3.SecurityRequirementObject[] | undefined;
                    requestBody?: {
                        description?: string | undefined;
                        required?: boolean | undefined;
                        content?: {
                            "application/json"?: {
                                schema?: any;
                                example?: any;
                                examples?: any;
                            } | undefined;
                            "application/xml"?: {
                                schema?: any;
                                example?: any;
                                examples?: any;
                            } | undefined;
                            "text/plain"?: {
                                schema?: any;
                                example?: any;
                                examples?: any;
                            } | undefined;
                            "text/html"?: {
                                schema?: any;
                                example?: any;
                                examples?: any;
                            } | undefined;
                            "application/octet-stream"?: {
                                schema?: any;
                                example?: any;
                                examples?: any;
                            } | undefined;
                            "application/x-www-form-urlencoded"?: {
                                schema?: any;
                                example?: any;
                                examples?: any;
                            } | undefined;
                            "multipart/form-data"?: {
                                schema?: any;
                                example?: any;
                                examples?: any;
                            } | undefined;
                        } | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    deprecated?: boolean | undefined;
                    'x-custom-examples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                    'x-codeSamples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                    'x-code-samples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                } | undefined;
                pathParameters?: {
                    name: string;
                    in?: string | undefined;
                    description?: string | undefined;
                    required?: boolean | undefined;
                    deprecated?: boolean | undefined;
                    allowEmptyValue?: boolean | undefined;
                    style?: "form" | "simple" | undefined;
                    explode?: boolean | undefined;
                    allowReserved?: boolean | undefined;
                    schema?: {
                        type: string;
                        name?: string | undefined;
                        example?: any;
                        default?: any;
                        format?: string | undefined;
                        description?: string | undefined;
                        properties?: Record<string, import("../types").Schema> | undefined;
                    } | undefined;
                    example?: any;
                    examples?: (Map<string, any> & Omit<Map<string, any>, keyof Map<any, any>>) | undefined;
                }[] | undefined;
            }[];
        }[] | undefined;
        info: {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name: string;
                url?: string | undefined;
            } | undefined;
            version?: string | undefined;
        } | {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name: string;
                url?: string | undefined;
            } | undefined;
            version?: string | undefined;
        } | {
            description?: string | undefined;
            title?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            version?: string | undefined;
            summary?: string | undefined;
            license?: {
                url?: string | undefined;
                name: string;
                identifier?: string | undefined;
            } | undefined;
        };
        host?: string | undefined;
        basePath?: string | undefined;
        schemes?: string[] | undefined;
        externalDocs?: {
            description: string;
            url: string;
        } | undefined;
        servers?: {
            url: string;
            description?: string | undefined;
            variables?: import("../types").ServerVariables | undefined;
        }[] | undefined;
        components?: {
            schemas?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.SchemaObject;
            } | undefined;
            responses?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.ResponseObject;
            } | undefined;
            parameters?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.ParameterObject;
            } | undefined;
            examples?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.ExampleObject;
            } | undefined;
            requestBodies?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.RequestBodyObject;
            } | undefined;
            headers?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.HeaderObject;
            } | undefined;
            securitySchemes?: {
                [key: string]: import("openapi-types").OpenAPIV3.SecuritySchemeObject | import("openapi-types").OpenAPIV3.ReferenceObject;
            } | undefined;
            links?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.LinkObject;
            } | undefined;
            callbacks?: {
                [key: string]: import("openapi-types").OpenAPIV3.ReferenceObject | import("openapi-types").OpenAPIV3.CallbackObject;
            } | undefined;
        } | {
            schemas?: Record<string, import("openapi-types").OpenAPIV3_1.SchemaObject> | undefined;
            responses?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3_1.ResponseObject> | undefined;
            parameters?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3.ParameterObject> | undefined;
            examples?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3.ExampleObject> | undefined;
            requestBodies?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3_1.RequestBodyObject> | undefined;
            headers?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3.HeaderObject> | undefined;
            securitySchemes?: Record<string, import("openapi-types").OpenAPIV3.SecuritySchemeObject | import("openapi-types").OpenAPIV3_1.ReferenceObject> | undefined;
            links?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3_1.LinkObject> | undefined;
            callbacks?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3_1.CallbackObject> | undefined;
            pathItems?: Record<string, import("openapi-types").OpenAPIV3_1.ReferenceObject | import("openapi-types").OpenAPIV3_1.PathItemObject<{}>> | undefined;
        } | undefined;
        webhooks?: import("../types").Webhooks | undefined;
        definitions?: import("openapi-types").OpenAPIV2.DefinitionsObject | undefined;
        swagger?: string | undefined;
        openapi?: string | undefined;
    };
    overwriteParsedSpecRef: (value: Spec) => void;
    errorRef: Ref<string | null>;
};
//# sourceMappingURL=useParser.d.ts.map