import { type Heading } from '../helpers';
import type { Tag, TransformedOperation } from '../types';
/**
 * Hook which provides reactive hash state from the URL
 * Also hash is only readable by the client so keep that in mind for SSR
 *
 * isIntersectionEnabled is a hack to prevent intersection observer from triggering
 * when clicking on sidebar links or going backwards
 *
 *
 * @param hasLifecyle - we cannot use lifecycle hooks when called from another composable, this prevents that
 */
export declare const useNavState: () => {
    hash: import("vue").Ref<string>;
    getWebhookId: (name?: string, httpVerb?: string) => string;
    getModelId: (name?: string) => string;
    getHeadingId: (heading: Heading) => string;
    getOperationId: (operation: TransformedOperation, parentTag: Tag) => string;
    getSectionId: (hashStr?: string) => string;
    getTagId: ({ name }: Tag) => string;
    isIntersectionEnabled: import("vue").Ref<boolean>;
    enableHashListener: () => false | Function | undefined;
};
//# sourceMappingURL=useNavState.d.ts.map