import type { HarRequest } from 'httpsnippet-lite';
import type { OpenAPIV3 } from 'openapi-types';
import type { AuthenticationState } from '../types';
/**
 * Get the request object from the authentication state.
 */
export declare function getRequestFromAuthentication(authentication: AuthenticationState, security?: OpenAPIV3.SecurityRequirementObject[]): Partial<HarRequest>;
export declare function getBase64Token(username: string, password: string): string;
export declare function getSecretCredentialsFromAuthentication(authentication: AuthenticationState): string[];
//# sourceMappingURL=getRequestFromAuthentication.d.ts.map