import type { ContentType, TransformedOperation } from '../types';
/**
 * Get the request body from the operation.
 */
export declare function getRequestBodyFromOperation(operation: TransformedOperation, selectedExampleKey?: string | number): {
    postData: {
        mimeType: string;
        text: any;
        params?: undefined;
    };
    headers?: undefined;
} | {
    postData: {
        mimeType: string;
        params: {
            name: string;
            value: string | number | Record<string, any>;
        }[];
        text?: undefined;
    };
    headers?: undefined;
} | {
    postData: undefined;
    headers?: undefined;
} | {
    headers: {
        name: string;
        value: ContentType;
    }[];
    postData: {
        mimeType: "application/json";
        text: any;
        params?: undefined;
    };
} | {
    headers: {
        name: string;
        value: ContentType;
    }[];
    postData: {
        mimeType: "application/xml";
        text: any;
        params?: undefined;
    };
} | {
    headers: {
        name: string;
        value: ContentType;
    }[];
    postData: {
        mimeType: "application/octet-stream";
        text: string;
        params?: undefined;
    };
} | {
    headers: {
        name: string;
        value: ContentType;
    }[];
    postData: {
        mimeType: "text/plain";
        text: any;
        params?: undefined;
    };
} | {
    headers: {
        name: string;
        value: ContentType;
    }[];
    postData: {
        mimeType: "application/x-www-form-urlencoded";
        text?: undefined;
        params?: undefined;
    };
} | {
    headers: {
        name: string;
        value: ContentType;
    }[];
    postData: {
        mimeType: "multipart/form-data";
        text?: undefined;
        params?: undefined;
    };
} | undefined;
//# sourceMappingURL=getRequestBodyFromOperation.d.ts.map