import type { BaseParameter } from '@scalar/api-client';
import type { TransformedOperation } from '../types';
/**
 * Get the query parameters from an operation.
 *
 * Example: [ { name: 'foobar', value: '' } ]
 *
 * - OpenAPI 3.x: Possible values are “query”, “header”, “path” or “cookie”.
 * - Swagger 2.0: Possible values are "query", "header", "path", "formData" or "body".
 */
export declare function getParametersFromOperation(operation: TransformedOperation, where: 'query' | 'header' | 'path' | 'cookie' | 'formData' | 'body', requiredOnly?: boolean): BaseParameter[];
//# sourceMappingURL=getParametersFromOperation.d.ts.map