import type { AuthState, ClientRequestConfig, RequestResult } from '../types';
export declare const createEmptyAuthState: () => AuthState;
type RequestHistoryEntry = RequestResult;
export declare const useRequestStore: () => {
    authState: {
        type: import("../types").AuthType;
        basic: {
            username: string;
            password: string;
            active: boolean;
        };
        oauthTwo: {
            generatedToken: string;
            discoveryURL: string;
            authURL: string;
            accessTokenURL: string;
            clientID: string;
            clientSecret: string;
            scope: string;
            active: boolean;
        };
        bearer: {
            token: string;
            active: boolean;
        };
        digest: {
            username: string;
            password: string;
            active: boolean;
        };
    };
    readOnly: import("vue").Ref<boolean>;
    activeRequest: {
        id?: string | undefined;
        name?: string | undefined;
        url: string;
        type: string;
        path: string;
        variables?: {
            name: string;
            description?: string | null | undefined;
            value: string | number | Record<string, any>;
            required?: boolean | undefined;
            enabled: boolean;
        }[] | undefined;
        query?: {
            name: string;
            description?: string | null | undefined;
            value: string | number | Record<string, any>;
            required?: boolean | undefined;
            enabled: boolean;
        }[] | undefined;
        cookies?: {
            name: string;
            description?: string | null | undefined;
            value: string | number | Record<string, any>;
            required?: boolean | undefined;
            enabled: boolean;
        }[] | undefined;
        headers?: {
            name: string;
            description?: string | null | undefined;
            value: string | number | Record<string, any>;
            required?: boolean | undefined;
            enabled: boolean;
        }[] | undefined;
        body?: string | undefined;
        formData?: {
            name: string;
            description?: string | null | undefined;
            value: string | number | Record<string, any>;
            required?: boolean | undefined;
            enabled: boolean;
        }[] | undefined;
    };
    activeResponse: import("vue").ComputedRef<import("../types").ClientResponse | null>;
    requestHistory: Record<string, RequestResult>;
    requestHistoryOrder: import("vue").Ref<string[]>;
    activeRequestId: import("vue").Ref<string>;
    setActiveResponse: (historyID: string) => void;
    resetActiveResponse: () => void;
    addRequestToHistory: (value: RequestHistoryEntry) => void;
    setActiveRequest: (request: ClientRequestConfig) => void;
};
export {};
//# sourceMappingURL=requestStore.d.ts.map