import type { AuthState, ClientRequestConfig } from '../types';
/**
 * Before a request is sent to the server, we’ll do some final preparation.
 *
 * - Add authentication headers
 * - Add Content-Type header if request.body is JSON
 * - Parse request.body if it’s JSON
 * - Remove duplicate headers
 */
export declare const prepareClientRequestConfig: (configuration: {
    request: ClientRequestConfig;
    authState: AuthState;
}) => {
    id?: string | undefined;
    name?: string | undefined;
    url: string;
    type: string;
    path: string;
    variables?: import("../types").BaseParameter[] | undefined;
    query?: import("../types").BaseParameter[] | undefined;
    cookies?: import("../types").BaseParameter[] | undefined;
    headers?: import("../types").BaseParameter[] | undefined;
    body?: string | undefined;
    formData?: import("../types").BaseParameter[] | undefined;
};
//# sourceMappingURL=prepareClientRequestConfig.d.ts.map