(function() {
  "use strict";
  try {
    if (typeof document != "undefined") {
      var elementStyle = document.createElement("style");
      elementStyle.appendChild(document.createTextNode(".light-mode .scalar-modal-layout,\n.light-mode .scalar {\n  --theme-color-1: color-mix(\n    in srgb,\n    rgb(var(--primary-base-300, 180 180 180)),\n    rgb(var(--dark-base, 23 23 23)) 96%\n  );\n  --theme-color-2: color-mix(\n    in srgb,\n    var(--theme-color-1),\n    transparent calc(100% - 100% * 0.72)\n  );\n  --theme-color-3: color-mix(\n    in srgb,\n    var(--theme-color-1),\n    transparent calc(100% - 100% * 0.4)\n  );\n  --theme-color-accent: #007d9c;\n\n  --theme-background-1: rgb(var(--light-base, 255 255 255));\n  --theme-background-2: color-mix(\n    in srgb,\n    rgb(var(--primary-base-800, 30 30 30)),\n    var(--theme-background-1) 96%\n  );\n  --theme-background-3: color-mix(\n    in srgb,\n    rgb(var(--primary-base-800, 30 30 30)),\n    var(--theme-background-1) 90%\n  );\n  --theme-background-accent: #007d9c1f;\n  --theme-code-language-color-supersede: var(--theme-color-1);\n  --theme-code-languages-background-supersede: var(--theme-background-1);\n  --theme-border-color: color-mix(\n    in srgb,\n    var(--theme-color-1),\n    transparent calc(100% - 100% * 0.08)\n  );\n\n  --theme-color-green: #0a6355;\n  --theme-color-red: #dc1b19;\n  --theme-color-yellow: #ffc90d;\n  --theme-color-blue: rgb(var(--primary-color-500, 52 109 219));\n  --theme-color-orange: #ff8d4d;\n  --theme-color-purple: #8250df;\n\n  --theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n}\n.dark-mode .scalar-modal-layout,\n.dark-mode .scalar {\n  --theme-color-1: color-mix(\n    in srgb,\n    rgb(var(--primary-base-700, 70 70 70)),\n    rgb(var(--light-base, 255 255 255)) 100%\n  );\n  --theme-color-2: color-mix(\n    in srgb,\n    var(--theme-color-1),\n    transparent calc(100% - 100% * 0.64)\n  );\n  --theme-color-3: color-mix(\n    in srgb,\n    var(--theme-color-1),\n    transparent calc(100% - 100% * 0.4)\n  );\n  --theme-color-accent: #50b7e0;\n\n  --theme-background-1: rgb(var(--dark-base, 22 22 22));\n  --theme-background-2: color-mix(\n    in srgb,\n    rgb(var(--primary-base-200, 200 200 200)),\n    var(--theme-background-1) 92%\n  );\n  --theme-background-3: color-mix(\n    in srgb,\n    rgb(var(--primary-base-200, 200 200 200)),\n    var(--theme-background-1) 88%\n  );\n  --theme-background-accent: #8ab4f81f;\n  --theme-code-languages-background-supersede: var(--theme-background-1);\n  --theme-border-color: color-mix(\n    in srgb,\n    var(--theme-color-1),\n    transparent calc(100% - 100% * 0.08)\n  );\n\n  --theme-color-green: #56b6c2;\n  --theme-color-red: rgb(245 124 97);\n  --theme-color-yellow: #edbe20;\n  --theme-color-blue: rgb(var(--primary-color-400, 93 138 226));\n  --theme-color-orange: #d19a66;\n  --theme-color-purple: #5203d1;\n\n  --theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n}\n.scalar-modal-layout,\n.scalar {\n  --theme-font: initial;\n  --theme-font-code: var(--font-mono);\n\n  --theme-paragraph: 16px;\n  --theme-small: 14px;\n  --theme-mini: 13px;\n  --theme-micro: 12px;\n\n  --theme-bold: 600;\n  --theme-semibold: 500;\n  --theme-regular: 400;\n\n  /* Font sizes for interactive applications (not rendered text content) */\n  --theme-font-size-1: 24px;\n  --theme-font-size-2: 16px;\n  --theme-font-size-3: 14px;\n  --theme-font-size-4: 13px;\n  --theme-font-size-5: 12px;\n\n  --theme-line-height-1: 32px;\n  --theme-line-height-2: 24px;\n  --theme-line-height-3: 20px;\n  --theme-line-height-4: 18px;\n  --theme-line-height-5: 16px;\n}\n.scalar input::placeholder {\n  color: var(--theme-color-3);\n}\n.scalar .scalar-app-header {\n  width: 100%;\n  z-index: 1000;\n  padding: 6px 12px 6px 12px;\n  border-radius: 0.25rem 0.25rem 0 0;\n  font-size: 14px;\n  font-family: sans-serif;\n  --scalar-app-header-height: 35px;\n  height: var(--scalar-app-header-height);\n  display: flex;\n  align-items: center;\n  gap: 6px;\n}\n.scalar .scalar-app-header a {\n  text-decoration: none;\n}\n.scalar .scalar-api-client {\n  max-height: calc(100% - calc(var(--scalar-app-header-height)));\n  border-radius: 8px;\n}\n.scalar-api-client__close {\n  appearance: none;\n  border: none;\n  outline: none;\n  display: flex;\n  align-items: center;\n  background: transparent;\n  color: var(--theme-color-1);\n  font-size: var(--theme-small);\n  font-weight: var(--theme-semibold);\n}\n.scalar-api-client__close:hover {\n  cursor: pointer;\n}\n.scalar .scalar-app {\n  background: var(--theme-background-3);\n  height: calc(100dvh - 100px);\n  max-width: 1280px;\n  width: 100%;\n  margin: auto;\n  opacity: 0;\n  animation: scalarapiclientfadein 0.35s forwards;\n  z-index: 1002;\n  position: relative;\n  overflow: hidden;\n  border-radius: 8px;\n}\n@keyframes scalarapiclientfadein {\n  from {\n    transform: translate3d(0, 20px, 0) scale(0.985);\n    opacity: 0;\n  }\n  to {\n    transform: translate3d(0, 0, 0) scale(1);\n    opacity: 1;\n  }\n}\n.scalar .scalar-app-exit {\n  position: fixed;\n  top: 0;\n  left: 0;\n  width: 100vw;\n  height: 100vh;\n  background: rgba(0, 0, 0, 0.62);\n  transition: all 0.3s ease-in-out;\n  z-index: 1000;\n  cursor: pointer;\n  animation: scalardrawerexitfadein 0.35s forwards;\n}\n.scalar .scalar-app-exit:before {\n  content: '\\00d7';\n  font-family: sans-serif;\n  position: absolute;\n  top: 0;\n  right: 0;\n  font-size: 30px;\n  font-weight: 100;\n  line-height: 50px;\n  right: 12px;\n  text-align: center;\n  color: white;\n  opacity: 0.6;\n}\n.scalar .scalar-app-exit:hover:before {\n  opacity: 1;\n}\n@keyframes scalardrawerexitfadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n.scalar-container {\n  overflow: hidden;\n  visibility: visible;\n  position: fixed;\n  bottom: 0;\n  left: 0;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  z-index: 1001;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n\n.scalar .url-form-input {\n  min-height: auto !important;\n}\n\n.scalar .scalar-container {\n  line-height: normal;\n}\n.scalar .scalar-app-header span {\n  color: var(--theme-color-3);\n}\n.scalar .scalar-app-header a {\n  color: var(--theme-color-1);\n}\n.scalar .scalar-app-header a:hover {\n  text-decoration: underline;\n}\n.scalar-activate {\n  width: fit-content;\n  margin: 0px 0.75rem 0.75rem auto;\n  line-height: 24px;\n  font-size: 0.75rem;\n  cursor: pointer;\n  font-size: 0.875rem;\n  font-weight: 600;\n  display: flex;\n  align-items: center;\n  gap: 6px;\n}\n.scalar-activate-button {\n  display: flex;\n  gap: 6px;\n  align-items: center;\n  color: var(--theme-color-blue);\n  appearance: none;\n  outline: none;\n  border: none;\n  background: transparent;\n}\n.scalar-activate-button {\n  padding: 0 0.5rem;\n}\n.scalar-activate:hover .scalar-activate-button {\n  background: var(--theme-background-3);\n  border-radius: 3px;\n}"));
      document.head.appendChild(elementStyle);
    }
  } catch (e) {
    console.error("vite-plugin-css-injected-by-js", e);
  }
})();
(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? factory(exports, require("react")) : typeof define === "function" && define.amd ? define(["exports", "react"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2["@scalar/api-client-react"] = {}, global2.React));
})(this, function(exports2, require$$0) {
  "use strict";
  var jsxRuntime = { exports: {} };
  var reactJsxRuntime_production_min = {};
  /**
   * @license React
   * react-jsx-runtime.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var hasRequiredReactJsxRuntime_production_min;
  function requireReactJsxRuntime_production_min() {
    if (hasRequiredReactJsxRuntime_production_min)
      return reactJsxRuntime_production_min;
    hasRequiredReactJsxRuntime_production_min = 1;
    var f2 = require$$0, k2 = Symbol.for("react.element"), l2 = Symbol.for("react.fragment"), m2 = Object.prototype.hasOwnProperty, n2 = f2.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, p2 = { key: true, ref: true, __self: true, __source: true };
    function q2(c2, a2, g) {
      var b2, d2 = {}, e2 = null, h2 = null;
      void 0 !== g && (e2 = "" + g);
      void 0 !== a2.key && (e2 = "" + a2.key);
      void 0 !== a2.ref && (h2 = a2.ref);
      for (b2 in a2)
        m2.call(a2, b2) && !p2.hasOwnProperty(b2) && (d2[b2] = a2[b2]);
      if (c2 && c2.defaultProps)
        for (b2 in a2 = c2.defaultProps, a2)
          void 0 === d2[b2] && (d2[b2] = a2[b2]);
      return { $$typeof: k2, type: c2, key: e2, ref: h2, props: d2, _owner: n2.current };
    }
    reactJsxRuntime_production_min.Fragment = l2;
    reactJsxRuntime_production_min.jsx = q2;
    reactJsxRuntime_production_min.jsxs = q2;
    return reactJsxRuntime_production_min;
  }
  var reactJsxRuntime_development = {};
  /**
   * @license React
   * react-jsx-runtime.development.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var hasRequiredReactJsxRuntime_development;
  function requireReactJsxRuntime_development() {
    if (hasRequiredReactJsxRuntime_development)
      return reactJsxRuntime_development;
    hasRequiredReactJsxRuntime_development = 1;
    if (process.env.NODE_ENV !== "production") {
      (function() {
        var React = require$$0;
        var REACT_ELEMENT_TYPE = Symbol.for("react.element");
        var REACT_PORTAL_TYPE = Symbol.for("react.portal");
        var REACT_FRAGMENT_TYPE = Symbol.for("react.fragment");
        var REACT_STRICT_MODE_TYPE = Symbol.for("react.strict_mode");
        var REACT_PROFILER_TYPE = Symbol.for("react.profiler");
        var REACT_PROVIDER_TYPE = Symbol.for("react.provider");
        var REACT_CONTEXT_TYPE = Symbol.for("react.context");
        var REACT_FORWARD_REF_TYPE = Symbol.for("react.forward_ref");
        var REACT_SUSPENSE_TYPE = Symbol.for("react.suspense");
        var REACT_SUSPENSE_LIST_TYPE = Symbol.for("react.suspense_list");
        var REACT_MEMO_TYPE = Symbol.for("react.memo");
        var REACT_LAZY_TYPE = Symbol.for("react.lazy");
        var REACT_OFFSCREEN_TYPE = Symbol.for("react.offscreen");
        var MAYBE_ITERATOR_SYMBOL = Symbol.iterator;
        var FAUX_ITERATOR_SYMBOL = "@@iterator";
        function getIteratorFn(maybeIterable) {
          if (maybeIterable === null || typeof maybeIterable !== "object") {
            return null;
          }
          var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];
          if (typeof maybeIterator === "function") {
            return maybeIterator;
          }
          return null;
        }
        var ReactSharedInternals = React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
        function error(format2) {
          {
            {
              for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                args[_key2 - 1] = arguments[_key2];
              }
              printWarning("error", format2, args);
            }
          }
        }
        function printWarning(level, format2, args) {
          {
            var ReactDebugCurrentFrame2 = ReactSharedInternals.ReactDebugCurrentFrame;
            var stack2 = ReactDebugCurrentFrame2.getStackAddendum();
            if (stack2 !== "") {
              format2 += "%s";
              args = args.concat([stack2]);
            }
            var argsWithFormat = args.map(function(item) {
              return String(item);
            });
            argsWithFormat.unshift("Warning: " + format2);
            Function.prototype.apply.call(console[level], console, argsWithFormat);
          }
        }
        var enableScopeAPI = false;
        var enableCacheElement = false;
        var enableTransitionTracing = false;
        var enableLegacyHidden = false;
        var enableDebugTracing = false;
        var REACT_MODULE_REFERENCE;
        {
          REACT_MODULE_REFERENCE = Symbol.for("react.module.reference");
        }
        function isValidElementType(type) {
          if (typeof type === "string" || typeof type === "function") {
            return true;
          }
          if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || enableDebugTracing || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || enableLegacyHidden || type === REACT_OFFSCREEN_TYPE || enableScopeAPI || enableCacheElement || enableTransitionTracing) {
            return true;
          }
          if (typeof type === "object" && type !== null) {
            if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || // This needs to include all possible module reference object
            // types supported by any Flight configuration anywhere since
            // we don't know which Flight build this will end up being used
            // with.
            type.$$typeof === REACT_MODULE_REFERENCE || type.getModuleId !== void 0) {
              return true;
            }
          }
          return false;
        }
        function getWrappedName(outerType, innerType, wrapperName) {
          var displayName = outerType.displayName;
          if (displayName) {
            return displayName;
          }
          var functionName = innerType.displayName || innerType.name || "";
          return functionName !== "" ? wrapperName + "(" + functionName + ")" : wrapperName;
        }
        function getContextName(type) {
          return type.displayName || "Context";
        }
        function getComponentNameFromType(type) {
          if (type == null) {
            return null;
          }
          {
            if (typeof type.tag === "number") {
              error("Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue.");
            }
          }
          if (typeof type === "function") {
            return type.displayName || type.name || null;
          }
          if (typeof type === "string") {
            return type;
          }
          switch (type) {
            case REACT_FRAGMENT_TYPE:
              return "Fragment";
            case REACT_PORTAL_TYPE:
              return "Portal";
            case REACT_PROFILER_TYPE:
              return "Profiler";
            case REACT_STRICT_MODE_TYPE:
              return "StrictMode";
            case REACT_SUSPENSE_TYPE:
              return "Suspense";
            case REACT_SUSPENSE_LIST_TYPE:
              return "SuspenseList";
          }
          if (typeof type === "object") {
            switch (type.$$typeof) {
              case REACT_CONTEXT_TYPE:
                var context = type;
                return getContextName(context) + ".Consumer";
              case REACT_PROVIDER_TYPE:
                var provider = type;
                return getContextName(provider._context) + ".Provider";
              case REACT_FORWARD_REF_TYPE:
                return getWrappedName(type, type.render, "ForwardRef");
              case REACT_MEMO_TYPE:
                var outerName = type.displayName || null;
                if (outerName !== null) {
                  return outerName;
                }
                return getComponentNameFromType(type.type) || "Memo";
              case REACT_LAZY_TYPE: {
                var lazyComponent = type;
                var payload = lazyComponent._payload;
                var init = lazyComponent._init;
                try {
                  return getComponentNameFromType(init(payload));
                } catch (x2) {
                  return null;
                }
              }
            }
          }
          return null;
        }
        var assign2 = Object.assign;
        var disabledDepth = 0;
        var prevLog;
        var prevInfo;
        var prevWarn;
        var prevError;
        var prevGroup;
        var prevGroupCollapsed;
        var prevGroupEnd;
        function disabledLog() {
        }
        disabledLog.__reactDisabledLog = true;
        function disableLogs() {
          {
            if (disabledDepth === 0) {
              prevLog = console.log;
              prevInfo = console.info;
              prevWarn = console.warn;
              prevError = console.error;
              prevGroup = console.group;
              prevGroupCollapsed = console.groupCollapsed;
              prevGroupEnd = console.groupEnd;
              var props = {
                configurable: true,
                enumerable: true,
                value: disabledLog,
                writable: true
              };
              Object.defineProperties(console, {
                info: props,
                log: props,
                warn: props,
                error: props,
                group: props,
                groupCollapsed: props,
                groupEnd: props
              });
            }
            disabledDepth++;
          }
        }
        function reenableLogs() {
          {
            disabledDepth--;
            if (disabledDepth === 0) {
              var props = {
                configurable: true,
                enumerable: true,
                writable: true
              };
              Object.defineProperties(console, {
                log: assign2({}, props, {
                  value: prevLog
                }),
                info: assign2({}, props, {
                  value: prevInfo
                }),
                warn: assign2({}, props, {
                  value: prevWarn
                }),
                error: assign2({}, props, {
                  value: prevError
                }),
                group: assign2({}, props, {
                  value: prevGroup
                }),
                groupCollapsed: assign2({}, props, {
                  value: prevGroupCollapsed
                }),
                groupEnd: assign2({}, props, {
                  value: prevGroupEnd
                })
              });
            }
            if (disabledDepth < 0) {
              error("disabledDepth fell below zero. This is a bug in React. Please file an issue.");
            }
          }
        }
        var ReactCurrentDispatcher = ReactSharedInternals.ReactCurrentDispatcher;
        var prefix;
        function describeBuiltInComponentFrame(name2, source, ownerFn) {
          {
            if (prefix === void 0) {
              try {
                throw Error();
              } catch (x2) {
                var match = x2.stack.trim().match(/\n( *(at )?)/);
                prefix = match && match[1] || "";
              }
            }
            return "\n" + prefix + name2;
          }
        }
        var reentry = false;
        var componentFrameCache;
        {
          var PossiblyWeakMap = typeof WeakMap === "function" ? WeakMap : Map;
          componentFrameCache = new PossiblyWeakMap();
        }
        function describeNativeComponentFrame(fn, construct) {
          if (!fn || reentry) {
            return "";
          }
          {
            var frame = componentFrameCache.get(fn);
            if (frame !== void 0) {
              return frame;
            }
          }
          var control;
          reentry = true;
          var previousPrepareStackTrace = Error.prepareStackTrace;
          Error.prepareStackTrace = void 0;
          var previousDispatcher;
          {
            previousDispatcher = ReactCurrentDispatcher.current;
            ReactCurrentDispatcher.current = null;
            disableLogs();
          }
          try {
            if (construct) {
              var Fake = function() {
                throw Error();
              };
              Object.defineProperty(Fake.prototype, "props", {
                set: function() {
                  throw Error();
                }
              });
              if (typeof Reflect === "object" && Reflect.construct) {
                try {
                  Reflect.construct(Fake, []);
                } catch (x2) {
                  control = x2;
                }
                Reflect.construct(fn, [], Fake);
              } else {
                try {
                  Fake.call();
                } catch (x2) {
                  control = x2;
                }
                fn.call(Fake.prototype);
              }
            } else {
              try {
                throw Error();
              } catch (x2) {
                control = x2;
              }
              fn();
            }
          } catch (sample) {
            if (sample && control && typeof sample.stack === "string") {
              var sampleLines = sample.stack.split("\n");
              var controlLines = control.stack.split("\n");
              var s2 = sampleLines.length - 1;
              var c2 = controlLines.length - 1;
              while (s2 >= 1 && c2 >= 0 && sampleLines[s2] !== controlLines[c2]) {
                c2--;
              }
              for (; s2 >= 1 && c2 >= 0; s2--, c2--) {
                if (sampleLines[s2] !== controlLines[c2]) {
                  if (s2 !== 1 || c2 !== 1) {
                    do {
                      s2--;
                      c2--;
                      if (c2 < 0 || sampleLines[s2] !== controlLines[c2]) {
                        var _frame = "\n" + sampleLines[s2].replace(" at new ", " at ");
                        if (fn.displayName && _frame.includes("<anonymous>")) {
                          _frame = _frame.replace("<anonymous>", fn.displayName);
                        }
                        {
                          if (typeof fn === "function") {
                            componentFrameCache.set(fn, _frame);
                          }
                        }
                        return _frame;
                      }
                    } while (s2 >= 1 && c2 >= 0);
                  }
                  break;
                }
              }
            }
          } finally {
            reentry = false;
            {
              ReactCurrentDispatcher.current = previousDispatcher;
              reenableLogs();
            }
            Error.prepareStackTrace = previousPrepareStackTrace;
          }
          var name2 = fn ? fn.displayName || fn.name : "";
          var syntheticFrame = name2 ? describeBuiltInComponentFrame(name2) : "";
          {
            if (typeof fn === "function") {
              componentFrameCache.set(fn, syntheticFrame);
            }
          }
          return syntheticFrame;
        }
        function describeFunctionComponentFrame(fn, source, ownerFn) {
          {
            return describeNativeComponentFrame(fn, false);
          }
        }
        function shouldConstruct(Component) {
          var prototype2 = Component.prototype;
          return !!(prototype2 && prototype2.isReactComponent);
        }
        function describeUnknownElementTypeFrameInDEV(type, source, ownerFn) {
          if (type == null) {
            return "";
          }
          if (typeof type === "function") {
            {
              return describeNativeComponentFrame(type, shouldConstruct(type));
            }
          }
          if (typeof type === "string") {
            return describeBuiltInComponentFrame(type);
          }
          switch (type) {
            case REACT_SUSPENSE_TYPE:
              return describeBuiltInComponentFrame("Suspense");
            case REACT_SUSPENSE_LIST_TYPE:
              return describeBuiltInComponentFrame("SuspenseList");
          }
          if (typeof type === "object") {
            switch (type.$$typeof) {
              case REACT_FORWARD_REF_TYPE:
                return describeFunctionComponentFrame(type.render);
              case REACT_MEMO_TYPE:
                return describeUnknownElementTypeFrameInDEV(type.type, source, ownerFn);
              case REACT_LAZY_TYPE: {
                var lazyComponent = type;
                var payload = lazyComponent._payload;
                var init = lazyComponent._init;
                try {
                  return describeUnknownElementTypeFrameInDEV(init(payload), source, ownerFn);
                } catch (x2) {
                }
              }
            }
          }
          return "";
        }
        var hasOwnProperty2 = Object.prototype.hasOwnProperty;
        var loggedTypeFailures = {};
        var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;
        function setCurrentlyValidatingElement(element) {
          {
            if (element) {
              var owner = element._owner;
              var stack2 = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
              ReactDebugCurrentFrame.setExtraStackFrame(stack2);
            } else {
              ReactDebugCurrentFrame.setExtraStackFrame(null);
            }
          }
        }
        function checkPropTypes(typeSpecs, values2, location, componentName, element) {
          {
            var has2 = Function.call.bind(hasOwnProperty2);
            for (var typeSpecName in typeSpecs) {
              if (has2(typeSpecs, typeSpecName)) {
                var error$1 = void 0;
                try {
                  if (typeof typeSpecs[typeSpecName] !== "function") {
                    var err = Error((componentName || "React class") + ": " + location + " type `" + typeSpecName + "` is invalid; it must be a function, usually from the `prop-types` package, but received `" + typeof typeSpecs[typeSpecName] + "`.This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.");
                    err.name = "Invariant Violation";
                    throw err;
                  }
                  error$1 = typeSpecs[typeSpecName](values2, typeSpecName, componentName, location, null, "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED");
                } catch (ex) {
                  error$1 = ex;
                }
                if (error$1 && !(error$1 instanceof Error)) {
                  setCurrentlyValidatingElement(element);
                  error("%s: type specification of %s `%s` is invalid; the type checker function must return `null` or an `Error` but returned a %s. You may have forgotten to pass an argument to the type checker creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and shape all require an argument).", componentName || "React class", location, typeSpecName, typeof error$1);
                  setCurrentlyValidatingElement(null);
                }
                if (error$1 instanceof Error && !(error$1.message in loggedTypeFailures)) {
                  loggedTypeFailures[error$1.message] = true;
                  setCurrentlyValidatingElement(element);
                  error("Failed %s type: %s", location, error$1.message);
                  setCurrentlyValidatingElement(null);
                }
              }
            }
          }
        }
        var isArrayImpl = Array.isArray;
        function isArray2(a2) {
          return isArrayImpl(a2);
        }
        function typeName2(value) {
          {
            var hasToStringTag = typeof Symbol === "function" && Symbol.toStringTag;
            var type = hasToStringTag && value[Symbol.toStringTag] || value.constructor.name || "Object";
            return type;
          }
        }
        function willCoercionThrow(value) {
          {
            try {
              testStringCoercion(value);
              return false;
            } catch (e2) {
              return true;
            }
          }
        }
        function testStringCoercion(value) {
          return "" + value;
        }
        function checkKeyStringCoercion(value) {
          {
            if (willCoercionThrow(value)) {
              error("The provided key is an unsupported type %s. This value must be coerced to a string before before using it here.", typeName2(value));
              return testStringCoercion(value);
            }
          }
        }
        var ReactCurrentOwner = ReactSharedInternals.ReactCurrentOwner;
        var RESERVED_PROPS = {
          key: true,
          ref: true,
          __self: true,
          __source: true
        };
        var specialPropKeyWarningShown;
        var specialPropRefWarningShown;
        var didWarnAboutStringRefs;
        {
          didWarnAboutStringRefs = {};
        }
        function hasValidRef(config2) {
          {
            if (hasOwnProperty2.call(config2, "ref")) {
              var getter = Object.getOwnPropertyDescriptor(config2, "ref").get;
              if (getter && getter.isReactWarning) {
                return false;
              }
            }
          }
          return config2.ref !== void 0;
        }
        function hasValidKey(config2) {
          {
            if (hasOwnProperty2.call(config2, "key")) {
              var getter = Object.getOwnPropertyDescriptor(config2, "key").get;
              if (getter && getter.isReactWarning) {
                return false;
              }
            }
          }
          return config2.key !== void 0;
        }
        function warnIfStringRefCannotBeAutoConverted(config2, self2) {
          {
            if (typeof config2.ref === "string" && ReactCurrentOwner.current && self2 && ReactCurrentOwner.current.stateNode !== self2) {
              var componentName = getComponentNameFromType(ReactCurrentOwner.current.type);
              if (!didWarnAboutStringRefs[componentName]) {
                error('Component "%s" contains the string ref "%s". Support for string refs will be removed in a future major release. This case cannot be automatically converted to an arrow function. We ask you to manually fix this case by using useRef() or createRef() instead. Learn more about using refs safely here: https://reactjs.org/link/strict-mode-string-ref', getComponentNameFromType(ReactCurrentOwner.current.type), config2.ref);
                didWarnAboutStringRefs[componentName] = true;
              }
            }
          }
        }
        function defineKeyPropWarningGetter(props, displayName) {
          {
            var warnAboutAccessingKey = function() {
              if (!specialPropKeyWarningShown) {
                specialPropKeyWarningShown = true;
                error("%s: `key` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", displayName);
              }
            };
            warnAboutAccessingKey.isReactWarning = true;
            Object.defineProperty(props, "key", {
              get: warnAboutAccessingKey,
              configurable: true
            });
          }
        }
        function defineRefPropWarningGetter(props, displayName) {
          {
            var warnAboutAccessingRef = function() {
              if (!specialPropRefWarningShown) {
                specialPropRefWarningShown = true;
                error("%s: `ref` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", displayName);
              }
            };
            warnAboutAccessingRef.isReactWarning = true;
            Object.defineProperty(props, "ref", {
              get: warnAboutAccessingRef,
              configurable: true
            });
          }
        }
        var ReactElement = function(type, key, ref2, self2, source, owner, props) {
          var element = {
            // This tag allows us to uniquely identify this as a React Element
            $$typeof: REACT_ELEMENT_TYPE,
            // Built-in properties that belong on the element
            type,
            key,
            ref: ref2,
            props,
            // Record the component responsible for creating this element.
            _owner: owner
          };
          {
            element._store = {};
            Object.defineProperty(element._store, "validated", {
              configurable: false,
              enumerable: false,
              writable: true,
              value: false
            });
            Object.defineProperty(element, "_self", {
              configurable: false,
              enumerable: false,
              writable: false,
              value: self2
            });
            Object.defineProperty(element, "_source", {
              configurable: false,
              enumerable: false,
              writable: false,
              value: source
            });
            if (Object.freeze) {
              Object.freeze(element.props);
              Object.freeze(element);
            }
          }
          return element;
        };
        function jsxDEV(type, config2, maybeKey, source, self2) {
          {
            var propName;
            var props = {};
            var key = null;
            var ref2 = null;
            if (maybeKey !== void 0) {
              {
                checkKeyStringCoercion(maybeKey);
              }
              key = "" + maybeKey;
            }
            if (hasValidKey(config2)) {
              {
                checkKeyStringCoercion(config2.key);
              }
              key = "" + config2.key;
            }
            if (hasValidRef(config2)) {
              ref2 = config2.ref;
              warnIfStringRefCannotBeAutoConverted(config2, self2);
            }
            for (propName in config2) {
              if (hasOwnProperty2.call(config2, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
                props[propName] = config2[propName];
              }
            }
            if (type && type.defaultProps) {
              var defaultProps = type.defaultProps;
              for (propName in defaultProps) {
                if (props[propName] === void 0) {
                  props[propName] = defaultProps[propName];
                }
              }
            }
            if (key || ref2) {
              var displayName = typeof type === "function" ? type.displayName || type.name || "Unknown" : type;
              if (key) {
                defineKeyPropWarningGetter(props, displayName);
              }
              if (ref2) {
                defineRefPropWarningGetter(props, displayName);
              }
            }
            return ReactElement(type, key, ref2, self2, source, ReactCurrentOwner.current, props);
          }
        }
        var ReactCurrentOwner$1 = ReactSharedInternals.ReactCurrentOwner;
        var ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;
        function setCurrentlyValidatingElement$1(element) {
          {
            if (element) {
              var owner = element._owner;
              var stack2 = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
              ReactDebugCurrentFrame$1.setExtraStackFrame(stack2);
            } else {
              ReactDebugCurrentFrame$1.setExtraStackFrame(null);
            }
          }
        }
        var propTypesMisspellWarningShown;
        {
          propTypesMisspellWarningShown = false;
        }
        function isValidElement(object) {
          {
            return typeof object === "object" && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
          }
        }
        function getDeclarationErrorAddendum() {
          {
            if (ReactCurrentOwner$1.current) {
              var name2 = getComponentNameFromType(ReactCurrentOwner$1.current.type);
              if (name2) {
                return "\n\nCheck the render method of `" + name2 + "`.";
              }
            }
            return "";
          }
        }
        function getSourceInfoErrorAddendum(source) {
          {
            if (source !== void 0) {
              var fileName = source.fileName.replace(/^.*[\\\/]/, "");
              var lineNumber = source.lineNumber;
              return "\n\nCheck your code at " + fileName + ":" + lineNumber + ".";
            }
            return "";
          }
        }
        var ownerHasKeyUseWarning = {};
        function getCurrentComponentErrorInfo(parentType) {
          {
            var info = getDeclarationErrorAddendum();
            if (!info) {
              var parentName = typeof parentType === "string" ? parentType : parentType.displayName || parentType.name;
              if (parentName) {
                info = "\n\nCheck the top-level render call using <" + parentName + ">.";
              }
            }
            return info;
          }
        }
        function validateExplicitKey(element, parentType) {
          {
            if (!element._store || element._store.validated || element.key != null) {
              return;
            }
            element._store.validated = true;
            var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);
            if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {
              return;
            }
            ownerHasKeyUseWarning[currentComponentErrorInfo] = true;
            var childOwner = "";
            if (element && element._owner && element._owner !== ReactCurrentOwner$1.current) {
              childOwner = " It was passed a child from " + getComponentNameFromType(element._owner.type) + ".";
            }
            setCurrentlyValidatingElement$1(element);
            error('Each child in a list should have a unique "key" prop.%s%s See https://reactjs.org/link/warning-keys for more information.', currentComponentErrorInfo, childOwner);
            setCurrentlyValidatingElement$1(null);
          }
        }
        function validateChildKeys(node, parentType) {
          {
            if (typeof node !== "object") {
              return;
            }
            if (isArray2(node)) {
              for (var i2 = 0; i2 < node.length; i2++) {
                var child = node[i2];
                if (isValidElement(child)) {
                  validateExplicitKey(child, parentType);
                }
              }
            } else if (isValidElement(node)) {
              if (node._store) {
                node._store.validated = true;
              }
            } else if (node) {
              var iteratorFn = getIteratorFn(node);
              if (typeof iteratorFn === "function") {
                if (iteratorFn !== node.entries) {
                  var iterator = iteratorFn.call(node);
                  var step;
                  while (!(step = iterator.next()).done) {
                    if (isValidElement(step.value)) {
                      validateExplicitKey(step.value, parentType);
                    }
                  }
                }
              }
            }
          }
        }
        function validatePropTypes(element) {
          {
            var type = element.type;
            if (type === null || type === void 0 || typeof type === "string") {
              return;
            }
            var propTypes;
            if (typeof type === "function") {
              propTypes = type.propTypes;
            } else if (typeof type === "object" && (type.$$typeof === REACT_FORWARD_REF_TYPE || // Note: Memo only checks outer props here.
            // Inner props are checked in the reconciler.
            type.$$typeof === REACT_MEMO_TYPE)) {
              propTypes = type.propTypes;
            } else {
              return;
            }
            if (propTypes) {
              var name2 = getComponentNameFromType(type);
              checkPropTypes(propTypes, element.props, "prop", name2, element);
            } else if (type.PropTypes !== void 0 && !propTypesMisspellWarningShown) {
              propTypesMisspellWarningShown = true;
              var _name = getComponentNameFromType(type);
              error("Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?", _name || "Unknown");
            }
            if (typeof type.getDefaultProps === "function" && !type.getDefaultProps.isReactClassApproved) {
              error("getDefaultProps is only used on classic React.createClass definitions. Use a static property named `defaultProps` instead.");
            }
          }
        }
        function validateFragmentProps(fragment) {
          {
            var keys = Object.keys(fragment.props);
            for (var i2 = 0; i2 < keys.length; i2++) {
              var key = keys[i2];
              if (key !== "children" && key !== "key") {
                setCurrentlyValidatingElement$1(fragment);
                error("Invalid prop `%s` supplied to `React.Fragment`. React.Fragment can only have `key` and `children` props.", key);
                setCurrentlyValidatingElement$1(null);
                break;
              }
            }
            if (fragment.ref !== null) {
              setCurrentlyValidatingElement$1(fragment);
              error("Invalid attribute `ref` supplied to `React.Fragment`.");
              setCurrentlyValidatingElement$1(null);
            }
          }
        }
        function jsxWithValidation(type, props, key, isStaticChildren, source, self2) {
          {
            var validType = isValidElementType(type);
            if (!validType) {
              var info = "";
              if (type === void 0 || typeof type === "object" && type !== null && Object.keys(type).length === 0) {
                info += " You likely forgot to export your component from the file it's defined in, or you might have mixed up default and named imports.";
              }
              var sourceInfo = getSourceInfoErrorAddendum(source);
              if (sourceInfo) {
                info += sourceInfo;
              } else {
                info += getDeclarationErrorAddendum();
              }
              var typeString;
              if (type === null) {
                typeString = "null";
              } else if (isArray2(type)) {
                typeString = "array";
              } else if (type !== void 0 && type.$$typeof === REACT_ELEMENT_TYPE) {
                typeString = "<" + (getComponentNameFromType(type.type) || "Unknown") + " />";
                info = " Did you accidentally export a JSX literal instead of a component?";
              } else {
                typeString = typeof type;
              }
              error("React.jsx: type is invalid -- expected a string (for built-in components) or a class/function (for composite components) but got: %s.%s", typeString, info);
            }
            var element = jsxDEV(type, props, key, source, self2);
            if (element == null) {
              return element;
            }
            if (validType) {
              var children = props.children;
              if (children !== void 0) {
                if (isStaticChildren) {
                  if (isArray2(children)) {
                    for (var i2 = 0; i2 < children.length; i2++) {
                      validateChildKeys(children[i2], type);
                    }
                    if (Object.freeze) {
                      Object.freeze(children);
                    }
                  } else {
                    error("React.jsx: Static children should always be an array. You are likely explicitly calling React.jsxs or React.jsxDEV. Use the Babel transform instead.");
                  }
                } else {
                  validateChildKeys(children, type);
                }
              }
            }
            if (type === REACT_FRAGMENT_TYPE) {
              validateFragmentProps(element);
            } else {
              validatePropTypes(element);
            }
            return element;
          }
        }
        function jsxWithValidationStatic(type, props, key) {
          {
            return jsxWithValidation(type, props, key, true);
          }
        }
        function jsxWithValidationDynamic(type, props, key) {
          {
            return jsxWithValidation(type, props, key, false);
          }
        }
        var jsx2 = jsxWithValidationDynamic;
        var jsxs = jsxWithValidationStatic;
        reactJsxRuntime_development.Fragment = REACT_FRAGMENT_TYPE;
        reactJsxRuntime_development.jsx = jsx2;
        reactJsxRuntime_development.jsxs = jsxs;
      })();
    }
    return reactJsxRuntime_development;
  }
  if (process.env.NODE_ENV === "production") {
    jsxRuntime.exports = requireReactJsxRuntime_production_min();
  } else {
    jsxRuntime.exports = requireReactJsxRuntime_development();
  }
  var jsxRuntimeExports = jsxRuntime.exports;
  /**
  * @vue/shared v3.4.21
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  function makeMap(str, expectsLowerCase) {
    const set2 = new Set(str.split(","));
    return expectsLowerCase ? (val) => set2.has(val.toLowerCase()) : (val) => set2.has(val);
  }
  const EMPTY_OBJ = !!(process.env.NODE_ENV !== "production") ? Object.freeze({}) : {};
  const EMPTY_ARR = !!(process.env.NODE_ENV !== "production") ? Object.freeze([]) : [];
  const NOOP = () => {
  };
  const NO = () => false;
  const isOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && // uppercase letter
  (key.charCodeAt(2) > 122 || key.charCodeAt(2) < 97);
  const isModelListener = (key) => key.startsWith("onUpdate:");
  const extend$2 = Object.assign;
  const remove$1 = (arr, el) => {
    const i2 = arr.indexOf(el);
    if (i2 > -1) {
      arr.splice(i2, 1);
    }
  };
  const hasOwnProperty$2 = Object.prototype.hasOwnProperty;
  const hasOwn = (val, key) => hasOwnProperty$2.call(val, key);
  const isArray$1 = Array.isArray;
  const isMap = (val) => toTypeString(val) === "[object Map]";
  const isSet = (val) => toTypeString(val) === "[object Set]";
  const isDate$1 = (val) => toTypeString(val) === "[object Date]";
  const isRegExp$1 = (val) => toTypeString(val) === "[object RegExp]";
  const isFunction$1 = (val) => typeof val === "function";
  const isString$1 = (val) => typeof val === "string";
  const isSymbol = (val) => typeof val === "symbol";
  const isObject$2 = (val) => val !== null && typeof val === "object";
  const isPromise = (val) => {
    return (isObject$2(val) || isFunction$1(val)) && isFunction$1(val.then) && isFunction$1(val.catch);
  };
  const objectToString = Object.prototype.toString;
  const toTypeString = (value) => objectToString.call(value);
  const toRawType = (value) => {
    return toTypeString(value).slice(8, -1);
  };
  const isPlainObject$1 = (val) => toTypeString(val) === "[object Object]";
  const isIntegerKey = (key) => isString$1(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
  const isReservedProp = /* @__PURE__ */ makeMap(
    // the leading comma is intentional so empty string "" is also included
    ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
  );
  const isBuiltInDirective = /* @__PURE__ */ makeMap(
    "bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo"
  );
  const cacheStringFunction = (fn) => {
    const cache2 = /* @__PURE__ */ Object.create(null);
    return (str) => {
      const hit = cache2[str];
      return hit || (cache2[str] = fn(str));
    };
  };
  const camelizeRE = /-(\w)/g;
  const camelize = cacheStringFunction((str) => {
    return str.replace(camelizeRE, (_2, c2) => c2 ? c2.toUpperCase() : "");
  });
  const hyphenateRE = /\B([A-Z])/g;
  const hyphenate = cacheStringFunction(
    (str) => str.replace(hyphenateRE, "-$1").toLowerCase()
  );
  const capitalize = cacheStringFunction((str) => {
    return str.charAt(0).toUpperCase() + str.slice(1);
  });
  const toHandlerKey = cacheStringFunction((str) => {
    const s2 = str ? `on${capitalize(str)}` : ``;
    return s2;
  });
  const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
  const invokeArrayFns = (fns, arg) => {
    for (let i2 = 0; i2 < fns.length; i2++) {
      fns[i2](arg);
    }
  };
  const def = (obj, key, value) => {
    Object.defineProperty(obj, key, {
      configurable: true,
      enumerable: false,
      value
    });
  };
  const looseToNumber = (val) => {
    const n2 = parseFloat(val);
    return isNaN(n2) ? val : n2;
  };
  const toNumber = (val) => {
    const n2 = isString$1(val) ? Number(val) : NaN;
    return isNaN(n2) ? val : n2;
  };
  let _globalThis;
  const getGlobalThis = () => {
    return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
  };
  const PatchFlagNames = {
    [1]: `TEXT`,
    [2]: `CLASS`,
    [4]: `STYLE`,
    [8]: `PROPS`,
    [16]: `FULL_PROPS`,
    [32]: `NEED_HYDRATION`,
    [64]: `STABLE_FRAGMENT`,
    [128]: `KEYED_FRAGMENT`,
    [256]: `UNKEYED_FRAGMENT`,
    [512]: `NEED_PATCH`,
    [1024]: `DYNAMIC_SLOTS`,
    [2048]: `DEV_ROOT_FRAGMENT`,
    [-1]: `HOISTED`,
    [-2]: `BAIL`
  };
  const slotFlagsText = {
    [1]: "STABLE",
    [2]: "DYNAMIC",
    [3]: "FORWARDED"
  };
  const GLOBALS_ALLOWED = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt,console,Error";
  const isGloballyAllowed = /* @__PURE__ */ makeMap(GLOBALS_ALLOWED);
  const range = 2;
  function generateCodeFrame(source, start = 0, end = source.length) {
    let lines = source.split(/(\r?\n)/);
    const newlineSequences = lines.filter((_2, idx) => idx % 2 === 1);
    lines = lines.filter((_2, idx) => idx % 2 === 0);
    let count = 0;
    const res = [];
    for (let i2 = 0; i2 < lines.length; i2++) {
      count += lines[i2].length + (newlineSequences[i2] && newlineSequences[i2].length || 0);
      if (count >= start) {
        for (let j2 = i2 - range; j2 <= i2 + range || end > count; j2++) {
          if (j2 < 0 || j2 >= lines.length)
            continue;
          const line = j2 + 1;
          res.push(
            `${line}${" ".repeat(Math.max(3 - String(line).length, 0))}|  ${lines[j2]}`
          );
          const lineLength = lines[j2].length;
          const newLineSeqLength = newlineSequences[j2] && newlineSequences[j2].length || 0;
          if (j2 === i2) {
            const pad = start - (count - (lineLength + newLineSeqLength));
            const length = Math.max(
              1,
              end > count ? lineLength - pad : end - start
            );
            res.push(`   |  ` + " ".repeat(pad) + "^".repeat(length));
          } else if (j2 > i2) {
            if (end > count) {
              const length = Math.max(Math.min(end - count, lineLength), 1);
              res.push(`   |  ` + "^".repeat(length));
            }
            count += lineLength + newLineSeqLength;
          }
        }
        break;
      }
    }
    return res.join("\n");
  }
  function normalizeStyle(value) {
    if (isArray$1(value)) {
      const res = {};
      for (let i2 = 0; i2 < value.length; i2++) {
        const item = value[i2];
        const normalized = isString$1(item) ? parseStringStyle(item) : normalizeStyle(item);
        if (normalized) {
          for (const key in normalized) {
            res[key] = normalized[key];
          }
        }
      }
      return res;
    } else if (isString$1(value) || isObject$2(value)) {
      return value;
    }
  }
  const listDelimiterRE = /;(?![^(]*\))/g;
  const propertyDelimiterRE = /:([^]+)/;
  const styleCommentRE = /\/\*[^]*?\*\//g;
  function parseStringStyle(cssText) {
    const ret = {};
    cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
      if (item) {
        const tmp = item.split(propertyDelimiterRE);
        tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
      }
    });
    return ret;
  }
  function stringifyStyle(styles) {
    let ret = "";
    if (!styles || isString$1(styles)) {
      return ret;
    }
    for (const key in styles) {
      const value = styles[key];
      const normalizedKey = key.startsWith(`--`) ? key : hyphenate(key);
      if (isString$1(value) || typeof value === "number") {
        ret += `${normalizedKey}:${value};`;
      }
    }
    return ret;
  }
  function normalizeClass(value) {
    let res = "";
    if (isString$1(value)) {
      res = value;
    } else if (isArray$1(value)) {
      for (let i2 = 0; i2 < value.length; i2++) {
        const normalized = normalizeClass(value[i2]);
        if (normalized) {
          res += normalized + " ";
        }
      }
    } else if (isObject$2(value)) {
      for (const name2 in value) {
        if (value[name2]) {
          res += name2 + " ";
        }
      }
    }
    return res.trim();
  }
  function normalizeProps(props) {
    if (!props)
      return null;
    let { class: klass, style } = props;
    if (klass && !isString$1(klass)) {
      props.class = normalizeClass(klass);
    }
    if (style) {
      props.style = normalizeStyle(style);
    }
    return props;
  }
  const HTML_TAGS = "html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot";
  const SVG_TAGS = "svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view";
  const MATH_TAGS = "annotation,annotation-xml,maction,maligngroup,malignmark,math,menclose,merror,mfenced,mfrac,mfraction,mglyph,mi,mlabeledtr,mlongdiv,mmultiscripts,mn,mo,mover,mpadded,mphantom,mprescripts,mroot,mrow,ms,mscarries,mscarry,msgroup,msline,mspace,msqrt,msrow,mstack,mstyle,msub,msubsup,msup,mtable,mtd,mtext,mtr,munder,munderover,none,semantics";
  const VOID_TAGS = "area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr";
  const isHTMLTag = /* @__PURE__ */ makeMap(HTML_TAGS);
  const isSVGTag = /* @__PURE__ */ makeMap(SVG_TAGS);
  const isMathMLTag = /* @__PURE__ */ makeMap(MATH_TAGS);
  const isVoidTag = /* @__PURE__ */ makeMap(VOID_TAGS);
  const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
  const isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
  const isBooleanAttr = /* @__PURE__ */ makeMap(
    specialBooleanAttrs + `,async,autofocus,autoplay,controls,default,defer,disabled,hidden,inert,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected`
  );
  function includeBooleanAttr(value) {
    return !!value || value === "";
  }
  const isKnownHtmlAttr = /* @__PURE__ */ makeMap(
    `accept,accept-charset,accesskey,action,align,allow,alt,async,autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,border,buffered,capture,challenge,charset,checked,cite,class,code,codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,formaction,formenctype,formmethod,formnovalidate,formtarget,headers,height,hidden,high,href,hreflang,http-equiv,icon,id,importance,inert,integrity,ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,start,step,style,summary,tabindex,target,title,translate,type,usemap,value,width,wrap`
  );
  const isKnownSvgAttr = /* @__PURE__ */ makeMap(
    `xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,color-interpolation-filters,color-profile,color-rendering,contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,font-family,font-size,font-size-adjust,font-stretch,font-style,font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,overflow,overline-position,overline-thickness,panose-1,paint-order,path,pathLength,patternContentUnits,patternTransform,patternUnits,ping,pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,specularConstant,specularExponent,speed,spreadMethod,startOffset,stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,string,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,text-decoration,text-rendering,textLength,to,transform,transform-origin,type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xmlns:xlink,xml:base,xml:lang,xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan`
  );
  function isRenderableAttrValue(value) {
    if (value == null) {
      return false;
    }
    const type = typeof value;
    return type === "string" || type === "number" || type === "boolean";
  }
  function looseCompareArrays(a2, b2) {
    if (a2.length !== b2.length)
      return false;
    let equal = true;
    for (let i2 = 0; equal && i2 < a2.length; i2++) {
      equal = looseEqual(a2[i2], b2[i2]);
    }
    return equal;
  }
  function looseEqual(a2, b2) {
    if (a2 === b2)
      return true;
    let aValidType = isDate$1(a2);
    let bValidType = isDate$1(b2);
    if (aValidType || bValidType) {
      return aValidType && bValidType ? a2.getTime() === b2.getTime() : false;
    }
    aValidType = isSymbol(a2);
    bValidType = isSymbol(b2);
    if (aValidType || bValidType) {
      return a2 === b2;
    }
    aValidType = isArray$1(a2);
    bValidType = isArray$1(b2);
    if (aValidType || bValidType) {
      return aValidType && bValidType ? looseCompareArrays(a2, b2) : false;
    }
    aValidType = isObject$2(a2);
    bValidType = isObject$2(b2);
    if (aValidType || bValidType) {
      if (!aValidType || !bValidType) {
        return false;
      }
      const aKeysCount = Object.keys(a2).length;
      const bKeysCount = Object.keys(b2).length;
      if (aKeysCount !== bKeysCount) {
        return false;
      }
      for (const key in a2) {
        const aHasKey = a2.hasOwnProperty(key);
        const bHasKey = b2.hasOwnProperty(key);
        if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a2[key], b2[key])) {
          return false;
        }
      }
    }
    return String(a2) === String(b2);
  }
  function looseIndexOf(arr, val) {
    return arr.findIndex((item) => looseEqual(item, val));
  }
  const toDisplayString = (val) => {
    return isString$1(val) ? val : val == null ? "" : isArray$1(val) || isObject$2(val) && (val.toString === objectToString || !isFunction$1(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
  };
  const replacer = (_key, val) => {
    if (val && val.__v_isRef) {
      return replacer(_key, val.value);
    } else if (isMap(val)) {
      return {
        [`Map(${val.size})`]: [...val.entries()].reduce(
          (entries, [key, val2], i2) => {
            entries[stringifySymbol(key, i2) + " =>"] = val2;
            return entries;
          },
          {}
        )
      };
    } else if (isSet(val)) {
      return {
        [`Set(${val.size})`]: [...val.values()].map((v2) => stringifySymbol(v2))
      };
    } else if (isSymbol(val)) {
      return stringifySymbol(val);
    } else if (isObject$2(val) && !isArray$1(val) && !isPlainObject$1(val)) {
      return String(val);
    }
    return val;
  };
  const stringifySymbol = (v2, i2 = "") => {
    var _a2;
    return isSymbol(v2) ? `Symbol(${(_a2 = v2.description) != null ? _a2 : i2})` : v2;
  };
  /**
  * @vue/reactivity v3.4.21
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  function warn$2(msg, ...args) {
    console.warn(`[Vue warn] ${msg}`, ...args);
  }
  let activeEffectScope;
  class EffectScope {
    constructor(detached = false) {
      this.detached = detached;
      this._active = true;
      this.effects = [];
      this.cleanups = [];
      this.parent = activeEffectScope;
      if (!detached && activeEffectScope) {
        this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(
          this
        ) - 1;
      }
    }
    get active() {
      return this._active;
    }
    run(fn) {
      if (this._active) {
        const currentEffectScope = activeEffectScope;
        try {
          activeEffectScope = this;
          return fn();
        } finally {
          activeEffectScope = currentEffectScope;
        }
      } else if (!!(process.env.NODE_ENV !== "production")) {
        warn$2(`cannot run an inactive effect scope.`);
      }
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    on() {
      activeEffectScope = this;
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    off() {
      activeEffectScope = this.parent;
    }
    stop(fromParent) {
      if (this._active) {
        let i2, l2;
        for (i2 = 0, l2 = this.effects.length; i2 < l2; i2++) {
          this.effects[i2].stop();
        }
        for (i2 = 0, l2 = this.cleanups.length; i2 < l2; i2++) {
          this.cleanups[i2]();
        }
        if (this.scopes) {
          for (i2 = 0, l2 = this.scopes.length; i2 < l2; i2++) {
            this.scopes[i2].stop(true);
          }
        }
        if (!this.detached && this.parent && !fromParent) {
          const last = this.parent.scopes.pop();
          if (last && last !== this) {
            this.parent.scopes[this.index] = last;
            last.index = this.index;
          }
        }
        this.parent = void 0;
        this._active = false;
      }
    }
  }
  function effectScope(detached) {
    return new EffectScope(detached);
  }
  function recordEffectScope(effect2, scope = activeEffectScope) {
    if (scope && scope.active) {
      scope.effects.push(effect2);
    }
  }
  function getCurrentScope() {
    return activeEffectScope;
  }
  function onScopeDispose(fn) {
    if (activeEffectScope) {
      activeEffectScope.cleanups.push(fn);
    } else if (!!(process.env.NODE_ENV !== "production")) {
      warn$2(
        `onScopeDispose() is called when there is no active effect scope to be associated with.`
      );
    }
  }
  let activeEffect;
  class ReactiveEffect {
    constructor(fn, trigger2, scheduler, scope) {
      this.fn = fn;
      this.trigger = trigger2;
      this.scheduler = scheduler;
      this.active = true;
      this.deps = [];
      this._dirtyLevel = 4;
      this._trackId = 0;
      this._runnings = 0;
      this._shouldSchedule = false;
      this._depsLength = 0;
      recordEffectScope(this, scope);
    }
    get dirty() {
      if (this._dirtyLevel === 2 || this._dirtyLevel === 3) {
        this._dirtyLevel = 1;
        pauseTracking();
        for (let i2 = 0; i2 < this._depsLength; i2++) {
          const dep = this.deps[i2];
          if (dep.computed) {
            triggerComputed(dep.computed);
            if (this._dirtyLevel >= 4) {
              break;
            }
          }
        }
        if (this._dirtyLevel === 1) {
          this._dirtyLevel = 0;
        }
        resetTracking();
      }
      return this._dirtyLevel >= 4;
    }
    set dirty(v2) {
      this._dirtyLevel = v2 ? 4 : 0;
    }
    run() {
      this._dirtyLevel = 0;
      if (!this.active) {
        return this.fn();
      }
      let lastShouldTrack = shouldTrack;
      let lastEffect = activeEffect;
      try {
        shouldTrack = true;
        activeEffect = this;
        this._runnings++;
        preCleanupEffect(this);
        return this.fn();
      } finally {
        postCleanupEffect(this);
        this._runnings--;
        activeEffect = lastEffect;
        shouldTrack = lastShouldTrack;
      }
    }
    stop() {
      var _a2;
      if (this.active) {
        preCleanupEffect(this);
        postCleanupEffect(this);
        (_a2 = this.onStop) == null ? void 0 : _a2.call(this);
        this.active = false;
      }
    }
  }
  function triggerComputed(computed2) {
    return computed2.value;
  }
  function preCleanupEffect(effect2) {
    effect2._trackId++;
    effect2._depsLength = 0;
  }
  function postCleanupEffect(effect2) {
    if (effect2.deps.length > effect2._depsLength) {
      for (let i2 = effect2._depsLength; i2 < effect2.deps.length; i2++) {
        cleanupDepEffect(effect2.deps[i2], effect2);
      }
      effect2.deps.length = effect2._depsLength;
    }
  }
  function cleanupDepEffect(dep, effect2) {
    const trackId = dep.get(effect2);
    if (trackId !== void 0 && effect2._trackId !== trackId) {
      dep.delete(effect2);
      if (dep.size === 0) {
        dep.cleanup();
      }
    }
  }
  function effect(fn, options) {
    if (fn.effect instanceof ReactiveEffect) {
      fn = fn.effect.fn;
    }
    const _effect = new ReactiveEffect(fn, NOOP, () => {
      if (_effect.dirty) {
        _effect.run();
      }
    });
    if (options) {
      extend$2(_effect, options);
      if (options.scope)
        recordEffectScope(_effect, options.scope);
    }
    if (!options || !options.lazy) {
      _effect.run();
    }
    const runner = _effect.run.bind(_effect);
    runner.effect = _effect;
    return runner;
  }
  function stop(runner) {
    runner.effect.stop();
  }
  let shouldTrack = true;
  let pauseScheduleStack = 0;
  const trackStack = [];
  function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
  }
  function resetTracking() {
    const last = trackStack.pop();
    shouldTrack = last === void 0 ? true : last;
  }
  function pauseScheduling() {
    pauseScheduleStack++;
  }
  function resetScheduling() {
    pauseScheduleStack--;
    while (!pauseScheduleStack && queueEffectSchedulers.length) {
      queueEffectSchedulers.shift()();
    }
  }
  function trackEffect(effect2, dep, debuggerEventExtraInfo) {
    var _a2;
    if (dep.get(effect2) !== effect2._trackId) {
      dep.set(effect2, effect2._trackId);
      const oldDep = effect2.deps[effect2._depsLength];
      if (oldDep !== dep) {
        if (oldDep) {
          cleanupDepEffect(oldDep, effect2);
        }
        effect2.deps[effect2._depsLength++] = dep;
      } else {
        effect2._depsLength++;
      }
      if (!!(process.env.NODE_ENV !== "production")) {
        (_a2 = effect2.onTrack) == null ? void 0 : _a2.call(effect2, extend$2({ effect: effect2 }, debuggerEventExtraInfo));
      }
    }
  }
  const queueEffectSchedulers = [];
  function triggerEffects(dep, dirtyLevel, debuggerEventExtraInfo) {
    var _a2;
    pauseScheduling();
    for (const effect2 of dep.keys()) {
      let tracking;
      if (effect2._dirtyLevel < dirtyLevel && (tracking != null ? tracking : tracking = dep.get(effect2) === effect2._trackId)) {
        effect2._shouldSchedule || (effect2._shouldSchedule = effect2._dirtyLevel === 0);
        effect2._dirtyLevel = dirtyLevel;
      }
      if (effect2._shouldSchedule && (tracking != null ? tracking : tracking = dep.get(effect2) === effect2._trackId)) {
        if (!!(process.env.NODE_ENV !== "production")) {
          (_a2 = effect2.onTrigger) == null ? void 0 : _a2.call(effect2, extend$2({ effect: effect2 }, debuggerEventExtraInfo));
        }
        effect2.trigger();
        if ((!effect2._runnings || effect2.allowRecurse) && effect2._dirtyLevel !== 2) {
          effect2._shouldSchedule = false;
          if (effect2.scheduler) {
            queueEffectSchedulers.push(effect2.scheduler);
          }
        }
      }
    }
    resetScheduling();
  }
  const createDep = (cleanup, computed2) => {
    const dep = /* @__PURE__ */ new Map();
    dep.cleanup = cleanup;
    dep.computed = computed2;
    return dep;
  };
  const targetMap = /* @__PURE__ */ new WeakMap();
  const ITERATE_KEY = Symbol(!!(process.env.NODE_ENV !== "production") ? "iterate" : "");
  const MAP_KEY_ITERATE_KEY = Symbol(!!(process.env.NODE_ENV !== "production") ? "Map key iterate" : "");
  function track(target, type, key) {
    if (shouldTrack && activeEffect) {
      let depsMap = targetMap.get(target);
      if (!depsMap) {
        targetMap.set(target, depsMap = /* @__PURE__ */ new Map());
      }
      let dep = depsMap.get(key);
      if (!dep) {
        depsMap.set(key, dep = createDep(() => depsMap.delete(key)));
      }
      trackEffect(
        activeEffect,
        dep,
        !!(process.env.NODE_ENV !== "production") ? {
          target,
          type,
          key
        } : void 0
      );
    }
  }
  function trigger(target, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target);
    if (!depsMap) {
      return;
    }
    let deps = [];
    if (type === "clear") {
      deps = [...depsMap.values()];
    } else if (key === "length" && isArray$1(target)) {
      const newLength = Number(newValue);
      depsMap.forEach((dep, key2) => {
        if (key2 === "length" || !isSymbol(key2) && key2 >= newLength) {
          deps.push(dep);
        }
      });
    } else {
      if (key !== void 0) {
        deps.push(depsMap.get(key));
      }
      switch (type) {
        case "add":
          if (!isArray$1(target)) {
            deps.push(depsMap.get(ITERATE_KEY));
            if (isMap(target)) {
              deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          } else if (isIntegerKey(key)) {
            deps.push(depsMap.get("length"));
          }
          break;
        case "delete":
          if (!isArray$1(target)) {
            deps.push(depsMap.get(ITERATE_KEY));
            if (isMap(target)) {
              deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          }
          break;
        case "set":
          if (isMap(target)) {
            deps.push(depsMap.get(ITERATE_KEY));
          }
          break;
      }
    }
    pauseScheduling();
    for (const dep of deps) {
      if (dep) {
        triggerEffects(
          dep,
          4,
          !!(process.env.NODE_ENV !== "production") ? {
            target,
            type,
            key,
            newValue,
            oldValue,
            oldTarget
          } : void 0
        );
      }
    }
    resetScheduling();
  }
  function getDepFromReactive(object, key) {
    var _a2;
    return (_a2 = targetMap.get(object)) == null ? void 0 : _a2.get(key);
  }
  const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
  const builtInSymbols = new Set(
    /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((key) => key !== "arguments" && key !== "caller").map((key) => Symbol[key]).filter(isSymbol)
  );
  const arrayInstrumentations = /* @__PURE__ */ createArrayInstrumentations();
  function createArrayInstrumentations() {
    const instrumentations = {};
    ["includes", "indexOf", "lastIndexOf"].forEach((key) => {
      instrumentations[key] = function(...args) {
        const arr = toRaw(this);
        for (let i2 = 0, l2 = this.length; i2 < l2; i2++) {
          track(arr, "get", i2 + "");
        }
        const res = arr[key](...args);
        if (res === -1 || res === false) {
          return arr[key](...args.map(toRaw));
        } else {
          return res;
        }
      };
    });
    ["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
      instrumentations[key] = function(...args) {
        pauseTracking();
        pauseScheduling();
        const res = toRaw(this)[key].apply(this, args);
        resetScheduling();
        resetTracking();
        return res;
      };
    });
    return instrumentations;
  }
  function hasOwnProperty$1(key) {
    const obj = toRaw(this);
    track(obj, "has", key);
    return obj.hasOwnProperty(key);
  }
  class BaseReactiveHandler {
    constructor(_isReadonly = false, _isShallow = false) {
      this._isReadonly = _isReadonly;
      this._isShallow = _isShallow;
    }
    get(target, key, receiver) {
      const isReadonly2 = this._isReadonly, isShallow2 = this._isShallow;
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_isShallow") {
        return isShallow2;
      } else if (key === "__v_raw") {
        if (receiver === (isReadonly2 ? isShallow2 ? shallowReadonlyMap : readonlyMap : isShallow2 ? shallowReactiveMap : reactiveMap).get(target) || // receiver is not the reactive proxy, but has the same prototype
        // this means the reciever is a user proxy of the reactive proxy
        Object.getPrototypeOf(target) === Object.getPrototypeOf(receiver)) {
          return target;
        }
        return;
      }
      const targetIsArray = isArray$1(target);
      if (!isReadonly2) {
        if (targetIsArray && hasOwn(arrayInstrumentations, key)) {
          return Reflect.get(arrayInstrumentations, key, receiver);
        }
        if (key === "hasOwnProperty") {
          return hasOwnProperty$1;
        }
      }
      const res = Reflect.get(target, key, receiver);
      if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
        return res;
      }
      if (!isReadonly2) {
        track(target, "get", key);
      }
      if (isShallow2) {
        return res;
      }
      if (isRef(res)) {
        return targetIsArray && isIntegerKey(key) ? res : res.value;
      }
      if (isObject$2(res)) {
        return isReadonly2 ? readonly(res) : reactive(res);
      }
      return res;
    }
  }
  class MutableReactiveHandler extends BaseReactiveHandler {
    constructor(isShallow2 = false) {
      super(false, isShallow2);
    }
    set(target, key, value, receiver) {
      let oldValue = target[key];
      if (!this._isShallow) {
        const isOldValueReadonly = isReadonly(oldValue);
        if (!isShallow(value) && !isReadonly(value)) {
          oldValue = toRaw(oldValue);
          value = toRaw(value);
        }
        if (!isArray$1(target) && isRef(oldValue) && !isRef(value)) {
          if (isOldValueReadonly) {
            return false;
          } else {
            oldValue.value = value;
            return true;
          }
        }
      }
      const hadKey = isArray$1(target) && isIntegerKey(key) ? Number(key) < target.length : hasOwn(target, key);
      const result = Reflect.set(target, key, value, receiver);
      if (target === toRaw(receiver)) {
        if (!hadKey) {
          trigger(target, "add", key, value);
        } else if (hasChanged(value, oldValue)) {
          trigger(target, "set", key, value, oldValue);
        }
      }
      return result;
    }
    deleteProperty(target, key) {
      const hadKey = hasOwn(target, key);
      const oldValue = target[key];
      const result = Reflect.deleteProperty(target, key);
      if (result && hadKey) {
        trigger(target, "delete", key, void 0, oldValue);
      }
      return result;
    }
    has(target, key) {
      const result = Reflect.has(target, key);
      if (!isSymbol(key) || !builtInSymbols.has(key)) {
        track(target, "has", key);
      }
      return result;
    }
    ownKeys(target) {
      track(
        target,
        "iterate",
        isArray$1(target) ? "length" : ITERATE_KEY
      );
      return Reflect.ownKeys(target);
    }
  }
  class ReadonlyReactiveHandler extends BaseReactiveHandler {
    constructor(isShallow2 = false) {
      super(true, isShallow2);
    }
    set(target, key) {
      if (!!(process.env.NODE_ENV !== "production")) {
        warn$2(
          `Set operation on key "${String(key)}" failed: target is readonly.`,
          target
        );
      }
      return true;
    }
    deleteProperty(target, key) {
      if (!!(process.env.NODE_ENV !== "production")) {
        warn$2(
          `Delete operation on key "${String(key)}" failed: target is readonly.`,
          target
        );
      }
      return true;
    }
  }
  const mutableHandlers = /* @__PURE__ */ new MutableReactiveHandler();
  const readonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler();
  const shallowReactiveHandlers = /* @__PURE__ */ new MutableReactiveHandler(
    true
  );
  const shallowReadonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler(true);
  const toShallow = (value) => value;
  const getProto = (v2) => Reflect.getPrototypeOf(v2);
  function get(target, key, isReadonly2 = false, isShallow2 = false) {
    target = target["__v_raw"];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (!isReadonly2) {
      if (hasChanged(key, rawKey)) {
        track(rawTarget, "get", key);
      }
      track(rawTarget, "get", rawKey);
    }
    const { has: has2 } = getProto(rawTarget);
    const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    if (has2.call(rawTarget, key)) {
      return wrap(target.get(key));
    } else if (has2.call(rawTarget, rawKey)) {
      return wrap(target.get(rawKey));
    } else if (target !== rawTarget) {
      target.get(key);
    }
  }
  function has(key, isReadonly2 = false) {
    const target = this["__v_raw"];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (!isReadonly2) {
      if (hasChanged(key, rawKey)) {
        track(rawTarget, "has", key);
      }
      track(rawTarget, "has", rawKey);
    }
    return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
  }
  function size(target, isReadonly2 = false) {
    target = target["__v_raw"];
    !isReadonly2 && track(toRaw(target), "iterate", ITERATE_KEY);
    return Reflect.get(target, "size", target);
  }
  function add(value) {
    value = toRaw(value);
    const target = toRaw(this);
    const proto = getProto(target);
    const hadKey = proto.has.call(target, value);
    if (!hadKey) {
      target.add(value);
      trigger(target, "add", value, value);
    }
    return this;
  }
  function set(key, value) {
    value = toRaw(value);
    const target = toRaw(this);
    const { has: has2, get: get2 } = getProto(target);
    let hadKey = has2.call(target, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target, key);
    } else if (!!(process.env.NODE_ENV !== "production")) {
      checkIdentityKeys(target, has2, key);
    }
    const oldValue = get2.call(target, key);
    target.set(key, value);
    if (!hadKey) {
      trigger(target, "add", key, value);
    } else if (hasChanged(value, oldValue)) {
      trigger(target, "set", key, value, oldValue);
    }
    return this;
  }
  function deleteEntry(key) {
    const target = toRaw(this);
    const { has: has2, get: get2 } = getProto(target);
    let hadKey = has2.call(target, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target, key);
    } else if (!!(process.env.NODE_ENV !== "production")) {
      checkIdentityKeys(target, has2, key);
    }
    const oldValue = get2 ? get2.call(target, key) : void 0;
    const result = target.delete(key);
    if (hadKey) {
      trigger(target, "delete", key, void 0, oldValue);
    }
    return result;
  }
  function clear() {
    const target = toRaw(this);
    const hadItems = target.size !== 0;
    const oldTarget = !!(process.env.NODE_ENV !== "production") ? isMap(target) ? new Map(target) : new Set(target) : void 0;
    const result = target.clear();
    if (hadItems) {
      trigger(target, "clear", void 0, void 0, oldTarget);
    }
    return result;
  }
  function createForEach(isReadonly2, isShallow2) {
    return function forEach2(callback, thisArg) {
      const observed = this;
      const target = observed["__v_raw"];
      const rawTarget = toRaw(target);
      const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
      !isReadonly2 && track(rawTarget, "iterate", ITERATE_KEY);
      return target.forEach((value, key) => {
        return callback.call(thisArg, wrap(value), wrap(key), observed);
      });
    };
  }
  function createIterableMethod(method, isReadonly2, isShallow2) {
    return function(...args) {
      const target = this["__v_raw"];
      const rawTarget = toRaw(target);
      const targetIsMap = isMap(rawTarget);
      const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
      const isKeyOnly = method === "keys" && targetIsMap;
      const innerIterator = target[method](...args);
      const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
      !isReadonly2 && track(
        rawTarget,
        "iterate",
        isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY
      );
      return {
        // iterator protocol
        next() {
          const { value, done } = innerIterator.next();
          return done ? { value, done } : {
            value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
            done
          };
        },
        // iterable protocol
        [Symbol.iterator]() {
          return this;
        }
      };
    };
  }
  function createReadonlyMethod(type) {
    return function(...args) {
      if (!!(process.env.NODE_ENV !== "production")) {
        const key = args[0] ? `on key "${args[0]}" ` : ``;
        warn$2(
          `${capitalize(type)} operation ${key}failed: target is readonly.`,
          toRaw(this)
        );
      }
      return type === "delete" ? false : type === "clear" ? void 0 : this;
    };
  }
  function createInstrumentations() {
    const mutableInstrumentations2 = {
      get(key) {
        return get(this, key);
      },
      get size() {
        return size(this);
      },
      has,
      add,
      set,
      delete: deleteEntry,
      clear,
      forEach: createForEach(false, false)
    };
    const shallowInstrumentations2 = {
      get(key) {
        return get(this, key, false, true);
      },
      get size() {
        return size(this);
      },
      has,
      add,
      set,
      delete: deleteEntry,
      clear,
      forEach: createForEach(false, true)
    };
    const readonlyInstrumentations2 = {
      get(key) {
        return get(this, key, true);
      },
      get size() {
        return size(this, true);
      },
      has(key) {
        return has.call(this, key, true);
      },
      add: createReadonlyMethod("add"),
      set: createReadonlyMethod("set"),
      delete: createReadonlyMethod("delete"),
      clear: createReadonlyMethod("clear"),
      forEach: createForEach(true, false)
    };
    const shallowReadonlyInstrumentations2 = {
      get(key) {
        return get(this, key, true, true);
      },
      get size() {
        return size(this, true);
      },
      has(key) {
        return has.call(this, key, true);
      },
      add: createReadonlyMethod("add"),
      set: createReadonlyMethod("set"),
      delete: createReadonlyMethod("delete"),
      clear: createReadonlyMethod("clear"),
      forEach: createForEach(true, true)
    };
    const iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
    iteratorMethods.forEach((method) => {
      mutableInstrumentations2[method] = createIterableMethod(
        method,
        false,
        false
      );
      readonlyInstrumentations2[method] = createIterableMethod(
        method,
        true,
        false
      );
      shallowInstrumentations2[method] = createIterableMethod(
        method,
        false,
        true
      );
      shallowReadonlyInstrumentations2[method] = createIterableMethod(
        method,
        true,
        true
      );
    });
    return [
      mutableInstrumentations2,
      readonlyInstrumentations2,
      shallowInstrumentations2,
      shallowReadonlyInstrumentations2
    ];
  }
  const [
    mutableInstrumentations,
    readonlyInstrumentations,
    shallowInstrumentations,
    shallowReadonlyInstrumentations
  ] = /* @__PURE__ */ createInstrumentations();
  function createInstrumentationGetter(isReadonly2, shallow) {
    const instrumentations = shallow ? isReadonly2 ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly2 ? readonlyInstrumentations : mutableInstrumentations;
    return (target, key, receiver) => {
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_raw") {
        return target;
      }
      return Reflect.get(
        hasOwn(instrumentations, key) && key in target ? instrumentations : target,
        key,
        receiver
      );
    };
  }
  const mutableCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, false)
  };
  const shallowCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, true)
  };
  const readonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, false)
  };
  const shallowReadonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, true)
  };
  function checkIdentityKeys(target, has2, key) {
    const rawKey = toRaw(key);
    if (rawKey !== key && has2.call(target, rawKey)) {
      const type = toRawType(target);
      warn$2(
        `Reactive ${type} contains both the raw and reactive versions of the same object${type === `Map` ? ` as keys` : ``}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`
      );
    }
  }
  const reactiveMap = /* @__PURE__ */ new WeakMap();
  const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
  const readonlyMap = /* @__PURE__ */ new WeakMap();
  const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
  function targetTypeMap(rawType) {
    switch (rawType) {
      case "Object":
      case "Array":
        return 1;
      case "Map":
      case "Set":
      case "WeakMap":
      case "WeakSet":
        return 2;
      default:
        return 0;
    }
  }
  function getTargetType(value) {
    return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType(value));
  }
  function reactive(target) {
    if (isReadonly(target)) {
      return target;
    }
    return createReactiveObject(
      target,
      false,
      mutableHandlers,
      mutableCollectionHandlers,
      reactiveMap
    );
  }
  function shallowReactive(target) {
    return createReactiveObject(
      target,
      false,
      shallowReactiveHandlers,
      shallowCollectionHandlers,
      shallowReactiveMap
    );
  }
  function readonly(target) {
    return createReactiveObject(
      target,
      true,
      readonlyHandlers,
      readonlyCollectionHandlers,
      readonlyMap
    );
  }
  function shallowReadonly(target) {
    return createReactiveObject(
      target,
      true,
      shallowReadonlyHandlers,
      shallowReadonlyCollectionHandlers,
      shallowReadonlyMap
    );
  }
  function createReactiveObject(target, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
    if (!isObject$2(target)) {
      if (!!(process.env.NODE_ENV !== "production")) {
        warn$2(`value cannot be made reactive: ${String(target)}`);
      }
      return target;
    }
    if (target["__v_raw"] && !(isReadonly2 && target["__v_isReactive"])) {
      return target;
    }
    const existingProxy = proxyMap.get(target);
    if (existingProxy) {
      return existingProxy;
    }
    const targetType = getTargetType(target);
    if (targetType === 0) {
      return target;
    }
    const proxy = new Proxy(
      target,
      targetType === 2 ? collectionHandlers : baseHandlers
    );
    proxyMap.set(target, proxy);
    return proxy;
  }
  function isReactive(value) {
    if (isReadonly(value)) {
      return isReactive(value["__v_raw"]);
    }
    return !!(value && value["__v_isReactive"]);
  }
  function isReadonly(value) {
    return !!(value && value["__v_isReadonly"]);
  }
  function isShallow(value) {
    return !!(value && value["__v_isShallow"]);
  }
  function isProxy(value) {
    return isReactive(value) || isReadonly(value);
  }
  function toRaw(observed) {
    const raw = observed && observed["__v_raw"];
    return raw ? toRaw(raw) : observed;
  }
  function markRaw(value) {
    if (Object.isExtensible(value)) {
      def(value, "__v_skip", true);
    }
    return value;
  }
  const toReactive = (value) => isObject$2(value) ? reactive(value) : value;
  const toReadonly = (value) => isObject$2(value) ? readonly(value) : value;
  const COMPUTED_SIDE_EFFECT_WARN = `Computed is still dirty after getter evaluation, likely because a computed is mutating its own dependency in its getter. State mutations in computed getters should be avoided.  Check the docs for more details: https://vuejs.org/guide/essentials/computed.html#getters-should-be-side-effect-free`;
  class ComputedRefImpl {
    constructor(getter, _setter, isReadonly2, isSSR) {
      this.getter = getter;
      this._setter = _setter;
      this.dep = void 0;
      this.__v_isRef = true;
      this["__v_isReadonly"] = false;
      this.effect = new ReactiveEffect(
        () => getter(this._value),
        () => triggerRefValue(
          this,
          this.effect._dirtyLevel === 2 ? 2 : 3
        )
      );
      this.effect.computed = this;
      this.effect.active = this._cacheable = !isSSR;
      this["__v_isReadonly"] = isReadonly2;
    }
    get value() {
      const self2 = toRaw(this);
      if ((!self2._cacheable || self2.effect.dirty) && hasChanged(self2._value, self2._value = self2.effect.run())) {
        triggerRefValue(self2, 4);
      }
      trackRefValue(self2);
      if (self2.effect._dirtyLevel >= 2) {
        if (!!(process.env.NODE_ENV !== "production") && this._warnRecursive) {
          warn$2(COMPUTED_SIDE_EFFECT_WARN, `

getter: `, this.getter);
        }
        triggerRefValue(self2, 2);
      }
      return self2._value;
    }
    set value(newValue) {
      this._setter(newValue);
    }
    // #region polyfill _dirty for backward compatibility third party code for Vue <= 3.3.x
    get _dirty() {
      return this.effect.dirty;
    }
    set _dirty(v2) {
      this.effect.dirty = v2;
    }
    // #endregion
  }
  function computed$1(getterOrOptions, debugOptions, isSSR = false) {
    let getter;
    let setter;
    const onlyGetter = isFunction$1(getterOrOptions);
    if (onlyGetter) {
      getter = getterOrOptions;
      setter = !!(process.env.NODE_ENV !== "production") ? () => {
        warn$2("Write operation failed: computed value is readonly");
      } : NOOP;
    } else {
      getter = getterOrOptions.get;
      setter = getterOrOptions.set;
    }
    const cRef = new ComputedRefImpl(getter, setter, onlyGetter || !setter, isSSR);
    if (!!(process.env.NODE_ENV !== "production") && debugOptions && !isSSR) {
      cRef.effect.onTrack = debugOptions.onTrack;
      cRef.effect.onTrigger = debugOptions.onTrigger;
    }
    return cRef;
  }
  function trackRefValue(ref2) {
    var _a2;
    if (shouldTrack && activeEffect) {
      ref2 = toRaw(ref2);
      trackEffect(
        activeEffect,
        (_a2 = ref2.dep) != null ? _a2 : ref2.dep = createDep(
          () => ref2.dep = void 0,
          ref2 instanceof ComputedRefImpl ? ref2 : void 0
        ),
        !!(process.env.NODE_ENV !== "production") ? {
          target: ref2,
          type: "get",
          key: "value"
        } : void 0
      );
    }
  }
  function triggerRefValue(ref2, dirtyLevel = 4, newVal) {
    ref2 = toRaw(ref2);
    const dep = ref2.dep;
    if (dep) {
      triggerEffects(
        dep,
        dirtyLevel,
        !!(process.env.NODE_ENV !== "production") ? {
          target: ref2,
          type: "set",
          key: "value",
          newValue: newVal
        } : void 0
      );
    }
  }
  function isRef(r2) {
    return !!(r2 && r2.__v_isRef === true);
  }
  function ref(value) {
    return createRef(value, false);
  }
  function shallowRef(value) {
    return createRef(value, true);
  }
  function createRef(rawValue, shallow) {
    if (isRef(rawValue)) {
      return rawValue;
    }
    return new RefImpl(rawValue, shallow);
  }
  class RefImpl {
    constructor(value, __v_isShallow) {
      this.__v_isShallow = __v_isShallow;
      this.dep = void 0;
      this.__v_isRef = true;
      this._rawValue = __v_isShallow ? value : toRaw(value);
      this._value = __v_isShallow ? value : toReactive(value);
    }
    get value() {
      trackRefValue(this);
      return this._value;
    }
    set value(newVal) {
      const useDirectValue = this.__v_isShallow || isShallow(newVal) || isReadonly(newVal);
      newVal = useDirectValue ? newVal : toRaw(newVal);
      if (hasChanged(newVal, this._rawValue)) {
        this._rawValue = newVal;
        this._value = useDirectValue ? newVal : toReactive(newVal);
        triggerRefValue(this, 4, newVal);
      }
    }
  }
  function triggerRef(ref2) {
    triggerRefValue(ref2, 4, !!(process.env.NODE_ENV !== "production") ? ref2.value : void 0);
  }
  function unref(ref2) {
    return isRef(ref2) ? ref2.value : ref2;
  }
  function toValue$2(source) {
    return isFunction$1(source) ? source() : unref(source);
  }
  const shallowUnwrapHandlers = {
    get: (target, key, receiver) => unref(Reflect.get(target, key, receiver)),
    set: (target, key, value, receiver) => {
      const oldValue = target[key];
      if (isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      } else {
        return Reflect.set(target, key, value, receiver);
      }
    }
  };
  function proxyRefs(objectWithRefs) {
    return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
  }
  class CustomRefImpl {
    constructor(factory) {
      this.dep = void 0;
      this.__v_isRef = true;
      const { get: get2, set: set2 } = factory(
        () => trackRefValue(this),
        () => triggerRefValue(this)
      );
      this._get = get2;
      this._set = set2;
    }
    get value() {
      return this._get();
    }
    set value(newVal) {
      this._set(newVal);
    }
  }
  function customRef(factory) {
    return new CustomRefImpl(factory);
  }
  function toRefs(object) {
    if (!!(process.env.NODE_ENV !== "production") && !isProxy(object)) {
      warn$2(`toRefs() expects a reactive object but received a plain one.`);
    }
    const ret = isArray$1(object) ? new Array(object.length) : {};
    for (const key in object) {
      ret[key] = propertyToRef(object, key);
    }
    return ret;
  }
  class ObjectRefImpl {
    constructor(_object, _key, _defaultValue) {
      this._object = _object;
      this._key = _key;
      this._defaultValue = _defaultValue;
      this.__v_isRef = true;
    }
    get value() {
      const val = this._object[this._key];
      return val === void 0 ? this._defaultValue : val;
    }
    set value(newVal) {
      this._object[this._key] = newVal;
    }
    get dep() {
      return getDepFromReactive(toRaw(this._object), this._key);
    }
  }
  class GetterRefImpl {
    constructor(_getter) {
      this._getter = _getter;
      this.__v_isRef = true;
      this.__v_isReadonly = true;
    }
    get value() {
      return this._getter();
    }
  }
  function toRef(source, key, defaultValue) {
    if (isRef(source)) {
      return source;
    } else if (isFunction$1(source)) {
      return new GetterRefImpl(source);
    } else if (isObject$2(source) && arguments.length > 1) {
      return propertyToRef(source, key, defaultValue);
    } else {
      return ref(source);
    }
  }
  function propertyToRef(source, key, defaultValue) {
    const val = source[key];
    return isRef(val) ? val : new ObjectRefImpl(source, key, defaultValue);
  }
  const TrackOpTypes = {
    "GET": "get",
    "HAS": "has",
    "ITERATE": "iterate"
  };
  const TriggerOpTypes = {
    "SET": "set",
    "ADD": "add",
    "DELETE": "delete",
    "CLEAR": "clear"
  };
  /**
  * @vue/runtime-core v3.4.21
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  const stack$1 = [];
  function pushWarningContext(vnode) {
    stack$1.push(vnode);
  }
  function popWarningContext() {
    stack$1.pop();
  }
  function warn$1(msg, ...args) {
    pauseTracking();
    const instance = stack$1.length ? stack$1[stack$1.length - 1].component : null;
    const appWarnHandler = instance && instance.appContext.config.warnHandler;
    const trace = getComponentTrace();
    if (appWarnHandler) {
      callWithErrorHandling(
        appWarnHandler,
        instance,
        11,
        [
          msg + args.map((a2) => {
            var _a2, _b;
            return (_b = (_a2 = a2.toString) == null ? void 0 : _a2.call(a2)) != null ? _b : JSON.stringify(a2);
          }).join(""),
          instance && instance.proxy,
          trace.map(
            ({ vnode }) => `at <${formatComponentName(instance, vnode.type)}>`
          ).join("\n"),
          trace
        ]
      );
    } else {
      const warnArgs = [`[Vue warn]: ${msg}`, ...args];
      if (trace.length && // avoid spamming console during tests
      true) {
        warnArgs.push(`
`, ...formatTrace(trace));
      }
      console.warn(...warnArgs);
    }
    resetTracking();
  }
  function getComponentTrace() {
    let currentVNode = stack$1[stack$1.length - 1];
    if (!currentVNode) {
      return [];
    }
    const normalizedStack = [];
    while (currentVNode) {
      const last = normalizedStack[0];
      if (last && last.vnode === currentVNode) {
        last.recurseCount++;
      } else {
        normalizedStack.push({
          vnode: currentVNode,
          recurseCount: 0
        });
      }
      const parentInstance = currentVNode.component && currentVNode.component.parent;
      currentVNode = parentInstance && parentInstance.vnode;
    }
    return normalizedStack;
  }
  function formatTrace(trace) {
    const logs = [];
    trace.forEach((entry, i2) => {
      logs.push(...i2 === 0 ? [] : [`
`], ...formatTraceEntry(entry));
    });
    return logs;
  }
  function formatTraceEntry({ vnode, recurseCount }) {
    const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;
    const isRoot = vnode.component ? vnode.component.parent == null : false;
    const open = ` at <${formatComponentName(
      vnode.component,
      vnode.type,
      isRoot
    )}`;
    const close = `>` + postfix;
    return vnode.props ? [open, ...formatProps(vnode.props), close] : [open + close];
  }
  function formatProps(props) {
    const res = [];
    const keys = Object.keys(props);
    keys.slice(0, 3).forEach((key) => {
      res.push(...formatProp(key, props[key]));
    });
    if (keys.length > 3) {
      res.push(` ...`);
    }
    return res;
  }
  function formatProp(key, value, raw) {
    if (isString$1(value)) {
      value = JSON.stringify(value);
      return raw ? value : [`${key}=${value}`];
    } else if (typeof value === "number" || typeof value === "boolean" || value == null) {
      return raw ? value : [`${key}=${value}`];
    } else if (isRef(value)) {
      value = formatProp(key, toRaw(value.value), true);
      return raw ? value : [`${key}=Ref<`, value, `>`];
    } else if (isFunction$1(value)) {
      return [`${key}=fn${value.name ? `<${value.name}>` : ``}`];
    } else {
      value = toRaw(value);
      return raw ? value : [`${key}=`, value];
    }
  }
  function assertNumber(val, type) {
    if (!!!(process.env.NODE_ENV !== "production"))
      return;
    if (val === void 0) {
      return;
    } else if (typeof val !== "number") {
      warn$1(`${type} is not a valid number - got ${JSON.stringify(val)}.`);
    } else if (isNaN(val)) {
      warn$1(`${type} is NaN - the duration expression might be incorrect.`);
    }
  }
  const ErrorCodes = {
    "SETUP_FUNCTION": 0,
    "0": "SETUP_FUNCTION",
    "RENDER_FUNCTION": 1,
    "1": "RENDER_FUNCTION",
    "WATCH_GETTER": 2,
    "2": "WATCH_GETTER",
    "WATCH_CALLBACK": 3,
    "3": "WATCH_CALLBACK",
    "WATCH_CLEANUP": 4,
    "4": "WATCH_CLEANUP",
    "NATIVE_EVENT_HANDLER": 5,
    "5": "NATIVE_EVENT_HANDLER",
    "COMPONENT_EVENT_HANDLER": 6,
    "6": "COMPONENT_EVENT_HANDLER",
    "VNODE_HOOK": 7,
    "7": "VNODE_HOOK",
    "DIRECTIVE_HOOK": 8,
    "8": "DIRECTIVE_HOOK",
    "TRANSITION_HOOK": 9,
    "9": "TRANSITION_HOOK",
    "APP_ERROR_HANDLER": 10,
    "10": "APP_ERROR_HANDLER",
    "APP_WARN_HANDLER": 11,
    "11": "APP_WARN_HANDLER",
    "FUNCTION_REF": 12,
    "12": "FUNCTION_REF",
    "ASYNC_COMPONENT_LOADER": 13,
    "13": "ASYNC_COMPONENT_LOADER",
    "SCHEDULER": 14,
    "14": "SCHEDULER"
  };
  const ErrorTypeStrings$1 = {
    ["sp"]: "serverPrefetch hook",
    ["bc"]: "beforeCreate hook",
    ["c"]: "created hook",
    ["bm"]: "beforeMount hook",
    ["m"]: "mounted hook",
    ["bu"]: "beforeUpdate hook",
    ["u"]: "updated",
    ["bum"]: "beforeUnmount hook",
    ["um"]: "unmounted hook",
    ["a"]: "activated hook",
    ["da"]: "deactivated hook",
    ["ec"]: "errorCaptured hook",
    ["rtc"]: "renderTracked hook",
    ["rtg"]: "renderTriggered hook",
    [0]: "setup function",
    [1]: "render function",
    [2]: "watcher getter",
    [3]: "watcher callback",
    [4]: "watcher cleanup function",
    [5]: "native event handler",
    [6]: "component event handler",
    [7]: "vnode hook",
    [8]: "directive hook",
    [9]: "transition hook",
    [10]: "app errorHandler",
    [11]: "app warnHandler",
    [12]: "ref function",
    [13]: "async component loader",
    [14]: "scheduler flush. This is likely a Vue internals bug. Please open an issue at https://github.com/vuejs/core ."
  };
  function callWithErrorHandling(fn, instance, type, args) {
    try {
      return args ? fn(...args) : fn();
    } catch (err) {
      handleError(err, instance, type);
    }
  }
  function callWithAsyncErrorHandling(fn, instance, type, args) {
    if (isFunction$1(fn)) {
      const res = callWithErrorHandling(fn, instance, type, args);
      if (res && isPromise(res)) {
        res.catch((err) => {
          handleError(err, instance, type);
        });
      }
      return res;
    }
    const values2 = [];
    for (let i2 = 0; i2 < fn.length; i2++) {
      values2.push(callWithAsyncErrorHandling(fn[i2], instance, type, args));
    }
    return values2;
  }
  function handleError(err, instance, type, throwInDev = true) {
    const contextVNode = instance ? instance.vnode : null;
    if (instance) {
      let cur2 = instance.parent;
      const exposedInstance = instance.proxy;
      const errorInfo = !!(process.env.NODE_ENV !== "production") ? ErrorTypeStrings$1[type] : `https://vuejs.org/error-reference/#runtime-${type}`;
      while (cur2) {
        const errorCapturedHooks = cur2.ec;
        if (errorCapturedHooks) {
          for (let i2 = 0; i2 < errorCapturedHooks.length; i2++) {
            if (errorCapturedHooks[i2](err, exposedInstance, errorInfo) === false) {
              return;
            }
          }
        }
        cur2 = cur2.parent;
      }
      const appErrorHandler = instance.appContext.config.errorHandler;
      if (appErrorHandler) {
        callWithErrorHandling(
          appErrorHandler,
          null,
          10,
          [err, exposedInstance, errorInfo]
        );
        return;
      }
    }
    logError(err, type, contextVNode, throwInDev);
  }
  function logError(err, type, contextVNode, throwInDev = true) {
    if (!!(process.env.NODE_ENV !== "production")) {
      const info = ErrorTypeStrings$1[type];
      if (contextVNode) {
        pushWarningContext(contextVNode);
      }
      warn$1(`Unhandled error${info ? ` during execution of ${info}` : ``}`);
      if (contextVNode) {
        popWarningContext();
      }
      if (throwInDev) {
        throw err;
      } else {
        console.error(err);
      }
    } else {
      console.error(err);
    }
  }
  let isFlushing = false;
  let isFlushPending = false;
  const queue = [];
  let flushIndex = 0;
  const pendingPostFlushCbs = [];
  let activePostFlushCbs = null;
  let postFlushIndex = 0;
  const resolvedPromise = /* @__PURE__ */ Promise.resolve();
  let currentFlushPromise = null;
  const RECURSION_LIMIT = 100;
  function nextTick(fn) {
    const p2 = currentFlushPromise || resolvedPromise;
    return fn ? p2.then(this ? fn.bind(this) : fn) : p2;
  }
  function findInsertionIndex(id2) {
    let start = flushIndex + 1;
    let end = queue.length;
    while (start < end) {
      const middle = start + end >>> 1;
      const middleJob = queue[middle];
      const middleJobId = getId(middleJob);
      if (middleJobId < id2 || middleJobId === id2 && middleJob.pre) {
        start = middle + 1;
      } else {
        end = middle;
      }
    }
    return start;
  }
  function queueJob(job) {
    if (!queue.length || !queue.includes(
      job,
      isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex
    )) {
      if (job.id == null) {
        queue.push(job);
      } else {
        queue.splice(findInsertionIndex(job.id), 0, job);
      }
      queueFlush();
    }
  }
  function queueFlush() {
    if (!isFlushing && !isFlushPending) {
      isFlushPending = true;
      currentFlushPromise = resolvedPromise.then(flushJobs);
    }
  }
  function invalidateJob(job) {
    const i2 = queue.indexOf(job);
    if (i2 > flushIndex) {
      queue.splice(i2, 1);
    }
  }
  function queuePostFlushCb(cb) {
    if (!isArray$1(cb)) {
      if (!activePostFlushCbs || !activePostFlushCbs.includes(
        cb,
        cb.allowRecurse ? postFlushIndex + 1 : postFlushIndex
      )) {
        pendingPostFlushCbs.push(cb);
      }
    } else {
      pendingPostFlushCbs.push(...cb);
    }
    queueFlush();
  }
  function flushPreFlushCbs(instance, seen2, i2 = isFlushing ? flushIndex + 1 : 0) {
    if (!!(process.env.NODE_ENV !== "production")) {
      seen2 = seen2 || /* @__PURE__ */ new Map();
    }
    for (; i2 < queue.length; i2++) {
      const cb = queue[i2];
      if (cb && cb.pre) {
        if (instance && cb.id !== instance.uid) {
          continue;
        }
        if (!!(process.env.NODE_ENV !== "production") && checkRecursiveUpdates(seen2, cb)) {
          continue;
        }
        queue.splice(i2, 1);
        i2--;
        cb();
      }
    }
  }
  function flushPostFlushCbs(seen2) {
    if (pendingPostFlushCbs.length) {
      const deduped = [...new Set(pendingPostFlushCbs)].sort(
        (a2, b2) => getId(a2) - getId(b2)
      );
      pendingPostFlushCbs.length = 0;
      if (activePostFlushCbs) {
        activePostFlushCbs.push(...deduped);
        return;
      }
      activePostFlushCbs = deduped;
      if (!!(process.env.NODE_ENV !== "production")) {
        seen2 = seen2 || /* @__PURE__ */ new Map();
      }
      for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
        if (!!(process.env.NODE_ENV !== "production") && checkRecursiveUpdates(seen2, activePostFlushCbs[postFlushIndex])) {
          continue;
        }
        activePostFlushCbs[postFlushIndex]();
      }
      activePostFlushCbs = null;
      postFlushIndex = 0;
    }
  }
  const getId = (job) => job.id == null ? Infinity : job.id;
  const comparator = (a2, b2) => {
    const diff = getId(a2) - getId(b2);
    if (diff === 0) {
      if (a2.pre && !b2.pre)
        return -1;
      if (b2.pre && !a2.pre)
        return 1;
    }
    return diff;
  };
  function flushJobs(seen2) {
    isFlushPending = false;
    isFlushing = true;
    if (!!(process.env.NODE_ENV !== "production")) {
      seen2 = seen2 || /* @__PURE__ */ new Map();
    }
    queue.sort(comparator);
    const check = !!(process.env.NODE_ENV !== "production") ? (job) => checkRecursiveUpdates(seen2, job) : NOOP;
    try {
      for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
        const job = queue[flushIndex];
        if (job && job.active !== false) {
          if (!!(process.env.NODE_ENV !== "production") && check(job)) {
            continue;
          }
          callWithErrorHandling(job, null, 14);
        }
      }
    } finally {
      flushIndex = 0;
      queue.length = 0;
      flushPostFlushCbs(seen2);
      isFlushing = false;
      currentFlushPromise = null;
      if (queue.length || pendingPostFlushCbs.length) {
        flushJobs(seen2);
      }
    }
  }
  function checkRecursiveUpdates(seen2, fn) {
    if (!seen2.has(fn)) {
      seen2.set(fn, 1);
    } else {
      const count = seen2.get(fn);
      if (count > RECURSION_LIMIT) {
        const instance = fn.ownerInstance;
        const componentName = instance && getComponentName(instance.type);
        handleError(
          `Maximum recursive updates exceeded${componentName ? ` in component <${componentName}>` : ``}. This means you have a reactive effect that is mutating its own dependencies and thus recursively triggering itself. Possible sources include component template, render function, updated hook or watcher source function.`,
          null,
          10
        );
        return true;
      } else {
        seen2.set(fn, count + 1);
      }
    }
  }
  let isHmrUpdating = false;
  const hmrDirtyComponents = /* @__PURE__ */ new Set();
  if (!!(process.env.NODE_ENV !== "production")) {
    getGlobalThis().__VUE_HMR_RUNTIME__ = {
      createRecord: tryWrap(createRecord),
      rerender: tryWrap(rerender),
      reload: tryWrap(reload)
    };
  }
  const map = /* @__PURE__ */ new Map();
  function registerHMR(instance) {
    const id2 = instance.type.__hmrId;
    let record = map.get(id2);
    if (!record) {
      createRecord(id2, instance.type);
      record = map.get(id2);
    }
    record.instances.add(instance);
  }
  function unregisterHMR(instance) {
    map.get(instance.type.__hmrId).instances.delete(instance);
  }
  function createRecord(id2, initialDef) {
    if (map.has(id2)) {
      return false;
    }
    map.set(id2, {
      initialDef: normalizeClassComponent(initialDef),
      instances: /* @__PURE__ */ new Set()
    });
    return true;
  }
  function normalizeClassComponent(component) {
    return isClassComponent(component) ? component.__vccOpts : component;
  }
  function rerender(id2, newRender) {
    const record = map.get(id2);
    if (!record) {
      return;
    }
    record.initialDef.render = newRender;
    [...record.instances].forEach((instance) => {
      if (newRender) {
        instance.render = newRender;
        normalizeClassComponent(instance.type).render = newRender;
      }
      instance.renderCache = [];
      isHmrUpdating = true;
      instance.effect.dirty = true;
      instance.update();
      isHmrUpdating = false;
    });
  }
  function reload(id2, newComp) {
    const record = map.get(id2);
    if (!record)
      return;
    newComp = normalizeClassComponent(newComp);
    updateComponentDef(record.initialDef, newComp);
    const instances = [...record.instances];
    for (const instance of instances) {
      const oldComp = normalizeClassComponent(instance.type);
      if (!hmrDirtyComponents.has(oldComp)) {
        if (oldComp !== record.initialDef) {
          updateComponentDef(oldComp, newComp);
        }
        hmrDirtyComponents.add(oldComp);
      }
      instance.appContext.propsCache.delete(instance.type);
      instance.appContext.emitsCache.delete(instance.type);
      instance.appContext.optionsCache.delete(instance.type);
      if (instance.ceReload) {
        hmrDirtyComponents.add(oldComp);
        instance.ceReload(newComp.styles);
        hmrDirtyComponents.delete(oldComp);
      } else if (instance.parent) {
        instance.parent.effect.dirty = true;
        queueJob(instance.parent.update);
      } else if (instance.appContext.reload) {
        instance.appContext.reload();
      } else if (typeof window !== "undefined") {
        window.location.reload();
      } else {
        console.warn(
          "[HMR] Root or manually mounted instance modified. Full reload required."
        );
      }
    }
    queuePostFlushCb(() => {
      for (const instance of instances) {
        hmrDirtyComponents.delete(
          normalizeClassComponent(instance.type)
        );
      }
    });
  }
  function updateComponentDef(oldComp, newComp) {
    extend$2(oldComp, newComp);
    for (const key in oldComp) {
      if (key !== "__file" && !(key in newComp)) {
        delete oldComp[key];
      }
    }
  }
  function tryWrap(fn) {
    return (id2, arg) => {
      try {
        return fn(id2, arg);
      } catch (e2) {
        console.error(e2);
        console.warn(
          `[HMR] Something went wrong during Vue component hot-reload. Full reload required.`
        );
      }
    };
  }
  let devtools$1;
  let buffer = [];
  let devtoolsNotInstalled = false;
  function emit$1(event, ...args) {
    if (devtools$1) {
      devtools$1.emit(event, ...args);
    } else if (!devtoolsNotInstalled) {
      buffer.push({ event, args });
    }
  }
  function setDevtoolsHook$1(hook, target) {
    var _a2, _b;
    devtools$1 = hook;
    if (devtools$1) {
      devtools$1.enabled = true;
      buffer.forEach(({ event, args }) => devtools$1.emit(event, ...args));
      buffer = [];
    } else if (
      // handle late devtools injection - only do this if we are in an actual
      // browser environment to avoid the timer handle stalling test runner exit
      // (#4815)
      typeof window !== "undefined" && // some envs mock window but not fully
      window.HTMLElement && // also exclude jsdom
      !((_b = (_a2 = window.navigator) == null ? void 0 : _a2.userAgent) == null ? void 0 : _b.includes("jsdom"))
    ) {
      const replay = target.__VUE_DEVTOOLS_HOOK_REPLAY__ = target.__VUE_DEVTOOLS_HOOK_REPLAY__ || [];
      replay.push((newHook) => {
        setDevtoolsHook$1(newHook, target);
      });
      setTimeout(() => {
        if (!devtools$1) {
          target.__VUE_DEVTOOLS_HOOK_REPLAY__ = null;
          devtoolsNotInstalled = true;
          buffer = [];
        }
      }, 3e3);
    } else {
      devtoolsNotInstalled = true;
      buffer = [];
    }
  }
  function devtoolsInitApp(app, version2) {
    emit$1("app:init", app, version2, {
      Fragment,
      Text: Text$2,
      Comment: Comment$1,
      Static
    });
  }
  function devtoolsUnmountApp(app) {
    emit$1("app:unmount", app);
  }
  const devtoolsComponentAdded = /* @__PURE__ */ createDevtoolsComponentHook(
    "component:added"
    /* COMPONENT_ADDED */
  );
  const devtoolsComponentUpdated = /* @__PURE__ */ createDevtoolsComponentHook(
    "component:updated"
    /* COMPONENT_UPDATED */
  );
  const _devtoolsComponentRemoved = /* @__PURE__ */ createDevtoolsComponentHook(
    "component:removed"
    /* COMPONENT_REMOVED */
  );
  const devtoolsComponentRemoved = (component) => {
    if (devtools$1 && typeof devtools$1.cleanupBuffer === "function" && // remove the component if it wasn't buffered
    !devtools$1.cleanupBuffer(component)) {
      _devtoolsComponentRemoved(component);
    }
  };
  function createDevtoolsComponentHook(hook) {
    return (component) => {
      emit$1(
        hook,
        component.appContext.app,
        component.uid,
        component.parent ? component.parent.uid : void 0,
        component
      );
    };
  }
  const devtoolsPerfStart = /* @__PURE__ */ createDevtoolsPerformanceHook(
    "perf:start"
    /* PERFORMANCE_START */
  );
  const devtoolsPerfEnd = /* @__PURE__ */ createDevtoolsPerformanceHook(
    "perf:end"
    /* PERFORMANCE_END */
  );
  function createDevtoolsPerformanceHook(hook) {
    return (component, type, time) => {
      emit$1(hook, component.appContext.app, component.uid, component, type, time);
    };
  }
  function devtoolsComponentEmit(component, event, params) {
    emit$1(
      "component:emit",
      component.appContext.app,
      component,
      event,
      params
    );
  }
  function emit(instance, event, ...rawArgs) {
    if (instance.isUnmounted)
      return;
    const props = instance.vnode.props || EMPTY_OBJ;
    if (!!(process.env.NODE_ENV !== "production")) {
      const {
        emitsOptions,
        propsOptions: [propsOptions]
      } = instance;
      if (emitsOptions) {
        if (!(event in emitsOptions) && true) {
          if (!propsOptions || !(toHandlerKey(event) in propsOptions)) {
            warn$1(
              `Component emitted event "${event}" but it is neither declared in the emits option nor as an "${toHandlerKey(event)}" prop.`
            );
          }
        } else {
          const validator2 = emitsOptions[event];
          if (isFunction$1(validator2)) {
            const isValid = validator2(...rawArgs);
            if (!isValid) {
              warn$1(
                `Invalid event arguments: event validation failed for event "${event}".`
              );
            }
          }
        }
      }
    }
    let args = rawArgs;
    const isModelListener2 = event.startsWith("update:");
    const modelArg = isModelListener2 && event.slice(7);
    if (modelArg && modelArg in props) {
      const modifiersKey = `${modelArg === "modelValue" ? "model" : modelArg}Modifiers`;
      const { number: number2, trim: trim2 } = props[modifiersKey] || EMPTY_OBJ;
      if (trim2) {
        args = rawArgs.map((a2) => isString$1(a2) ? a2.trim() : a2);
      }
      if (number2) {
        args = rawArgs.map(looseToNumber);
      }
    }
    if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
      devtoolsComponentEmit(instance, event, args);
    }
    if (!!(process.env.NODE_ENV !== "production")) {
      const lowerCaseEvent = event.toLowerCase();
      if (lowerCaseEvent !== event && props[toHandlerKey(lowerCaseEvent)]) {
        warn$1(
          `Event "${lowerCaseEvent}" is emitted in component ${formatComponentName(
            instance,
            instance.type
          )} but the handler is registered for "${event}". Note that HTML attributes are case-insensitive and you cannot use v-on to listen to camelCase events when using in-DOM templates. You should probably use "${hyphenate(
            event
          )}" instead of "${event}".`
        );
      }
    }
    let handlerName;
    let handler = props[handlerName = toHandlerKey(event)] || // also try camelCase event handler (#2249)
    props[handlerName = toHandlerKey(camelize(event))];
    if (!handler && isModelListener2) {
      handler = props[handlerName = toHandlerKey(hyphenate(event))];
    }
    if (handler) {
      callWithAsyncErrorHandling(
        handler,
        instance,
        6,
        args
      );
    }
    const onceHandler = props[handlerName + `Once`];
    if (onceHandler) {
      if (!instance.emitted) {
        instance.emitted = {};
      } else if (instance.emitted[handlerName]) {
        return;
      }
      instance.emitted[handlerName] = true;
      callWithAsyncErrorHandling(
        onceHandler,
        instance,
        6,
        args
      );
    }
  }
  function normalizeEmitsOptions(comp, appContext, asMixin = false) {
    const cache2 = appContext.emitsCache;
    const cached = cache2.get(comp);
    if (cached !== void 0) {
      return cached;
    }
    const raw = comp.emits;
    let normalized = {};
    let hasExtends = false;
    if (__VUE_OPTIONS_API__ && !isFunction$1(comp)) {
      const extendEmits = (raw2) => {
        const normalizedFromExtend = normalizeEmitsOptions(raw2, appContext, true);
        if (normalizedFromExtend) {
          hasExtends = true;
          extend$2(normalized, normalizedFromExtend);
        }
      };
      if (!asMixin && appContext.mixins.length) {
        appContext.mixins.forEach(extendEmits);
      }
      if (comp.extends) {
        extendEmits(comp.extends);
      }
      if (comp.mixins) {
        comp.mixins.forEach(extendEmits);
      }
    }
    if (!raw && !hasExtends) {
      if (isObject$2(comp)) {
        cache2.set(comp, null);
      }
      return null;
    }
    if (isArray$1(raw)) {
      raw.forEach((key) => normalized[key] = null);
    } else {
      extend$2(normalized, raw);
    }
    if (isObject$2(comp)) {
      cache2.set(comp, normalized);
    }
    return normalized;
  }
  function isEmitListener(options, key) {
    if (!options || !isOn(key)) {
      return false;
    }
    key = key.slice(2).replace(/Once$/, "");
    return hasOwn(options, key[0].toLowerCase() + key.slice(1)) || hasOwn(options, hyphenate(key)) || hasOwn(options, key);
  }
  let currentRenderingInstance = null;
  let currentScopeId = null;
  function setCurrentRenderingInstance(instance) {
    const prev = currentRenderingInstance;
    currentRenderingInstance = instance;
    currentScopeId = instance && instance.type.__scopeId || null;
    return prev;
  }
  function pushScopeId(id2) {
    currentScopeId = id2;
  }
  function popScopeId() {
    currentScopeId = null;
  }
  const withScopeId = (_id) => withCtx;
  function withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot) {
    if (!ctx)
      return fn;
    if (fn._n) {
      return fn;
    }
    const renderFnWithContext = (...args) => {
      if (renderFnWithContext._d) {
        setBlockTracking(-1);
      }
      const prevInstance = setCurrentRenderingInstance(ctx);
      let res;
      try {
        res = fn(...args);
      } finally {
        setCurrentRenderingInstance(prevInstance);
        if (renderFnWithContext._d) {
          setBlockTracking(1);
        }
      }
      if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
        devtoolsComponentUpdated(ctx);
      }
      return res;
    };
    renderFnWithContext._n = true;
    renderFnWithContext._c = true;
    renderFnWithContext._d = true;
    return renderFnWithContext;
  }
  let accessedAttrs = false;
  function markAttrsAccessed() {
    accessedAttrs = true;
  }
  function renderComponentRoot(instance) {
    const {
      type: Component,
      vnode,
      proxy,
      withProxy,
      props,
      propsOptions: [propsOptions],
      slots,
      attrs,
      emit: emit2,
      render: render2,
      renderCache,
      data,
      setupState,
      ctx,
      inheritAttrs
    } = instance;
    let result;
    let fallthroughAttrs;
    const prev = setCurrentRenderingInstance(instance);
    if (!!(process.env.NODE_ENV !== "production")) {
      accessedAttrs = false;
    }
    try {
      if (vnode.shapeFlag & 4) {
        const proxyToUse = withProxy || proxy;
        const thisProxy = !!(process.env.NODE_ENV !== "production") && setupState.__isScriptSetup ? new Proxy(proxyToUse, {
          get(target, key, receiver) {
            warn$1(
              `Property '${String(
                key
              )}' was accessed via 'this'. Avoid using 'this' in templates.`
            );
            return Reflect.get(target, key, receiver);
          }
        }) : proxyToUse;
        result = normalizeVNode(
          render2.call(
            thisProxy,
            proxyToUse,
            renderCache,
            props,
            setupState,
            data,
            ctx
          )
        );
        fallthroughAttrs = attrs;
      } else {
        const render22 = Component;
        if (!!(process.env.NODE_ENV !== "production") && attrs === props) {
          markAttrsAccessed();
        }
        result = normalizeVNode(
          render22.length > 1 ? render22(
            props,
            !!(process.env.NODE_ENV !== "production") ? {
              get attrs() {
                markAttrsAccessed();
                return attrs;
              },
              slots,
              emit: emit2
            } : { attrs, slots, emit: emit2 }
          ) : render22(
            props,
            null
            /* we know it doesn't need it */
          )
        );
        fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
      }
    } catch (err) {
      blockStack.length = 0;
      handleError(err, instance, 1);
      result = createVNode(Comment$1);
    }
    let root = result;
    let setRoot = void 0;
    if (!!(process.env.NODE_ENV !== "production") && result.patchFlag > 0 && result.patchFlag & 2048) {
      [root, setRoot] = getChildRoot(result);
    }
    if (fallthroughAttrs && inheritAttrs !== false) {
      const keys = Object.keys(fallthroughAttrs);
      const { shapeFlag } = root;
      if (keys.length) {
        if (shapeFlag & (1 | 6)) {
          if (propsOptions && keys.some(isModelListener)) {
            fallthroughAttrs = filterModelListeners(
              fallthroughAttrs,
              propsOptions
            );
          }
          root = cloneVNode(root, fallthroughAttrs);
        } else if (!!(process.env.NODE_ENV !== "production") && !accessedAttrs && root.type !== Comment$1) {
          const allAttrs = Object.keys(attrs);
          const eventAttrs = [];
          const extraAttrs = [];
          for (let i2 = 0, l2 = allAttrs.length; i2 < l2; i2++) {
            const key = allAttrs[i2];
            if (isOn(key)) {
              if (!isModelListener(key)) {
                eventAttrs.push(key[2].toLowerCase() + key.slice(3));
              }
            } else {
              extraAttrs.push(key);
            }
          }
          if (extraAttrs.length) {
            warn$1(
              `Extraneous non-props attributes (${extraAttrs.join(", ")}) were passed to component but could not be automatically inherited because component renders fragment or text root nodes.`
            );
          }
          if (eventAttrs.length) {
            warn$1(
              `Extraneous non-emits event listeners (${eventAttrs.join(", ")}) were passed to component but could not be automatically inherited because component renders fragment or text root nodes. If the listener is intended to be a component custom event listener only, declare it using the "emits" option.`
            );
          }
        }
      }
    }
    if (vnode.dirs) {
      if (!!(process.env.NODE_ENV !== "production") && !isElementRoot(root)) {
        warn$1(
          `Runtime directive used on component with non-element root node. The directives will not function as intended.`
        );
      }
      root = cloneVNode(root);
      root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;
    }
    if (vnode.transition) {
      if (!!(process.env.NODE_ENV !== "production") && !isElementRoot(root)) {
        warn$1(
          `Component inside <Transition> renders non-element root node that cannot be animated.`
        );
      }
      root.transition = vnode.transition;
    }
    if (!!(process.env.NODE_ENV !== "production") && setRoot) {
      setRoot(root);
    } else {
      result = root;
    }
    setCurrentRenderingInstance(prev);
    return result;
  }
  const getChildRoot = (vnode) => {
    const rawChildren = vnode.children;
    const dynamicChildren = vnode.dynamicChildren;
    const childRoot = filterSingleRoot(rawChildren, false);
    if (!childRoot) {
      return [vnode, void 0];
    } else if (!!(process.env.NODE_ENV !== "production") && childRoot.patchFlag > 0 && childRoot.patchFlag & 2048) {
      return getChildRoot(childRoot);
    }
    const index2 = rawChildren.indexOf(childRoot);
    const dynamicIndex = dynamicChildren ? dynamicChildren.indexOf(childRoot) : -1;
    const setRoot = (updatedRoot) => {
      rawChildren[index2] = updatedRoot;
      if (dynamicChildren) {
        if (dynamicIndex > -1) {
          dynamicChildren[dynamicIndex] = updatedRoot;
        } else if (updatedRoot.patchFlag > 0) {
          vnode.dynamicChildren = [...dynamicChildren, updatedRoot];
        }
      }
    };
    return [normalizeVNode(childRoot), setRoot];
  };
  function filterSingleRoot(children, recurse = true) {
    let singleRoot;
    for (let i2 = 0; i2 < children.length; i2++) {
      const child = children[i2];
      if (isVNode(child)) {
        if (child.type !== Comment$1 || child.children === "v-if") {
          if (singleRoot) {
            return;
          } else {
            singleRoot = child;
            if (!!(process.env.NODE_ENV !== "production") && recurse && singleRoot.patchFlag > 0 && singleRoot.patchFlag & 2048) {
              return filterSingleRoot(singleRoot.children);
            }
          }
        }
      } else {
        return;
      }
    }
    return singleRoot;
  }
  const getFunctionalFallthrough = (attrs) => {
    let res;
    for (const key in attrs) {
      if (key === "class" || key === "style" || isOn(key)) {
        (res || (res = {}))[key] = attrs[key];
      }
    }
    return res;
  };
  const filterModelListeners = (attrs, props) => {
    const res = {};
    for (const key in attrs) {
      if (!isModelListener(key) || !(key.slice(9) in props)) {
        res[key] = attrs[key];
      }
    }
    return res;
  };
  const isElementRoot = (vnode) => {
    return vnode.shapeFlag & (6 | 1) || vnode.type === Comment$1;
  };
  function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
    const { props: prevProps, children: prevChildren, component } = prevVNode;
    const { props: nextProps, children: nextChildren, patchFlag } = nextVNode;
    const emits = component.emitsOptions;
    if (!!(process.env.NODE_ENV !== "production") && (prevChildren || nextChildren) && isHmrUpdating) {
      return true;
    }
    if (nextVNode.dirs || nextVNode.transition) {
      return true;
    }
    if (optimized && patchFlag >= 0) {
      if (patchFlag & 1024) {
        return true;
      }
      if (patchFlag & 16) {
        if (!prevProps) {
          return !!nextProps;
        }
        return hasPropsChanged(prevProps, nextProps, emits);
      } else if (patchFlag & 8) {
        const dynamicProps = nextVNode.dynamicProps;
        for (let i2 = 0; i2 < dynamicProps.length; i2++) {
          const key = dynamicProps[i2];
          if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) {
            return true;
          }
        }
      }
    } else {
      if (prevChildren || nextChildren) {
        if (!nextChildren || !nextChildren.$stable) {
          return true;
        }
      }
      if (prevProps === nextProps) {
        return false;
      }
      if (!prevProps) {
        return !!nextProps;
      }
      if (!nextProps) {
        return true;
      }
      return hasPropsChanged(prevProps, nextProps, emits);
    }
    return false;
  }
  function hasPropsChanged(prevProps, nextProps, emitsOptions) {
    const nextKeys = Object.keys(nextProps);
    if (nextKeys.length !== Object.keys(prevProps).length) {
      return true;
    }
    for (let i2 = 0; i2 < nextKeys.length; i2++) {
      const key = nextKeys[i2];
      if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) {
        return true;
      }
    }
    return false;
  }
  function updateHOCHostEl({ vnode, parent }, el) {
    while (parent) {
      const root = parent.subTree;
      if (root.suspense && root.suspense.activeBranch === vnode) {
        root.el = vnode.el;
      }
      if (root === vnode) {
        (vnode = parent.vnode).el = el;
        parent = parent.parent;
      } else {
        break;
      }
    }
  }
  const COMPONENTS = "components";
  const DIRECTIVES = "directives";
  function resolveComponent(name2, maybeSelfReference) {
    return resolveAsset(COMPONENTS, name2, true, maybeSelfReference) || name2;
  }
  const NULL_DYNAMIC_COMPONENT = Symbol.for("v-ndc");
  function resolveDynamicComponent(component) {
    if (isString$1(component)) {
      return resolveAsset(COMPONENTS, component, false) || component;
    } else {
      return component || NULL_DYNAMIC_COMPONENT;
    }
  }
  function resolveDirective(name2) {
    return resolveAsset(DIRECTIVES, name2);
  }
  function resolveAsset(type, name2, warnMissing = true, maybeSelfReference = false) {
    const instance = currentRenderingInstance || currentInstance;
    if (instance) {
      const Component = instance.type;
      if (type === COMPONENTS) {
        const selfName = getComponentName(
          Component,
          false
        );
        if (selfName && (selfName === name2 || selfName === camelize(name2) || selfName === capitalize(camelize(name2)))) {
          return Component;
        }
      }
      const res = (
        // local registration
        // check instance[type] first which is resolved for options API
        resolve(instance[type] || Component[type], name2) || // global registration
        resolve(instance.appContext[type], name2)
      );
      if (!res && maybeSelfReference) {
        return Component;
      }
      if (!!(process.env.NODE_ENV !== "production") && warnMissing && !res) {
        const extra = type === COMPONENTS ? `
If this is a native custom element, make sure to exclude it from component resolution via compilerOptions.isCustomElement.` : ``;
        warn$1(`Failed to resolve ${type.slice(0, -1)}: ${name2}${extra}`);
      }
      return res;
    } else if (!!(process.env.NODE_ENV !== "production")) {
      warn$1(
        `resolve${capitalize(type.slice(0, -1))} can only be used in render() or setup().`
      );
    }
  }
  function resolve(registry, name2) {
    return registry && (registry[name2] || registry[camelize(name2)] || registry[capitalize(camelize(name2))]);
  }
  const isSuspense = (type) => type.__isSuspense;
  let suspenseId = 0;
  const SuspenseImpl = {
    name: "Suspense",
    // In order to make Suspense tree-shakable, we need to avoid importing it
    // directly in the renderer. The renderer checks for the __isSuspense flag
    // on a vnode's type and calls the `process` method, passing in renderer
    // internals.
    __isSuspense: true,
    process(n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, rendererInternals) {
      if (n1 == null) {
        mountSuspense(
          n2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized,
          rendererInternals
        );
      } else {
        if (parentSuspense && parentSuspense.deps > 0 && !n1.suspense.isInFallback) {
          n2.suspense = n1.suspense;
          n2.suspense.vnode = n2;
          n2.el = n1.el;
          return;
        }
        patchSuspense(
          n1,
          n2,
          container,
          anchor,
          parentComponent,
          namespace,
          slotScopeIds,
          optimized,
          rendererInternals
        );
      }
    },
    hydrate: hydrateSuspense,
    create: createSuspenseBoundary,
    normalize: normalizeSuspenseChildren
  };
  const Suspense = SuspenseImpl;
  function triggerEvent(vnode, name2) {
    const eventListener = vnode.props && vnode.props[name2];
    if (isFunction$1(eventListener)) {
      eventListener();
    }
  }
  function mountSuspense(vnode, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, rendererInternals) {
    const {
      p: patch,
      o: { createElement }
    } = rendererInternals;
    const hiddenContainer = createElement("div");
    const suspense = vnode.suspense = createSuspenseBoundary(
      vnode,
      parentSuspense,
      parentComponent,
      container,
      hiddenContainer,
      anchor,
      namespace,
      slotScopeIds,
      optimized,
      rendererInternals
    );
    patch(
      null,
      suspense.pendingBranch = vnode.ssContent,
      hiddenContainer,
      null,
      parentComponent,
      suspense,
      namespace,
      slotScopeIds
    );
    if (suspense.deps > 0) {
      triggerEvent(vnode, "onPending");
      triggerEvent(vnode, "onFallback");
      patch(
        null,
        vnode.ssFallback,
        container,
        anchor,
        parentComponent,
        null,
        // fallback tree will not have suspense context
        namespace,
        slotScopeIds
      );
      setActiveBranch(suspense, vnode.ssFallback);
    } else {
      suspense.resolve(false, true);
    }
  }
  function patchSuspense(n1, n2, container, anchor, parentComponent, namespace, slotScopeIds, optimized, { p: patch, um: unmount, o: { createElement } }) {
    const suspense = n2.suspense = n1.suspense;
    suspense.vnode = n2;
    n2.el = n1.el;
    const newBranch = n2.ssContent;
    const newFallback = n2.ssFallback;
    const { activeBranch, pendingBranch, isInFallback, isHydrating } = suspense;
    if (pendingBranch) {
      suspense.pendingBranch = newBranch;
      if (isSameVNodeType(newBranch, pendingBranch)) {
        patch(
          pendingBranch,
          newBranch,
          suspense.hiddenContainer,
          null,
          parentComponent,
          suspense,
          namespace,
          slotScopeIds,
          optimized
        );
        if (suspense.deps <= 0) {
          suspense.resolve();
        } else if (isInFallback) {
          if (!isHydrating) {
            patch(
              activeBranch,
              newFallback,
              container,
              anchor,
              parentComponent,
              null,
              // fallback tree will not have suspense context
              namespace,
              slotScopeIds,
              optimized
            );
            setActiveBranch(suspense, newFallback);
          }
        }
      } else {
        suspense.pendingId = suspenseId++;
        if (isHydrating) {
          suspense.isHydrating = false;
          suspense.activeBranch = pendingBranch;
        } else {
          unmount(pendingBranch, parentComponent, suspense);
        }
        suspense.deps = 0;
        suspense.effects.length = 0;
        suspense.hiddenContainer = createElement("div");
        if (isInFallback) {
          patch(
            null,
            newBranch,
            suspense.hiddenContainer,
            null,
            parentComponent,
            suspense,
            namespace,
            slotScopeIds,
            optimized
          );
          if (suspense.deps <= 0) {
            suspense.resolve();
          } else {
            patch(
              activeBranch,
              newFallback,
              container,
              anchor,
              parentComponent,
              null,
              // fallback tree will not have suspense context
              namespace,
              slotScopeIds,
              optimized
            );
            setActiveBranch(suspense, newFallback);
          }
        } else if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
          patch(
            activeBranch,
            newBranch,
            container,
            anchor,
            parentComponent,
            suspense,
            namespace,
            slotScopeIds,
            optimized
          );
          suspense.resolve(true);
        } else {
          patch(
            null,
            newBranch,
            suspense.hiddenContainer,
            null,
            parentComponent,
            suspense,
            namespace,
            slotScopeIds,
            optimized
          );
          if (suspense.deps <= 0) {
            suspense.resolve();
          }
        }
      }
    } else {
      if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
        patch(
          activeBranch,
          newBranch,
          container,
          anchor,
          parentComponent,
          suspense,
          namespace,
          slotScopeIds,
          optimized
        );
        setActiveBranch(suspense, newBranch);
      } else {
        triggerEvent(n2, "onPending");
        suspense.pendingBranch = newBranch;
        if (newBranch.shapeFlag & 512) {
          suspense.pendingId = newBranch.component.suspenseId;
        } else {
          suspense.pendingId = suspenseId++;
        }
        patch(
          null,
          newBranch,
          suspense.hiddenContainer,
          null,
          parentComponent,
          suspense,
          namespace,
          slotScopeIds,
          optimized
        );
        if (suspense.deps <= 0) {
          suspense.resolve();
        } else {
          const { timeout, pendingId } = suspense;
          if (timeout > 0) {
            setTimeout(() => {
              if (suspense.pendingId === pendingId) {
                suspense.fallback(newFallback);
              }
            }, timeout);
          } else if (timeout === 0) {
            suspense.fallback(newFallback);
          }
        }
      }
    }
  }
  let hasWarned = false;
  function createSuspenseBoundary(vnode, parentSuspense, parentComponent, container, hiddenContainer, anchor, namespace, slotScopeIds, optimized, rendererInternals, isHydrating = false) {
    if (!!(process.env.NODE_ENV !== "production") && true && !hasWarned) {
      hasWarned = true;
      console[console.info ? "info" : "log"](
        `<Suspense> is an experimental feature and its API will likely change.`
      );
    }
    const {
      p: patch,
      m: move,
      um: unmount,
      n: next,
      o: { parentNode, remove: remove2 }
    } = rendererInternals;
    let parentSuspenseId;
    const isSuspensible = isVNodeSuspensible(vnode);
    if (isSuspensible) {
      if (parentSuspense == null ? void 0 : parentSuspense.pendingBranch) {
        parentSuspenseId = parentSuspense.pendingId;
        parentSuspense.deps++;
      }
    }
    const timeout = vnode.props ? toNumber(vnode.props.timeout) : void 0;
    if (!!(process.env.NODE_ENV !== "production")) {
      assertNumber(timeout, `Suspense timeout`);
    }
    const initialAnchor = anchor;
    const suspense = {
      vnode,
      parent: parentSuspense,
      parentComponent,
      namespace,
      container,
      hiddenContainer,
      deps: 0,
      pendingId: suspenseId++,
      timeout: typeof timeout === "number" ? timeout : -1,
      activeBranch: null,
      pendingBranch: null,
      isInFallback: !isHydrating,
      isHydrating,
      isUnmounted: false,
      effects: [],
      resolve(resume = false, sync = false) {
        if (!!(process.env.NODE_ENV !== "production")) {
          if (!resume && !suspense.pendingBranch) {
            throw new Error(
              `suspense.resolve() is called without a pending branch.`
            );
          }
          if (suspense.isUnmounted) {
            throw new Error(
              `suspense.resolve() is called on an already unmounted suspense boundary.`
            );
          }
        }
        const {
          vnode: vnode2,
          activeBranch,
          pendingBranch,
          pendingId,
          effects,
          parentComponent: parentComponent2,
          container: container2
        } = suspense;
        let delayEnter = false;
        if (suspense.isHydrating) {
          suspense.isHydrating = false;
        } else if (!resume) {
          delayEnter = activeBranch && pendingBranch.transition && pendingBranch.transition.mode === "out-in";
          if (delayEnter) {
            activeBranch.transition.afterLeave = () => {
              if (pendingId === suspense.pendingId) {
                move(
                  pendingBranch,
                  container2,
                  anchor === initialAnchor ? next(activeBranch) : anchor,
                  0
                );
                queuePostFlushCb(effects);
              }
            };
          }
          if (activeBranch) {
            if (parentNode(activeBranch.el) !== suspense.hiddenContainer) {
              anchor = next(activeBranch);
            }
            unmount(activeBranch, parentComponent2, suspense, true);
          }
          if (!delayEnter) {
            move(pendingBranch, container2, anchor, 0);
          }
        }
        setActiveBranch(suspense, pendingBranch);
        suspense.pendingBranch = null;
        suspense.isInFallback = false;
        let parent = suspense.parent;
        let hasUnresolvedAncestor = false;
        while (parent) {
          if (parent.pendingBranch) {
            parent.effects.push(...effects);
            hasUnresolvedAncestor = true;
            break;
          }
          parent = parent.parent;
        }
        if (!hasUnresolvedAncestor && !delayEnter) {
          queuePostFlushCb(effects);
        }
        suspense.effects = [];
        if (isSuspensible) {
          if (parentSuspense && parentSuspense.pendingBranch && parentSuspenseId === parentSuspense.pendingId) {
            parentSuspense.deps--;
            if (parentSuspense.deps === 0 && !sync) {
              parentSuspense.resolve();
            }
          }
        }
        triggerEvent(vnode2, "onResolve");
      },
      fallback(fallbackVNode) {
        if (!suspense.pendingBranch) {
          return;
        }
        const { vnode: vnode2, activeBranch, parentComponent: parentComponent2, container: container2, namespace: namespace2 } = suspense;
        triggerEvent(vnode2, "onFallback");
        const anchor2 = next(activeBranch);
        const mountFallback = () => {
          if (!suspense.isInFallback) {
            return;
          }
          patch(
            null,
            fallbackVNode,
            container2,
            anchor2,
            parentComponent2,
            null,
            // fallback tree will not have suspense context
            namespace2,
            slotScopeIds,
            optimized
          );
          setActiveBranch(suspense, fallbackVNode);
        };
        const delayEnter = fallbackVNode.transition && fallbackVNode.transition.mode === "out-in";
        if (delayEnter) {
          activeBranch.transition.afterLeave = mountFallback;
        }
        suspense.isInFallback = true;
        unmount(
          activeBranch,
          parentComponent2,
          null,
          // no suspense so unmount hooks fire now
          true
          // shouldRemove
        );
        if (!delayEnter) {
          mountFallback();
        }
      },
      move(container2, anchor2, type) {
        suspense.activeBranch && move(suspense.activeBranch, container2, anchor2, type);
        suspense.container = container2;
      },
      next() {
        return suspense.activeBranch && next(suspense.activeBranch);
      },
      registerDep(instance, setupRenderEffect) {
        const isInPendingSuspense = !!suspense.pendingBranch;
        if (isInPendingSuspense) {
          suspense.deps++;
        }
        const hydratedEl = instance.vnode.el;
        instance.asyncDep.catch((err) => {
          handleError(err, instance, 0);
        }).then((asyncSetupResult) => {
          if (instance.isUnmounted || suspense.isUnmounted || suspense.pendingId !== instance.suspenseId) {
            return;
          }
          instance.asyncResolved = true;
          const { vnode: vnode2 } = instance;
          if (!!(process.env.NODE_ENV !== "production")) {
            pushWarningContext(vnode2);
          }
          handleSetupResult(instance, asyncSetupResult, false);
          if (hydratedEl) {
            vnode2.el = hydratedEl;
          }
          const placeholder = !hydratedEl && instance.subTree.el;
          setupRenderEffect(
            instance,
            vnode2,
            // component may have been moved before resolve.
            // if this is not a hydration, instance.subTree will be the comment
            // placeholder.
            parentNode(hydratedEl || instance.subTree.el),
            // anchor will not be used if this is hydration, so only need to
            // consider the comment placeholder case.
            hydratedEl ? null : next(instance.subTree),
            suspense,
            namespace,
            optimized
          );
          if (placeholder) {
            remove2(placeholder);
          }
          updateHOCHostEl(instance, vnode2.el);
          if (!!(process.env.NODE_ENV !== "production")) {
            popWarningContext();
          }
          if (isInPendingSuspense && --suspense.deps === 0) {
            suspense.resolve();
          }
        });
      },
      unmount(parentSuspense2, doRemove) {
        suspense.isUnmounted = true;
        if (suspense.activeBranch) {
          unmount(
            suspense.activeBranch,
            parentComponent,
            parentSuspense2,
            doRemove
          );
        }
        if (suspense.pendingBranch) {
          unmount(
            suspense.pendingBranch,
            parentComponent,
            parentSuspense2,
            doRemove
          );
        }
      }
    };
    return suspense;
  }
  function hydrateSuspense(node, vnode, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, rendererInternals, hydrateNode) {
    const suspense = vnode.suspense = createSuspenseBoundary(
      vnode,
      parentSuspense,
      parentComponent,
      node.parentNode,
      // eslint-disable-next-line no-restricted-globals
      document.createElement("div"),
      null,
      namespace,
      slotScopeIds,
      optimized,
      rendererInternals,
      true
    );
    const result = hydrateNode(
      node,
      suspense.pendingBranch = vnode.ssContent,
      parentComponent,
      suspense,
      slotScopeIds,
      optimized
    );
    if (suspense.deps === 0) {
      suspense.resolve(false, true);
    }
    return result;
  }
  function normalizeSuspenseChildren(vnode) {
    const { shapeFlag, children } = vnode;
    const isSlotChildren = shapeFlag & 32;
    vnode.ssContent = normalizeSuspenseSlot(
      isSlotChildren ? children.default : children
    );
    vnode.ssFallback = isSlotChildren ? normalizeSuspenseSlot(children.fallback) : createVNode(Comment$1);
  }
  function normalizeSuspenseSlot(s2) {
    let block;
    if (isFunction$1(s2)) {
      const trackBlock = isBlockTreeEnabled && s2._c;
      if (trackBlock) {
        s2._d = false;
        openBlock();
      }
      s2 = s2();
      if (trackBlock) {
        s2._d = true;
        block = currentBlock;
        closeBlock();
      }
    }
    if (isArray$1(s2)) {
      const singleChild = filterSingleRoot(s2);
      if (!!(process.env.NODE_ENV !== "production") && !singleChild && s2.filter((child) => child !== NULL_DYNAMIC_COMPONENT).length > 0) {
        warn$1(`<Suspense> slots expect a single root node.`);
      }
      s2 = singleChild;
    }
    s2 = normalizeVNode(s2);
    if (block && !s2.dynamicChildren) {
      s2.dynamicChildren = block.filter((c2) => c2 !== s2);
    }
    return s2;
  }
  function queueEffectWithSuspense(fn, suspense) {
    if (suspense && suspense.pendingBranch) {
      if (isArray$1(fn)) {
        suspense.effects.push(...fn);
      } else {
        suspense.effects.push(fn);
      }
    } else {
      queuePostFlushCb(fn);
    }
  }
  function setActiveBranch(suspense, branch) {
    suspense.activeBranch = branch;
    const { vnode, parentComponent } = suspense;
    let el = branch.el;
    while (!el && branch.component) {
      branch = branch.component.subTree;
      el = branch.el;
    }
    vnode.el = el;
    if (parentComponent && parentComponent.subTree === vnode) {
      parentComponent.vnode.el = el;
      updateHOCHostEl(parentComponent, el);
    }
  }
  function isVNodeSuspensible(vnode) {
    var _a2;
    return ((_a2 = vnode.props) == null ? void 0 : _a2.suspensible) != null && vnode.props.suspensible !== false;
  }
  const ssrContextKey = Symbol.for("v-scx");
  const useSSRContext = () => {
    {
      const ctx = inject(ssrContextKey);
      if (!ctx) {
        !!(process.env.NODE_ENV !== "production") && warn$1(
          `Server rendering context not provided. Make sure to only call useSSRContext() conditionally in the server build.`
        );
      }
      return ctx;
    }
  };
  function watchEffect(effect2, options) {
    return doWatch(effect2, null, options);
  }
  function watchPostEffect(effect2, options) {
    return doWatch(
      effect2,
      null,
      !!(process.env.NODE_ENV !== "production") ? extend$2({}, options, { flush: "post" }) : { flush: "post" }
    );
  }
  function watchSyncEffect(effect2, options) {
    return doWatch(
      effect2,
      null,
      !!(process.env.NODE_ENV !== "production") ? extend$2({}, options, { flush: "sync" }) : { flush: "sync" }
    );
  }
  const INITIAL_WATCHER_VALUE = {};
  function watch(source, cb, options) {
    if (!!(process.env.NODE_ENV !== "production") && !isFunction$1(cb)) {
      warn$1(
        `\`watch(fn, options?)\` signature has been moved to a separate API. Use \`watchEffect(fn, options?)\` instead. \`watch\` now only supports \`watch(source, cb, options?) signature.`
      );
    }
    return doWatch(source, cb, options);
  }
  function doWatch(source, cb, {
    immediate,
    deep,
    flush,
    once,
    onTrack,
    onTrigger
  } = EMPTY_OBJ) {
    if (cb && once) {
      const _cb = cb;
      cb = (...args) => {
        _cb(...args);
        unwatch();
      };
    }
    if (!!(process.env.NODE_ENV !== "production") && deep !== void 0 && typeof deep === "number") {
      warn$1(
        `watch() "deep" option with number value will be used as watch depth in future versions. Please use a boolean instead to avoid potential breakage.`
      );
    }
    if (!!(process.env.NODE_ENV !== "production") && !cb) {
      if (immediate !== void 0) {
        warn$1(
          `watch() "immediate" option is only respected when using the watch(source, callback, options?) signature.`
        );
      }
      if (deep !== void 0) {
        warn$1(
          `watch() "deep" option is only respected when using the watch(source, callback, options?) signature.`
        );
      }
      if (once !== void 0) {
        warn$1(
          `watch() "once" option is only respected when using the watch(source, callback, options?) signature.`
        );
      }
    }
    const warnInvalidSource = (s2) => {
      warn$1(
        `Invalid watch source: `,
        s2,
        `A watch source can only be a getter/effect function, a ref, a reactive object, or an array of these types.`
      );
    };
    const instance = currentInstance;
    const reactiveGetter = (source2) => deep === true ? source2 : (
      // for deep: false, only traverse root-level properties
      traverse(source2, deep === false ? 1 : void 0)
    );
    let getter;
    let forceTrigger = false;
    let isMultiSource = false;
    if (isRef(source)) {
      getter = () => source.value;
      forceTrigger = isShallow(source);
    } else if (isReactive(source)) {
      getter = () => reactiveGetter(source);
      forceTrigger = true;
    } else if (isArray$1(source)) {
      isMultiSource = true;
      forceTrigger = source.some((s2) => isReactive(s2) || isShallow(s2));
      getter = () => source.map((s2) => {
        if (isRef(s2)) {
          return s2.value;
        } else if (isReactive(s2)) {
          return reactiveGetter(s2);
        } else if (isFunction$1(s2)) {
          return callWithErrorHandling(s2, instance, 2);
        } else {
          !!(process.env.NODE_ENV !== "production") && warnInvalidSource(s2);
        }
      });
    } else if (isFunction$1(source)) {
      if (cb) {
        getter = () => callWithErrorHandling(source, instance, 2);
      } else {
        getter = () => {
          if (cleanup) {
            cleanup();
          }
          return callWithAsyncErrorHandling(
            source,
            instance,
            3,
            [onCleanup]
          );
        };
      }
    } else {
      getter = NOOP;
      !!(process.env.NODE_ENV !== "production") && warnInvalidSource(source);
    }
    if (cb && deep) {
      const baseGetter = getter;
      getter = () => traverse(baseGetter());
    }
    let cleanup;
    let onCleanup = (fn) => {
      cleanup = effect2.onStop = () => {
        callWithErrorHandling(fn, instance, 4);
        cleanup = effect2.onStop = void 0;
      };
    };
    let ssrCleanup;
    if (isInSSRComponentSetup) {
      onCleanup = NOOP;
      if (!cb) {
        getter();
      } else if (immediate) {
        callWithAsyncErrorHandling(cb, instance, 3, [
          getter(),
          isMultiSource ? [] : void 0,
          onCleanup
        ]);
      }
      if (flush === "sync") {
        const ctx = useSSRContext();
        ssrCleanup = ctx.__watcherHandles || (ctx.__watcherHandles = []);
      } else {
        return NOOP;
      }
    }
    let oldValue = isMultiSource ? new Array(source.length).fill(INITIAL_WATCHER_VALUE) : INITIAL_WATCHER_VALUE;
    const job = () => {
      if (!effect2.active || !effect2.dirty) {
        return;
      }
      if (cb) {
        const newValue = effect2.run();
        if (deep || forceTrigger || (isMultiSource ? newValue.some((v2, i2) => hasChanged(v2, oldValue[i2])) : hasChanged(newValue, oldValue)) || false) {
          if (cleanup) {
            cleanup();
          }
          callWithAsyncErrorHandling(cb, instance, 3, [
            newValue,
            // pass undefined as the old value when it's changed for the first time
            oldValue === INITIAL_WATCHER_VALUE ? void 0 : isMultiSource && oldValue[0] === INITIAL_WATCHER_VALUE ? [] : oldValue,
            onCleanup
          ]);
          oldValue = newValue;
        }
      } else {
        effect2.run();
      }
    };
    job.allowRecurse = !!cb;
    let scheduler;
    if (flush === "sync") {
      scheduler = job;
    } else if (flush === "post") {
      scheduler = () => queuePostRenderEffect(job, instance && instance.suspense);
    } else {
      job.pre = true;
      if (instance)
        job.id = instance.uid;
      scheduler = () => queueJob(job);
    }
    const effect2 = new ReactiveEffect(getter, NOOP, scheduler);
    const scope = getCurrentScope();
    const unwatch = () => {
      effect2.stop();
      if (scope) {
        remove$1(scope.effects, effect2);
      }
    };
    if (!!(process.env.NODE_ENV !== "production")) {
      effect2.onTrack = onTrack;
      effect2.onTrigger = onTrigger;
    }
    if (cb) {
      if (immediate) {
        job();
      } else {
        oldValue = effect2.run();
      }
    } else if (flush === "post") {
      queuePostRenderEffect(
        effect2.run.bind(effect2),
        instance && instance.suspense
      );
    } else {
      effect2.run();
    }
    if (ssrCleanup)
      ssrCleanup.push(unwatch);
    return unwatch;
  }
  function instanceWatch(source, value, options) {
    const publicThis = this.proxy;
    const getter = isString$1(source) ? source.includes(".") ? createPathGetter(publicThis, source) : () => publicThis[source] : source.bind(publicThis, publicThis);
    let cb;
    if (isFunction$1(value)) {
      cb = value;
    } else {
      cb = value.handler;
      options = value;
    }
    const reset2 = setCurrentInstance(this);
    const res = doWatch(getter, cb.bind(publicThis), options);
    reset2();
    return res;
  }
  function createPathGetter(ctx, path) {
    const segments = path.split(".");
    return () => {
      let cur2 = ctx;
      for (let i2 = 0; i2 < segments.length && cur2; i2++) {
        cur2 = cur2[segments[i2]];
      }
      return cur2;
    };
  }
  function traverse(value, depth, currentDepth = 0, seen2) {
    if (!isObject$2(value) || value["__v_skip"]) {
      return value;
    }
    if (depth && depth > 0) {
      if (currentDepth >= depth) {
        return value;
      }
      currentDepth++;
    }
    seen2 = seen2 || /* @__PURE__ */ new Set();
    if (seen2.has(value)) {
      return value;
    }
    seen2.add(value);
    if (isRef(value)) {
      traverse(value.value, depth, currentDepth, seen2);
    } else if (isArray$1(value)) {
      for (let i2 = 0; i2 < value.length; i2++) {
        traverse(value[i2], depth, currentDepth, seen2);
      }
    } else if (isSet(value) || isMap(value)) {
      value.forEach((v2) => {
        traverse(v2, depth, currentDepth, seen2);
      });
    } else if (isPlainObject$1(value)) {
      for (const key in value) {
        traverse(value[key], depth, currentDepth, seen2);
      }
    }
    return value;
  }
  function validateDirectiveName(name2) {
    if (isBuiltInDirective(name2)) {
      warn$1("Do not use built-in directive ids as custom directive id: " + name2);
    }
  }
  function withDirectives(vnode, directives) {
    if (currentRenderingInstance === null) {
      !!(process.env.NODE_ENV !== "production") && warn$1(`withDirectives can only be used inside render functions.`);
      return vnode;
    }
    const instance = getExposeProxy(currentRenderingInstance) || currentRenderingInstance.proxy;
    const bindings = vnode.dirs || (vnode.dirs = []);
    for (let i2 = 0; i2 < directives.length; i2++) {
      let [dir, value, arg, modifiers2 = EMPTY_OBJ] = directives[i2];
      if (dir) {
        if (isFunction$1(dir)) {
          dir = {
            mounted: dir,
            updated: dir
          };
        }
        if (dir.deep) {
          traverse(value);
        }
        bindings.push({
          dir,
          instance,
          value,
          oldValue: void 0,
          arg,
          modifiers: modifiers2
        });
      }
    }
    return vnode;
  }
  function invokeDirectiveHook(vnode, prevVNode, instance, name2) {
    const bindings = vnode.dirs;
    const oldBindings = prevVNode && prevVNode.dirs;
    for (let i2 = 0; i2 < bindings.length; i2++) {
      const binding = bindings[i2];
      if (oldBindings) {
        binding.oldValue = oldBindings[i2].value;
      }
      let hook = binding.dir[name2];
      if (hook) {
        pauseTracking();
        callWithAsyncErrorHandling(hook, instance, 8, [
          vnode.el,
          binding,
          vnode,
          prevVNode
        ]);
        resetTracking();
      }
    }
  }
  const leaveCbKey = Symbol("_leaveCb");
  const enterCbKey$1 = Symbol("_enterCb");
  function useTransitionState() {
    const state = {
      isMounted: false,
      isLeaving: false,
      isUnmounting: false,
      leavingVNodes: /* @__PURE__ */ new Map()
    };
    onMounted(() => {
      state.isMounted = true;
    });
    onBeforeUnmount(() => {
      state.isUnmounting = true;
    });
    return state;
  }
  const TransitionHookValidator = [Function, Array];
  const BaseTransitionPropsValidators = {
    mode: String,
    appear: Boolean,
    persisted: Boolean,
    // enter
    onBeforeEnter: TransitionHookValidator,
    onEnter: TransitionHookValidator,
    onAfterEnter: TransitionHookValidator,
    onEnterCancelled: TransitionHookValidator,
    // leave
    onBeforeLeave: TransitionHookValidator,
    onLeave: TransitionHookValidator,
    onAfterLeave: TransitionHookValidator,
    onLeaveCancelled: TransitionHookValidator,
    // appear
    onBeforeAppear: TransitionHookValidator,
    onAppear: TransitionHookValidator,
    onAfterAppear: TransitionHookValidator,
    onAppearCancelled: TransitionHookValidator
  };
  const BaseTransitionImpl = {
    name: `BaseTransition`,
    props: BaseTransitionPropsValidators,
    setup(props, { slots }) {
      const instance = getCurrentInstance();
      const state = useTransitionState();
      return () => {
        const children = slots.default && getTransitionRawChildren(slots.default(), true);
        if (!children || !children.length) {
          return;
        }
        let child = children[0];
        if (children.length > 1) {
          let hasFound = false;
          for (const c2 of children) {
            if (c2.type !== Comment$1) {
              if (!!(process.env.NODE_ENV !== "production") && hasFound) {
                warn$1(
                  "<transition> can only be used on a single element or component. Use <transition-group> for lists."
                );
                break;
              }
              child = c2;
              hasFound = true;
              if (!!!(process.env.NODE_ENV !== "production"))
                break;
            }
          }
        }
        const rawProps = toRaw(props);
        const { mode } = rawProps;
        if (!!(process.env.NODE_ENV !== "production") && mode && mode !== "in-out" && mode !== "out-in" && mode !== "default") {
          warn$1(`invalid <transition> mode: ${mode}`);
        }
        if (state.isLeaving) {
          return emptyPlaceholder(child);
        }
        const innerChild = getKeepAliveChild(child);
        if (!innerChild) {
          return emptyPlaceholder(child);
        }
        const enterHooks = resolveTransitionHooks(
          innerChild,
          rawProps,
          state,
          instance
        );
        setTransitionHooks(innerChild, enterHooks);
        const oldChild = instance.subTree;
        const oldInnerChild = oldChild && getKeepAliveChild(oldChild);
        if (oldInnerChild && oldInnerChild.type !== Comment$1 && !isSameVNodeType(innerChild, oldInnerChild)) {
          const leavingHooks = resolveTransitionHooks(
            oldInnerChild,
            rawProps,
            state,
            instance
          );
          setTransitionHooks(oldInnerChild, leavingHooks);
          if (mode === "out-in") {
            state.isLeaving = true;
            leavingHooks.afterLeave = () => {
              state.isLeaving = false;
              if (instance.update.active !== false) {
                instance.effect.dirty = true;
                instance.update();
              }
            };
            return emptyPlaceholder(child);
          } else if (mode === "in-out" && innerChild.type !== Comment$1) {
            leavingHooks.delayLeave = (el, earlyRemove, delayedLeave) => {
              const leavingVNodesCache = getLeavingNodesForType(
                state,
                oldInnerChild
              );
              leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
              el[leaveCbKey] = () => {
                earlyRemove();
                el[leaveCbKey] = void 0;
                delete enterHooks.delayedLeave;
              };
              enterHooks.delayedLeave = delayedLeave;
            };
          }
        }
        return child;
      };
    }
  };
  const BaseTransition = BaseTransitionImpl;
  function getLeavingNodesForType(state, vnode) {
    const { leavingVNodes } = state;
    let leavingVNodesCache = leavingVNodes.get(vnode.type);
    if (!leavingVNodesCache) {
      leavingVNodesCache = /* @__PURE__ */ Object.create(null);
      leavingVNodes.set(vnode.type, leavingVNodesCache);
    }
    return leavingVNodesCache;
  }
  function resolveTransitionHooks(vnode, props, state, instance) {
    const {
      appear,
      mode,
      persisted = false,
      onBeforeEnter,
      onEnter,
      onAfterEnter,
      onEnterCancelled,
      onBeforeLeave,
      onLeave,
      onAfterLeave,
      onLeaveCancelled,
      onBeforeAppear,
      onAppear,
      onAfterAppear,
      onAppearCancelled
    } = props;
    const key = String(vnode.key);
    const leavingVNodesCache = getLeavingNodesForType(state, vnode);
    const callHook2 = (hook, args) => {
      hook && callWithAsyncErrorHandling(
        hook,
        instance,
        9,
        args
      );
    };
    const callAsyncHook = (hook, args) => {
      const done = args[1];
      callHook2(hook, args);
      if (isArray$1(hook)) {
        if (hook.every((hook2) => hook2.length <= 1))
          done();
      } else if (hook.length <= 1) {
        done();
      }
    };
    const hooks = {
      mode,
      persisted,
      beforeEnter(el) {
        let hook = onBeforeEnter;
        if (!state.isMounted) {
          if (appear) {
            hook = onBeforeAppear || onBeforeEnter;
          } else {
            return;
          }
        }
        if (el[leaveCbKey]) {
          el[leaveCbKey](
            true
            /* cancelled */
          );
        }
        const leavingVNode = leavingVNodesCache[key];
        if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el[leaveCbKey]) {
          leavingVNode.el[leaveCbKey]();
        }
        callHook2(hook, [el]);
      },
      enter(el) {
        let hook = onEnter;
        let afterHook = onAfterEnter;
        let cancelHook = onEnterCancelled;
        if (!state.isMounted) {
          if (appear) {
            hook = onAppear || onEnter;
            afterHook = onAfterAppear || onAfterEnter;
            cancelHook = onAppearCancelled || onEnterCancelled;
          } else {
            return;
          }
        }
        let called = false;
        const done = el[enterCbKey$1] = (cancelled) => {
          if (called)
            return;
          called = true;
          if (cancelled) {
            callHook2(cancelHook, [el]);
          } else {
            callHook2(afterHook, [el]);
          }
          if (hooks.delayedLeave) {
            hooks.delayedLeave();
          }
          el[enterCbKey$1] = void 0;
        };
        if (hook) {
          callAsyncHook(hook, [el, done]);
        } else {
          done();
        }
      },
      leave(el, remove2) {
        const key2 = String(vnode.key);
        if (el[enterCbKey$1]) {
          el[enterCbKey$1](
            true
            /* cancelled */
          );
        }
        if (state.isUnmounting) {
          return remove2();
        }
        callHook2(onBeforeLeave, [el]);
        let called = false;
        const done = el[leaveCbKey] = (cancelled) => {
          if (called)
            return;
          called = true;
          remove2();
          if (cancelled) {
            callHook2(onLeaveCancelled, [el]);
          } else {
            callHook2(onAfterLeave, [el]);
          }
          el[leaveCbKey] = void 0;
          if (leavingVNodesCache[key2] === vnode) {
            delete leavingVNodesCache[key2];
          }
        };
        leavingVNodesCache[key2] = vnode;
        if (onLeave) {
          callAsyncHook(onLeave, [el, done]);
        } else {
          done();
        }
      },
      clone(vnode2) {
        return resolveTransitionHooks(vnode2, props, state, instance);
      }
    };
    return hooks;
  }
  function emptyPlaceholder(vnode) {
    if (isKeepAlive(vnode)) {
      vnode = cloneVNode(vnode);
      vnode.children = null;
      return vnode;
    }
  }
  function getKeepAliveChild(vnode) {
    return isKeepAlive(vnode) ? (
      // #7121 ensure get the child component subtree in case
      // it's been replaced during HMR
      !!(process.env.NODE_ENV !== "production") && vnode.component ? vnode.component.subTree : vnode.children ? vnode.children[0] : void 0
    ) : vnode;
  }
  function setTransitionHooks(vnode, hooks) {
    if (vnode.shapeFlag & 6 && vnode.component) {
      setTransitionHooks(vnode.component.subTree, hooks);
    } else if (vnode.shapeFlag & 128) {
      vnode.ssContent.transition = hooks.clone(vnode.ssContent);
      vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
    } else {
      vnode.transition = hooks;
    }
  }
  function getTransitionRawChildren(children, keepComment = false, parentKey) {
    let ret = [];
    let keyedFragmentCount = 0;
    for (let i2 = 0; i2 < children.length; i2++) {
      let child = children[i2];
      const key = parentKey == null ? child.key : String(parentKey) + String(child.key != null ? child.key : i2);
      if (child.type === Fragment) {
        if (child.patchFlag & 128)
          keyedFragmentCount++;
        ret = ret.concat(
          getTransitionRawChildren(child.children, keepComment, key)
        );
      } else if (keepComment || child.type !== Comment$1) {
        ret.push(key != null ? cloneVNode(child, { key }) : child);
      }
    }
    if (keyedFragmentCount > 1) {
      for (let i2 = 0; i2 < ret.length; i2++) {
        ret[i2].patchFlag = -2;
      }
    }
    return ret;
  }
  /*! #__NO_SIDE_EFFECTS__ */
  // @__NO_SIDE_EFFECTS__
  function defineComponent(options, extraOptions) {
    return isFunction$1(options) ? (
      // #8326: extend call and options.name access are considered side-effects
      // by Rollup, so we have to wrap it in a pure-annotated IIFE.
      /* @__PURE__ */ (() => extend$2({ name: options.name }, extraOptions, { setup: options }))()
    ) : options;
  }
  const isAsyncWrapper = (i2) => !!i2.type.__asyncLoader;
  /*! #__NO_SIDE_EFFECTS__ */
  // @__NO_SIDE_EFFECTS__
  function defineAsyncComponent(source) {
    if (isFunction$1(source)) {
      source = { loader: source };
    }
    const {
      loader,
      loadingComponent,
      errorComponent,
      delay = 200,
      timeout,
      // undefined = never times out
      suspensible = true,
      onError: userOnError
    } = source;
    let pendingRequest = null;
    let resolvedComp;
    let retries = 0;
    const retry = () => {
      retries++;
      pendingRequest = null;
      return load();
    };
    const load = () => {
      let thisRequest;
      return pendingRequest || (thisRequest = pendingRequest = loader().catch((err) => {
        err = err instanceof Error ? err : new Error(String(err));
        if (userOnError) {
          return new Promise((resolve2, reject) => {
            const userRetry = () => resolve2(retry());
            const userFail = () => reject(err);
            userOnError(err, userRetry, userFail, retries + 1);
          });
        } else {
          throw err;
        }
      }).then((comp) => {
        if (thisRequest !== pendingRequest && pendingRequest) {
          return pendingRequest;
        }
        if (!!(process.env.NODE_ENV !== "production") && !comp) {
          warn$1(
            `Async component loader resolved to undefined. If you are using retry(), make sure to return its return value.`
          );
        }
        if (comp && (comp.__esModule || comp[Symbol.toStringTag] === "Module")) {
          comp = comp.default;
        }
        if (!!(process.env.NODE_ENV !== "production") && comp && !isObject$2(comp) && !isFunction$1(comp)) {
          throw new Error(`Invalid async component load result: ${comp}`);
        }
        resolvedComp = comp;
        return comp;
      }));
    };
    return /* @__PURE__ */ defineComponent({
      name: "AsyncComponentWrapper",
      __asyncLoader: load,
      get __asyncResolved() {
        return resolvedComp;
      },
      setup() {
        const instance = currentInstance;
        if (resolvedComp) {
          return () => createInnerComp(resolvedComp, instance);
        }
        const onError = (err) => {
          pendingRequest = null;
          handleError(
            err,
            instance,
            13,
            !errorComponent
          );
        };
        if (suspensible && instance.suspense || isInSSRComponentSetup) {
          return load().then((comp) => {
            return () => createInnerComp(comp, instance);
          }).catch((err) => {
            onError(err);
            return () => errorComponent ? createVNode(errorComponent, {
              error: err
            }) : null;
          });
        }
        const loaded = ref(false);
        const error = ref();
        const delayed = ref(!!delay);
        if (delay) {
          setTimeout(() => {
            delayed.value = false;
          }, delay);
        }
        if (timeout != null) {
          setTimeout(() => {
            if (!loaded.value && !error.value) {
              const err = new Error(
                `Async component timed out after ${timeout}ms.`
              );
              onError(err);
              error.value = err;
            }
          }, timeout);
        }
        load().then(() => {
          loaded.value = true;
          if (instance.parent && isKeepAlive(instance.parent.vnode)) {
            instance.parent.effect.dirty = true;
            queueJob(instance.parent.update);
          }
        }).catch((err) => {
          onError(err);
          error.value = err;
        });
        return () => {
          if (loaded.value && resolvedComp) {
            return createInnerComp(resolvedComp, instance);
          } else if (error.value && errorComponent) {
            return createVNode(errorComponent, {
              error: error.value
            });
          } else if (loadingComponent && !delayed.value) {
            return createVNode(loadingComponent);
          }
        };
      }
    });
  }
  function createInnerComp(comp, parent) {
    const { ref: ref2, props, children, ce } = parent.vnode;
    const vnode = createVNode(comp, props, children);
    vnode.ref = ref2;
    vnode.ce = ce;
    delete parent.vnode.ce;
    return vnode;
  }
  const isKeepAlive = (vnode) => vnode.type.__isKeepAlive;
  const KeepAliveImpl = {
    name: `KeepAlive`,
    // Marker for special handling inside the renderer. We are not using a ===
    // check directly on KeepAlive in the renderer, because importing it directly
    // would prevent it from being tree-shaken.
    __isKeepAlive: true,
    props: {
      include: [String, RegExp, Array],
      exclude: [String, RegExp, Array],
      max: [String, Number]
    },
    setup(props, { slots }) {
      const instance = getCurrentInstance();
      const sharedContext = instance.ctx;
      if (!sharedContext.renderer) {
        return () => {
          const children = slots.default && slots.default();
          return children && children.length === 1 ? children[0] : children;
        };
      }
      const cache2 = /* @__PURE__ */ new Map();
      const keys = /* @__PURE__ */ new Set();
      let current = null;
      if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
        instance.__v_cache = cache2;
      }
      const parentSuspense = instance.suspense;
      const {
        renderer: {
          p: patch,
          m: move,
          um: _unmount,
          o: { createElement }
        }
      } = sharedContext;
      const storageContainer = createElement("div");
      sharedContext.activate = (vnode, container, anchor, namespace, optimized) => {
        const instance2 = vnode.component;
        move(vnode, container, anchor, 0, parentSuspense);
        patch(
          instance2.vnode,
          vnode,
          container,
          anchor,
          instance2,
          parentSuspense,
          namespace,
          vnode.slotScopeIds,
          optimized
        );
        queuePostRenderEffect(() => {
          instance2.isDeactivated = false;
          if (instance2.a) {
            invokeArrayFns(instance2.a);
          }
          const vnodeHook = vnode.props && vnode.props.onVnodeMounted;
          if (vnodeHook) {
            invokeVNodeHook(vnodeHook, instance2.parent, vnode);
          }
        }, parentSuspense);
        if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
          devtoolsComponentAdded(instance2);
        }
      };
      sharedContext.deactivate = (vnode) => {
        const instance2 = vnode.component;
        move(vnode, storageContainer, null, 1, parentSuspense);
        queuePostRenderEffect(() => {
          if (instance2.da) {
            invokeArrayFns(instance2.da);
          }
          const vnodeHook = vnode.props && vnode.props.onVnodeUnmounted;
          if (vnodeHook) {
            invokeVNodeHook(vnodeHook, instance2.parent, vnode);
          }
          instance2.isDeactivated = true;
        }, parentSuspense);
        if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
          devtoolsComponentAdded(instance2);
        }
      };
      function unmount(vnode) {
        resetShapeFlag(vnode);
        _unmount(vnode, instance, parentSuspense, true);
      }
      function pruneCache(filter) {
        cache2.forEach((vnode, key) => {
          const name2 = getComponentName(vnode.type);
          if (name2 && (!filter || !filter(name2))) {
            pruneCacheEntry(key);
          }
        });
      }
      function pruneCacheEntry(key) {
        const cached = cache2.get(key);
        if (!current || !isSameVNodeType(cached, current)) {
          unmount(cached);
        } else if (current) {
          resetShapeFlag(current);
        }
        cache2.delete(key);
        keys.delete(key);
      }
      watch(
        () => [props.include, props.exclude],
        ([include, exclude]) => {
          include && pruneCache((name2) => matches(include, name2));
          exclude && pruneCache((name2) => !matches(exclude, name2));
        },
        // prune post-render after `current` has been updated
        { flush: "post", deep: true }
      );
      let pendingCacheKey = null;
      const cacheSubtree = () => {
        if (pendingCacheKey != null) {
          cache2.set(pendingCacheKey, getInnerChild(instance.subTree));
        }
      };
      onMounted(cacheSubtree);
      onUpdated(cacheSubtree);
      onBeforeUnmount(() => {
        cache2.forEach((cached) => {
          const { subTree, suspense } = instance;
          const vnode = getInnerChild(subTree);
          if (cached.type === vnode.type && cached.key === vnode.key) {
            resetShapeFlag(vnode);
            const da = vnode.component.da;
            da && queuePostRenderEffect(da, suspense);
            return;
          }
          unmount(cached);
        });
      });
      return () => {
        pendingCacheKey = null;
        if (!slots.default) {
          return null;
        }
        const children = slots.default();
        const rawVNode = children[0];
        if (children.length > 1) {
          if (!!(process.env.NODE_ENV !== "production")) {
            warn$1(`KeepAlive should contain exactly one component child.`);
          }
          current = null;
          return children;
        } else if (!isVNode(rawVNode) || !(rawVNode.shapeFlag & 4) && !(rawVNode.shapeFlag & 128)) {
          current = null;
          return rawVNode;
        }
        let vnode = getInnerChild(rawVNode);
        const comp = vnode.type;
        const name2 = getComponentName(
          isAsyncWrapper(vnode) ? vnode.type.__asyncResolved || {} : comp
        );
        const { include, exclude, max } = props;
        if (include && (!name2 || !matches(include, name2)) || exclude && name2 && matches(exclude, name2)) {
          current = vnode;
          return rawVNode;
        }
        const key = vnode.key == null ? comp : vnode.key;
        const cachedVNode = cache2.get(key);
        if (vnode.el) {
          vnode = cloneVNode(vnode);
          if (rawVNode.shapeFlag & 128) {
            rawVNode.ssContent = vnode;
          }
        }
        pendingCacheKey = key;
        if (cachedVNode) {
          vnode.el = cachedVNode.el;
          vnode.component = cachedVNode.component;
          if (vnode.transition) {
            setTransitionHooks(vnode, vnode.transition);
          }
          vnode.shapeFlag |= 512;
          keys.delete(key);
          keys.add(key);
        } else {
          keys.add(key);
          if (max && keys.size > parseInt(max, 10)) {
            pruneCacheEntry(keys.values().next().value);
          }
        }
        vnode.shapeFlag |= 256;
        current = vnode;
        return isSuspense(rawVNode.type) ? rawVNode : vnode;
      };
    }
  };
  const KeepAlive = KeepAliveImpl;
  function matches(pattern, name2) {
    if (isArray$1(pattern)) {
      return pattern.some((p2) => matches(p2, name2));
    } else if (isString$1(pattern)) {
      return pattern.split(",").includes(name2);
    } else if (isRegExp$1(pattern)) {
      return pattern.test(name2);
    }
    return false;
  }
  function onActivated(hook, target) {
    registerKeepAliveHook(hook, "a", target);
  }
  function onDeactivated(hook, target) {
    registerKeepAliveHook(hook, "da", target);
  }
  function registerKeepAliveHook(hook, type, target = currentInstance) {
    const wrappedHook = hook.__wdc || (hook.__wdc = () => {
      let current = target;
      while (current) {
        if (current.isDeactivated) {
          return;
        }
        current = current.parent;
      }
      return hook();
    });
    injectHook(type, wrappedHook, target);
    if (target) {
      let current = target.parent;
      while (current && current.parent) {
        if (isKeepAlive(current.parent.vnode)) {
          injectToKeepAliveRoot(wrappedHook, type, target, current);
        }
        current = current.parent;
      }
    }
  }
  function injectToKeepAliveRoot(hook, type, target, keepAliveRoot) {
    const injected = injectHook(
      type,
      hook,
      keepAliveRoot,
      true
      /* prepend */
    );
    onUnmounted(() => {
      remove$1(keepAliveRoot[type], injected);
    }, target);
  }
  function resetShapeFlag(vnode) {
    vnode.shapeFlag &= ~256;
    vnode.shapeFlag &= ~512;
  }
  function getInnerChild(vnode) {
    return vnode.shapeFlag & 128 ? vnode.ssContent : vnode;
  }
  function injectHook(type, hook, target = currentInstance, prepend = false) {
    if (target) {
      const hooks = target[type] || (target[type] = []);
      const wrappedHook = hook.__weh || (hook.__weh = (...args) => {
        if (target.isUnmounted) {
          return;
        }
        pauseTracking();
        const reset2 = setCurrentInstance(target);
        const res = callWithAsyncErrorHandling(hook, target, type, args);
        reset2();
        resetTracking();
        return res;
      });
      if (prepend) {
        hooks.unshift(wrappedHook);
      } else {
        hooks.push(wrappedHook);
      }
      return wrappedHook;
    } else if (!!(process.env.NODE_ENV !== "production")) {
      const apiName = toHandlerKey(ErrorTypeStrings$1[type].replace(/ hook$/, ""));
      warn$1(
        `${apiName} is called when there is no active component instance to be associated with. Lifecycle injection APIs can only be used during execution of setup(). If you are using async setup(), make sure to register lifecycle hooks before the first await statement.`
      );
    }
  }
  const createHook = (lifecycle) => (hook, target = currentInstance) => (
    // post-create lifecycle registrations are noops during SSR (except for serverPrefetch)
    (!isInSSRComponentSetup || lifecycle === "sp") && injectHook(lifecycle, (...args) => hook(...args), target)
  );
  const onBeforeMount = createHook("bm");
  const onMounted = createHook("m");
  const onBeforeUpdate = createHook("bu");
  const onUpdated = createHook("u");
  const onBeforeUnmount = createHook("bum");
  const onUnmounted = createHook("um");
  const onServerPrefetch = createHook("sp");
  const onRenderTriggered = createHook(
    "rtg"
  );
  const onRenderTracked = createHook(
    "rtc"
  );
  function onErrorCaptured(hook, target = currentInstance) {
    injectHook("ec", hook, target);
  }
  function renderList(source, renderItem, cache2, index2) {
    let ret;
    const cached = cache2 && cache2[index2];
    if (isArray$1(source) || isString$1(source)) {
      ret = new Array(source.length);
      for (let i2 = 0, l2 = source.length; i2 < l2; i2++) {
        ret[i2] = renderItem(source[i2], i2, void 0, cached && cached[i2]);
      }
    } else if (typeof source === "number") {
      if (!!(process.env.NODE_ENV !== "production") && !Number.isInteger(source)) {
        warn$1(`The v-for range expect an integer value but got ${source}.`);
      }
      ret = new Array(source);
      for (let i2 = 0; i2 < source; i2++) {
        ret[i2] = renderItem(i2 + 1, i2, void 0, cached && cached[i2]);
      }
    } else if (isObject$2(source)) {
      if (source[Symbol.iterator]) {
        ret = Array.from(
          source,
          (item, i2) => renderItem(item, i2, void 0, cached && cached[i2])
        );
      } else {
        const keys = Object.keys(source);
        ret = new Array(keys.length);
        for (let i2 = 0, l2 = keys.length; i2 < l2; i2++) {
          const key = keys[i2];
          ret[i2] = renderItem(source[key], key, i2, cached && cached[i2]);
        }
      }
    } else {
      ret = [];
    }
    if (cache2) {
      cache2[index2] = ret;
    }
    return ret;
  }
  function createSlots(slots, dynamicSlots) {
    for (let i2 = 0; i2 < dynamicSlots.length; i2++) {
      const slot = dynamicSlots[i2];
      if (isArray$1(slot)) {
        for (let j2 = 0; j2 < slot.length; j2++) {
          slots[slot[j2].name] = slot[j2].fn;
        }
      } else if (slot) {
        slots[slot.name] = slot.key ? (...args) => {
          const res = slot.fn(...args);
          if (res)
            res.key = slot.key;
          return res;
        } : slot.fn;
      }
    }
    return slots;
  }
  function renderSlot(slots, name2, props = {}, fallback, noSlotted) {
    if (currentRenderingInstance.isCE || currentRenderingInstance.parent && isAsyncWrapper(currentRenderingInstance.parent) && currentRenderingInstance.parent.isCE) {
      if (name2 !== "default")
        props.name = name2;
      return createVNode("slot", props, fallback && fallback());
    }
    let slot = slots[name2];
    if (!!(process.env.NODE_ENV !== "production") && slot && slot.length > 1) {
      warn$1(
        `SSR-optimized slot function detected in a non-SSR-optimized render function. You need to mark this component with $dynamic-slots in the parent template.`
      );
      slot = () => [];
    }
    if (slot && slot._c) {
      slot._d = false;
    }
    openBlock();
    const validSlotContent = slot && ensureValidVNode(slot(props));
    const rendered = createBlock(
      Fragment,
      {
        key: props.key || // slot content array of a dynamic conditional slot may have a branch
        // key attached in the `createSlots` helper, respect that
        validSlotContent && validSlotContent.key || `_${name2}`
      },
      validSlotContent || (fallback ? fallback() : []),
      validSlotContent && slots._ === 1 ? 64 : -2
    );
    if (!noSlotted && rendered.scopeId) {
      rendered.slotScopeIds = [rendered.scopeId + "-s"];
    }
    if (slot && slot._c) {
      slot._d = true;
    }
    return rendered;
  }
  function ensureValidVNode(vnodes) {
    return vnodes.some((child) => {
      if (!isVNode(child))
        return true;
      if (child.type === Comment$1)
        return false;
      if (child.type === Fragment && !ensureValidVNode(child.children))
        return false;
      return true;
    }) ? vnodes : null;
  }
  function toHandlers(obj, preserveCaseIfNecessary) {
    const ret = {};
    if (!!(process.env.NODE_ENV !== "production") && !isObject$2(obj)) {
      warn$1(`v-on with no argument expects an object value.`);
      return ret;
    }
    for (const key in obj) {
      ret[preserveCaseIfNecessary && /[A-Z]/.test(key) ? `on:${key}` : toHandlerKey(key)] = obj[key];
    }
    return ret;
  }
  const getPublicInstance = (i2) => {
    if (!i2)
      return null;
    if (isStatefulComponent(i2))
      return getExposeProxy(i2) || i2.proxy;
    return getPublicInstance(i2.parent);
  };
  const publicPropertiesMap = (
    // Move PURE marker to new line to workaround compiler discarding it
    // due to type annotation
    /* @__PURE__ */ extend$2(/* @__PURE__ */ Object.create(null), {
      $: (i2) => i2,
      $el: (i2) => i2.vnode.el,
      $data: (i2) => i2.data,
      $props: (i2) => !!(process.env.NODE_ENV !== "production") ? shallowReadonly(i2.props) : i2.props,
      $attrs: (i2) => !!(process.env.NODE_ENV !== "production") ? shallowReadonly(i2.attrs) : i2.attrs,
      $slots: (i2) => !!(process.env.NODE_ENV !== "production") ? shallowReadonly(i2.slots) : i2.slots,
      $refs: (i2) => !!(process.env.NODE_ENV !== "production") ? shallowReadonly(i2.refs) : i2.refs,
      $parent: (i2) => getPublicInstance(i2.parent),
      $root: (i2) => getPublicInstance(i2.root),
      $emit: (i2) => i2.emit,
      $options: (i2) => __VUE_OPTIONS_API__ ? resolveMergedOptions(i2) : i2.type,
      $forceUpdate: (i2) => i2.f || (i2.f = () => {
        i2.effect.dirty = true;
        queueJob(i2.update);
      }),
      $nextTick: (i2) => i2.n || (i2.n = nextTick.bind(i2.proxy)),
      $watch: (i2) => __VUE_OPTIONS_API__ ? instanceWatch.bind(i2) : NOOP
    })
  );
  const isReservedPrefix = (key) => key === "_" || key === "$";
  const hasSetupBinding = (state, key) => state !== EMPTY_OBJ && !state.__isScriptSetup && hasOwn(state, key);
  const PublicInstanceProxyHandlers = {
    get({ _: instance }, key) {
      const { ctx, setupState, data, props, accessCache, type, appContext } = instance;
      if (!!(process.env.NODE_ENV !== "production") && key === "__isVue") {
        return true;
      }
      let normalizedProps;
      if (key[0] !== "$") {
        const n2 = accessCache[key];
        if (n2 !== void 0) {
          switch (n2) {
            case 1:
              return setupState[key];
            case 2:
              return data[key];
            case 4:
              return ctx[key];
            case 3:
              return props[key];
          }
        } else if (hasSetupBinding(setupState, key)) {
          accessCache[key] = 1;
          return setupState[key];
        } else if (data !== EMPTY_OBJ && hasOwn(data, key)) {
          accessCache[key] = 2;
          return data[key];
        } else if (
          // only cache other properties when instance has declared (thus stable)
          // props
          (normalizedProps = instance.propsOptions[0]) && hasOwn(normalizedProps, key)
        ) {
          accessCache[key] = 3;
          return props[key];
        } else if (ctx !== EMPTY_OBJ && hasOwn(ctx, key)) {
          accessCache[key] = 4;
          return ctx[key];
        } else if (!__VUE_OPTIONS_API__ || shouldCacheAccess) {
          accessCache[key] = 0;
        }
      }
      const publicGetter = publicPropertiesMap[key];
      let cssModule, globalProperties;
      if (publicGetter) {
        if (key === "$attrs") {
          track(instance, "get", key);
          !!(process.env.NODE_ENV !== "production") && markAttrsAccessed();
        } else if (!!(process.env.NODE_ENV !== "production") && key === "$slots") {
          track(instance, "get", key);
        }
        return publicGetter(instance);
      } else if (
        // css module (injected by vue-loader)
        (cssModule = type.__cssModules) && (cssModule = cssModule[key])
      ) {
        return cssModule;
      } else if (ctx !== EMPTY_OBJ && hasOwn(ctx, key)) {
        accessCache[key] = 4;
        return ctx[key];
      } else if (
        // global properties
        globalProperties = appContext.config.globalProperties, hasOwn(globalProperties, key)
      ) {
        {
          return globalProperties[key];
        }
      } else if (!!(process.env.NODE_ENV !== "production") && currentRenderingInstance && (!isString$1(key) || // #1091 avoid internal isRef/isVNode checks on component instance leading
      // to infinite warning loop
      key.indexOf("__v") !== 0)) {
        if (data !== EMPTY_OBJ && isReservedPrefix(key[0]) && hasOwn(data, key)) {
          warn$1(
            `Property ${JSON.stringify(
              key
            )} must be accessed via $data because it starts with a reserved character ("$" or "_") and is not proxied on the render context.`
          );
        } else if (instance === currentRenderingInstance) {
          warn$1(
            `Property ${JSON.stringify(key)} was accessed during render but is not defined on instance.`
          );
        }
      }
    },
    set({ _: instance }, key, value) {
      const { data, setupState, ctx } = instance;
      if (hasSetupBinding(setupState, key)) {
        setupState[key] = value;
        return true;
      } else if (!!(process.env.NODE_ENV !== "production") && setupState.__isScriptSetup && hasOwn(setupState, key)) {
        warn$1(`Cannot mutate <script setup> binding "${key}" from Options API.`);
        return false;
      } else if (data !== EMPTY_OBJ && hasOwn(data, key)) {
        data[key] = value;
        return true;
      } else if (hasOwn(instance.props, key)) {
        !!(process.env.NODE_ENV !== "production") && warn$1(`Attempting to mutate prop "${key}". Props are readonly.`);
        return false;
      }
      if (key[0] === "$" && key.slice(1) in instance) {
        !!(process.env.NODE_ENV !== "production") && warn$1(
          `Attempting to mutate public property "${key}". Properties starting with $ are reserved and readonly.`
        );
        return false;
      } else {
        if (!!(process.env.NODE_ENV !== "production") && key in instance.appContext.config.globalProperties) {
          Object.defineProperty(ctx, key, {
            enumerable: true,
            configurable: true,
            value
          });
        } else {
          ctx[key] = value;
        }
      }
      return true;
    },
    has({
      _: { data, setupState, accessCache, ctx, appContext, propsOptions }
    }, key) {
      let normalizedProps;
      return !!accessCache[key] || data !== EMPTY_OBJ && hasOwn(data, key) || hasSetupBinding(setupState, key) || (normalizedProps = propsOptions[0]) && hasOwn(normalizedProps, key) || hasOwn(ctx, key) || hasOwn(publicPropertiesMap, key) || hasOwn(appContext.config.globalProperties, key);
    },
    defineProperty(target, key, descriptor) {
      if (descriptor.get != null) {
        target._.accessCache[key] = 0;
      } else if (hasOwn(descriptor, "value")) {
        this.set(target, key, descriptor.value, null);
      }
      return Reflect.defineProperty(target, key, descriptor);
    }
  };
  if (!!(process.env.NODE_ENV !== "production") && true) {
    PublicInstanceProxyHandlers.ownKeys = (target) => {
      warn$1(
        `Avoid app logic that relies on enumerating keys on a component instance. The keys will be empty in production mode to avoid performance overhead.`
      );
      return Reflect.ownKeys(target);
    };
  }
  const RuntimeCompiledPublicInstanceProxyHandlers = /* @__PURE__ */ extend$2(
    {},
    PublicInstanceProxyHandlers,
    {
      get(target, key) {
        if (key === Symbol.unscopables) {
          return;
        }
        return PublicInstanceProxyHandlers.get(target, key, target);
      },
      has(_2, key) {
        const has2 = key[0] !== "_" && !isGloballyAllowed(key);
        if (!!(process.env.NODE_ENV !== "production") && !has2 && PublicInstanceProxyHandlers.has(_2, key)) {
          warn$1(
            `Property ${JSON.stringify(
              key
            )} should not start with _ which is a reserved prefix for Vue internals.`
          );
        }
        return has2;
      }
    }
  );
  function createDevRenderContext(instance) {
    const target = {};
    Object.defineProperty(target, `_`, {
      configurable: true,
      enumerable: false,
      get: () => instance
    });
    Object.keys(publicPropertiesMap).forEach((key) => {
      Object.defineProperty(target, key, {
        configurable: true,
        enumerable: false,
        get: () => publicPropertiesMap[key](instance),
        // intercepted by the proxy so no need for implementation,
        // but needed to prevent set errors
        set: NOOP
      });
    });
    return target;
  }
  function exposePropsOnRenderContext(instance) {
    const {
      ctx,
      propsOptions: [propsOptions]
    } = instance;
    if (propsOptions) {
      Object.keys(propsOptions).forEach((key) => {
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => instance.props[key],
          set: NOOP
        });
      });
    }
  }
  function exposeSetupStateOnRenderContext(instance) {
    const { ctx, setupState } = instance;
    Object.keys(toRaw(setupState)).forEach((key) => {
      if (!setupState.__isScriptSetup) {
        if (isReservedPrefix(key[0])) {
          warn$1(
            `setup() return property ${JSON.stringify(
              key
            )} should not start with "$" or "_" which are reserved prefixes for Vue internals.`
          );
          return;
        }
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => setupState[key],
          set: NOOP
        });
      }
    });
  }
  const warnRuntimeUsage = (method) => warn$1(
    `${method}() is a compiler-hint helper that is only usable inside <script setup> of a single file component. Its arguments should be compiled away and passing it at runtime has no effect.`
  );
  function defineProps() {
    if (!!(process.env.NODE_ENV !== "production")) {
      warnRuntimeUsage(`defineProps`);
    }
    return null;
  }
  function defineEmits() {
    if (!!(process.env.NODE_ENV !== "production")) {
      warnRuntimeUsage(`defineEmits`);
    }
    return null;
  }
  function defineExpose(exposed) {
    if (!!(process.env.NODE_ENV !== "production")) {
      warnRuntimeUsage(`defineExpose`);
    }
  }
  function defineOptions(options) {
    if (!!(process.env.NODE_ENV !== "production")) {
      warnRuntimeUsage(`defineOptions`);
    }
  }
  function defineSlots() {
    if (!!(process.env.NODE_ENV !== "production")) {
      warnRuntimeUsage(`defineSlots`);
    }
    return null;
  }
  function defineModel() {
    if (!!(process.env.NODE_ENV !== "production")) {
      warnRuntimeUsage("defineModel");
    }
  }
  function withDefaults(props, defaults2) {
    if (!!(process.env.NODE_ENV !== "production")) {
      warnRuntimeUsage(`withDefaults`);
    }
    return null;
  }
  function useSlots() {
    return getContext().slots;
  }
  function useAttrs() {
    return getContext().attrs;
  }
  function getContext() {
    const i2 = getCurrentInstance();
    if (!!(process.env.NODE_ENV !== "production") && !i2) {
      warn$1(`useContext() called without active instance.`);
    }
    return i2.setupContext || (i2.setupContext = createSetupContext(i2));
  }
  function normalizePropsOrEmits(props) {
    return isArray$1(props) ? props.reduce(
      (normalized, p2) => (normalized[p2] = null, normalized),
      {}
    ) : props;
  }
  function mergeDefaults(raw, defaults2) {
    const props = normalizePropsOrEmits(raw);
    for (const key in defaults2) {
      if (key.startsWith("__skip"))
        continue;
      let opt = props[key];
      if (opt) {
        if (isArray$1(opt) || isFunction$1(opt)) {
          opt = props[key] = { type: opt, default: defaults2[key] };
        } else {
          opt.default = defaults2[key];
        }
      } else if (opt === null) {
        opt = props[key] = { default: defaults2[key] };
      } else if (!!(process.env.NODE_ENV !== "production")) {
        warn$1(`props default key "${key}" has no corresponding declaration.`);
      }
      if (opt && defaults2[`__skip_${key}`]) {
        opt.skipFactory = true;
      }
    }
    return props;
  }
  function mergeModels(a2, b2) {
    if (!a2 || !b2)
      return a2 || b2;
    if (isArray$1(a2) && isArray$1(b2))
      return a2.concat(b2);
    return extend$2({}, normalizePropsOrEmits(a2), normalizePropsOrEmits(b2));
  }
  function createPropsRestProxy(props, excludedKeys) {
    const ret = {};
    for (const key in props) {
      if (!excludedKeys.includes(key)) {
        Object.defineProperty(ret, key, {
          enumerable: true,
          get: () => props[key]
        });
      }
    }
    return ret;
  }
  function withAsyncContext(getAwaitable) {
    const ctx = getCurrentInstance();
    if (!!(process.env.NODE_ENV !== "production") && !ctx) {
      warn$1(
        `withAsyncContext called without active current instance. This is likely a bug.`
      );
    }
    let awaitable = getAwaitable();
    unsetCurrentInstance();
    if (isPromise(awaitable)) {
      awaitable = awaitable.catch((e2) => {
        setCurrentInstance(ctx);
        throw e2;
      });
    }
    return [awaitable, () => setCurrentInstance(ctx)];
  }
  function createDuplicateChecker() {
    const cache2 = /* @__PURE__ */ Object.create(null);
    return (type, key) => {
      if (cache2[key]) {
        warn$1(`${type} property "${key}" is already defined in ${cache2[key]}.`);
      } else {
        cache2[key] = type;
      }
    };
  }
  let shouldCacheAccess = true;
  function applyOptions(instance) {
    const options = resolveMergedOptions(instance);
    const publicThis = instance.proxy;
    const ctx = instance.ctx;
    shouldCacheAccess = false;
    if (options.beforeCreate) {
      callHook$1(options.beforeCreate, instance, "bc");
    }
    const {
      // state
      data: dataOptions,
      computed: computedOptions,
      methods,
      watch: watchOptions,
      provide: provideOptions,
      inject: injectOptions,
      // lifecycle
      created,
      beforeMount,
      mounted,
      beforeUpdate,
      updated,
      activated,
      deactivated,
      beforeDestroy,
      beforeUnmount,
      destroyed,
      unmounted,
      render: render2,
      renderTracked,
      renderTriggered,
      errorCaptured,
      serverPrefetch,
      // public API
      expose,
      inheritAttrs,
      // assets
      components,
      directives,
      filters
    } = options;
    const checkDuplicateProperties = !!(process.env.NODE_ENV !== "production") ? createDuplicateChecker() : null;
    if (!!(process.env.NODE_ENV !== "production")) {
      const [propsOptions] = instance.propsOptions;
      if (propsOptions) {
        for (const key in propsOptions) {
          checkDuplicateProperties("Props", key);
        }
      }
    }
    if (injectOptions) {
      resolveInjections(injectOptions, ctx, checkDuplicateProperties);
    }
    if (methods) {
      for (const key in methods) {
        const methodHandler = methods[key];
        if (isFunction$1(methodHandler)) {
          if (!!(process.env.NODE_ENV !== "production")) {
            Object.defineProperty(ctx, key, {
              value: methodHandler.bind(publicThis),
              configurable: true,
              enumerable: true,
              writable: true
            });
          } else {
            ctx[key] = methodHandler.bind(publicThis);
          }
          if (!!(process.env.NODE_ENV !== "production")) {
            checkDuplicateProperties("Methods", key);
          }
        } else if (!!(process.env.NODE_ENV !== "production")) {
          warn$1(
            `Method "${key}" has type "${typeof methodHandler}" in the component definition. Did you reference the function correctly?`
          );
        }
      }
    }
    if (dataOptions) {
      if (!!(process.env.NODE_ENV !== "production") && !isFunction$1(dataOptions)) {
        warn$1(
          `The data option must be a function. Plain object usage is no longer supported.`
        );
      }
      const data = dataOptions.call(publicThis, publicThis);
      if (!!(process.env.NODE_ENV !== "production") && isPromise(data)) {
        warn$1(
          `data() returned a Promise - note data() cannot be async; If you intend to perform data fetching before component renders, use async setup() + <Suspense>.`
        );
      }
      if (!isObject$2(data)) {
        !!(process.env.NODE_ENV !== "production") && warn$1(`data() should return an object.`);
      } else {
        instance.data = reactive(data);
        if (!!(process.env.NODE_ENV !== "production")) {
          for (const key in data) {
            checkDuplicateProperties("Data", key);
            if (!isReservedPrefix(key[0])) {
              Object.defineProperty(ctx, key, {
                configurable: true,
                enumerable: true,
                get: () => data[key],
                set: NOOP
              });
            }
          }
        }
      }
    }
    shouldCacheAccess = true;
    if (computedOptions) {
      for (const key in computedOptions) {
        const opt = computedOptions[key];
        const get2 = isFunction$1(opt) ? opt.bind(publicThis, publicThis) : isFunction$1(opt.get) ? opt.get.bind(publicThis, publicThis) : NOOP;
        if (!!(process.env.NODE_ENV !== "production") && get2 === NOOP) {
          warn$1(`Computed property "${key}" has no getter.`);
        }
        const set2 = !isFunction$1(opt) && isFunction$1(opt.set) ? opt.set.bind(publicThis) : !!(process.env.NODE_ENV !== "production") ? () => {
          warn$1(
            `Write operation failed: computed property "${key}" is readonly.`
          );
        } : NOOP;
        const c2 = computed({
          get: get2,
          set: set2
        });
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => c2.value,
          set: (v2) => c2.value = v2
        });
        if (!!(process.env.NODE_ENV !== "production")) {
          checkDuplicateProperties("Computed", key);
        }
      }
    }
    if (watchOptions) {
      for (const key in watchOptions) {
        createWatcher(watchOptions[key], ctx, publicThis, key);
      }
    }
    if (provideOptions) {
      const provides = isFunction$1(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
      Reflect.ownKeys(provides).forEach((key) => {
        provide(key, provides[key]);
      });
    }
    if (created) {
      callHook$1(created, instance, "c");
    }
    function registerLifecycleHook(register, hook) {
      if (isArray$1(hook)) {
        hook.forEach((_hook) => register(_hook.bind(publicThis)));
      } else if (hook) {
        register(hook.bind(publicThis));
      }
    }
    registerLifecycleHook(onBeforeMount, beforeMount);
    registerLifecycleHook(onMounted, mounted);
    registerLifecycleHook(onBeforeUpdate, beforeUpdate);
    registerLifecycleHook(onUpdated, updated);
    registerLifecycleHook(onActivated, activated);
    registerLifecycleHook(onDeactivated, deactivated);
    registerLifecycleHook(onErrorCaptured, errorCaptured);
    registerLifecycleHook(onRenderTracked, renderTracked);
    registerLifecycleHook(onRenderTriggered, renderTriggered);
    registerLifecycleHook(onBeforeUnmount, beforeUnmount);
    registerLifecycleHook(onUnmounted, unmounted);
    registerLifecycleHook(onServerPrefetch, serverPrefetch);
    if (isArray$1(expose)) {
      if (expose.length) {
        const exposed = instance.exposed || (instance.exposed = {});
        expose.forEach((key) => {
          Object.defineProperty(exposed, key, {
            get: () => publicThis[key],
            set: (val) => publicThis[key] = val
          });
        });
      } else if (!instance.exposed) {
        instance.exposed = {};
      }
    }
    if (render2 && instance.render === NOOP) {
      instance.render = render2;
    }
    if (inheritAttrs != null) {
      instance.inheritAttrs = inheritAttrs;
    }
    if (components)
      instance.components = components;
    if (directives)
      instance.directives = directives;
  }
  function resolveInjections(injectOptions, ctx, checkDuplicateProperties = NOOP) {
    if (isArray$1(injectOptions)) {
      injectOptions = normalizeInject(injectOptions);
    }
    for (const key in injectOptions) {
      const opt = injectOptions[key];
      let injected;
      if (isObject$2(opt)) {
        if ("default" in opt) {
          injected = inject(
            opt.from || key,
            opt.default,
            true
          );
        } else {
          injected = inject(opt.from || key);
        }
      } else {
        injected = inject(opt);
      }
      if (isRef(injected)) {
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => injected.value,
          set: (v2) => injected.value = v2
        });
      } else {
        ctx[key] = injected;
      }
      if (!!(process.env.NODE_ENV !== "production")) {
        checkDuplicateProperties("Inject", key);
      }
    }
  }
  function callHook$1(hook, instance, type) {
    callWithAsyncErrorHandling(
      isArray$1(hook) ? hook.map((h2) => h2.bind(instance.proxy)) : hook.bind(instance.proxy),
      instance,
      type
    );
  }
  function createWatcher(raw, ctx, publicThis, key) {
    const getter = key.includes(".") ? createPathGetter(publicThis, key) : () => publicThis[key];
    if (isString$1(raw)) {
      const handler = ctx[raw];
      if (isFunction$1(handler)) {
        watch(getter, handler);
      } else if (!!(process.env.NODE_ENV !== "production")) {
        warn$1(`Invalid watch handler specified by key "${raw}"`, handler);
      }
    } else if (isFunction$1(raw)) {
      watch(getter, raw.bind(publicThis));
    } else if (isObject$2(raw)) {
      if (isArray$1(raw)) {
        raw.forEach((r2) => createWatcher(r2, ctx, publicThis, key));
      } else {
        const handler = isFunction$1(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
        if (isFunction$1(handler)) {
          watch(getter, handler, raw);
        } else if (!!(process.env.NODE_ENV !== "production")) {
          warn$1(`Invalid watch handler specified by key "${raw.handler}"`, handler);
        }
      }
    } else if (!!(process.env.NODE_ENV !== "production")) {
      warn$1(`Invalid watch option: "${key}"`, raw);
    }
  }
  function resolveMergedOptions(instance) {
    const base2 = instance.type;
    const { mixins, extends: extendsOptions } = base2;
    const {
      mixins: globalMixins,
      optionsCache: cache2,
      config: { optionMergeStrategies }
    } = instance.appContext;
    const cached = cache2.get(base2);
    let resolved;
    if (cached) {
      resolved = cached;
    } else if (!globalMixins.length && !mixins && !extendsOptions) {
      {
        resolved = base2;
      }
    } else {
      resolved = {};
      if (globalMixins.length) {
        globalMixins.forEach(
          (m2) => mergeOptions(resolved, m2, optionMergeStrategies, true)
        );
      }
      mergeOptions(resolved, base2, optionMergeStrategies);
    }
    if (isObject$2(base2)) {
      cache2.set(base2, resolved);
    }
    return resolved;
  }
  function mergeOptions(to, from, strats, asMixin = false) {
    const { mixins, extends: extendsOptions } = from;
    if (extendsOptions) {
      mergeOptions(to, extendsOptions, strats, true);
    }
    if (mixins) {
      mixins.forEach(
        (m2) => mergeOptions(to, m2, strats, true)
      );
    }
    for (const key in from) {
      if (asMixin && key === "expose") {
        !!(process.env.NODE_ENV !== "production") && warn$1(
          `"expose" option is ignored when declared in mixins or extends. It should only be declared in the base component itself.`
        );
      } else {
        const strat = internalOptionMergeStrats[key] || strats && strats[key];
        to[key] = strat ? strat(to[key], from[key]) : from[key];
      }
    }
    return to;
  }
  const internalOptionMergeStrats = {
    data: mergeDataFn,
    props: mergeEmitsOrPropsOptions,
    emits: mergeEmitsOrPropsOptions,
    // objects
    methods: mergeObjectOptions,
    computed: mergeObjectOptions,
    // lifecycle
    beforeCreate: mergeAsArray$1,
    created: mergeAsArray$1,
    beforeMount: mergeAsArray$1,
    mounted: mergeAsArray$1,
    beforeUpdate: mergeAsArray$1,
    updated: mergeAsArray$1,
    beforeDestroy: mergeAsArray$1,
    beforeUnmount: mergeAsArray$1,
    destroyed: mergeAsArray$1,
    unmounted: mergeAsArray$1,
    activated: mergeAsArray$1,
    deactivated: mergeAsArray$1,
    errorCaptured: mergeAsArray$1,
    serverPrefetch: mergeAsArray$1,
    // assets
    components: mergeObjectOptions,
    directives: mergeObjectOptions,
    // watch
    watch: mergeWatchOptions,
    // provide / inject
    provide: mergeDataFn,
    inject: mergeInject
  };
  function mergeDataFn(to, from) {
    if (!from) {
      return to;
    }
    if (!to) {
      return from;
    }
    return function mergedDataFn() {
      return extend$2(
        isFunction$1(to) ? to.call(this, this) : to,
        isFunction$1(from) ? from.call(this, this) : from
      );
    };
  }
  function mergeInject(to, from) {
    return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
  }
  function normalizeInject(raw) {
    if (isArray$1(raw)) {
      const res = {};
      for (let i2 = 0; i2 < raw.length; i2++) {
        res[raw[i2]] = raw[i2];
      }
      return res;
    }
    return raw;
  }
  function mergeAsArray$1(to, from) {
    return to ? [...new Set([].concat(to, from))] : from;
  }
  function mergeObjectOptions(to, from) {
    return to ? extend$2(/* @__PURE__ */ Object.create(null), to, from) : from;
  }
  function mergeEmitsOrPropsOptions(to, from) {
    if (to) {
      if (isArray$1(to) && isArray$1(from)) {
        return [.../* @__PURE__ */ new Set([...to, ...from])];
      }
      return extend$2(
        /* @__PURE__ */ Object.create(null),
        normalizePropsOrEmits(to),
        normalizePropsOrEmits(from != null ? from : {})
      );
    } else {
      return from;
    }
  }
  function mergeWatchOptions(to, from) {
    if (!to)
      return from;
    if (!from)
      return to;
    const merged = extend$2(/* @__PURE__ */ Object.create(null), to);
    for (const key in from) {
      merged[key] = mergeAsArray$1(to[key], from[key]);
    }
    return merged;
  }
  function createAppContext() {
    return {
      app: null,
      config: {
        isNativeTag: NO,
        performance: false,
        globalProperties: {},
        optionMergeStrategies: {},
        errorHandler: void 0,
        warnHandler: void 0,
        compilerOptions: {}
      },
      mixins: [],
      components: {},
      directives: {},
      provides: /* @__PURE__ */ Object.create(null),
      optionsCache: /* @__PURE__ */ new WeakMap(),
      propsCache: /* @__PURE__ */ new WeakMap(),
      emitsCache: /* @__PURE__ */ new WeakMap()
    };
  }
  let uid$1 = 0;
  function createAppAPI(render2, hydrate2) {
    return function createApp2(rootComponent, rootProps = null) {
      if (!isFunction$1(rootComponent)) {
        rootComponent = extend$2({}, rootComponent);
      }
      if (rootProps != null && !isObject$2(rootProps)) {
        !!(process.env.NODE_ENV !== "production") && warn$1(`root props passed to app.mount() must be an object.`);
        rootProps = null;
      }
      const context = createAppContext();
      const installedPlugins = /* @__PURE__ */ new WeakSet();
      let isMounted = false;
      const app = context.app = {
        _uid: uid$1++,
        _component: rootComponent,
        _props: rootProps,
        _container: null,
        _context: context,
        _instance: null,
        version,
        get config() {
          return context.config;
        },
        set config(v2) {
          if (!!(process.env.NODE_ENV !== "production")) {
            warn$1(
              `app.config cannot be replaced. Modify individual options instead.`
            );
          }
        },
        use(plugin, ...options) {
          if (installedPlugins.has(plugin)) {
            !!(process.env.NODE_ENV !== "production") && warn$1(`Plugin has already been applied to target app.`);
          } else if (plugin && isFunction$1(plugin.install)) {
            installedPlugins.add(plugin);
            plugin.install(app, ...options);
          } else if (isFunction$1(plugin)) {
            installedPlugins.add(plugin);
            plugin(app, ...options);
          } else if (!!(process.env.NODE_ENV !== "production")) {
            warn$1(
              `A plugin must either be a function or an object with an "install" function.`
            );
          }
          return app;
        },
        mixin(mixin) {
          if (__VUE_OPTIONS_API__) {
            if (!context.mixins.includes(mixin)) {
              context.mixins.push(mixin);
            } else if (!!(process.env.NODE_ENV !== "production")) {
              warn$1(
                "Mixin has already been applied to target app" + (mixin.name ? `: ${mixin.name}` : "")
              );
            }
          } else if (!!(process.env.NODE_ENV !== "production")) {
            warn$1("Mixins are only available in builds supporting Options API");
          }
          return app;
        },
        component(name2, component) {
          if (!!(process.env.NODE_ENV !== "production")) {
            validateComponentName(name2, context.config);
          }
          if (!component) {
            return context.components[name2];
          }
          if (!!(process.env.NODE_ENV !== "production") && context.components[name2]) {
            warn$1(`Component "${name2}" has already been registered in target app.`);
          }
          context.components[name2] = component;
          return app;
        },
        directive(name2, directive) {
          if (!!(process.env.NODE_ENV !== "production")) {
            validateDirectiveName(name2);
          }
          if (!directive) {
            return context.directives[name2];
          }
          if (!!(process.env.NODE_ENV !== "production") && context.directives[name2]) {
            warn$1(`Directive "${name2}" has already been registered in target app.`);
          }
          context.directives[name2] = directive;
          return app;
        },
        mount(rootContainer, isHydrate, namespace) {
          if (!isMounted) {
            if (!!(process.env.NODE_ENV !== "production") && rootContainer.__vue_app__) {
              warn$1(
                `There is already an app instance mounted on the host container.
 If you want to mount another app on the same host container, you need to unmount the previous app by calling \`app.unmount()\` first.`
              );
            }
            const vnode = createVNode(rootComponent, rootProps);
            vnode.appContext = context;
            if (namespace === true) {
              namespace = "svg";
            } else if (namespace === false) {
              namespace = void 0;
            }
            if (!!(process.env.NODE_ENV !== "production")) {
              context.reload = () => {
                render2(
                  cloneVNode(vnode),
                  rootContainer,
                  namespace
                );
              };
            }
            if (isHydrate && hydrate2) {
              hydrate2(vnode, rootContainer);
            } else {
              render2(vnode, rootContainer, namespace);
            }
            isMounted = true;
            app._container = rootContainer;
            rootContainer.__vue_app__ = app;
            if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
              app._instance = vnode.component;
              devtoolsInitApp(app, version);
            }
            return getExposeProxy(vnode.component) || vnode.component.proxy;
          } else if (!!(process.env.NODE_ENV !== "production")) {
            warn$1(
              `App has already been mounted.
If you want to remount the same app, move your app creation logic into a factory function and create fresh app instances for each mount - e.g. \`const createMyApp = () => createApp(App)\``
            );
          }
        },
        unmount() {
          if (isMounted) {
            render2(null, app._container);
            if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
              app._instance = null;
              devtoolsUnmountApp(app);
            }
            delete app._container.__vue_app__;
          } else if (!!(process.env.NODE_ENV !== "production")) {
            warn$1(`Cannot unmount an app that is not mounted.`);
          }
        },
        provide(key, value) {
          if (!!(process.env.NODE_ENV !== "production") && key in context.provides) {
            warn$1(
              `App already provides property with key "${String(key)}". It will be overwritten with the new value.`
            );
          }
          context.provides[key] = value;
          return app;
        },
        runWithContext(fn) {
          const lastApp = currentApp;
          currentApp = app;
          try {
            return fn();
          } finally {
            currentApp = lastApp;
          }
        }
      };
      return app;
    };
  }
  let currentApp = null;
  function provide(key, value) {
    if (!currentInstance) {
      if (!!(process.env.NODE_ENV !== "production")) {
        warn$1(`provide() can only be used inside setup().`);
      }
    } else {
      let provides = currentInstance.provides;
      const parentProvides = currentInstance.parent && currentInstance.parent.provides;
      if (parentProvides === provides) {
        provides = currentInstance.provides = Object.create(parentProvides);
      }
      provides[key] = value;
    }
  }
  function inject(key, defaultValue, treatDefaultAsFactory = false) {
    const instance = currentInstance || currentRenderingInstance;
    if (instance || currentApp) {
      const provides = instance ? instance.parent == null ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides : currentApp._context.provides;
      if (provides && key in provides) {
        return provides[key];
      } else if (arguments.length > 1) {
        return treatDefaultAsFactory && isFunction$1(defaultValue) ? defaultValue.call(instance && instance.proxy) : defaultValue;
      } else if (!!(process.env.NODE_ENV !== "production")) {
        warn$1(`injection "${String(key)}" not found.`);
      }
    } else if (!!(process.env.NODE_ENV !== "production")) {
      warn$1(`inject() can only be used inside setup() or functional components.`);
    }
  }
  function hasInjectionContext() {
    return !!(currentInstance || currentRenderingInstance || currentApp);
  }
  function initProps(instance, rawProps, isStateful, isSSR = false) {
    const props = {};
    const attrs = {};
    def(attrs, InternalObjectKey, 1);
    instance.propsDefaults = /* @__PURE__ */ Object.create(null);
    setFullProps(instance, rawProps, props, attrs);
    for (const key in instance.propsOptions[0]) {
      if (!(key in props)) {
        props[key] = void 0;
      }
    }
    if (!!(process.env.NODE_ENV !== "production")) {
      validateProps(rawProps || {}, props, instance);
    }
    if (isStateful) {
      instance.props = isSSR ? props : shallowReactive(props);
    } else {
      if (!instance.type.props) {
        instance.props = attrs;
      } else {
        instance.props = props;
      }
    }
    instance.attrs = attrs;
  }
  function isInHmrContext(instance) {
    while (instance) {
      if (instance.type.__hmrId)
        return true;
      instance = instance.parent;
    }
  }
  function updateProps(instance, rawProps, rawPrevProps, optimized) {
    const {
      props,
      attrs,
      vnode: { patchFlag }
    } = instance;
    const rawCurrentProps = toRaw(props);
    const [options] = instance.propsOptions;
    let hasAttrsChanged = false;
    if (
      // always force full diff in dev
      // - #1942 if hmr is enabled with sfc component
      // - vite#872 non-sfc component used by sfc component
      !(!!(process.env.NODE_ENV !== "production") && isInHmrContext(instance)) && (optimized || patchFlag > 0) && !(patchFlag & 16)
    ) {
      if (patchFlag & 8) {
        const propsToUpdate = instance.vnode.dynamicProps;
        for (let i2 = 0; i2 < propsToUpdate.length; i2++) {
          let key = propsToUpdate[i2];
          if (isEmitListener(instance.emitsOptions, key)) {
            continue;
          }
          const value = rawProps[key];
          if (options) {
            if (hasOwn(attrs, key)) {
              if (value !== attrs[key]) {
                attrs[key] = value;
                hasAttrsChanged = true;
              }
            } else {
              const camelizedKey = camelize(key);
              props[camelizedKey] = resolvePropValue(
                options,
                rawCurrentProps,
                camelizedKey,
                value,
                instance,
                false
              );
            }
          } else {
            if (value !== attrs[key]) {
              attrs[key] = value;
              hasAttrsChanged = true;
            }
          }
        }
      }
    } else {
      if (setFullProps(instance, rawProps, props, attrs)) {
        hasAttrsChanged = true;
      }
      let kebabKey;
      for (const key in rawCurrentProps) {
        if (!rawProps || // for camelCase
        !hasOwn(rawProps, key) && // it's possible the original props was passed in as kebab-case
        // and converted to camelCase (#955)
        ((kebabKey = hyphenate(key)) === key || !hasOwn(rawProps, kebabKey))) {
          if (options) {
            if (rawPrevProps && // for camelCase
            (rawPrevProps[key] !== void 0 || // for kebab-case
            rawPrevProps[kebabKey] !== void 0)) {
              props[key] = resolvePropValue(
                options,
                rawCurrentProps,
                key,
                void 0,
                instance,
                true
              );
            }
          } else {
            delete props[key];
          }
        }
      }
      if (attrs !== rawCurrentProps) {
        for (const key in attrs) {
          if (!rawProps || !hasOwn(rawProps, key) && true) {
            delete attrs[key];
            hasAttrsChanged = true;
          }
        }
      }
    }
    if (hasAttrsChanged) {
      trigger(instance, "set", "$attrs");
    }
    if (!!(process.env.NODE_ENV !== "production")) {
      validateProps(rawProps || {}, props, instance);
    }
  }
  function setFullProps(instance, rawProps, props, attrs) {
    const [options, needCastKeys] = instance.propsOptions;
    let hasAttrsChanged = false;
    let rawCastValues;
    if (rawProps) {
      for (let key in rawProps) {
        if (isReservedProp(key)) {
          continue;
        }
        const value = rawProps[key];
        let camelKey;
        if (options && hasOwn(options, camelKey = camelize(key))) {
          if (!needCastKeys || !needCastKeys.includes(camelKey)) {
            props[camelKey] = value;
          } else {
            (rawCastValues || (rawCastValues = {}))[camelKey] = value;
          }
        } else if (!isEmitListener(instance.emitsOptions, key)) {
          if (!(key in attrs) || value !== attrs[key]) {
            attrs[key] = value;
            hasAttrsChanged = true;
          }
        }
      }
    }
    if (needCastKeys) {
      const rawCurrentProps = toRaw(props);
      const castValues = rawCastValues || EMPTY_OBJ;
      for (let i2 = 0; i2 < needCastKeys.length; i2++) {
        const key = needCastKeys[i2];
        props[key] = resolvePropValue(
          options,
          rawCurrentProps,
          key,
          castValues[key],
          instance,
          !hasOwn(castValues, key)
        );
      }
    }
    return hasAttrsChanged;
  }
  function resolvePropValue(options, props, key, value, instance, isAbsent) {
    const opt = options[key];
    if (opt != null) {
      const hasDefault = hasOwn(opt, "default");
      if (hasDefault && value === void 0) {
        const defaultValue = opt.default;
        if (opt.type !== Function && !opt.skipFactory && isFunction$1(defaultValue)) {
          const { propsDefaults } = instance;
          if (key in propsDefaults) {
            value = propsDefaults[key];
          } else {
            const reset2 = setCurrentInstance(instance);
            value = propsDefaults[key] = defaultValue.call(
              null,
              props
            );
            reset2();
          }
        } else {
          value = defaultValue;
        }
      }
      if (opt[
        0
        /* shouldCast */
      ]) {
        if (isAbsent && !hasDefault) {
          value = false;
        } else if (opt[
          1
          /* shouldCastTrue */
        ] && (value === "" || value === hyphenate(key))) {
          value = true;
        }
      }
    }
    return value;
  }
  function normalizePropsOptions(comp, appContext, asMixin = false) {
    const cache2 = appContext.propsCache;
    const cached = cache2.get(comp);
    if (cached) {
      return cached;
    }
    const raw = comp.props;
    const normalized = {};
    const needCastKeys = [];
    let hasExtends = false;
    if (__VUE_OPTIONS_API__ && !isFunction$1(comp)) {
      const extendProps = (raw2) => {
        hasExtends = true;
        const [props, keys] = normalizePropsOptions(raw2, appContext, true);
        extend$2(normalized, props);
        if (keys)
          needCastKeys.push(...keys);
      };
      if (!asMixin && appContext.mixins.length) {
        appContext.mixins.forEach(extendProps);
      }
      if (comp.extends) {
        extendProps(comp.extends);
      }
      if (comp.mixins) {
        comp.mixins.forEach(extendProps);
      }
    }
    if (!raw && !hasExtends) {
      if (isObject$2(comp)) {
        cache2.set(comp, EMPTY_ARR);
      }
      return EMPTY_ARR;
    }
    if (isArray$1(raw)) {
      for (let i2 = 0; i2 < raw.length; i2++) {
        if (!!(process.env.NODE_ENV !== "production") && !isString$1(raw[i2])) {
          warn$1(`props must be strings when using array syntax.`, raw[i2]);
        }
        const normalizedKey = camelize(raw[i2]);
        if (validatePropName(normalizedKey)) {
          normalized[normalizedKey] = EMPTY_OBJ;
        }
      }
    } else if (raw) {
      if (!!(process.env.NODE_ENV !== "production") && !isObject$2(raw)) {
        warn$1(`invalid props options`, raw);
      }
      for (const key in raw) {
        const normalizedKey = camelize(key);
        if (validatePropName(normalizedKey)) {
          const opt = raw[key];
          const prop = normalized[normalizedKey] = isArray$1(opt) || isFunction$1(opt) ? { type: opt } : extend$2({}, opt);
          if (prop) {
            const booleanIndex = getTypeIndex(Boolean, prop.type);
            const stringIndex = getTypeIndex(String, prop.type);
            prop[
              0
              /* shouldCast */
            ] = booleanIndex > -1;
            prop[
              1
              /* shouldCastTrue */
            ] = stringIndex < 0 || booleanIndex < stringIndex;
            if (booleanIndex > -1 || hasOwn(prop, "default")) {
              needCastKeys.push(normalizedKey);
            }
          }
        }
      }
    }
    const res = [normalized, needCastKeys];
    if (isObject$2(comp)) {
      cache2.set(comp, res);
    }
    return res;
  }
  function validatePropName(key) {
    if (key[0] !== "$" && !isReservedProp(key)) {
      return true;
    } else if (!!(process.env.NODE_ENV !== "production")) {
      warn$1(`Invalid prop name: "${key}" is a reserved property.`);
    }
    return false;
  }
  function getType(ctor) {
    if (ctor === null) {
      return "null";
    }
    if (typeof ctor === "function") {
      return ctor.name || "";
    } else if (typeof ctor === "object") {
      const name2 = ctor.constructor && ctor.constructor.name;
      return name2 || "";
    }
    return "";
  }
  function isSameType(a2, b2) {
    return getType(a2) === getType(b2);
  }
  function getTypeIndex(type, expectedTypes) {
    if (isArray$1(expectedTypes)) {
      return expectedTypes.findIndex((t2) => isSameType(t2, type));
    } else if (isFunction$1(expectedTypes)) {
      return isSameType(expectedTypes, type) ? 0 : -1;
    }
    return -1;
  }
  function validateProps(rawProps, props, instance) {
    const resolvedValues = toRaw(props);
    const options = instance.propsOptions[0];
    for (const key in options) {
      let opt = options[key];
      if (opt == null)
        continue;
      validateProp(
        key,
        resolvedValues[key],
        opt,
        !!(process.env.NODE_ENV !== "production") ? shallowReadonly(resolvedValues) : resolvedValues,
        !hasOwn(rawProps, key) && !hasOwn(rawProps, hyphenate(key))
      );
    }
  }
  function validateProp(name2, value, prop, props, isAbsent) {
    const { type, required, validator: validator2, skipCheck } = prop;
    if (required && isAbsent) {
      warn$1('Missing required prop: "' + name2 + '"');
      return;
    }
    if (value == null && !required) {
      return;
    }
    if (type != null && type !== true && !skipCheck) {
      let isValid = false;
      const types2 = isArray$1(type) ? type : [type];
      const expectedTypes = [];
      for (let i2 = 0; i2 < types2.length && !isValid; i2++) {
        const { valid, expectedType } = assertType(value, types2[i2]);
        expectedTypes.push(expectedType || "");
        isValid = valid;
      }
      if (!isValid) {
        warn$1(getInvalidTypeMessage(name2, value, expectedTypes));
        return;
      }
    }
    if (validator2 && !validator2(value, props)) {
      warn$1('Invalid prop: custom validator check failed for prop "' + name2 + '".');
    }
  }
  const isSimpleType = /* @__PURE__ */ makeMap(
    "String,Number,Boolean,Function,Symbol,BigInt"
  );
  function assertType(value, type) {
    let valid;
    const expectedType = getType(type);
    if (isSimpleType(expectedType)) {
      const t2 = typeof value;
      valid = t2 === expectedType.toLowerCase();
      if (!valid && t2 === "object") {
        valid = value instanceof type;
      }
    } else if (expectedType === "Object") {
      valid = isObject$2(value);
    } else if (expectedType === "Array") {
      valid = isArray$1(value);
    } else if (expectedType === "null") {
      valid = value === null;
    } else {
      valid = value instanceof type;
    }
    return {
      valid,
      expectedType
    };
  }
  function getInvalidTypeMessage(name2, value, expectedTypes) {
    if (expectedTypes.length === 0) {
      return `Prop type [] for prop "${name2}" won't match anything. Did you mean to use type Array instead?`;
    }
    let message = `Invalid prop: type check failed for prop "${name2}". Expected ${expectedTypes.map(capitalize).join(" | ")}`;
    const expectedType = expectedTypes[0];
    const receivedType = toRawType(value);
    const expectedValue = styleValue(value, expectedType);
    const receivedValue = styleValue(value, receivedType);
    if (expectedTypes.length === 1 && isExplicable(expectedType) && !isBoolean$1(expectedType, receivedType)) {
      message += ` with value ${expectedValue}`;
    }
    message += `, got ${receivedType} `;
    if (isExplicable(receivedType)) {
      message += `with value ${receivedValue}.`;
    }
    return message;
  }
  function styleValue(value, type) {
    if (type === "String") {
      return `"${value}"`;
    } else if (type === "Number") {
      return `${Number(value)}`;
    } else {
      return `${value}`;
    }
  }
  function isExplicable(type) {
    const explicitTypes = ["string", "number", "boolean"];
    return explicitTypes.some((elem) => type.toLowerCase() === elem);
  }
  function isBoolean$1(...args) {
    return args.some((elem) => elem.toLowerCase() === "boolean");
  }
  const isInternalKey = (key) => key[0] === "_" || key === "$stable";
  const normalizeSlotValue = (value) => isArray$1(value) ? value.map(normalizeVNode) : [normalizeVNode(value)];
  const normalizeSlot = (key, rawSlot, ctx) => {
    if (rawSlot._n) {
      return rawSlot;
    }
    const normalized = withCtx((...args) => {
      if (!!(process.env.NODE_ENV !== "production") && currentInstance && (!ctx || ctx.root === currentInstance.root)) {
        warn$1(
          `Slot "${key}" invoked outside of the render function: this will not track dependencies used in the slot. Invoke the slot function inside the render function instead.`
        );
      }
      return normalizeSlotValue(rawSlot(...args));
    }, ctx);
    normalized._c = false;
    return normalized;
  };
  const normalizeObjectSlots = (rawSlots, slots, instance) => {
    const ctx = rawSlots._ctx;
    for (const key in rawSlots) {
      if (isInternalKey(key))
        continue;
      const value = rawSlots[key];
      if (isFunction$1(value)) {
        slots[key] = normalizeSlot(key, value, ctx);
      } else if (value != null) {
        if (!!(process.env.NODE_ENV !== "production") && true) {
          warn$1(
            `Non-function value encountered for slot "${key}". Prefer function slots for better performance.`
          );
        }
        const normalized = normalizeSlotValue(value);
        slots[key] = () => normalized;
      }
    }
  };
  const normalizeVNodeSlots = (instance, children) => {
    if (!!(process.env.NODE_ENV !== "production") && !isKeepAlive(instance.vnode) && true) {
      warn$1(
        `Non-function value encountered for default slot. Prefer function slots for better performance.`
      );
    }
    const normalized = normalizeSlotValue(children);
    instance.slots.default = () => normalized;
  };
  const initSlots = (instance, children) => {
    if (instance.vnode.shapeFlag & 32) {
      const type = children._;
      if (type) {
        instance.slots = toRaw(children);
        def(children, "_", type);
      } else {
        normalizeObjectSlots(
          children,
          instance.slots = {}
        );
      }
    } else {
      instance.slots = {};
      if (children) {
        normalizeVNodeSlots(instance, children);
      }
    }
    def(instance.slots, InternalObjectKey, 1);
  };
  const updateSlots = (instance, children, optimized) => {
    const { vnode, slots } = instance;
    let needDeletionCheck = true;
    let deletionComparisonTarget = EMPTY_OBJ;
    if (vnode.shapeFlag & 32) {
      const type = children._;
      if (type) {
        if (!!(process.env.NODE_ENV !== "production") && isHmrUpdating) {
          extend$2(slots, children);
          trigger(instance, "set", "$slots");
        } else if (optimized && type === 1) {
          needDeletionCheck = false;
        } else {
          extend$2(slots, children);
          if (!optimized && type === 1) {
            delete slots._;
          }
        }
      } else {
        needDeletionCheck = !children.$stable;
        normalizeObjectSlots(children, slots);
      }
      deletionComparisonTarget = children;
    } else if (children) {
      normalizeVNodeSlots(instance, children);
      deletionComparisonTarget = { default: 1 };
    }
    if (needDeletionCheck) {
      for (const key in slots) {
        if (!isInternalKey(key) && deletionComparisonTarget[key] == null) {
          delete slots[key];
        }
      }
    }
  };
  function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
    if (isArray$1(rawRef)) {
      rawRef.forEach(
        (r2, i2) => setRef(
          r2,
          oldRawRef && (isArray$1(oldRawRef) ? oldRawRef[i2] : oldRawRef),
          parentSuspense,
          vnode,
          isUnmount
        )
      );
      return;
    }
    if (isAsyncWrapper(vnode) && !isUnmount) {
      return;
    }
    const refValue = vnode.shapeFlag & 4 ? getExposeProxy(vnode.component) || vnode.component.proxy : vnode.el;
    const value = isUnmount ? null : refValue;
    const { i: owner, r: ref2 } = rawRef;
    if (!!(process.env.NODE_ENV !== "production") && !owner) {
      warn$1(
        `Missing ref owner context. ref cannot be used on hoisted vnodes. A vnode with ref must be created inside the render function.`
      );
      return;
    }
    const oldRef = oldRawRef && oldRawRef.r;
    const refs = owner.refs === EMPTY_OBJ ? owner.refs = {} : owner.refs;
    const setupState = owner.setupState;
    if (oldRef != null && oldRef !== ref2) {
      if (isString$1(oldRef)) {
        refs[oldRef] = null;
        if (hasOwn(setupState, oldRef)) {
          setupState[oldRef] = null;
        }
      } else if (isRef(oldRef)) {
        oldRef.value = null;
      }
    }
    if (isFunction$1(ref2)) {
      callWithErrorHandling(ref2, owner, 12, [value, refs]);
    } else {
      const _isString = isString$1(ref2);
      const _isRef = isRef(ref2);
      if (_isString || _isRef) {
        const doSet = () => {
          if (rawRef.f) {
            const existing = _isString ? hasOwn(setupState, ref2) ? setupState[ref2] : refs[ref2] : ref2.value;
            if (isUnmount) {
              isArray$1(existing) && remove$1(existing, refValue);
            } else {
              if (!isArray$1(existing)) {
                if (_isString) {
                  refs[ref2] = [refValue];
                  if (hasOwn(setupState, ref2)) {
                    setupState[ref2] = refs[ref2];
                  }
                } else {
                  ref2.value = [refValue];
                  if (rawRef.k)
                    refs[rawRef.k] = ref2.value;
                }
              } else if (!existing.includes(refValue)) {
                existing.push(refValue);
              }
            }
          } else if (_isString) {
            refs[ref2] = value;
            if (hasOwn(setupState, ref2)) {
              setupState[ref2] = value;
            }
          } else if (_isRef) {
            ref2.value = value;
            if (rawRef.k)
              refs[rawRef.k] = value;
          } else if (!!(process.env.NODE_ENV !== "production")) {
            warn$1("Invalid template ref type:", ref2, `(${typeof ref2})`);
          }
        };
        if (value) {
          doSet.id = -1;
          queuePostRenderEffect(doSet, parentSuspense);
        } else {
          doSet();
        }
      } else if (!!(process.env.NODE_ENV !== "production")) {
        warn$1("Invalid template ref type:", ref2, `(${typeof ref2})`);
      }
    }
  }
  let hasMismatch = false;
  const isSVGContainer = (container) => container.namespaceURI.includes("svg") && container.tagName !== "foreignObject";
  const isMathMLContainer = (container) => container.namespaceURI.includes("MathML");
  const getContainerType = (container) => {
    if (isSVGContainer(container))
      return "svg";
    if (isMathMLContainer(container))
      return "mathml";
    return void 0;
  };
  const isComment = (node) => node.nodeType === 8;
  function createHydrationFunctions(rendererInternals) {
    const {
      mt: mountComponent,
      p: patch,
      o: {
        patchProp: patchProp2,
        createText,
        nextSibling,
        parentNode,
        remove: remove2,
        insert: insert2,
        createComment
      }
    } = rendererInternals;
    const hydrate2 = (vnode, container) => {
      if (!container.hasChildNodes()) {
        (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_HYDRATION_MISMATCH_DETAILS__) && warn$1(
          `Attempting to hydrate existing markup but container is empty. Performing full mount instead.`
        );
        patch(null, vnode, container);
        flushPostFlushCbs();
        container._vnode = vnode;
        return;
      }
      hasMismatch = false;
      hydrateNode(container.firstChild, vnode, null, null, null);
      flushPostFlushCbs();
      container._vnode = vnode;
      if (hasMismatch && true) {
        console.error(`Hydration completed but contains mismatches.`);
      }
    };
    const hydrateNode = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized = false) => {
      const isFragmentStart = isComment(node) && node.data === "[";
      const onMismatch = () => handleMismatch(
        node,
        vnode,
        parentComponent,
        parentSuspense,
        slotScopeIds,
        isFragmentStart
      );
      const { type, ref: ref2, shapeFlag, patchFlag } = vnode;
      let domType = node.nodeType;
      vnode.el = node;
      if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
        if (!("__vnode" in node)) {
          Object.defineProperty(node, "__vnode", {
            value: vnode,
            enumerable: false
          });
        }
        if (!("__vueParentComponent" in node)) {
          Object.defineProperty(node, "__vueParentComponent", {
            value: parentComponent,
            enumerable: false
          });
        }
      }
      if (patchFlag === -2) {
        optimized = false;
        vnode.dynamicChildren = null;
      }
      let nextNode = null;
      switch (type) {
        case Text$2:
          if (domType !== 3) {
            if (vnode.children === "") {
              insert2(vnode.el = createText(""), parentNode(node), node);
              nextNode = node;
            } else {
              nextNode = onMismatch();
            }
          } else {
            if (node.data !== vnode.children) {
              hasMismatch = true;
              (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_HYDRATION_MISMATCH_DETAILS__) && warn$1(
                `Hydration text mismatch in`,
                node.parentNode,
                `
  - rendered on server: ${JSON.stringify(
                  node.data
                )}
  - expected on client: ${JSON.stringify(vnode.children)}`
              );
              node.data = vnode.children;
            }
            nextNode = nextSibling(node);
          }
          break;
        case Comment$1:
          if (isTemplateNode2(node)) {
            nextNode = nextSibling(node);
            replaceNode(
              vnode.el = node.content.firstChild,
              node,
              parentComponent
            );
          } else if (domType !== 8 || isFragmentStart) {
            nextNode = onMismatch();
          } else {
            nextNode = nextSibling(node);
          }
          break;
        case Static:
          if (isFragmentStart) {
            node = nextSibling(node);
            domType = node.nodeType;
          }
          if (domType === 1 || domType === 3) {
            nextNode = node;
            const needToAdoptContent = !vnode.children.length;
            for (let i2 = 0; i2 < vnode.staticCount; i2++) {
              if (needToAdoptContent)
                vnode.children += nextNode.nodeType === 1 ? nextNode.outerHTML : nextNode.data;
              if (i2 === vnode.staticCount - 1) {
                vnode.anchor = nextNode;
              }
              nextNode = nextSibling(nextNode);
            }
            return isFragmentStart ? nextSibling(nextNode) : nextNode;
          } else {
            onMismatch();
          }
          break;
        case Fragment:
          if (!isFragmentStart) {
            nextNode = onMismatch();
          } else {
            nextNode = hydrateFragment(
              node,
              vnode,
              parentComponent,
              parentSuspense,
              slotScopeIds,
              optimized
            );
          }
          break;
        default:
          if (shapeFlag & 1) {
            if ((domType !== 1 || vnode.type.toLowerCase() !== node.tagName.toLowerCase()) && !isTemplateNode2(node)) {
              nextNode = onMismatch();
            } else {
              nextNode = hydrateElement(
                node,
                vnode,
                parentComponent,
                parentSuspense,
                slotScopeIds,
                optimized
              );
            }
          } else if (shapeFlag & 6) {
            vnode.slotScopeIds = slotScopeIds;
            const container = parentNode(node);
            if (isFragmentStart) {
              nextNode = locateClosingAnchor(node);
            } else if (isComment(node) && node.data === "teleport start") {
              nextNode = locateClosingAnchor(node, node.data, "teleport end");
            } else {
              nextNode = nextSibling(node);
            }
            mountComponent(
              vnode,
              container,
              null,
              parentComponent,
              parentSuspense,
              getContainerType(container),
              optimized
            );
            if (isAsyncWrapper(vnode)) {
              let subTree;
              if (isFragmentStart) {
                subTree = createVNode(Fragment);
                subTree.anchor = nextNode ? nextNode.previousSibling : container.lastChild;
              } else {
                subTree = node.nodeType === 3 ? createTextVNode("") : createVNode("div");
              }
              subTree.el = node;
              vnode.component.subTree = subTree;
            }
          } else if (shapeFlag & 64) {
            if (domType !== 8) {
              nextNode = onMismatch();
            } else {
              nextNode = vnode.type.hydrate(
                node,
                vnode,
                parentComponent,
                parentSuspense,
                slotScopeIds,
                optimized,
                rendererInternals,
                hydrateChildren
              );
            }
          } else if (shapeFlag & 128) {
            nextNode = vnode.type.hydrate(
              node,
              vnode,
              parentComponent,
              parentSuspense,
              getContainerType(parentNode(node)),
              slotScopeIds,
              optimized,
              rendererInternals,
              hydrateNode
            );
          } else if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_HYDRATION_MISMATCH_DETAILS__) {
            warn$1("Invalid HostVNode type:", type, `(${typeof type})`);
          }
      }
      if (ref2 != null) {
        setRef(ref2, null, parentSuspense, vnode);
      }
      return nextNode;
    };
    const hydrateElement = (el, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {
      optimized = optimized || !!vnode.dynamicChildren;
      const { type, props, patchFlag, shapeFlag, dirs, transition } = vnode;
      const forcePatch = type === "input" || type === "option";
      if (!!(process.env.NODE_ENV !== "production") || forcePatch || patchFlag !== -1) {
        if (dirs) {
          invokeDirectiveHook(vnode, null, parentComponent, "created");
        }
        let needCallTransitionHooks = false;
        if (isTemplateNode2(el)) {
          needCallTransitionHooks = needTransition(parentSuspense, transition) && parentComponent && parentComponent.vnode.props && parentComponent.vnode.props.appear;
          const content2 = el.content.firstChild;
          if (needCallTransitionHooks) {
            transition.beforeEnter(content2);
          }
          replaceNode(content2, el, parentComponent);
          vnode.el = el = content2;
        }
        if (shapeFlag & 16 && // skip if element has innerHTML / textContent
        !(props && (props.innerHTML || props.textContent))) {
          let next = hydrateChildren(
            el.firstChild,
            vnode,
            el,
            parentComponent,
            parentSuspense,
            slotScopeIds,
            optimized
          );
          let hasWarned2 = false;
          while (next) {
            hasMismatch = true;
            if ((!!(process.env.NODE_ENV !== "production") || __VUE_PROD_HYDRATION_MISMATCH_DETAILS__) && !hasWarned2) {
              warn$1(
                `Hydration children mismatch on`,
                el,
                `
Server rendered element contains more child nodes than client vdom.`
              );
              hasWarned2 = true;
            }
            const cur2 = next;
            next = next.nextSibling;
            remove2(cur2);
          }
        } else if (shapeFlag & 8) {
          if (el.textContent !== vnode.children) {
            hasMismatch = true;
            (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_HYDRATION_MISMATCH_DETAILS__) && warn$1(
              `Hydration text content mismatch on`,
              el,
              `
  - rendered on server: ${el.textContent}
  - expected on client: ${vnode.children}`
            );
            el.textContent = vnode.children;
          }
        }
        if (props) {
          if (!!(process.env.NODE_ENV !== "production") || forcePatch || !optimized || patchFlag & (16 | 32)) {
            for (const key in props) {
              if (!!(process.env.NODE_ENV !== "production") && propHasMismatch(el, key, props[key], vnode, parentComponent)) {
                hasMismatch = true;
              }
              if (forcePatch && (key.endsWith("value") || key === "indeterminate") || isOn(key) && !isReservedProp(key) || // force hydrate v-bind with .prop modifiers
              key[0] === ".") {
                patchProp2(
                  el,
                  key,
                  null,
                  props[key],
                  void 0,
                  void 0,
                  parentComponent
                );
              }
            }
          } else if (props.onClick) {
            patchProp2(
              el,
              "onClick",
              null,
              props.onClick,
              void 0,
              void 0,
              parentComponent
            );
          }
        }
        let vnodeHooks;
        if (vnodeHooks = props && props.onVnodeBeforeMount) {
          invokeVNodeHook(vnodeHooks, parentComponent, vnode);
        }
        if (dirs) {
          invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
        }
        if ((vnodeHooks = props && props.onVnodeMounted) || dirs || needCallTransitionHooks) {
          queueEffectWithSuspense(() => {
            vnodeHooks && invokeVNodeHook(vnodeHooks, parentComponent, vnode);
            needCallTransitionHooks && transition.enter(el);
            dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
          }, parentSuspense);
        }
      }
      return el.nextSibling;
    };
    const hydrateChildren = (node, parentVNode, container, parentComponent, parentSuspense, slotScopeIds, optimized) => {
      optimized = optimized || !!parentVNode.dynamicChildren;
      const children = parentVNode.children;
      const l2 = children.length;
      let hasWarned2 = false;
      for (let i2 = 0; i2 < l2; i2++) {
        const vnode = optimized ? children[i2] : children[i2] = normalizeVNode(children[i2]);
        if (node) {
          node = hydrateNode(
            node,
            vnode,
            parentComponent,
            parentSuspense,
            slotScopeIds,
            optimized
          );
        } else if (vnode.type === Text$2 && !vnode.children) {
          continue;
        } else {
          hasMismatch = true;
          if ((!!(process.env.NODE_ENV !== "production") || __VUE_PROD_HYDRATION_MISMATCH_DETAILS__) && !hasWarned2) {
            warn$1(
              `Hydration children mismatch on`,
              container,
              `
Server rendered element contains fewer child nodes than client vdom.`
            );
            hasWarned2 = true;
          }
          patch(
            null,
            vnode,
            container,
            null,
            parentComponent,
            parentSuspense,
            getContainerType(container),
            slotScopeIds
          );
        }
      }
      return node;
    };
    const hydrateFragment = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {
      const { slotScopeIds: fragmentSlotScopeIds } = vnode;
      if (fragmentSlotScopeIds) {
        slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
      }
      const container = parentNode(node);
      const next = hydrateChildren(
        nextSibling(node),
        vnode,
        container,
        parentComponent,
        parentSuspense,
        slotScopeIds,
        optimized
      );
      if (next && isComment(next) && next.data === "]") {
        return nextSibling(vnode.anchor = next);
      } else {
        hasMismatch = true;
        insert2(vnode.anchor = createComment(`]`), container, next);
        return next;
      }
    };
    const handleMismatch = (node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragment) => {
      hasMismatch = true;
      (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_HYDRATION_MISMATCH_DETAILS__) && warn$1(
        `Hydration node mismatch:
- rendered on server:`,
        node,
        node.nodeType === 3 ? `(text)` : isComment(node) && node.data === "[" ? `(start of fragment)` : ``,
        `
- expected on client:`,
        vnode.type
      );
      vnode.el = null;
      if (isFragment) {
        const end = locateClosingAnchor(node);
        while (true) {
          const next2 = nextSibling(node);
          if (next2 && next2 !== end) {
            remove2(next2);
          } else {
            break;
          }
        }
      }
      const next = nextSibling(node);
      const container = parentNode(node);
      remove2(node);
      patch(
        null,
        vnode,
        container,
        next,
        parentComponent,
        parentSuspense,
        getContainerType(container),
        slotScopeIds
      );
      return next;
    };
    const locateClosingAnchor = (node, open = "[", close = "]") => {
      let match = 0;
      while (node) {
        node = nextSibling(node);
        if (node && isComment(node)) {
          if (node.data === open)
            match++;
          if (node.data === close) {
            if (match === 0) {
              return nextSibling(node);
            } else {
              match--;
            }
          }
        }
      }
      return node;
    };
    const replaceNode = (newNode, oldNode, parentComponent) => {
      const parentNode2 = oldNode.parentNode;
      if (parentNode2) {
        parentNode2.replaceChild(newNode, oldNode);
      }
      let parent = parentComponent;
      while (parent) {
        if (parent.vnode.el === oldNode) {
          parent.vnode.el = parent.subTree.el = newNode;
        }
        parent = parent.parent;
      }
    };
    const isTemplateNode2 = (node) => {
      return node.nodeType === 1 && node.tagName.toLowerCase() === "template";
    };
    return [hydrate2, hydrateNode];
  }
  function propHasMismatch(el, key, clientValue, vnode, instance) {
    var _a2;
    let mismatchType;
    let mismatchKey;
    let actual;
    let expected;
    if (key === "class") {
      actual = el.getAttribute("class");
      expected = normalizeClass(clientValue);
      if (!isSetEqual(toClassSet(actual || ""), toClassSet(expected))) {
        mismatchType = mismatchKey = `class`;
      }
    } else if (key === "style") {
      actual = el.getAttribute("style");
      expected = isString$1(clientValue) ? clientValue : stringifyStyle(normalizeStyle(clientValue));
      const actualMap = toStyleMap(actual);
      const expectedMap = toStyleMap(expected);
      if (vnode.dirs) {
        for (const { dir, value } of vnode.dirs) {
          if (dir.name === "show" && !value) {
            expectedMap.set("display", "none");
          }
        }
      }
      const root = instance == null ? void 0 : instance.subTree;
      if (vnode === root || (root == null ? void 0 : root.type) === Fragment && root.children.includes(vnode)) {
        const cssVars = (_a2 = instance == null ? void 0 : instance.getCssVars) == null ? void 0 : _a2.call(instance);
        for (const key2 in cssVars) {
          expectedMap.set(`--${key2}`, String(cssVars[key2]));
        }
      }
      if (!isMapEqual(actualMap, expectedMap)) {
        mismatchType = mismatchKey = "style";
      }
    } else if (el instanceof SVGElement && isKnownSvgAttr(key) || el instanceof HTMLElement && (isBooleanAttr(key) || isKnownHtmlAttr(key))) {
      if (isBooleanAttr(key)) {
        actual = el.hasAttribute(key);
        expected = includeBooleanAttr(clientValue);
      } else if (clientValue == null) {
        actual = el.hasAttribute(key);
        expected = false;
      } else {
        if (el.hasAttribute(key)) {
          actual = el.getAttribute(key);
        } else if (key === "value" && el.tagName === "TEXTAREA") {
          actual = el.value;
        } else {
          actual = false;
        }
        expected = isRenderableAttrValue(clientValue) ? String(clientValue) : false;
      }
      if (actual !== expected) {
        mismatchType = `attribute`;
        mismatchKey = key;
      }
    }
    if (mismatchType) {
      const format2 = (v2) => v2 === false ? `(not rendered)` : `${mismatchKey}="${v2}"`;
      const preSegment = `Hydration ${mismatchType} mismatch on`;
      const postSegment = `
  - rendered on server: ${format2(actual)}
  - expected on client: ${format2(expected)}
  Note: this mismatch is check-only. The DOM will not be rectified in production due to performance overhead.
  You should fix the source of the mismatch.`;
      {
        warn$1(preSegment, el, postSegment);
      }
      return true;
    }
    return false;
  }
  function toClassSet(str) {
    return new Set(str.trim().split(/\s+/));
  }
  function isSetEqual(a2, b2) {
    if (a2.size !== b2.size) {
      return false;
    }
    for (const s2 of a2) {
      if (!b2.has(s2)) {
        return false;
      }
    }
    return true;
  }
  function toStyleMap(str) {
    const styleMap = /* @__PURE__ */ new Map();
    for (const item of str.split(";")) {
      let [key, value] = item.split(":");
      key = key == null ? void 0 : key.trim();
      value = value == null ? void 0 : value.trim();
      if (key && value) {
        styleMap.set(key, value);
      }
    }
    return styleMap;
  }
  function isMapEqual(a2, b2) {
    if (a2.size !== b2.size) {
      return false;
    }
    for (const [key, value] of a2) {
      if (value !== b2.get(key)) {
        return false;
      }
    }
    return true;
  }
  let supported;
  let perf;
  function startMeasure(instance, type) {
    if (instance.appContext.config.performance && isSupported()) {
      perf.mark(`vue-${type}-${instance.uid}`);
    }
    if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
      devtoolsPerfStart(instance, type, isSupported() ? perf.now() : Date.now());
    }
  }
  function endMeasure(instance, type) {
    if (instance.appContext.config.performance && isSupported()) {
      const startTag = `vue-${type}-${instance.uid}`;
      const endTag2 = startTag + `:end`;
      perf.mark(endTag2);
      perf.measure(
        `<${formatComponentName(instance, instance.type)}> ${type}`,
        startTag,
        endTag2
      );
      perf.clearMarks(startTag);
      perf.clearMarks(endTag2);
    }
    if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
      devtoolsPerfEnd(instance, type, isSupported() ? perf.now() : Date.now());
    }
  }
  function isSupported() {
    if (supported !== void 0) {
      return supported;
    }
    if (typeof window !== "undefined" && window.performance) {
      supported = true;
      perf = window.performance;
    } else {
      supported = false;
    }
    return supported;
  }
  function initFeatureFlags() {
    const needWarn = [];
    if (typeof __VUE_OPTIONS_API__ !== "boolean") {
      !!(process.env.NODE_ENV !== "production") && needWarn.push(`__VUE_OPTIONS_API__`);
      getGlobalThis().__VUE_OPTIONS_API__ = true;
    }
    if (typeof __VUE_PROD_DEVTOOLS__ !== "boolean") {
      !!(process.env.NODE_ENV !== "production") && needWarn.push(`__VUE_PROD_DEVTOOLS__`);
      getGlobalThis().__VUE_PROD_DEVTOOLS__ = false;
    }
    if (typeof __VUE_PROD_HYDRATION_MISMATCH_DETAILS__ !== "boolean") {
      !!(process.env.NODE_ENV !== "production") && needWarn.push(`__VUE_PROD_HYDRATION_MISMATCH_DETAILS__`);
      getGlobalThis().__VUE_PROD_HYDRATION_MISMATCH_DETAILS__ = false;
    }
    if (!!(process.env.NODE_ENV !== "production") && needWarn.length) {
      const multi = needWarn.length > 1;
      console.warn(
        `Feature flag${multi ? `s` : ``} ${needWarn.join(", ")} ${multi ? `are` : `is`} not explicitly defined. You are running the esm-bundler build of Vue, which expects these compile-time feature flags to be globally injected via the bundler config in order to get better tree-shaking in the production bundle.

For more details, see https://link.vuejs.org/feature-flags.`
      );
    }
  }
  const queuePostRenderEffect = queueEffectWithSuspense;
  function createRenderer(options) {
    return baseCreateRenderer(options);
  }
  function createHydrationRenderer(options) {
    return baseCreateRenderer(options, createHydrationFunctions);
  }
  function baseCreateRenderer(options, createHydrationFns) {
    {
      initFeatureFlags();
    }
    const target = getGlobalThis();
    target.__VUE__ = true;
    if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
      setDevtoolsHook$1(target.__VUE_DEVTOOLS_GLOBAL_HOOK__, target);
    }
    const {
      insert: hostInsert,
      remove: hostRemove,
      patchProp: hostPatchProp,
      createElement: hostCreateElement,
      createText: hostCreateText,
      createComment: hostCreateComment,
      setText: hostSetText,
      setElementText: hostSetElementText,
      parentNode: hostParentNode,
      nextSibling: hostNextSibling,
      setScopeId: hostSetScopeId = NOOP,
      insertStaticContent: hostInsertStaticContent
    } = options;
    const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, namespace = void 0, slotScopeIds = null, optimized = !!(process.env.NODE_ENV !== "production") && isHmrUpdating ? false : !!n2.dynamicChildren) => {
      if (n1 === n2) {
        return;
      }
      if (n1 && !isSameVNodeType(n1, n2)) {
        anchor = getNextHostNode(n1);
        unmount(n1, parentComponent, parentSuspense, true);
        n1 = null;
      }
      if (n2.patchFlag === -2) {
        optimized = false;
        n2.dynamicChildren = null;
      }
      const { type, ref: ref2, shapeFlag } = n2;
      switch (type) {
        case Text$2:
          processText(n1, n2, container, anchor);
          break;
        case Comment$1:
          processCommentNode(n1, n2, container, anchor);
          break;
        case Static:
          if (n1 == null) {
            mountStaticNode(n2, container, anchor, namespace);
          } else if (!!(process.env.NODE_ENV !== "production")) {
            patchStaticNode(n1, n2, container, namespace);
          }
          break;
        case Fragment:
          processFragment(
            n1,
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          break;
        default:
          if (shapeFlag & 1) {
            processElement(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else if (shapeFlag & 6) {
            processComponent(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else if (shapeFlag & 64) {
            type.process(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized,
              internals
            );
          } else if (shapeFlag & 128) {
            type.process(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized,
              internals
            );
          } else if (!!(process.env.NODE_ENV !== "production")) {
            warn$1("Invalid VNode type:", type, `(${typeof type})`);
          }
      }
      if (ref2 != null && parentComponent) {
        setRef(ref2, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
      }
    };
    const processText = (n1, n2, container, anchor) => {
      if (n1 == null) {
        hostInsert(
          n2.el = hostCreateText(n2.children),
          container,
          anchor
        );
      } else {
        const el = n2.el = n1.el;
        if (n2.children !== n1.children) {
          hostSetText(el, n2.children);
        }
      }
    };
    const processCommentNode = (n1, n2, container, anchor) => {
      if (n1 == null) {
        hostInsert(
          n2.el = hostCreateComment(n2.children || ""),
          container,
          anchor
        );
      } else {
        n2.el = n1.el;
      }
    };
    const mountStaticNode = (n2, container, anchor, namespace) => {
      [n2.el, n2.anchor] = hostInsertStaticContent(
        n2.children,
        container,
        anchor,
        namespace,
        n2.el,
        n2.anchor
      );
    };
    const patchStaticNode = (n1, n2, container, namespace) => {
      if (n2.children !== n1.children) {
        const anchor = hostNextSibling(n1.anchor);
        removeStaticNode(n1);
        [n2.el, n2.anchor] = hostInsertStaticContent(
          n2.children,
          container,
          anchor,
          namespace
        );
      } else {
        n2.el = n1.el;
        n2.anchor = n1.anchor;
      }
    };
    const moveStaticNode = ({ el, anchor }, container, nextSibling) => {
      let next;
      while (el && el !== anchor) {
        next = hostNextSibling(el);
        hostInsert(el, container, nextSibling);
        el = next;
      }
      hostInsert(anchor, container, nextSibling);
    };
    const removeStaticNode = ({ el, anchor }) => {
      let next;
      while (el && el !== anchor) {
        next = hostNextSibling(el);
        hostRemove(el);
        el = next;
      }
      hostRemove(anchor);
    };
    const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      if (n2.type === "svg") {
        namespace = "svg";
      } else if (n2.type === "math") {
        namespace = "mathml";
      }
      if (n1 == null) {
        mountElement(
          n2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      } else {
        patchElement(
          n1,
          n2,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      }
    };
    const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      let el;
      let vnodeHook;
      const { props, shapeFlag, transition, dirs } = vnode;
      el = vnode.el = hostCreateElement(
        vnode.type,
        namespace,
        props && props.is,
        props
      );
      if (shapeFlag & 8) {
        hostSetElementText(el, vnode.children);
      } else if (shapeFlag & 16) {
        mountChildren(
          vnode.children,
          el,
          null,
          parentComponent,
          parentSuspense,
          resolveChildrenNamespace(vnode, namespace),
          slotScopeIds,
          optimized
        );
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "created");
      }
      setScopeId(el, vnode, vnode.scopeId, slotScopeIds, parentComponent);
      if (props) {
        for (const key in props) {
          if (key !== "value" && !isReservedProp(key)) {
            hostPatchProp(
              el,
              key,
              null,
              props[key],
              namespace,
              vnode.children,
              parentComponent,
              parentSuspense,
              unmountChildren
            );
          }
        }
        if ("value" in props) {
          hostPatchProp(el, "value", null, props.value, namespace);
        }
        if (vnodeHook = props.onVnodeBeforeMount) {
          invokeVNodeHook(vnodeHook, parentComponent, vnode);
        }
      }
      if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
        Object.defineProperty(el, "__vnode", {
          value: vnode,
          enumerable: false
        });
        Object.defineProperty(el, "__vueParentComponent", {
          value: parentComponent,
          enumerable: false
        });
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
      }
      const needCallTransitionHooks = needTransition(parentSuspense, transition);
      if (needCallTransitionHooks) {
        transition.beforeEnter(el);
      }
      hostInsert(el, container, anchor);
      if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) {
        queuePostRenderEffect(() => {
          vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
          needCallTransitionHooks && transition.enter(el);
          dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
        }, parentSuspense);
      }
    };
    const setScopeId = (el, vnode, scopeId, slotScopeIds, parentComponent) => {
      if (scopeId) {
        hostSetScopeId(el, scopeId);
      }
      if (slotScopeIds) {
        for (let i2 = 0; i2 < slotScopeIds.length; i2++) {
          hostSetScopeId(el, slotScopeIds[i2]);
        }
      }
      if (parentComponent) {
        let subTree = parentComponent.subTree;
        if (!!(process.env.NODE_ENV !== "production") && subTree.patchFlag > 0 && subTree.patchFlag & 2048) {
          subTree = filterSingleRoot(subTree.children) || subTree;
        }
        if (vnode === subTree) {
          const parentVNode = parentComponent.vnode;
          setScopeId(
            el,
            parentVNode,
            parentVNode.scopeId,
            parentVNode.slotScopeIds,
            parentComponent.parent
          );
        }
      }
    };
    const mountChildren = (children, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, start = 0) => {
      for (let i2 = start; i2 < children.length; i2++) {
        const child = children[i2] = optimized ? cloneIfMounted(children[i2]) : normalizeVNode(children[i2]);
        patch(
          null,
          child,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      }
    };
    const patchElement = (n1, n2, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      const el = n2.el = n1.el;
      let { patchFlag, dynamicChildren, dirs } = n2;
      patchFlag |= n1.patchFlag & 16;
      const oldProps = n1.props || EMPTY_OBJ;
      const newProps = n2.props || EMPTY_OBJ;
      let vnodeHook;
      parentComponent && toggleRecurse(parentComponent, false);
      if (vnodeHook = newProps.onVnodeBeforeUpdate) {
        invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
      }
      if (dirs) {
        invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
      }
      parentComponent && toggleRecurse(parentComponent, true);
      if (!!(process.env.NODE_ENV !== "production") && isHmrUpdating) {
        patchFlag = 0;
        optimized = false;
        dynamicChildren = null;
      }
      if (dynamicChildren) {
        patchBlockChildren(
          n1.dynamicChildren,
          dynamicChildren,
          el,
          parentComponent,
          parentSuspense,
          resolveChildrenNamespace(n2, namespace),
          slotScopeIds
        );
        if (!!(process.env.NODE_ENV !== "production")) {
          traverseStaticChildren(n1, n2);
        }
      } else if (!optimized) {
        patchChildren(
          n1,
          n2,
          el,
          null,
          parentComponent,
          parentSuspense,
          resolveChildrenNamespace(n2, namespace),
          slotScopeIds,
          false
        );
      }
      if (patchFlag > 0) {
        if (patchFlag & 16) {
          patchProps(
            el,
            n2,
            oldProps,
            newProps,
            parentComponent,
            parentSuspense,
            namespace
          );
        } else {
          if (patchFlag & 2) {
            if (oldProps.class !== newProps.class) {
              hostPatchProp(el, "class", null, newProps.class, namespace);
            }
          }
          if (patchFlag & 4) {
            hostPatchProp(el, "style", oldProps.style, newProps.style, namespace);
          }
          if (patchFlag & 8) {
            const propsToUpdate = n2.dynamicProps;
            for (let i2 = 0; i2 < propsToUpdate.length; i2++) {
              const key = propsToUpdate[i2];
              const prev = oldProps[key];
              const next = newProps[key];
              if (next !== prev || key === "value") {
                hostPatchProp(
                  el,
                  key,
                  prev,
                  next,
                  namespace,
                  n1.children,
                  parentComponent,
                  parentSuspense,
                  unmountChildren
                );
              }
            }
          }
        }
        if (patchFlag & 1) {
          if (n1.children !== n2.children) {
            hostSetElementText(el, n2.children);
          }
        }
      } else if (!optimized && dynamicChildren == null) {
        patchProps(
          el,
          n2,
          oldProps,
          newProps,
          parentComponent,
          parentSuspense,
          namespace
        );
      }
      if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {
        queuePostRenderEffect(() => {
          vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
          dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
        }, parentSuspense);
      }
    };
    const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, namespace, slotScopeIds) => {
      for (let i2 = 0; i2 < newChildren.length; i2++) {
        const oldVNode = oldChildren[i2];
        const newVNode = newChildren[i2];
        const container = (
          // oldVNode may be an errored async setup() component inside Suspense
          // which will not have a mounted element
          oldVNode.el && // - In the case of a Fragment, we need to provide the actual parent
          // of the Fragment itself so it can move its children.
          (oldVNode.type === Fragment || // - In the case of different nodes, there is going to be a replacement
          // which also requires the correct parent container
          !isSameVNodeType(oldVNode, newVNode) || // - In the case of a component, it could contain anything.
          oldVNode.shapeFlag & (6 | 64)) ? hostParentNode(oldVNode.el) : (
            // In other cases, the parent container is not actually used so we
            // just pass the block element here to avoid a DOM parentNode call.
            fallbackContainer
          )
        );
        patch(
          oldVNode,
          newVNode,
          container,
          null,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          true
        );
      }
    };
    const patchProps = (el, vnode, oldProps, newProps, parentComponent, parentSuspense, namespace) => {
      if (oldProps !== newProps) {
        if (oldProps !== EMPTY_OBJ) {
          for (const key in oldProps) {
            if (!isReservedProp(key) && !(key in newProps)) {
              hostPatchProp(
                el,
                key,
                oldProps[key],
                null,
                namespace,
                vnode.children,
                parentComponent,
                parentSuspense,
                unmountChildren
              );
            }
          }
        }
        for (const key in newProps) {
          if (isReservedProp(key))
            continue;
          const next = newProps[key];
          const prev = oldProps[key];
          if (next !== prev && key !== "value") {
            hostPatchProp(
              el,
              key,
              prev,
              next,
              namespace,
              vnode.children,
              parentComponent,
              parentSuspense,
              unmountChildren
            );
          }
        }
        if ("value" in newProps) {
          hostPatchProp(el, "value", oldProps.value, newProps.value, namespace);
        }
      }
    };
    const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
      const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
      let { patchFlag, dynamicChildren, slotScopeIds: fragmentSlotScopeIds } = n2;
      if (!!(process.env.NODE_ENV !== "production") && // #5523 dev root fragment may inherit directives
      (isHmrUpdating || patchFlag & 2048)) {
        patchFlag = 0;
        optimized = false;
        dynamicChildren = null;
      }
      if (fragmentSlotScopeIds) {
        slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
      }
      if (n1 == null) {
        hostInsert(fragmentStartAnchor, container, anchor);
        hostInsert(fragmentEndAnchor, container, anchor);
        mountChildren(
          // #10007
          // such fragment like `<></>` will be compiled into
          // a fragment which doesn't have a children.
          // In this case fallback to an empty array
          n2.children || [],
          container,
          fragmentEndAnchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      } else {
        if (patchFlag > 0 && patchFlag & 64 && dynamicChildren && // #2715 the previous fragment could've been a BAILed one as a result
        // of renderSlot() with no valid children
        n1.dynamicChildren) {
          patchBlockChildren(
            n1.dynamicChildren,
            dynamicChildren,
            container,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds
          );
          if (!!(process.env.NODE_ENV !== "production")) {
            traverseStaticChildren(n1, n2);
          } else if (
            // #2080 if the stable fragment has a key, it's a <template v-for> that may
            //  get moved around. Make sure all root level vnodes inherit el.
            // #2134 or if it's a component root, it may also get moved around
            // as the component is being moved.
            n2.key != null || parentComponent && n2 === parentComponent.subTree
          ) {
            traverseStaticChildren(
              n1,
              n2,
              true
              /* shallow */
            );
          }
        } else {
          patchChildren(
            n1,
            n2,
            container,
            fragmentEndAnchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        }
      }
    };
    const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      n2.slotScopeIds = slotScopeIds;
      if (n1 == null) {
        if (n2.shapeFlag & 512) {
          parentComponent.ctx.activate(
            n2,
            container,
            anchor,
            namespace,
            optimized
          );
        } else {
          mountComponent(
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            optimized
          );
        }
      } else {
        updateComponent(n1, n2, optimized);
      }
    };
    const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, namespace, optimized) => {
      const instance = initialVNode.component = createComponentInstance(
        initialVNode,
        parentComponent,
        parentSuspense
      );
      if (!!(process.env.NODE_ENV !== "production") && instance.type.__hmrId) {
        registerHMR(instance);
      }
      if (!!(process.env.NODE_ENV !== "production")) {
        pushWarningContext(initialVNode);
        startMeasure(instance, `mount`);
      }
      if (isKeepAlive(initialVNode)) {
        instance.ctx.renderer = internals;
      }
      {
        if (!!(process.env.NODE_ENV !== "production")) {
          startMeasure(instance, `init`);
        }
        setupComponent(instance);
        if (!!(process.env.NODE_ENV !== "production")) {
          endMeasure(instance, `init`);
        }
      }
      if (instance.asyncDep) {
        parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect);
        if (!initialVNode.el) {
          const placeholder = instance.subTree = createVNode(Comment$1);
          processCommentNode(null, placeholder, container, anchor);
        }
      } else {
        setupRenderEffect(
          instance,
          initialVNode,
          container,
          anchor,
          parentSuspense,
          namespace,
          optimized
        );
      }
      if (!!(process.env.NODE_ENV !== "production")) {
        popWarningContext();
        endMeasure(instance, `mount`);
      }
    };
    const updateComponent = (n1, n2, optimized) => {
      const instance = n2.component = n1.component;
      if (shouldUpdateComponent(n1, n2, optimized)) {
        if (instance.asyncDep && !instance.asyncResolved) {
          if (!!(process.env.NODE_ENV !== "production")) {
            pushWarningContext(n2);
          }
          updateComponentPreRender(instance, n2, optimized);
          if (!!(process.env.NODE_ENV !== "production")) {
            popWarningContext();
          }
          return;
        } else {
          instance.next = n2;
          invalidateJob(instance.update);
          instance.effect.dirty = true;
          instance.update();
        }
      } else {
        n2.el = n1.el;
        instance.vnode = n2;
      }
    };
    const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, namespace, optimized) => {
      const componentUpdateFn = () => {
        if (!instance.isMounted) {
          let vnodeHook;
          const { el, props } = initialVNode;
          const { bm, m: m2, parent } = instance;
          const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
          toggleRecurse(instance, false);
          if (bm) {
            invokeArrayFns(bm);
          }
          if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) {
            invokeVNodeHook(vnodeHook, parent, initialVNode);
          }
          toggleRecurse(instance, true);
          if (el && hydrateNode) {
            const hydrateSubTree = () => {
              if (!!(process.env.NODE_ENV !== "production")) {
                startMeasure(instance, `render`);
              }
              instance.subTree = renderComponentRoot(instance);
              if (!!(process.env.NODE_ENV !== "production")) {
                endMeasure(instance, `render`);
              }
              if (!!(process.env.NODE_ENV !== "production")) {
                startMeasure(instance, `hydrate`);
              }
              hydrateNode(
                el,
                instance.subTree,
                instance,
                parentSuspense,
                null
              );
              if (!!(process.env.NODE_ENV !== "production")) {
                endMeasure(instance, `hydrate`);
              }
            };
            if (isAsyncWrapperVNode) {
              initialVNode.type.__asyncLoader().then(
                // note: we are moving the render call into an async callback,
                // which means it won't track dependencies - but it's ok because
                // a server-rendered async wrapper is already in resolved state
                // and it will never need to change.
                () => !instance.isUnmounted && hydrateSubTree()
              );
            } else {
              hydrateSubTree();
            }
          } else {
            if (!!(process.env.NODE_ENV !== "production")) {
              startMeasure(instance, `render`);
            }
            const subTree = instance.subTree = renderComponentRoot(instance);
            if (!!(process.env.NODE_ENV !== "production")) {
              endMeasure(instance, `render`);
            }
            if (!!(process.env.NODE_ENV !== "production")) {
              startMeasure(instance, `patch`);
            }
            patch(
              null,
              subTree,
              container,
              anchor,
              instance,
              parentSuspense,
              namespace
            );
            if (!!(process.env.NODE_ENV !== "production")) {
              endMeasure(instance, `patch`);
            }
            initialVNode.el = subTree.el;
          }
          if (m2) {
            queuePostRenderEffect(m2, parentSuspense);
          }
          if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
            const scopedInitialVNode = initialVNode;
            queuePostRenderEffect(
              () => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode),
              parentSuspense
            );
          }
          if (initialVNode.shapeFlag & 256 || parent && isAsyncWrapper(parent.vnode) && parent.vnode.shapeFlag & 256) {
            instance.a && queuePostRenderEffect(instance.a, parentSuspense);
          }
          instance.isMounted = true;
          if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
            devtoolsComponentAdded(instance);
          }
          initialVNode = container = anchor = null;
        } else {
          let { next, bu, u: u2, parent, vnode } = instance;
          {
            const nonHydratedAsyncRoot = locateNonHydratedAsyncRoot(instance);
            if (nonHydratedAsyncRoot) {
              if (next) {
                next.el = vnode.el;
                updateComponentPreRender(instance, next, optimized);
              }
              nonHydratedAsyncRoot.asyncDep.then(() => {
                if (!instance.isUnmounted) {
                  componentUpdateFn();
                }
              });
              return;
            }
          }
          let originNext = next;
          let vnodeHook;
          if (!!(process.env.NODE_ENV !== "production")) {
            pushWarningContext(next || instance.vnode);
          }
          toggleRecurse(instance, false);
          if (next) {
            next.el = vnode.el;
            updateComponentPreRender(instance, next, optimized);
          } else {
            next = vnode;
          }
          if (bu) {
            invokeArrayFns(bu);
          }
          if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) {
            invokeVNodeHook(vnodeHook, parent, next, vnode);
          }
          toggleRecurse(instance, true);
          if (!!(process.env.NODE_ENV !== "production")) {
            startMeasure(instance, `render`);
          }
          const nextTree = renderComponentRoot(instance);
          if (!!(process.env.NODE_ENV !== "production")) {
            endMeasure(instance, `render`);
          }
          const prevTree = instance.subTree;
          instance.subTree = nextTree;
          if (!!(process.env.NODE_ENV !== "production")) {
            startMeasure(instance, `patch`);
          }
          patch(
            prevTree,
            nextTree,
            // parent may have changed if it's in a teleport
            hostParentNode(prevTree.el),
            // anchor may have changed if it's in a fragment
            getNextHostNode(prevTree),
            instance,
            parentSuspense,
            namespace
          );
          if (!!(process.env.NODE_ENV !== "production")) {
            endMeasure(instance, `patch`);
          }
          next.el = nextTree.el;
          if (originNext === null) {
            updateHOCHostEl(instance, nextTree.el);
          }
          if (u2) {
            queuePostRenderEffect(u2, parentSuspense);
          }
          if (vnodeHook = next.props && next.props.onVnodeUpdated) {
            queuePostRenderEffect(
              () => invokeVNodeHook(vnodeHook, parent, next, vnode),
              parentSuspense
            );
          }
          if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
            devtoolsComponentUpdated(instance);
          }
          if (!!(process.env.NODE_ENV !== "production")) {
            popWarningContext();
          }
        }
      };
      const effect2 = instance.effect = new ReactiveEffect(
        componentUpdateFn,
        NOOP,
        () => queueJob(update),
        instance.scope
        // track it in component's effect scope
      );
      const update = instance.update = () => {
        if (effect2.dirty) {
          effect2.run();
        }
      };
      update.id = instance.uid;
      toggleRecurse(instance, true);
      if (!!(process.env.NODE_ENV !== "production")) {
        effect2.onTrack = instance.rtc ? (e2) => invokeArrayFns(instance.rtc, e2) : void 0;
        effect2.onTrigger = instance.rtg ? (e2) => invokeArrayFns(instance.rtg, e2) : void 0;
        update.ownerInstance = instance;
      }
      update();
    };
    const updateComponentPreRender = (instance, nextVNode, optimized) => {
      nextVNode.component = instance;
      const prevProps = instance.vnode.props;
      instance.vnode = nextVNode;
      instance.next = null;
      updateProps(instance, nextVNode.props, prevProps, optimized);
      updateSlots(instance, nextVNode.children, optimized);
      pauseTracking();
      flushPreFlushCbs(instance);
      resetTracking();
    };
    const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized = false) => {
      const c1 = n1 && n1.children;
      const prevShapeFlag = n1 ? n1.shapeFlag : 0;
      const c2 = n2.children;
      const { patchFlag, shapeFlag } = n2;
      if (patchFlag > 0) {
        if (patchFlag & 128) {
          patchKeyedChildren(
            c1,
            c2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          return;
        } else if (patchFlag & 256) {
          patchUnkeyedChildren(
            c1,
            c2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          return;
        }
      }
      if (shapeFlag & 8) {
        if (prevShapeFlag & 16) {
          unmountChildren(c1, parentComponent, parentSuspense);
        }
        if (c2 !== c1) {
          hostSetElementText(container, c2);
        }
      } else {
        if (prevShapeFlag & 16) {
          if (shapeFlag & 16) {
            patchKeyedChildren(
              c1,
              c2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else {
            unmountChildren(c1, parentComponent, parentSuspense, true);
          }
        } else {
          if (prevShapeFlag & 8) {
            hostSetElementText(container, "");
          }
          if (shapeFlag & 16) {
            mountChildren(
              c2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          }
        }
      }
    };
    const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      c1 = c1 || EMPTY_ARR;
      c2 = c2 || EMPTY_ARR;
      const oldLength = c1.length;
      const newLength = c2.length;
      const commonLength = Math.min(oldLength, newLength);
      let i2;
      for (i2 = 0; i2 < commonLength; i2++) {
        const nextChild = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
        patch(
          c1[i2],
          nextChild,
          container,
          null,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      }
      if (oldLength > newLength) {
        unmountChildren(
          c1,
          parentComponent,
          parentSuspense,
          true,
          false,
          commonLength
        );
      } else {
        mountChildren(
          c2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized,
          commonLength
        );
      }
    };
    const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      let i2 = 0;
      const l2 = c2.length;
      let e1 = c1.length - 1;
      let e2 = l2 - 1;
      while (i2 <= e1 && i2 <= e2) {
        const n1 = c1[i2];
        const n2 = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
        if (isSameVNodeType(n1, n2)) {
          patch(
            n1,
            n2,
            container,
            null,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else {
          break;
        }
        i2++;
      }
      while (i2 <= e1 && i2 <= e2) {
        const n1 = c1[e1];
        const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
        if (isSameVNodeType(n1, n2)) {
          patch(
            n1,
            n2,
            container,
            null,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else {
          break;
        }
        e1--;
        e2--;
      }
      if (i2 > e1) {
        if (i2 <= e2) {
          const nextPos = e2 + 1;
          const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
          while (i2 <= e2) {
            patch(
              null,
              c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]),
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
            i2++;
          }
        }
      } else if (i2 > e2) {
        while (i2 <= e1) {
          unmount(c1[i2], parentComponent, parentSuspense, true);
          i2++;
        }
      } else {
        const s1 = i2;
        const s2 = i2;
        const keyToNewIndexMap = /* @__PURE__ */ new Map();
        for (i2 = s2; i2 <= e2; i2++) {
          const nextChild = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
          if (nextChild.key != null) {
            if (!!(process.env.NODE_ENV !== "production") && keyToNewIndexMap.has(nextChild.key)) {
              warn$1(
                `Duplicate keys found during update:`,
                JSON.stringify(nextChild.key),
                `Make sure keys are unique.`
              );
            }
            keyToNewIndexMap.set(nextChild.key, i2);
          }
        }
        let j2;
        let patched = 0;
        const toBePatched = e2 - s2 + 1;
        let moved = false;
        let maxNewIndexSoFar = 0;
        const newIndexToOldIndexMap = new Array(toBePatched);
        for (i2 = 0; i2 < toBePatched; i2++)
          newIndexToOldIndexMap[i2] = 0;
        for (i2 = s1; i2 <= e1; i2++) {
          const prevChild = c1[i2];
          if (patched >= toBePatched) {
            unmount(prevChild, parentComponent, parentSuspense, true);
            continue;
          }
          let newIndex;
          if (prevChild.key != null) {
            newIndex = keyToNewIndexMap.get(prevChild.key);
          } else {
            for (j2 = s2; j2 <= e2; j2++) {
              if (newIndexToOldIndexMap[j2 - s2] === 0 && isSameVNodeType(prevChild, c2[j2])) {
                newIndex = j2;
                break;
              }
            }
          }
          if (newIndex === void 0) {
            unmount(prevChild, parentComponent, parentSuspense, true);
          } else {
            newIndexToOldIndexMap[newIndex - s2] = i2 + 1;
            if (newIndex >= maxNewIndexSoFar) {
              maxNewIndexSoFar = newIndex;
            } else {
              moved = true;
            }
            patch(
              prevChild,
              c2[newIndex],
              container,
              null,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
            patched++;
          }
        }
        const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : EMPTY_ARR;
        j2 = increasingNewIndexSequence.length - 1;
        for (i2 = toBePatched - 1; i2 >= 0; i2--) {
          const nextIndex = s2 + i2;
          const nextChild = c2[nextIndex];
          const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;
          if (newIndexToOldIndexMap[i2] === 0) {
            patch(
              null,
              nextChild,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else if (moved) {
            if (j2 < 0 || i2 !== increasingNewIndexSequence[j2]) {
              move(nextChild, container, anchor, 2);
            } else {
              j2--;
            }
          }
        }
      }
    };
    const move = (vnode, container, anchor, moveType, parentSuspense = null) => {
      const { el, type, transition, children, shapeFlag } = vnode;
      if (shapeFlag & 6) {
        move(vnode.component.subTree, container, anchor, moveType);
        return;
      }
      if (shapeFlag & 128) {
        vnode.suspense.move(container, anchor, moveType);
        return;
      }
      if (shapeFlag & 64) {
        type.move(vnode, container, anchor, internals);
        return;
      }
      if (type === Fragment) {
        hostInsert(el, container, anchor);
        for (let i2 = 0; i2 < children.length; i2++) {
          move(children[i2], container, anchor, moveType);
        }
        hostInsert(vnode.anchor, container, anchor);
        return;
      }
      if (type === Static) {
        moveStaticNode(vnode, container, anchor);
        return;
      }
      const needTransition2 = moveType !== 2 && shapeFlag & 1 && transition;
      if (needTransition2) {
        if (moveType === 0) {
          transition.beforeEnter(el);
          hostInsert(el, container, anchor);
          queuePostRenderEffect(() => transition.enter(el), parentSuspense);
        } else {
          const { leave, delayLeave, afterLeave } = transition;
          const remove22 = () => hostInsert(el, container, anchor);
          const performLeave = () => {
            leave(el, () => {
              remove22();
              afterLeave && afterLeave();
            });
          };
          if (delayLeave) {
            delayLeave(el, remove22, performLeave);
          } else {
            performLeave();
          }
        }
      } else {
        hostInsert(el, container, anchor);
      }
    };
    const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {
      const {
        type,
        props,
        ref: ref2,
        children,
        dynamicChildren,
        shapeFlag,
        patchFlag,
        dirs
      } = vnode;
      if (ref2 != null) {
        setRef(ref2, null, parentSuspense, vnode, true);
      }
      if (shapeFlag & 256) {
        parentComponent.ctx.deactivate(vnode);
        return;
      }
      const shouldInvokeDirs = shapeFlag & 1 && dirs;
      const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
      let vnodeHook;
      if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) {
        invokeVNodeHook(vnodeHook, parentComponent, vnode);
      }
      if (shapeFlag & 6) {
        unmountComponent(vnode.component, parentSuspense, doRemove);
      } else {
        if (shapeFlag & 128) {
          vnode.suspense.unmount(parentSuspense, doRemove);
          return;
        }
        if (shouldInvokeDirs) {
          invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
        }
        if (shapeFlag & 64) {
          vnode.type.remove(
            vnode,
            parentComponent,
            parentSuspense,
            optimized,
            internals,
            doRemove
          );
        } else if (dynamicChildren && // #1153: fast path should not be taken for non-stable (v-for) fragments
        (type !== Fragment || patchFlag > 0 && patchFlag & 64)) {
          unmountChildren(
            dynamicChildren,
            parentComponent,
            parentSuspense,
            false,
            true
          );
        } else if (type === Fragment && patchFlag & (128 | 256) || !optimized && shapeFlag & 16) {
          unmountChildren(children, parentComponent, parentSuspense);
        }
        if (doRemove) {
          remove2(vnode);
        }
      }
      if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) {
        queuePostRenderEffect(() => {
          vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
          shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
        }, parentSuspense);
      }
    };
    const remove2 = (vnode) => {
      const { type, el, anchor, transition } = vnode;
      if (type === Fragment) {
        if (!!(process.env.NODE_ENV !== "production") && vnode.patchFlag > 0 && vnode.patchFlag & 2048 && transition && !transition.persisted) {
          vnode.children.forEach((child) => {
            if (child.type === Comment$1) {
              hostRemove(child.el);
            } else {
              remove2(child);
            }
          });
        } else {
          removeFragment(el, anchor);
        }
        return;
      }
      if (type === Static) {
        removeStaticNode(vnode);
        return;
      }
      const performRemove = () => {
        hostRemove(el);
        if (transition && !transition.persisted && transition.afterLeave) {
          transition.afterLeave();
        }
      };
      if (vnode.shapeFlag & 1 && transition && !transition.persisted) {
        const { leave, delayLeave } = transition;
        const performLeave = () => leave(el, performRemove);
        if (delayLeave) {
          delayLeave(vnode.el, performRemove, performLeave);
        } else {
          performLeave();
        }
      } else {
        performRemove();
      }
    };
    const removeFragment = (cur2, end) => {
      let next;
      while (cur2 !== end) {
        next = hostNextSibling(cur2);
        hostRemove(cur2);
        cur2 = next;
      }
      hostRemove(end);
    };
    const unmountComponent = (instance, parentSuspense, doRemove) => {
      if (!!(process.env.NODE_ENV !== "production") && instance.type.__hmrId) {
        unregisterHMR(instance);
      }
      const { bum, scope, update, subTree, um } = instance;
      if (bum) {
        invokeArrayFns(bum);
      }
      scope.stop();
      if (update) {
        update.active = false;
        unmount(subTree, instance, parentSuspense, doRemove);
      }
      if (um) {
        queuePostRenderEffect(um, parentSuspense);
      }
      queuePostRenderEffect(() => {
        instance.isUnmounted = true;
      }, parentSuspense);
      if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
        parentSuspense.deps--;
        if (parentSuspense.deps === 0) {
          parentSuspense.resolve();
        }
      }
      if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
        devtoolsComponentRemoved(instance);
      }
    };
    const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start = 0) => {
      for (let i2 = start; i2 < children.length; i2++) {
        unmount(children[i2], parentComponent, parentSuspense, doRemove, optimized);
      }
    };
    const getNextHostNode = (vnode) => {
      if (vnode.shapeFlag & 6) {
        return getNextHostNode(vnode.component.subTree);
      }
      if (vnode.shapeFlag & 128) {
        return vnode.suspense.next();
      }
      return hostNextSibling(vnode.anchor || vnode.el);
    };
    let isFlushing2 = false;
    const render2 = (vnode, container, namespace) => {
      if (vnode == null) {
        if (container._vnode) {
          unmount(container._vnode, null, null, true);
        }
      } else {
        patch(
          container._vnode || null,
          vnode,
          container,
          null,
          null,
          null,
          namespace
        );
      }
      if (!isFlushing2) {
        isFlushing2 = true;
        flushPreFlushCbs();
        flushPostFlushCbs();
        isFlushing2 = false;
      }
      container._vnode = vnode;
    };
    const internals = {
      p: patch,
      um: unmount,
      m: move,
      r: remove2,
      mt: mountComponent,
      mc: mountChildren,
      pc: patchChildren,
      pbc: patchBlockChildren,
      n: getNextHostNode,
      o: options
    };
    let hydrate2;
    let hydrateNode;
    if (createHydrationFns) {
      [hydrate2, hydrateNode] = createHydrationFns(
        internals
      );
    }
    return {
      render: render2,
      hydrate: hydrate2,
      createApp: createAppAPI(render2, hydrate2)
    };
  }
  function resolveChildrenNamespace({ type, props }, currentNamespace) {
    return currentNamespace === "svg" && type === "foreignObject" || currentNamespace === "mathml" && type === "annotation-xml" && props && props.encoding && props.encoding.includes("html") ? void 0 : currentNamespace;
  }
  function toggleRecurse({ effect: effect2, update }, allowed) {
    effect2.allowRecurse = update.allowRecurse = allowed;
  }
  function needTransition(parentSuspense, transition) {
    return (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
  }
  function traverseStaticChildren(n1, n2, shallow = false) {
    const ch1 = n1.children;
    const ch2 = n2.children;
    if (isArray$1(ch1) && isArray$1(ch2)) {
      for (let i2 = 0; i2 < ch1.length; i2++) {
        const c1 = ch1[i2];
        let c2 = ch2[i2];
        if (c2.shapeFlag & 1 && !c2.dynamicChildren) {
          if (c2.patchFlag <= 0 || c2.patchFlag === 32) {
            c2 = ch2[i2] = cloneIfMounted(ch2[i2]);
            c2.el = c1.el;
          }
          if (!shallow)
            traverseStaticChildren(c1, c2);
        }
        if (c2.type === Text$2) {
          c2.el = c1.el;
        }
        if (!!(process.env.NODE_ENV !== "production") && c2.type === Comment$1 && !c2.el) {
          c2.el = c1.el;
        }
      }
    }
  }
  function getSequence(arr) {
    const p2 = arr.slice();
    const result = [0];
    let i2, j2, u2, v2, c2;
    const len = arr.length;
    for (i2 = 0; i2 < len; i2++) {
      const arrI = arr[i2];
      if (arrI !== 0) {
        j2 = result[result.length - 1];
        if (arr[j2] < arrI) {
          p2[i2] = j2;
          result.push(i2);
          continue;
        }
        u2 = 0;
        v2 = result.length - 1;
        while (u2 < v2) {
          c2 = u2 + v2 >> 1;
          if (arr[result[c2]] < arrI) {
            u2 = c2 + 1;
          } else {
            v2 = c2;
          }
        }
        if (arrI < arr[result[u2]]) {
          if (u2 > 0) {
            p2[i2] = result[u2 - 1];
          }
          result[u2] = i2;
        }
      }
    }
    u2 = result.length;
    v2 = result[u2 - 1];
    while (u2-- > 0) {
      result[u2] = v2;
      v2 = p2[v2];
    }
    return result;
  }
  function locateNonHydratedAsyncRoot(instance) {
    const subComponent = instance.subTree.component;
    if (subComponent) {
      if (subComponent.asyncDep && !subComponent.asyncResolved) {
        return subComponent;
      } else {
        return locateNonHydratedAsyncRoot(subComponent);
      }
    }
  }
  const isTeleport = (type) => type.__isTeleport;
  const isTeleportDisabled = (props) => props && (props.disabled || props.disabled === "");
  const isTargetSVG = (target) => typeof SVGElement !== "undefined" && target instanceof SVGElement;
  const isTargetMathML = (target) => typeof MathMLElement === "function" && target instanceof MathMLElement;
  const resolveTarget = (props, select) => {
    const targetSelector = props && props.to;
    if (isString$1(targetSelector)) {
      if (!select) {
        !!(process.env.NODE_ENV !== "production") && warn$1(
          `Current renderer does not support string target for Teleports. (missing querySelector renderer option)`
        );
        return null;
      } else {
        const target = select(targetSelector);
        if (!target) {
          !!(process.env.NODE_ENV !== "production") && warn$1(
            `Failed to locate Teleport target with selector "${targetSelector}". Note the target element must exist before the component is mounted - i.e. the target cannot be rendered by the component itself, and ideally should be outside of the entire Vue component tree.`
          );
        }
        return target;
      }
    } else {
      if (!!(process.env.NODE_ENV !== "production") && !targetSelector && !isTeleportDisabled(props)) {
        warn$1(`Invalid Teleport target: ${targetSelector}`);
      }
      return targetSelector;
    }
  };
  const TeleportImpl = {
    name: "Teleport",
    __isTeleport: true,
    process(n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, internals) {
      const {
        mc: mountChildren,
        pc: patchChildren,
        pbc: patchBlockChildren,
        o: { insert: insert2, querySelector, createText, createComment }
      } = internals;
      const disabled = isTeleportDisabled(n2.props);
      let { shapeFlag, children, dynamicChildren } = n2;
      if (!!(process.env.NODE_ENV !== "production") && isHmrUpdating) {
        optimized = false;
        dynamicChildren = null;
      }
      if (n1 == null) {
        const placeholder = n2.el = !!(process.env.NODE_ENV !== "production") ? createComment("teleport start") : createText("");
        const mainAnchor = n2.anchor = !!(process.env.NODE_ENV !== "production") ? createComment("teleport end") : createText("");
        insert2(placeholder, container, anchor);
        insert2(mainAnchor, container, anchor);
        const target = n2.target = resolveTarget(n2.props, querySelector);
        const targetAnchor = n2.targetAnchor = createText("");
        if (target) {
          insert2(targetAnchor, target);
          if (namespace === "svg" || isTargetSVG(target)) {
            namespace = "svg";
          } else if (namespace === "mathml" || isTargetMathML(target)) {
            namespace = "mathml";
          }
        } else if (!!(process.env.NODE_ENV !== "production") && !disabled) {
          warn$1("Invalid Teleport target on mount:", target, `(${typeof target})`);
        }
        const mount = (container2, anchor2) => {
          if (shapeFlag & 16) {
            mountChildren(
              children,
              container2,
              anchor2,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          }
        };
        if (disabled) {
          mount(container, mainAnchor);
        } else if (target) {
          mount(target, targetAnchor);
        }
      } else {
        n2.el = n1.el;
        const mainAnchor = n2.anchor = n1.anchor;
        const target = n2.target = n1.target;
        const targetAnchor = n2.targetAnchor = n1.targetAnchor;
        const wasDisabled = isTeleportDisabled(n1.props);
        const currentContainer = wasDisabled ? container : target;
        const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;
        if (namespace === "svg" || isTargetSVG(target)) {
          namespace = "svg";
        } else if (namespace === "mathml" || isTargetMathML(target)) {
          namespace = "mathml";
        }
        if (dynamicChildren) {
          patchBlockChildren(
            n1.dynamicChildren,
            dynamicChildren,
            currentContainer,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds
          );
          traverseStaticChildren(n1, n2, true);
        } else if (!optimized) {
          patchChildren(
            n1,
            n2,
            currentContainer,
            currentAnchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            false
          );
        }
        if (disabled) {
          if (!wasDisabled) {
            moveTeleport(
              n2,
              container,
              mainAnchor,
              internals,
              1
            );
          } else {
            if (n2.props && n1.props && n2.props.to !== n1.props.to) {
              n2.props.to = n1.props.to;
            }
          }
        } else {
          if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {
            const nextTarget = n2.target = resolveTarget(
              n2.props,
              querySelector
            );
            if (nextTarget) {
              moveTeleport(
                n2,
                nextTarget,
                null,
                internals,
                0
              );
            } else if (!!(process.env.NODE_ENV !== "production")) {
              warn$1(
                "Invalid Teleport target on update:",
                target,
                `(${typeof target})`
              );
            }
          } else if (wasDisabled) {
            moveTeleport(
              n2,
              target,
              targetAnchor,
              internals,
              1
            );
          }
        }
      }
      updateCssVars(n2);
    },
    remove(vnode, parentComponent, parentSuspense, optimized, { um: unmount, o: { remove: hostRemove } }, doRemove) {
      const { shapeFlag, children, anchor, targetAnchor, target, props } = vnode;
      if (target) {
        hostRemove(targetAnchor);
      }
      doRemove && hostRemove(anchor);
      if (shapeFlag & 16) {
        const shouldRemove = doRemove || !isTeleportDisabled(props);
        for (let i2 = 0; i2 < children.length; i2++) {
          const child = children[i2];
          unmount(
            child,
            parentComponent,
            parentSuspense,
            shouldRemove,
            !!child.dynamicChildren
          );
        }
      }
    },
    move: moveTeleport,
    hydrate: hydrateTeleport
  };
  function moveTeleport(vnode, container, parentAnchor, { o: { insert: insert2 }, m: move }, moveType = 2) {
    if (moveType === 0) {
      insert2(vnode.targetAnchor, container, parentAnchor);
    }
    const { el, anchor, shapeFlag, children, props } = vnode;
    const isReorder = moveType === 2;
    if (isReorder) {
      insert2(el, container, parentAnchor);
    }
    if (!isReorder || isTeleportDisabled(props)) {
      if (shapeFlag & 16) {
        for (let i2 = 0; i2 < children.length; i2++) {
          move(
            children[i2],
            container,
            parentAnchor,
            2
          );
        }
      }
    }
    if (isReorder) {
      insert2(anchor, container, parentAnchor);
    }
  }
  function hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, {
    o: { nextSibling, parentNode, querySelector }
  }, hydrateChildren) {
    const target = vnode.target = resolveTarget(
      vnode.props,
      querySelector
    );
    if (target) {
      const targetNode = target._lpa || target.firstChild;
      if (vnode.shapeFlag & 16) {
        if (isTeleportDisabled(vnode.props)) {
          vnode.anchor = hydrateChildren(
            nextSibling(node),
            vnode,
            parentNode(node),
            parentComponent,
            parentSuspense,
            slotScopeIds,
            optimized
          );
          vnode.targetAnchor = targetNode;
        } else {
          vnode.anchor = nextSibling(node);
          let targetAnchor = targetNode;
          while (targetAnchor) {
            targetAnchor = nextSibling(targetAnchor);
            if (targetAnchor && targetAnchor.nodeType === 8 && targetAnchor.data === "teleport anchor") {
              vnode.targetAnchor = targetAnchor;
              target._lpa = vnode.targetAnchor && nextSibling(vnode.targetAnchor);
              break;
            }
          }
          hydrateChildren(
            targetNode,
            vnode,
            target,
            parentComponent,
            parentSuspense,
            slotScopeIds,
            optimized
          );
        }
      }
      updateCssVars(vnode);
    }
    return vnode.anchor && nextSibling(vnode.anchor);
  }
  const Teleport = TeleportImpl;
  function updateCssVars(vnode) {
    const ctx = vnode.ctx;
    if (ctx && ctx.ut) {
      let node = vnode.children[0].el;
      while (node && node !== vnode.targetAnchor) {
        if (node.nodeType === 1)
          node.setAttribute("data-v-owner", ctx.uid);
        node = node.nextSibling;
      }
      ctx.ut();
    }
  }
  const Fragment = Symbol.for("v-fgt");
  const Text$2 = Symbol.for("v-txt");
  const Comment$1 = Symbol.for("v-cmt");
  const Static = Symbol.for("v-stc");
  const blockStack = [];
  let currentBlock = null;
  function openBlock(disableTracking = false) {
    blockStack.push(currentBlock = disableTracking ? null : []);
  }
  function closeBlock() {
    blockStack.pop();
    currentBlock = blockStack[blockStack.length - 1] || null;
  }
  let isBlockTreeEnabled = 1;
  function setBlockTracking(value) {
    isBlockTreeEnabled += value;
  }
  function setupBlock(vnode) {
    vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || EMPTY_ARR : null;
    closeBlock();
    if (isBlockTreeEnabled > 0 && currentBlock) {
      currentBlock.push(vnode);
    }
    return vnode;
  }
  function createElementBlock(type, props, children, patchFlag, dynamicProps, shapeFlag) {
    return setupBlock(
      createBaseVNode(
        type,
        props,
        children,
        patchFlag,
        dynamicProps,
        shapeFlag,
        true
      )
    );
  }
  function createBlock(type, props, children, patchFlag, dynamicProps) {
    return setupBlock(
      createVNode(
        type,
        props,
        children,
        patchFlag,
        dynamicProps,
        true
      )
    );
  }
  function isVNode(value) {
    return value ? value.__v_isVNode === true : false;
  }
  function isSameVNodeType(n1, n2) {
    if (!!(process.env.NODE_ENV !== "production") && n2.shapeFlag & 6 && hmrDirtyComponents.has(n2.type)) {
      n1.shapeFlag &= ~256;
      n2.shapeFlag &= ~512;
      return false;
    }
    return n1.type === n2.type && n1.key === n2.key;
  }
  let vnodeArgsTransformer;
  function transformVNodeArgs(transformer) {
    vnodeArgsTransformer = transformer;
  }
  const createVNodeWithArgsTransform = (...args) => {
    return _createVNode(
      ...vnodeArgsTransformer ? vnodeArgsTransformer(args, currentRenderingInstance) : args
    );
  };
  const InternalObjectKey = `__vInternal`;
  const normalizeKey = ({ key }) => key != null ? key : null;
  const normalizeRef = ({
    ref: ref2,
    ref_key,
    ref_for
  }) => {
    if (typeof ref2 === "number") {
      ref2 = "" + ref2;
    }
    return ref2 != null ? isString$1(ref2) || isRef(ref2) || isFunction$1(ref2) ? { i: currentRenderingInstance, r: ref2, k: ref_key, f: !!ref_for } : ref2 : null;
  };
  function createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
    const vnode = {
      __v_isVNode: true,
      __v_skip: true,
      type,
      props,
      key: props && normalizeKey(props),
      ref: props && normalizeRef(props),
      scopeId: currentScopeId,
      slotScopeIds: null,
      children,
      component: null,
      suspense: null,
      ssContent: null,
      ssFallback: null,
      dirs: null,
      transition: null,
      el: null,
      anchor: null,
      target: null,
      targetAnchor: null,
      staticCount: 0,
      shapeFlag,
      patchFlag,
      dynamicProps,
      dynamicChildren: null,
      appContext: null,
      ctx: currentRenderingInstance
    };
    if (needFullChildrenNormalization) {
      normalizeChildren(vnode, children);
      if (shapeFlag & 128) {
        type.normalize(vnode);
      }
    } else if (children) {
      vnode.shapeFlag |= isString$1(children) ? 8 : 16;
    }
    if (!!(process.env.NODE_ENV !== "production") && vnode.key !== vnode.key) {
      warn$1(`VNode created with invalid key (NaN). VNode type:`, vnode.type);
    }
    if (isBlockTreeEnabled > 0 && // avoid a block node from tracking itself
    !isBlockNode && // has current parent block
    currentBlock && // presence of a patch flag indicates this node needs patching on updates.
    // component nodes also should always be patched, because even if the
    // component doesn't need to update, it needs to persist the instance on to
    // the next vnode so that it can be properly unmounted later.
    (vnode.patchFlag > 0 || shapeFlag & 6) && // the EVENTS flag is only for hydration and if it is the only flag, the
    // vnode should not be considered dynamic due to handler caching.
    vnode.patchFlag !== 32) {
      currentBlock.push(vnode);
    }
    return vnode;
  }
  const createVNode = !!(process.env.NODE_ENV !== "production") ? createVNodeWithArgsTransform : _createVNode;
  function _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
    if (!type || type === NULL_DYNAMIC_COMPONENT) {
      if (!!(process.env.NODE_ENV !== "production") && !type) {
        warn$1(`Invalid vnode type when creating vnode: ${type}.`);
      }
      type = Comment$1;
    }
    if (isVNode(type)) {
      const cloned = cloneVNode(
        type,
        props,
        true
        /* mergeRef: true */
      );
      if (children) {
        normalizeChildren(cloned, children);
      }
      if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock) {
        if (cloned.shapeFlag & 6) {
          currentBlock[currentBlock.indexOf(type)] = cloned;
        } else {
          currentBlock.push(cloned);
        }
      }
      cloned.patchFlag |= -2;
      return cloned;
    }
    if (isClassComponent(type)) {
      type = type.__vccOpts;
    }
    if (props) {
      props = guardReactiveProps(props);
      let { class: klass, style } = props;
      if (klass && !isString$1(klass)) {
        props.class = normalizeClass(klass);
      }
      if (isObject$2(style)) {
        if (isProxy(style) && !isArray$1(style)) {
          style = extend$2({}, style);
        }
        props.style = normalizeStyle(style);
      }
    }
    const shapeFlag = isString$1(type) ? 1 : isSuspense(type) ? 128 : isTeleport(type) ? 64 : isObject$2(type) ? 4 : isFunction$1(type) ? 2 : 0;
    if (!!(process.env.NODE_ENV !== "production") && shapeFlag & 4 && isProxy(type)) {
      type = toRaw(type);
      warn$1(
        `Vue received a Component that was made a reactive object. This can lead to unnecessary performance overhead and should be avoided by marking the component with \`markRaw\` or using \`shallowRef\` instead of \`ref\`.`,
        `
Component that was made reactive: `,
        type
      );
    }
    return createBaseVNode(
      type,
      props,
      children,
      patchFlag,
      dynamicProps,
      shapeFlag,
      isBlockNode,
      true
    );
  }
  function guardReactiveProps(props) {
    if (!props)
      return null;
    return isProxy(props) || InternalObjectKey in props ? extend$2({}, props) : props;
  }
  function cloneVNode(vnode, extraProps, mergeRef = false) {
    const { props, ref: ref2, patchFlag, children } = vnode;
    const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
    const cloned = {
      __v_isVNode: true,
      __v_skip: true,
      type: vnode.type,
      props: mergedProps,
      key: mergedProps && normalizeKey(mergedProps),
      ref: extraProps && extraProps.ref ? (
        // #2078 in the case of <component :is="vnode" ref="extra"/>
        // if the vnode itself already has a ref, cloneVNode will need to merge
        // the refs so the single vnode can be set on multiple refs
        mergeRef && ref2 ? isArray$1(ref2) ? ref2.concat(normalizeRef(extraProps)) : [ref2, normalizeRef(extraProps)] : normalizeRef(extraProps)
      ) : ref2,
      scopeId: vnode.scopeId,
      slotScopeIds: vnode.slotScopeIds,
      children: !!(process.env.NODE_ENV !== "production") && patchFlag === -1 && isArray$1(children) ? children.map(deepCloneVNode) : children,
      target: vnode.target,
      targetAnchor: vnode.targetAnchor,
      staticCount: vnode.staticCount,
      shapeFlag: vnode.shapeFlag,
      // if the vnode is cloned with extra props, we can no longer assume its
      // existing patch flag to be reliable and need to add the FULL_PROPS flag.
      // note: preserve flag for fragments since they use the flag for children
      // fast paths only.
      patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
      dynamicProps: vnode.dynamicProps,
      dynamicChildren: vnode.dynamicChildren,
      appContext: vnode.appContext,
      dirs: vnode.dirs,
      transition: vnode.transition,
      // These should technically only be non-null on mounted VNodes. However,
      // they *should* be copied for kept-alive vnodes. So we just always copy
      // them since them being non-null during a mount doesn't affect the logic as
      // they will simply be overwritten.
      component: vnode.component,
      suspense: vnode.suspense,
      ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
      ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
      el: vnode.el,
      anchor: vnode.anchor,
      ctx: vnode.ctx,
      ce: vnode.ce
    };
    return cloned;
  }
  function deepCloneVNode(vnode) {
    const cloned = cloneVNode(vnode);
    if (isArray$1(vnode.children)) {
      cloned.children = vnode.children.map(deepCloneVNode);
    }
    return cloned;
  }
  function createTextVNode(text = " ", flag = 0) {
    return createVNode(Text$2, null, text, flag);
  }
  function createStaticVNode(content2, numberOfNodes) {
    const vnode = createVNode(Static, null, content2);
    vnode.staticCount = numberOfNodes;
    return vnode;
  }
  function createCommentVNode(text = "", asBlock = false) {
    return asBlock ? (openBlock(), createBlock(Comment$1, null, text)) : createVNode(Comment$1, null, text);
  }
  function normalizeVNode(child) {
    if (child == null || typeof child === "boolean") {
      return createVNode(Comment$1);
    } else if (isArray$1(child)) {
      return createVNode(
        Fragment,
        null,
        // #3666, avoid reference pollution when reusing vnode
        child.slice()
      );
    } else if (typeof child === "object") {
      return cloneIfMounted(child);
    } else {
      return createVNode(Text$2, null, String(child));
    }
  }
  function cloneIfMounted(child) {
    return child.el === null && child.patchFlag !== -1 || child.memo ? child : cloneVNode(child);
  }
  function normalizeChildren(vnode, children) {
    let type = 0;
    const { shapeFlag } = vnode;
    if (children == null) {
      children = null;
    } else if (isArray$1(children)) {
      type = 16;
    } else if (typeof children === "object") {
      if (shapeFlag & (1 | 64)) {
        const slot = children.default;
        if (slot) {
          slot._c && (slot._d = false);
          normalizeChildren(vnode, slot());
          slot._c && (slot._d = true);
        }
        return;
      } else {
        type = 32;
        const slotFlag = children._;
        if (!slotFlag && !(InternalObjectKey in children)) {
          children._ctx = currentRenderingInstance;
        } else if (slotFlag === 3 && currentRenderingInstance) {
          if (currentRenderingInstance.slots._ === 1) {
            children._ = 1;
          } else {
            children._ = 2;
            vnode.patchFlag |= 1024;
          }
        }
      }
    } else if (isFunction$1(children)) {
      children = { default: children, _ctx: currentRenderingInstance };
      type = 32;
    } else {
      children = String(children);
      if (shapeFlag & 64) {
        type = 16;
        children = [createTextVNode(children)];
      } else {
        type = 8;
      }
    }
    vnode.children = children;
    vnode.shapeFlag |= type;
  }
  function mergeProps(...args) {
    const ret = {};
    for (let i2 = 0; i2 < args.length; i2++) {
      const toMerge = args[i2];
      for (const key in toMerge) {
        if (key === "class") {
          if (ret.class !== toMerge.class) {
            ret.class = normalizeClass([ret.class, toMerge.class]);
          }
        } else if (key === "style") {
          ret.style = normalizeStyle([ret.style, toMerge.style]);
        } else if (isOn(key)) {
          const existing = ret[key];
          const incoming = toMerge[key];
          if (incoming && existing !== incoming && !(isArray$1(existing) && existing.includes(incoming))) {
            ret[key] = existing ? [].concat(existing, incoming) : incoming;
          }
        } else if (key !== "") {
          ret[key] = toMerge[key];
        }
      }
    }
    return ret;
  }
  function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
    callWithAsyncErrorHandling(hook, instance, 7, [
      vnode,
      prevVNode
    ]);
  }
  const emptyAppContext = createAppContext();
  let uid = 0;
  function createComponentInstance(vnode, parent, suspense) {
    const type = vnode.type;
    const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
    const instance = {
      uid: uid++,
      vnode,
      type,
      parent,
      appContext,
      root: null,
      // to be immediately set
      next: null,
      subTree: null,
      // will be set synchronously right after creation
      effect: null,
      update: null,
      // will be set synchronously right after creation
      scope: new EffectScope(
        true
        /* detached */
      ),
      render: null,
      proxy: null,
      exposed: null,
      exposeProxy: null,
      withProxy: null,
      provides: parent ? parent.provides : Object.create(appContext.provides),
      accessCache: null,
      renderCache: [],
      // local resolved assets
      components: null,
      directives: null,
      // resolved props and emits options
      propsOptions: normalizePropsOptions(type, appContext),
      emitsOptions: normalizeEmitsOptions(type, appContext),
      // emit
      emit: null,
      // to be set immediately
      emitted: null,
      // props default value
      propsDefaults: EMPTY_OBJ,
      // inheritAttrs
      inheritAttrs: type.inheritAttrs,
      // state
      ctx: EMPTY_OBJ,
      data: EMPTY_OBJ,
      props: EMPTY_OBJ,
      attrs: EMPTY_OBJ,
      slots: EMPTY_OBJ,
      refs: EMPTY_OBJ,
      setupState: EMPTY_OBJ,
      setupContext: null,
      attrsProxy: null,
      slotsProxy: null,
      // suspense related
      suspense,
      suspenseId: suspense ? suspense.pendingId : 0,
      asyncDep: null,
      asyncResolved: false,
      // lifecycle hooks
      // not using enums here because it results in computed properties
      isMounted: false,
      isUnmounted: false,
      isDeactivated: false,
      bc: null,
      c: null,
      bm: null,
      m: null,
      bu: null,
      u: null,
      um: null,
      bum: null,
      da: null,
      a: null,
      rtg: null,
      rtc: null,
      ec: null,
      sp: null
    };
    if (!!(process.env.NODE_ENV !== "production")) {
      instance.ctx = createDevRenderContext(instance);
    } else {
      instance.ctx = { _: instance };
    }
    instance.root = parent ? parent.root : instance;
    instance.emit = emit.bind(null, instance);
    if (vnode.ce) {
      vnode.ce(instance);
    }
    return instance;
  }
  let currentInstance = null;
  const getCurrentInstance = () => currentInstance || currentRenderingInstance;
  let internalSetCurrentInstance;
  let setInSSRSetupState;
  {
    const g = getGlobalThis();
    const registerGlobalSetter = (key, setter) => {
      let setters;
      if (!(setters = g[key]))
        setters = g[key] = [];
      setters.push(setter);
      return (v2) => {
        if (setters.length > 1)
          setters.forEach((set2) => set2(v2));
        else
          setters[0](v2);
      };
    };
    internalSetCurrentInstance = registerGlobalSetter(
      `__VUE_INSTANCE_SETTERS__`,
      (v2) => currentInstance = v2
    );
    setInSSRSetupState = registerGlobalSetter(
      `__VUE_SSR_SETTERS__`,
      (v2) => isInSSRComponentSetup = v2
    );
  }
  const setCurrentInstance = (instance) => {
    const prev = currentInstance;
    internalSetCurrentInstance(instance);
    instance.scope.on();
    return () => {
      instance.scope.off();
      internalSetCurrentInstance(prev);
    };
  };
  const unsetCurrentInstance = () => {
    currentInstance && currentInstance.scope.off();
    internalSetCurrentInstance(null);
  };
  const isBuiltInTag = /* @__PURE__ */ makeMap("slot,component");
  function validateComponentName(name2, { isNativeTag }) {
    if (isBuiltInTag(name2) || isNativeTag(name2)) {
      warn$1(
        "Do not use built-in or reserved HTML elements as component id: " + name2
      );
    }
  }
  function isStatefulComponent(instance) {
    return instance.vnode.shapeFlag & 4;
  }
  let isInSSRComponentSetup = false;
  function setupComponent(instance, isSSR = false) {
    isSSR && setInSSRSetupState(isSSR);
    const { props, children } = instance.vnode;
    const isStateful = isStatefulComponent(instance);
    initProps(instance, props, isStateful, isSSR);
    initSlots(instance, children);
    const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : void 0;
    isSSR && setInSSRSetupState(false);
    return setupResult;
  }
  function setupStatefulComponent(instance, isSSR) {
    var _a2;
    const Component = instance.type;
    if (!!(process.env.NODE_ENV !== "production")) {
      if (Component.name) {
        validateComponentName(Component.name, instance.appContext.config);
      }
      if (Component.components) {
        const names = Object.keys(Component.components);
        for (let i2 = 0; i2 < names.length; i2++) {
          validateComponentName(names[i2], instance.appContext.config);
        }
      }
      if (Component.directives) {
        const names = Object.keys(Component.directives);
        for (let i2 = 0; i2 < names.length; i2++) {
          validateDirectiveName(names[i2]);
        }
      }
      if (Component.compilerOptions && isRuntimeOnly()) {
        warn$1(
          `"compilerOptions" is only supported when using a build of Vue that includes the runtime compiler. Since you are using a runtime-only build, the options should be passed via your build tool config instead.`
        );
      }
    }
    instance.accessCache = /* @__PURE__ */ Object.create(null);
    instance.proxy = markRaw(new Proxy(instance.ctx, PublicInstanceProxyHandlers));
    if (!!(process.env.NODE_ENV !== "production")) {
      exposePropsOnRenderContext(instance);
    }
    const { setup } = Component;
    if (setup) {
      const setupContext = instance.setupContext = setup.length > 1 ? createSetupContext(instance) : null;
      const reset2 = setCurrentInstance(instance);
      pauseTracking();
      const setupResult = callWithErrorHandling(
        setup,
        instance,
        0,
        [
          !!(process.env.NODE_ENV !== "production") ? shallowReadonly(instance.props) : instance.props,
          setupContext
        ]
      );
      resetTracking();
      reset2();
      if (isPromise(setupResult)) {
        setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
        if (isSSR) {
          return setupResult.then((resolvedResult) => {
            handleSetupResult(instance, resolvedResult, isSSR);
          }).catch((e2) => {
            handleError(e2, instance, 0);
          });
        } else {
          instance.asyncDep = setupResult;
          if (!!(process.env.NODE_ENV !== "production") && !instance.suspense) {
            const name2 = (_a2 = Component.name) != null ? _a2 : "Anonymous";
            warn$1(
              `Component <${name2}>: setup function returned a promise, but no <Suspense> boundary was found in the parent component tree. A component with async setup() must be nested in a <Suspense> in order to be rendered.`
            );
          }
        }
      } else {
        handleSetupResult(instance, setupResult, isSSR);
      }
    } else {
      finishComponentSetup(instance, isSSR);
    }
  }
  function handleSetupResult(instance, setupResult, isSSR) {
    if (isFunction$1(setupResult)) {
      if (instance.type.__ssrInlineRender) {
        instance.ssrRender = setupResult;
      } else {
        instance.render = setupResult;
      }
    } else if (isObject$2(setupResult)) {
      if (!!(process.env.NODE_ENV !== "production") && isVNode(setupResult)) {
        warn$1(
          `setup() should not return VNodes directly - return a render function instead.`
        );
      }
      if (!!(process.env.NODE_ENV !== "production") || __VUE_PROD_DEVTOOLS__) {
        instance.devtoolsRawSetupState = setupResult;
      }
      instance.setupState = proxyRefs(setupResult);
      if (!!(process.env.NODE_ENV !== "production")) {
        exposeSetupStateOnRenderContext(instance);
      }
    } else if (!!(process.env.NODE_ENV !== "production") && setupResult !== void 0) {
      warn$1(
        `setup() should return an object. Received: ${setupResult === null ? "null" : typeof setupResult}`
      );
    }
    finishComponentSetup(instance, isSSR);
  }
  let compile$1;
  let installWithProxy;
  function registerRuntimeCompiler(_compile) {
    compile$1 = _compile;
    installWithProxy = (i2) => {
      if (i2.render._rc) {
        i2.withProxy = new Proxy(i2.ctx, RuntimeCompiledPublicInstanceProxyHandlers);
      }
    };
  }
  const isRuntimeOnly = () => !compile$1;
  function finishComponentSetup(instance, isSSR, skipOptions) {
    const Component = instance.type;
    if (!instance.render) {
      if (!isSSR && compile$1 && !Component.render) {
        const template = Component.template || resolveMergedOptions(instance).template;
        if (template) {
          if (!!(process.env.NODE_ENV !== "production")) {
            startMeasure(instance, `compile`);
          }
          const { isCustomElement, compilerOptions } = instance.appContext.config;
          const { delimiters, compilerOptions: componentCompilerOptions } = Component;
          const finalCompilerOptions = extend$2(
            extend$2(
              {
                isCustomElement,
                delimiters
              },
              compilerOptions
            ),
            componentCompilerOptions
          );
          Component.render = compile$1(template, finalCompilerOptions);
          if (!!(process.env.NODE_ENV !== "production")) {
            endMeasure(instance, `compile`);
          }
        }
      }
      instance.render = Component.render || NOOP;
      if (installWithProxy) {
        installWithProxy(instance);
      }
    }
    if (__VUE_OPTIONS_API__ && true) {
      const reset2 = setCurrentInstance(instance);
      pauseTracking();
      try {
        applyOptions(instance);
      } finally {
        resetTracking();
        reset2();
      }
    }
    if (!!(process.env.NODE_ENV !== "production") && !Component.render && instance.render === NOOP && !isSSR) {
      if (!compile$1 && Component.template) {
        warn$1(
          `Component provided template option but runtime compilation is not supported in this build of Vue. Configure your bundler to alias "vue" to "vue/dist/vue.esm-bundler.js".`
        );
      } else {
        warn$1(`Component is missing template or render function.`);
      }
    }
  }
  function getAttrsProxy(instance) {
    return instance.attrsProxy || (instance.attrsProxy = new Proxy(
      instance.attrs,
      !!(process.env.NODE_ENV !== "production") ? {
        get(target, key) {
          markAttrsAccessed();
          track(instance, "get", "$attrs");
          return target[key];
        },
        set() {
          warn$1(`setupContext.attrs is readonly.`);
          return false;
        },
        deleteProperty() {
          warn$1(`setupContext.attrs is readonly.`);
          return false;
        }
      } : {
        get(target, key) {
          track(instance, "get", "$attrs");
          return target[key];
        }
      }
    ));
  }
  function getSlotsProxy(instance) {
    return instance.slotsProxy || (instance.slotsProxy = new Proxy(instance.slots, {
      get(target, key) {
        track(instance, "get", "$slots");
        return target[key];
      }
    }));
  }
  function createSetupContext(instance) {
    const expose = (exposed) => {
      if (!!(process.env.NODE_ENV !== "production")) {
        if (instance.exposed) {
          warn$1(`expose() should be called only once per setup().`);
        }
        if (exposed != null) {
          let exposedType = typeof exposed;
          if (exposedType === "object") {
            if (isArray$1(exposed)) {
              exposedType = "array";
            } else if (isRef(exposed)) {
              exposedType = "ref";
            }
          }
          if (exposedType !== "object") {
            warn$1(
              `expose() should be passed a plain object, received ${exposedType}.`
            );
          }
        }
      }
      instance.exposed = exposed || {};
    };
    if (!!(process.env.NODE_ENV !== "production")) {
      return Object.freeze({
        get attrs() {
          return getAttrsProxy(instance);
        },
        get slots() {
          return getSlotsProxy(instance);
        },
        get emit() {
          return (event, ...args) => instance.emit(event, ...args);
        },
        expose
      });
    } else {
      return {
        get attrs() {
          return getAttrsProxy(instance);
        },
        slots: instance.slots,
        emit: instance.emit,
        expose
      };
    }
  }
  function getExposeProxy(instance) {
    if (instance.exposed) {
      return instance.exposeProxy || (instance.exposeProxy = new Proxy(proxyRefs(markRaw(instance.exposed)), {
        get(target, key) {
          if (key in target) {
            return target[key];
          } else if (key in publicPropertiesMap) {
            return publicPropertiesMap[key](instance);
          }
        },
        has(target, key) {
          return key in target || key in publicPropertiesMap;
        }
      }));
    }
  }
  const classifyRE = /(?:^|[-_])(\w)/g;
  const classify = (str) => str.replace(classifyRE, (c2) => c2.toUpperCase()).replace(/[-_]/g, "");
  function getComponentName(Component, includeInferred = true) {
    return isFunction$1(Component) ? Component.displayName || Component.name : Component.name || includeInferred && Component.__name;
  }
  function formatComponentName(instance, Component, isRoot = false) {
    let name2 = getComponentName(Component);
    if (!name2 && Component.__file) {
      const match = Component.__file.match(/([^/\\]+)\.\w+$/);
      if (match) {
        name2 = match[1];
      }
    }
    if (!name2 && instance && instance.parent) {
      const inferFromRegistry = (registry) => {
        for (const key in registry) {
          if (registry[key] === Component) {
            return key;
          }
        }
      };
      name2 = inferFromRegistry(
        instance.components || instance.parent.type.components
      ) || inferFromRegistry(instance.appContext.components);
    }
    return name2 ? classify(name2) : isRoot ? `App` : `Anonymous`;
  }
  function isClassComponent(value) {
    return isFunction$1(value) && "__vccOpts" in value;
  }
  const computed = (getterOrOptions, debugOptions) => {
    const c2 = computed$1(getterOrOptions, debugOptions, isInSSRComponentSetup);
    if (!!(process.env.NODE_ENV !== "production")) {
      const i2 = getCurrentInstance();
      if (i2 && i2.appContext.config.warnRecursiveComputed) {
        c2._warnRecursive = true;
      }
    }
    return c2;
  };
  function useModel(props, name2, options = EMPTY_OBJ) {
    const i2 = getCurrentInstance();
    if (!!(process.env.NODE_ENV !== "production") && !i2) {
      warn$1(`useModel() called without active instance.`);
      return ref();
    }
    if (!!(process.env.NODE_ENV !== "production") && !i2.propsOptions[0][name2]) {
      warn$1(`useModel() called with prop "${name2}" which is not declared.`);
      return ref();
    }
    const camelizedName = camelize(name2);
    const hyphenatedName = hyphenate(name2);
    const res = customRef((track2, trigger2) => {
      let localValue;
      watchSyncEffect(() => {
        const propValue = props[name2];
        if (hasChanged(localValue, propValue)) {
          localValue = propValue;
          trigger2();
        }
      });
      return {
        get() {
          track2();
          return options.get ? options.get(localValue) : localValue;
        },
        set(value) {
          const rawProps = i2.vnode.props;
          if (!(rawProps && // check if parent has passed v-model
          (name2 in rawProps || camelizedName in rawProps || hyphenatedName in rawProps) && (`onUpdate:${name2}` in rawProps || `onUpdate:${camelizedName}` in rawProps || `onUpdate:${hyphenatedName}` in rawProps)) && hasChanged(value, localValue)) {
            localValue = value;
            trigger2();
          }
          i2.emit(`update:${name2}`, options.set ? options.set(value) : value);
        }
      };
    });
    const modifierKey = name2 === "modelValue" ? "modelModifiers" : `${name2}Modifiers`;
    res[Symbol.iterator] = () => {
      let i22 = 0;
      return {
        next() {
          if (i22 < 2) {
            return { value: i22++ ? props[modifierKey] || {} : res, done: false };
          } else {
            return { done: true };
          }
        }
      };
    };
    return res;
  }
  function h$1(type, propsOrChildren, children) {
    const l2 = arguments.length;
    if (l2 === 2) {
      if (isObject$2(propsOrChildren) && !isArray$1(propsOrChildren)) {
        if (isVNode(propsOrChildren)) {
          return createVNode(type, null, [propsOrChildren]);
        }
        return createVNode(type, propsOrChildren);
      } else {
        return createVNode(type, null, propsOrChildren);
      }
    } else {
      if (l2 > 3) {
        children = Array.prototype.slice.call(arguments, 2);
      } else if (l2 === 3 && isVNode(children)) {
        children = [children];
      }
      return createVNode(type, propsOrChildren, children);
    }
  }
  function initCustomFormatter() {
    if (!!!(process.env.NODE_ENV !== "production") || typeof window === "undefined") {
      return;
    }
    const vueStyle = { style: "color:#3ba776" };
    const numberStyle = { style: "color:#1677ff" };
    const stringStyle = { style: "color:#f5222d" };
    const keywordStyle = { style: "color:#eb2f96" };
    const formatter = {
      header(obj) {
        if (!isObject$2(obj)) {
          return null;
        }
        if (obj.__isVue) {
          return ["div", vueStyle, `VueInstance`];
        } else if (isRef(obj)) {
          return [
            "div",
            {},
            ["span", vueStyle, genRefFlag(obj)],
            "<",
            formatValue(obj.value),
            `>`
          ];
        } else if (isReactive(obj)) {
          return [
            "div",
            {},
            ["span", vueStyle, isShallow(obj) ? "ShallowReactive" : "Reactive"],
            "<",
            formatValue(obj),
            `>${isReadonly(obj) ? ` (readonly)` : ``}`
          ];
        } else if (isReadonly(obj)) {
          return [
            "div",
            {},
            ["span", vueStyle, isShallow(obj) ? "ShallowReadonly" : "Readonly"],
            "<",
            formatValue(obj),
            ">"
          ];
        }
        return null;
      },
      hasBody(obj) {
        return obj && obj.__isVue;
      },
      body(obj) {
        if (obj && obj.__isVue) {
          return [
            "div",
            {},
            ...formatInstance(obj.$)
          ];
        }
      }
    };
    function formatInstance(instance) {
      const blocks = [];
      if (instance.type.props && instance.props) {
        blocks.push(createInstanceBlock("props", toRaw(instance.props)));
      }
      if (instance.setupState !== EMPTY_OBJ) {
        blocks.push(createInstanceBlock("setup", instance.setupState));
      }
      if (instance.data !== EMPTY_OBJ) {
        blocks.push(createInstanceBlock("data", toRaw(instance.data)));
      }
      const computed2 = extractKeys(instance, "computed");
      if (computed2) {
        blocks.push(createInstanceBlock("computed", computed2));
      }
      const injected = extractKeys(instance, "inject");
      if (injected) {
        blocks.push(createInstanceBlock("injected", injected));
      }
      blocks.push([
        "div",
        {},
        [
          "span",
          {
            style: keywordStyle.style + ";opacity:0.66"
          },
          "$ (internal): "
        ],
        ["object", { object: instance }]
      ]);
      return blocks;
    }
    function createInstanceBlock(type, target) {
      target = extend$2({}, target);
      if (!Object.keys(target).length) {
        return ["span", {}];
      }
      return [
        "div",
        { style: "line-height:1.25em;margin-bottom:0.6em" },
        [
          "div",
          {
            style: "color:#476582"
          },
          type
        ],
        [
          "div",
          {
            style: "padding-left:1.25em"
          },
          ...Object.keys(target).map((key) => {
            return [
              "div",
              {},
              ["span", keywordStyle, key + ": "],
              formatValue(target[key], false)
            ];
          })
        ]
      ];
    }
    function formatValue(v2, asRaw = true) {
      if (typeof v2 === "number") {
        return ["span", numberStyle, v2];
      } else if (typeof v2 === "string") {
        return ["span", stringStyle, JSON.stringify(v2)];
      } else if (typeof v2 === "boolean") {
        return ["span", keywordStyle, v2];
      } else if (isObject$2(v2)) {
        return ["object", { object: asRaw ? toRaw(v2) : v2 }];
      } else {
        return ["span", stringStyle, String(v2)];
      }
    }
    function extractKeys(instance, type) {
      const Comp = instance.type;
      if (isFunction$1(Comp)) {
        return;
      }
      const extracted = {};
      for (const key in instance.ctx) {
        if (isKeyOfType(Comp, key, type)) {
          extracted[key] = instance.ctx[key];
        }
      }
      return extracted;
    }
    function isKeyOfType(Comp, key, type) {
      const opts = Comp[type];
      if (isArray$1(opts) && opts.includes(key) || isObject$2(opts) && key in opts) {
        return true;
      }
      if (Comp.extends && isKeyOfType(Comp.extends, key, type)) {
        return true;
      }
      if (Comp.mixins && Comp.mixins.some((m2) => isKeyOfType(m2, key, type))) {
        return true;
      }
    }
    function genRefFlag(v2) {
      if (isShallow(v2)) {
        return `ShallowRef`;
      }
      if (v2.effect) {
        return `ComputedRef`;
      }
      return `Ref`;
    }
    if (window.devtoolsFormatters) {
      window.devtoolsFormatters.push(formatter);
    } else {
      window.devtoolsFormatters = [formatter];
    }
  }
  function withMemo(memo, render2, cache2, index2) {
    const cached = cache2[index2];
    if (cached && isMemoSame(cached, memo)) {
      return cached;
    }
    const ret = render2();
    ret.memo = memo.slice();
    return cache2[index2] = ret;
  }
  function isMemoSame(cached, memo) {
    const prev = cached.memo;
    if (prev.length != memo.length) {
      return false;
    }
    for (let i2 = 0; i2 < prev.length; i2++) {
      if (hasChanged(prev[i2], memo[i2])) {
        return false;
      }
    }
    if (isBlockTreeEnabled > 0 && currentBlock) {
      currentBlock.push(cached);
    }
    return true;
  }
  const version = "3.4.21";
  const warn = !!(process.env.NODE_ENV !== "production") ? warn$1 : NOOP;
  const ErrorTypeStrings = ErrorTypeStrings$1;
  const devtools = !!(process.env.NODE_ENV !== "production") || true ? devtools$1 : void 0;
  const setDevtoolsHook = !!(process.env.NODE_ENV !== "production") || true ? setDevtoolsHook$1 : NOOP;
  const _ssrUtils = {
    createComponentInstance,
    setupComponent,
    renderComponentRoot,
    setCurrentRenderingInstance,
    isVNode,
    normalizeVNode
  };
  const ssrUtils = _ssrUtils;
  const resolveFilter = null;
  const compatUtils = null;
  const DeprecationTypes = null;
  /**
  * @vue/runtime-dom v3.4.21
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  const svgNS = "http://www.w3.org/2000/svg";
  const mathmlNS = "http://www.w3.org/1998/Math/MathML";
  const doc$1 = typeof document !== "undefined" ? document : null;
  const templateContainer = doc$1 && /* @__PURE__ */ doc$1.createElement("template");
  const nodeOps = {
    insert: (child, parent, anchor) => {
      parent.insertBefore(child, anchor || null);
    },
    remove: (child) => {
      const parent = child.parentNode;
      if (parent) {
        parent.removeChild(child);
      }
    },
    createElement: (tag, namespace, is, props) => {
      const el = namespace === "svg" ? doc$1.createElementNS(svgNS, tag) : namespace === "mathml" ? doc$1.createElementNS(mathmlNS, tag) : doc$1.createElement(tag, is ? { is } : void 0);
      if (tag === "select" && props && props.multiple != null) {
        el.setAttribute("multiple", props.multiple);
      }
      return el;
    },
    createText: (text) => doc$1.createTextNode(text),
    createComment: (text) => doc$1.createComment(text),
    setText: (node, text) => {
      node.nodeValue = text;
    },
    setElementText: (el, text) => {
      el.textContent = text;
    },
    parentNode: (node) => node.parentNode,
    nextSibling: (node) => node.nextSibling,
    querySelector: (selector) => doc$1.querySelector(selector),
    setScopeId(el, id2) {
      el.setAttribute(id2, "");
    },
    // __UNSAFE__
    // Reason: innerHTML.
    // Static content here can only come from compiled templates.
    // As long as the user only uses trusted templates, this is safe.
    insertStaticContent(content2, parent, anchor, namespace, start, end) {
      const before = anchor ? anchor.previousSibling : parent.lastChild;
      if (start && (start === end || start.nextSibling)) {
        while (true) {
          parent.insertBefore(start.cloneNode(true), anchor);
          if (start === end || !(start = start.nextSibling))
            break;
        }
      } else {
        templateContainer.innerHTML = namespace === "svg" ? `<svg>${content2}</svg>` : namespace === "mathml" ? `<math>${content2}</math>` : content2;
        const template = templateContainer.content;
        if (namespace === "svg" || namespace === "mathml") {
          const wrapper = template.firstChild;
          while (wrapper.firstChild) {
            template.appendChild(wrapper.firstChild);
          }
          template.removeChild(wrapper);
        }
        parent.insertBefore(template, anchor);
      }
      return [
        // first
        before ? before.nextSibling : parent.firstChild,
        // last
        anchor ? anchor.previousSibling : parent.lastChild
      ];
    }
  };
  const TRANSITION$1 = "transition";
  const ANIMATION = "animation";
  const vtcKey = Symbol("_vtc");
  const Transition = (props, { slots }) => h$1(BaseTransition, resolveTransitionProps(props), slots);
  Transition.displayName = "Transition";
  const DOMTransitionPropsValidators = {
    name: String,
    type: String,
    css: {
      type: Boolean,
      default: true
    },
    duration: [String, Number, Object],
    enterFromClass: String,
    enterActiveClass: String,
    enterToClass: String,
    appearFromClass: String,
    appearActiveClass: String,
    appearToClass: String,
    leaveFromClass: String,
    leaveActiveClass: String,
    leaveToClass: String
  };
  const TransitionPropsValidators = Transition.props = /* @__PURE__ */ extend$2(
    {},
    BaseTransitionPropsValidators,
    DOMTransitionPropsValidators
  );
  const callHook = (hook, args = []) => {
    if (isArray$1(hook)) {
      hook.forEach((h2) => h2(...args));
    } else if (hook) {
      hook(...args);
    }
  };
  const hasExplicitCallback = (hook) => {
    return hook ? isArray$1(hook) ? hook.some((h2) => h2.length > 1) : hook.length > 1 : false;
  };
  function resolveTransitionProps(rawProps) {
    const baseProps = {};
    for (const key in rawProps) {
      if (!(key in DOMTransitionPropsValidators)) {
        baseProps[key] = rawProps[key];
      }
    }
    if (rawProps.css === false) {
      return baseProps;
    }
    const {
      name: name2 = "v",
      type,
      duration,
      enterFromClass = `${name2}-enter-from`,
      enterActiveClass = `${name2}-enter-active`,
      enterToClass = `${name2}-enter-to`,
      appearFromClass = enterFromClass,
      appearActiveClass = enterActiveClass,
      appearToClass = enterToClass,
      leaveFromClass = `${name2}-leave-from`,
      leaveActiveClass = `${name2}-leave-active`,
      leaveToClass = `${name2}-leave-to`
    } = rawProps;
    const durations = normalizeDuration(duration);
    const enterDuration = durations && durations[0];
    const leaveDuration = durations && durations[1];
    const {
      onBeforeEnter,
      onEnter,
      onEnterCancelled,
      onLeave,
      onLeaveCancelled,
      onBeforeAppear = onBeforeEnter,
      onAppear = onEnter,
      onAppearCancelled = onEnterCancelled
    } = baseProps;
    const finishEnter = (el, isAppear, done) => {
      removeTransitionClass(el, isAppear ? appearToClass : enterToClass);
      removeTransitionClass(el, isAppear ? appearActiveClass : enterActiveClass);
      done && done();
    };
    const finishLeave = (el, done) => {
      el._isLeaving = false;
      removeTransitionClass(el, leaveFromClass);
      removeTransitionClass(el, leaveToClass);
      removeTransitionClass(el, leaveActiveClass);
      done && done();
    };
    const makeEnterHook = (isAppear) => {
      return (el, done) => {
        const hook = isAppear ? onAppear : onEnter;
        const resolve2 = () => finishEnter(el, isAppear, done);
        callHook(hook, [el, resolve2]);
        nextFrame(() => {
          removeTransitionClass(el, isAppear ? appearFromClass : enterFromClass);
          addTransitionClass(el, isAppear ? appearToClass : enterToClass);
          if (!hasExplicitCallback(hook)) {
            whenTransitionEnds(el, type, enterDuration, resolve2);
          }
        });
      };
    };
    return extend$2(baseProps, {
      onBeforeEnter(el) {
        callHook(onBeforeEnter, [el]);
        addTransitionClass(el, enterFromClass);
        addTransitionClass(el, enterActiveClass);
      },
      onBeforeAppear(el) {
        callHook(onBeforeAppear, [el]);
        addTransitionClass(el, appearFromClass);
        addTransitionClass(el, appearActiveClass);
      },
      onEnter: makeEnterHook(false),
      onAppear: makeEnterHook(true),
      onLeave(el, done) {
        el._isLeaving = true;
        const resolve2 = () => finishLeave(el, done);
        addTransitionClass(el, leaveFromClass);
        forceReflow();
        addTransitionClass(el, leaveActiveClass);
        nextFrame(() => {
          if (!el._isLeaving) {
            return;
          }
          removeTransitionClass(el, leaveFromClass);
          addTransitionClass(el, leaveToClass);
          if (!hasExplicitCallback(onLeave)) {
            whenTransitionEnds(el, type, leaveDuration, resolve2);
          }
        });
        callHook(onLeave, [el, resolve2]);
      },
      onEnterCancelled(el) {
        finishEnter(el, false);
        callHook(onEnterCancelled, [el]);
      },
      onAppearCancelled(el) {
        finishEnter(el, true);
        callHook(onAppearCancelled, [el]);
      },
      onLeaveCancelled(el) {
        finishLeave(el);
        callHook(onLeaveCancelled, [el]);
      }
    });
  }
  function normalizeDuration(duration) {
    if (duration == null) {
      return null;
    } else if (isObject$2(duration)) {
      return [NumberOf(duration.enter), NumberOf(duration.leave)];
    } else {
      const n2 = NumberOf(duration);
      return [n2, n2];
    }
  }
  function NumberOf(val) {
    const res = toNumber(val);
    if (!!(process.env.NODE_ENV !== "production")) {
      assertNumber(res, "<transition> explicit duration");
    }
    return res;
  }
  function addTransitionClass(el, cls) {
    cls.split(/\s+/).forEach((c2) => c2 && el.classList.add(c2));
    (el[vtcKey] || (el[vtcKey] = /* @__PURE__ */ new Set())).add(cls);
  }
  function removeTransitionClass(el, cls) {
    cls.split(/\s+/).forEach((c2) => c2 && el.classList.remove(c2));
    const _vtc = el[vtcKey];
    if (_vtc) {
      _vtc.delete(cls);
      if (!_vtc.size) {
        el[vtcKey] = void 0;
      }
    }
  }
  function nextFrame(cb) {
    requestAnimationFrame(() => {
      requestAnimationFrame(cb);
    });
  }
  let endId = 0;
  function whenTransitionEnds(el, expectedType, explicitTimeout, resolve2) {
    const id2 = el._endId = ++endId;
    const resolveIfNotStale = () => {
      if (id2 === el._endId) {
        resolve2();
      }
    };
    if (explicitTimeout) {
      return setTimeout(resolveIfNotStale, explicitTimeout);
    }
    const { type, timeout, propCount } = getTransitionInfo(el, expectedType);
    if (!type) {
      return resolve2();
    }
    const endEvent = type + "end";
    let ended = 0;
    const end = () => {
      el.removeEventListener(endEvent, onEnd);
      resolveIfNotStale();
    };
    const onEnd = (e2) => {
      if (e2.target === el && ++ended >= propCount) {
        end();
      }
    };
    setTimeout(() => {
      if (ended < propCount) {
        end();
      }
    }, timeout + 1);
    el.addEventListener(endEvent, onEnd);
  }
  function getTransitionInfo(el, expectedType) {
    const styles = window.getComputedStyle(el);
    const getStyleProperties = (key) => (styles[key] || "").split(", ");
    const transitionDelays = getStyleProperties(`${TRANSITION$1}Delay`);
    const transitionDurations = getStyleProperties(`${TRANSITION$1}Duration`);
    const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
    const animationDelays = getStyleProperties(`${ANIMATION}Delay`);
    const animationDurations = getStyleProperties(`${ANIMATION}Duration`);
    const animationTimeout = getTimeout(animationDelays, animationDurations);
    let type = null;
    let timeout = 0;
    let propCount = 0;
    if (expectedType === TRANSITION$1) {
      if (transitionTimeout > 0) {
        type = TRANSITION$1;
        timeout = transitionTimeout;
        propCount = transitionDurations.length;
      }
    } else if (expectedType === ANIMATION) {
      if (animationTimeout > 0) {
        type = ANIMATION;
        timeout = animationTimeout;
        propCount = animationDurations.length;
      }
    } else {
      timeout = Math.max(transitionTimeout, animationTimeout);
      type = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION$1 : ANIMATION : null;
      propCount = type ? type === TRANSITION$1 ? transitionDurations.length : animationDurations.length : 0;
    }
    const hasTransform = type === TRANSITION$1 && /\b(transform|all)(,|$)/.test(
      getStyleProperties(`${TRANSITION$1}Property`).toString()
    );
    return {
      type,
      timeout,
      propCount,
      hasTransform
    };
  }
  function getTimeout(delays, durations) {
    while (delays.length < durations.length) {
      delays = delays.concat(delays);
    }
    return Math.max(...durations.map((d2, i2) => toMs(d2) + toMs(delays[i2])));
  }
  function toMs(s2) {
    if (s2 === "auto")
      return 0;
    return Number(s2.slice(0, -1).replace(",", ".")) * 1e3;
  }
  function forceReflow() {
    return document.body.offsetHeight;
  }
  function patchClass(el, value, isSVG) {
    const transitionClasses = el[vtcKey];
    if (transitionClasses) {
      value = (value ? [value, ...transitionClasses] : [...transitionClasses]).join(" ");
    }
    if (value == null) {
      el.removeAttribute("class");
    } else if (isSVG) {
      el.setAttribute("class", value);
    } else {
      el.className = value;
    }
  }
  const vShowOriginalDisplay = Symbol("_vod");
  const vShowHidden = Symbol("_vsh");
  const vShow = {
    beforeMount(el, { value }, { transition }) {
      el[vShowOriginalDisplay] = el.style.display === "none" ? "" : el.style.display;
      if (transition && value) {
        transition.beforeEnter(el);
      } else {
        setDisplay(el, value);
      }
    },
    mounted(el, { value }, { transition }) {
      if (transition && value) {
        transition.enter(el);
      }
    },
    updated(el, { value, oldValue }, { transition }) {
      if (!value === !oldValue)
        return;
      if (transition) {
        if (value) {
          transition.beforeEnter(el);
          setDisplay(el, true);
          transition.enter(el);
        } else {
          transition.leave(el, () => {
            setDisplay(el, false);
          });
        }
      } else {
        setDisplay(el, value);
      }
    },
    beforeUnmount(el, { value }) {
      setDisplay(el, value);
    }
  };
  if (!!(process.env.NODE_ENV !== "production")) {
    vShow.name = "show";
  }
  function setDisplay(el, value) {
    el.style.display = value ? el[vShowOriginalDisplay] : "none";
    el[vShowHidden] = !value;
  }
  function initVShowForSSR() {
    vShow.getSSRProps = ({ value }) => {
      if (!value) {
        return { style: { display: "none" } };
      }
    };
  }
  const CSS_VAR_TEXT = Symbol(!!(process.env.NODE_ENV !== "production") ? "CSS_VAR_TEXT" : "");
  function useCssVars(getter) {
    const instance = getCurrentInstance();
    if (!instance) {
      !!(process.env.NODE_ENV !== "production") && warn(`useCssVars is called without current active component instance.`);
      return;
    }
    const updateTeleports = instance.ut = (vars = getter(instance.proxy)) => {
      Array.from(
        document.querySelectorAll(`[data-v-owner="${instance.uid}"]`)
      ).forEach((node) => setVarsOnNode(node, vars));
    };
    if (!!(process.env.NODE_ENV !== "production")) {
      instance.getCssVars = () => getter(instance.proxy);
    }
    const setVars = () => {
      const vars = getter(instance.proxy);
      setVarsOnVNode(instance.subTree, vars);
      updateTeleports(vars);
    };
    watchPostEffect(setVars);
    onMounted(() => {
      const ob = new MutationObserver(setVars);
      ob.observe(instance.subTree.el.parentNode, { childList: true });
      onUnmounted(() => ob.disconnect());
    });
  }
  function setVarsOnVNode(vnode, vars) {
    if (vnode.shapeFlag & 128) {
      const suspense = vnode.suspense;
      vnode = suspense.activeBranch;
      if (suspense.pendingBranch && !suspense.isHydrating) {
        suspense.effects.push(() => {
          setVarsOnVNode(suspense.activeBranch, vars);
        });
      }
    }
    while (vnode.component) {
      vnode = vnode.component.subTree;
    }
    if (vnode.shapeFlag & 1 && vnode.el) {
      setVarsOnNode(vnode.el, vars);
    } else if (vnode.type === Fragment) {
      vnode.children.forEach((c2) => setVarsOnVNode(c2, vars));
    } else if (vnode.type === Static) {
      let { el, anchor } = vnode;
      while (el) {
        setVarsOnNode(el, vars);
        if (el === anchor)
          break;
        el = el.nextSibling;
      }
    }
  }
  function setVarsOnNode(el, vars) {
    if (el.nodeType === 1) {
      const style = el.style;
      let cssText = "";
      for (const key in vars) {
        style.setProperty(`--${key}`, vars[key]);
        cssText += `--${key}: ${vars[key]};`;
      }
      style[CSS_VAR_TEXT] = cssText;
    }
  }
  const displayRE = /(^|;)\s*display\s*:/;
  function patchStyle(el, prev, next) {
    const style = el.style;
    const isCssString = isString$1(next);
    let hasControlledDisplay = false;
    if (next && !isCssString) {
      if (prev) {
        if (!isString$1(prev)) {
          for (const key in prev) {
            if (next[key] == null) {
              setStyle(style, key, "");
            }
          }
        } else {
          for (const prevStyle of prev.split(";")) {
            const key = prevStyle.slice(0, prevStyle.indexOf(":")).trim();
            if (next[key] == null) {
              setStyle(style, key, "");
            }
          }
        }
      }
      for (const key in next) {
        if (key === "display") {
          hasControlledDisplay = true;
        }
        setStyle(style, key, next[key]);
      }
    } else {
      if (isCssString) {
        if (prev !== next) {
          const cssVarText = style[CSS_VAR_TEXT];
          if (cssVarText) {
            next += ";" + cssVarText;
          }
          style.cssText = next;
          hasControlledDisplay = displayRE.test(next);
        }
      } else if (prev) {
        el.removeAttribute("style");
      }
    }
    if (vShowOriginalDisplay in el) {
      el[vShowOriginalDisplay] = hasControlledDisplay ? style.display : "";
      if (el[vShowHidden]) {
        style.display = "none";
      }
    }
  }
  const semicolonRE = /[^\\];\s*$/;
  const importantRE = /\s*!important$/;
  function setStyle(style, name2, val) {
    if (isArray$1(val)) {
      val.forEach((v2) => setStyle(style, name2, v2));
    } else {
      if (val == null)
        val = "";
      if (!!(process.env.NODE_ENV !== "production")) {
        if (semicolonRE.test(val)) {
          warn(
            `Unexpected semicolon at the end of '${name2}' style value: '${val}'`
          );
        }
      }
      if (name2.startsWith("--")) {
        style.setProperty(name2, val);
      } else {
        const prefixed = autoPrefix(style, name2);
        if (importantRE.test(val)) {
          style.setProperty(
            hyphenate(prefixed),
            val.replace(importantRE, ""),
            "important"
          );
        } else {
          style[prefixed] = val;
        }
      }
    }
  }
  const prefixes = ["Webkit", "Moz", "ms"];
  const prefixCache = {};
  function autoPrefix(style, rawName) {
    const cached = prefixCache[rawName];
    if (cached) {
      return cached;
    }
    let name2 = camelize(rawName);
    if (name2 !== "filter" && name2 in style) {
      return prefixCache[rawName] = name2;
    }
    name2 = capitalize(name2);
    for (let i2 = 0; i2 < prefixes.length; i2++) {
      const prefixed = prefixes[i2] + name2;
      if (prefixed in style) {
        return prefixCache[rawName] = prefixed;
      }
    }
    return rawName;
  }
  const xlinkNS = "http://www.w3.org/1999/xlink";
  function patchAttr(el, key, value, isSVG, instance) {
    if (isSVG && key.startsWith("xlink:")) {
      if (value == null) {
        el.removeAttributeNS(xlinkNS, key.slice(6, key.length));
      } else {
        el.setAttributeNS(xlinkNS, key, value);
      }
    } else {
      const isBoolean2 = isSpecialBooleanAttr(key);
      if (value == null || isBoolean2 && !includeBooleanAttr(value)) {
        el.removeAttribute(key);
      } else {
        el.setAttribute(key, isBoolean2 ? "" : value);
      }
    }
  }
  function patchDOMProp(el, key, value, prevChildren, parentComponent, parentSuspense, unmountChildren) {
    if (key === "innerHTML" || key === "textContent") {
      if (prevChildren) {
        unmountChildren(prevChildren, parentComponent, parentSuspense);
      }
      el[key] = value == null ? "" : value;
      return;
    }
    const tag = el.tagName;
    if (key === "value" && tag !== "PROGRESS" && // custom elements may use _value internally
    !tag.includes("-")) {
      const oldValue = tag === "OPTION" ? el.getAttribute("value") || "" : el.value;
      const newValue = value == null ? "" : value;
      if (oldValue !== newValue || !("_value" in el)) {
        el.value = newValue;
      }
      if (value == null) {
        el.removeAttribute(key);
      }
      el._value = value;
      return;
    }
    let needRemove = false;
    if (value === "" || value == null) {
      const type = typeof el[key];
      if (type === "boolean") {
        value = includeBooleanAttr(value);
      } else if (value == null && type === "string") {
        value = "";
        needRemove = true;
      } else if (type === "number") {
        value = 0;
        needRemove = true;
      }
    }
    try {
      el[key] = value;
    } catch (e2) {
      if (!!(process.env.NODE_ENV !== "production") && !needRemove) {
        warn(
          `Failed setting prop "${key}" on <${tag.toLowerCase()}>: value ${value} is invalid.`,
          e2
        );
      }
    }
    needRemove && el.removeAttribute(key);
  }
  function addEventListener(el, event, handler, options) {
    el.addEventListener(event, handler, options);
  }
  function removeEventListener(el, event, handler, options) {
    el.removeEventListener(event, handler, options);
  }
  const veiKey = Symbol("_vei");
  function patchEvent(el, rawName, prevValue, nextValue, instance = null) {
    const invokers = el[veiKey] || (el[veiKey] = {});
    const existingInvoker = invokers[rawName];
    if (nextValue && existingInvoker) {
      existingInvoker.value = nextValue;
    } else {
      const [name2, options] = parseName(rawName);
      if (nextValue) {
        const invoker = invokers[rawName] = createInvoker(nextValue, instance);
        addEventListener(el, name2, invoker, options);
      } else if (existingInvoker) {
        removeEventListener(el, name2, existingInvoker, options);
        invokers[rawName] = void 0;
      }
    }
  }
  const optionsModifierRE = /(?:Once|Passive|Capture)$/;
  function parseName(name2) {
    let options;
    if (optionsModifierRE.test(name2)) {
      options = {};
      let m2;
      while (m2 = name2.match(optionsModifierRE)) {
        name2 = name2.slice(0, name2.length - m2[0].length);
        options[m2[0].toLowerCase()] = true;
      }
    }
    const event = name2[2] === ":" ? name2.slice(3) : hyphenate(name2.slice(2));
    return [event, options];
  }
  let cachedNow = 0;
  const p = /* @__PURE__ */ Promise.resolve();
  const getNow = () => cachedNow || (p.then(() => cachedNow = 0), cachedNow = Date.now());
  function createInvoker(initialValue, instance) {
    const invoker = (e2) => {
      if (!e2._vts) {
        e2._vts = Date.now();
      } else if (e2._vts <= invoker.attached) {
        return;
      }
      callWithAsyncErrorHandling(
        patchStopImmediatePropagation(e2, invoker.value),
        instance,
        5,
        [e2]
      );
    };
    invoker.value = initialValue;
    invoker.attached = getNow();
    return invoker;
  }
  function patchStopImmediatePropagation(e2, value) {
    if (isArray$1(value)) {
      const originalStop = e2.stopImmediatePropagation;
      e2.stopImmediatePropagation = () => {
        originalStop.call(e2);
        e2._stopped = true;
      };
      return value.map((fn) => (e22) => !e22._stopped && fn && fn(e22));
    } else {
      return value;
    }
  }
  const isNativeOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && // lowercase letter
  key.charCodeAt(2) > 96 && key.charCodeAt(2) < 123;
  const patchProp = (el, key, prevValue, nextValue, namespace, prevChildren, parentComponent, parentSuspense, unmountChildren) => {
    const isSVG = namespace === "svg";
    if (key === "class") {
      patchClass(el, nextValue, isSVG);
    } else if (key === "style") {
      patchStyle(el, prevValue, nextValue);
    } else if (isOn(key)) {
      if (!isModelListener(key)) {
        patchEvent(el, key, prevValue, nextValue, parentComponent);
      }
    } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el, key, nextValue, isSVG)) {
      patchDOMProp(
        el,
        key,
        nextValue,
        prevChildren,
        parentComponent,
        parentSuspense,
        unmountChildren
      );
    } else {
      if (key === "true-value") {
        el._trueValue = nextValue;
      } else if (key === "false-value") {
        el._falseValue = nextValue;
      }
      patchAttr(el, key, nextValue, isSVG);
    }
  };
  function shouldSetAsProp(el, key, value, isSVG) {
    if (isSVG) {
      if (key === "innerHTML" || key === "textContent") {
        return true;
      }
      if (key in el && isNativeOn(key) && isFunction$1(value)) {
        return true;
      }
      return false;
    }
    if (key === "spellcheck" || key === "draggable" || key === "translate") {
      return false;
    }
    if (key === "form") {
      return false;
    }
    if (key === "list" && el.tagName === "INPUT") {
      return false;
    }
    if (key === "type" && el.tagName === "TEXTAREA") {
      return false;
    }
    if (key === "width" || key === "height") {
      const tag = el.tagName;
      if (tag === "IMG" || tag === "VIDEO" || tag === "CANVAS" || tag === "SOURCE") {
        return false;
      }
    }
    if (isNativeOn(key) && isString$1(value)) {
      return false;
    }
    return key in el;
  }
  /*! #__NO_SIDE_EFFECTS__ */
  // @__NO_SIDE_EFFECTS__
  function defineCustomElement(options, hydrate2) {
    const Comp = /* @__PURE__ */ defineComponent(options);
    class VueCustomElement extends VueElement {
      constructor(initialProps) {
        super(Comp, initialProps, hydrate2);
      }
    }
    VueCustomElement.def = Comp;
    return VueCustomElement;
  }
  /*! #__NO_SIDE_EFFECTS__ */
  const defineSSRCustomElement = /* @__NO_SIDE_EFFECTS__ */ (options) => {
    return /* @__PURE__ */ defineCustomElement(options, hydrate);
  };
  const BaseClass = typeof HTMLElement !== "undefined" ? HTMLElement : class {
  };
  class VueElement extends BaseClass {
    constructor(_def, _props = {}, hydrate2) {
      super();
      this._def = _def;
      this._props = _props;
      this._instance = null;
      this._connected = false;
      this._resolved = false;
      this._numberProps = null;
      this._ob = null;
      if (this.shadowRoot && hydrate2) {
        hydrate2(this._createVNode(), this.shadowRoot);
      } else {
        if (!!(process.env.NODE_ENV !== "production") && this.shadowRoot) {
          warn(
            `Custom element has pre-rendered declarative shadow root but is not defined as hydratable. Use \`defineSSRCustomElement\`.`
          );
        }
        this.attachShadow({ mode: "open" });
        if (!this._def.__asyncLoader) {
          this._resolveProps(this._def);
        }
      }
    }
    connectedCallback() {
      this._connected = true;
      if (!this._instance) {
        if (this._resolved) {
          this._update();
        } else {
          this._resolveDef();
        }
      }
    }
    disconnectedCallback() {
      this._connected = false;
      if (this._ob) {
        this._ob.disconnect();
        this._ob = null;
      }
      nextTick(() => {
        if (!this._connected) {
          render(null, this.shadowRoot);
          this._instance = null;
        }
      });
    }
    /**
     * resolve inner component definition (handle possible async component)
     */
    _resolveDef() {
      this._resolved = true;
      for (let i2 = 0; i2 < this.attributes.length; i2++) {
        this._setAttr(this.attributes[i2].name);
      }
      this._ob = new MutationObserver((mutations) => {
        for (const m2 of mutations) {
          this._setAttr(m2.attributeName);
        }
      });
      this._ob.observe(this, { attributes: true });
      const resolve2 = (def2, isAsync = false) => {
        const { props, styles } = def2;
        let numberProps;
        if (props && !isArray$1(props)) {
          for (const key in props) {
            const opt = props[key];
            if (opt === Number || opt && opt.type === Number) {
              if (key in this._props) {
                this._props[key] = toNumber(this._props[key]);
              }
              (numberProps || (numberProps = /* @__PURE__ */ Object.create(null)))[camelize(key)] = true;
            }
          }
        }
        this._numberProps = numberProps;
        if (isAsync) {
          this._resolveProps(def2);
        }
        this._applyStyles(styles);
        this._update();
      };
      const asyncDef = this._def.__asyncLoader;
      if (asyncDef) {
        asyncDef().then((def2) => resolve2(def2, true));
      } else {
        resolve2(this._def);
      }
    }
    _resolveProps(def2) {
      const { props } = def2;
      const declaredPropKeys = isArray$1(props) ? props : Object.keys(props || {});
      for (const key of Object.keys(this)) {
        if (key[0] !== "_" && declaredPropKeys.includes(key)) {
          this._setProp(key, this[key], true, false);
        }
      }
      for (const key of declaredPropKeys.map(camelize)) {
        Object.defineProperty(this, key, {
          get() {
            return this._getProp(key);
          },
          set(val) {
            this._setProp(key, val);
          }
        });
      }
    }
    _setAttr(key) {
      let value = this.getAttribute(key);
      const camelKey = camelize(key);
      if (this._numberProps && this._numberProps[camelKey]) {
        value = toNumber(value);
      }
      this._setProp(camelKey, value, false);
    }
    /**
     * @internal
     */
    _getProp(key) {
      return this._props[key];
    }
    /**
     * @internal
     */
    _setProp(key, val, shouldReflect = true, shouldUpdate = true) {
      if (val !== this._props[key]) {
        this._props[key] = val;
        if (shouldUpdate && this._instance) {
          this._update();
        }
        if (shouldReflect) {
          if (val === true) {
            this.setAttribute(hyphenate(key), "");
          } else if (typeof val === "string" || typeof val === "number") {
            this.setAttribute(hyphenate(key), val + "");
          } else if (!val) {
            this.removeAttribute(hyphenate(key));
          }
        }
      }
    }
    _update() {
      render(this._createVNode(), this.shadowRoot);
    }
    _createVNode() {
      const vnode = createVNode(this._def, extend$2({}, this._props));
      if (!this._instance) {
        vnode.ce = (instance) => {
          this._instance = instance;
          instance.isCE = true;
          if (!!(process.env.NODE_ENV !== "production")) {
            instance.ceReload = (newStyles) => {
              if (this._styles) {
                this._styles.forEach((s2) => this.shadowRoot.removeChild(s2));
                this._styles.length = 0;
              }
              this._applyStyles(newStyles);
              this._instance = null;
              this._update();
            };
          }
          const dispatch = (event, args) => {
            this.dispatchEvent(
              new CustomEvent(event, {
                detail: args
              })
            );
          };
          instance.emit = (event, ...args) => {
            dispatch(event, args);
            if (hyphenate(event) !== event) {
              dispatch(hyphenate(event), args);
            }
          };
          let parent = this;
          while (parent = parent && (parent.parentNode || parent.host)) {
            if (parent instanceof VueElement) {
              instance.parent = parent._instance;
              instance.provides = parent._instance.provides;
              break;
            }
          }
        };
      }
      return vnode;
    }
    _applyStyles(styles) {
      if (styles) {
        styles.forEach((css2) => {
          const s2 = document.createElement("style");
          s2.textContent = css2;
          this.shadowRoot.appendChild(s2);
          if (!!(process.env.NODE_ENV !== "production")) {
            (this._styles || (this._styles = [])).push(s2);
          }
        });
      }
    }
  }
  function useCssModule(name2 = "$style") {
    {
      const instance = getCurrentInstance();
      if (!instance) {
        !!(process.env.NODE_ENV !== "production") && warn(`useCssModule must be called inside setup()`);
        return EMPTY_OBJ;
      }
      const modules = instance.type.__cssModules;
      if (!modules) {
        !!(process.env.NODE_ENV !== "production") && warn(`Current instance does not have CSS modules injected.`);
        return EMPTY_OBJ;
      }
      const mod = modules[name2];
      if (!mod) {
        !!(process.env.NODE_ENV !== "production") && warn(`Current instance does not have CSS module named "${name2}".`);
        return EMPTY_OBJ;
      }
      return mod;
    }
  }
  const positionMap = /* @__PURE__ */ new WeakMap();
  const newPositionMap = /* @__PURE__ */ new WeakMap();
  const moveCbKey = Symbol("_moveCb");
  const enterCbKey = Symbol("_enterCb");
  const TransitionGroupImpl = {
    name: "TransitionGroup",
    props: /* @__PURE__ */ extend$2({}, TransitionPropsValidators, {
      tag: String,
      moveClass: String
    }),
    setup(props, { slots }) {
      const instance = getCurrentInstance();
      const state = useTransitionState();
      let prevChildren;
      let children;
      onUpdated(() => {
        if (!prevChildren.length) {
          return;
        }
        const moveClass = props.moveClass || `${props.name || "v"}-move`;
        if (!hasCSSTransform(
          prevChildren[0].el,
          instance.vnode.el,
          moveClass
        )) {
          return;
        }
        prevChildren.forEach(callPendingCbs);
        prevChildren.forEach(recordPosition);
        const movedChildren = prevChildren.filter(applyTranslation);
        forceReflow();
        movedChildren.forEach((c2) => {
          const el = c2.el;
          const style = el.style;
          addTransitionClass(el, moveClass);
          style.transform = style.webkitTransform = style.transitionDuration = "";
          const cb = el[moveCbKey] = (e2) => {
            if (e2 && e2.target !== el) {
              return;
            }
            if (!e2 || /transform$/.test(e2.propertyName)) {
              el.removeEventListener("transitionend", cb);
              el[moveCbKey] = null;
              removeTransitionClass(el, moveClass);
            }
          };
          el.addEventListener("transitionend", cb);
        });
      });
      return () => {
        const rawProps = toRaw(props);
        const cssTransitionProps = resolveTransitionProps(rawProps);
        let tag = rawProps.tag || Fragment;
        prevChildren = children;
        children = slots.default ? getTransitionRawChildren(slots.default()) : [];
        for (let i2 = 0; i2 < children.length; i2++) {
          const child = children[i2];
          if (child.key != null) {
            setTransitionHooks(
              child,
              resolveTransitionHooks(child, cssTransitionProps, state, instance)
            );
          } else if (!!(process.env.NODE_ENV !== "production")) {
            warn(`<TransitionGroup> children must be keyed.`);
          }
        }
        if (prevChildren) {
          for (let i2 = 0; i2 < prevChildren.length; i2++) {
            const child = prevChildren[i2];
            setTransitionHooks(
              child,
              resolveTransitionHooks(child, cssTransitionProps, state, instance)
            );
            positionMap.set(child, child.el.getBoundingClientRect());
          }
        }
        return createVNode(tag, null, children);
      };
    }
  };
  const removeMode = (props) => delete props.mode;
  /* @__PURE__ */ removeMode(TransitionGroupImpl.props);
  const TransitionGroup = TransitionGroupImpl;
  function callPendingCbs(c2) {
    const el = c2.el;
    if (el[moveCbKey]) {
      el[moveCbKey]();
    }
    if (el[enterCbKey]) {
      el[enterCbKey]();
    }
  }
  function recordPosition(c2) {
    newPositionMap.set(c2, c2.el.getBoundingClientRect());
  }
  function applyTranslation(c2) {
    const oldPos = positionMap.get(c2);
    const newPos = newPositionMap.get(c2);
    const dx = oldPos.left - newPos.left;
    const dy = oldPos.top - newPos.top;
    if (dx || dy) {
      const s2 = c2.el.style;
      s2.transform = s2.webkitTransform = `translate(${dx}px,${dy}px)`;
      s2.transitionDuration = "0s";
      return c2;
    }
  }
  function hasCSSTransform(el, root, moveClass) {
    const clone = el.cloneNode();
    const _vtc = el[vtcKey];
    if (_vtc) {
      _vtc.forEach((cls) => {
        cls.split(/\s+/).forEach((c2) => c2 && clone.classList.remove(c2));
      });
    }
    moveClass.split(/\s+/).forEach((c2) => c2 && clone.classList.add(c2));
    clone.style.display = "none";
    const container = root.nodeType === 1 ? root : root.parentNode;
    container.appendChild(clone);
    const { hasTransform } = getTransitionInfo(clone);
    container.removeChild(clone);
    return hasTransform;
  }
  const getModelAssigner = (vnode) => {
    const fn = vnode.props["onUpdate:modelValue"] || false;
    return isArray$1(fn) ? (value) => invokeArrayFns(fn, value) : fn;
  };
  function onCompositionStart(e2) {
    e2.target.composing = true;
  }
  function onCompositionEnd(e2) {
    const target = e2.target;
    if (target.composing) {
      target.composing = false;
      target.dispatchEvent(new Event("input"));
    }
  }
  const assignKey = Symbol("_assign");
  const vModelText = {
    created(el, { modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
      el[assignKey] = getModelAssigner(vnode);
      const castToNumber = number2 || vnode.props && vnode.props.type === "number";
      addEventListener(el, lazy ? "change" : "input", (e2) => {
        if (e2.target.composing)
          return;
        let domValue = el.value;
        if (trim2) {
          domValue = domValue.trim();
        }
        if (castToNumber) {
          domValue = looseToNumber(domValue);
        }
        el[assignKey](domValue);
      });
      if (trim2) {
        addEventListener(el, "change", () => {
          el.value = el.value.trim();
        });
      }
      if (!lazy) {
        addEventListener(el, "compositionstart", onCompositionStart);
        addEventListener(el, "compositionend", onCompositionEnd);
        addEventListener(el, "change", onCompositionEnd);
      }
    },
    // set value on mounted so it's after min/max for type="range"
    mounted(el, { value }) {
      el.value = value == null ? "" : value;
    },
    beforeUpdate(el, { value, modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
      el[assignKey] = getModelAssigner(vnode);
      if (el.composing)
        return;
      const elValue = number2 || el.type === "number" ? looseToNumber(el.value) : el.value;
      const newValue = value == null ? "" : value;
      if (elValue === newValue) {
        return;
      }
      if (document.activeElement === el && el.type !== "range") {
        if (lazy) {
          return;
        }
        if (trim2 && el.value.trim() === newValue) {
          return;
        }
      }
      el.value = newValue;
    }
  };
  const vModelCheckbox = {
    // #4096 array checkboxes need to be deep traversed
    deep: true,
    created(el, _2, vnode) {
      el[assignKey] = getModelAssigner(vnode);
      addEventListener(el, "change", () => {
        const modelValue = el._modelValue;
        const elementValue = getValue(el);
        const checked = el.checked;
        const assign2 = el[assignKey];
        if (isArray$1(modelValue)) {
          const index2 = looseIndexOf(modelValue, elementValue);
          const found = index2 !== -1;
          if (checked && !found) {
            assign2(modelValue.concat(elementValue));
          } else if (!checked && found) {
            const filtered = [...modelValue];
            filtered.splice(index2, 1);
            assign2(filtered);
          }
        } else if (isSet(modelValue)) {
          const cloned = new Set(modelValue);
          if (checked) {
            cloned.add(elementValue);
          } else {
            cloned.delete(elementValue);
          }
          assign2(cloned);
        } else {
          assign2(getCheckboxValue(el, checked));
        }
      });
    },
    // set initial checked on mount to wait for true-value/false-value
    mounted: setChecked,
    beforeUpdate(el, binding, vnode) {
      el[assignKey] = getModelAssigner(vnode);
      setChecked(el, binding, vnode);
    }
  };
  function setChecked(el, { value, oldValue }, vnode) {
    el._modelValue = value;
    if (isArray$1(value)) {
      el.checked = looseIndexOf(value, vnode.props.value) > -1;
    } else if (isSet(value)) {
      el.checked = value.has(vnode.props.value);
    } else if (value !== oldValue) {
      el.checked = looseEqual(value, getCheckboxValue(el, true));
    }
  }
  const vModelRadio = {
    created(el, { value }, vnode) {
      el.checked = looseEqual(value, vnode.props.value);
      el[assignKey] = getModelAssigner(vnode);
      addEventListener(el, "change", () => {
        el[assignKey](getValue(el));
      });
    },
    beforeUpdate(el, { value, oldValue }, vnode) {
      el[assignKey] = getModelAssigner(vnode);
      if (value !== oldValue) {
        el.checked = looseEqual(value, vnode.props.value);
      }
    }
  };
  const vModelSelect = {
    // <select multiple> value need to be deep traversed
    deep: true,
    created(el, { value, modifiers: { number: number2 } }, vnode) {
      const isSetModel = isSet(value);
      addEventListener(el, "change", () => {
        const selectedVal = Array.prototype.filter.call(el.options, (o2) => o2.selected).map(
          (o2) => number2 ? looseToNumber(getValue(o2)) : getValue(o2)
        );
        el[assignKey](
          el.multiple ? isSetModel ? new Set(selectedVal) : selectedVal : selectedVal[0]
        );
        el._assigning = true;
        nextTick(() => {
          el._assigning = false;
        });
      });
      el[assignKey] = getModelAssigner(vnode);
    },
    // set value in mounted & updated because <select> relies on its children
    // <option>s.
    mounted(el, { value, modifiers: { number: number2 } }) {
      setSelected(el, value, number2);
    },
    beforeUpdate(el, _binding, vnode) {
      el[assignKey] = getModelAssigner(vnode);
    },
    updated(el, { value, modifiers: { number: number2 } }) {
      if (!el._assigning) {
        setSelected(el, value, number2);
      }
    }
  };
  function setSelected(el, value, number2) {
    const isMultiple = el.multiple;
    const isArrayValue = isArray$1(value);
    if (isMultiple && !isArrayValue && !isSet(value)) {
      !!(process.env.NODE_ENV !== "production") && warn(
        `<select multiple v-model> expects an Array or Set value for its binding, but got ${Object.prototype.toString.call(value).slice(8, -1)}.`
      );
      return;
    }
    for (let i2 = 0, l2 = el.options.length; i2 < l2; i2++) {
      const option = el.options[i2];
      const optionValue = getValue(option);
      if (isMultiple) {
        if (isArrayValue) {
          const optionType = typeof optionValue;
          if (optionType === "string" || optionType === "number") {
            option.selected = value.includes(
              number2 ? looseToNumber(optionValue) : optionValue
            );
          } else {
            option.selected = looseIndexOf(value, optionValue) > -1;
          }
        } else {
          option.selected = value.has(optionValue);
        }
      } else if (looseEqual(getValue(option), value)) {
        if (el.selectedIndex !== i2)
          el.selectedIndex = i2;
        return;
      }
    }
    if (!isMultiple && el.selectedIndex !== -1) {
      el.selectedIndex = -1;
    }
  }
  function getValue(el) {
    return "_value" in el ? el._value : el.value;
  }
  function getCheckboxValue(el, checked) {
    const key = checked ? "_trueValue" : "_falseValue";
    return key in el ? el[key] : checked;
  }
  const vModelDynamic = {
    created(el, binding, vnode) {
      callModelHook(el, binding, vnode, null, "created");
    },
    mounted(el, binding, vnode) {
      callModelHook(el, binding, vnode, null, "mounted");
    },
    beforeUpdate(el, binding, vnode, prevVNode) {
      callModelHook(el, binding, vnode, prevVNode, "beforeUpdate");
    },
    updated(el, binding, vnode, prevVNode) {
      callModelHook(el, binding, vnode, prevVNode, "updated");
    }
  };
  function resolveDynamicModel(tagName, type) {
    switch (tagName) {
      case "SELECT":
        return vModelSelect;
      case "TEXTAREA":
        return vModelText;
      default:
        switch (type) {
          case "checkbox":
            return vModelCheckbox;
          case "radio":
            return vModelRadio;
          default:
            return vModelText;
        }
    }
  }
  function callModelHook(el, binding, vnode, prevVNode, hook) {
    const modelToUse = resolveDynamicModel(
      el.tagName,
      vnode.props && vnode.props.type
    );
    const fn = modelToUse[hook];
    fn && fn(el, binding, vnode, prevVNode);
  }
  function initVModelForSSR() {
    vModelText.getSSRProps = ({ value }) => ({ value });
    vModelRadio.getSSRProps = ({ value }, vnode) => {
      if (vnode.props && looseEqual(vnode.props.value, value)) {
        return { checked: true };
      }
    };
    vModelCheckbox.getSSRProps = ({ value }, vnode) => {
      if (isArray$1(value)) {
        if (vnode.props && looseIndexOf(value, vnode.props.value) > -1) {
          return { checked: true };
        }
      } else if (isSet(value)) {
        if (vnode.props && value.has(vnode.props.value)) {
          return { checked: true };
        }
      } else if (value) {
        return { checked: true };
      }
    };
    vModelDynamic.getSSRProps = (binding, vnode) => {
      if (typeof vnode.type !== "string") {
        return;
      }
      const modelToUse = resolveDynamicModel(
        // resolveDynamicModel expects an uppercase tag name, but vnode.type is lowercase
        vnode.type.toUpperCase(),
        vnode.props && vnode.props.type
      );
      if (modelToUse.getSSRProps) {
        return modelToUse.getSSRProps(binding, vnode);
      }
    };
  }
  const systemModifiers = ["ctrl", "shift", "alt", "meta"];
  const modifierGuards = {
    stop: (e2) => e2.stopPropagation(),
    prevent: (e2) => e2.preventDefault(),
    self: (e2) => e2.target !== e2.currentTarget,
    ctrl: (e2) => !e2.ctrlKey,
    shift: (e2) => !e2.shiftKey,
    alt: (e2) => !e2.altKey,
    meta: (e2) => !e2.metaKey,
    left: (e2) => "button" in e2 && e2.button !== 0,
    middle: (e2) => "button" in e2 && e2.button !== 1,
    right: (e2) => "button" in e2 && e2.button !== 2,
    exact: (e2, modifiers2) => systemModifiers.some((m2) => e2[`${m2}Key`] && !modifiers2.includes(m2))
  };
  const withModifiers = (fn, modifiers2) => {
    const cache2 = fn._withMods || (fn._withMods = {});
    const cacheKey = modifiers2.join(".");
    return cache2[cacheKey] || (cache2[cacheKey] = (event, ...args) => {
      for (let i2 = 0; i2 < modifiers2.length; i2++) {
        const guard = modifierGuards[modifiers2[i2]];
        if (guard && guard(event, modifiers2))
          return;
      }
      return fn(event, ...args);
    });
  };
  const keyNames = {
    esc: "escape",
    space: " ",
    up: "arrow-up",
    left: "arrow-left",
    right: "arrow-right",
    down: "arrow-down",
    delete: "backspace"
  };
  const withKeys = (fn, modifiers2) => {
    const cache2 = fn._withKeys || (fn._withKeys = {});
    const cacheKey = modifiers2.join(".");
    return cache2[cacheKey] || (cache2[cacheKey] = (event) => {
      if (!("key" in event)) {
        return;
      }
      const eventKey = hyphenate(event.key);
      if (modifiers2.some((k2) => k2 === eventKey || keyNames[k2] === eventKey)) {
        return fn(event);
      }
    });
  };
  const rendererOptions = /* @__PURE__ */ extend$2({ patchProp }, nodeOps);
  let renderer;
  let enabledHydration = false;
  function ensureRenderer() {
    return renderer || (renderer = createRenderer(rendererOptions));
  }
  function ensureHydrationRenderer() {
    renderer = enabledHydration ? renderer : createHydrationRenderer(rendererOptions);
    enabledHydration = true;
    return renderer;
  }
  const render = (...args) => {
    ensureRenderer().render(...args);
  };
  const hydrate = (...args) => {
    ensureHydrationRenderer().hydrate(...args);
  };
  const createApp = (...args) => {
    const app = ensureRenderer().createApp(...args);
    if (!!(process.env.NODE_ENV !== "production")) {
      injectNativeTagCheck(app);
      injectCompilerOptionsCheck(app);
    }
    const { mount } = app;
    app.mount = (containerOrSelector) => {
      const container = normalizeContainer(containerOrSelector);
      if (!container)
        return;
      const component = app._component;
      if (!isFunction$1(component) && !component.render && !component.template) {
        component.template = container.innerHTML;
      }
      container.innerHTML = "";
      const proxy = mount(container, false, resolveRootNamespace(container));
      if (container instanceof Element) {
        container.removeAttribute("v-cloak");
        container.setAttribute("data-v-app", "");
      }
      return proxy;
    };
    return app;
  };
  const createSSRApp = (...args) => {
    const app = ensureHydrationRenderer().createApp(...args);
    if (!!(process.env.NODE_ENV !== "production")) {
      injectNativeTagCheck(app);
      injectCompilerOptionsCheck(app);
    }
    const { mount } = app;
    app.mount = (containerOrSelector) => {
      const container = normalizeContainer(containerOrSelector);
      if (container) {
        return mount(container, true, resolveRootNamespace(container));
      }
    };
    return app;
  };
  function resolveRootNamespace(container) {
    if (container instanceof SVGElement) {
      return "svg";
    }
    if (typeof MathMLElement === "function" && container instanceof MathMLElement) {
      return "mathml";
    }
  }
  function injectNativeTagCheck(app) {
    Object.defineProperty(app.config, "isNativeTag", {
      value: (tag) => isHTMLTag(tag) || isSVGTag(tag) || isMathMLTag(tag),
      writable: false
    });
  }
  function injectCompilerOptionsCheck(app) {
    if (isRuntimeOnly()) {
      const isCustomElement = app.config.isCustomElement;
      Object.defineProperty(app.config, "isCustomElement", {
        get() {
          return isCustomElement;
        },
        set() {
          warn(
            `The \`isCustomElement\` config option is deprecated. Use \`compilerOptions.isCustomElement\` instead.`
          );
        }
      });
      const compilerOptions = app.config.compilerOptions;
      const msg = `The \`compilerOptions\` config option is only respected when using a build of Vue.js that includes the runtime compiler (aka "full build"). Since you are using the runtime-only build, \`compilerOptions\` must be passed to \`@vue/compiler-dom\` in the build setup instead.
- For vue-loader: pass it via vue-loader's \`compilerOptions\` loader option.
- For vue-cli: see https://cli.vuejs.org/guide/webpack.html#modifying-options-of-a-loader
- For vite: pass it via @vitejs/plugin-vue options. See https://github.com/vitejs/vite-plugin-vue/tree/main/packages/plugin-vue#example-for-passing-options-to-vuecompiler-sfc`;
      Object.defineProperty(app.config, "compilerOptions", {
        get() {
          warn(msg);
          return compilerOptions;
        },
        set() {
          warn(msg);
        }
      });
    }
  }
  function normalizeContainer(container) {
    if (isString$1(container)) {
      const res = document.querySelector(container);
      if (!!(process.env.NODE_ENV !== "production") && !res) {
        warn(
          `Failed to mount app: mount target selector "${container}" returned null.`
        );
      }
      return res;
    }
    if (!!(process.env.NODE_ENV !== "production") && window.ShadowRoot && container instanceof window.ShadowRoot && container.mode === "closed") {
      warn(
        `mounting on a ShadowRoot with \`{mode: "closed"}\` may lead to unpredictable bugs`
      );
    }
    return container;
  }
  let ssrDirectiveInitialized = false;
  const initDirectivesForSSR = () => {
    if (!ssrDirectiveInitialized) {
      ssrDirectiveInitialized = true;
      initVModelForSSR();
      initVShowForSSR();
    }
  };
  const runtimeDom = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    BaseTransition,
    BaseTransitionPropsValidators,
    Comment: Comment$1,
    DeprecationTypes,
    EffectScope,
    ErrorCodes,
    ErrorTypeStrings,
    Fragment,
    KeepAlive,
    ReactiveEffect,
    Static,
    Suspense,
    Teleport,
    Text: Text$2,
    TrackOpTypes,
    Transition,
    TransitionGroup,
    TriggerOpTypes,
    VueElement,
    assertNumber,
    callWithAsyncErrorHandling,
    callWithErrorHandling,
    camelize,
    capitalize,
    cloneVNode,
    compatUtils,
    computed,
    createApp,
    createBlock,
    createCommentVNode,
    createElementBlock,
    createElementVNode: createBaseVNode,
    createHydrationRenderer,
    createPropsRestProxy,
    createRenderer,
    createSSRApp,
    createSlots,
    createStaticVNode,
    createTextVNode,
    createVNode,
    customRef,
    defineAsyncComponent,
    defineComponent,
    defineCustomElement,
    defineEmits,
    defineExpose,
    defineModel,
    defineOptions,
    defineProps,
    defineSSRCustomElement,
    defineSlots,
    devtools,
    effect,
    effectScope,
    getCurrentInstance,
    getCurrentScope,
    getTransitionRawChildren,
    guardReactiveProps,
    h: h$1,
    handleError,
    hasInjectionContext,
    hydrate,
    initCustomFormatter,
    initDirectivesForSSR,
    inject,
    isMemoSame,
    isProxy,
    isReactive,
    isReadonly,
    isRef,
    isRuntimeOnly,
    isShallow,
    isVNode,
    markRaw,
    mergeDefaults,
    mergeModels,
    mergeProps,
    nextTick,
    normalizeClass,
    normalizeProps,
    normalizeStyle,
    onActivated,
    onBeforeMount,
    onBeforeUnmount,
    onBeforeUpdate,
    onDeactivated,
    onErrorCaptured,
    onMounted,
    onRenderTracked,
    onRenderTriggered,
    onScopeDispose,
    onServerPrefetch,
    onUnmounted,
    onUpdated,
    openBlock,
    popScopeId,
    provide,
    proxyRefs,
    pushScopeId,
    queuePostFlushCb,
    reactive,
    readonly,
    ref,
    registerRuntimeCompiler,
    render,
    renderList,
    renderSlot,
    resolveComponent,
    resolveDirective,
    resolveDynamicComponent,
    resolveFilter,
    resolveTransitionHooks,
    setBlockTracking,
    setDevtoolsHook,
    setTransitionHooks,
    shallowReactive,
    shallowReadonly,
    shallowRef,
    ssrContextKey,
    ssrUtils,
    stop,
    toDisplayString,
    toHandlerKey,
    toHandlers,
    toRaw,
    toRef,
    toRefs,
    toValue: toValue$2,
    transformVNodeArgs,
    triggerRef,
    unref,
    useAttrs,
    useCssModule,
    useCssVars,
    useModel,
    useSSRContext,
    useSlots,
    useTransitionState,
    vModelCheckbox,
    vModelDynamic,
    vModelRadio,
    vModelSelect,
    vModelText,
    vShow,
    version,
    warn,
    watch,
    watchEffect,
    watchPostEffect,
    watchSyncEffect,
    withAsyncContext,
    withCtx,
    withDefaults,
    withDirectives,
    withKeys,
    withMemo,
    withModifiers,
    withScopeId
  }, Symbol.toStringTag, { value: "Module" }));
  /**
  * vue v3.4.21
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  function initDev$1() {
    {
      initCustomFormatter();
    }
  }
  if (!!(process.env.NODE_ENV !== "production")) {
    initDev$1();
  }
  let t$7 = Symbol("headlessui.useid"), i$6 = 0;
  function I$1() {
    return inject(t$7, () => `${++i$6}`)();
  }
  function o$2(e2) {
    var l2;
    if (e2 == null || e2.value == null)
      return null;
    let n2 = (l2 = e2.value.$el) != null ? l2 : e2.value;
    return n2 instanceof Node ? n2 : null;
  }
  function u$4(r2, n2, ...a2) {
    if (r2 in n2) {
      let e2 = n2[r2];
      return typeof e2 == "function" ? e2(...a2) : e2;
    }
    let t2 = new Error(`Tried to handle "${r2}" but there is no handler defined. Only defined handlers are: ${Object.keys(n2).map((e2) => `"${e2}"`).join(", ")}.`);
    throw Error.captureStackTrace && Error.captureStackTrace(t2, u$4), t2;
  }
  var i$5 = Object.defineProperty;
  var d$3 = (t2, e2, r2) => e2 in t2 ? i$5(t2, e2, { enumerable: true, configurable: true, writable: true, value: r2 }) : t2[e2] = r2;
  var n$3 = (t2, e2, r2) => (d$3(t2, typeof e2 != "symbol" ? e2 + "" : e2, r2), r2);
  let s$4 = class s {
    constructor() {
      n$3(this, "current", this.detect());
      n$3(this, "currentId", 0);
    }
    set(e2) {
      this.current !== e2 && (this.currentId = 0, this.current = e2);
    }
    reset() {
      this.set(this.detect());
    }
    nextId() {
      return ++this.currentId;
    }
    get isServer() {
      return this.current === "server";
    }
    get isClient() {
      return this.current === "client";
    }
    detect() {
      return typeof window == "undefined" || typeof document == "undefined" ? "server" : "client";
    }
  };
  let c$2 = new s$4();
  function i$4(r2) {
    if (c$2.isServer)
      return null;
    if (r2 instanceof Node)
      return r2.ownerDocument;
    if (r2 != null && r2.hasOwnProperty("value")) {
      let n2 = o$2(r2);
      if (n2)
        return n2.ownerDocument;
    }
    return document;
  }
  let c$1 = ["[contentEditable=true]", "[tabindex]", "a[href]", "area[href]", "button:not([disabled])", "iframe", "input:not([disabled])", "select:not([disabled])", "textarea:not([disabled])"].map((e2) => `${e2}:not([tabindex='-1'])`).join(",");
  var N$6 = ((n2) => (n2[n2.First = 1] = "First", n2[n2.Previous = 2] = "Previous", n2[n2.Next = 4] = "Next", n2[n2.Last = 8] = "Last", n2[n2.WrapAround = 16] = "WrapAround", n2[n2.NoScroll = 32] = "NoScroll", n2))(N$6 || {}), T$3 = ((o2) => (o2[o2.Error = 0] = "Error", o2[o2.Overflow = 1] = "Overflow", o2[o2.Success = 2] = "Success", o2[o2.Underflow = 3] = "Underflow", o2))(T$3 || {}), F = ((t2) => (t2[t2.Previous = -1] = "Previous", t2[t2.Next = 1] = "Next", t2))(F || {});
  function E$3(e2 = document.body) {
    return e2 == null ? [] : Array.from(e2.querySelectorAll(c$1)).sort((r2, t2) => Math.sign((r2.tabIndex || Number.MAX_SAFE_INTEGER) - (t2.tabIndex || Number.MAX_SAFE_INTEGER)));
  }
  var h = ((t2) => (t2[t2.Strict = 0] = "Strict", t2[t2.Loose = 1] = "Loose", t2))(h || {});
  function w$4(e2, r2 = 0) {
    var t2;
    return e2 === ((t2 = i$4(e2)) == null ? void 0 : t2.body) ? false : u$4(r2, { [0]() {
      return e2.matches(c$1);
    }, [1]() {
      let l2 = e2;
      for (; l2 !== null; ) {
        if (l2.matches(c$1))
          return true;
        l2 = l2.parentElement;
      }
      return false;
    } });
  }
  var y$2 = ((t2) => (t2[t2.Keyboard = 0] = "Keyboard", t2[t2.Mouse = 1] = "Mouse", t2))(y$2 || {});
  typeof window != "undefined" && typeof document != "undefined" && (document.addEventListener("keydown", (e2) => {
    e2.metaKey || e2.altKey || e2.ctrlKey || (document.documentElement.dataset.headlessuiFocusVisible = "");
  }, true), document.addEventListener("click", (e2) => {
    e2.detail === 1 ? delete document.documentElement.dataset.headlessuiFocusVisible : e2.detail === 0 && (document.documentElement.dataset.headlessuiFocusVisible = "");
  }, true));
  function S$2(e2) {
    e2 == null || e2.focus({ preventScroll: true });
  }
  let H$1 = ["textarea", "input"].join(",");
  function I(e2) {
    var r2, t2;
    return (t2 = (r2 = e2 == null ? void 0 : e2.matches) == null ? void 0 : r2.call(e2, H$1)) != null ? t2 : false;
  }
  function O$1(e2, r2 = (t2) => t2) {
    return e2.slice().sort((t2, l2) => {
      let o2 = r2(t2), i2 = r2(l2);
      if (o2 === null || i2 === null)
        return 0;
      let n2 = o2.compareDocumentPosition(i2);
      return n2 & Node.DOCUMENT_POSITION_FOLLOWING ? -1 : n2 & Node.DOCUMENT_POSITION_PRECEDING ? 1 : 0;
    });
  }
  function P(e2, r2, { sorted: t2 = true, relativeTo: l2 = null, skipElements: o2 = [] } = {}) {
    var m2;
    let i2 = (m2 = Array.isArray(e2) ? e2.length > 0 ? e2[0].ownerDocument : document : e2 == null ? void 0 : e2.ownerDocument) != null ? m2 : document, n2 = Array.isArray(e2) ? t2 ? O$1(e2) : e2 : E$3(e2);
    o2.length > 0 && n2.length > 1 && (n2 = n2.filter((s2) => !o2.includes(s2))), l2 = l2 != null ? l2 : i2.activeElement;
    let x2 = (() => {
      if (r2 & 5)
        return 1;
      if (r2 & 10)
        return -1;
      throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
    })(), p2 = (() => {
      if (r2 & 1)
        return 0;
      if (r2 & 2)
        return Math.max(0, n2.indexOf(l2)) - 1;
      if (r2 & 4)
        return Math.max(0, n2.indexOf(l2)) + 1;
      if (r2 & 8)
        return n2.length - 1;
      throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
    })(), L = r2 & 32 ? { preventScroll: true } : {}, a2 = 0, d2 = n2.length, u2;
    do {
      if (a2 >= d2 || a2 + d2 <= 0)
        return 0;
      let s2 = p2 + a2;
      if (r2 & 16)
        s2 = (s2 + d2) % d2;
      else {
        if (s2 < 0)
          return 3;
        if (s2 >= d2)
          return 1;
      }
      u2 = n2[s2], u2 == null || u2.focus(L), a2 += x2;
    } while (u2 !== i2.activeElement);
    return r2 & 6 && I(u2) && u2.select(), 2;
  }
  function t$6() {
    return /iPhone/gi.test(window.navigator.platform) || /Mac/gi.test(window.navigator.platform) && window.navigator.maxTouchPoints > 0;
  }
  function i$3() {
    return /Android/gi.test(window.navigator.userAgent);
  }
  function n$2() {
    return t$6() || i$3();
  }
  function u$3(e2, t2, n2) {
    c$2.isServer || watchEffect((o2) => {
      document.addEventListener(e2, t2, n2), o2(() => document.removeEventListener(e2, t2, n2));
    });
  }
  function w$3(e2, n2, t2) {
    c$2.isServer || watchEffect((o2) => {
      window.addEventListener(e2, n2, t2), o2(() => window.removeEventListener(e2, n2, t2));
    });
  }
  function w$2(f2, m2, l2 = computed(() => true)) {
    function a2(e2, r2) {
      if (!l2.value || e2.defaultPrevented)
        return;
      let t2 = r2(e2);
      if (t2 === null || !t2.getRootNode().contains(t2))
        return;
      let c2 = function o2(n2) {
        return typeof n2 == "function" ? o2(n2()) : Array.isArray(n2) || n2 instanceof Set ? n2 : [n2];
      }(f2);
      for (let o2 of c2) {
        if (o2 === null)
          continue;
        let n2 = o2 instanceof HTMLElement ? o2 : o$2(o2);
        if (n2 != null && n2.contains(t2) || e2.composed && e2.composedPath().includes(n2))
          return;
      }
      return !w$4(t2, h.Loose) && t2.tabIndex !== -1 && e2.preventDefault(), m2(e2, t2);
    }
    let u2 = ref(null);
    u$3("pointerdown", (e2) => {
      var r2, t2;
      l2.value && (u2.value = ((t2 = (r2 = e2.composedPath) == null ? void 0 : r2.call(e2)) == null ? void 0 : t2[0]) || e2.target);
    }, true), u$3("mousedown", (e2) => {
      var r2, t2;
      l2.value && (u2.value = ((t2 = (r2 = e2.composedPath) == null ? void 0 : r2.call(e2)) == null ? void 0 : t2[0]) || e2.target);
    }, true), u$3("click", (e2) => {
      n$2() || u2.value && (a2(e2, () => u2.value), u2.value = null);
    }, true), u$3("touchend", (e2) => a2(e2, () => e2.target instanceof HTMLElement ? e2.target : null), true), w$3("blur", (e2) => a2(e2, () => window.document.activeElement instanceof HTMLIFrameElement ? window.document.activeElement : null), true);
  }
  function r$1(t2, e2) {
    if (t2)
      return t2;
    let n2 = e2 != null ? e2 : "button";
    if (typeof n2 == "string" && n2.toLowerCase() === "button")
      return "button";
  }
  function s$3(t2, e2) {
    let n2 = ref(r$1(t2.value.type, t2.value.as));
    return onMounted(() => {
      n2.value = r$1(t2.value.type, t2.value.as);
    }), watchEffect(() => {
      var u2;
      n2.value || o$2(e2) && o$2(e2) instanceof HTMLButtonElement && !((u2 = o$2(e2)) != null && u2.hasAttribute("type")) && (n2.value = "button");
    }), n2;
  }
  var N$5 = ((o2) => (o2[o2.None = 0] = "None", o2[o2.RenderStrategy = 1] = "RenderStrategy", o2[o2.Static = 2] = "Static", o2))(N$5 || {}), S$1 = ((e2) => (e2[e2.Unmount = 0] = "Unmount", e2[e2.Hidden = 1] = "Hidden", e2))(S$1 || {});
  function A$3({ visible: r2 = true, features: t2 = 0, ourProps: e2, theirProps: o2, ...i2 }) {
    var a2;
    let n2 = j(o2, e2), l2 = Object.assign(i2, { props: n2 });
    if (r2 || t2 & 2 && n2.static)
      return y$1(l2);
    if (t2 & 1) {
      let d2 = (a2 = n2.unmount) == null || a2 ? 0 : 1;
      return u$4(d2, { [0]() {
        return null;
      }, [1]() {
        return y$1({ ...i2, props: { ...n2, hidden: true, style: { display: "none" } } });
      } });
    }
    return y$1(l2);
  }
  function y$1({ props: r2, attrs: t2, slots: e2, slot: o2, name: i2 }) {
    var m2, h2;
    let { as: n2, ...l2 } = T$2(r2, ["unmount", "static"]), a2 = (m2 = e2.default) == null ? void 0 : m2.call(e2, o2), d2 = {};
    if (o2) {
      let u2 = false, c2 = [];
      for (let [p2, f2] of Object.entries(o2))
        typeof f2 == "boolean" && (u2 = true), f2 === true && c2.push(p2);
      u2 && (d2["data-headlessui-state"] = c2.join(" "));
    }
    if (n2 === "template") {
      if (a2 = b(a2 != null ? a2 : []), Object.keys(l2).length > 0 || Object.keys(t2).length > 0) {
        let [u2, ...c2] = a2 != null ? a2 : [];
        if (!v(u2) || c2.length > 0)
          throw new Error(['Passing props on "template"!', "", `The current component <${i2} /> is rendering a "template".`, "However we need to passthrough the following props:", Object.keys(l2).concat(Object.keys(t2)).map((s2) => s2.trim()).filter((s2, g, R2) => R2.indexOf(s2) === g).sort((s2, g) => s2.localeCompare(g)).map((s2) => `  - ${s2}`).join(`
`), "", "You can apply a few solutions:", ['Add an `as="..."` prop, to ensure that we render an actual element instead of a "template".', "Render a single element as the child so that we can forward the props onto that element."].map((s2) => `  - ${s2}`).join(`
`)].join(`
`));
        let p2 = j((h2 = u2.props) != null ? h2 : {}, l2, d2), f2 = cloneVNode(u2, p2, true);
        for (let s2 in p2)
          s2.startsWith("on") && (f2.props || (f2.props = {}), f2.props[s2] = p2[s2]);
        return f2;
      }
      return Array.isArray(a2) && a2.length === 1 ? a2[0] : a2;
    }
    return h$1(n2, Object.assign({}, l2, d2), { default: () => a2 });
  }
  function b(r2) {
    return r2.flatMap((t2) => t2.type === Fragment ? b(t2.children) : [t2]);
  }
  function j(...r2) {
    if (r2.length === 0)
      return {};
    if (r2.length === 1)
      return r2[0];
    let t2 = {}, e2 = {};
    for (let i2 of r2)
      for (let n2 in i2)
        n2.startsWith("on") && typeof i2[n2] == "function" ? (e2[n2] != null || (e2[n2] = []), e2[n2].push(i2[n2])) : t2[n2] = i2[n2];
    if (t2.disabled || t2["aria-disabled"])
      return Object.assign(t2, Object.fromEntries(Object.keys(e2).map((i2) => [i2, void 0])));
    for (let i2 in e2)
      Object.assign(t2, { [i2](n2, ...l2) {
        let a2 = e2[i2];
        for (let d2 of a2) {
          if (n2 instanceof Event && n2.defaultPrevented)
            return;
          d2(n2, ...l2);
        }
      } });
    return t2;
  }
  function T$2(r2, t2 = []) {
    let e2 = Object.assign({}, r2);
    for (let o2 of t2)
      o2 in e2 && delete e2[o2];
    return e2;
  }
  function v(r2) {
    return r2 == null ? false : typeof r2.type == "string" || typeof r2.type == "object" || typeof r2.type == "function";
  }
  var s$2 = ((e2) => (e2[e2.None = 1] = "None", e2[e2.Focusable = 2] = "Focusable", e2[e2.Hidden = 4] = "Hidden", e2))(s$2 || {});
  let f = /* @__PURE__ */ defineComponent({ name: "Hidden", props: { as: { type: [Object, String], default: "div" }, features: { type: Number, default: 1 } }, setup(d2, { slots: o2, attrs: i2 }) {
    return () => {
      var t2;
      let { features: e2, ...r2 } = d2, n2 = { "aria-hidden": (e2 & 2) === 2 ? true : (t2 = r2["aria-hidden"]) != null ? t2 : void 0, style: { position: "fixed", top: 1, left: 1, width: 1, height: 0, padding: 0, margin: -1, overflow: "hidden", clip: "rect(0, 0, 0, 0)", whiteSpace: "nowrap", borderWidth: "0", ...(e2 & 4) === 4 && (e2 & 2) !== 2 && { display: "none" } } };
      return A$3({ ourProps: n2, theirProps: r2, slot: {}, attrs: i2, slots: o2, name: "Hidden" });
    };
  } });
  let n$1 = Symbol("Context");
  var i$2 = ((e2) => (e2[e2.Open = 1] = "Open", e2[e2.Closed = 2] = "Closed", e2[e2.Closing = 4] = "Closing", e2[e2.Opening = 8] = "Opening", e2))(i$2 || {});
  function l$1() {
    return inject(n$1, null);
  }
  function t$5(o2) {
    provide(n$1, o2);
  }
  var o$1 = ((r2) => (r2.Space = " ", r2.Enter = "Enter", r2.Escape = "Escape", r2.Backspace = "Backspace", r2.Delete = "Delete", r2.ArrowLeft = "ArrowLeft", r2.ArrowUp = "ArrowUp", r2.ArrowRight = "ArrowRight", r2.ArrowDown = "ArrowDown", r2.Home = "Home", r2.End = "End", r2.PageUp = "PageUp", r2.PageDown = "PageDown", r2.Tab = "Tab", r2))(o$1 || {});
  function t$4(n2) {
    function e2() {
      document.readyState !== "loading" && (n2(), document.removeEventListener("DOMContentLoaded", e2));
    }
    typeof window != "undefined" && typeof document != "undefined" && (document.addEventListener("DOMContentLoaded", e2), e2());
  }
  let t$3 = [];
  t$4(() => {
    function e2(n2) {
      n2.target instanceof HTMLElement && n2.target !== document.body && t$3[0] !== n2.target && (t$3.unshift(n2.target), t$3 = t$3.filter((r2) => r2 != null && r2.isConnected), t$3.splice(10));
    }
    window.addEventListener("click", e2, { capture: true }), window.addEventListener("mousedown", e2, { capture: true }), window.addEventListener("focus", e2, { capture: true }), document.body.addEventListener("click", e2, { capture: true }), document.body.addEventListener("mousedown", e2, { capture: true }), document.body.addEventListener("focus", e2, { capture: true });
  });
  function t$2(e2) {
    typeof queueMicrotask == "function" ? queueMicrotask(e2) : Promise.resolve().then(e2).catch((o2) => setTimeout(() => {
      throw o2;
    }));
  }
  function o() {
    let a2 = [], s2 = { addEventListener(e2, t2, r2, i2) {
      return e2.addEventListener(t2, r2, i2), s2.add(() => e2.removeEventListener(t2, r2, i2));
    }, requestAnimationFrame(...e2) {
      let t2 = requestAnimationFrame(...e2);
      s2.add(() => cancelAnimationFrame(t2));
    }, nextFrame(...e2) {
      s2.requestAnimationFrame(() => {
        s2.requestAnimationFrame(...e2);
      });
    }, setTimeout(...e2) {
      let t2 = setTimeout(...e2);
      s2.add(() => clearTimeout(t2));
    }, microTask(...e2) {
      let t2 = { current: true };
      return t$2(() => {
        t2.current && e2[0]();
      }), s2.add(() => {
        t2.current = false;
      });
    }, style(e2, t2, r2) {
      let i2 = e2.style.getPropertyValue(t2);
      return Object.assign(e2.style, { [t2]: r2 }), this.add(() => {
        Object.assign(e2.style, { [t2]: i2 });
      });
    }, group(e2) {
      let t2 = o();
      return e2(t2), this.add(() => t2.dispose());
    }, add(e2) {
      return a2.push(e2), () => {
        let t2 = a2.indexOf(e2);
        if (t2 >= 0)
          for (let r2 of a2.splice(t2, 1))
            r2();
      };
    }, dispose() {
      for (let e2 of a2.splice(0))
        e2();
    } };
    return s2;
  }
  function E$2(n2, e2, o2, r2) {
    c$2.isServer || watchEffect((t2) => {
      n2 = n2 != null ? n2 : window, n2.addEventListener(e2, o2, r2), t2(() => n2.removeEventListener(e2, o2, r2));
    });
  }
  var d$2 = ((r2) => (r2[r2.Forwards = 0] = "Forwards", r2[r2.Backwards = 1] = "Backwards", r2))(d$2 || {});
  function n() {
    let o2 = ref(0);
    return w$3("keydown", (e2) => {
      e2.key === "Tab" && (o2.value = e2.shiftKey ? 1 : 0);
    }), o2;
  }
  function B(t2) {
    if (!t2)
      return /* @__PURE__ */ new Set();
    if (typeof t2 == "function")
      return new Set(t2());
    let n2 = /* @__PURE__ */ new Set();
    for (let r2 of t2.value) {
      let l2 = o$2(r2);
      l2 instanceof HTMLElement && n2.add(l2);
    }
    return n2;
  }
  var A$2 = ((e2) => (e2[e2.None = 1] = "None", e2[e2.InitialFocus = 2] = "InitialFocus", e2[e2.TabLock = 4] = "TabLock", e2[e2.FocusLock = 8] = "FocusLock", e2[e2.RestoreFocus = 16] = "RestoreFocus", e2[e2.All = 30] = "All", e2))(A$2 || {});
  let ue = Object.assign(/* @__PURE__ */ defineComponent({ name: "FocusTrap", props: { as: { type: [Object, String], default: "div" }, initialFocus: { type: Object, default: null }, features: { type: Number, default: 30 }, containers: { type: [Object, Function], default: ref(/* @__PURE__ */ new Set()) } }, inheritAttrs: false, setup(t2, { attrs: n$12, slots: r2, expose: l2 }) {
    let o2 = ref(null);
    l2({ el: o2, $el: o2 });
    let i2 = computed(() => i$4(o2)), e2 = ref(false);
    onMounted(() => e2.value = true), onUnmounted(() => e2.value = false), $$1({ ownerDocument: i2 }, computed(() => e2.value && Boolean(t2.features & 16)));
    let m2 = z({ ownerDocument: i2, container: o2, initialFocus: computed(() => t2.initialFocus) }, computed(() => e2.value && Boolean(t2.features & 2)));
    J$1({ ownerDocument: i2, container: o2, containers: t2.containers, previousActiveElement: m2 }, computed(() => e2.value && Boolean(t2.features & 8)));
    let f$1 = n();
    function a2(u2) {
      let T2 = o$2(o2);
      if (!T2)
        return;
      ((w2) => w2())(() => {
        u$4(f$1.value, { [d$2.Forwards]: () => {
          P(T2, N$6.First, { skipElements: [u2.relatedTarget] });
        }, [d$2.Backwards]: () => {
          P(T2, N$6.Last, { skipElements: [u2.relatedTarget] });
        } });
      });
    }
    let s2 = ref(false);
    function F2(u2) {
      u2.key === "Tab" && (s2.value = true, requestAnimationFrame(() => {
        s2.value = false;
      }));
    }
    function H2(u2) {
      if (!e2.value)
        return;
      let T2 = B(t2.containers);
      o$2(o2) instanceof HTMLElement && T2.add(o$2(o2));
      let d2 = u2.relatedTarget;
      d2 instanceof HTMLElement && d2.dataset.headlessuiFocusGuard !== "true" && (N$4(T2, d2) || (s2.value ? P(o$2(o2), u$4(f$1.value, { [d$2.Forwards]: () => N$6.Next, [d$2.Backwards]: () => N$6.Previous }) | N$6.WrapAround, { relativeTo: u2.target }) : u2.target instanceof HTMLElement && S$2(u2.target)));
    }
    return () => {
      let u2 = {}, T2 = { ref: o2, onKeydown: F2, onFocusout: H2 }, { features: d2, initialFocus: w2, containers: Q2, ...O2 } = t2;
      return h$1(Fragment, [Boolean(d2 & 4) && h$1(f, { as: "button", type: "button", "data-headlessui-focus-guard": true, onFocus: a2, features: s$2.Focusable }), A$3({ ourProps: T2, theirProps: { ...n$12, ...O2 }, slot: u2, attrs: n$12, slots: r2, name: "FocusTrap" }), Boolean(d2 & 4) && h$1(f, { as: "button", type: "button", "data-headlessui-focus-guard": true, onFocus: a2, features: s$2.Focusable })]);
    };
  } }), { features: A$2 });
  function W(t2) {
    let n2 = ref(t$3.slice());
    return watch([t2], ([r2], [l2]) => {
      l2 === true && r2 === false ? t$2(() => {
        n2.value.splice(0);
      }) : l2 === false && r2 === true && (n2.value = t$3.slice());
    }, { flush: "post" }), () => {
      var r2;
      return (r2 = n2.value.find((l2) => l2 != null && l2.isConnected)) != null ? r2 : null;
    };
  }
  function $$1({ ownerDocument: t2 }, n2) {
    let r2 = W(n2);
    onMounted(() => {
      watchEffect(() => {
        var l2, o2;
        n2.value || ((l2 = t2.value) == null ? void 0 : l2.activeElement) === ((o2 = t2.value) == null ? void 0 : o2.body) && S$2(r2());
      }, { flush: "post" });
    }), onUnmounted(() => {
      n2.value && S$2(r2());
    });
  }
  function z({ ownerDocument: t2, container: n2, initialFocus: r2 }, l2) {
    let o2 = ref(null), i2 = ref(false);
    return onMounted(() => i2.value = true), onUnmounted(() => i2.value = false), onMounted(() => {
      watch([n2, r2, l2], (e2, m2) => {
        if (e2.every((a2, s2) => (m2 == null ? void 0 : m2[s2]) === a2) || !l2.value)
          return;
        let f2 = o$2(n2);
        f2 && t$2(() => {
          var F2, H2;
          if (!i2.value)
            return;
          let a2 = o$2(r2), s2 = (F2 = t2.value) == null ? void 0 : F2.activeElement;
          if (a2) {
            if (a2 === s2) {
              o2.value = s2;
              return;
            }
          } else if (f2.contains(s2)) {
            o2.value = s2;
            return;
          }
          a2 ? S$2(a2) : P(f2, N$6.First | N$6.NoScroll) === T$3.Error && console.warn("There are no focusable elements inside the <FocusTrap />"), o2.value = (H2 = t2.value) == null ? void 0 : H2.activeElement;
        });
      }, { immediate: true, flush: "post" });
    }), o2;
  }
  function J$1({ ownerDocument: t2, container: n2, containers: r2, previousActiveElement: l2 }, o2) {
    var i2;
    E$2((i2 = t2.value) == null ? void 0 : i2.defaultView, "focus", (e2) => {
      if (!o2.value)
        return;
      let m2 = B(r2);
      o$2(n2) instanceof HTMLElement && m2.add(o$2(n2));
      let f2 = l2.value;
      if (!f2)
        return;
      let a2 = e2.target;
      a2 && a2 instanceof HTMLElement ? N$4(m2, a2) ? (l2.value = a2, S$2(a2)) : (e2.preventDefault(), e2.stopPropagation(), S$2(f2)) : S$2(l2.value);
    }, true);
  }
  function N$4(t2, n2) {
    for (let r2 of t2)
      if (r2.contains(n2))
        return true;
    return false;
  }
  function m$2(t2) {
    let e2 = shallowRef(t2.getSnapshot());
    return onUnmounted(t2.subscribe(() => {
      e2.value = t2.getSnapshot();
    })), e2;
  }
  function a$1(o2, r2) {
    let t2 = o2(), n2 = /* @__PURE__ */ new Set();
    return { getSnapshot() {
      return t2;
    }, subscribe(e2) {
      return n2.add(e2), () => n2.delete(e2);
    }, dispatch(e2, ...s2) {
      let i2 = r2[e2].call(t2, ...s2);
      i2 && (t2 = i2, n2.forEach((c2) => c2()));
    } };
  }
  function c() {
    let o2;
    return { before({ doc: e2 }) {
      var l2;
      let n2 = e2.documentElement;
      o2 = ((l2 = e2.defaultView) != null ? l2 : window).innerWidth - n2.clientWidth;
    }, after({ doc: e2, d: n2 }) {
      let t2 = e2.documentElement, l2 = t2.clientWidth - t2.offsetWidth, r2 = o2 - l2;
      n2.style(t2, "paddingRight", `${r2}px`);
    } };
  }
  function w$1() {
    return t$6() ? { before({ doc: r2, d: n2, meta: c2 }) {
      function o$12(a2) {
        return c2.containers.flatMap((l2) => l2()).some((l2) => l2.contains(a2));
      }
      n2.microTask(() => {
        var s2;
        if (window.getComputedStyle(r2.documentElement).scrollBehavior !== "auto") {
          let t2 = o();
          t2.style(r2.documentElement, "scrollBehavior", "auto"), n2.add(() => n2.microTask(() => t2.dispose()));
        }
        let a2 = (s2 = window.scrollY) != null ? s2 : window.pageYOffset, l2 = null;
        n2.addEventListener(r2, "click", (t2) => {
          if (t2.target instanceof HTMLElement)
            try {
              let e2 = t2.target.closest("a");
              if (!e2)
                return;
              let { hash: f2 } = new URL(e2.href), i2 = r2.querySelector(f2);
              i2 && !o$12(i2) && (l2 = i2);
            } catch {
            }
        }, true), n2.addEventListener(r2, "touchstart", (t2) => {
          if (t2.target instanceof HTMLElement)
            if (o$12(t2.target)) {
              let e2 = t2.target;
              for (; e2.parentElement && o$12(e2.parentElement); )
                e2 = e2.parentElement;
              n2.style(e2, "overscrollBehavior", "contain");
            } else
              n2.style(t2.target, "touchAction", "none");
        }), n2.addEventListener(r2, "touchmove", (t2) => {
          if (t2.target instanceof HTMLElement)
            if (o$12(t2.target)) {
              let e2 = t2.target;
              for (; e2.parentElement && e2.dataset.headlessuiPortal !== "" && !(e2.scrollHeight > e2.clientHeight || e2.scrollWidth > e2.clientWidth); )
                e2 = e2.parentElement;
              e2.dataset.headlessuiPortal === "" && t2.preventDefault();
            } else
              t2.preventDefault();
        }, { passive: false }), n2.add(() => {
          var e2;
          let t2 = (e2 = window.scrollY) != null ? e2 : window.pageYOffset;
          a2 !== t2 && window.scrollTo(0, a2), l2 && l2.isConnected && (l2.scrollIntoView({ block: "nearest" }), l2 = null);
        });
      });
    } } : {};
  }
  function l() {
    return { before({ doc: e2, d: o2 }) {
      o2.style(e2.documentElement, "overflow", "hidden");
    } };
  }
  function m$1(e2) {
    let n2 = {};
    for (let t2 of e2)
      Object.assign(n2, t2(n2));
    return n2;
  }
  let a = a$1(() => /* @__PURE__ */ new Map(), { PUSH(e2, n2) {
    var o$12;
    let t2 = (o$12 = this.get(e2)) != null ? o$12 : { doc: e2, count: 0, d: o(), meta: /* @__PURE__ */ new Set() };
    return t2.count++, t2.meta.add(n2), this.set(e2, t2), this;
  }, POP(e2, n2) {
    let t2 = this.get(e2);
    return t2 && (t2.count--, t2.meta.delete(n2)), this;
  }, SCROLL_PREVENT({ doc: e2, d: n2, meta: t2 }) {
    let o2 = { doc: e2, d: n2, meta: m$1(t2) }, c$12 = [w$1(), c(), l()];
    c$12.forEach(({ before: r2 }) => r2 == null ? void 0 : r2(o2)), c$12.forEach(({ after: r2 }) => r2 == null ? void 0 : r2(o2));
  }, SCROLL_ALLOW({ d: e2 }) {
    e2.dispose();
  }, TEARDOWN({ doc: e2 }) {
    this.delete(e2);
  } });
  a.subscribe(() => {
    let e2 = a.getSnapshot(), n2 = /* @__PURE__ */ new Map();
    for (let [t2] of e2)
      n2.set(t2, t2.documentElement.style.overflow);
    for (let t2 of e2.values()) {
      let o2 = n2.get(t2.doc) === "hidden", c2 = t2.count !== 0;
      (c2 && !o2 || !c2 && o2) && a.dispatch(t2.count > 0 ? "SCROLL_PREVENT" : "SCROLL_ALLOW", t2), t2.count === 0 && a.dispatch("TEARDOWN", t2);
    }
  });
  function d$1(t2, a$12, n2) {
    let i2 = m$2(a), l2 = computed(() => {
      let e2 = t2.value ? i2.value.get(t2.value) : void 0;
      return e2 ? e2.count > 0 : false;
    });
    return watch([t2, a$12], ([e2, m2], [r2], o2) => {
      if (!e2 || !m2)
        return;
      a.dispatch("PUSH", e2, n2);
      let f2 = false;
      o2(() => {
        f2 || (a.dispatch("POP", r2 != null ? r2 : e2, n2), f2 = true);
      });
    }, { immediate: true }), l2;
  }
  let i$1 = /* @__PURE__ */ new Map(), t$1 = /* @__PURE__ */ new Map();
  function E$1(d2, f2 = ref(true)) {
    watchEffect((o2) => {
      var a2;
      if (!f2.value)
        return;
      let e2 = o$2(d2);
      if (!e2)
        return;
      o2(function() {
        var u2;
        if (!e2)
          return;
        let r2 = (u2 = t$1.get(e2)) != null ? u2 : 1;
        if (r2 === 1 ? t$1.delete(e2) : t$1.set(e2, r2 - 1), r2 !== 1)
          return;
        let n2 = i$1.get(e2);
        n2 && (n2["aria-hidden"] === null ? e2.removeAttribute("aria-hidden") : e2.setAttribute("aria-hidden", n2["aria-hidden"]), e2.inert = n2.inert, i$1.delete(e2));
      });
      let l2 = (a2 = t$1.get(e2)) != null ? a2 : 0;
      t$1.set(e2, l2 + 1), l2 === 0 && (i$1.set(e2, { "aria-hidden": e2.getAttribute("aria-hidden"), inert: e2.inert }), e2.setAttribute("aria-hidden", "true"), e2.inert = true);
    });
  }
  function N$3({ defaultContainers: o2 = [], portals: i2, mainTreeNodeRef: H2 } = {}) {
    let t2 = ref(null), r2 = i$4(t2);
    function u2() {
      var l2, f2, a2;
      let n2 = [];
      for (let e2 of o2)
        e2 !== null && (e2 instanceof HTMLElement ? n2.push(e2) : "value" in e2 && e2.value instanceof HTMLElement && n2.push(e2.value));
      if (i2 != null && i2.value)
        for (let e2 of i2.value)
          n2.push(e2);
      for (let e2 of (l2 = r2 == null ? void 0 : r2.querySelectorAll("html > *, body > *")) != null ? l2 : [])
        e2 !== document.body && e2 !== document.head && e2 instanceof HTMLElement && e2.id !== "headlessui-portal-root" && (e2.contains(o$2(t2)) || e2.contains((a2 = (f2 = o$2(t2)) == null ? void 0 : f2.getRootNode()) == null ? void 0 : a2.host) || n2.some((M) => e2.contains(M)) || n2.push(e2));
      return n2;
    }
    return { resolveContainers: u2, contains(n2) {
      return u2().some((l2) => l2.contains(n2));
    }, mainTreeNodeRef: t2, MainTreeNode() {
      return H2 != null ? null : h$1(f, { features: s$2.Hidden, ref: t2 });
    } };
  }
  let e = Symbol("ForcePortalRootContext");
  function s$1() {
    return inject(e, false);
  }
  let u$2 = /* @__PURE__ */ defineComponent({ name: "ForcePortalRoot", props: { as: { type: [Object, String], default: "template" }, force: { type: Boolean, default: false } }, setup(o2, { slots: t2, attrs: r2 }) {
    return provide(e, o2.force), () => {
      let { force: f2, ...n2 } = o2;
      return A$3({ theirProps: n2, ourProps: {}, slot: {}, slots: t2, attrs: r2, name: "ForcePortalRoot" });
    };
  } });
  let u$1 = Symbol("StackContext");
  var s = ((e2) => (e2[e2.Add = 0] = "Add", e2[e2.Remove = 1] = "Remove", e2))(s || {});
  function y() {
    return inject(u$1, () => {
    });
  }
  function R$1({ type: o2, enabled: r2, element: e2, onUpdate: i2 }) {
    let a2 = y();
    function t2(...n2) {
      i2 == null || i2(...n2), a2(...n2);
    }
    onMounted(() => {
      watch(r2, (n2, d2) => {
        n2 ? t2(0, o2, e2) : d2 === true && t2(1, o2, e2);
      }, { immediate: true, flush: "sync" });
    }), onUnmounted(() => {
      r2.value && t2(1, o2, e2);
    }), provide(u$1, t2);
  }
  let u = Symbol("DescriptionContext");
  function w() {
    let t2 = inject(u, null);
    if (t2 === null)
      throw new Error("Missing parent");
    return t2;
  }
  function k$1({ slot: t2 = ref({}), name: o2 = "Description", props: s2 = {} } = {}) {
    let e2 = ref([]);
    function r2(n2) {
      return e2.value.push(n2), () => {
        let i2 = e2.value.indexOf(n2);
        i2 !== -1 && e2.value.splice(i2, 1);
      };
    }
    return provide(u, { register: r2, slot: t2, name: o2, props: s2 }), computed(() => e2.value.length > 0 ? e2.value.join(" ") : void 0);
  }
  let K = /* @__PURE__ */ defineComponent({ name: "Description", props: { as: { type: [Object, String], default: "p" }, id: { type: String, default: null } }, setup(t2, { attrs: o2, slots: s2 }) {
    var n2;
    let e2 = (n2 = t2.id) != null ? n2 : `headlessui-description-${I$1()}`, r2 = w();
    return onMounted(() => onUnmounted(r2.register(e2))), () => {
      let { name: i2 = "Description", slot: l2 = ref({}), props: d2 = {} } = r2, { ...c2 } = t2, f2 = { ...Object.entries(d2).reduce((a2, [g, m2]) => Object.assign(a2, { [g]: unref(m2) }), {}), id: e2 };
      return A$3({ ourProps: f2, theirProps: c2, slot: l2.value, attrs: o2, slots: s2, name: i2 });
    };
  } });
  function x(r2) {
    let e2 = i$4(r2);
    if (!e2) {
      if (r2 === null)
        return null;
      throw new Error(`[Headless UI]: Cannot find ownerDocument for contextElement: ${r2}`);
    }
    let u2 = e2.getElementById("headlessui-portal-root");
    if (u2)
      return u2;
    let t2 = e2.createElement("div");
    return t2.setAttribute("id", "headlessui-portal-root"), e2.body.appendChild(t2);
  }
  let _ = /* @__PURE__ */ defineComponent({ name: "Portal", props: { as: { type: [Object, String], default: "div" } }, setup(r2, { slots: e2, attrs: u2 }) {
    let t2 = ref(null), i2 = computed(() => i$4(t2)), l2 = s$1(), n2 = inject(C$2, null), o2 = ref(l2 === true || n2 == null ? x(t2.value) : n2.resolveTarget()), d2 = ref(false);
    onMounted(() => {
      d2.value = true;
    }), watchEffect(() => {
      l2 || n2 != null && (o2.value = n2.resolveTarget());
    });
    let c2 = inject(m, null), v2 = false, H2 = getCurrentInstance();
    return watch(t2, () => {
      if (v2 || !c2)
        return;
      let a2 = o$2(t2);
      a2 && (onUnmounted(c2.register(a2), H2), v2 = true);
    }), onUnmounted(() => {
      var g, P2;
      let a2 = (g = i2.value) == null ? void 0 : g.getElementById("headlessui-portal-root");
      a2 && o2.value === a2 && o2.value.children.length <= 0 && ((P2 = o2.value.parentElement) == null || P2.removeChild(o2.value));
    }), () => {
      if (!d2.value || o2.value === null)
        return null;
      let a2 = { ref: t2, "data-headlessui-portal": "" };
      return h$1(Teleport, { to: o2.value }, A$3({ ourProps: a2, theirProps: r2, slot: {}, attrs: u2, slots: e2, name: "Portal" }));
    };
  } }), m = Symbol("PortalParentContext");
  function A$1() {
    let r2 = inject(m, null), e2 = ref([]);
    function u2(l2) {
      return e2.value.push(l2), r2 && r2.register(l2), () => t2(l2);
    }
    function t2(l2) {
      let n2 = e2.value.indexOf(l2);
      n2 !== -1 && e2.value.splice(n2, 1), r2 && r2.unregister(l2);
    }
    let i2 = { register: u2, unregister: t2, portals: e2 };
    return [e2, /* @__PURE__ */ defineComponent({ name: "PortalWrapper", setup(l2, { slots: n2 }) {
      return provide(m, i2), () => {
        var o2;
        return (o2 = n2.default) == null ? void 0 : o2.call(n2);
      };
    } })];
  }
  let C$2 = Symbol("PortalGroupContext"), N$2 = /* @__PURE__ */ defineComponent({ name: "PortalGroup", props: { as: { type: [Object, String], default: "template" }, target: { type: Object, default: null } }, setup(r2, { attrs: e2, slots: u2 }) {
    let t2 = reactive({ resolveTarget() {
      return r2.target;
    } });
    return provide(C$2, t2), () => {
      let { target: i2, ...l2 } = r2;
      return A$3({ theirProps: l2, ourProps: {}, slot: {}, attrs: e2, slots: u2, name: "PortalGroup" });
    };
  } });
  var Te$1 = ((l2) => (l2[l2.Open = 0] = "Open", l2[l2.Closed = 1] = "Closed", l2))(Te$1 || {});
  let H = Symbol("DialogContext");
  function T$1(e2) {
    let i2 = inject(H, null);
    if (i2 === null) {
      let l2 = new Error(`<${e2} /> is missing a parent <Dialog /> component.`);
      throw Error.captureStackTrace && Error.captureStackTrace(l2, T$1), l2;
    }
    return i2;
  }
  let A = "DC8F892D-2EBD-447C-A4C8-A03058436FF4", We$1 = /* @__PURE__ */ defineComponent({ name: "Dialog", inheritAttrs: false, props: { as: { type: [Object, String], default: "div" }, static: { type: Boolean, default: false }, unmount: { type: Boolean, default: true }, open: { type: [Boolean, String], default: A }, initialFocus: { type: Object, default: null }, id: { type: String, default: null }, role: { type: String, default: "dialog" } }, emits: { close: (e2) => true }, setup(e2, { emit: i2, attrs: l2, slots: d2, expose: s$12 }) {
    var _$1, q2;
    let n2 = (_$1 = e2.id) != null ? _$1 : `headlessui-dialog-${I$1()}`, u2 = ref(false);
    onMounted(() => {
      u2.value = true;
    });
    let r2 = false, g = computed(() => e2.role === "dialog" || e2.role === "alertdialog" ? e2.role : (r2 || (r2 = true, console.warn(`Invalid role [${g}] passed to <Dialog />. Only \`dialog\` and and \`alertdialog\` are supported. Using \`dialog\` instead.`)), "dialog")), D = ref(0), S2 = l$1(), R2 = computed(() => e2.open === A && S2 !== null ? (S2.value & i$2.Open) === i$2.Open : e2.open), m2 = ref(null), E2 = computed(() => i$4(m2));
    if (s$12({ el: m2, $el: m2 }), !(e2.open !== A || S2 !== null))
      throw new Error("You forgot to provide an `open` prop to the `Dialog`.");
    if (typeof R2.value != "boolean")
      throw new Error(`You provided an \`open\` prop to the \`Dialog\`, but the value is not a boolean. Received: ${R2.value === A ? void 0 : e2.open}`);
    let c2 = computed(() => u2.value && R2.value ? 0 : 1), k2 = computed(() => c2.value === 0), w2 = computed(() => D.value > 1), N2 = inject(H, null) !== null, [Q2, X] = A$1(), { resolveContainers: B2, mainTreeNodeRef: K2, MainTreeNode: Z } = N$3({ portals: Q2, defaultContainers: [computed(() => {
      var t2;
      return (t2 = h2.panelRef.value) != null ? t2 : m2.value;
    })] }), ee = computed(() => w2.value ? "parent" : "leaf"), U2 = computed(() => S2 !== null ? (S2.value & i$2.Closing) === i$2.Closing : false), te2 = computed(() => N2 || U2.value ? false : k2.value), le2 = computed(() => {
      var t2, a2, p2;
      return (p2 = Array.from((a2 = (t2 = E2.value) == null ? void 0 : t2.querySelectorAll("body > *")) != null ? a2 : []).find((f2) => f2.id === "headlessui-portal-root" ? false : f2.contains(o$2(K2)) && f2 instanceof HTMLElement)) != null ? p2 : null;
    });
    E$1(le2, te2);
    let ae = computed(() => w2.value ? true : k2.value), oe = computed(() => {
      var t2, a2, p2;
      return (p2 = Array.from((a2 = (t2 = E2.value) == null ? void 0 : t2.querySelectorAll("[data-headlessui-portal]")) != null ? a2 : []).find((f2) => f2.contains(o$2(K2)) && f2 instanceof HTMLElement)) != null ? p2 : null;
    });
    E$1(oe, ae), R$1({ type: "Dialog", enabled: computed(() => c2.value === 0), element: m2, onUpdate: (t2, a2) => {
      if (a2 === "Dialog")
        return u$4(t2, { [s.Add]: () => D.value += 1, [s.Remove]: () => D.value -= 1 });
    } });
    let re = k$1({ name: "DialogDescription", slot: computed(() => ({ open: R2.value })) }), M = ref(null), h2 = { titleId: M, panelRef: ref(null), dialogState: c2, setTitleId(t2) {
      M.value !== t2 && (M.value = t2);
    }, close() {
      i2("close", false);
    } };
    provide(H, h2);
    let ne = computed(() => !(!k2.value || w2.value));
    w$2(B2, (t2, a2) => {
      h2.close(), nextTick(() => a2 == null ? void 0 : a2.focus());
    }, ne);
    let ie2 = computed(() => !(w2.value || c2.value !== 0));
    E$2((q2 = E2.value) == null ? void 0 : q2.defaultView, "keydown", (t2) => {
      ie2.value && (t2.defaultPrevented || t2.key === o$1.Escape && (t2.preventDefault(), t2.stopPropagation(), h2.close()));
    });
    let ue$1 = computed(() => !(U2.value || c2.value !== 0 || N2));
    return d$1(E2, ue$1, (t2) => {
      var a2;
      return { containers: [...(a2 = t2.containers) != null ? a2 : [], B2] };
    }), watchEffect((t2) => {
      if (c2.value !== 0)
        return;
      let a2 = o$2(m2);
      if (!a2)
        return;
      let p2 = new ResizeObserver((f2) => {
        for (let L of f2) {
          let x2 = L.target.getBoundingClientRect();
          x2.x === 0 && x2.y === 0 && x2.width === 0 && x2.height === 0 && h2.close();
        }
      });
      p2.observe(a2), t2(() => p2.disconnect());
    }), () => {
      let { open: t2, initialFocus: a2, ...p2 } = e2, f2 = { ...l2, ref: m2, id: n2, role: g.value, "aria-modal": c2.value === 0 ? true : void 0, "aria-labelledby": M.value, "aria-describedby": re.value }, L = { open: c2.value === 0 };
      return h$1(u$2, { force: true }, () => [h$1(_, () => h$1(N$2, { target: m2.value }, () => h$1(u$2, { force: false }, () => h$1(ue, { initialFocus: a2, containers: B2, features: k2.value ? u$4(ee.value, { parent: ue.features.RestoreFocus, leaf: ue.features.All & ~ue.features.FocusLock }) : ue.features.None }, () => h$1(X, {}, () => A$3({ ourProps: f2, theirProps: { ...p2, ...l2 }, slot: L, attrs: l2, slots: d2, visible: c2.value === 0, features: N$5.RenderStrategy | N$5.Static, name: "Dialog" })))))), h$1(Z)]);
    };
  } }), Ge$1 = /* @__PURE__ */ defineComponent({ name: "DialogPanel", props: { as: { type: [Object, String], default: "div" }, id: { type: String, default: null } }, setup(e2, { attrs: i2, slots: l2, expose: d2 }) {
    var r2;
    let s2 = (r2 = e2.id) != null ? r2 : `headlessui-dialog-panel-${I$1()}`, n2 = T$1("DialogPanel");
    d2({ el: n2.panelRef, $el: n2.panelRef });
    function u2(g) {
      g.stopPropagation();
    }
    return () => {
      let { ...g } = e2, D = { id: s2, ref: n2.panelRef, onClick: u2 };
      return A$3({ ourProps: D, theirProps: g, slot: { open: n2.dialogState.value === 0 }, attrs: i2, slots: l2, name: "DialogPanel" });
    };
  } }), Ve$1 = /* @__PURE__ */ defineComponent({ name: "DialogTitle", props: { as: { type: [Object, String], default: "h2" }, id: { type: String, default: null } }, setup(e2, { attrs: i2, slots: l2 }) {
    var n2;
    let d2 = (n2 = e2.id) != null ? n2 : `headlessui-dialog-title-${I$1()}`, s2 = T$1("DialogTitle");
    return onMounted(() => {
      s2.setTitleId(d2), onUnmounted(() => s2.setTitleId(null));
    }), () => {
      let { ...u2 } = e2;
      return A$3({ ourProps: { id: d2 }, theirProps: u2, slot: { open: s2.dialogState.value === 0 }, attrs: i2, slots: l2, name: "DialogTitle" });
    };
  } }), Je = K;
  var $ = ((o2) => (o2[o2.Open = 0] = "Open", o2[o2.Closed = 1] = "Closed", o2))($ || {});
  let T = Symbol("DisclosureContext");
  function O(t2) {
    let r2 = inject(T, null);
    if (r2 === null) {
      let o2 = new Error(`<${t2} /> is missing a parent <Disclosure /> component.`);
      throw Error.captureStackTrace && Error.captureStackTrace(o2, O), o2;
    }
    return r2;
  }
  let k = Symbol("DisclosurePanelContext");
  function U$1() {
    return inject(k, null);
  }
  let N$1 = /* @__PURE__ */ defineComponent({ name: "Disclosure", props: { as: { type: [Object, String], default: "template" }, defaultOpen: { type: [Boolean], default: false } }, setup(t2, { slots: r2, attrs: o2 }) {
    let s2 = ref(t2.defaultOpen ? 0 : 1), e2 = ref(null), i2 = ref(null), n2 = { buttonId: ref(`headlessui-disclosure-button-${I$1()}`), panelId: ref(`headlessui-disclosure-panel-${I$1()}`), disclosureState: s2, panel: e2, button: i2, toggleDisclosure() {
      s2.value = u$4(s2.value, { [0]: 1, [1]: 0 });
    }, closeDisclosure() {
      s2.value !== 1 && (s2.value = 1);
    }, close(l2) {
      n2.closeDisclosure();
      let a2 = (() => l2 ? l2 instanceof HTMLElement ? l2 : l2.value instanceof HTMLElement ? o$2(l2) : o$2(n2.button) : o$2(n2.button))();
      a2 == null || a2.focus();
    } };
    return provide(T, n2), t$5(computed(() => u$4(s2.value, { [0]: i$2.Open, [1]: i$2.Closed }))), () => {
      let { defaultOpen: l2, ...a2 } = t2, c2 = { open: s2.value === 0, close: n2.close };
      return A$3({ theirProps: a2, ourProps: {}, slot: c2, slots: r2, attrs: o2, name: "Disclosure" });
    };
  } }), Q = /* @__PURE__ */ defineComponent({ name: "DisclosureButton", props: { as: { type: [Object, String], default: "button" }, disabled: { type: [Boolean], default: false }, id: { type: String, default: null } }, setup(t2, { attrs: r2, slots: o2, expose: s2 }) {
    let e2 = O("DisclosureButton"), i2 = U$1(), n2 = computed(() => i2 === null ? false : i2.value === e2.panelId.value);
    onMounted(() => {
      n2.value || t2.id !== null && (e2.buttonId.value = t2.id);
    }), onUnmounted(() => {
      n2.value || (e2.buttonId.value = null);
    });
    let l2 = ref(null);
    s2({ el: l2, $el: l2 }), n2.value || watchEffect(() => {
      e2.button.value = l2.value;
    });
    let a2 = s$3(computed(() => ({ as: t2.as, type: r2.type })), l2);
    function c2() {
      var u2;
      t2.disabled || (n2.value ? (e2.toggleDisclosure(), (u2 = o$2(e2.button)) == null || u2.focus()) : e2.toggleDisclosure());
    }
    function D(u2) {
      var S2;
      if (!t2.disabled)
        if (n2.value)
          switch (u2.key) {
            case o$1.Space:
            case o$1.Enter:
              u2.preventDefault(), u2.stopPropagation(), e2.toggleDisclosure(), (S2 = o$2(e2.button)) == null || S2.focus();
              break;
          }
        else
          switch (u2.key) {
            case o$1.Space:
            case o$1.Enter:
              u2.preventDefault(), u2.stopPropagation(), e2.toggleDisclosure();
              break;
          }
    }
    function v2(u2) {
      switch (u2.key) {
        case o$1.Space:
          u2.preventDefault();
          break;
      }
    }
    return () => {
      var C2;
      let u2 = { open: e2.disclosureState.value === 0 }, { id: S2, ...K2 } = t2, M = n2.value ? { ref: l2, type: a2.value, onClick: c2, onKeydown: D } : { id: (C2 = e2.buttonId.value) != null ? C2 : S2, ref: l2, type: a2.value, "aria-expanded": e2.disclosureState.value === 0, "aria-controls": e2.disclosureState.value === 0 || o$2(e2.panel) ? e2.panelId.value : void 0, disabled: t2.disabled ? true : void 0, onClick: c2, onKeydown: D, onKeyup: v2 };
      return A$3({ ourProps: M, theirProps: K2, slot: u2, attrs: r2, slots: o2, name: "DisclosureButton" });
    };
  } }), V$1 = /* @__PURE__ */ defineComponent({ name: "DisclosurePanel", props: { as: { type: [Object, String], default: "div" }, static: { type: Boolean, default: false }, unmount: { type: Boolean, default: true }, id: { type: String, default: null } }, setup(t2, { attrs: r2, slots: o2, expose: s2 }) {
    let e2 = O("DisclosurePanel");
    onMounted(() => {
      t2.id !== null && (e2.panelId.value = t2.id);
    }), onUnmounted(() => {
      e2.panelId.value = null;
    }), s2({ el: e2.panel, $el: e2.panel }), provide(k, e2.panelId);
    let i2 = l$1(), n2 = computed(() => i2 !== null ? (i2.value & i$2.Open) === i$2.Open : e2.disclosureState.value === 0);
    return () => {
      var v2;
      let l2 = { open: e2.disclosureState.value === 0, close: e2.close }, { id: a2, ...c2 } = t2, D = { id: (v2 = e2.panelId.value) != null ? v2 : a2, ref: e2.panel };
      return A$3({ ourProps: D, theirProps: c2, slot: l2, attrs: r2, slots: o2, features: N$5.RenderStrategy | N$5.Static, visible: n2.value, name: "DisclosurePanel" });
    };
  } });
  let d = /* @__PURE__ */ defineComponent({ props: { onFocus: { type: Function, required: true } }, setup(t2) {
    let n2 = ref(true);
    return () => n2.value ? h$1(f, { as: "button", type: "button", features: s$2.Focusable, onFocus(o2) {
      o2.preventDefault();
      let e2, a2 = 50;
      function r2() {
        var u2;
        if (a2-- <= 0) {
          e2 && cancelAnimationFrame(e2);
          return;
        }
        if ((u2 = t2.onFocus) != null && u2.call(t2)) {
          n2.value = false, cancelAnimationFrame(e2);
          return;
        }
        e2 = requestAnimationFrame(r2);
      }
      e2 = requestAnimationFrame(r2);
    } }) : null;
  } });
  var te = ((s2) => (s2[s2.Forwards = 0] = "Forwards", s2[s2.Backwards = 1] = "Backwards", s2))(te || {}), le = ((o2) => (o2[o2.Less = -1] = "Less", o2[o2.Equal = 0] = "Equal", o2[o2.Greater = 1] = "Greater", o2))(le || {});
  let U = Symbol("TabsContext");
  function C$1(a2) {
    let b2 = inject(U, null);
    if (b2 === null) {
      let s2 = new Error(`<${a2} /> is missing a parent <TabGroup /> component.`);
      throw Error.captureStackTrace && Error.captureStackTrace(s2, C$1), s2;
    }
    return b2;
  }
  let G = Symbol("TabsSSRContext"), pe = /* @__PURE__ */ defineComponent({ name: "TabGroup", emits: { change: (a2) => true }, props: { as: { type: [Object, String], default: "template" }, selectedIndex: { type: [Number], default: null }, defaultIndex: { type: [Number], default: 0 }, vertical: { type: [Boolean], default: false }, manual: { type: [Boolean], default: false } }, inheritAttrs: false, setup(a2, { slots: b2, attrs: s2, emit: o2 }) {
    var w2;
    let i2 = ref((w2 = a2.selectedIndex) != null ? w2 : a2.defaultIndex), l2 = ref([]), r2 = ref([]), x2 = computed(() => a2.selectedIndex !== null), P2 = computed(() => x2.value ? a2.selectedIndex : i2.value);
    function y2(t2) {
      var c2;
      let n2 = O$1(u2.tabs.value, o$2), d2 = O$1(u2.panels.value, o$2), e2 = n2.filter((I2) => {
        var p2;
        return !((p2 = o$2(I2)) != null && p2.hasAttribute("disabled"));
      });
      if (t2 < 0 || t2 > n2.length - 1) {
        let I2 = u$4(i2.value === null ? 0 : Math.sign(t2 - i2.value), { [-1]: () => 1, [0]: () => u$4(Math.sign(t2), { [-1]: () => 0, [0]: () => 0, [1]: () => 1 }), [1]: () => 0 }), p2 = u$4(I2, { [0]: () => n2.indexOf(e2[0]), [1]: () => n2.indexOf(e2[e2.length - 1]) });
        p2 !== -1 && (i2.value = p2), u2.tabs.value = n2, u2.panels.value = d2;
      } else {
        let I2 = n2.slice(0, t2), D = [...n2.slice(t2), ...I2].find((W2) => e2.includes(W2));
        if (!D)
          return;
        let O2 = (c2 = n2.indexOf(D)) != null ? c2 : u2.selectedIndex.value;
        O2 === -1 && (O2 = u2.selectedIndex.value), i2.value = O2, u2.tabs.value = n2, u2.panels.value = d2;
      }
    }
    let u2 = { selectedIndex: computed(() => {
      var t2, n2;
      return (n2 = (t2 = i2.value) != null ? t2 : a2.defaultIndex) != null ? n2 : null;
    }), orientation: computed(() => a2.vertical ? "vertical" : "horizontal"), activation: computed(() => a2.manual ? "manual" : "auto"), tabs: l2, panels: r2, setSelectedIndex(t2) {
      P2.value !== t2 && o2("change", t2), x2.value || y2(t2);
    }, registerTab(t2) {
      var e2;
      if (l2.value.includes(t2))
        return;
      let n2 = l2.value[i2.value];
      l2.value.push(t2), l2.value = O$1(l2.value, o$2);
      let d2 = (e2 = l2.value.indexOf(n2)) != null ? e2 : i2.value;
      d2 !== -1 && (i2.value = d2);
    }, unregisterTab(t2) {
      let n2 = l2.value.indexOf(t2);
      n2 !== -1 && l2.value.splice(n2, 1);
    }, registerPanel(t2) {
      r2.value.includes(t2) || (r2.value.push(t2), r2.value = O$1(r2.value, o$2));
    }, unregisterPanel(t2) {
      let n2 = r2.value.indexOf(t2);
      n2 !== -1 && r2.value.splice(n2, 1);
    } };
    provide(U, u2);
    let T2 = ref({ tabs: [], panels: [] }), m2 = ref(false);
    onMounted(() => {
      m2.value = true;
    }), provide(G, computed(() => m2.value ? null : T2.value));
    let R2 = computed(() => a2.selectedIndex);
    return onMounted(() => {
      watch([R2], () => {
        var t2;
        return y2((t2 = a2.selectedIndex) != null ? t2 : a2.defaultIndex);
      }, { immediate: true });
    }), watchEffect(() => {
      if (!x2.value || P2.value == null || u2.tabs.value.length <= 0)
        return;
      let t2 = O$1(u2.tabs.value, o$2);
      t2.some((d2, e2) => o$2(u2.tabs.value[e2]) !== o$2(d2)) && u2.setSelectedIndex(t2.findIndex((d2) => o$2(d2) === o$2(u2.tabs.value[P2.value])));
    }), () => {
      let t2 = { selectedIndex: i2.value };
      return h$1(Fragment, [l2.value.length <= 0 && h$1(d, { onFocus: () => {
        for (let n2 of l2.value) {
          let d2 = o$2(n2);
          if ((d2 == null ? void 0 : d2.tabIndex) === 0)
            return d2.focus(), true;
        }
        return false;
      } }), A$3({ theirProps: { ...s2, ...T$2(a2, ["selectedIndex", "defaultIndex", "manual", "vertical", "onChange"]) }, ourProps: {}, slot: t2, slots: b2, attrs: s2, name: "TabGroup" })]);
    };
  } }), me = /* @__PURE__ */ defineComponent({ name: "TabList", props: { as: { type: [Object, String], default: "div" } }, setup(a2, { attrs: b2, slots: s2 }) {
    let o2 = C$1("TabList");
    return () => {
      let i2 = { selectedIndex: o2.selectedIndex.value }, l2 = { role: "tablist", "aria-orientation": o2.orientation.value };
      return A$3({ ourProps: l2, theirProps: a2, slot: i2, attrs: b2, slots: s2, name: "TabList" });
    };
  } }), xe = /* @__PURE__ */ defineComponent({ name: "Tab", props: { as: { type: [Object, String], default: "button" }, disabled: { type: [Boolean], default: false }, id: { type: String, default: null } }, setup(a2, { attrs: b2, slots: s2, expose: o2 }) {
    var d2;
    let i2 = (d2 = a2.id) != null ? d2 : `headlessui-tabs-tab-${I$1()}`, l2 = C$1("Tab"), r2 = ref(null);
    o2({ el: r2, $el: r2 }), onMounted(() => l2.registerTab(r2)), onUnmounted(() => l2.unregisterTab(r2));
    let x2 = inject(G), P$1 = computed(() => {
      if (x2.value) {
        let e2 = x2.value.tabs.indexOf(i2);
        return e2 === -1 ? x2.value.tabs.push(i2) - 1 : e2;
      }
      return -1;
    }), y2 = computed(() => {
      let e2 = l2.tabs.value.indexOf(r2);
      return e2 === -1 ? P$1.value : e2;
    }), u2 = computed(() => y2.value === l2.selectedIndex.value);
    function T2(e2) {
      var I2;
      let c2 = e2();
      if (c2 === T$3.Success && l2.activation.value === "auto") {
        let p2 = (I2 = i$4(r2)) == null ? void 0 : I2.activeElement, D = l2.tabs.value.findIndex((O2) => o$2(O2) === p2);
        D !== -1 && l2.setSelectedIndex(D);
      }
      return c2;
    }
    function m2(e2) {
      let c2 = l2.tabs.value.map((p2) => o$2(p2)).filter(Boolean);
      if (e2.key === o$1.Space || e2.key === o$1.Enter) {
        e2.preventDefault(), e2.stopPropagation(), l2.setSelectedIndex(y2.value);
        return;
      }
      switch (e2.key) {
        case o$1.Home:
        case o$1.PageUp:
          return e2.preventDefault(), e2.stopPropagation(), T2(() => P(c2, N$6.First));
        case o$1.End:
        case o$1.PageDown:
          return e2.preventDefault(), e2.stopPropagation(), T2(() => P(c2, N$6.Last));
      }
      if (T2(() => u$4(l2.orientation.value, { vertical() {
        return e2.key === o$1.ArrowUp ? P(c2, N$6.Previous | N$6.WrapAround) : e2.key === o$1.ArrowDown ? P(c2, N$6.Next | N$6.WrapAround) : T$3.Error;
      }, horizontal() {
        return e2.key === o$1.ArrowLeft ? P(c2, N$6.Previous | N$6.WrapAround) : e2.key === o$1.ArrowRight ? P(c2, N$6.Next | N$6.WrapAround) : T$3.Error;
      } })) === T$3.Success)
        return e2.preventDefault();
    }
    let R2 = ref(false);
    function w2() {
      var e2;
      R2.value || (R2.value = true, !a2.disabled && ((e2 = o$2(r2)) == null || e2.focus({ preventScroll: true }), l2.setSelectedIndex(y2.value), t$2(() => {
        R2.value = false;
      })));
    }
    function t2(e2) {
      e2.preventDefault();
    }
    let n2 = s$3(computed(() => ({ as: a2.as, type: b2.type })), r2);
    return () => {
      var p2;
      let e2 = { selected: u2.value }, { ...c2 } = a2, I2 = { ref: r2, onKeydown: m2, onMousedown: t2, onClick: w2, id: i2, role: "tab", type: n2.value, "aria-controls": (p2 = o$2(l2.panels.value[y2.value])) == null ? void 0 : p2.id, "aria-selected": u2.value, tabIndex: u2.value ? 0 : -1, disabled: a2.disabled ? true : void 0 };
      return A$3({ ourProps: I2, theirProps: c2, slot: e2, attrs: b2, slots: s2, name: "Tab" });
    };
  } }), Ie$1 = /* @__PURE__ */ defineComponent({ name: "TabPanels", props: { as: { type: [Object, String], default: "div" } }, setup(a2, { slots: b2, attrs: s2 }) {
    let o2 = C$1("TabPanels");
    return () => {
      let i2 = { selectedIndex: o2.selectedIndex.value };
      return A$3({ theirProps: a2, ourProps: {}, slot: i2, attrs: s2, slots: b2, name: "TabPanels" });
    };
  } }), ye = /* @__PURE__ */ defineComponent({ name: "TabPanel", props: { as: { type: [Object, String], default: "div" }, static: { type: Boolean, default: false }, unmount: { type: Boolean, default: true }, id: { type: String, default: null }, tabIndex: { type: Number, default: 0 } }, setup(a2, { attrs: b2, slots: s2, expose: o2 }) {
    var T2;
    let i2 = (T2 = a2.id) != null ? T2 : `headlessui-tabs-panel-${I$1()}`, l2 = C$1("TabPanel"), r2 = ref(null);
    o2({ el: r2, $el: r2 }), onMounted(() => l2.registerPanel(r2)), onUnmounted(() => l2.unregisterPanel(r2));
    let x2 = inject(G), P2 = computed(() => {
      if (x2.value) {
        let m2 = x2.value.panels.indexOf(i2);
        return m2 === -1 ? x2.value.panels.push(i2) - 1 : m2;
      }
      return -1;
    }), y2 = computed(() => {
      let m2 = l2.panels.value.indexOf(r2);
      return m2 === -1 ? P2.value : m2;
    }), u2 = computed(() => y2.value === l2.selectedIndex.value);
    return () => {
      var n2;
      let m2 = { selected: u2.value }, { tabIndex: R2, ...w2 } = a2, t2 = { ref: r2, id: i2, role: "tabpanel", "aria-labelledby": (n2 = o$2(l2.tabs.value[y2.value])) == null ? void 0 : n2.id, tabIndex: u2.value ? R2 : -1 };
      return !u2.value && a2.unmount && !a2.static ? h$1(f, { as: "span", "aria-hidden": true, ...t2 }) : A$3({ ourProps: t2, theirProps: w2, slot: m2, attrs: b2, slots: s2, features: N$5.Static | N$5.RenderStrategy, visible: u2.value, name: "TabPanel" });
    };
  } });
  function tryOnScopeDispose(fn) {
    if (getCurrentScope()) {
      onScopeDispose(fn);
      return true;
    }
    return false;
  }
  function toValue$1(r2) {
    return typeof r2 === "function" ? r2() : unref(r2);
  }
  const isClient = typeof window !== "undefined" && typeof document !== "undefined";
  typeof WorkerGlobalScope !== "undefined" && globalThis instanceof WorkerGlobalScope;
  const toString$1 = Object.prototype.toString;
  const isObject$1 = (val) => toString$1.call(val) === "[object Object]";
  const noop$1 = () => {
  };
  function whenever(source, cb, options) {
    const stop2 = watch(
      source,
      (v2, ov, onInvalidate) => {
        if (v2) {
          if (options == null ? void 0 : options.once)
            nextTick(() => stop2());
          cb(v2, ov, onInvalidate);
        }
      },
      {
        ...options,
        once: false
      }
    );
    return stop2;
  }
  function unrefElement(elRef) {
    var _a2;
    const plain = toValue$1(elRef);
    return (_a2 = plain == null ? void 0 : plain.$el) != null ? _a2 : plain;
  }
  const defaultWindow = isClient ? window : void 0;
  function useEventListener(...args) {
    let target;
    let events;
    let listeners;
    let options;
    if (typeof args[0] === "string" || Array.isArray(args[0])) {
      [events, listeners, options] = args;
      target = defaultWindow;
    } else {
      [target, events, listeners, options] = args;
    }
    if (!target)
      return noop$1;
    if (!Array.isArray(events))
      events = [events];
    if (!Array.isArray(listeners))
      listeners = [listeners];
    const cleanups = [];
    const cleanup = () => {
      cleanups.forEach((fn) => fn());
      cleanups.length = 0;
    };
    const register = (el, event, listener, options2) => {
      el.addEventListener(event, listener, options2);
      return () => el.removeEventListener(event, listener, options2);
    };
    const stopWatch = watch(
      () => [unrefElement(target), toValue$1(options)],
      ([el, options2]) => {
        cleanup();
        if (!el)
          return;
        const optionsClone = isObject$1(options2) ? { ...options2 } : options2;
        cleanups.push(
          ...events.flatMap((event) => {
            return listeners.map((listener) => register(el, event, listener, optionsClone));
          })
        );
      },
      { immediate: true, flush: "post" }
    );
    const stop2 = () => {
      stopWatch();
      cleanup();
    };
    tryOnScopeDispose(stop2);
    return stop2;
  }
  function useMounted() {
    const isMounted = ref(false);
    const instance = getCurrentInstance();
    if (instance) {
      onMounted(() => {
        isMounted.value = true;
      }, instance);
    }
    return isMounted;
  }
  function useSupported(callback) {
    const isMounted = useMounted();
    return computed(() => {
      isMounted.value;
      return Boolean(callback());
    });
  }
  function useMediaQuery(query, options = {}) {
    const { window: window2 = defaultWindow } = options;
    const isSupported2 = useSupported(() => window2 && "matchMedia" in window2 && typeof window2.matchMedia === "function");
    let mediaQuery;
    const matches2 = ref(false);
    const handler = (event) => {
      matches2.value = event.matches;
    };
    const cleanup = () => {
      if (!mediaQuery)
        return;
      if ("removeEventListener" in mediaQuery)
        mediaQuery.removeEventListener("change", handler);
      else
        mediaQuery.removeListener(handler);
    };
    const stopWatch = watchEffect(() => {
      if (!isSupported2.value)
        return;
      cleanup();
      mediaQuery = window2.matchMedia(toValue$1(query));
      if ("addEventListener" in mediaQuery)
        mediaQuery.addEventListener("change", handler);
      else
        mediaQuery.addListener(handler);
      matches2.value = mediaQuery.matches;
    });
    tryOnScopeDispose(() => {
      stopWatch();
      cleanup();
      mediaQuery = void 0;
    });
    return matches2;
  }
  const DefaultMagicKeysAliasMap = {
    ctrl: "control",
    command: "meta",
    cmd: "meta",
    option: "alt",
    up: "arrowup",
    down: "arrowdown",
    left: "arrowleft",
    right: "arrowright"
  };
  function useMagicKeys(options = {}) {
    const {
      reactive: useReactive = false,
      target = defaultWindow,
      aliasMap = DefaultMagicKeysAliasMap,
      passive = true,
      onEventFired = noop$1
    } = options;
    const current = reactive(/* @__PURE__ */ new Set());
    const obj = {
      toJSON() {
        return {};
      },
      current
    };
    const refs = useReactive ? reactive(obj) : obj;
    const metaDeps = /* @__PURE__ */ new Set();
    const usedKeys = /* @__PURE__ */ new Set();
    function setRefs(key, value) {
      if (key in refs) {
        if (useReactive)
          refs[key] = value;
        else
          refs[key].value = value;
      }
    }
    function reset2() {
      current.clear();
      for (const key of usedKeys)
        setRefs(key, false);
    }
    function updateRefs(e2, value) {
      var _a2, _b;
      const key = (_a2 = e2.key) == null ? void 0 : _a2.toLowerCase();
      const code2 = (_b = e2.code) == null ? void 0 : _b.toLowerCase();
      const values2 = [code2, key].filter(Boolean);
      if (key) {
        if (value)
          current.add(key);
        else
          current.delete(key);
      }
      for (const key2 of values2) {
        usedKeys.add(key2);
        setRefs(key2, value);
      }
      if (key === "meta" && !value) {
        metaDeps.forEach((key2) => {
          current.delete(key2);
          setRefs(key2, false);
        });
        metaDeps.clear();
      } else if (typeof e2.getModifierState === "function" && e2.getModifierState("Meta") && value) {
        [...current, ...values2].forEach((key2) => metaDeps.add(key2));
      }
    }
    useEventListener(target, "keydown", (e2) => {
      updateRefs(e2, true);
      return onEventFired(e2);
    }, { passive });
    useEventListener(target, "keyup", (e2) => {
      updateRefs(e2, false);
      return onEventFired(e2);
    }, { passive });
    useEventListener("blur", reset2, { passive: true });
    useEventListener("focus", reset2, { passive: true });
    const proxy = new Proxy(
      refs,
      {
        get(target2, prop, rec) {
          if (typeof prop !== "string")
            return Reflect.get(target2, prop, rec);
          prop = prop.toLowerCase();
          if (prop in aliasMap)
            prop = aliasMap[prop];
          if (!(prop in refs)) {
            if (/[+_-]/.test(prop)) {
              const keys = prop.split(/[+_-]/g).map((i2) => i2.trim());
              refs[prop] = computed(() => keys.every((key) => toValue$1(proxy[key])));
            } else {
              refs[prop] = ref(false);
            }
          }
          const r2 = Reflect.get(target2, prop, rec);
          return useReactive ? toValue$1(r2) : r2;
        }
      }
    );
    return proxy;
  }
  function bind(fn, thisArg) {
    return function wrap() {
      return fn.apply(thisArg, arguments);
    };
  }
  const { toString } = Object.prototype;
  const { getPrototypeOf } = Object;
  const kindOf = /* @__PURE__ */ ((cache2) => (thing) => {
    const str = toString.call(thing);
    return cache2[str] || (cache2[str] = str.slice(8, -1).toLowerCase());
  })(/* @__PURE__ */ Object.create(null));
  const kindOfTest = (type) => {
    type = type.toLowerCase();
    return (thing) => kindOf(thing) === type;
  };
  const typeOfTest = (type) => (thing) => typeof thing === type;
  const { isArray } = Array;
  const isUndefined = typeOfTest("undefined");
  function isBuffer(val) {
    return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && isFunction(val.constructor.isBuffer) && val.constructor.isBuffer(val);
  }
  const isArrayBuffer = kindOfTest("ArrayBuffer");
  function isArrayBufferView(val) {
    let result;
    if (typeof ArrayBuffer !== "undefined" && ArrayBuffer.isView) {
      result = ArrayBuffer.isView(val);
    } else {
      result = val && val.buffer && isArrayBuffer(val.buffer);
    }
    return result;
  }
  const isString = typeOfTest("string");
  const isFunction = typeOfTest("function");
  const isNumber$1 = typeOfTest("number");
  const isObject = (thing) => thing !== null && typeof thing === "object";
  const isBoolean = (thing) => thing === true || thing === false;
  const isPlainObject = (val) => {
    if (kindOf(val) !== "object") {
      return false;
    }
    const prototype2 = getPrototypeOf(val);
    return (prototype2 === null || prototype2 === Object.prototype || Object.getPrototypeOf(prototype2) === null) && !(Symbol.toStringTag in val) && !(Symbol.iterator in val);
  };
  const isDate = kindOfTest("Date");
  const isFile = kindOfTest("File");
  const isBlob = kindOfTest("Blob");
  const isFileList = kindOfTest("FileList");
  const isStream = (val) => isObject(val) && isFunction(val.pipe);
  const isFormData = (thing) => {
    let kind;
    return thing && (typeof FormData === "function" && thing instanceof FormData || isFunction(thing.append) && ((kind = kindOf(thing)) === "formdata" || // detect form-data instance
    kind === "object" && isFunction(thing.toString) && thing.toString() === "[object FormData]"));
  };
  const isURLSearchParams = kindOfTest("URLSearchParams");
  const trim = (str) => str.trim ? str.trim() : str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "");
  function forEach(obj, fn, { allOwnKeys = false } = {}) {
    if (obj === null || typeof obj === "undefined") {
      return;
    }
    let i2;
    let l2;
    if (typeof obj !== "object") {
      obj = [obj];
    }
    if (isArray(obj)) {
      for (i2 = 0, l2 = obj.length; i2 < l2; i2++) {
        fn.call(null, obj[i2], i2, obj);
      }
    } else {
      const keys = allOwnKeys ? Object.getOwnPropertyNames(obj) : Object.keys(obj);
      const len = keys.length;
      let key;
      for (i2 = 0; i2 < len; i2++) {
        key = keys[i2];
        fn.call(null, obj[key], key, obj);
      }
    }
  }
  function findKey(obj, key) {
    key = key.toLowerCase();
    const keys = Object.keys(obj);
    let i2 = keys.length;
    let _key;
    while (i2-- > 0) {
      _key = keys[i2];
      if (key === _key.toLowerCase()) {
        return _key;
      }
    }
    return null;
  }
  const _global = (() => {
    if (typeof globalThis !== "undefined")
      return globalThis;
    return typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : global;
  })();
  const isContextDefined = (context) => !isUndefined(context) && context !== _global;
  function merge() {
    const { caseless } = isContextDefined(this) && this || {};
    const result = {};
    const assignValue = (val, key) => {
      const targetKey = caseless && findKey(result, key) || key;
      if (isPlainObject(result[targetKey]) && isPlainObject(val)) {
        result[targetKey] = merge(result[targetKey], val);
      } else if (isPlainObject(val)) {
        result[targetKey] = merge({}, val);
      } else if (isArray(val)) {
        result[targetKey] = val.slice();
      } else {
        result[targetKey] = val;
      }
    };
    for (let i2 = 0, l2 = arguments.length; i2 < l2; i2++) {
      arguments[i2] && forEach(arguments[i2], assignValue);
    }
    return result;
  }
  const extend$1 = (a2, b2, thisArg, { allOwnKeys } = {}) => {
    forEach(b2, (val, key) => {
      if (thisArg && isFunction(val)) {
        a2[key] = bind(val, thisArg);
      } else {
        a2[key] = val;
      }
    }, { allOwnKeys });
    return a2;
  };
  const stripBOM = (content2) => {
    if (content2.charCodeAt(0) === 65279) {
      content2 = content2.slice(1);
    }
    return content2;
  };
  const inherits = (constructor, superConstructor, props, descriptors2) => {
    constructor.prototype = Object.create(superConstructor.prototype, descriptors2);
    constructor.prototype.constructor = constructor;
    Object.defineProperty(constructor, "super", {
      value: superConstructor.prototype
    });
    props && Object.assign(constructor.prototype, props);
  };
  const toFlatObject = (sourceObj, destObj, filter, propFilter) => {
    let props;
    let i2;
    let prop;
    const merged = {};
    destObj = destObj || {};
    if (sourceObj == null)
      return destObj;
    do {
      props = Object.getOwnPropertyNames(sourceObj);
      i2 = props.length;
      while (i2-- > 0) {
        prop = props[i2];
        if ((!propFilter || propFilter(prop, sourceObj, destObj)) && !merged[prop]) {
          destObj[prop] = sourceObj[prop];
          merged[prop] = true;
        }
      }
      sourceObj = filter !== false && getPrototypeOf(sourceObj);
    } while (sourceObj && (!filter || filter(sourceObj, destObj)) && sourceObj !== Object.prototype);
    return destObj;
  };
  const endsWith = (str, searchString, position2) => {
    str = String(str);
    if (position2 === void 0 || position2 > str.length) {
      position2 = str.length;
    }
    position2 -= searchString.length;
    const lastIndex = str.indexOf(searchString, position2);
    return lastIndex !== -1 && lastIndex === position2;
  };
  const toArray = (thing) => {
    if (!thing)
      return null;
    if (isArray(thing))
      return thing;
    let i2 = thing.length;
    if (!isNumber$1(i2))
      return null;
    const arr = new Array(i2);
    while (i2-- > 0) {
      arr[i2] = thing[i2];
    }
    return arr;
  };
  const isTypedArray = /* @__PURE__ */ ((TypedArray) => {
    return (thing) => {
      return TypedArray && thing instanceof TypedArray;
    };
  })(typeof Uint8Array !== "undefined" && getPrototypeOf(Uint8Array));
  const forEachEntry = (obj, fn) => {
    const generator = obj && obj[Symbol.iterator];
    const iterator = generator.call(obj);
    let result;
    while ((result = iterator.next()) && !result.done) {
      const pair2 = result.value;
      fn.call(obj, pair2[0], pair2[1]);
    }
  };
  const matchAll = (regExp, str) => {
    let matches2;
    const arr = [];
    while ((matches2 = regExp.exec(str)) !== null) {
      arr.push(matches2);
    }
    return arr;
  };
  const isHTMLForm = kindOfTest("HTMLFormElement");
  const toCamelCase = (str) => {
    return str.toLowerCase().replace(
      /[-_\s]([a-z\d])(\w*)/g,
      function replacer2(m2, p1, p2) {
        return p1.toUpperCase() + p2;
      }
    );
  };
  const hasOwnProperty = (({ hasOwnProperty: hasOwnProperty2 }) => (obj, prop) => hasOwnProperty2.call(obj, prop))(Object.prototype);
  const isRegExp = kindOfTest("RegExp");
  const reduceDescriptors = (obj, reducer) => {
    const descriptors2 = Object.getOwnPropertyDescriptors(obj);
    const reducedDescriptors = {};
    forEach(descriptors2, (descriptor, name2) => {
      let ret;
      if ((ret = reducer(descriptor, name2, obj)) !== false) {
        reducedDescriptors[name2] = ret || descriptor;
      }
    });
    Object.defineProperties(obj, reducedDescriptors);
  };
  const freezeMethods = (obj) => {
    reduceDescriptors(obj, (descriptor, name2) => {
      if (isFunction(obj) && ["arguments", "caller", "callee"].indexOf(name2) !== -1) {
        return false;
      }
      const value = obj[name2];
      if (!isFunction(value))
        return;
      descriptor.enumerable = false;
      if ("writable" in descriptor) {
        descriptor.writable = false;
        return;
      }
      if (!descriptor.set) {
        descriptor.set = () => {
          throw Error("Can not rewrite read-only method '" + name2 + "'");
        };
      }
    });
  };
  const toObjectSet = (arrayOrString, delimiter) => {
    const obj = {};
    const define2 = (arr) => {
      arr.forEach((value) => {
        obj[value] = true;
      });
    };
    isArray(arrayOrString) ? define2(arrayOrString) : define2(String(arrayOrString).split(delimiter));
    return obj;
  };
  const noop = () => {
  };
  const toFiniteNumber = (value, defaultValue) => {
    value = +value;
    return Number.isFinite(value) ? value : defaultValue;
  };
  const ALPHA = "abcdefghijklmnopqrstuvwxyz";
  const DIGIT = "0123456789";
  const ALPHABET = {
    DIGIT,
    ALPHA,
    ALPHA_DIGIT: ALPHA + ALPHA.toUpperCase() + DIGIT
  };
  const generateString = (size2 = 16, alphabet = ALPHABET.ALPHA_DIGIT) => {
    let str = "";
    const { length } = alphabet;
    while (size2--) {
      str += alphabet[Math.random() * length | 0];
    }
    return str;
  };
  function isSpecCompliantForm(thing) {
    return !!(thing && isFunction(thing.append) && thing[Symbol.toStringTag] === "FormData" && thing[Symbol.iterator]);
  }
  const toJSONObject = (obj) => {
    const stack2 = new Array(10);
    const visit = (source, i2) => {
      if (isObject(source)) {
        if (stack2.indexOf(source) >= 0) {
          return;
        }
        if (!("toJSON" in source)) {
          stack2[i2] = source;
          const target = isArray(source) ? [] : {};
          forEach(source, (value, key) => {
            const reducedValue = visit(value, i2 + 1);
            !isUndefined(reducedValue) && (target[key] = reducedValue);
          });
          stack2[i2] = void 0;
          return target;
        }
      }
      return source;
    };
    return visit(obj, 0);
  };
  const isAsyncFn = kindOfTest("AsyncFunction");
  const isThenable = (thing) => thing && (isObject(thing) || isFunction(thing)) && isFunction(thing.then) && isFunction(thing.catch);
  const utils$1 = {
    isArray,
    isArrayBuffer,
    isBuffer,
    isFormData,
    isArrayBufferView,
    isString,
    isNumber: isNumber$1,
    isBoolean,
    isObject,
    isPlainObject,
    isUndefined,
    isDate,
    isFile,
    isBlob,
    isRegExp,
    isFunction,
    isStream,
    isURLSearchParams,
    isTypedArray,
    isFileList,
    forEach,
    merge,
    extend: extend$1,
    trim,
    stripBOM,
    inherits,
    toFlatObject,
    kindOf,
    kindOfTest,
    endsWith,
    toArray,
    forEachEntry,
    matchAll,
    isHTMLForm,
    hasOwnProperty,
    hasOwnProp: hasOwnProperty,
    // an alias to avoid ESLint no-prototype-builtins detection
    reduceDescriptors,
    freezeMethods,
    toObjectSet,
    toCamelCase,
    noop,
    toFiniteNumber,
    findKey,
    global: _global,
    isContextDefined,
    ALPHABET,
    generateString,
    isSpecCompliantForm,
    toJSONObject,
    isAsyncFn,
    isThenable
  };
  function AxiosError(message, code2, config2, request, response) {
    Error.call(this);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error().stack;
    }
    this.message = message;
    this.name = "AxiosError";
    code2 && (this.code = code2);
    config2 && (this.config = config2);
    request && (this.request = request);
    response && (this.response = response);
  }
  utils$1.inherits(AxiosError, Error, {
    toJSON: function toJSON() {
      return {
        // Standard
        message: this.message,
        name: this.name,
        // Microsoft
        description: this.description,
        number: this.number,
        // Mozilla
        fileName: this.fileName,
        lineNumber: this.lineNumber,
        columnNumber: this.columnNumber,
        stack: this.stack,
        // Axios
        config: utils$1.toJSONObject(this.config),
        code: this.code,
        status: this.response && this.response.status ? this.response.status : null
      };
    }
  });
  const prototype$1 = AxiosError.prototype;
  const descriptors = {};
  [
    "ERR_BAD_OPTION_VALUE",
    "ERR_BAD_OPTION",
    "ECONNABORTED",
    "ETIMEDOUT",
    "ERR_NETWORK",
    "ERR_FR_TOO_MANY_REDIRECTS",
    "ERR_DEPRECATED",
    "ERR_BAD_RESPONSE",
    "ERR_BAD_REQUEST",
    "ERR_CANCELED",
    "ERR_NOT_SUPPORT",
    "ERR_INVALID_URL"
    // eslint-disable-next-line func-names
  ].forEach((code2) => {
    descriptors[code2] = { value: code2 };
  });
  Object.defineProperties(AxiosError, descriptors);
  Object.defineProperty(prototype$1, "isAxiosError", { value: true });
  AxiosError.from = (error, code2, config2, request, response, customProps) => {
    const axiosError = Object.create(prototype$1);
    utils$1.toFlatObject(error, axiosError, function filter(obj) {
      return obj !== Error.prototype;
    }, (prop) => {
      return prop !== "isAxiosError";
    });
    AxiosError.call(axiosError, error.message, code2, config2, request, response);
    axiosError.cause = error;
    axiosError.name = error.name;
    customProps && Object.assign(axiosError, customProps);
    return axiosError;
  };
  const httpAdapter = null;
  function isVisitable(thing) {
    return utils$1.isPlainObject(thing) || utils$1.isArray(thing);
  }
  function removeBrackets(key) {
    return utils$1.endsWith(key, "[]") ? key.slice(0, -2) : key;
  }
  function renderKey(path, key, dots) {
    if (!path)
      return key;
    return path.concat(key).map(function each(token, i2) {
      token = removeBrackets(token);
      return !dots && i2 ? "[" + token + "]" : token;
    }).join(dots ? "." : "");
  }
  function isFlatArray(arr) {
    return utils$1.isArray(arr) && !arr.some(isVisitable);
  }
  const predicates = utils$1.toFlatObject(utils$1, {}, null, function filter(prop) {
    return /^is[A-Z]/.test(prop);
  });
  function toFormData(obj, formData, options) {
    if (!utils$1.isObject(obj)) {
      throw new TypeError("target must be an object");
    }
    formData = formData || new FormData();
    options = utils$1.toFlatObject(options, {
      metaTokens: true,
      dots: false,
      indexes: false
    }, false, function defined(option, source) {
      return !utils$1.isUndefined(source[option]);
    });
    const metaTokens = options.metaTokens;
    const visitor = options.visitor || defaultVisitor;
    const dots = options.dots;
    const indexes = options.indexes;
    const _Blob = options.Blob || typeof Blob !== "undefined" && Blob;
    const useBlob = _Blob && utils$1.isSpecCompliantForm(formData);
    if (!utils$1.isFunction(visitor)) {
      throw new TypeError("visitor must be a function");
    }
    function convertValue(value) {
      if (value === null)
        return "";
      if (utils$1.isDate(value)) {
        return value.toISOString();
      }
      if (!useBlob && utils$1.isBlob(value)) {
        throw new AxiosError("Blob is not supported. Use a Buffer instead.");
      }
      if (utils$1.isArrayBuffer(value) || utils$1.isTypedArray(value)) {
        return useBlob && typeof Blob === "function" ? new Blob([value]) : Buffer.from(value);
      }
      return value;
    }
    function defaultVisitor(value, key, path) {
      let arr = value;
      if (value && !path && typeof value === "object") {
        if (utils$1.endsWith(key, "{}")) {
          key = metaTokens ? key : key.slice(0, -2);
          value = JSON.stringify(value);
        } else if (utils$1.isArray(value) && isFlatArray(value) || (utils$1.isFileList(value) || utils$1.endsWith(key, "[]")) && (arr = utils$1.toArray(value))) {
          key = removeBrackets(key);
          arr.forEach(function each(el, index2) {
            !(utils$1.isUndefined(el) || el === null) && formData.append(
              // eslint-disable-next-line no-nested-ternary
              indexes === true ? renderKey([key], index2, dots) : indexes === null ? key : key + "[]",
              convertValue(el)
            );
          });
          return false;
        }
      }
      if (isVisitable(value)) {
        return true;
      }
      formData.append(renderKey(path, key, dots), convertValue(value));
      return false;
    }
    const stack2 = [];
    const exposedHelpers = Object.assign(predicates, {
      defaultVisitor,
      convertValue,
      isVisitable
    });
    function build(value, path) {
      if (utils$1.isUndefined(value))
        return;
      if (stack2.indexOf(value) !== -1) {
        throw Error("Circular reference detected in " + path.join("."));
      }
      stack2.push(value);
      utils$1.forEach(value, function each(el, key) {
        const result = !(utils$1.isUndefined(el) || el === null) && visitor.call(
          formData,
          el,
          utils$1.isString(key) ? key.trim() : key,
          path,
          exposedHelpers
        );
        if (result === true) {
          build(el, path ? path.concat(key) : [key]);
        }
      });
      stack2.pop();
    }
    if (!utils$1.isObject(obj)) {
      throw new TypeError("data must be an object");
    }
    build(obj);
    return formData;
  }
  function encode$1(str) {
    const charMap = {
      "!": "%21",
      "'": "%27",
      "(": "%28",
      ")": "%29",
      "~": "%7E",
      "%20": "+",
      "%00": "\0"
    };
    return encodeURIComponent(str).replace(/[!'()~]|%20|%00/g, function replacer2(match) {
      return charMap[match];
    });
  }
  function AxiosURLSearchParams(params, options) {
    this._pairs = [];
    params && toFormData(params, this, options);
  }
  const prototype = AxiosURLSearchParams.prototype;
  prototype.append = function append(name2, value) {
    this._pairs.push([name2, value]);
  };
  prototype.toString = function toString2(encoder) {
    const _encode = encoder ? function(value) {
      return encoder.call(this, value, encode$1);
    } : encode$1;
    return this._pairs.map(function each(pair2) {
      return _encode(pair2[0]) + "=" + _encode(pair2[1]);
    }, "").join("&");
  };
  function encode(val) {
    return encodeURIComponent(val).replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, "+").replace(/%5B/gi, "[").replace(/%5D/gi, "]");
  }
  function buildURL(url, params, options) {
    if (!params) {
      return url;
    }
    const _encode = options && options.encode || encode;
    const serializeFn = options && options.serialize;
    let serializedParams;
    if (serializeFn) {
      serializedParams = serializeFn(params, options);
    } else {
      serializedParams = utils$1.isURLSearchParams(params) ? params.toString() : new AxiosURLSearchParams(params, options).toString(_encode);
    }
    if (serializedParams) {
      const hashmarkIndex = url.indexOf("#");
      if (hashmarkIndex !== -1) {
        url = url.slice(0, hashmarkIndex);
      }
      url += (url.indexOf("?") === -1 ? "?" : "&") + serializedParams;
    }
    return url;
  }
  class InterceptorManager {
    constructor() {
      this.handlers = [];
    }
    /**
     * Add a new interceptor to the stack
     *
     * @param {Function} fulfilled The function to handle `then` for a `Promise`
     * @param {Function} rejected The function to handle `reject` for a `Promise`
     *
     * @return {Number} An ID used to remove interceptor later
     */
    use(fulfilled, rejected, options) {
      this.handlers.push({
        fulfilled,
        rejected,
        synchronous: options ? options.synchronous : false,
        runWhen: options ? options.runWhen : null
      });
      return this.handlers.length - 1;
    }
    /**
     * Remove an interceptor from the stack
     *
     * @param {Number} id The ID that was returned by `use`
     *
     * @returns {Boolean} `true` if the interceptor was removed, `false` otherwise
     */
    eject(id2) {
      if (this.handlers[id2]) {
        this.handlers[id2] = null;
      }
    }
    /**
     * Clear all interceptors from the stack
     *
     * @returns {void}
     */
    clear() {
      if (this.handlers) {
        this.handlers = [];
      }
    }
    /**
     * Iterate over all the registered interceptors
     *
     * This method is particularly useful for skipping over any
     * interceptors that may have become `null` calling `eject`.
     *
     * @param {Function} fn The function to call for each interceptor
     *
     * @returns {void}
     */
    forEach(fn) {
      utils$1.forEach(this.handlers, function forEachHandler(h2) {
        if (h2 !== null) {
          fn(h2);
        }
      });
    }
  }
  const transitionalDefaults = {
    silentJSONParsing: true,
    forcedJSONParsing: true,
    clarifyTimeoutError: false
  };
  const URLSearchParams$1 = typeof URLSearchParams !== "undefined" ? URLSearchParams : AxiosURLSearchParams;
  const FormData$1 = typeof FormData !== "undefined" ? FormData : null;
  const Blob$1 = typeof Blob !== "undefined" ? Blob : null;
  const platform$1 = {
    isBrowser: true,
    classes: {
      URLSearchParams: URLSearchParams$1,
      FormData: FormData$1,
      Blob: Blob$1
    },
    protocols: ["http", "https", "file", "blob", "url", "data"]
  };
  const hasBrowserEnv = typeof window !== "undefined" && typeof document !== "undefined";
  const hasStandardBrowserEnv = ((product) => {
    return hasBrowserEnv && ["ReactNative", "NativeScript", "NS"].indexOf(product) < 0;
  })(typeof navigator !== "undefined" && navigator.product);
  const hasStandardBrowserWebWorkerEnv = (() => {
    return typeof WorkerGlobalScope !== "undefined" && // eslint-disable-next-line no-undef
    self instanceof WorkerGlobalScope && typeof self.importScripts === "function";
  })();
  const utils = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    hasBrowserEnv,
    hasStandardBrowserEnv,
    hasStandardBrowserWebWorkerEnv
  }, Symbol.toStringTag, { value: "Module" }));
  const platform = {
    ...utils,
    ...platform$1
  };
  function toURLEncodedForm(data, options) {
    return toFormData(data, new platform.classes.URLSearchParams(), Object.assign({
      visitor: function(value, key, path, helpers) {
        if (platform.isNode && utils$1.isBuffer(value)) {
          this.append(key, value.toString("base64"));
          return false;
        }
        return helpers.defaultVisitor.apply(this, arguments);
      }
    }, options));
  }
  function parsePropPath(name2) {
    return utils$1.matchAll(/\w+|\[(\w*)]/g, name2).map((match) => {
      return match[0] === "[]" ? "" : match[1] || match[0];
    });
  }
  function arrayToObject(arr) {
    const obj = {};
    const keys = Object.keys(arr);
    let i2;
    const len = keys.length;
    let key;
    for (i2 = 0; i2 < len; i2++) {
      key = keys[i2];
      obj[key] = arr[key];
    }
    return obj;
  }
  function formDataToJSON(formData) {
    function buildPath(path, value, target, index2) {
      let name2 = path[index2++];
      if (name2 === "__proto__")
        return true;
      const isNumericKey = Number.isFinite(+name2);
      const isLast = index2 >= path.length;
      name2 = !name2 && utils$1.isArray(target) ? target.length : name2;
      if (isLast) {
        if (utils$1.hasOwnProp(target, name2)) {
          target[name2] = [target[name2], value];
        } else {
          target[name2] = value;
        }
        return !isNumericKey;
      }
      if (!target[name2] || !utils$1.isObject(target[name2])) {
        target[name2] = [];
      }
      const result = buildPath(path, value, target[name2], index2);
      if (result && utils$1.isArray(target[name2])) {
        target[name2] = arrayToObject(target[name2]);
      }
      return !isNumericKey;
    }
    if (utils$1.isFormData(formData) && utils$1.isFunction(formData.entries)) {
      const obj = {};
      utils$1.forEachEntry(formData, (name2, value) => {
        buildPath(parsePropPath(name2), value, obj, 0);
      });
      return obj;
    }
    return null;
  }
  function stringifySafely(rawValue, parser2, encoder) {
    if (utils$1.isString(rawValue)) {
      try {
        (parser2 || JSON.parse)(rawValue);
        return utils$1.trim(rawValue);
      } catch (e2) {
        if (e2.name !== "SyntaxError") {
          throw e2;
        }
      }
    }
    return (encoder || JSON.stringify)(rawValue);
  }
  const defaults$1 = {
    transitional: transitionalDefaults,
    adapter: ["xhr", "http"],
    transformRequest: [function transformRequest(data, headers) {
      const contentType2 = headers.getContentType() || "";
      const hasJSONContentType = contentType2.indexOf("application/json") > -1;
      const isObjectPayload = utils$1.isObject(data);
      if (isObjectPayload && utils$1.isHTMLForm(data)) {
        data = new FormData(data);
      }
      const isFormData2 = utils$1.isFormData(data);
      if (isFormData2) {
        return hasJSONContentType ? JSON.stringify(formDataToJSON(data)) : data;
      }
      if (utils$1.isArrayBuffer(data) || utils$1.isBuffer(data) || utils$1.isStream(data) || utils$1.isFile(data) || utils$1.isBlob(data)) {
        return data;
      }
      if (utils$1.isArrayBufferView(data)) {
        return data.buffer;
      }
      if (utils$1.isURLSearchParams(data)) {
        headers.setContentType("application/x-www-form-urlencoded;charset=utf-8", false);
        return data.toString();
      }
      let isFileList2;
      if (isObjectPayload) {
        if (contentType2.indexOf("application/x-www-form-urlencoded") > -1) {
          return toURLEncodedForm(data, this.formSerializer).toString();
        }
        if ((isFileList2 = utils$1.isFileList(data)) || contentType2.indexOf("multipart/form-data") > -1) {
          const _FormData = this.env && this.env.FormData;
          return toFormData(
            isFileList2 ? { "files[]": data } : data,
            _FormData && new _FormData(),
            this.formSerializer
          );
        }
      }
      if (isObjectPayload || hasJSONContentType) {
        headers.setContentType("application/json", false);
        return stringifySafely(data);
      }
      return data;
    }],
    transformResponse: [function transformResponse(data) {
      const transitional = this.transitional || defaults$1.transitional;
      const forcedJSONParsing = transitional && transitional.forcedJSONParsing;
      const JSONRequested = this.responseType === "json";
      if (data && utils$1.isString(data) && (forcedJSONParsing && !this.responseType || JSONRequested)) {
        const silentJSONParsing = transitional && transitional.silentJSONParsing;
        const strictJSONParsing = !silentJSONParsing && JSONRequested;
        try {
          return JSON.parse(data);
        } catch (e2) {
          if (strictJSONParsing) {
            if (e2.name === "SyntaxError") {
              throw AxiosError.from(e2, AxiosError.ERR_BAD_RESPONSE, this, null, this.response);
            }
            throw e2;
          }
        }
      }
      return data;
    }],
    /**
     * A timeout in milliseconds to abort a request. If set to 0 (default) a
     * timeout is not created.
     */
    timeout: 0,
    xsrfCookieName: "XSRF-TOKEN",
    xsrfHeaderName: "X-XSRF-TOKEN",
    maxContentLength: -1,
    maxBodyLength: -1,
    env: {
      FormData: platform.classes.FormData,
      Blob: platform.classes.Blob
    },
    validateStatus: function validateStatus(status) {
      return status >= 200 && status < 300;
    },
    headers: {
      common: {
        "Accept": "application/json, text/plain, */*",
        "Content-Type": void 0
      }
    }
  };
  utils$1.forEach(["delete", "get", "head", "post", "put", "patch"], (method) => {
    defaults$1.headers[method] = {};
  });
  const defaults$2 = defaults$1;
  const ignoreDuplicateOf = utils$1.toObjectSet([
    "age",
    "authorization",
    "content-length",
    "content-type",
    "etag",
    "expires",
    "from",
    "host",
    "if-modified-since",
    "if-unmodified-since",
    "last-modified",
    "location",
    "max-forwards",
    "proxy-authorization",
    "referer",
    "retry-after",
    "user-agent"
  ]);
  const parseHeaders = (rawHeaders) => {
    const parsed = {};
    let key;
    let val;
    let i2;
    rawHeaders && rawHeaders.split("\n").forEach(function parser2(line) {
      i2 = line.indexOf(":");
      key = line.substring(0, i2).trim().toLowerCase();
      val = line.substring(i2 + 1).trim();
      if (!key || parsed[key] && ignoreDuplicateOf[key]) {
        return;
      }
      if (key === "set-cookie") {
        if (parsed[key]) {
          parsed[key].push(val);
        } else {
          parsed[key] = [val];
        }
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ", " + val : val;
      }
    });
    return parsed;
  };
  const $internals = Symbol("internals");
  function normalizeHeader(header) {
    return header && String(header).trim().toLowerCase();
  }
  function normalizeValue(value) {
    if (value === false || value == null) {
      return value;
    }
    return utils$1.isArray(value) ? value.map(normalizeValue) : String(value);
  }
  function parseTokens(str) {
    const tokens = /* @__PURE__ */ Object.create(null);
    const tokensRE = /([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;
    let match;
    while (match = tokensRE.exec(str)) {
      tokens[match[1]] = match[2];
    }
    return tokens;
  }
  const isValidHeaderName = (str) => /^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(str.trim());
  function matchHeaderValue(context, value, header, filter, isHeaderNameFilter) {
    if (utils$1.isFunction(filter)) {
      return filter.call(this, value, header);
    }
    if (isHeaderNameFilter) {
      value = header;
    }
    if (!utils$1.isString(value))
      return;
    if (utils$1.isString(filter)) {
      return value.indexOf(filter) !== -1;
    }
    if (utils$1.isRegExp(filter)) {
      return filter.test(value);
    }
  }
  function formatHeader(header) {
    return header.trim().toLowerCase().replace(/([a-z\d])(\w*)/g, (w2, char, str) => {
      return char.toUpperCase() + str;
    });
  }
  function buildAccessors(obj, header) {
    const accessorName = utils$1.toCamelCase(" " + header);
    ["get", "set", "has"].forEach((methodName) => {
      Object.defineProperty(obj, methodName + accessorName, {
        value: function(arg1, arg2, arg3) {
          return this[methodName].call(this, header, arg1, arg2, arg3);
        },
        configurable: true
      });
    });
  }
  class AxiosHeaders {
    constructor(headers) {
      headers && this.set(headers);
    }
    set(header, valueOrRewrite, rewrite) {
      const self2 = this;
      function setHeader(_value, _header, _rewrite) {
        const lHeader = normalizeHeader(_header);
        if (!lHeader) {
          throw new Error("header name must be a non-empty string");
        }
        const key = utils$1.findKey(self2, lHeader);
        if (!key || self2[key] === void 0 || _rewrite === true || _rewrite === void 0 && self2[key] !== false) {
          self2[key || _header] = normalizeValue(_value);
        }
      }
      const setHeaders = (headers, _rewrite) => utils$1.forEach(headers, (_value, _header) => setHeader(_value, _header, _rewrite));
      if (utils$1.isPlainObject(header) || header instanceof this.constructor) {
        setHeaders(header, valueOrRewrite);
      } else if (utils$1.isString(header) && (header = header.trim()) && !isValidHeaderName(header)) {
        setHeaders(parseHeaders(header), valueOrRewrite);
      } else {
        header != null && setHeader(valueOrRewrite, header, rewrite);
      }
      return this;
    }
    get(header, parser2) {
      header = normalizeHeader(header);
      if (header) {
        const key = utils$1.findKey(this, header);
        if (key) {
          const value = this[key];
          if (!parser2) {
            return value;
          }
          if (parser2 === true) {
            return parseTokens(value);
          }
          if (utils$1.isFunction(parser2)) {
            return parser2.call(this, value, key);
          }
          if (utils$1.isRegExp(parser2)) {
            return parser2.exec(value);
          }
          throw new TypeError("parser must be boolean|regexp|function");
        }
      }
    }
    has(header, matcher) {
      header = normalizeHeader(header);
      if (header) {
        const key = utils$1.findKey(this, header);
        return !!(key && this[key] !== void 0 && (!matcher || matchHeaderValue(this, this[key], key, matcher)));
      }
      return false;
    }
    delete(header, matcher) {
      const self2 = this;
      let deleted = false;
      function deleteHeader(_header) {
        _header = normalizeHeader(_header);
        if (_header) {
          const key = utils$1.findKey(self2, _header);
          if (key && (!matcher || matchHeaderValue(self2, self2[key], key, matcher))) {
            delete self2[key];
            deleted = true;
          }
        }
      }
      if (utils$1.isArray(header)) {
        header.forEach(deleteHeader);
      } else {
        deleteHeader(header);
      }
      return deleted;
    }
    clear(matcher) {
      const keys = Object.keys(this);
      let i2 = keys.length;
      let deleted = false;
      while (i2--) {
        const key = keys[i2];
        if (!matcher || matchHeaderValue(this, this[key], key, matcher, true)) {
          delete this[key];
          deleted = true;
        }
      }
      return deleted;
    }
    normalize(format2) {
      const self2 = this;
      const headers = {};
      utils$1.forEach(this, (value, header) => {
        const key = utils$1.findKey(headers, header);
        if (key) {
          self2[key] = normalizeValue(value);
          delete self2[header];
          return;
        }
        const normalized = format2 ? formatHeader(header) : String(header).trim();
        if (normalized !== header) {
          delete self2[header];
        }
        self2[normalized] = normalizeValue(value);
        headers[normalized] = true;
      });
      return this;
    }
    concat(...targets) {
      return this.constructor.concat(this, ...targets);
    }
    toJSON(asStrings) {
      const obj = /* @__PURE__ */ Object.create(null);
      utils$1.forEach(this, (value, header) => {
        value != null && value !== false && (obj[header] = asStrings && utils$1.isArray(value) ? value.join(", ") : value);
      });
      return obj;
    }
    [Symbol.iterator]() {
      return Object.entries(this.toJSON())[Symbol.iterator]();
    }
    toString() {
      return Object.entries(this.toJSON()).map(([header, value]) => header + ": " + value).join("\n");
    }
    get [Symbol.toStringTag]() {
      return "AxiosHeaders";
    }
    static from(thing) {
      return thing instanceof this ? thing : new this(thing);
    }
    static concat(first, ...targets) {
      const computed2 = new this(first);
      targets.forEach((target) => computed2.set(target));
      return computed2;
    }
    static accessor(header) {
      const internals = this[$internals] = this[$internals] = {
        accessors: {}
      };
      const accessors = internals.accessors;
      const prototype2 = this.prototype;
      function defineAccessor(_header) {
        const lHeader = normalizeHeader(_header);
        if (!accessors[lHeader]) {
          buildAccessors(prototype2, _header);
          accessors[lHeader] = true;
        }
      }
      utils$1.isArray(header) ? header.forEach(defineAccessor) : defineAccessor(header);
      return this;
    }
  }
  AxiosHeaders.accessor(["Content-Type", "Content-Length", "Accept", "Accept-Encoding", "User-Agent", "Authorization"]);
  utils$1.reduceDescriptors(AxiosHeaders.prototype, ({ value }, key) => {
    let mapped = key[0].toUpperCase() + key.slice(1);
    return {
      get: () => value,
      set(headerValue) {
        this[mapped] = headerValue;
      }
    };
  });
  utils$1.freezeMethods(AxiosHeaders);
  const AxiosHeaders$1 = AxiosHeaders;
  function transformData(fns, response) {
    const config2 = this || defaults$2;
    const context = response || config2;
    const headers = AxiosHeaders$1.from(context.headers);
    let data = context.data;
    utils$1.forEach(fns, function transform2(fn) {
      data = fn.call(config2, data, headers.normalize(), response ? response.status : void 0);
    });
    headers.normalize();
    return data;
  }
  function isCancel(value) {
    return !!(value && value.__CANCEL__);
  }
  function CanceledError(message, config2, request) {
    AxiosError.call(this, message == null ? "canceled" : message, AxiosError.ERR_CANCELED, config2, request);
    this.name = "CanceledError";
  }
  utils$1.inherits(CanceledError, AxiosError, {
    __CANCEL__: true
  });
  function settle(resolve2, reject, response) {
    const validateStatus = response.config.validateStatus;
    if (!response.status || !validateStatus || validateStatus(response.status)) {
      resolve2(response);
    } else {
      reject(new AxiosError(
        "Request failed with status code " + response.status,
        [AxiosError.ERR_BAD_REQUEST, AxiosError.ERR_BAD_RESPONSE][Math.floor(response.status / 100) - 4],
        response.config,
        response.request,
        response
      ));
    }
  }
  const cookies = platform.hasStandardBrowserEnv ? (
    // Standard browser envs support document.cookie
    {
      write(name2, value, expires, path, domain, secure) {
        const cookie = [name2 + "=" + encodeURIComponent(value)];
        utils$1.isNumber(expires) && cookie.push("expires=" + new Date(expires).toGMTString());
        utils$1.isString(path) && cookie.push("path=" + path);
        utils$1.isString(domain) && cookie.push("domain=" + domain);
        secure === true && cookie.push("secure");
        document.cookie = cookie.join("; ");
      },
      read(name2) {
        const match = document.cookie.match(new RegExp("(^|;\\s*)(" + name2 + ")=([^;]*)"));
        return match ? decodeURIComponent(match[3]) : null;
      },
      remove(name2) {
        this.write(name2, "", Date.now() - 864e5);
      }
    }
  ) : (
    // Non-standard browser env (web workers, react-native) lack needed support.
    {
      write() {
      },
      read() {
        return null;
      },
      remove() {
      }
    }
  );
  function isAbsoluteURL(url) {
    return /^([a-z][a-z\d+\-.]*:)?\/\//i.test(url);
  }
  function combineURLs(baseURL, relativeURL) {
    return relativeURL ? baseURL.replace(/\/?\/$/, "") + "/" + relativeURL.replace(/^\/+/, "") : baseURL;
  }
  function buildFullPath(baseURL, requestedURL) {
    if (baseURL && !isAbsoluteURL(requestedURL)) {
      return combineURLs(baseURL, requestedURL);
    }
    return requestedURL;
  }
  const isURLSameOrigin = platform.hasStandardBrowserEnv ? (
    // Standard browser envs have full support of the APIs needed to test
    // whether the request URL is of the same origin as current location.
    function standardBrowserEnv() {
      const msie = /(msie|trident)/i.test(navigator.userAgent);
      const urlParsingNode = document.createElement("a");
      let originURL;
      function resolveURL(url) {
        let href = url;
        if (msie) {
          urlParsingNode.setAttribute("href", href);
          href = urlParsingNode.href;
        }
        urlParsingNode.setAttribute("href", href);
        return {
          href: urlParsingNode.href,
          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, "") : "",
          host: urlParsingNode.host,
          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, "") : "",
          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, "") : "",
          hostname: urlParsingNode.hostname,
          port: urlParsingNode.port,
          pathname: urlParsingNode.pathname.charAt(0) === "/" ? urlParsingNode.pathname : "/" + urlParsingNode.pathname
        };
      }
      originURL = resolveURL(window.location.href);
      return function isURLSameOrigin2(requestURL) {
        const parsed = utils$1.isString(requestURL) ? resolveURL(requestURL) : requestURL;
        return parsed.protocol === originURL.protocol && parsed.host === originURL.host;
      };
    }()
  ) : (
    // Non standard browser envs (web workers, react-native) lack needed support.
    /* @__PURE__ */ function nonStandardBrowserEnv() {
      return function isURLSameOrigin2() {
        return true;
      };
    }()
  );
  function parseProtocol(url) {
    const match = /^([-+\w]{1,25})(:?\/\/|:)/.exec(url);
    return match && match[1] || "";
  }
  function speedometer(samplesCount, min) {
    samplesCount = samplesCount || 10;
    const bytes = new Array(samplesCount);
    const timestamps = new Array(samplesCount);
    let head = 0;
    let tail = 0;
    let firstSampleTS;
    min = min !== void 0 ? min : 1e3;
    return function push(chunkLength) {
      const now = Date.now();
      const startedAt = timestamps[tail];
      if (!firstSampleTS) {
        firstSampleTS = now;
      }
      bytes[head] = chunkLength;
      timestamps[head] = now;
      let i2 = tail;
      let bytesCount = 0;
      while (i2 !== head) {
        bytesCount += bytes[i2++];
        i2 = i2 % samplesCount;
      }
      head = (head + 1) % samplesCount;
      if (head === tail) {
        tail = (tail + 1) % samplesCount;
      }
      if (now - firstSampleTS < min) {
        return;
      }
      const passed = startedAt && now - startedAt;
      return passed ? Math.round(bytesCount * 1e3 / passed) : void 0;
    };
  }
  function progressEventReducer(listener, isDownloadStream) {
    let bytesNotified = 0;
    const _speedometer = speedometer(50, 250);
    return (e2) => {
      const loaded = e2.loaded;
      const total = e2.lengthComputable ? e2.total : void 0;
      const progressBytes = loaded - bytesNotified;
      const rate = _speedometer(progressBytes);
      const inRange = loaded <= total;
      bytesNotified = loaded;
      const data = {
        loaded,
        total,
        progress: total ? loaded / total : void 0,
        bytes: progressBytes,
        rate: rate ? rate : void 0,
        estimated: rate && total && inRange ? (total - loaded) / rate : void 0,
        event: e2
      };
      data[isDownloadStream ? "download" : "upload"] = true;
      listener(data);
    };
  }
  const isXHRAdapterSupported = typeof XMLHttpRequest !== "undefined";
  const xhrAdapter = isXHRAdapterSupported && function(config2) {
    return new Promise(function dispatchXhrRequest(resolve2, reject) {
      let requestData = config2.data;
      const requestHeaders = AxiosHeaders$1.from(config2.headers).normalize();
      let { responseType, withXSRFToken } = config2;
      let onCanceled;
      function done() {
        if (config2.cancelToken) {
          config2.cancelToken.unsubscribe(onCanceled);
        }
        if (config2.signal) {
          config2.signal.removeEventListener("abort", onCanceled);
        }
      }
      let contentType2;
      if (utils$1.isFormData(requestData)) {
        if (platform.hasStandardBrowserEnv || platform.hasStandardBrowserWebWorkerEnv) {
          requestHeaders.setContentType(false);
        } else if ((contentType2 = requestHeaders.getContentType()) !== false) {
          const [type, ...tokens] = contentType2 ? contentType2.split(";").map((token) => token.trim()).filter(Boolean) : [];
          requestHeaders.setContentType([type || "multipart/form-data", ...tokens].join("; "));
        }
      }
      let request = new XMLHttpRequest();
      if (config2.auth) {
        const username = config2.auth.username || "";
        const password = config2.auth.password ? unescape(encodeURIComponent(config2.auth.password)) : "";
        requestHeaders.set("Authorization", "Basic " + btoa(username + ":" + password));
      }
      const fullPath = buildFullPath(config2.baseURL, config2.url);
      request.open(config2.method.toUpperCase(), buildURL(fullPath, config2.params, config2.paramsSerializer), true);
      request.timeout = config2.timeout;
      function onloadend() {
        if (!request) {
          return;
        }
        const responseHeaders = AxiosHeaders$1.from(
          "getAllResponseHeaders" in request && request.getAllResponseHeaders()
        );
        const responseData = !responseType || responseType === "text" || responseType === "json" ? request.responseText : request.response;
        const response = {
          data: responseData,
          status: request.status,
          statusText: request.statusText,
          headers: responseHeaders,
          config: config2,
          request
        };
        settle(function _resolve(value) {
          resolve2(value);
          done();
        }, function _reject(err) {
          reject(err);
          done();
        }, response);
        request = null;
      }
      if ("onloadend" in request) {
        request.onloadend = onloadend;
      } else {
        request.onreadystatechange = function handleLoad() {
          if (!request || request.readyState !== 4) {
            return;
          }
          if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf("file:") === 0)) {
            return;
          }
          setTimeout(onloadend);
        };
      }
      request.onabort = function handleAbort() {
        if (!request) {
          return;
        }
        reject(new AxiosError("Request aborted", AxiosError.ECONNABORTED, config2, request));
        request = null;
      };
      request.onerror = function handleError2() {
        reject(new AxiosError("Network Error", AxiosError.ERR_NETWORK, config2, request));
        request = null;
      };
      request.ontimeout = function handleTimeout() {
        let timeoutErrorMessage = config2.timeout ? "timeout of " + config2.timeout + "ms exceeded" : "timeout exceeded";
        const transitional = config2.transitional || transitionalDefaults;
        if (config2.timeoutErrorMessage) {
          timeoutErrorMessage = config2.timeoutErrorMessage;
        }
        reject(new AxiosError(
          timeoutErrorMessage,
          transitional.clarifyTimeoutError ? AxiosError.ETIMEDOUT : AxiosError.ECONNABORTED,
          config2,
          request
        ));
        request = null;
      };
      if (platform.hasStandardBrowserEnv) {
        withXSRFToken && utils$1.isFunction(withXSRFToken) && (withXSRFToken = withXSRFToken(config2));
        if (withXSRFToken || withXSRFToken !== false && isURLSameOrigin(fullPath)) {
          const xsrfValue = config2.xsrfHeaderName && config2.xsrfCookieName && cookies.read(config2.xsrfCookieName);
          if (xsrfValue) {
            requestHeaders.set(config2.xsrfHeaderName, xsrfValue);
          }
        }
      }
      requestData === void 0 && requestHeaders.setContentType(null);
      if ("setRequestHeader" in request) {
        utils$1.forEach(requestHeaders.toJSON(), function setRequestHeader(val, key) {
          request.setRequestHeader(key, val);
        });
      }
      if (!utils$1.isUndefined(config2.withCredentials)) {
        request.withCredentials = !!config2.withCredentials;
      }
      if (responseType && responseType !== "json") {
        request.responseType = config2.responseType;
      }
      if (typeof config2.onDownloadProgress === "function") {
        request.addEventListener("progress", progressEventReducer(config2.onDownloadProgress, true));
      }
      if (typeof config2.onUploadProgress === "function" && request.upload) {
        request.upload.addEventListener("progress", progressEventReducer(config2.onUploadProgress));
      }
      if (config2.cancelToken || config2.signal) {
        onCanceled = (cancel) => {
          if (!request) {
            return;
          }
          reject(!cancel || cancel.type ? new CanceledError(null, config2, request) : cancel);
          request.abort();
          request = null;
        };
        config2.cancelToken && config2.cancelToken.subscribe(onCanceled);
        if (config2.signal) {
          config2.signal.aborted ? onCanceled() : config2.signal.addEventListener("abort", onCanceled);
        }
      }
      const protocol = parseProtocol(fullPath);
      if (protocol && platform.protocols.indexOf(protocol) === -1) {
        reject(new AxiosError("Unsupported protocol " + protocol + ":", AxiosError.ERR_BAD_REQUEST, config2));
        return;
      }
      request.send(requestData || null);
    });
  };
  const knownAdapters = {
    http: httpAdapter,
    xhr: xhrAdapter
  };
  utils$1.forEach(knownAdapters, (fn, value) => {
    if (fn) {
      try {
        Object.defineProperty(fn, "name", { value });
      } catch (e2) {
      }
      Object.defineProperty(fn, "adapterName", { value });
    }
  });
  const renderReason = (reason) => `- ${reason}`;
  const isResolvedHandle = (adapter) => utils$1.isFunction(adapter) || adapter === null || adapter === false;
  const adapters = {
    getAdapter: (adapters2) => {
      adapters2 = utils$1.isArray(adapters2) ? adapters2 : [adapters2];
      const { length } = adapters2;
      let nameOrAdapter;
      let adapter;
      const rejectedReasons = {};
      for (let i2 = 0; i2 < length; i2++) {
        nameOrAdapter = adapters2[i2];
        let id2;
        adapter = nameOrAdapter;
        if (!isResolvedHandle(nameOrAdapter)) {
          adapter = knownAdapters[(id2 = String(nameOrAdapter)).toLowerCase()];
          if (adapter === void 0) {
            throw new AxiosError(`Unknown adapter '${id2}'`);
          }
        }
        if (adapter) {
          break;
        }
        rejectedReasons[id2 || "#" + i2] = adapter;
      }
      if (!adapter) {
        const reasons = Object.entries(rejectedReasons).map(
          ([id2, state]) => `adapter ${id2} ` + (state === false ? "is not supported by the environment" : "is not available in the build")
        );
        let s2 = length ? reasons.length > 1 ? "since :\n" + reasons.map(renderReason).join("\n") : " " + renderReason(reasons[0]) : "as no adapter specified";
        throw new AxiosError(
          `There is no suitable adapter to dispatch the request ` + s2,
          "ERR_NOT_SUPPORT"
        );
      }
      return adapter;
    },
    adapters: knownAdapters
  };
  function throwIfCancellationRequested(config2) {
    if (config2.cancelToken) {
      config2.cancelToken.throwIfRequested();
    }
    if (config2.signal && config2.signal.aborted) {
      throw new CanceledError(null, config2);
    }
  }
  function dispatchRequest(config2) {
    throwIfCancellationRequested(config2);
    config2.headers = AxiosHeaders$1.from(config2.headers);
    config2.data = transformData.call(
      config2,
      config2.transformRequest
    );
    if (["post", "put", "patch"].indexOf(config2.method) !== -1) {
      config2.headers.setContentType("application/x-www-form-urlencoded", false);
    }
    const adapter = adapters.getAdapter(config2.adapter || defaults$2.adapter);
    return adapter(config2).then(function onAdapterResolution(response) {
      throwIfCancellationRequested(config2);
      response.data = transformData.call(
        config2,
        config2.transformResponse,
        response
      );
      response.headers = AxiosHeaders$1.from(response.headers);
      return response;
    }, function onAdapterRejection(reason) {
      if (!isCancel(reason)) {
        throwIfCancellationRequested(config2);
        if (reason && reason.response) {
          reason.response.data = transformData.call(
            config2,
            config2.transformResponse,
            reason.response
          );
          reason.response.headers = AxiosHeaders$1.from(reason.response.headers);
        }
      }
      return Promise.reject(reason);
    });
  }
  const headersToObject = (thing) => thing instanceof AxiosHeaders$1 ? thing.toJSON() : thing;
  function mergeConfig(config1, config2) {
    config2 = config2 || {};
    const config3 = {};
    function getMergedValue(target, source, caseless) {
      if (utils$1.isPlainObject(target) && utils$1.isPlainObject(source)) {
        return utils$1.merge.call({ caseless }, target, source);
      } else if (utils$1.isPlainObject(source)) {
        return utils$1.merge({}, source);
      } else if (utils$1.isArray(source)) {
        return source.slice();
      }
      return source;
    }
    function mergeDeepProperties(a2, b2, caseless) {
      if (!utils$1.isUndefined(b2)) {
        return getMergedValue(a2, b2, caseless);
      } else if (!utils$1.isUndefined(a2)) {
        return getMergedValue(void 0, a2, caseless);
      }
    }
    function valueFromConfig2(a2, b2) {
      if (!utils$1.isUndefined(b2)) {
        return getMergedValue(void 0, b2);
      }
    }
    function defaultToConfig2(a2, b2) {
      if (!utils$1.isUndefined(b2)) {
        return getMergedValue(void 0, b2);
      } else if (!utils$1.isUndefined(a2)) {
        return getMergedValue(void 0, a2);
      }
    }
    function mergeDirectKeys(a2, b2, prop) {
      if (prop in config2) {
        return getMergedValue(a2, b2);
      } else if (prop in config1) {
        return getMergedValue(void 0, a2);
      }
    }
    const mergeMap = {
      url: valueFromConfig2,
      method: valueFromConfig2,
      data: valueFromConfig2,
      baseURL: defaultToConfig2,
      transformRequest: defaultToConfig2,
      transformResponse: defaultToConfig2,
      paramsSerializer: defaultToConfig2,
      timeout: defaultToConfig2,
      timeoutMessage: defaultToConfig2,
      withCredentials: defaultToConfig2,
      withXSRFToken: defaultToConfig2,
      adapter: defaultToConfig2,
      responseType: defaultToConfig2,
      xsrfCookieName: defaultToConfig2,
      xsrfHeaderName: defaultToConfig2,
      onUploadProgress: defaultToConfig2,
      onDownloadProgress: defaultToConfig2,
      decompress: defaultToConfig2,
      maxContentLength: defaultToConfig2,
      maxBodyLength: defaultToConfig2,
      beforeRedirect: defaultToConfig2,
      transport: defaultToConfig2,
      httpAgent: defaultToConfig2,
      httpsAgent: defaultToConfig2,
      cancelToken: defaultToConfig2,
      socketPath: defaultToConfig2,
      responseEncoding: defaultToConfig2,
      validateStatus: mergeDirectKeys,
      headers: (a2, b2) => mergeDeepProperties(headersToObject(a2), headersToObject(b2), true)
    };
    utils$1.forEach(Object.keys(Object.assign({}, config1, config2)), function computeConfigValue(prop) {
      const merge2 = mergeMap[prop] || mergeDeepProperties;
      const configValue = merge2(config1[prop], config2[prop], prop);
      utils$1.isUndefined(configValue) && merge2 !== mergeDirectKeys || (config3[prop] = configValue);
    });
    return config3;
  }
  const VERSION = "1.6.7";
  const validators$1 = {};
  ["object", "boolean", "number", "function", "string", "symbol"].forEach((type, i2) => {
    validators$1[type] = function validator2(thing) {
      return typeof thing === type || "a" + (i2 < 1 ? "n " : " ") + type;
    };
  });
  const deprecatedWarnings = {};
  validators$1.transitional = function transitional(validator2, version2, message) {
    function formatMessage(opt, desc) {
      return "[Axios v" + VERSION + "] Transitional option '" + opt + "'" + desc + (message ? ". " + message : "");
    }
    return (value, opt, opts) => {
      if (validator2 === false) {
        throw new AxiosError(
          formatMessage(opt, " has been removed" + (version2 ? " in " + version2 : "")),
          AxiosError.ERR_DEPRECATED
        );
      }
      if (version2 && !deprecatedWarnings[opt]) {
        deprecatedWarnings[opt] = true;
        console.warn(
          formatMessage(
            opt,
            " has been deprecated since v" + version2 + " and will be removed in the near future"
          )
        );
      }
      return validator2 ? validator2(value, opt, opts) : true;
    };
  };
  function assertOptions(options, schema, allowUnknown) {
    if (typeof options !== "object") {
      throw new AxiosError("options must be an object", AxiosError.ERR_BAD_OPTION_VALUE);
    }
    const keys = Object.keys(options);
    let i2 = keys.length;
    while (i2-- > 0) {
      const opt = keys[i2];
      const validator2 = schema[opt];
      if (validator2) {
        const value = options[opt];
        const result = value === void 0 || validator2(value, opt, options);
        if (result !== true) {
          throw new AxiosError("option " + opt + " must be " + result, AxiosError.ERR_BAD_OPTION_VALUE);
        }
        continue;
      }
      if (allowUnknown !== true) {
        throw new AxiosError("Unknown option " + opt, AxiosError.ERR_BAD_OPTION);
      }
    }
  }
  const validator = {
    assertOptions,
    validators: validators$1
  };
  const validators = validator.validators;
  class Axios {
    constructor(instanceConfig) {
      this.defaults = instanceConfig;
      this.interceptors = {
        request: new InterceptorManager(),
        response: new InterceptorManager()
      };
    }
    /**
     * Dispatch a request
     *
     * @param {String|Object} configOrUrl The config specific for this request (merged with this.defaults)
     * @param {?Object} config
     *
     * @returns {Promise} The Promise to be fulfilled
     */
    async request(configOrUrl, config2) {
      try {
        return await this._request(configOrUrl, config2);
      } catch (err) {
        if (err instanceof Error) {
          let dummy;
          Error.captureStackTrace ? Error.captureStackTrace(dummy = {}) : dummy = new Error();
          const stack2 = dummy.stack ? dummy.stack.replace(/^.+\n/, "") : "";
          if (!err.stack) {
            err.stack = stack2;
          } else if (stack2 && !String(err.stack).endsWith(stack2.replace(/^.+\n.+\n/, ""))) {
            err.stack += "\n" + stack2;
          }
        }
        throw err;
      }
    }
    _request(configOrUrl, config2) {
      if (typeof configOrUrl === "string") {
        config2 = config2 || {};
        config2.url = configOrUrl;
      } else {
        config2 = configOrUrl || {};
      }
      config2 = mergeConfig(this.defaults, config2);
      const { transitional, paramsSerializer, headers } = config2;
      if (transitional !== void 0) {
        validator.assertOptions(transitional, {
          silentJSONParsing: validators.transitional(validators.boolean),
          forcedJSONParsing: validators.transitional(validators.boolean),
          clarifyTimeoutError: validators.transitional(validators.boolean)
        }, false);
      }
      if (paramsSerializer != null) {
        if (utils$1.isFunction(paramsSerializer)) {
          config2.paramsSerializer = {
            serialize: paramsSerializer
          };
        } else {
          validator.assertOptions(paramsSerializer, {
            encode: validators.function,
            serialize: validators.function
          }, true);
        }
      }
      config2.method = (config2.method || this.defaults.method || "get").toLowerCase();
      let contextHeaders = headers && utils$1.merge(
        headers.common,
        headers[config2.method]
      );
      headers && utils$1.forEach(
        ["delete", "get", "head", "post", "put", "patch", "common"],
        (method) => {
          delete headers[method];
        }
      );
      config2.headers = AxiosHeaders$1.concat(contextHeaders, headers);
      const requestInterceptorChain = [];
      let synchronousRequestInterceptors = true;
      this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
        if (typeof interceptor.runWhen === "function" && interceptor.runWhen(config2) === false) {
          return;
        }
        synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
        requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
      });
      const responseInterceptorChain = [];
      this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
        responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
      });
      let promise;
      let i2 = 0;
      let len;
      if (!synchronousRequestInterceptors) {
        const chain = [dispatchRequest.bind(this), void 0];
        chain.unshift.apply(chain, requestInterceptorChain);
        chain.push.apply(chain, responseInterceptorChain);
        len = chain.length;
        promise = Promise.resolve(config2);
        while (i2 < len) {
          promise = promise.then(chain[i2++], chain[i2++]);
        }
        return promise;
      }
      len = requestInterceptorChain.length;
      let newConfig = config2;
      i2 = 0;
      while (i2 < len) {
        const onFulfilled = requestInterceptorChain[i2++];
        const onRejected = requestInterceptorChain[i2++];
        try {
          newConfig = onFulfilled(newConfig);
        } catch (error) {
          onRejected.call(this, error);
          break;
        }
      }
      try {
        promise = dispatchRequest.call(this, newConfig);
      } catch (error) {
        return Promise.reject(error);
      }
      i2 = 0;
      len = responseInterceptorChain.length;
      while (i2 < len) {
        promise = promise.then(responseInterceptorChain[i2++], responseInterceptorChain[i2++]);
      }
      return promise;
    }
    getUri(config2) {
      config2 = mergeConfig(this.defaults, config2);
      const fullPath = buildFullPath(config2.baseURL, config2.url);
      return buildURL(fullPath, config2.params, config2.paramsSerializer);
    }
  }
  utils$1.forEach(["delete", "get", "head", "options"], function forEachMethodNoData(method) {
    Axios.prototype[method] = function(url, config2) {
      return this.request(mergeConfig(config2 || {}, {
        method,
        url,
        data: (config2 || {}).data
      }));
    };
  });
  utils$1.forEach(["post", "put", "patch"], function forEachMethodWithData(method) {
    function generateHTTPMethod(isForm) {
      return function httpMethod(url, data, config2) {
        return this.request(mergeConfig(config2 || {}, {
          method,
          headers: isForm ? {
            "Content-Type": "multipart/form-data"
          } : {},
          url,
          data
        }));
      };
    }
    Axios.prototype[method] = generateHTTPMethod();
    Axios.prototype[method + "Form"] = generateHTTPMethod(true);
  });
  const Axios$1 = Axios;
  class CancelToken {
    constructor(executor) {
      if (typeof executor !== "function") {
        throw new TypeError("executor must be a function.");
      }
      let resolvePromise;
      this.promise = new Promise(function promiseExecutor(resolve2) {
        resolvePromise = resolve2;
      });
      const token = this;
      this.promise.then((cancel) => {
        if (!token._listeners)
          return;
        let i2 = token._listeners.length;
        while (i2-- > 0) {
          token._listeners[i2](cancel);
        }
        token._listeners = null;
      });
      this.promise.then = (onfulfilled) => {
        let _resolve;
        const promise = new Promise((resolve2) => {
          token.subscribe(resolve2);
          _resolve = resolve2;
        }).then(onfulfilled);
        promise.cancel = function reject() {
          token.unsubscribe(_resolve);
        };
        return promise;
      };
      executor(function cancel(message, config2, request) {
        if (token.reason) {
          return;
        }
        token.reason = new CanceledError(message, config2, request);
        resolvePromise(token.reason);
      });
    }
    /**
     * Throws a `CanceledError` if cancellation has been requested.
     */
    throwIfRequested() {
      if (this.reason) {
        throw this.reason;
      }
    }
    /**
     * Subscribe to the cancel signal
     */
    subscribe(listener) {
      if (this.reason) {
        listener(this.reason);
        return;
      }
      if (this._listeners) {
        this._listeners.push(listener);
      } else {
        this._listeners = [listener];
      }
    }
    /**
     * Unsubscribe from the cancel signal
     */
    unsubscribe(listener) {
      if (!this._listeners) {
        return;
      }
      const index2 = this._listeners.indexOf(listener);
      if (index2 !== -1) {
        this._listeners.splice(index2, 1);
      }
    }
    /**
     * Returns an object that contains a new `CancelToken` and a function that, when called,
     * cancels the `CancelToken`.
     */
    static source() {
      let cancel;
      const token = new CancelToken(function executor(c2) {
        cancel = c2;
      });
      return {
        token,
        cancel
      };
    }
  }
  const CancelToken$1 = CancelToken;
  function spread(callback) {
    return function wrap(arr) {
      return callback.apply(null, arr);
    };
  }
  function isAxiosError(payload) {
    return utils$1.isObject(payload) && payload.isAxiosError === true;
  }
  const HttpStatusCode = {
    Continue: 100,
    SwitchingProtocols: 101,
    Processing: 102,
    EarlyHints: 103,
    Ok: 200,
    Created: 201,
    Accepted: 202,
    NonAuthoritativeInformation: 203,
    NoContent: 204,
    ResetContent: 205,
    PartialContent: 206,
    MultiStatus: 207,
    AlreadyReported: 208,
    ImUsed: 226,
    MultipleChoices: 300,
    MovedPermanently: 301,
    Found: 302,
    SeeOther: 303,
    NotModified: 304,
    UseProxy: 305,
    Unused: 306,
    TemporaryRedirect: 307,
    PermanentRedirect: 308,
    BadRequest: 400,
    Unauthorized: 401,
    PaymentRequired: 402,
    Forbidden: 403,
    NotFound: 404,
    MethodNotAllowed: 405,
    NotAcceptable: 406,
    ProxyAuthenticationRequired: 407,
    RequestTimeout: 408,
    Conflict: 409,
    Gone: 410,
    LengthRequired: 411,
    PreconditionFailed: 412,
    PayloadTooLarge: 413,
    UriTooLong: 414,
    UnsupportedMediaType: 415,
    RangeNotSatisfiable: 416,
    ExpectationFailed: 417,
    ImATeapot: 418,
    MisdirectedRequest: 421,
    UnprocessableEntity: 422,
    Locked: 423,
    FailedDependency: 424,
    TooEarly: 425,
    UpgradeRequired: 426,
    PreconditionRequired: 428,
    TooManyRequests: 429,
    RequestHeaderFieldsTooLarge: 431,
    UnavailableForLegalReasons: 451,
    InternalServerError: 500,
    NotImplemented: 501,
    BadGateway: 502,
    ServiceUnavailable: 503,
    GatewayTimeout: 504,
    HttpVersionNotSupported: 505,
    VariantAlsoNegotiates: 506,
    InsufficientStorage: 507,
    LoopDetected: 508,
    NotExtended: 510,
    NetworkAuthenticationRequired: 511
  };
  Object.entries(HttpStatusCode).forEach(([key, value]) => {
    HttpStatusCode[value] = key;
  });
  const HttpStatusCode$1 = HttpStatusCode;
  function createInstance(defaultConfig) {
    const context = new Axios$1(defaultConfig);
    const instance = bind(Axios$1.prototype.request, context);
    utils$1.extend(instance, Axios$1.prototype, context, { allOwnKeys: true });
    utils$1.extend(instance, context, null, { allOwnKeys: true });
    instance.create = function create(instanceConfig) {
      return createInstance(mergeConfig(defaultConfig, instanceConfig));
    };
    return instance;
  }
  const axios = createInstance(defaults$2);
  axios.Axios = Axios$1;
  axios.CanceledError = CanceledError;
  axios.CancelToken = CancelToken$1;
  axios.isCancel = isCancel;
  axios.VERSION = VERSION;
  axios.toFormData = toFormData;
  axios.AxiosError = AxiosError;
  axios.Cancel = axios.CanceledError;
  axios.all = function all(promises) {
    return Promise.all(promises);
  };
  axios.spread = spread;
  axios.isAxiosError = isAxiosError;
  axios.mergeConfig = mergeConfig;
  axios.AxiosHeaders = AxiosHeaders$1;
  axios.formToJSON = (thing) => formDataToJSON(utils$1.isHTMLForm(thing) ? new FormData(thing) : thing);
  axios.getAdapter = adapters.getAdapter;
  axios.HttpStatusCode = HttpStatusCode$1;
  axios.default = axios;
  const urlAlphabet = "useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict";
  let nanoid = (size2 = 21) => {
    let id2 = "";
    let bytes = crypto.getRandomValues(new Uint8Array(size2));
    while (size2--) {
      id2 += urlAlphabet[bytes[size2] & 63];
    }
    return id2;
  };
  const BYTE_UNITS = [
    "B",
    "kB",
    "MB",
    "GB",
    "TB",
    "PB",
    "EB",
    "ZB",
    "YB"
  ];
  const BIBYTE_UNITS = [
    "B",
    "KiB",
    "MiB",
    "GiB",
    "TiB",
    "PiB",
    "EiB",
    "ZiB",
    "YiB"
  ];
  const BIT_UNITS = [
    "b",
    "kbit",
    "Mbit",
    "Gbit",
    "Tbit",
    "Pbit",
    "Ebit",
    "Zbit",
    "Ybit"
  ];
  const BIBIT_UNITS = [
    "b",
    "kibit",
    "Mibit",
    "Gibit",
    "Tibit",
    "Pibit",
    "Eibit",
    "Zibit",
    "Yibit"
  ];
  const toLocaleString = (number2, locale, options) => {
    let result = number2;
    if (typeof locale === "string" || Array.isArray(locale)) {
      result = number2.toLocaleString(locale, options);
    } else if (locale === true || options !== void 0) {
      result = number2.toLocaleString(void 0, options);
    }
    return result;
  };
  function prettyBytes(number2, options) {
    if (!Number.isFinite(number2)) {
      throw new TypeError(`Expected a finite number, got ${typeof number2}: ${number2}`);
    }
    options = {
      bits: false,
      binary: false,
      space: true,
      ...options
    };
    const UNITS = options.bits ? options.binary ? BIBIT_UNITS : BIT_UNITS : options.binary ? BIBYTE_UNITS : BYTE_UNITS;
    const separator = options.space ? " " : "";
    if (options.signed && number2 === 0) {
      return ` 0${separator}${UNITS[0]}`;
    }
    const isNegative = number2 < 0;
    const prefix = isNegative ? "-" : options.signed ? "+" : "";
    if (isNegative) {
      number2 = -number2;
    }
    let localeOptions;
    if (options.minimumFractionDigits !== void 0) {
      localeOptions = { minimumFractionDigits: options.minimumFractionDigits };
    }
    if (options.maximumFractionDigits !== void 0) {
      localeOptions = { maximumFractionDigits: options.maximumFractionDigits, ...localeOptions };
    }
    if (number2 < 1) {
      const numberString2 = toLocaleString(number2, options.locale, localeOptions);
      return prefix + numberString2 + separator + UNITS[0];
    }
    const exponent = Math.min(Math.floor(options.binary ? Math.log(number2) / Math.log(1024) : Math.log10(number2) / 3), UNITS.length - 1);
    number2 /= (options.binary ? 1024 : 1e3) ** exponent;
    if (!localeOptions) {
      number2 = number2.toPrecision(3);
    }
    const numberString = toLocaleString(Number(number2), options.locale, localeOptions);
    const unit = UNITS[exponent];
    return prefix + numberString + separator + unit;
  }
  function parseMilliseconds(milliseconds) {
    if (typeof milliseconds !== "number") {
      throw new TypeError("Expected a number");
    }
    const roundTowardsZero = milliseconds > 0 ? Math.floor : Math.ceil;
    return {
      days: roundTowardsZero(milliseconds / 864e5),
      hours: roundTowardsZero(milliseconds / 36e5) % 24,
      minutes: roundTowardsZero(milliseconds / 6e4) % 60,
      seconds: roundTowardsZero(milliseconds / 1e3) % 60,
      milliseconds: roundTowardsZero(milliseconds) % 1e3,
      microseconds: roundTowardsZero(milliseconds * 1e3) % 1e3,
      nanoseconds: roundTowardsZero(milliseconds * 1e6) % 1e3
    };
  }
  const pluralize = (word, count) => count === 1 ? word : `${word}s`;
  const SECOND_ROUNDING_EPSILON = 1e-7;
  function prettyMilliseconds(milliseconds, options = {}) {
    if (!Number.isFinite(milliseconds)) {
      throw new TypeError("Expected a finite number");
    }
    if (options.colonNotation) {
      options.compact = false;
      options.formatSubMilliseconds = false;
      options.separateMilliseconds = false;
      options.verbose = false;
    }
    if (options.compact) {
      options.secondsDecimalDigits = 0;
      options.millisecondsDecimalDigits = 0;
    }
    const result = [];
    const floorDecimals = (value, decimalDigits) => {
      const flooredInterimValue = Math.floor(value * 10 ** decimalDigits + SECOND_ROUNDING_EPSILON);
      const flooredValue = Math.round(flooredInterimValue) / 10 ** decimalDigits;
      return flooredValue.toFixed(decimalDigits);
    };
    const add2 = (value, long, short, valueString) => {
      if ((result.length === 0 || !options.colonNotation) && value === 0 && !(options.colonNotation && short === "m")) {
        return;
      }
      valueString = (valueString || value || "0").toString();
      let prefix;
      let suffix;
      if (options.colonNotation) {
        prefix = result.length > 0 ? ":" : "";
        suffix = "";
        const wholeDigits = valueString.includes(".") ? valueString.split(".")[0].length : valueString.length;
        const minLength = result.length > 0 ? 2 : 1;
        valueString = "0".repeat(Math.max(0, minLength - wholeDigits)) + valueString;
      } else {
        prefix = "";
        suffix = options.verbose ? " " + pluralize(long, value) : short;
      }
      result.push(prefix + valueString + suffix);
    };
    const parsed = parseMilliseconds(milliseconds);
    add2(Math.trunc(parsed.days / 365), "year", "y");
    add2(parsed.days % 365, "day", "d");
    add2(parsed.hours, "hour", "h");
    add2(parsed.minutes, "minute", "m");
    if (options.separateMilliseconds || options.formatSubMilliseconds || !options.colonNotation && milliseconds < 1e3) {
      add2(parsed.seconds, "second", "s");
      if (options.formatSubMilliseconds) {
        add2(parsed.milliseconds, "millisecond", "ms");
        add2(parsed.microseconds, "microsecond", "µs");
        add2(parsed.nanoseconds, "nanosecond", "ns");
      } else {
        const millisecondsAndBelow = parsed.milliseconds + parsed.microseconds / 1e3 + parsed.nanoseconds / 1e6;
        const millisecondsDecimalDigits = typeof options.millisecondsDecimalDigits === "number" ? options.millisecondsDecimalDigits : 0;
        const roundedMiliseconds = millisecondsAndBelow >= 1 ? Math.round(millisecondsAndBelow) : Math.ceil(millisecondsAndBelow);
        const millisecondsString = millisecondsDecimalDigits ? millisecondsAndBelow.toFixed(millisecondsDecimalDigits) : roundedMiliseconds;
        add2(
          Number.parseFloat(millisecondsString),
          "millisecond",
          "ms",
          millisecondsString
        );
      }
    } else {
      const seconds = milliseconds / 1e3 % 60;
      const secondsDecimalDigits = typeof options.secondsDecimalDigits === "number" ? options.secondsDecimalDigits : 1;
      const secondsFixed = floorDecimals(seconds, secondsDecimalDigits);
      const secondsString = options.keepDecimalsOnWholeSeconds ? secondsFixed : secondsFixed.replace(/\.0+$/, "");
      add2(Number.parseFloat(secondsString), "second", "s", secondsString);
    }
    if (result.length === 0) {
      return "0" + (options.verbose ? " milliseconds" : "ms");
    }
    if (options.compact) {
      return result[0];
    }
    if (typeof options.unitCount === "number") {
      const separator = options.colonNotation ? "" : " ";
      return result.slice(0, Math.max(options.unitCount, 1)).join(separator);
    }
    return options.colonNotation ? result.join("") : result.join(" ");
  }
  var contentType = {};
  /*!
   * content-type
   * Copyright(c) 2015 Douglas Christopher Wilson
   * MIT Licensed
   */
  var PARAM_REGEXP = /; *([!#$%&'*+.^_`|~0-9A-Za-z-]+) *= *("(?:[\u000b\u0020\u0021\u0023-\u005b\u005d-\u007e\u0080-\u00ff]|\\[\u000b\u0020-\u00ff])*"|[!#$%&'*+.^_`|~0-9A-Za-z-]+) */g;
  var TEXT_REGEXP = /^[\u000b\u0020-\u007e\u0080-\u00ff]+$/;
  var TOKEN_REGEXP = /^[!#$%&'*+.^_`|~0-9A-Za-z-]+$/;
  var QESC_REGEXP = /\\([\u000b\u0020-\u00ff])/g;
  var QUOTE_REGEXP = /([\\"])/g;
  var TYPE_REGEXP = /^[!#$%&'*+.^_`|~0-9A-Za-z-]+\/[!#$%&'*+.^_`|~0-9A-Za-z-]+$/;
  contentType.format = format;
  contentType.parse = parse$1;
  function format(obj) {
    if (!obj || typeof obj !== "object") {
      throw new TypeError("argument obj is required");
    }
    var parameters = obj.parameters;
    var type = obj.type;
    if (!type || !TYPE_REGEXP.test(type)) {
      throw new TypeError("invalid type");
    }
    var string2 = type;
    if (parameters && typeof parameters === "object") {
      var param;
      var params = Object.keys(parameters).sort();
      for (var i2 = 0; i2 < params.length; i2++) {
        param = params[i2];
        if (!TOKEN_REGEXP.test(param)) {
          throw new TypeError("invalid parameter name");
        }
        string2 += "; " + param + "=" + qstring(parameters[param]);
      }
    }
    return string2;
  }
  function parse$1(string2) {
    if (!string2) {
      throw new TypeError("argument string is required");
    }
    var header = typeof string2 === "object" ? getcontenttype(string2) : string2;
    if (typeof header !== "string") {
      throw new TypeError("argument string is required to be a string");
    }
    var index2 = header.indexOf(";");
    var type = index2 !== -1 ? header.slice(0, index2).trim() : header.trim();
    if (!TYPE_REGEXP.test(type)) {
      throw new TypeError("invalid media type");
    }
    var obj = new ContentType(type.toLowerCase());
    if (index2 !== -1) {
      var key;
      var match;
      var value;
      PARAM_REGEXP.lastIndex = index2;
      while (match = PARAM_REGEXP.exec(header)) {
        if (match.index !== index2) {
          throw new TypeError("invalid parameter format");
        }
        index2 += match[0].length;
        key = match[1].toLowerCase();
        value = match[2];
        if (value.charCodeAt(0) === 34) {
          value = value.slice(1, -1);
          if (value.indexOf("\\") !== -1) {
            value = value.replace(QESC_REGEXP, "$1");
          }
        }
        obj.parameters[key] = value;
      }
      if (index2 !== header.length) {
        throw new TypeError("invalid parameter format");
      }
    }
    return obj;
  }
  function getcontenttype(obj) {
    var header;
    if (typeof obj.getHeader === "function") {
      header = obj.getHeader("content-type");
    } else if (typeof obj.headers === "object") {
      header = obj.headers && obj.headers["content-type"];
    }
    if (typeof header !== "string") {
      throw new TypeError("content-type header is missing from object");
    }
    return header;
  }
  function qstring(val) {
    var str = String(val);
    if (TOKEN_REGEXP.test(str)) {
      return str;
    }
    if (str.length > 0 && !TEXT_REGEXP.test(str)) {
      throw new TypeError("invalid parameter value");
    }
    return '"' + str.replace(QUOTE_REGEXP, "\\$1") + '"';
  }
  function ContentType(type) {
    this.parameters = /* @__PURE__ */ Object.create(null);
    this.type = type;
  }
  (function() {
    try {
      if (typeof document != "undefined") {
        var elementStyle = document.createElement("style");
        elementStyle.appendChild(document.createTextNode("@import url('https://fonts.googleapis.com/css2?family=Inter:wght@100..900');@import url('https://fonts.googleapis.com/css?family=JetBrains%20Mono');\n\n:root {\n  --default-theme-border-width: 1px;\n  --default-theme-radius: 3px;\n  --default-theme-radius-lg: 6px;\n  --default-theme-radius-xl: 8px;\n\n  --default-theme-header-height: 50px;\n  --default-theme-sidebar-width: 280px;\n  --default-theme-toc-width: 280px;\n\n  /* TYPOGRAPHY ------------------------------------ */\n  --default-theme-font: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI',\n    Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;\n  --default-theme-font-code: 'JetBrains Mono', ui-monospace, Menlo, Monaco,\n    'Cascadia Mono', 'Segoe UI Mono', 'Roboto Mono', 'Oxygen Mono',\n    'Ubuntu Monospace', 'Source Code Pro', 'Fira Mono', 'Droid Sans Mono',\n    'Courier New', monospace;\n\n  /** Font sizes for rendered text content (editor styles or static content) */\n  --default-theme-heading-1: 40px; /* Editor Page heading */\n  --default-theme-page-description: 24px;\n  --default-theme-heading-2: 24px; /* Editor section headings */\n  --default-theme-heading-3: 20px;\n  --default-theme-heading-4: 16px;\n  --default-theme-heading-5: 16px;\n  --default-theme-heading-6: 16px;\n\n  --default-theme-paragraph: 16px;\n  --default-theme-small: 14px;\n  --default-theme-mini: 13px;\n  --default-theme-micro: 12px;\n  --default-theme-bold: 600;\n  --default-theme-semibold: 500;\n  --default-theme-regular: 400;\n\n  /* Font sizes for interactive applications (not rendered text content) */\n  --default-theme-font-size-1: 24px;\n  --default-theme-font-size-2: 16px;\n  --default-theme-font-size-3: 14px;\n  --default-theme-font-size-4: 13px;\n  --default-theme-font-size-5: 12px;\n\n  --default-theme-line-height-1: 32px;\n  --default-theme-line-height-2: 24px;\n  --default-theme-line-height-3: 20px;\n  --default-theme-line-height-4: 18px;\n  --default-theme-line-height-5: 16px;\n\n  --default-theme-font-medium: 500;\n  --default-theme-font-bold: 700;\n}\n.dark-mode {\n  color-scheme: dark;\n  --default-theme-scrollbar-color: rgba(255, 255, 255, 0.18);\n  --default-theme-scrollbar-color-active: rgba(255, 255, 255, 0.36);\n  --default-theme-button-1: rgba(255, 255, 255, 1);\n  --default-theme-button-1-hover: rgba(255, 255, 255, 0.9);\n  --default-theme-button-1-color: black;\n\n  --default-theme-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, 0.1);\n  --default-theme-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px,\n    rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px rgba(255, 255, 255, 0.1);\n}\n.light-mode {\n  color-scheme: light;\n  --default-theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --default-theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --default-theme-button-1: rgba(0, 0, 0, 1);\n  --default-theme-button-1-hover: rgba(0, 0, 0, 0.8);\n  --default-theme-button-1-color: rgba(255, 255, 255, 0.9);\n\n  --default-theme-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --default-theme-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px,\n    rgba(0, 0, 0, 0.08) 0px 3px 8px 0px, #eeeeed 0px 0 0 1px;\n}\n@media (max-width: 460px) {\n  :root {\n    --default-theme-font-size-1: 22px;\n    --default-theme-font-size-2: 14px;\n    --default-theme-font-size-3: 12px;\n  }\n}\n@media (max-width: 720px) {\n  :root {\n    --default-theme-heading-1: 24px;\n    --default-theme-page-description: 20px;\n  }\n}\n.cm-scroller,\n.custom-scroll {\n  overflow-y: auto;\n  scrollbar-color: transparent transparent;\n  scrollbar-width: thin;\n  -webkit-overflow-scrolling: touch;\n}\n.custom-scroll-self-contain-overflow {\n  overscroll-behavior: contain;\n}\n@supports (-moz-appearance: none) {\n  .cm-scroller,\n  .custom-scroll {\n    padding-right: 12px;\n  }\n}\n.cm-scroller:hover,\n.custom-scroll:hover {\n  scrollbar-color: var(\n      --theme-scrollbar-color,\n      var(--default-theme-scrollbar-color)\n    )\n    transparent;\n}\n.cm-scroller:hover::-webkit-scrollbar-thumb,\n.custom-scroll:hover::-webkit-scrollbar-thumb {\n  background: var(\n    --theme-scrollbar-color,\n    var(--default-theme-scrollbar-color)\n  );\n  background-clip: content-box;\n  border: 3px solid transparent;\n}\n.cm-scroller::-webkit-scrollbar-thumb:active,\n.custom-scroll::-webkit-scrollbar-thumb:active {\n  background: var(\n    --theme-scrollbar-color-active,\n    var(--default-theme-scrollbar-color-active)\n  );\n  background-clip: content-box;\n  border: 3px solid transparent;\n}\n.cm-scroller::-webkit-scrollbar-corner,\n.custom-scroll::-webkit-scrollbar-corner {\n  background: transparent;\n}\n.cm-scroller::-webkit-scrollbar,\n.custom-scroll::-webkit-scrollbar {\n  height: 12px;\n  width: 12px;\n}\n.cm-scroller::-webkit-scrollbar-track,\n.custom-scroll::-webkit-scrollbar-track {\n  background: transparent;\n}\n.cm-scroller::-webkit-scrollbar-thumb,\n.custom-scroll::-webkit-scrollbar-thumb {\n  border-radius: 20px;\n  background: transparent;\n  background-clip: content-box;\n  border: 3px solid transparent;\n}\n@media (pointer: coarse) {\n  .cm-scroller,\n  .custom-scroll {\n    padding-right: 12px;\n  }\n}\n\n.codemirror-container[data-v-9f50a430] {\n  width: 100%;\n  height: 100%;\n  padding-top: 4px;\n  min-height: 76px;\n  background: var(--theme-background-2, var(--default-theme-background-2));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  display: flex;\n  align-items: stretch;\n}\n.copy-to-clipboard-button[data-v-9f50a430] {\n  background: red;\n}\n\n.codemirror {\n  flex-grow: 1;\n  max-width: 100%;\n  cursor: text;\n  font-size: var(--theme-small, var(--default-theme-small));\n  /* Don't scale wide text on mobile because we let it scroll */\n  -webkit-text-size-adjust: 100%;\n}\n.cm-focused {\n  outline: none !important;\n}\n\n.modal-layout[data-v-a06b8e92] {\n  position: fixed;\n  width: 100vw;\n  height: 100vh;\n  top: 0;\n  left: 0;\n  z-index: 1001;\n  background: rgba(0, 0, 0, 0.44);\n  padding: 20px;\n  opacity: 0;\n  animation: modal-fade-a06b8e92 0.2s forwards;\n}\n.modal-body[data-v-a06b8e92] {\n  padding: 24px 24px 18px 24px;\n  max-height: calc(100vh - 240px);\n  background: var(--theme-background-1, var(--default-theme-background-1));\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n  font-family: var(--theme-font, var(--default-theme-font));\n  position: relative;\n}\n.modal[data-v-a06b8e92] {\n  margin: 80px auto 0;\n  position: relative;\n  background: var(--theme-background-2, var(--default-theme-background-2));\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  width: 100%;\n  text-align: left;\n  line-height: 1.4;\n  opacity: 0;\n  transform: scale(0.98);\n  animation: modal-pop-a06b8e92 0.15s 0.15s forwards;\n  display: flex;\n  flex-direction: column;\n}\n.modal[data-v-a06b8e92]:before {\n  content: '';\n  display: block;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  z-index: 0;\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n}\n.dark-mode .modal[data-v-a06b8e92]:before {\n  background: #1a1a1a;\n}\n.light-mode .modal[data-v-a06b8e92]:before {\n  background: #fff;\n}\n.modal-content-history[data-v-a06b8e92] {\n  background: var(--theme-background-1, var(--default-theme-background-1));\n}\n.modal-content-history[data-v-a06b8e92],\n.modal-content-large[data-v-a06b8e92] {\n  max-width: 800px;\n}\n.modal-content-normal[data-v-a06b8e92] {\n  max-width: 640px;\n}\n.modal-content-small[data-v-a06b8e92] {\n  max-width: 480px;\n}\n@keyframes modal-fade-a06b8e92 {\nfrom {\n    opacity: 0;\n}\nto {\n    opacity: 1;\n}\n}\n@keyframes modal-pop-a06b8e92 {\n0% {\n    opacity: 0;\n}\n100% {\n    opacity: 1;\n    transform: scale(1);\n}\n}\n.modal-header[data-v-a06b8e92] {\n  padding: 12px 24px;\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  font-size: var(--theme-font-size-4, var(--default-theme-font-size-4));\n  text-align: left;\n  font-weight: 600;\n  margin: 0;\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg))\n    var(--theme-radius-lg, var(--default-theme-radius-lg)) 0 0;\n  z-index: 1;\n}\n.modal-content-history .modal-header[data-v-a06b8e92] {\n  padding-bottom: 0;\n  padding-top: 24px;\n}\n.modal-content-history .modal-body[data-v-a06b8e92] {\n  padding-top: 12px;\n}\n.modal-content-search[data-v-a06b8e92] {\n  max-width: 540px;\n}\n.modal-content-search .modal-body[data-v-a06b8e92] {\n  padding: 0;\n  overflow: hidden;\n  display: flex;\n  flex-direction: column;\n  max-height: 440px;\n}\n\n.navtable-item-time[data-v-dd49a57f] {\n  text-transform: capitalize;\n}\n.navtable-item__active[data-v-dd49a57f] {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n  cursor: default;\n}\n\n.navtable-mock {\n  background-repeat: repeat;\n  width: 100%;\n  background-size: 31px 31px;\n  background-position: center 1px;\n  flex: 1;\n  position: relative;\n  z-index: 0;\n  border-top: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  background: repeating-linear-gradient(\n    var(--theme-background-1, var(--default-theme-background-1)),\n    var(--theme-background-1, var(--default-theme-background-1)) 34.8px,\n    var(--theme-border-color, var(--default-theme-border-color)) 34.8px,\n    var(--theme-border-color, var(--default-theme-border-color)) 35.8px\n  );\n}\n.navtable-mock .navtable-item {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  left: 0;\n  top: 0;\n  background: transparent;\n  box-shadow: none;\n}\n.radio {\n  height: 10px;\n  max-width: 10px;\n  width: 10px;\n  max-height: 10px;\n  background: transparent;\n  border: var(--border, var(--default-border));\n  flex-shrink: 0;\n  margin-right: 6px;\n  margin-left: 0;\n  border-radius: 50%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  outline: none;\n  padding: 0;\n}\n.radio:before {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  cursor: pointer;\n}\n.navtable-item__active:before {\n  content: '';\n  display: block;\n  box-shadow: 0 0 0 1px var(--theme-color-1, var(--default-theme-color-1)) !important;\n  width: 100%;\n  position: absolute;\n  top: 0;\n  left: 0;\n  height: 100%;\n}\n.navtable-item__active + .navtable-item {\n  /* box-shadow: none; */\n}\n.radio.post {\n  background: var(--theme-color-green, var(--default-theme-color-green));\n}\n.radio.delete {\n  background: var(--theme-color-red, var(--default-theme-color-red));\n}\n.radio.patch {\n  background: var(--theme-color-yellow, var(--default-theme-color-yellow));\n}\n.radio.get {\n  background: var(--theme-color-blue, var(--default-theme-color-blue));\n}\n.radio.put {\n  background: var(--theme-color-orange, var(--default-theme-color-orange));\n}\n.navtable-item-request span {\n  border: none;\n  outline: none;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  width: 100%;\n  display: block;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n.navtable-item-request span em {\n  text-transform: uppercase;\n  font-style: normal;\n  font-family: var(--theme-font-code, var(--default-theme-font-code));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  margin-right: 6px;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  color: var(--theme-color-3, var(--default-theme-color-3));\n}\n\n.request-method-select[data-v-8e2122cd] {\n  position: relative;\n  display: flex;\n}\n.request-method-select select[data-v-8e2122cd] {\n  border: none;\n  outline: none;\n  cursor: pointer;\n  background: var(--theme-background-3, var(--default-theme-background-3));\n  box-shadow: -2px 0 0 0\n    var(--theme-background-3, var(--default-theme-background-3));\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  opacity: 0;\n  -moz-appearance: none;\n  -webkit-appearance: none;\n  appearance: none;\n}\n.request-method-select select[disabled][data-v-8e2122cd] {\n  pointer-events: none;\n}\n.request-method[data-v-8e2122cd] {\n  display: flex;\n  align-items: center;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  appearance: none;\n  -webkit-appearance: none;\n  padding: 0 12px;\n  border-right: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  position: relative;\n}\n.request-method span[data-v-8e2122cd] {\n  font-family: var(--theme-font-code, var(--default-theme-font-code));\n  font-size: 500;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  text-transform: uppercase;\n  display: flex;\n  align-items: center;\n}\n.request-method:not(.request-method--disabled) span[data-v-8e2122cd]:after {\n  content: '';\n  width: 7px;\n  height: 7px;\n  transform: rotate(45deg) translate3d(-2px, -2px, 0);\n  display: block;\n  margin-left: 6px;\n  box-shadow: 1px 1px 0 currentColor;\n}\n.request-method i[data-v-8e2122cd] {\n  width: 10px;\n  height: 10px;\n  border-radius: 50%;\n  margin-right: 6px;\n  text-align: center;\n  line-height: 18px;\n  font-style: normal;\n  flex-shrink: 0;\n  display: inline-block;\n  color: var(--theme-color-disabled, var(--default-theme-color-disabled));\n  background: var(\n    --scalar-api-client-color,\n    var(--default-scalar-api-client-color)\n  );\n}\n\n.api-client-url-variable {\n  color: var(--scalar-api-client-color, var(--default-scalar-api-client-color));\n}\n\n.loader[data-v-75df9114] {\n  position: absolute;\n  z-index: 3;\n  height: 2px;\n  background: var(\n    --scalar-api-client-color,\n    var(--default-scalar-api-client-color)\n  );\n  animation: loading-75df9114 5s cubic-bezier(0, 0.5, 0.25, 1);\n}\n@keyframes loading-75df9114 {\n0% {\n    width: 0;\n}\n100% {\n    width: 100%;\n}\n}\n.address-bar[data-v-75df9114] {\n  width: 100%;\n  padding: 12px 12px 10px 12px;\n  display: flex;\n  align-items: center;\n  position: relative;\n  background: var(--theme-background-1, var(--default-theme-background-1));\n}\n.url-form[data-v-75df9114] {\n  display: flex;\n  width: 100%;\n  align-items: stretch;\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n}\n.url-form[data-v-75df9114] .cm-content {\n  display: flex;\n  align-items: center;\n}\n.url-form-field[data-v-75df9114] {\n  border-right: 0;\n  background: var(--theme-background-2, var(--default-theme-background-2));\n  border-radius: var(--theme-radius, var(--default-theme-radius)) 0 0\n    var(--theme-radius, var(--default-theme-radius));\n  display: flex;\n  align-items: stretch;\n  width: 100%;\n  overflow: hidden;\n  min-height: 31px;\n}\n.url-form-input[data-v-75df9114] {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.url-form-input[data-v-75df9114] {\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  min-height: auto;\n  padding-top: 0;\n}\n.url-form-input[data-v-75df9114] .cm-scroller {\n  overflow-y: hidden;\n}\n.history[data-v-75df9114] {\n  appearance: none;\n  -webkit-appearance: none;\n  background: transparent;\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  display: flex;\n  align-items: center;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  height: 100%;\n}\n.send-button[type='submit'][data-v-75df9114] {\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  letter-spacing: 0.25px;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  color: white;\n  border: none;\n  white-space: nowrap;\n  padding: 0 12px;\n  text-transform: uppercase;\n  cursor: pointer;\n  outline: none;\n  font-family: (--theme-font, var(--default-theme-font));\n  border-radius: 0 var(--theme-radius, var(--default-theme-radius))\n    var(--theme-radius, var(--default-theme-radius)) 0;\n  background: var(\n    --scalar-api-client-color,\n    var(--default-scalar-api-client-color)\n  );\n  position: relative;\n  /**  #087f5b */\n  display: flex;\n  align-items: center;\n  overflow: hidden;\n  flex-shrink: 0;\n}\n.send-button[data-v-75df9114]:before {\n  content: '';\n  position: absolute;\n  top: -5%;\n  left: -5%;\n  width: 110%;\n  height: 110%;\n  pointer-events: none;\n  cursor: pointer;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  background: linear-gradient(rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 0.2));\n}\n.send-button[data-v-75df9114]:hover:before {\n  background: linear-gradient(rgba(0, 0, 0, 0.2), rgba(0, 0, 0, 0.1));\n}\n.send-button svg[data-v-75df9114] {\n  width: 12px;\n  height: 12px;\n  flex-shrink: 0;\n  margin-right: 6px;\n  position: relative;\n}\n.send-button span[data-v-75df9114] {\n  position: relative;\n}\n@media screen and (max-width: 720px) {\n.history-toggle span[data-v-75df9114],\n  .send-button span[data-v-75df9114] {\n    display: none;\n}\n.history-toggle svg[data-v-75df9114],\n  .send-button svg[data-v-75df9114] {\n    margin-right: 0;\n}\n}\n.send-button[disabled][data-v-75df9114] {\n  pointer-events: none;\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  background: var(--theme-background-3, var(--default-theme-background-3));\n  border: 1px solid var(--default-theme-border-color);\n}\n.history-toggle[data-v-75df9114] {\n  padding: 0 12px;\n  line-height: 30px;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  letter-spacing: 0.125px;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  text-transform: uppercase;\n  height: 100%;\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n  white-space: nowrap;\n  box-shadow: 0 0 0 1px\n    var(--theme-border-color, var(--default-theme-border-color));\n  margin-left: 12px;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  user-select: none;\n}\n.history-toggle[data-v-75df9114]:hover {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n}\n.history-toggle svg[data-v-75df9114] {\n  height: 13px;\n  width: 13px;\n  margin-right: 6px;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n}\n.address-bar-content[data-v-75df9114] {\n  width: 640px;\n  height: 100%;\n  background: var(--theme-background-1, var(--default-theme-background-1));\n  position: fixed;\n  top: 0;\n  right: 0;\n  z-index: 1000;\n  transform: translate3d(640px, 0, 0);\n  opacity: 0;\n  transition:\n    transform 0.5s cubic-bezier(0.77, 0, 0.175, 1),\n    opacity 0.01s ease-in-out 0.5s;\n  pointer-events: none;\n}\n.address-bar--with-history[data-v-75df9114] {\n  z-index: 100000;\n}\n.address-bar--with-history .address-bar-content[data-v-75df9114] {\n  transform: translate3d(0, 0, 0);\n  opacity: 1;\n  pointer-events: all;\n  transition: transform 0.5s cubic-bezier(0.77, 0, 0.175, 1);\n}\n.address-bar--with-history .address-bar-close[data-v-75df9114] {\n  opacity: 1;\n  pointer-events: all;\n  cursor: pointer;\n}\n.address-bar-close[data-v-75df9114] {\n  width: 100%;\n  height: 100%;\n  position: fixed;\n  top: 0;\n  left: 0;\n  pointer-events: none;\n  opacity: 0;\n  transition: all 0.1s ease-in-out;\n  z-index: 1000;\n}\n\n.scalar-api-client__item {\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  margin-bottom: 6px;\n  position: relative;\n}\n.scalar-api-client__item button {\n  background-color: transparent;\n  text-align: left;\n}\n.scalar-api-client__item:hover {\n  cursor: pointer;\n}\n.scalar-api-client__toggle:after {\n  content: '';\n  position: absolute;\n  bottom: -6.5px;\n  width: 100%;\n  height: 6px;\n  left: 0;\n}\n.scalar-api-client__item--open .scalar-api-client__toggle:after {\n  display: none;\n}\n.scalar-api-client__item:hover,\n.scalar-api-client__item--open {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n}\n.scalar-api-client__item--open .scalar-api-client__item__content {\n  display: flex;\n}\n.scalar-api-client__item--open:hover {\n  cursor: default;\n}\n.scalar-api-client__item--open .scalar-api-client__toggle__icon {\n  transform: rotate(90deg);\n}\n.scalar-api-client__toggle {\n  padding: 6px;\n  min-height: 37px;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  position: relative;\n  width: 100%;\n  appearance: none;\n  outline: 0;\n  border: none;\n  font-family: (--theme-font, var(--default-theme-font));\n  cursor: pointer;\n}\n.scalar-api-client__item .scalar-api-client__item__title {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  font-size: var(--theme-small, var(--default-theme-small));\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  font-family: (--theme-font, var(--default-theme-font));\n  user-select: none;\n  flex: 1;\n  position: relative;\n  z-index: 1;\n}\n.scalar-api-client__item .scalar-api-client__toggle__icon {\n  width: 10px;\n  margin-right: 6px;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  z-index: 1;\n  position: relative;\n}\n.scalar-api-client__toggle:hover .scalar-api-client__toggle__icon {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.scalar-api-client__item__options {\n  position: relative;\n  z-index: 1;\n}\n.scalar-api-client__item__options span {\n  background: transparent;\n  padding: 2px 0;\n  border-radius: 3px;\n  font-size: var(--theme-small, var(--default-theme-small));\n  pointer-events: none;\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n.scalar-api-client__item__options:hover span {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  border-color: currentColor;\n}\n.scalar-api-client__item__options span svg {\n  width: 15px;\n  height: 15px;\n  margin-left: 3px;\n}\n.scalar-api-client__item__options select {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  opacity: 0;\n  cursor: pointer;\n  -moz-appearance: none;\n  -webkit-appearance: none;\n  appearance: none;\n}\n.scalar-api-client__item__content .scalar-api-client__codemirror__wrapper {\n  padding-top: 0;\n}\n\n.table {\n  border: 1px solid var(--theme-border-color, var(--default-theme-border-color));\n  background: transparent;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  width: 100%;\n}\n.table-row {\n  border-bottom: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  display: flex;\n  position: relative;\n}\n.table-row__add {\n  border-radius: 0 0 var(--theme-radius-lg, var(--default-theme-radius-lg))\n    var(--theme-radius-lg, var(--default-theme-radius-lg));\n  border-bottom: none;\n}\n.table-row.required-parameter .table-row-item:nth-of-type(2):after {\n  content: 'Required';\n  position: absolute;\n  top: 4px;\n  right: 0;\n  padding: 5px 9px 5px 6px;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  background: var(--theme-background-2, var(--default-theme-background-2));\n  box-shadow: -2px 0 4px\n    var(--theme-background-2, var(--default-theme-background-2));\n}\n.table-row.required-parameter\n  .table-row-item:nth-of-type(2):focus-within:after {\n  display: none;\n}\n.table-row:last-of-type {\n  border-bottom: none;\n}\n.table-row__active {\n  border-radius: 0 0 var(--theme-radius-lg, var(--default-theme-radius-lg))\n    var(--theme-radius-lg, var(--default-theme-radius-lg));\n}\n.table-row-drag {\n  width: 20px;\n  flex-shrink: 0;\n  border-right: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  align-items: center;\n  justify-content: center;\n  display: none;\n}\n.table-row-drag svg {\n  width: 6px;\n  fill: var(--theme-color-3, var(--default-theme-color-3));\n}\n.table-row-drag .table-row-drag-add {\n  width: 8px;\n}\n.table-row-item {\n  width: 100%;\n  border-right: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  position: relative;\n}\n.table-row-item-menu {\n  position: absolute;\n  right: 6px;\n  background: var(--theme-background-2, var(--default-theme-background-2));\n  width: 24px;\n  height: 24px;\n  top: 50%;\n  transform: translate3d(0, -50%, 0);\n  border-radius: 50%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  opacity: 0;\n  cursor: pointer;\n}\n.table-row-item input:focus + .table-row-item-menu,\n.table-row-item:hover .table-row-item-menu {\n  opacity: 1;\n}\n.table-row-item-menu svg {\n  height: 12px;\n  width: initial;\n  fill: var(--theme-color-3, var(--default-theme-color-3));\n}\n.table-row-item-menu:hover svg {\n  fill: var(--theme-color-1, var(--default-theme-color-1));\n}\n.table-row-item input {\n  border: none;\n  appearance: none;\n  outline: none;\n  padding: 9px;\n  width: 100%;\n  min-height: 100%;\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  background: transparent;\n  font-family: var(--theme-font, var(--default-theme-font));\n}\n.table-row-item input[disabled] {\n  background: transparent;\n  font-family: var(--theme-font-code, var(--default-theme-font-code));\n}\n.table-row-item input:focus {\n  box-shadow: 0 0 0 1px var(--theme-color-1, var(--default-theme-color-1));\n}\n.table-row-item label {\n  background: transparent;\n  text-transform: uppercase;\n  display: block;\n  padding: 9px;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n}\n.table-row-meta {\n  overflow: hidden;\n  flex-shrink: 0;\n  transition: all 0.15s ease-in-out;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  width: 51px;\n  user-select: none;\n}\n.table-row-meta-check {\n  width: 18px;\n  height: 18px;\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n  background: rgba(47, 177, 228, 0.1);\n}\n.table-row-meta svg {\n  width: 13px;\n  height: 13px;\n  margin: 0 1px;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  cursor: pointer;\n}\n.table-row-meta svg:hover {\n  color: var(--theme-color-2, var(--default-theme-color-2));\n}\n.meta-check {\n  display: flex;\n  position: relative;\n  cursor: pointer;\n  align-items: center;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n  user-select: none;\n  margin: 0 1px;\n  transition: all 0.15s ease-in-out;\n}\n.meta-check input {\n  position: absolute;\n  opacity: 0;\n  cursor: pointer;\n  height: 0;\n  width: 0;\n}\n.meta-checkmark {\n  height: 17px;\n  width: 17px;\n  background: var(--theme-background-3, var(--default-theme-background-3));\n  border-radius: 3px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  position: relative;\n}\n.meta-checkmark:hover {\n  background: var(--theme-background-3, var(--default-theme-background-3));\n}\n.meta-check:focus-within .meta-checkmark {\n  box-shadow: 0 0 0 1px var(--theme-color-1, var(--default-theme-color-1));\n}\n.meta-check .meta-checkmark:after {\n  content: '';\n  display: none;\n  width: 5px;\n  height: 8px;\n  border: solid var(--theme-color-1, var(--default-theme-color-1));\n  border-width: 0 1.5px 1.5px 0;\n  transform: rotate(45deg) translate3d(0, -1px, 0);\n}\n.meta-check input:checked ~ .meta-checkmark:after {\n  display: block;\n}\n.meta-check input:checked ~ .meta-checkmark:hover {\n  background: transparent;\n}\n\n.navtable {\n  width: 100%;\n}\n.navtable-follow {\n  background-color: black;\n  color: white;\n  font-size: 9px;\n  padding: 6px;\n  display: -webkit-box;\n  max-width: 250px;\n  -webkit-line-clamp: 12;\n  border-radius: 3px;\n  -webkit-box-orient: vertical;\n  overflow: hidden;\n  line-height: 1.24;\n  transform: translate3d(10px, 0, 0);\n}\n.navtable-follow:after {\n  content: '';\n  position: absolute;\n  bottom: 0;\n  width: 100%;\n  height: 6px;\n  background-color: black;\n}\n.navtable-follow * {\n  font-family: var(\n    --theme-font-code,\n    var(--default-theme-font-code)\n  ) !important;\n}\n.navtable-table {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  min-height: 389px;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  border: 1px solid var(--theme-border-color, var(--default-theme-border-color));\n}\n.navtable-radios {\n  z-index: 1;\n  border-top: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n}\n.navtable-item {\n  display: flex;\n  position: relative;\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  border-top: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n}\n.navtable-item:first-of-type {\n  border-top: none;\n}\n.navtable-item > div {\n  word-wrap: break-word;\n}\n.navtable-item > div:not(:first-child) {\n  border-left: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n}\n.navtable-item-action {\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  font-weight: var(--theme-bold, var(--default-theme-bold));\n  background: var(\n    --scalar-api-client-bg3,\n    var(--default-scalar-api-client-bg3)\n  );\n  border: none;\n  border-radius: 30px;\n  appearance: none;\n  max-height: 25px;\n  margin-left: 12px;\n  margin-right: 6px;\n  padding: 4px 8px;\n  outline: none;\n  cursor: pointer;\n  opacity: 0;\n  transition: opacity 0.15s ease-in-out;\n  white-space: nowrap;\n  position: relative;\n}\n.navtable-item-action:hover {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  background: var(\n    --scalar-api-client-gradient,\n    var(--default-scalar-api-client-gradient)\n  );\n  box-shadow: 0 0 0 1px\n    var(--theme-border-color, var(--default-theme-border-color));\n}\n.navtable-item-action:focus {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n}\n.navtable-item:hover,\n.navtable-item:focus-within .navtable-item-action {\n  opacity: 1;\n}\n.navtable-item-add {\n  display: flex;\n  align-items: center;\n  padding: 9px;\n  font-weight: var(--theme-bold, var(--default-theme-bold));\n  outline: none;\n  border: none;\n  appearance: none;\n  background: transparent;\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.navtable-item-add:hover {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n  cursor: pointer;\n}\n.navtable-item-25 {\n  width: 25%;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  display: flex;\n  align-items: center;\n}\n.navtable-item-33 {\n  width: 33.33333%;\n  display: flex;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  align-items: center;\n}\n.navtable-item-66 {\n  width: 66.6666%;\n  display: flex;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  align-items: center;\n}\n.navtable-item-75 {\n  width: 75%;\n  display: flex;\n  align-items: center;\n}\n.navtable-item-75:focus-within {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n}\n.navtable-item-40 {\n  width: 40%;\n  display: flex;\n  align-items: center;\n  padding: 9px;\n}\n.navtable-item-20 {\n  width: 20%;\n  display: flex;\n  align-items: center;\n  padding: 9px;\n}\n.navtable-item-50 {\n  width: 50%;\n  display: flex;\n  align-items: center;\n}\n.navtable-item-50:focus-within {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n}\n.navtable-item p {\n  padding: 9px;\n}\n.navtable-item input {\n  padding: 12px 6px;\n  border: none;\n  outline: none;\n  appearance: none;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  background: transparent;\n  width: 100%;\n}\n.navtable-item input:focus {\n  background: var(--theme-background-2, var(--default-theme-background-2));\n}\n.navtable-item-select {\n  position: relative;\n}\n.navtable-item-select select {\n  background: transparent;\n  outline: none;\n  border: none;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  -moz-appearance: none;\n  -webkit-appearance: none;\n  appearance: none;\n  width: 100%;\n  padding: 12px 6px;\n  top: 0;\n  position: relative;\n  cursor: pointer;\n  color: var(--theme-color-2, var(--default-theme-color-2));\n}\n.navtable-item-select svg {\n  position: absolute;\n  right: 6px;\n  color: var(--theme-color-ghost, var(--default-theme-color-ghost));\n  width: 6px;\n  top: 12px;\n  pointer-events: none;\n}\n.navtable-item .option {\n  padding: 12px 6px;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  width: 100%;\n}\n.navtable-item label {\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  text-transform: uppercase;\n  display: block;\n  width: 100%;\n}\n.navtable-item-response {\n  padding: 0 9px;\n}\n.navtable-item-response span {\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  display: flex;\n  align-items: center;\n  margin-right: 9px;\n  min-width: 40px;\n}\n.scalar-api-client__status--1xx:before,\n.scalar-api-client__status--2xx:before,\n.scalar-api-client__status--3xx:before,\n.scalar-api-client__status--4xx:before,\n.scalar-api-client__status--5xx:before,\n.scalar-api-client__status--6xx:before {\n  content: '';\n  width: 10px;\n  height: 10px;\n  border-radius: 50%;\n  margin-right: 4px;\n  background: var(--theme-background-2, var(--default-theme-background-2));\n}\n.scalar-api-client__status--2xx:before {\n  background: var(--theme-color-green, var(--default-theme-color-green));\n}\n.scalar-api-client__status--3xx:before {\n  background: var(--theme-color-orange, var(--default-theme-color-orange));\n}\n.scalar-api-client__status--4xx:before {\n  background: var(--theme-color-red, var(--default-theme-color-red));\n}\n.navtable-item-response span:empty {\n  display: none;\n}\n.simpletable.navtable {\n  padding: 0;\n}\n.simpletable.navtable .navtable-item-66,\n.simpletable.navtable .navtable-item-33 {\n  display: block;\n}\n.simpletable.navtable .navtable-table {\n  height: fit-content;\n}\n.meta-delete {\n  position: absolute;\n  right: -9px;\n  background: var(\n    --theme-background-3,\n    var(--default-theme-background-3)\n  ) !important;\n  height: 20px;\n  width: 20px;\n  border: none;\n  outline: none;\n  border-radius: 50%;\n  opacity: 0;\n  padding: 5px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  cursor: pointer;\n}\n.meta-delete svg {\n  width: 11px;\n  height: 11px;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n}\n.meta-delete:hover svg {\n  color: var(--theme-color-red, var(--default-theme-color-red));\n}\n.meta-delete:focus svg {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.meta-delete:focus {\n  border-color: var(--theme-color-1, var(--default-theme-color-1));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.table-row:hover .meta-delete {\n  opacity: 1;\n}\n@media (pointer: coarse) {\n.table-row:hover .meta-delete {\n    opacity: 1;\n}\n}\n.meta-actions-item {\n  border: none;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  appearance: none;\n  padding: 9px;\n  width: 100%;\n  appearance: none;\n  outline: none;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  font-family: var(--theme-font, var(--default-theme-font));\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  gap: 6px;\n}\n.meta-actions {\n  width: 100%;\n  display: flex;\n  justify-content: space-between;\n}\n.meta-actions-item:nth-of-type(2) {\n  display: flex;\n  justify-content: flex-end;\n}\n.meta-actions-item:nth-of-type(2) i {\n  filter: drop-shadow(0 0.125px 0 currentColor)\n    drop-shadow(0 -0.125px 0 currentColor);\n}\n.meta-actions-item-icon {\n  width: 12px;\n  height: 12px;\n}\n.meta-actions-item:hover,\n.meta-actions-item:focus {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n\n.scalar-api-client-add {\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  padding: 6px;\n  width: fit-content;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  cursor: pointer;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  text-decoration: none;\n  margin: 0 6px;\n  border: none;\n  font-family: var(--theme-font);\n  appearance: none;\n  display: flex;\n  align-items: center;\n}\n.scalar-api-client-add svg {\n  width: 12px;\n  height: 12px;\n  margin-right: 6px;\n}\n.scalar-api-client-add:hover {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.scalar-api-client-add:focus-within {\n  background: var(--theme-background-3, var(--default-theme-background-3));\n}\n\n.scalar-api-client__main__left {\n  width: 50%;\n  border-right: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  padding: 0 18px 12px 18px;\n}\n@media screen and (max-width: 820px) {\n.scalar-api-client__main__left {\n    width: 100%;\n    border-right: none;\n    padding: 0 12px 12px 12px;\n}\n}\n.scalar-api-client__item__content {\n  flex-flow: wrap;\n  padding: 3px 9px 9px 9px;\n  border-radius: 3px;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  margin-top: -3px;\n  justify-content: space-between;\n  overflow: auto;\n}\n.scalar-api-client__item__content .scalar-api-client__codemirror__wrapper {\n  width: 100%;\n  min-height: 63px;\n}\n.scalar-api-client__item__content .scalar-codeblock-pre,\n.scalar-api-client__item__content .cm-s-default {\n  border: 1px solid var(--theme-border-color, var(--default-theme-border-color));\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n}\n.scalar-api-client__item__content .scalar-codeblock-pre,\n.scalar-api-client__item__content .codemirror-container {\n  width: 100%;\n  max-height: calc(100vh - 300px);\n  overflow: auto;\n}\n.scalar-api-client__item__content .cm-scroller {\n  border: 1px solid var(--theme-border-color, var(--default-theme-border-color));\n  border-radius: 3px;\n}\n.scalar-api-client__item__content .cm-editor {\n  outline: none !important;\n}\n.scalar-api-client__item__content .cm-editor .cm-gutters {\n  background: transparent;\n}\n.scalar-api-client__item__content .cm-scroll {\n  background: transparent;\n}\n.scalar-api-client__item__content .cm-editor * {\n  font-size: var(--theme-micro, var(--default-theme-micro));\n}\n.scalar-api-client__item__content .cm-editor .cm-line {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.scalar-api-client__item__content-button {\n  appearance: none;\n  border: none;\n  outline: none;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  background: var(\n    --scalar-api-client-color,\n    var(--default-scalar-api-client-color)\n  ) !important;\n  text-align: center;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  font-family: var(--theme-font, var(--default-theme-font));\n  padding: 6px;\n  width: fit-content;\n  margin: 3px 3px 3px auto;\n  text-transform: uppercase;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  color: white;\n  cursor: pointer;\n  text-align: center !important;\n  position: relative;\n}\n.scalar-api-client__item__content-button span {\n  position: relative;\n}\n.scalar-api-client__item__content-button:before {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  pointer-events: none;\n  cursor: pointer;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  background: linear-gradient(rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 0.2));\n}\n.scalar-api-client__item__content-button:hover:before {\n  background: linear-gradient(rgba(0, 0, 0, 0.2), rgba(0, 0, 0, 0.1));\n}\n.scalar-api-client__item__content__split {\n  justify-content: space-between;\n}\n.scalar-collapsible-section-flex {\n  width: 100%;\n}\n.input {\n  background: transparent;\n  position: relative;\n  width: 100%;\n  text-align: left;\n  display: flex;\n  box-shadow: 0 1px 0\n    var(--theme-border-color, var(--default-theme-border-color));\n}\n.input:focus-within {\n  box-shadow: 0 0 0 1px var(--theme-color-1, var(--default-theme-color-1)) !important;\n  z-index: 10;\n}\n.input:first-of-type {\n  border-radius: var(--theme-radius, var(--default-theme-radius))\n    var(--theme-radius, var(--default-theme-radius)) 0 0;\n}\n.input:first-child:last-child {\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n}\n.input:last-child {\n  box-shadow: none;\n  border-radius: 0 0 var(--theme-radius, var(--default-theme-radius))\n    var(--theme-radius, var(--default-theme-radius));\n}\n.input__half:first-of-type {\n  border-radius: var(--theme-radius, var(--default-theme-radius)) 0 0 0;\n}\n.input__half:nth-of-type(2) {\n  border-radius: 0 var(--theme-radius, var(--default-theme-radius)) 0 0;\n}\n.authentication-form {\n  box-shadow: 0 0 0 1px\n    var(--theme-border-color, var(--default-theme-border-color));\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  width: 100%;\n  display: flex;\n  flex-flow: wrap;\n}\n.input__half {\n  width: 50%;\n}\n.input__half + .input__half {\n  border-left: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n}\n.input__half:focus-within {\n  border-color: transparent;\n}\n.input label,\n.input input {\n  padding: 9px;\n  border: 0;\n  outline: none;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  width: 100%;\n  background: transparent;\n  appearance: none;\n  -webkit-appearance: none;\n  left: 0;\n}\n.input label {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  width: fit-content;\n  padding-right: 0;\n  white-space: nowrap;\n  cursor: text;\n}\n.input input {\n  position: relative;\n  z-index: 99;\n}\n.input input:not(:placeholder-shown) + label {\n  color: var(--theme-color-2, var(--default-theme-color-2));\n}\n.select {\n  background: --theme-background-1;\n  border-radius: var(--theme-radius-lg, var(--default-theme-radius-lg));\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  border: 1px solid var(--theme-border-color, var(--default-theme-border-color));\n  width: 100%;\n  position: relative;\n  margin-bottom: 6px;\n}\n.select:focus-within {\n  background: var(--theme-background-3, var(--default-theme-background-3));\n}\n.select:hover {\n  background: var(--theme-background-3, var(--default-theme-background-3));\n}\n.select svg {\n  position: absolute;\n  right: 9px;\n  pointer-events: none;\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  width: 6px;\n  top: 10px;\n}\n.select label {\n  display: block;\n  font-size: 10px;\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  position: absolute;\n  left: 9px;\n  top: 6px;\n}\n.select select {\n  background: transparent;\n  outline: none;\n  border: none;\n  -moz-appearance: none;\n  -webkit-appearance: none;\n  appearance: none;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  width: 100%;\n  padding: 14px 9px 4px 9px;\n  top: 0;\n  position: relative;\n  cursor: pointer;\n}\n.check {\n  display: flex;\n  position: relative;\n  cursor: pointer;\n  align-items: center;\n  font-size: var(--theme-micro, var(--default-theme-micro));\n  padding: 6px 9px;\n  border-radius: 0 0 var(--theme-radius, var(--default-theme-radius))\n    var(--theme-radius, var(--default-theme-radius));\n  user-select: none;\n  width: 100%;\n  outline: none;\n}\n.check:focus-within {\n  box-shadow: 0 0 0 1px var(--theme-color-1, var(--default-theme-color-1));\n}\n.checkmark:hover {\n  background: var(--theme-background-3, var(--default-theme-background-3));\n}\n.check:focus-within {\n  border-color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.check p {\n  color: var(--theme-color-3, var(--default-theme-color-3));\n}\n.check input {\n  position: absolute;\n  opacity: 0;\n  cursor: pointer;\n  height: 0;\n  width: 0;\n}\n.checkmark {\n  height: 17px;\n  width: 17px;\n  background: var(--theme-background-3, var(--default-theme-background-3));\n  margin-right: 10px;\n  border-radius: 3px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  position: relative;\n}\n.check input:checked ~ p {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.check .checkmark:after {\n  content: '';\n  display: none;\n  width: 5px;\n  height: 8px;\n  border: solid var(--theme-color-1, var(--default-theme-color-1));\n  border-width: 0 1.5px 1.5px 0;\n  transform: rotate(45deg) translate3d(0, -1px, 0);\n}\n.check input:checked ~ .checkmark:after {\n  display: block;\n}\n.scalar-api-client__main__scroll-container {\n  height: calc(100vh - 320px);\n}\n.scalar-api-client__request-name {\n  outline: none;\n  border: none;\n  appearance: none;\n  -webkit-appearance: none;\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  font-size: var(--theme-small, var(--default-theme-small));\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  width: 100%;\n  padding: 0;\n  background: transparent;\n  font-family: var(--theme-font, var(--default-theme-font));\n}\n.scalar-api-client__request-name::-webkit-input-placeholder {\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n}\n.scalar-api-client__request-name:-ms-input-placeholder {\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n}\n.scalar-api-client__request-name::placeholder {\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n}\n\na[data-v-ffc7287f] {\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  text-decoration: underline;\n  text-decoration-color: var(\n    --theme-border-color,\n    var(--default-theme-border-color)\n  );\n  text-underline-offset: 2px;\n  cursor: help;\n}\n\n.simple-cell[data-v-b99d5e90] {\n  all: unset;\n  display: table-cell;\n  border-right: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n  position: relative;\n  padding: 9px !important;\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  white-space: nowrap;\n}\n.simple-cell a[data-v-b99d5e90] {\n  color: var(--theme-color-1, var(--default-theme-color-1)) !important;\n}\n.simple-cell[data-v-b99d5e90]:last-of-type {\n  border-right: none;\n}\n.simple-cell.wrap[data-v-b99d5e90] {\n  white-space: normal;\n}\n.simple-cell.strong[data-v-b99d5e90] {\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n}\n\n.simple-header[data-v-6bd3700b] {\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  text-transform: uppercase;\n}\n\n.simple-row[data-v-e7e681a1] {\n  all: unset;\n  display: table-row;\n  box-shadow: 0 -1px var(--theme-border-color, var(--default-theme-border-color));\n}\n.simple-row[data-v-e7e681a1]:first-of-type {\n  box-shadow: none;\n}\n\n.simple-table[data-v-8f53a32f] {\n  all: unset;\n  display: table;\n  width: 100%;\n  border-spacing: 0;\n  box-shadow: 0 0 0 1px\n    var(--theme-border-color, var(--default-theme-border-color));\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n}\n\n.scalar-api-client__main__right {\n  width: 50%;\n  padding: 0 18px 12px 18px;\n}\n@media screen and (max-width: 820px) {\n.scalar-api-client__main__right {\n    width: 100%;\n    border-right: none;\n    padding: 0 12px 12px 12px;\n}\n}\n.scalar-api-client__main__right :deep(.scalar-copilot__header-button) {\n  position: absolute;\n  top: 6px;\n  right: 12px;\n}\n\n.scalar-api-client,\n#headlessui-portal-root {\n  background: var(--theme-background-1, var(--default-theme-background-1));\n  position: relative;\n  height: 100%;\n  overflow: hidden !important;\n  display: flex;\n  flex-direction: column;\n  font-family: var(--theme-font, var(--default-theme-font));\n\n  /** Make sure box-sizing is set properly. */\n  box-sizing: border-box;\n*,\n  *:before,\n  *:after {\n    box-sizing: inherit;\n}\n}\n.scalar-api-client {\n  flex: 1;\n  max-height: 100vh;\n}\n@media screen and (max-width: 1000px) {\n.scalar-api-client {\n    width: 100%;\n}\n}\n.scalar-api-client pre {\n  font-family: var(--theme-font-code, var(--default-theme-font-code));\n}\n.scalar-api-client__mobile-navigation {\n  padding: 12px 12px 0 12px;\n  display: flex;\n  font-size: var(--theme-small, var(--default-theme-small));\n  color: var(--theme-color-2, var(--default-theme-color-2));\n  font-weight: var(--theme-bold, var(--default-theme-bold));\n}\n.scalar-api-client__mobile-navigation__toggle {\n  appearance: none;\n  border: none;\n  outline: none;\n  background: transparent;\n  font-size: var(--theme-font-size-2);\n  color: var(--theme-color-2);\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  font-family: var(--theme-font, var(--default-theme-font));\n  padding: 0;\n  margin-right: 9px;\n  cursor: pointer;\n}\n.scalar-api-client__mobile-navigation--active {\n  color: var(--theme-color-1, var(--default-theme-color-1));\n}\n.scalar-api-client__mobile-navigation--active:hover {\n  cursor: pointer;\n}\n.scalar-api-client__main {\n  display: flex;\n  height: 100%;\n  min-height: 0;\n  background: var(--theme-background-1, var(--default-theme-background-1));\n  border-top: 1px solid\n    var(--theme-border-color, var(--default-theme-border-color));\n}\n@media screen and (max-width: 820px) {\n.scalar-api-client__main {\n    flex-direction: column;\n}\n}\n\n/** TODO: Consider to make a Column component */\n.scalar-api-client__main__content {\n  padding: 12px 6px;\n  background: var(--theme-background-1, var(--default-theme-background-1));\n  top: 0;\n  position: sticky;\n  z-index: 100;\n}\n.scalar-api-client__main__content label {\n  font-size: var(--theme-small, var(--default-theme-small));\n  color: var(--theme-color-1, var(--default-theme-color-1));\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  display: flex;\n  align-items: center;\n}\n@media screen and (max-width: 820px) {\n.scalar-api-client__main__content {\n    padding: 3px 0 12px 0;\n}\n.scalar-api-client__main__content label {\n    display: none;\n}\n}\n.meta {\n  display: flex;\n  margin-top: 3px;\n  font-size: var(--theme-font-size-2, var(--default-theme-font-size-2));\n  font-weight: var(--theme-font-size-2, var(--default-theme-font-size-2));\n  color: var(\n    --scalar-api-client-color2,\n    var(--default-scalar-api-client-color2)\n  );\n}\n.meta-item svg {\n  fill: var(--theme-color-ghost, var(--default-theme-color-ghost));\n  height: 14px;\n  width: 14px;\n  margin-right: 6px;\n}\n.meta-item {\n  display: flex;\n  align-items: center;\n  margin-right: 12px;\n  white-space: nowrap;\n  font-weight: var(--theme-semibold, var(--default-theme-semibold));\n  font-size: var(--theme-small, var(--default-theme-small));\n  color: var(--theme-color-3, var(--default-theme-color-3));\n  min-height: 17px;\n}\n.meta-item__input {\n  background: transparent;\n  width: 100%;\n  margin-right: 0;\n}\n.types {\n  margin: auto;\n  width: 580px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex-flow: wrap;\n}\n.types-heading {\n  width: 100%;\n  text-align: center;\n}\n.types-heading b {\n  font-size: 42px;\n}\n.types-heading p {\n  margin-bottom: 20px;\n  margin-top: 12px;\n  font-size: 24px;\n}\n.scalar-api-client__empty-state {\n  border: 1px dashed\n    var(--theme-border-color, var(--default-theme-border-color));\n  width: 100%;\n  text-align: center;\n  border-radius: var(--theme-radius, var(--default-theme-radius));\n  font-size: var(--theme-small, var(--default-theme-small));\n  min-height: 58px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}"));
        document.head.appendChild(elementStyle);
      }
    } catch (e2) {
      console.error("vite-plugin-css-injected-by-js", e2);
    }
  })();
  var __defProp = Object.defineProperty;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __publicField = (obj, key, value) => {
    __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
    return value;
  };
  const alternateTheme = "/* basic theme */\n.light-mode,\n.light-mode .dark-mode {\n  --default-theme-background-1: #f9f9f9;\n  --default-theme-background-2: #f1f1f1;\n  --default-theme-background-3: #e7e7e7;\n  --default-theme-background-card: #fff;\n\n  --default-theme-color-1: #2a2f45;\n  --default-theme-color-2: #757575;\n  --default-theme-color-3: #8e8e8e;\n\n  --default-theme-color-accent: var(--default-theme-color-1);\n  --default-theme-background-accent: var(--default-theme-background-3);\n\n  --default-theme-border-color: rgba(0, 0, 0, 0.1);\n  --default-theme-code-languages-background-supersede: var(\n    --default-theme-background-1\n  );\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n.dark-mode {\n  --default-theme-background-1: #131313;\n  --default-theme-background-2: #1d1d1d;\n  --default-theme-background-3: #272727;\n  --default-theme-background-card: #1d1d1d;\n\n  --default-theme-color-1: rgba(255, 255, 255, 0.9);\n  --default-theme-color-2: rgba(255, 255, 255, 0.62);\n  --default-theme-color-3: rgba(255, 255, 255, 0.44);\n\n  --default-theme-color-accent: var(--default-theme-color-1);\n  --default-theme-background-accent: var(--default-theme-background-3);\n\n  --default-theme-border-color: rgba(255, 255, 255, 0.1);\n  --default-theme-code-languages-background-supersede: var(\n    --default-theme-background-3\n  );\n  --default-theme-code-language-color-supersede: var(--default-theme-color-3);\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-border-color: var(--default-theme-border-color);\n\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-hover-color: currentColor;\n\n  --default-sidebar-item-active-background: var(\n    --default-theme-background-accent\n  );\n  --default-sidebar-color-active: var(--default-theme-color-accent);\n\n  --default-sidebar-search-background: transparent;\n  --default-sidebar-search-color: var(--default-theme-color-3);\n  --default-sidebar-search-border-color: var(--default-theme-border-color);\n}\n/* advanced */\n.light-mode {\n  --default-theme-color-green: #069061;\n  --default-theme-color-red: #ef0006;\n  --default-theme-color-yellow: #edbe20;\n  --default-theme-color-blue: #0082d0;\n  --default-theme-color-orange: #fb892c;\n  --default-theme-color-purple: #5203d1;\n}\n.dark-mode {\n  --default-theme-color-green: #00b648;\n  --default-theme-color-red: #dd2f2c;\n  --default-theme-color-yellow: #ffc90d;\n  --default-theme-color-blue: #4eb3ec;\n  --default-theme-color-orange: #ff8d4d;\n  --default-theme-color-purple: #b191f9;\n}\n\n.code-languages-background:before {\n  box-shadow: inset 0 0 0 1px var(--default-theme-border-color) !important;\n}\n.scalar-api-client__item,\n.scalar-card,\n.dark-mode .dark-mode.scalar-card {\n  --default-theme-background-1: var(--default-theme-background-card);\n  --default-theme-background-2: var(--default-theme-background-1);\n  --default-theme-background-3: var(--default-theme-background-1);\n}\n.dark-mode .dark-mode.scalar-card {\n  --default-theme-background-3: var(--default-theme-background-3);\n}\n.dark-mode .show-api-client-button span,\n.dark-mode .show-api-client-button svg {\n  color: var(--default-theme-background-3);\n}\n.dark-mode .show-api-client-button {\n  background: var(--default-theme-color-1) !important;\n}\n.t-doc__sidebar {\n  --default-theme-color-green: var(--default-theme-color-1);\n  --default-theme-color-red: var(--default-theme-color-1);\n  --default-theme-color-yellow: var(--default-theme-color-1);\n  --default-theme-color-blue: var(--default-theme-color-1);\n  --default-theme-color-orange: var(--default-theme-color-1);\n  --default-theme-color-purple: var(--default-theme-color-1);\n}\n.download-cta a,\n.references-rendered .markdown a {\n  color: var(--default-theme-color-1) !important;\n  text-decoration: underline !important;\n}\n";
  const bluePlanetTheme = "/* basic theme */\n.light-mode {\n  --default-theme-background-1: #f0f2f5;\n  --default-theme-background-2: #eaecf0;\n  --default-theme-background-3: #e0e2e6;\n  --default-theme-border-color: rgb(228, 228, 231);\n\n  --default-theme-color-1: rgb(9, 9, 11);\n  --default-theme-color-2: rgb(113, 113, 122);\n  --default-theme-color-3: rgba(25, 25, 28, 0.5);\n\n  --default-theme-color-accent: var(--default-theme-color-1);\n  --default-theme-background-accent: #8ab4f81f;\n\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n.light-mode .scalar-card.dark-mode,\n.dark-mode {\n  --default-theme-background-1: #000e23;\n  --default-theme-background-2: #01132e;\n  --default-theme-background-3: #03193b;\n  --default-theme-border-color: rgba(255, 255, 255, 0.12);\n\n  --default-theme-color-1: #fafafa;\n  --default-theme-color-2: rgb(161, 161, 170);\n  --default-theme-color-3: rgba(255, 255, 255, 0.533);\n\n  --default-theme-color-accent: var(--default-theme-color-1);\n  --default-theme-background-accent: #8ab4f81f;\n\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --default-sidebar-background-1: transparent;\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-border-color: var(--default-theme-border-color);\n\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-hover-color: currentColor;\n\n  --default-sidebar-item-active-background: var(--default-theme-background-3);\n  --default-sidebar-color-active: var(--default-theme-color-accent);\n\n  --default-sidebar-search-background: rgba(255, 255, 255, 0.1);\n  --default-sidebar-search-border-color: var(--default-theme-border-color);\n  --default-sidebar-search-color: var(--default-theme-color-3);\n  z-index: 1;\n}\n.light-mode .t-doc__sidebar {\n  --default-sidebar-search-background: white;\n}\n/* advanced */\n.light-mode {\n  --default-theme-color-green: #069061;\n  --default-theme-color-red: #ef0006;\n  --default-theme-color-yellow: #edbe20;\n  --default-theme-color-blue: #0082d0;\n  --default-theme-color-orange: #fb892c;\n  --default-theme-color-purple: #5203d1;\n}\n.dark-mode {\n  --default-theme-color-green: rgba(69, 255, 165, 0.823);\n  --default-theme-color-red: #ff8589;\n  --default-theme-color-yellow: #ffcc4d;\n  --default-theme-color-blue: #6bc1fe;\n  --default-theme-color-orange: #f98943;\n  --default-theme-color-purple: #b191f9;\n}\n/* Custom theme */\n.show-api-client-button:before {\n  background: white !important;\n}\n.show-api-client-button span,\n.show-api-client-button svg {\n  color: black !important;\n}\n.download-cta,\n.references-rendered .markdown a {\n  text-decoration: underline !important;\n}\n/* Document header */\n@keyframes headerbackground {\n  from {\n    background: transparent;\n    backdrop-filter: none;\n  }\n  to {\n    background: var(--header-background-1);\n    backdrop-filter: blur(12px);\n  }\n}\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header,\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(\n    to right bottom,\n    rgb(255, 255, 255) 30%,\n    rgba(255, 255, 255, 0.38)\n  );\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n.code-languages-background {\n  background: var(--default-theme-background-1) !important;\n}\n.code-languages-background:before {\n  box-shadow: inset 0 0 0 2px var(--default-theme-border-color);\n  background: linear-gradient(\n    to right top,\n    rgb(211 225 249 / 12%),\n    rgb(209 223 247 / 11%),\n    rgb(223 233 251 / 29%)\n  ) !important;\n}\n.light-mode .code-languages-background:before {\n  background: linear-gradient(\n    to right top,\n    rgb(0 0 0 / 8%),\n    rgb(0 0 0 / 7%),\n    rgb(0 0 0 / 19%)\n  ) !important;\n}\n.code-languages__active .code-languages-background:before {\n  background: var(--default-theme-background-1) !important;\n}\n.sidebar-heading-type {\n  color: var(--default-theme-background-1) !important;\n}\n.active_page .sidebar-heading-type {\n  color: var(--default-sidebar-color-1) !important;\n}\n.sidebar-heading-type:after {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  background: linear-gradient(\n    9deg,\n    var(--default-theme-background-1),\n    transparent\n  );\n  border-radius: 30px;\n  opacity: 0.3;\n}\n.code-languages span {\n  margin-top: 5px !important;\n}\n/* Hero Section Flare */\n.section-flare-item:nth-of-type(1) {\n  --c1: #ffffff;\n  --c2: #babfd8;\n  --c3: #2e8bb2;\n  --c4: #1a8593;\n  --c5: #0a143e;\n  --c6: #0a0f52;\n  --c7: #2341b8;\n\n  --solid: var(--c1), var(--c2), var(--c3), var(--c4), var(--c5), var(--c6),\n    var(--c7);\n  --solid-wrap: var(--solid), var(--c1);\n  --trans: var(--c1), transparent, var(--c2), transparent, var(--c3),\n    transparent, var(--c4), transparent, var(--c5), transparent, var(--c6),\n    transparent, var(--c7);\n  --trans-wrap: var(--trans), transparent, var(--c1);\n\n  background: radial-gradient(circle, var(--trans)),\n    conic-gradient(from 180deg, var(--trans-wrap)),\n    radial-gradient(circle, var(--trans)), conic-gradient(var(--solid-wrap));\n  width: 70vw;\n  height: 700px;\n  border-radius: 50%;\n  filter: blur(100px);\n  z-index: 0;\n  right: 0;\n  position: absolute;\n  transform: rotate(-45deg);\n  top: -300px;\n  opacity: 0.3;\n}\n.section-flare-item:nth-of-type(3) {\n  --star-color: #6b9acc;\n  --star-color2: #446b8d;\n  --star-color3: #3e5879;\n  background-image: radial-gradient(\n      2px 2px at 20px 30px,\n      var(--star-color2),\n      rgba(0, 0, 0, 0)\n    ),\n    radial-gradient(2px 2px at 40px 70px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 50px 160px, var(--star-color3), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 90px 40px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 130px 80px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(\n      2px 2px at 160px 120px,\n      var(--star-color3),\n      rgba(0, 0, 0, 0)\n    );\n  background-repeat: repeat;\n  background-size: 200px 200px;\n  width: 100%;\n  height: 100%;\n  mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n}\n.section-flare {\n  top: -150px !important;\n  height: 100vh;\n  background: linear-gradient(#000, var(--default-theme-background-1));\n  width: 100vw;\n}\n.light-mode .section-flare {\n  display: none;\n}\n.light-mode .scalar-card {\n  --default-theme-background-1: #fff;\n  --default-theme-background-2: #fff;\n  --default-theme-background-3: #fff;\n}\n";
  const deepSpaceTheme = "/* basic theme */\n.light-mode {\n  --default-theme-color-1: rgb(9, 9, 11);\n  --default-theme-color-2: rgb(113, 113, 122);\n  --default-theme-color-3: rgba(25, 25, 28, 0.5);\n  --default-theme-color-accent: var(--default-theme-color-1);\n\n  --default-theme-background-1: #fff;\n  --default-theme-background-2: #f4f4f5;\n  --default-theme-background-3: #e3e3e6;\n  --default-theme-background-accent: #8ab4f81f;\n\n  --default-theme-border-color: rgb(228, 228, 231);\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n.dark-mode {\n  --default-theme-color-1: #fafafa;\n  --default-theme-color-2: rgb(161, 161, 170);\n  --default-theme-color-3: rgba(255, 255, 255, 0.533);\n  --default-theme-color-accent: var(--default-theme-color-1);\n\n  --default-theme-background-1: #09090b;\n  --default-theme-background-2: #18181b;\n  --default-theme-background-3: #2c2c30;\n  --default-theme-background-accent: #8ab4f81f;\n\n  --default-theme-border-color: rgba(255, 255, 255, 0.12);\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --sidebar-background-1: var(--default-theme-background-1);\n  --sidebar-item-hover-color: currentColor;\n  --sidebar-item-hover-background: var(--default-theme-background-2);\n  --sidebar-item-active-background: var(--default-theme-background-3);\n  --sidebar-border-color: var(--default-theme-border-color);\n  --sidebar-color-1: var(--default-theme-color-1);\n  --sidebar-color-2: var(--default-theme-color-2);\n  --sidebar-color-active: var(--default-theme-color-accent);\n  --sidebar-search-background: transparent;\n  --sidebar-search-border-color: var(--default-theme-border-color);\n  --sidebar-search-color: var(--default-theme-color-3);\n}\n.light-mode .t-doc__sidebar {\n  --sidebar-item-active-background: #09090b;\n  --sidebar-color-active: var(--sidebar-background-1);\n}\n/* advanced */\n.light-mode {\n  --default-theme-button-1: rgb(49 53 56);\n  --default-theme-button-1-color: #fff;\n  --default-theme-button-1-hover: rgb(28 31 33);\n\n  --default-theme-color-green: #069061;\n  --default-theme-color-red: #ef0006;\n  --default-theme-color-yellow: #edbe20;\n  --default-theme-color-blue: #0082d0;\n  --default-theme-color-orange: #fb892c;\n  --default-theme-color-purple: #5203d1;\n\n  --default-theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --default-theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n}\n.dark-mode {\n  --default-theme-button-1: #f6f6f6;\n  --default-theme-button-1-color: #000;\n  --default-theme-button-1-hover: #e7e7e7;\n\n  --default-theme-color-green: rgba(69, 255, 165, 0.823);\n  --default-theme-color-red: #ff8589;\n  --default-theme-color-yellow: #ffcc4d;\n  --default-theme-color-blue: #6bc1fe;\n  --default-theme-color-orange: #f98943;\n  --default-theme-color-purple: #b191f9;\n\n  --default-theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --default-theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n}\n/* Custom theme */\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header,\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(\n    to right bottom,\n    rgb(255, 255, 255) 30%,\n    rgba(255, 255, 255, 0.38)\n  );\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n.examples .scalar-card-footer {\n  --default-theme-background-3: transparent;\n  padding-top: 0;\n}\n.show-api-client-button:before {\n  background: white !important;\n}\n.show-api-client-button span,\n.show-api-client-button svg {\n  color: black !important;\n}\n.download-cta,\n.references-rendered .markdown a {\n  text-decoration: underline !important;\n}\n.code-languages-background {\n  background: var(--default-theme-background-1) !important;\n}\n.code-languages-background:before {\n  box-shadow: inset 0 0 0 2px var(--default-theme-border-color);\n  background: linear-gradient(\n    to right top,\n    rgb(211 225 249 / 12%),\n    rgb(209 223 247 / 11%),\n    rgb(223 233 251 / 29%)\n  ) !important;\n}\n.light-mode .code-languages-background:before {\n  background: linear-gradient(\n    to right top,\n    rgb(0 0 0 / 8%),\n    rgb(0 0 0 / 7%),\n    rgb(0 0 0 / 19%)\n  ) !important;\n}\n.code-languages__active .code-languages-background:before {\n  background: var(--default-theme-background-1) !important;\n}\n.sidebar-heading-type:after {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  background: linear-gradient(\n    9deg,\n    var(--default-theme-background-1),\n    transparent\n  );\n  border-radius: 30px;\n  opacity: 0.3;\n}\n.code-languages span {\n  margin-top: 5px !important;\n}\n/* Hero section flare */\n.section-flare {\n  width: 100vw;\n  height: 550px;\n  position: relative;\n}\n.section-flare-item:nth-of-type(1) {\n  position: absolute;\n  width: 100vw;\n  height: 550px;\n  --stripesDark: repeating-linear-gradient(\n    100deg,\n    #000 0%,\n    #000 7%,\n    transparent 10%,\n    transparent 12%,\n    #000 16%\n  );\n  --rainbow: repeating-linear-gradient(\n    100deg,\n    #fff 10%,\n    #fff 16%,\n    #fff 22%,\n    #fff 30%\n  );\n  background-image: var(--stripesDark), var(--rainbow);\n  background-size: 300%, 200%;\n  background-position:\n    50% 50%,\n    50% 50%;\n  filter: invert(100%);\n  -webkit-mask-image: radial-gradient(\n    ellipse at 100% 0%,\n    black 40%,\n    transparent 70%\n  );\n  mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n  pointer-events: none;\n  opacity: 0.07;\n}\n.dark-mode .section-flare-item:nth-of-type(1) {\n  background-image: var(--stripesDark), var(--rainbow);\n  filter: opacity(50%) saturate(200%);\n  opacity: 0.25;\n  height: 350px;\n}\n.section-flare-item:nth-of-type(1):after {\n  content: '';\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  background-image: var(--stripesDark), var(--rainbow);\n  background-size: 200%, 100%;\n  background-attachment: fixed;\n  mix-blend-mode: difference;\n}\n.dark-mode .section-flare:after {\n  background-image: var(--stripesDark), var(--rainbow);\n}\n.section-flare-item:nth-of-type(2) {\n  --star-color: #fff;\n  --star-color2: #fff;\n  --star-color3: #fff;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  background-image: radial-gradient(\n      2px 2px at 20px 30px,\n      var(--star-color2),\n      rgba(0, 0, 0, 0)\n    ),\n    radial-gradient(2px 2px at 40px 70px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 50px 160px, var(--star-color3), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 90px 40px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(2px 2px at 130px 80px, var(--star-color), rgba(0, 0, 0, 0)),\n    radial-gradient(\n      2px 2px at 160px 120px,\n      var(--star-color3),\n      rgba(0, 0, 0, 0)\n    );\n  background-repeat: repeat;\n  background-size: 200px 200px;\n  mask-image: radial-gradient(ellipse at 100% 0%, black 40%, transparent 70%);\n  opacity: 0.2;\n}\n";
  const defaultTheme = "/* basic theme */\n.light-mode {\n  --default-theme-background-1: #fff;\n  --default-theme-background-2: #f6f6f6;\n  --default-theme-background-3: #e7e7e7;\n  --default-theme-background-accent: #8ab4f81f;\n\n  --default-theme-color-1: #2a2f45;\n  --default-theme-color-2: #757575;\n  --default-theme-color-3: #8e8e8e;\n\n  --default-theme-color-accent: #0099ff;\n  --default-theme-border-color: rgba(0, 0, 0, 0.1);\n}\n.dark-mode {\n  --default-theme-background-1: #0f0f0f;\n  --default-theme-background-2: #1a1a1a;\n  --default-theme-background-3: #272727;\n\n  --default-theme-color-1: rgba(255, 255, 255, 0.9);\n  --default-theme-color-2: rgba(255, 255, 255, 0.62);\n  --default-theme-color-3: rgba(255, 255, 255, 0.44);\n\n  --default-theme-color-accent: #3ea6ff;\n  --default-theme-background-accent: #3ea6ff1f;\n\n  --default-theme-border-color: rgba(255, 255, 255, 0.1);\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-border-color: var(--default-theme-border-color);\n\n  --default-sidebar-item-hover-background: var(--default-theme-background-3);\n  --default-sidebar-item-hover-color: currentColor;\n\n  --default-sidebar-item-active-background: var(\n    --default-theme-background-accent\n  );\n  --default-sidebar-color-active: var(--default-theme-color-accent);\n\n  --default-sidebar-search-background: transparent;\n  --default-sidebar-search-color: var(--default-theme-color-3);\n  --default-sidebar-search-border-color: var(--default-theme-border-color);\n}\n\n/* advanced */\n.light-mode {\n  --default-theme-color-green: #069061;\n  --default-theme-color-red: #ef0006;\n  --default-theme-color-yellow: #edbe20;\n  --default-theme-color-blue: #0082d0;\n  --default-theme-color-orange: #fb892c;\n  --default-theme-color-purple: #5203d1;\n}\n.dark-mode {\n  --default-theme-color-green: #00b648;\n  --default-theme-color-red: #dc1b19;\n  --default-theme-color-yellow: #ffc90d;\n  --default-theme-color-blue: #4eb3ec;\n  --default-theme-color-orange: #ff8d4d;\n  --default-theme-color-purple: #b191f9;\n}\n";
  const keplerTheme = "/* basic theme */\n.light-mode {\n  --default-theme-color-1: #2a2f45;\n  --default-theme-color-2: #757575;\n  --default-theme-color-3: #8e8e8e;\n  --default-theme-color-accent: #7070ff;\n\n  --default-theme-background-1: #fff;\n  --default-theme-background-2: #f6f6f6;\n  --default-theme-background-3: #e7e7e7;\n  --default-theme-background-accent: #7070ff1f;\n\n  --default-theme-border-color: rgba(0, 0, 0, 0.1);\n\n  --default-theme-code-language-color-supersede: var(--default-theme-color-3);\n}\n.dark-mode {\n  --default-theme-color-1: #f7f8f8;\n  --default-theme-color-2: rgb(180, 188, 208);\n  --default-theme-color-3: #b4bcd099;\n  --default-theme-color-accent: #828fff;\n\n  --default-theme-background-1: #000212;\n  --default-theme-background-2: rgba(255, 255, 255, 0.05);\n  --default-theme-background-3: rgba(255, 255, 255, 0.05);\n  --default-theme-background-accent: #8ab4f81f;\n\n  --default-theme-border-color: #242537;\n  --default-theme-code-language-color-supersede: var(--default-theme-color-3);\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-item-hover-color: currentColor;\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-active-background: var(\n    --default-theme-background-accent\n  );\n  --default-sidebar-border-color: var(--default-theme-border-color);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-color-active: var(--default-theme-color-accent);\n  --default-sidebar-search-background: rgba(0, 0, 0, 0.05);\n  --default-sidebar-search-border-color: 1px solid rgba(0, 0, 0, 0.05);\n  --default-sidebar-search-color: var(--default-theme-color-3);\n  --default-theme-background-2: rgba(0, 0, 0, 0.03);\n}\n.dark-mode .t-doc__sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-item-hover-color: currentColor;\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-active-background: rgba(255, 255, 255, 0.1);\n  --default-sidebar-border-color: var(--default-theme-border-color);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-color-active: var(--default-theme-color-accent);\n  --default-sidebar-search-background: rgba(255, 255, 255, 0.1);\n  --default-sidebar-search-border-color: 1px solid rgba(255, 255, 255, 0.05);\n  --default-sidebar-search-color: var(--default-theme-color-3);\n}\n/* advanced */\n.light-mode {\n  --default-theme-button-1: rgb(49 53 56);\n  --default-theme-button-1-color: #fff;\n  --default-theme-button-1-hover: rgb(28 31 33);\n\n  --default-theme-color-green: #069061;\n  --default-theme-color-red: #ef0006;\n  --default-theme-color-yellow: #edbe20;\n  --default-theme-color-blue: #0082d0;\n  --default-theme-color-orange: #fb892c;\n  --default-theme-color-purple: #5203d1;\n\n  --default-theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --default-theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n}\n.dark-mode {\n  --default-theme-button-1: #f6f6f6;\n  --default-theme-button-1-color: #000;\n  --default-theme-button-1-hover: #e7e7e7;\n\n  --default-theme-color-green: #00b648;\n  --default-theme-color-red: #dc1b19;\n  --default-theme-color-yellow: #ffc90d;\n  --default-theme-color-blue: #4eb3ec;\n  --default-theme-color-orange: #ff8d4d;\n  --default-theme-color-purple: #b191f9;\n\n  --default-theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --default-theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n}\n/* Custom Theme */\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header,\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(\n    to right bottom,\n    rgb(255, 255, 255) 30%,\n    rgba(255, 255, 255, 0.38)\n  );\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n.sidebar-search {\n  backdrop-filter: blur(12px);\n}\n@keyframes headerbackground {\n  from {\n    background: transparent;\n    backdrop-filter: none;\n  }\n  to {\n    background: var(--header-background-1);\n    backdrop-filter: blur(12px);\n  }\n}\n.dark-mode .scalar-card {\n  background: rgba(255, 255, 255, 0.05) !important;\n}\n.dark-mode .scalar-card * {\n  --default-theme-background-2: transparent !important;\n  --default-theme-background-1: transparent !important;\n}\n.light-mode .dark-mode.scalar-card *,\n.light-mode .dark-mode.scalar-card {\n  --default-theme-background-1: #0d0f1e !important;\n  --default-theme-background-2: #0d0f1e !important;\n  --default-theme-background-3: #191b29 !important;\n}\n.light-mode .dark-mode.scalar-card {\n  background: #191b29 !important;\n}\n.sidebar-heading-type:before {\n  z-index: 10;\n  position: relative;\n}\n.sidebar-heading-type:after {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  background: linear-gradient(\n    9deg,\n    var(--default-theme-background-1),\n    transparent\n  );\n  border-radius: 30px;\n  opacity: 0.3;\n}\n.show-api-client-button:before {\n  background-color: var(--default-theme-color-accent) !important;\n}\n.badge {\n  box-shadow: 0 0 0 1px var(--default-theme-border-color);\n  margin-right: 6px;\n}\n\n.table-row.required-parameter .table-row-item:nth-of-type(2):after {\n  background: transparent;\n  box-shadow: none;\n}\n.code-languages__active {\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n.code-languages-background {\n  background: linear-gradient(\n    rgba(255, 255, 255, 0) 0%,\n    rgba(255, 255, 255, 0.05) 100%\n  ) !important;\n  box-shadow: inset 0 0 0 1px var(--default-theme-border-color) !important;\n}\n/* Hero Section Flare */\n.section-flare {\n  width: 100vw;\n  background: radial-gradient(\n    ellipse 80% 50% at 50% -20%,\n    rgba(120, 119, 198, 0.3),\n    transparent\n  );\n  height: 100%;\n}\n";
  const marsTheme = "/* basic theme */\n.light-mode {\n  --default-theme-background-1: #f9f6f0;\n  --default-theme-background-2: #f2efe8;\n  --default-theme-background-3: #e9e7e2;\n  --default-theme-border-color: rgba(203, 165, 156, 0.6);\n\n  --default-theme-color-1: #c75549;\n  --default-theme-color-2: #c75549;\n  --default-theme-color-3: #c75549;\n\n  --default-theme-color-accent: #c75549;\n  --default-theme-background-accent: #dcbfa81f;\n\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n.dark-mode {\n  --default-theme-background-1: #140507;\n  --default-theme-background-2: #20090c;\n  --default-theme-background-3: #321116;\n  --default-theme-border-color: rgba(255, 255, 255, 0.1);\n\n  --default-theme-color-1: rgba(255, 255, 255, 0.9);\n  --default-theme-color-2: rgba(255, 255, 255, 0.62);\n  --default-theme-color-3: rgba(255, 255, 255, 0.44);\n\n  --default-theme-color-accent: rgba(255, 255, 255, 0.9);\n  --default-theme-background-accent: #441313;\n\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --default-sidebar-background-1: transparent;\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-border-color: var(--default-theme-border-color);\n\n  --default-sidebar-item-hover-color: currentColor;\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n\n  --default-sidebar-item-active-background: var(--default-theme-background-3);\n  --default-sidebar-color-active: var(--default-theme-color-accent);\n\n  --default-sidebar-search-background: rgba(255, 255, 255, 0.1);\n  --default-sidebar-search-color: var(--default-theme-color-3);\n  --default-sidebar-search-border-color: var(--default-theme-border-color);\n  z-index: 1;\n}\n/* advanced */\n.light-mode {\n  --default-theme-color-green: #09533a;\n  --default-theme-color-red: #aa181d;\n  --default-theme-color-yellow: #ab8d2b;\n  --default-theme-color-blue: #19689a;\n  --default-theme-color-orange: #b26c34;\n  --default-theme-color-purple: #4c2191;\n}\n.dark-mode {\n  --default-theme-color-green: rgba(69, 255, 165, 0.823);\n  --default-theme-color-red: #ff8589;\n  --default-theme-color-yellow: #ffcc4d;\n  --default-theme-color-blue: #6bc1fe;\n  --default-theme-color-orange: #f98943;\n  --default-theme-color-purple: #b191f9;\n}\n/* Custom Theme */\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header,\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(\n    to right bottom,\n    rgb(255, 255, 255) 30%,\n    rgba(255, 255, 255, 0.38)\n  );\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n.light-mode .t-doc__sidebar {\n  --default-sidebar-search-background: white;\n}\n.examples .scalar-card-footer {\n  --default-theme-background-3: transparent;\n  padding-top: 0;\n}\n.show-api-client-button:before {\n  background: white !important;\n}\n.show-api-client-button span,\n.show-api-client-button svg {\n  color: black !important;\n}\n.code-languages-background {\n  background: var(--default-theme-background-1) !important;\n}\n.code-languages-background:before {\n  box-shadow: inset 0 0 0 2px var(--default-theme-border-color);\n  background: linear-gradient(\n    to right top,\n    rgb(211 225 249 / 12%),\n    rgb(209 223 247 / 11%),\n    rgb(223 233 251 / 29%)\n  ) !important;\n}\n.light-mode .code-languages-background:before {\n  background: linear-gradient(\n    to right top,\n    rgb(0 0 0 / 8%),\n    rgb(0 0 0 / 7%),\n    rgb(0 0 0 / 19%)\n  ) !important;\n}\n.code-languages__active .code-languages-background:before {\n  background: var(--default-theme-background-1) !important;\n}\n.sidebar-heading-type {\n  color: var(--default-theme-background-1) !important;\n}\n.active_page .sidebar-heading-type {\n  color: var(--default-sidebar-color-active) !important;\n}\n.sidebar-heading-type:after {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  background: linear-gradient(\n    9deg,\n    var(--default-theme-background-1),\n    transparent\n  );\n  border-radius: 30px;\n  opacity: 0.3;\n}\n\n.code-languages span {\n  margin-top: 5px !important;\n}\n/* Hero section flare */\n.section-flare-item:nth-of-type(1) {\n  background: #d25019;\n  width: 80vw;\n  height: 500px;\n  margin-top: -150px;\n  border-radius: 50%;\n  filter: blur(100px);\n  z-index: 0;\n}\n.light-mode .section-flare {\n  display: none;\n}\n.section-flare {\n  top: -150px !important;\n  height: 100vh;\n  right: -400px !important;\n  left: initial;\n}\n.download-cta a,\n.section .markdown a {\n  text-decoration: underline !important;\n}\n";
  const moonTheme = ".light-mode {\n  color-scheme: light;\n  --default-theme-color-1: #000000;\n  --default-theme-color-2: #000000;\n  --default-theme-color-3: #000000;\n  --default-theme-color-accent: #645b0f;\n  --default-theme-background-1: #ccc9b3;\n  --default-theme-background-2: #c2bfaa;\n  --default-theme-background-3: #b8b5a1;\n  --default-theme-background-accent: #000000;\n\n  --default-theme-border-color: rgba(0, 0, 0, 0.2);\n  --default-theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --default-theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --default-theme-lifted-brightness: 1;\n  --default-theme-backdrop-brightness: 1;\n\n  --default-theme-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --default-theme-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px,\n    rgba(0, 0, 0, 0.08) 0px 3px 8px 0px,\n    var(--default-theme-border-color) 0px 0 0 1px;\n\n  --default-theme-button-1: rgb(49 53 56);\n  --default-theme-button-1-color: #fff;\n  --default-theme-button-1-hover: rgb(28 31 33);\n\n  --default-theme-color-red: #b91c1c;\n  --default-theme-color-orange: #a16207;\n  --default-theme-color-green: #047857;\n  --default-theme-color-blue: #1d4ed8;\n  --default-theme-color-orange: #c2410c;\n  --default-theme-color-purple: #6d28d9;\n\n  --default-theme-code-languages-background-supersede: var(\n    --default-theme-background-3\n  );\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n\n.dark-mode {\n  color-scheme: dark;\n  --default-theme-color-1: #fffef3;\n  --default-theme-color-2: #fffef3;\n  --default-theme-color-3: #fffef3;\n  --default-theme-color-accent: #c3b531;\n  --default-theme-background-1: #313332;\n  --default-theme-background-2: #393b3a;\n  --default-theme-background-3: #414342;\n  --default-theme-background-accent: #fffef3;\n\n  --default-theme-border-color: rgba(255, 255, 255, 0.1);\n  --default-theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --default-theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n  --default-theme-lifted-brightness: 1.45;\n  --default-theme-backdrop-brightness: 0.5;\n\n  --default-theme-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --default-theme-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px,\n    rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px rgba(255, 255, 255, 0.1);\n\n  --default-theme-button-1: #f6f6f6;\n  --default-theme-button-1-color: #000;\n  --default-theme-button-1-hover: #e7e7e7;\n\n  --default-theme-color-green: #00b648;\n  --default-theme-color-red: #dc1b19;\n  --default-theme-color-yellow: #ffc90d;\n  --default-theme-color-blue: #4eb3ec;\n  --default-theme-color-orange: #ff8d4d;\n  --default-theme-color-purple: #b191f9;\n\n  --default-theme-code-languages-background-supersede: var(\n    --default-theme-background-3\n  );\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n}\n\n/* Sidebar */\n.light-mode .t-doc__sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-item-hover-color: currentColor;\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-active-background: var(\n    --default-theme-background-accent\n  );\n  --default-sidebar-border-color: var(--default-theme-border-color);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-color-active: var(--default-sidebar-background-1);\n  --default-sidebar-search-background: var(--default-theme-background-3);\n  --default-sidebar-search-border-color: var(\n    --default-sidebar-search-background\n  );\n  --default-sidebar-search--color: var(--default-theme-color-3);\n}\n\n.dark-mode .sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-item-hover-color: currentColor;\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-active-background: var(\n    --default-theme-background-accent\n  );\n  --default-sidebar-border-color: var(--default-theme-border-color);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-color-active: var(--default-sidebar-background-1);\n  --default-sidebar-search-background: var(--default-theme-background-3);\n  --default-sidebar-search-border-color: var(\n    --default-sidebar-search-background\n  );\n  --default-sidebar-search--color: var(--default-theme-color-3);\n}\n";
  const purpleTheme = "/* basic theme */\n.light-mode {\n  --default-theme-background-1: #fff;\n  --default-theme-background-2: #f5f6f8;\n  --default-theme-background-3: #eceef1;\n\n  --default-theme-color-1: #2a2f45;\n  --default-theme-color-2: #757575;\n  --default-theme-color-3: #8e8e8e;\n\n  --default-theme-color-accent: #5469d4;\n  --default-theme-background-accent: #5469d41f;\n\n  --default-theme-border-color: rgba(215, 215, 206, 0.5);\n}\n.dark-mode {\n  --default-theme-background-1: #15171c;\n  --default-theme-background-2: #1c1e24;\n  --default-theme-background-3: #22252b;\n\n  --default-theme-color-1: #fafafa;\n  --default-theme-color-2: #c9ced8;\n  --default-theme-color-3: #8c99ad;\n\n  --default-theme-color-accent: #5469d4;\n  --default-theme-background-accent: #5469d41f;\n\n  --default-theme-border-color: rgba(255, 255, 255, 0.12);\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --sidebar-background-1: var(--default-theme-background-1);\n  --sidebar-color-1: var(--default-theme-color-1);\n  --sidebar-color-2: var(--default-theme-color-2);\n  --sidebar-border-color: var(--default-theme-border-color);\n\n  /* Sidebar item hover */\n  --sidebar-item-hover-color: currentColor;\n  --sidebar-item-hover-background: var(--default-theme-background-3);\n\n  /* Sidebar Active */\n  --sidebar-item-active-background: var(--default-theme-background-accent);\n  --sidebar-color-active: var(--default-theme-color-accent);\n\n  /* Sidebar Search */\n  --sidebar-search-background: var(--default-theme-background-1);\n  --sidebar-search-color: var(--default-theme-color-3);\n  --sidebar-search-border-color: var(--default-theme-border-color);\n}\n\n/* advanced */\n.light-mode {\n  --default-theme-color-green: #17803d;\n  --default-theme-color-red: #e10909;\n  --default-theme-color-yellow: #edbe20;\n  --default-theme-color-blue: #1763a6;\n  --default-theme-color-orange: #e25b09;\n  --default-theme-color-purple: #5c3993;\n}\n.dark-mode {\n  --default-theme-color-green: #30a159;\n  --default-theme-color-red: #dc1b19;\n  --default-theme-color-yellow: #eec644;\n  --default-theme-color-blue: #2b7abf;\n  --default-theme-color-orange: #f07528;\n  --default-theme-color-purple: #7a59b1;\n}\n";
  const saturnTheme = "/* basic theme */\n.light-mode {\n  --default-theme-background-1: #f3f3ee;\n  --default-theme-background-2: #e8e8e3;\n  --default-theme-background-3: #e4e4df;\n  --default-theme-border-color: rgba(215, 215, 206, 0.5);\n\n  --default-theme-color-1: #2a2f45;\n  --default-theme-color-2: #757575;\n  --default-theme-color-3: #8e8e8e;\n\n  --default-theme-color-accent: #1763a6;\n  --default-theme-background-accent: #1f648e1f;\n\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n  --default-theme-code-languages-background-supersede: var(\n    --default-theme-background-2\n  );\n}\n.dark-mode {\n  --default-theme-background-1: #09090b;\n  --default-theme-background-2: #18181b;\n  --default-theme-background-3: #2c2c30;\n  --default-theme-border-color: rgba(255, 255, 255, 0.12);\n\n  --default-theme-color-1: #fafafa;\n  --default-theme-color-2: rgb(161, 161, 170);\n  --default-theme-color-3: rgba(255, 255, 255, 0.533);\n\n  --default-theme-color-accent: #4eb3ec;\n  --default-theme-background-accent: #8ab4f81f;\n\n  --default-theme-code-language-color-supersede: var(--default-theme-color-1);\n  --default-theme-code-languages-background-supersede: var(\n    --default-theme-background-2\n  );\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-border-color: var(--default-theme-border-color);\n\n  --default-sidebar-item-hover-background: var(--default-theme-background-3);\n  --default-sidebar-item-hover-color: currentColor;\n\n  --default-sidebar-item-active-background: var(--default-theme-background-3);\n  --default-sidebar-color-active: var(--default-theme-color-1);\n\n  --default-sidebar-search-background: var(--default-theme-background-1);\n  --default-sidebar-search-border-color: var(--default-theme-border-color);\n  --default-sidebar-search-color: var(--default-theme-color-3);\n}\n\n/* advanced */\n.light-mode {\n  --default-theme-color-green: #17803d;\n  --default-theme-color-red: #e10909;\n  --default-theme-color-yellow: #edbe20;\n  --default-theme-color-blue: #1763a6;\n  --default-theme-color-orange: #e25b09;\n  --default-theme-color-purple: #5c3993;\n}\n.dark-mode {\n  --default-theme-color-green: #30a159;\n  --default-theme-color-red: #dc1b19;\n  --default-theme-color-yellow: #eec644;\n  --default-theme-color-blue: #2b7abf;\n  --default-theme-color-orange: #f07528;\n  --default-theme-color-purple: #7a59b1;\n}\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header,\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(\n    to right bottom,\n    rgb(255, 255, 255) 30%,\n    rgba(255, 255, 255, 0.38)\n  );\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n";
  const solarizedTheme = ".light-mode {\n  color-scheme: light;\n  --default-theme-color-1: #584c27;\n  --default-theme-color-2: #616161;\n  --default-theme-color-3: #a89f84;\n  --default-theme-color-accent: #b58900;\n  --default-theme-background-1: #fdf6e3;\n  --default-theme-background-2: #eee8d5;\n  --default-theme-background-3: #ddd6c1;\n  --default-theme-background-accent: #b589001f;\n\n  --default-theme-border-color: #ded8c8;\n  --default-theme-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --default-theme-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --default-theme-lifted-brightness: 1;\n  --default-theme-backdrop-brightness: 1;\n\n  --default-theme-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --default-theme-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px,\n    rgba(0, 0, 0, 0.08) 0px 3px 8px 0px, #eeeeed 0px 0 0 1px;\n\n  --default-theme-button-1: rgb(49 53 56);\n  --default-theme-button-1-color: #fff;\n  --default-theme-button-1-hover: rgb(28 31 33);\n\n  --default-theme-color-red: #b91c1c;\n  --default-theme-color-orange: #a16207;\n  --default-theme-color-green: #047857;\n  --default-theme-color-blue: #1d4ed8;\n  --default-theme-color-orange: #c2410c;\n  --default-theme-color-purple: #6d28d9;\n}\n\n.dark-mode {\n  color-scheme: dark;\n  --default-theme-color-1: #fff;\n  --default-theme-color-2: #cccccc;\n  --default-theme-color-3: #6d8890;\n  --default-theme-color-accent: #007acc;\n  --default-theme-background-1: #00212b;\n  --default-theme-background-2: #012b36;\n  --default-theme-background-3: #004052;\n  --default-theme-background-accent: #015a6f;\n\n  --default-theme-border-color: rgba(255, 255, 255, 0.1);\n  --default-theme-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --default-theme-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n  --default-theme-lifted-brightness: 1.45;\n  --default-theme-backdrop-brightness: 0.5;\n\n  --default-theme-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, 0.1);\n  --default-theme-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px,\n    rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px rgba(255, 255, 255, 0.1);\n\n  --default-theme-button-1: #f6f6f6;\n  --default-theme-button-1-color: #000;\n  --default-theme-button-1-hover: #e7e7e7;\n\n  --default-theme-color-green: #00b648;\n  --default-theme-color-red: #dc1b19;\n  --default-theme-color-yellow: #ffc90d;\n  --default-theme-color-blue: #4eb3ec;\n  --default-theme-color-orange: #ff8d4d;\n  --default-theme-color-purple: #b191f9;\n}\n\n/* Sidebar */\n.light-mode .t-doc__sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-item-hover-color: currentColor;\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-active-background: var(\n    --default-theme-background-accent\n  );\n  --default-sidebar-border-color: var(--default-theme-border-color);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-color-active: var(--default-theme-color-accent);\n  --default-sidebar-search-background: var(--default-theme-background-2);\n  --default-sidebar-search-border-color: var(--sidebar-search-background);\n  --default-sidebar-search--color: var(--default-theme-color-3);\n}\n\n.dark-mode .sidebar {\n  --default-sidebar-background-1: var(--default-theme-background-1);\n  --default-sidebar-item-hover-color: currentColor;\n  --default-sidebar-item-hover-background: var(--default-theme-background-2);\n  --default-sidebar-item-active-background: var(\n    --default-theme-background-accent\n  );\n  --default-sidebar-border-color: var(--default-theme-border-color);\n  --default-sidebar-color-1: var(--default-theme-color-1);\n  --default-sidebar-color-2: var(--default-theme-color-2);\n  --default-sidebar-color-active: var(--default-sidebar-color-1);\n  --default-sidebar-search-background: var(--default-theme-background-2);\n  --default-sidebar-search-border-color: var(--sidebar-search-background);\n  --default-sidebar-search--color: var(--default-theme-color-3);\n}\n";
  const _sfc_main$r = /* @__PURE__ */ defineComponent({
    __name: "ThemeStyles",
    props: {
      id: {}
    },
    setup(__props) {
      return (_ctx, _cache) => {
        return _ctx.id !== "none" ? (openBlock(), createBlock(resolveDynamicComponent("style"), { key: 0 }, {
          default: withCtx(() => [
            createTextVNode(toDisplayString(unref(getThemeById)(_ctx.id)), 1)
          ]),
          _: 1
        })) : createCommentVNode("", true);
      };
    }
  });
  const presets = {
    alternate: alternateTheme,
    default: defaultTheme,
    moon: moonTheme,
    purple: purpleTheme,
    solarized: solarizedTheme,
    bluePlanet: bluePlanetTheme,
    deepSpace: deepSpaceTheme,
    saturn: saturnTheme,
    kepler: keplerTheme,
    mars: marsTheme
  };
  const getThemeById = (themeId = "default") => {
    if (themeId === "none") {
      return "";
    }
    return presets[themeId] ?? defaultTheme;
  };
  function defaultState() {
    return {
      showApiClient: false,
      activeApiClientEndpointId: "",
      activeItem: {},
      snippetType: "javascript"
    };
  }
  reactive(defaultState());
  const createPlaceholderRequest = () => ({
    name: "",
    url: "",
    type: "GET",
    path: "",
    variables: [],
    headers: [],
    query: [],
    body: "",
    formData: []
  });
  const createEmptyAuthState = () => ({
    type: "none",
    basic: {
      username: "",
      password: "",
      active: true
    },
    oauthTwo: {
      generatedToken: "",
      discoveryURL: "",
      authURL: "",
      accessTokenURL: "",
      clientID: "",
      clientSecret: "",
      scope: "",
      active: true
    },
    bearer: {
      token: "",
      active: true
    },
    digest: {
      username: "",
      password: "",
      active: true
    }
  });
  const authState = reactive(createEmptyAuthState());
  const requestHistory = reactive({});
  const requestHistoryOrder = ref([]);
  const activeRequestId = ref("");
  const activeRequest = reactive(createPlaceholderRequest());
  const addRequestToHistory = (value) => {
    requestHistory[value.responseId] = value;
    activeRequestId.value = value.responseId;
    requestHistoryOrder.value.unshift(value.responseId);
  };
  const setActiveResponse = (historyID) => {
    activeRequestId.value = historyID;
    const { request } = requestHistory[historyID];
    const req = JSON.parse(JSON.stringify(request));
    req.body = JSON.stringify(request.body, null, 2);
    Object.assign(activeRequest, req);
  };
  const activeResponse = computed(
    () => activeRequestId.value ? requestHistory[activeRequestId.value].response : null
  );
  const setActiveRequest$1 = (request) => {
    Object.assign(activeRequest, request);
  };
  const resetActiveResponse = () => {
    activeRequestId.value = "";
  };
  const readOnly$1 = ref(true);
  const useRequestStore = () => ({
    authState,
    readOnly: readOnly$1,
    activeRequest,
    activeResponse,
    requestHistory,
    requestHistoryOrder,
    activeRequestId,
    setActiveResponse,
    resetActiveResponse,
    addRequestToHistory,
    setActiveRequest: setActiveRequest$1
  });
  const httpHeaders = [
    {
      name: "Accept",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept"
    },
    {
      name: "Accept-CH",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-CH"
    },
    {
      name: "Accept-CH-Lifetime",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-CH-Lifetime"
    },
    {
      name: "Accept-Charset",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Charset"
    },
    {
      name: "Accept-Encoding",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Encoding"
    },
    {
      name: "Accept-Language",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Language"
    },
    {
      name: "Accept-Patch",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Patch"
    },
    {
      name: "Accept-Post",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Post"
    },
    {
      name: "Accept-Ranges",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Ranges"
    },
    {
      name: "Access-Control-Allow-Credentials",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials"
    },
    {
      name: "Access-Control-Allow-Headers",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers"
    },
    {
      name: "Access-Control-Allow-Methods",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods"
    },
    {
      name: "Access-Control-Allow-Origin",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin"
    },
    {
      name: "Access-Control-Expose-Headers",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers"
    },
    {
      name: "Access-Control-Max-Age",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age"
    },
    {
      name: "Access-Control-Request-Headers",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Request-Headers"
    },
    {
      name: "Access-Control-Request-Method",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Request-Method"
    },
    {
      name: "Age",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Age"
    },
    {
      name: "Allow",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Allow"
    },
    {
      name: "Alt-Svc",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Alt-Svc"
    },
    {
      name: "Alt-Used",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Alt-Used"
    },
    {
      name: "Authorization",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Authorization"
    },
    {
      name: "Cache-Control",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control"
    },
    {
      name: "Clear-Site-Data",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Clear-Site-Data"
    },
    {
      name: "Connection",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Connection"
    },
    {
      name: "Content-Disposition",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Disposition"
    },
    {
      name: "Content-DPR",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-DPR"
    },
    {
      name: "Content-Encoding",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding"
    },
    {
      name: "Content-Language",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Language"
    },
    {
      name: "Content-Length",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Length"
    },
    {
      name: "Content-Location",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Location"
    },
    {
      name: "Content-Range",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Range"
    },
    {
      name: "Content-Security-Policy",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy"
    },
    {
      name: "Content-Security-Policy-Report-Only",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy-Report-Only"
    },
    {
      name: "Content-Type",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Type"
    },
    {
      name: "Cookie",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cookie"
    },
    {
      name: "Critical-CH",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Critical-CH"
    },
    {
      name: "Cross-Origin-Embedder-Policy",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cross-Origin-Embedder-Policy"
    },
    {
      name: "Cross-Origin-Opener-Policy",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cross-Origin-Opener-Policy"
    },
    {
      name: "Cross-Origin-Resource-Policy",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cross-Origin-Resource-Policy"
    },
    {
      name: "Date",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Date"
    },
    {
      name: "Device-Memory",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Device-Memory"
    },
    {
      name: "Digest",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Digest"
    },
    {
      name: "DNT",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/DNT"
    },
    {
      name: "Downlink",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Downlink"
    },
    {
      name: "DPR",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/DPR"
    },
    {
      name: "Early-Data",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Early-Data"
    },
    {
      name: "ECT",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/ECT"
    },
    {
      name: "ETag",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/ETag"
    },
    {
      name: "Expect",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Expect"
    },
    {
      name: "Expect-CT",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Expect-CT"
    },
    {
      name: "Expires",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Expires"
    },
    {
      name: "Forwarded",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Forwarded"
    },
    {
      name: "From",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/From"
    },
    {
      name: "Host",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Host"
    },
    {
      name: "If-Match",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-Match"
    },
    {
      name: "If-Modified-Since",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-Modified-Since"
    },
    {
      name: "If-None-Match",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-None-Match"
    },
    {
      name: "If-Range",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-Range"
    },
    {
      name: "If-Unmodified-Since",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-Unmodified-Since"
    },
    {
      name: "Keep-Alive",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Keep-Alive"
    },
    {
      name: "Large-Allocation",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Large-Allocation"
    },
    {
      name: "Last-Modified",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Last-Modified"
    },
    {
      name: "Link",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link"
    },
    {
      name: "Location",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Location"
    },
    {
      name: "Max-Forwards",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Max-Forwards"
    },
    {
      name: "NEL",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/NEL"
    },
    {
      name: "Origin",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin"
    },
    {
      name: "Permissions-Policy",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Permissions-Policy"
    },
    {
      name: "Pragma",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Pragma"
    },
    {
      name: "Proxy-Authenticate",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Proxy-Authenticate"
    },
    {
      name: "Proxy-Authorization",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Proxy-Authorization"
    },
    {
      name: "Range",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Range"
    },
    {
      name: "Referer",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer"
    },
    {
      name: "Referrer-Policy",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy"
    },
    {
      name: "Retry-After",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Retry-After"
    },
    {
      name: "RTT",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/RTT"
    },
    {
      name: "Save-Data",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Save-Data"
    },
    {
      name: "Sec-CH-Prefers-Reduced-Motion",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-Prefers-Reduced-Motion"
    },
    {
      name: "Sec-CH-Prefers-Reduced-Transparency",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-Prefers-Reduced-Transparency"
    },
    {
      name: "Sec-CH-UA",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA"
    },
    {
      name: "Sec-CH-UA-Arch",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Arch"
    },
    {
      name: "Sec-CH-UA-Bitness",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Bitness"
    },
    {
      name: "Sec-CH-UA-Full-Version",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Full-Version"
    },
    {
      name: "Sec-CH-UA-Full-Version-List",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Full-Version-List"
    },
    {
      name: "Sec-CH-UA-Mobile",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Mobile"
    },
    {
      name: "Sec-CH-UA-Model",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Model"
    },
    {
      name: "Sec-CH-UA-Platform",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Platform"
    },
    {
      name: "Sec-CH-UA-Platform-Version",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-UA-Platform-Version"
    },
    {
      name: "Sec-Fetch-Dest",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-Fetch-Dest"
    },
    {
      name: "Sec-Fetch-Mode",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-Fetch-Mode"
    },
    {
      name: "Sec-Fetch-Site",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-Fetch-Site"
    },
    {
      name: "Sec-Fetch-User",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-Fetch-User"
    },
    {
      name: "Sec-GPC",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-GPC"
    },
    {
      name: "Sec-Purpose",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-Purpose"
    },
    {
      name: "Sec-WebSocket-Accept",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-WebSocket-Accept"
    },
    {
      name: "Server",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Server"
    },
    {
      name: "Server-Timing",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Server-Timing"
    },
    {
      name: "Service-Worker-Navigation-Preload",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Service-Worker-Navigation-Preload"
    },
    {
      name: "Set-Cookie",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie"
    },
    {
      name: "SourceMap",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/SourceMap"
    },
    {
      name: "Strict-Transport-Security",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security"
    },
    {
      name: "TE",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/TE"
    },
    {
      name: "Timing-Allow-Origin",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Timing-Allow-Origin"
    },
    {
      name: "Tk",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Tk"
    },
    {
      name: "Trailer",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Trailer"
    },
    {
      name: "Transfer-Encoding",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Transfer-Encoding"
    },
    {
      name: "Upgrade",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Upgrade"
    },
    {
      name: "Upgrade-Insecure-Requests",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Upgrade-Insecure-Requests"
    },
    {
      name: "User-Agent",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/User-Agent"
    },
    {
      name: "Vary",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Vary"
    },
    {
      name: "Via",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Via"
    },
    {
      name: "Viewport-Width",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Viewport-Width"
    },
    {
      name: "Want-Digest",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Want-Digest"
    },
    {
      name: "Warning",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Warning"
    },
    {
      name: "Width",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Width"
    },
    {
      name: "WWW-Authenticate",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/WWW-Authenticate"
    },
    {
      name: "X-Content-Type-Options",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options"
    },
    {
      name: "X-DNS-Prefetch-Control",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-DNS-Prefetch-Control"
    },
    {
      name: "Non-standard",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Non-standard"
    },
    {
      name: "X-Forwarded-For",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For"
    },
    {
      name: "Non-standard",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Non-standard"
    },
    {
      name: "X-Forwarded-Host",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host"
    },
    {
      name: "Non-standard",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Non-standard"
    },
    {
      name: "X-Forwarded-Proto",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Proto"
    },
    {
      name: "Non-standard",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Non-standard"
    },
    {
      name: "X-Frame-Options",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options"
    },
    {
      name: "X-XSS-Protection",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection"
    },
    {
      name: "Cf-Cache-Status",
      url: "https://developers.cloudflare.com/cache/concepts/default-cache-behavior/#cloudflare-cache-responses"
    },
    {
      name: "Cf-Ray",
      url: "https://developers.cloudflare.com/fundamentals/get-started/reference/http-request-headers/#cf-ray"
    },
    {
      name: "Report-To",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/report-to"
    }
  ];
  const validRequestMethods = [
    "GET",
    "POST",
    "PUT",
    "HEAD",
    "DELETE",
    "PATCH",
    "OPTIONS",
    "CONNECT",
    "TRACE"
  ];
  function isRequestMethod(s2) {
    return validRequestMethods.includes(s2);
  }
  const requestMethodColors = {
    POST: "var(--theme-color-green, var(--default-theme-color-green))",
    DELETE: "var(--theme-color-red, var(--default-theme-color-red))",
    PATCH: "var(--theme-color-yellow, var(--default-theme-color-yellow))",
    GET: "var(--theme-color-blue, var(--default-theme-color-blue))",
    PUT: "var(--theme-color-orange, var(--default-theme-color-orange))",
    OPTIONS: "var(--theme-color-purple, var(--default-theme-color-purple))",
    HEAD: "var(--theme-color-2, var(--default-theme-color-2))",
    CONNECT: "var(--theme-color-2, var(--default-theme-color-2))",
    TRACE: "var(--theme-color-2, var(--default-theme-color-2))"
  };
  const requestMethodAbbreviations = {
    POST: "POST",
    DELETE: "DEL",
    PATCH: "PATCH",
    GET: "GET",
    PUT: "PUT",
    OPTIONS: "OPTS",
    HEAD: "HEAD",
    CONNECT: "CONN",
    TRACE: "TRACE"
  };
  const httpStatusCodes = {
    100: {
      name: "Continue",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/100"
    },
    101: {
      name: "Switching Protocols",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/101"
    },
    102: {
      name: "Processing",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/102"
    },
    103: {
      name: "Early Hints",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/103"
    },
    200: {
      name: "OK",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/200"
    },
    201: {
      name: "Created",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/201"
    },
    202: {
      name: "Accepted",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/202"
    },
    203: {
      name: "Non-Authoritative Information",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/203"
    },
    204: {
      name: "No Content",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/204"
    },
    205: {
      name: "Reset Content",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/205"
    },
    206: {
      name: "Partial Content",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/206"
    },
    207: {
      name: "Multi-Status",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/207"
    },
    208: {
      name: "Already Reported",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/208"
    },
    226: {
      name: "IM Used",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/226"
    },
    300: {
      name: "Multiple Choices",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/300"
    },
    301: {
      name: "Moved Permanently",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/301"
    },
    302: {
      name: "Found",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/302"
    },
    303: {
      name: "See Other",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/303"
    },
    304: {
      name: "Not Modified",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/304"
    },
    305: {
      name: "Use Proxy",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/305"
    },
    306: {
      name: "(Unused)",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/306"
    },
    307: {
      name: "Temporary Redirect",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/307"
    },
    308: {
      name: "Permanent Redirect",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/308"
    },
    400: {
      name: "Bad Request",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/400"
    },
    401: {
      name: "Unauthorized",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/401"
    },
    402: {
      name: "Payment Required",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/402"
    },
    403: {
      name: "Forbidden",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/403"
    },
    404: {
      name: "Not Found",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/404"
    },
    405: {
      name: "Method Not Allowed",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/405"
    },
    406: {
      name: "Not Acceptable",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/406"
    },
    407: {
      name: "Proxy Authentication Required",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/407"
    },
    408: {
      name: "Request Timeout",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/408"
    },
    409: {
      name: "Conflict",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/409"
    },
    410: {
      name: "Gone",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/410"
    },
    411: {
      name: "Length Required",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/411"
    },
    412: {
      name: "Precondition Failed",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/412"
    },
    413: {
      name: "Content Too Large",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/413"
    },
    414: {
      name: "URI Too Long",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/414"
    },
    415: {
      name: "Unsupported Media Type",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/415"
    },
    416: {
      name: "Range Not Satisfiable",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/416"
    },
    417: {
      name: "Expectation Failed",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/417"
    },
    421: {
      name: "Misdirected Request",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/421"
    },
    422: {
      name: "Unprocessable Content",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/422"
    },
    423: {
      name: "Locked",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/423"
    },
    424: {
      name: "Failed Dependency",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/424"
    },
    425: {
      name: "Too Early",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/425"
    },
    426: {
      name: "Upgrade Required",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/426"
    },
    428: {
      name: "Precondition Required",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/428"
    },
    429: {
      name: "Too Many Requests",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/429"
    },
    431: {
      name: "Request Header Fields Too Large",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/431"
    },
    451: {
      name: "Unavailable For Legal Reasons",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/451"
    },
    500: {
      name: "Internal Server Error",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/500"
    },
    501: {
      name: "Not Implemented",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/501"
    },
    502: {
      name: "Bad Gateway",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/502"
    },
    503: {
      name: "Service Unavailable",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/503"
    },
    504: {
      name: "Gateway Timeout",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/504"
    },
    505: {
      name: "HTTP Version Not Supported",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/505"
    },
    506: {
      name: "Variant Also Negotiates",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/506"
    },
    507: {
      name: "Insufficient Storage",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/507"
    },
    508: {
      name: "Loop Detected",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/508"
    },
    510: {
      name: "Not Extended",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/510"
    },
    511: {
      name: "Network Authentication Required",
      url: "https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/511"
    }
  };
  const _sfc_main$q = /* @__PURE__ */ defineComponent({
    __name: "HttpMethod",
    props: {
      as: {},
      property: {},
      short: { type: Boolean },
      method: {}
    },
    setup(__props) {
      const props = __props;
      const normalized = computed(() => props.method.trim().toUpperCase());
      const abbreviated = computed(() => {
        if (isRequestMethod(normalized.value))
          return requestMethodAbbreviations[normalized.value];
        return normalized.value.slice(0, 4);
      });
      const color = computed(() => {
        if (isRequestMethod(normalized.value))
          return requestMethodColors[normalized.value];
        return "var(--theme-color-ghost, var(--default-theme-color-ghost))";
      });
      return (_ctx, _cache) => {
        return openBlock(), createBlock(resolveDynamicComponent(_ctx.as ?? "span"), {
          style: normalizeStyle({ [_ctx.property || "color"]: color.value })
        }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps({ normalized: normalized.value, abbreviated: abbreviated.value, color: color.value })), () => [
              createTextVNode(toDisplayString(_ctx.short ? abbreviated.value : normalized.value), 1)
            ])
          ]),
          _: 3
        }, 8, ["style"]);
      };
    }
  });
  let Text$1 = class Text2 {
    /**
    Get the line description around the given position.
    */
    lineAt(pos) {
      if (pos < 0 || pos > this.length)
        throw new RangeError(`Invalid position ${pos} in document of length ${this.length}`);
      return this.lineInner(pos, false, 1, 0);
    }
    /**
    Get the description for the given (1-based) line number.
    */
    line(n2) {
      if (n2 < 1 || n2 > this.lines)
        throw new RangeError(`Invalid line number ${n2} in ${this.lines}-line document`);
      return this.lineInner(n2, true, 1, 0);
    }
    /**
    Replace a range of the text with the given content.
    */
    replace(from, to, text) {
      [from, to] = clip(this, from, to);
      let parts = [];
      this.decompose(
        0,
        from,
        parts,
        2
        /* Open.To */
      );
      if (text.length)
        text.decompose(
          0,
          text.length,
          parts,
          1 | 2
          /* Open.To */
        );
      this.decompose(
        to,
        this.length,
        parts,
        1
        /* Open.From */
      );
      return TextNode.from(parts, this.length - (to - from) + text.length);
    }
    /**
    Append another document to this one.
    */
    append(other) {
      return this.replace(this.length, this.length, other);
    }
    /**
    Retrieve the text between the given points.
    */
    slice(from, to = this.length) {
      [from, to] = clip(this, from, to);
      let parts = [];
      this.decompose(from, to, parts, 0);
      return TextNode.from(parts, to - from);
    }
    /**
    Test whether this text is equal to another instance.
    */
    eq(other) {
      if (other == this)
        return true;
      if (other.length != this.length || other.lines != this.lines)
        return false;
      let start = this.scanIdentical(other, 1), end = this.length - this.scanIdentical(other, -1);
      let a2 = new RawTextCursor(this), b2 = new RawTextCursor(other);
      for (let skip = start, pos = start; ; ) {
        a2.next(skip);
        b2.next(skip);
        skip = 0;
        if (a2.lineBreak != b2.lineBreak || a2.done != b2.done || a2.value != b2.value)
          return false;
        pos += a2.value.length;
        if (a2.done || pos >= end)
          return true;
      }
    }
    /**
    Iterate over the text. When `dir` is `-1`, iteration happens
    from end to start. This will return lines and the breaks between
    them as separate strings.
    */
    iter(dir = 1) {
      return new RawTextCursor(this, dir);
    }
    /**
    Iterate over a range of the text. When `from` > `to`, the
    iterator will run in reverse.
    */
    iterRange(from, to = this.length) {
      return new PartialTextCursor(this, from, to);
    }
    /**
    Return a cursor that iterates over the given range of lines,
    _without_ returning the line breaks between, and yielding empty
    strings for empty lines.
    
    When `from` and `to` are given, they should be 1-based line numbers.
    */
    iterLines(from, to) {
      let inner;
      if (from == null) {
        inner = this.iter();
      } else {
        if (to == null)
          to = this.lines + 1;
        let start = this.line(from).from;
        inner = this.iterRange(start, Math.max(start, to == this.lines + 1 ? this.length : to <= 1 ? 0 : this.line(to - 1).to));
      }
      return new LineCursor(inner);
    }
    /**
    Return the document as a string, using newline characters to
    separate lines.
    */
    toString() {
      return this.sliceString(0);
    }
    /**
    Convert the document to an array of lines (which can be
    deserialized again via [`Text.of`](https://codemirror.net/6/docs/ref/#state.Text^of)).
    */
    toJSON() {
      let lines = [];
      this.flatten(lines);
      return lines;
    }
    /**
    @internal
    */
    constructor() {
    }
    /**
    Create a `Text` instance for the given array of lines.
    */
    static of(text) {
      if (text.length == 0)
        throw new RangeError("A document must have at least one line");
      if (text.length == 1 && !text[0])
        return Text2.empty;
      return text.length <= 32 ? new TextLeaf(text) : TextNode.from(TextLeaf.split(text, []));
    }
  };
  class TextLeaf extends Text$1 {
    constructor(text, length = textLength(text)) {
      super();
      this.text = text;
      this.length = length;
    }
    get lines() {
      return this.text.length;
    }
    get children() {
      return null;
    }
    lineInner(target, isLine, line, offset) {
      for (let i2 = 0; ; i2++) {
        let string2 = this.text[i2], end = offset + string2.length;
        if ((isLine ? line : end) >= target)
          return new Line(offset, end, line, string2);
        offset = end + 1;
        line++;
      }
    }
    decompose(from, to, target, open) {
      let text = from <= 0 && to >= this.length ? this : new TextLeaf(sliceText(this.text, from, to), Math.min(to, this.length) - Math.max(0, from));
      if (open & 1) {
        let prev = target.pop();
        let joined = appendText(text.text, prev.text.slice(), 0, text.length);
        if (joined.length <= 32) {
          target.push(new TextLeaf(joined, prev.length + text.length));
        } else {
          let mid = joined.length >> 1;
          target.push(new TextLeaf(joined.slice(0, mid)), new TextLeaf(joined.slice(mid)));
        }
      } else {
        target.push(text);
      }
    }
    replace(from, to, text) {
      if (!(text instanceof TextLeaf))
        return super.replace(from, to, text);
      [from, to] = clip(this, from, to);
      let lines = appendText(this.text, appendText(text.text, sliceText(this.text, 0, from)), to);
      let newLen = this.length + text.length - (to - from);
      if (lines.length <= 32)
        return new TextLeaf(lines, newLen);
      return TextNode.from(TextLeaf.split(lines, []), newLen);
    }
    sliceString(from, to = this.length, lineSep = "\n") {
      [from, to] = clip(this, from, to);
      let result = "";
      for (let pos = 0, i2 = 0; pos <= to && i2 < this.text.length; i2++) {
        let line = this.text[i2], end = pos + line.length;
        if (pos > from && i2)
          result += lineSep;
        if (from < end && to > pos)
          result += line.slice(Math.max(0, from - pos), to - pos);
        pos = end + 1;
      }
      return result;
    }
    flatten(target) {
      for (let line of this.text)
        target.push(line);
    }
    scanIdentical() {
      return 0;
    }
    static split(text, target) {
      let part = [], len = -1;
      for (let line of text) {
        part.push(line);
        len += line.length + 1;
        if (part.length == 32) {
          target.push(new TextLeaf(part, len));
          part = [];
          len = -1;
        }
      }
      if (len > -1)
        target.push(new TextLeaf(part, len));
      return target;
    }
  }
  class TextNode extends Text$1 {
    constructor(children, length) {
      super();
      this.children = children;
      this.length = length;
      this.lines = 0;
      for (let child of children)
        this.lines += child.lines;
    }
    lineInner(target, isLine, line, offset) {
      for (let i2 = 0; ; i2++) {
        let child = this.children[i2], end = offset + child.length, endLine = line + child.lines - 1;
        if ((isLine ? endLine : end) >= target)
          return child.lineInner(target, isLine, line, offset);
        offset = end + 1;
        line = endLine + 1;
      }
    }
    decompose(from, to, target, open) {
      for (let i2 = 0, pos = 0; pos <= to && i2 < this.children.length; i2++) {
        let child = this.children[i2], end = pos + child.length;
        if (from <= end && to >= pos) {
          let childOpen = open & ((pos <= from ? 1 : 0) | (end >= to ? 2 : 0));
          if (pos >= from && end <= to && !childOpen)
            target.push(child);
          else
            child.decompose(from - pos, to - pos, target, childOpen);
        }
        pos = end + 1;
      }
    }
    replace(from, to, text) {
      [from, to] = clip(this, from, to);
      if (text.lines < this.lines)
        for (let i2 = 0, pos = 0; i2 < this.children.length; i2++) {
          let child = this.children[i2], end = pos + child.length;
          if (from >= pos && to <= end) {
            let updated = child.replace(from - pos, to - pos, text);
            let totalLines = this.lines - child.lines + updated.lines;
            if (updated.lines < totalLines >> 5 - 1 && updated.lines > totalLines >> 5 + 1) {
              let copy2 = this.children.slice();
              copy2[i2] = updated;
              return new TextNode(copy2, this.length - (to - from) + text.length);
            }
            return super.replace(pos, end, updated);
          }
          pos = end + 1;
        }
      return super.replace(from, to, text);
    }
    sliceString(from, to = this.length, lineSep = "\n") {
      [from, to] = clip(this, from, to);
      let result = "";
      for (let i2 = 0, pos = 0; i2 < this.children.length && pos <= to; i2++) {
        let child = this.children[i2], end = pos + child.length;
        if (pos > from && i2)
          result += lineSep;
        if (from < end && to > pos)
          result += child.sliceString(from - pos, to - pos, lineSep);
        pos = end + 1;
      }
      return result;
    }
    flatten(target) {
      for (let child of this.children)
        child.flatten(target);
    }
    scanIdentical(other, dir) {
      if (!(other instanceof TextNode))
        return 0;
      let length = 0;
      let [iA, iB, eA, eB] = dir > 0 ? [0, 0, this.children.length, other.children.length] : [this.children.length - 1, other.children.length - 1, -1, -1];
      for (; ; iA += dir, iB += dir) {
        if (iA == eA || iB == eB)
          return length;
        let chA = this.children[iA], chB = other.children[iB];
        if (chA != chB)
          return length + chA.scanIdentical(chB, dir);
        length += chA.length + 1;
      }
    }
    static from(children, length = children.reduce((l2, ch) => l2 + ch.length + 1, -1)) {
      let lines = 0;
      for (let ch of children)
        lines += ch.lines;
      if (lines < 32) {
        let flat = [];
        for (let ch of children)
          ch.flatten(flat);
        return new TextLeaf(flat, length);
      }
      let chunk = Math.max(
        32,
        lines >> 5
        /* Tree.BranchShift */
      ), maxChunk = chunk << 1, minChunk = chunk >> 1;
      let chunked = [], currentLines = 0, currentLen = -1, currentChunk = [];
      function add2(child) {
        let last;
        if (child.lines > maxChunk && child instanceof TextNode) {
          for (let node of child.children)
            add2(node);
        } else if (child.lines > minChunk && (currentLines > minChunk || !currentLines)) {
          flush();
          chunked.push(child);
        } else if (child instanceof TextLeaf && currentLines && (last = currentChunk[currentChunk.length - 1]) instanceof TextLeaf && child.lines + last.lines <= 32) {
          currentLines += child.lines;
          currentLen += child.length + 1;
          currentChunk[currentChunk.length - 1] = new TextLeaf(last.text.concat(child.text), last.length + 1 + child.length);
        } else {
          if (currentLines + child.lines > chunk)
            flush();
          currentLines += child.lines;
          currentLen += child.length + 1;
          currentChunk.push(child);
        }
      }
      function flush() {
        if (currentLines == 0)
          return;
        chunked.push(currentChunk.length == 1 ? currentChunk[0] : TextNode.from(currentChunk, currentLen));
        currentLen = -1;
        currentLines = currentChunk.length = 0;
      }
      for (let child of children)
        add2(child);
      flush();
      return chunked.length == 1 ? chunked[0] : new TextNode(chunked, length);
    }
  }
  Text$1.empty = /* @__PURE__ */ new TextLeaf([""], 0);
  function textLength(text) {
    let length = -1;
    for (let line of text)
      length += line.length + 1;
    return length;
  }
  function appendText(text, target, from = 0, to = 1e9) {
    for (let pos = 0, i2 = 0, first = true; i2 < text.length && pos <= to; i2++) {
      let line = text[i2], end = pos + line.length;
      if (end >= from) {
        if (end > to)
          line = line.slice(0, to - pos);
        if (pos < from)
          line = line.slice(from - pos);
        if (first) {
          target[target.length - 1] += line;
          first = false;
        } else
          target.push(line);
      }
      pos = end + 1;
    }
    return target;
  }
  function sliceText(text, from, to) {
    return appendText(text, [""], from, to);
  }
  class RawTextCursor {
    constructor(text, dir = 1) {
      this.dir = dir;
      this.done = false;
      this.lineBreak = false;
      this.value = "";
      this.nodes = [text];
      this.offsets = [dir > 0 ? 1 : (text instanceof TextLeaf ? text.text.length : text.children.length) << 1];
    }
    nextInner(skip, dir) {
      this.done = this.lineBreak = false;
      for (; ; ) {
        let last = this.nodes.length - 1;
        let top2 = this.nodes[last], offsetValue = this.offsets[last], offset = offsetValue >> 1;
        let size2 = top2 instanceof TextLeaf ? top2.text.length : top2.children.length;
        if (offset == (dir > 0 ? size2 : 0)) {
          if (last == 0) {
            this.done = true;
            this.value = "";
            return this;
          }
          if (dir > 0)
            this.offsets[last - 1]++;
          this.nodes.pop();
          this.offsets.pop();
        } else if ((offsetValue & 1) == (dir > 0 ? 0 : 1)) {
          this.offsets[last] += dir;
          if (skip == 0) {
            this.lineBreak = true;
            this.value = "\n";
            return this;
          }
          skip--;
        } else if (top2 instanceof TextLeaf) {
          let next = top2.text[offset + (dir < 0 ? -1 : 0)];
          this.offsets[last] += dir;
          if (next.length > Math.max(0, skip)) {
            this.value = skip == 0 ? next : dir > 0 ? next.slice(skip) : next.slice(0, next.length - skip);
            return this;
          }
          skip -= next.length;
        } else {
          let next = top2.children[offset + (dir < 0 ? -1 : 0)];
          if (skip > next.length) {
            skip -= next.length;
            this.offsets[last] += dir;
          } else {
            if (dir < 0)
              this.offsets[last]--;
            this.nodes.push(next);
            this.offsets.push(dir > 0 ? 1 : (next instanceof TextLeaf ? next.text.length : next.children.length) << 1);
          }
        }
      }
    }
    next(skip = 0) {
      if (skip < 0) {
        this.nextInner(-skip, -this.dir);
        skip = this.value.length;
      }
      return this.nextInner(skip, this.dir);
    }
  }
  class PartialTextCursor {
    constructor(text, start, end) {
      this.value = "";
      this.done = false;
      this.cursor = new RawTextCursor(text, start > end ? -1 : 1);
      this.pos = start > end ? text.length : 0;
      this.from = Math.min(start, end);
      this.to = Math.max(start, end);
    }
    nextInner(skip, dir) {
      if (dir < 0 ? this.pos <= this.from : this.pos >= this.to) {
        this.value = "";
        this.done = true;
        return this;
      }
      skip += Math.max(0, dir < 0 ? this.pos - this.to : this.from - this.pos);
      let limit = dir < 0 ? this.pos - this.from : this.to - this.pos;
      if (skip > limit)
        skip = limit;
      limit -= skip;
      let { value } = this.cursor.next(skip);
      this.pos += (value.length + skip) * dir;
      this.value = value.length <= limit ? value : dir < 0 ? value.slice(value.length - limit) : value.slice(0, limit);
      this.done = !this.value;
      return this;
    }
    next(skip = 0) {
      if (skip < 0)
        skip = Math.max(skip, this.from - this.pos);
      else if (skip > 0)
        skip = Math.min(skip, this.to - this.pos);
      return this.nextInner(skip, this.cursor.dir);
    }
    get lineBreak() {
      return this.cursor.lineBreak && this.value != "";
    }
  }
  class LineCursor {
    constructor(inner) {
      this.inner = inner;
      this.afterBreak = true;
      this.value = "";
      this.done = false;
    }
    next(skip = 0) {
      let { done, lineBreak, value } = this.inner.next(skip);
      if (done && this.afterBreak) {
        this.value = "";
        this.afterBreak = false;
      } else if (done) {
        this.done = true;
        this.value = "";
      } else if (lineBreak) {
        if (this.afterBreak) {
          this.value = "";
        } else {
          this.afterBreak = true;
          this.next();
        }
      } else {
        this.value = value;
        this.afterBreak = false;
      }
      return this;
    }
    get lineBreak() {
      return false;
    }
  }
  if (typeof Symbol != "undefined") {
    Text$1.prototype[Symbol.iterator] = function() {
      return this.iter();
    };
    RawTextCursor.prototype[Symbol.iterator] = PartialTextCursor.prototype[Symbol.iterator] = LineCursor.prototype[Symbol.iterator] = function() {
      return this;
    };
  }
  class Line {
    /**
    @internal
    */
    constructor(from, to, number2, text) {
      this.from = from;
      this.to = to;
      this.number = number2;
      this.text = text;
    }
    /**
    The length of the line (not including any line break after it).
    */
    get length() {
      return this.to - this.from;
    }
  }
  function clip(text, from, to) {
    from = Math.max(0, Math.min(text.length, from));
    return [from, Math.max(from, Math.min(text.length, to))];
  }
  let extend = /* @__PURE__ */ "lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map((s2) => s2 ? parseInt(s2, 36) : 1);
  for (let i2 = 1; i2 < extend.length; i2++)
    extend[i2] += extend[i2 - 1];
  function isExtendingChar(code2) {
    for (let i2 = 1; i2 < extend.length; i2 += 2)
      if (extend[i2] > code2)
        return extend[i2 - 1] <= code2;
    return false;
  }
  function isRegionalIndicator(code2) {
    return code2 >= 127462 && code2 <= 127487;
  }
  const ZWJ = 8205;
  function findClusterBreak(str, pos, forward = true, includeExtending = true) {
    return (forward ? nextClusterBreak : prevClusterBreak)(str, pos, includeExtending);
  }
  function nextClusterBreak(str, pos, includeExtending) {
    if (pos == str.length)
      return pos;
    if (pos && surrogateLow(str.charCodeAt(pos)) && surrogateHigh(str.charCodeAt(pos - 1)))
      pos--;
    let prev = codePointAt(str, pos);
    pos += codePointSize(prev);
    while (pos < str.length) {
      let next = codePointAt(str, pos);
      if (prev == ZWJ || next == ZWJ || includeExtending && isExtendingChar(next)) {
        pos += codePointSize(next);
        prev = next;
      } else if (isRegionalIndicator(next)) {
        let countBefore = 0, i2 = pos - 2;
        while (i2 >= 0 && isRegionalIndicator(codePointAt(str, i2))) {
          countBefore++;
          i2 -= 2;
        }
        if (countBefore % 2 == 0)
          break;
        else
          pos += 2;
      } else {
        break;
      }
    }
    return pos;
  }
  function prevClusterBreak(str, pos, includeExtending) {
    while (pos > 0) {
      let found = nextClusterBreak(str, pos - 2, includeExtending);
      if (found < pos)
        return found;
      pos--;
    }
    return 0;
  }
  function surrogateLow(ch) {
    return ch >= 56320 && ch < 57344;
  }
  function surrogateHigh(ch) {
    return ch >= 55296 && ch < 56320;
  }
  function codePointAt(str, pos) {
    let code0 = str.charCodeAt(pos);
    if (!surrogateHigh(code0) || pos + 1 == str.length)
      return code0;
    let code1 = str.charCodeAt(pos + 1);
    if (!surrogateLow(code1))
      return code0;
    return (code0 - 55296 << 10) + (code1 - 56320) + 65536;
  }
  function fromCodePoint(code2) {
    if (code2 <= 65535)
      return String.fromCharCode(code2);
    code2 -= 65536;
    return String.fromCharCode((code2 >> 10) + 55296, (code2 & 1023) + 56320);
  }
  function codePointSize(code2) {
    return code2 < 65536 ? 1 : 2;
  }
  const DefaultSplit = /\r\n?|\n/;
  var MapMode = /* @__PURE__ */ function(MapMode2) {
    MapMode2[MapMode2["Simple"] = 0] = "Simple";
    MapMode2[MapMode2["TrackDel"] = 1] = "TrackDel";
    MapMode2[MapMode2["TrackBefore"] = 2] = "TrackBefore";
    MapMode2[MapMode2["TrackAfter"] = 3] = "TrackAfter";
    return MapMode2;
  }(MapMode || (MapMode = {}));
  class ChangeDesc {
    // Sections are encoded as pairs of integers. The first is the
    // length in the current document, and the second is -1 for
    // unaffected sections, and the length of the replacement content
    // otherwise. So an insertion would be (0, n>0), a deletion (n>0,
    // 0), and a replacement two positive numbers.
    /**
    @internal
    */
    constructor(sections) {
      this.sections = sections;
    }
    /**
    The length of the document before the change.
    */
    get length() {
      let result = 0;
      for (let i2 = 0; i2 < this.sections.length; i2 += 2)
        result += this.sections[i2];
      return result;
    }
    /**
    The length of the document after the change.
    */
    get newLength() {
      let result = 0;
      for (let i2 = 0; i2 < this.sections.length; i2 += 2) {
        let ins = this.sections[i2 + 1];
        result += ins < 0 ? this.sections[i2] : ins;
      }
      return result;
    }
    /**
    False when there are actual changes in this set.
    */
    get empty() {
      return this.sections.length == 0 || this.sections.length == 2 && this.sections[1] < 0;
    }
    /**
    Iterate over the unchanged parts left by these changes. `posA`
    provides the position of the range in the old document, `posB`
    the new position in the changed document.
    */
    iterGaps(f2) {
      for (let i2 = 0, posA = 0, posB = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++];
        if (ins < 0) {
          f2(posA, posB, len);
          posB += len;
        } else {
          posB += ins;
        }
        posA += len;
      }
    }
    /**
    Iterate over the ranges changed by these changes. (See
    [`ChangeSet.iterChanges`](https://codemirror.net/6/docs/ref/#state.ChangeSet.iterChanges) for a
    variant that also provides you with the inserted text.)
    `fromA`/`toA` provides the extent of the change in the starting
    document, `fromB`/`toB` the extent of the replacement in the
    changed document.
    
    When `individual` is true, adjacent changes (which are kept
    separate for [position mapping](https://codemirror.net/6/docs/ref/#state.ChangeDesc.mapPos)) are
    reported separately.
    */
    iterChangedRanges(f2, individual = false) {
      iterChanges(this, f2, individual);
    }
    /**
    Get a description of the inverted form of these changes.
    */
    get invertedDesc() {
      let sections = [];
      for (let i2 = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++];
        if (ins < 0)
          sections.push(len, ins);
        else
          sections.push(ins, len);
      }
      return new ChangeDesc(sections);
    }
    /**
    Compute the combined effect of applying another set of changes
    after this one. The length of the document after this set should
    match the length before `other`.
    */
    composeDesc(other) {
      return this.empty ? other : other.empty ? this : composeSets(this, other);
    }
    /**
    Map this description, which should start with the same document
    as `other`, over another set of changes, so that it can be
    applied after it. When `before` is true, map as if the changes
    in `other` happened before the ones in `this`.
    */
    mapDesc(other, before = false) {
      return other.empty ? this : mapSet(this, other, before);
    }
    mapPos(pos, assoc = -1, mode = MapMode.Simple) {
      let posA = 0, posB = 0;
      for (let i2 = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++], endA = posA + len;
        if (ins < 0) {
          if (endA > pos)
            return posB + (pos - posA);
          posB += len;
        } else {
          if (mode != MapMode.Simple && endA >= pos && (mode == MapMode.TrackDel && posA < pos && endA > pos || mode == MapMode.TrackBefore && posA < pos || mode == MapMode.TrackAfter && endA > pos))
            return null;
          if (endA > pos || endA == pos && assoc < 0 && !len)
            return pos == posA || assoc < 0 ? posB : posB + ins;
          posB += ins;
        }
        posA = endA;
      }
      if (pos > posA)
        throw new RangeError(`Position ${pos} is out of range for changeset of length ${posA}`);
      return posB;
    }
    /**
    Check whether these changes touch a given range. When one of the
    changes entirely covers the range, the string `"cover"` is
    returned.
    */
    touchesRange(from, to = from) {
      for (let i2 = 0, pos = 0; i2 < this.sections.length && pos <= to; ) {
        let len = this.sections[i2++], ins = this.sections[i2++], end = pos + len;
        if (ins >= 0 && pos <= to && end >= from)
          return pos < from && end > to ? "cover" : true;
        pos = end;
      }
      return false;
    }
    /**
    @internal
    */
    toString() {
      let result = "";
      for (let i2 = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++];
        result += (result ? " " : "") + len + (ins >= 0 ? ":" + ins : "");
      }
      return result;
    }
    /**
    Serialize this change desc to a JSON-representable value.
    */
    toJSON() {
      return this.sections;
    }
    /**
    Create a change desc from its JSON representation (as produced
    by [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeDesc.toJSON).
    */
    static fromJSON(json2) {
      if (!Array.isArray(json2) || json2.length % 2 || json2.some((a2) => typeof a2 != "number"))
        throw new RangeError("Invalid JSON representation of ChangeDesc");
      return new ChangeDesc(json2);
    }
    /**
    @internal
    */
    static create(sections) {
      return new ChangeDesc(sections);
    }
  }
  class ChangeSet extends ChangeDesc {
    constructor(sections, inserted) {
      super(sections);
      this.inserted = inserted;
    }
    /**
    Apply the changes to a document, returning the modified
    document.
    */
    apply(doc2) {
      if (this.length != doc2.length)
        throw new RangeError("Applying change set to a document with the wrong length");
      iterChanges(this, (fromA, toA, fromB, _toB, text) => doc2 = doc2.replace(fromB, fromB + (toA - fromA), text), false);
      return doc2;
    }
    mapDesc(other, before = false) {
      return mapSet(this, other, before, true);
    }
    /**
    Given the document as it existed _before_ the changes, return a
    change set that represents the inverse of this set, which could
    be used to go from the document created by the changes back to
    the document as it existed before the changes.
    */
    invert(doc2) {
      let sections = this.sections.slice(), inserted = [];
      for (let i2 = 0, pos = 0; i2 < sections.length; i2 += 2) {
        let len = sections[i2], ins = sections[i2 + 1];
        if (ins >= 0) {
          sections[i2] = ins;
          sections[i2 + 1] = len;
          let index2 = i2 >> 1;
          while (inserted.length < index2)
            inserted.push(Text$1.empty);
          inserted.push(len ? doc2.slice(pos, pos + len) : Text$1.empty);
        }
        pos += len;
      }
      return new ChangeSet(sections, inserted);
    }
    /**
    Combine two subsequent change sets into a single set. `other`
    must start in the document produced by `this`. If `this` goes
    `docA` → `docB` and `other` represents `docB` → `docC`, the
    returned value will represent the change `docA` → `docC`.
    */
    compose(other) {
      return this.empty ? other : other.empty ? this : composeSets(this, other, true);
    }
    /**
    Given another change set starting in the same document, maps this
    change set over the other, producing a new change set that can be
    applied to the document produced by applying `other`. When
    `before` is `true`, order changes as if `this` comes before
    `other`, otherwise (the default) treat `other` as coming first.
    
    Given two changes `A` and `B`, `A.compose(B.map(A))` and
    `B.compose(A.map(B, true))` will produce the same document. This
    provides a basic form of [operational
    transformation](https://en.wikipedia.org/wiki/Operational_transformation),
    and can be used for collaborative editing.
    */
    map(other, before = false) {
      return other.empty ? this : mapSet(this, other, before, true);
    }
    /**
    Iterate over the changed ranges in the document, calling `f` for
    each, with the range in the original document (`fromA`-`toA`)
    and the range that replaces it in the new document
    (`fromB`-`toB`).
    
    When `individual` is true, adjacent changes are reported
    separately.
    */
    iterChanges(f2, individual = false) {
      iterChanges(this, f2, individual);
    }
    /**
    Get a [change description](https://codemirror.net/6/docs/ref/#state.ChangeDesc) for this change
    set.
    */
    get desc() {
      return ChangeDesc.create(this.sections);
    }
    /**
    @internal
    */
    filter(ranges) {
      let resultSections = [], resultInserted = [], filteredSections = [];
      let iter = new SectionIter(this);
      done:
        for (let i2 = 0, pos = 0; ; ) {
          let next = i2 == ranges.length ? 1e9 : ranges[i2++];
          while (pos < next || pos == next && iter.len == 0) {
            if (iter.done)
              break done;
            let len = Math.min(iter.len, next - pos);
            addSection(filteredSections, len, -1);
            let ins = iter.ins == -1 ? -1 : iter.off == 0 ? iter.ins : 0;
            addSection(resultSections, len, ins);
            if (ins > 0)
              addInsert(resultInserted, resultSections, iter.text);
            iter.forward(len);
            pos += len;
          }
          let end = ranges[i2++];
          while (pos < end) {
            if (iter.done)
              break done;
            let len = Math.min(iter.len, end - pos);
            addSection(resultSections, len, -1);
            addSection(filteredSections, len, iter.ins == -1 ? -1 : iter.off == 0 ? iter.ins : 0);
            iter.forward(len);
            pos += len;
          }
        }
      return {
        changes: new ChangeSet(resultSections, resultInserted),
        filtered: ChangeDesc.create(filteredSections)
      };
    }
    /**
    Serialize this change set to a JSON-representable value.
    */
    toJSON() {
      let parts = [];
      for (let i2 = 0; i2 < this.sections.length; i2 += 2) {
        let len = this.sections[i2], ins = this.sections[i2 + 1];
        if (ins < 0)
          parts.push(len);
        else if (ins == 0)
          parts.push([len]);
        else
          parts.push([len].concat(this.inserted[i2 >> 1].toJSON()));
      }
      return parts;
    }
    /**
    Create a change set for the given changes, for a document of the
    given length, using `lineSep` as line separator.
    */
    static of(changes, length, lineSep) {
      let sections = [], inserted = [], pos = 0;
      let total = null;
      function flush(force = false) {
        if (!force && !sections.length)
          return;
        if (pos < length)
          addSection(sections, length - pos, -1);
        let set2 = new ChangeSet(sections, inserted);
        total = total ? total.compose(set2.map(total)) : set2;
        sections = [];
        inserted = [];
        pos = 0;
      }
      function process2(spec) {
        if (Array.isArray(spec)) {
          for (let sub of spec)
            process2(sub);
        } else if (spec instanceof ChangeSet) {
          if (spec.length != length)
            throw new RangeError(`Mismatched change set length (got ${spec.length}, expected ${length})`);
          flush();
          total = total ? total.compose(spec.map(total)) : spec;
        } else {
          let { from, to = from, insert: insert2 } = spec;
          if (from > to || from < 0 || to > length)
            throw new RangeError(`Invalid change range ${from} to ${to} (in doc of length ${length})`);
          let insText = !insert2 ? Text$1.empty : typeof insert2 == "string" ? Text$1.of(insert2.split(lineSep || DefaultSplit)) : insert2;
          let insLen = insText.length;
          if (from == to && insLen == 0)
            return;
          if (from < pos)
            flush();
          if (from > pos)
            addSection(sections, from - pos, -1);
          addSection(sections, to - from, insLen);
          addInsert(inserted, sections, insText);
          pos = to;
        }
      }
      process2(changes);
      flush(!total);
      return total;
    }
    /**
    Create an empty changeset of the given length.
    */
    static empty(length) {
      return new ChangeSet(length ? [length, -1] : [], []);
    }
    /**
    Create a changeset from its JSON representation (as produced by
    [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeSet.toJSON).
    */
    static fromJSON(json2) {
      if (!Array.isArray(json2))
        throw new RangeError("Invalid JSON representation of ChangeSet");
      let sections = [], inserted = [];
      for (let i2 = 0; i2 < json2.length; i2++) {
        let part = json2[i2];
        if (typeof part == "number") {
          sections.push(part, -1);
        } else if (!Array.isArray(part) || typeof part[0] != "number" || part.some((e2, i22) => i22 && typeof e2 != "string")) {
          throw new RangeError("Invalid JSON representation of ChangeSet");
        } else if (part.length == 1) {
          sections.push(part[0], 0);
        } else {
          while (inserted.length < i2)
            inserted.push(Text$1.empty);
          inserted[i2] = Text$1.of(part.slice(1));
          sections.push(part[0], inserted[i2].length);
        }
      }
      return new ChangeSet(sections, inserted);
    }
    /**
    @internal
    */
    static createSet(sections, inserted) {
      return new ChangeSet(sections, inserted);
    }
  }
  function addSection(sections, len, ins, forceJoin = false) {
    if (len == 0 && ins <= 0)
      return;
    let last = sections.length - 2;
    if (last >= 0 && ins <= 0 && ins == sections[last + 1])
      sections[last] += len;
    else if (len == 0 && sections[last] == 0)
      sections[last + 1] += ins;
    else if (forceJoin) {
      sections[last] += len;
      sections[last + 1] += ins;
    } else
      sections.push(len, ins);
  }
  function addInsert(values2, sections, value) {
    if (value.length == 0)
      return;
    let index2 = sections.length - 2 >> 1;
    if (index2 < values2.length) {
      values2[values2.length - 1] = values2[values2.length - 1].append(value);
    } else {
      while (values2.length < index2)
        values2.push(Text$1.empty);
      values2.push(value);
    }
  }
  function iterChanges(desc, f2, individual) {
    let inserted = desc.inserted;
    for (let posA = 0, posB = 0, i2 = 0; i2 < desc.sections.length; ) {
      let len = desc.sections[i2++], ins = desc.sections[i2++];
      if (ins < 0) {
        posA += len;
        posB += len;
      } else {
        let endA = posA, endB = posB, text = Text$1.empty;
        for (; ; ) {
          endA += len;
          endB += ins;
          if (ins && inserted)
            text = text.append(inserted[i2 - 2 >> 1]);
          if (individual || i2 == desc.sections.length || desc.sections[i2 + 1] < 0)
            break;
          len = desc.sections[i2++];
          ins = desc.sections[i2++];
        }
        f2(posA, endA, posB, endB, text);
        posA = endA;
        posB = endB;
      }
    }
  }
  function mapSet(setA, setB, before, mkSet = false) {
    let sections = [], insert2 = mkSet ? [] : null;
    let a2 = new SectionIter(setA), b2 = new SectionIter(setB);
    for (let inserted = -1; ; ) {
      if (a2.ins == -1 && b2.ins == -1) {
        let len = Math.min(a2.len, b2.len);
        addSection(sections, len, -1);
        a2.forward(len);
        b2.forward(len);
      } else if (b2.ins >= 0 && (a2.ins < 0 || inserted == a2.i || a2.off == 0 && (b2.len < a2.len || b2.len == a2.len && !before))) {
        let len = b2.len;
        addSection(sections, b2.ins, -1);
        while (len) {
          let piece = Math.min(a2.len, len);
          if (a2.ins >= 0 && inserted < a2.i && a2.len <= piece) {
            addSection(sections, 0, a2.ins);
            if (insert2)
              addInsert(insert2, sections, a2.text);
            inserted = a2.i;
          }
          a2.forward(piece);
          len -= piece;
        }
        b2.next();
      } else if (a2.ins >= 0) {
        let len = 0, left = a2.len;
        while (left) {
          if (b2.ins == -1) {
            let piece = Math.min(left, b2.len);
            len += piece;
            left -= piece;
            b2.forward(piece);
          } else if (b2.ins == 0 && b2.len < left) {
            left -= b2.len;
            b2.next();
          } else {
            break;
          }
        }
        addSection(sections, len, inserted < a2.i ? a2.ins : 0);
        if (insert2 && inserted < a2.i)
          addInsert(insert2, sections, a2.text);
        inserted = a2.i;
        a2.forward(a2.len - left);
      } else if (a2.done && b2.done) {
        return insert2 ? ChangeSet.createSet(sections, insert2) : ChangeDesc.create(sections);
      } else {
        throw new Error("Mismatched change set lengths");
      }
    }
  }
  function composeSets(setA, setB, mkSet = false) {
    let sections = [];
    let insert2 = mkSet ? [] : null;
    let a2 = new SectionIter(setA), b2 = new SectionIter(setB);
    for (let open = false; ; ) {
      if (a2.done && b2.done) {
        return insert2 ? ChangeSet.createSet(sections, insert2) : ChangeDesc.create(sections);
      } else if (a2.ins == 0) {
        addSection(sections, a2.len, 0, open);
        a2.next();
      } else if (b2.len == 0 && !b2.done) {
        addSection(sections, 0, b2.ins, open);
        if (insert2)
          addInsert(insert2, sections, b2.text);
        b2.next();
      } else if (a2.done || b2.done) {
        throw new Error("Mismatched change set lengths");
      } else {
        let len = Math.min(a2.len2, b2.len), sectionLen = sections.length;
        if (a2.ins == -1) {
          let insB = b2.ins == -1 ? -1 : b2.off ? 0 : b2.ins;
          addSection(sections, len, insB, open);
          if (insert2 && insB)
            addInsert(insert2, sections, b2.text);
        } else if (b2.ins == -1) {
          addSection(sections, a2.off ? 0 : a2.len, len, open);
          if (insert2)
            addInsert(insert2, sections, a2.textBit(len));
        } else {
          addSection(sections, a2.off ? 0 : a2.len, b2.off ? 0 : b2.ins, open);
          if (insert2 && !b2.off)
            addInsert(insert2, sections, b2.text);
        }
        open = (a2.ins > len || b2.ins >= 0 && b2.len > len) && (open || sections.length > sectionLen);
        a2.forward2(len);
        b2.forward(len);
      }
    }
  }
  class SectionIter {
    constructor(set2) {
      this.set = set2;
      this.i = 0;
      this.next();
    }
    next() {
      let { sections } = this.set;
      if (this.i < sections.length) {
        this.len = sections[this.i++];
        this.ins = sections[this.i++];
      } else {
        this.len = 0;
        this.ins = -2;
      }
      this.off = 0;
    }
    get done() {
      return this.ins == -2;
    }
    get len2() {
      return this.ins < 0 ? this.len : this.ins;
    }
    get text() {
      let { inserted } = this.set, index2 = this.i - 2 >> 1;
      return index2 >= inserted.length ? Text$1.empty : inserted[index2];
    }
    textBit(len) {
      let { inserted } = this.set, index2 = this.i - 2 >> 1;
      return index2 >= inserted.length && !len ? Text$1.empty : inserted[index2].slice(this.off, len == null ? void 0 : this.off + len);
    }
    forward(len) {
      if (len == this.len)
        this.next();
      else {
        this.len -= len;
        this.off += len;
      }
    }
    forward2(len) {
      if (this.ins == -1)
        this.forward(len);
      else if (len == this.ins)
        this.next();
      else {
        this.ins -= len;
        this.off += len;
      }
    }
  }
  class SelectionRange {
    constructor(from, to, flags) {
      this.from = from;
      this.to = to;
      this.flags = flags;
    }
    /**
    The anchor of the range—the side that doesn't move when you
    extend it.
    */
    get anchor() {
      return this.flags & 32 ? this.to : this.from;
    }
    /**
    The head of the range, which is moved when the range is
    [extended](https://codemirror.net/6/docs/ref/#state.SelectionRange.extend).
    */
    get head() {
      return this.flags & 32 ? this.from : this.to;
    }
    /**
    True when `anchor` and `head` are at the same position.
    */
    get empty() {
      return this.from == this.to;
    }
    /**
    If this is a cursor that is explicitly associated with the
    character on one of its sides, this returns the side. -1 means
    the character before its position, 1 the character after, and 0
    means no association.
    */
    get assoc() {
      return this.flags & 8 ? -1 : this.flags & 16 ? 1 : 0;
    }
    /**
    The bidirectional text level associated with this cursor, if
    any.
    */
    get bidiLevel() {
      let level = this.flags & 7;
      return level == 7 ? null : level;
    }
    /**
    The goal column (stored vertical offset) associated with a
    cursor. This is used to preserve the vertical position when
    [moving](https://codemirror.net/6/docs/ref/#view.EditorView.moveVertically) across
    lines of different length.
    */
    get goalColumn() {
      let value = this.flags >> 6;
      return value == 16777215 ? void 0 : value;
    }
    /**
    Map this range through a change, producing a valid range in the
    updated document.
    */
    map(change, assoc = -1) {
      let from, to;
      if (this.empty) {
        from = to = change.mapPos(this.from, assoc);
      } else {
        from = change.mapPos(this.from, 1);
        to = change.mapPos(this.to, -1);
      }
      return from == this.from && to == this.to ? this : new SelectionRange(from, to, this.flags);
    }
    /**
    Extend this range to cover at least `from` to `to`.
    */
    extend(from, to = from) {
      if (from <= this.anchor && to >= this.anchor)
        return EditorSelection.range(from, to);
      let head = Math.abs(from - this.anchor) > Math.abs(to - this.anchor) ? from : to;
      return EditorSelection.range(this.anchor, head);
    }
    /**
    Compare this range to another range.
    */
    eq(other, includeAssoc = false) {
      return this.anchor == other.anchor && this.head == other.head && (!includeAssoc || !this.empty || this.assoc == other.assoc);
    }
    /**
    Return a JSON-serializable object representing the range.
    */
    toJSON() {
      return { anchor: this.anchor, head: this.head };
    }
    /**
    Convert a JSON representation of a range to a `SelectionRange`
    instance.
    */
    static fromJSON(json2) {
      if (!json2 || typeof json2.anchor != "number" || typeof json2.head != "number")
        throw new RangeError("Invalid JSON representation for SelectionRange");
      return EditorSelection.range(json2.anchor, json2.head);
    }
    /**
    @internal
    */
    static create(from, to, flags) {
      return new SelectionRange(from, to, flags);
    }
  }
  class EditorSelection {
    constructor(ranges, mainIndex) {
      this.ranges = ranges;
      this.mainIndex = mainIndex;
    }
    /**
    Map a selection through a change. Used to adjust the selection
    position for changes.
    */
    map(change, assoc = -1) {
      if (change.empty)
        return this;
      return EditorSelection.create(this.ranges.map((r2) => r2.map(change, assoc)), this.mainIndex);
    }
    /**
    Compare this selection to another selection. By default, ranges
    are compared only by position. When `includeAssoc` is true,
    cursor ranges must also have the same
    [`assoc`](https://codemirror.net/6/docs/ref/#state.SelectionRange.assoc) value.
    */
    eq(other, includeAssoc = false) {
      if (this.ranges.length != other.ranges.length || this.mainIndex != other.mainIndex)
        return false;
      for (let i2 = 0; i2 < this.ranges.length; i2++)
        if (!this.ranges[i2].eq(other.ranges[i2], includeAssoc))
          return false;
      return true;
    }
    /**
    Get the primary selection range. Usually, you should make sure
    your code applies to _all_ ranges, by using methods like
    [`changeByRange`](https://codemirror.net/6/docs/ref/#state.EditorState.changeByRange).
    */
    get main() {
      return this.ranges[this.mainIndex];
    }
    /**
    Make sure the selection only has one range. Returns a selection
    holding only the main range from this selection.
    */
    asSingle() {
      return this.ranges.length == 1 ? this : new EditorSelection([this.main], 0);
    }
    /**
    Extend this selection with an extra range.
    */
    addRange(range2, main = true) {
      return EditorSelection.create([range2].concat(this.ranges), main ? 0 : this.mainIndex + 1);
    }
    /**
    Replace a given range with another range, and then normalize the
    selection to merge and sort ranges if necessary.
    */
    replaceRange(range2, which = this.mainIndex) {
      let ranges = this.ranges.slice();
      ranges[which] = range2;
      return EditorSelection.create(ranges, this.mainIndex);
    }
    /**
    Convert this selection to an object that can be serialized to
    JSON.
    */
    toJSON() {
      return { ranges: this.ranges.map((r2) => r2.toJSON()), main: this.mainIndex };
    }
    /**
    Create a selection from a JSON representation.
    */
    static fromJSON(json2) {
      if (!json2 || !Array.isArray(json2.ranges) || typeof json2.main != "number" || json2.main >= json2.ranges.length)
        throw new RangeError("Invalid JSON representation for EditorSelection");
      return new EditorSelection(json2.ranges.map((r2) => SelectionRange.fromJSON(r2)), json2.main);
    }
    /**
    Create a selection holding a single range.
    */
    static single(anchor, head = anchor) {
      return new EditorSelection([EditorSelection.range(anchor, head)], 0);
    }
    /**
    Sort and merge the given set of ranges, creating a valid
    selection.
    */
    static create(ranges, mainIndex = 0) {
      if (ranges.length == 0)
        throw new RangeError("A selection needs at least one range");
      for (let pos = 0, i2 = 0; i2 < ranges.length; i2++) {
        let range2 = ranges[i2];
        if (range2.empty ? range2.from <= pos : range2.from < pos)
          return EditorSelection.normalized(ranges.slice(), mainIndex);
        pos = range2.to;
      }
      return new EditorSelection(ranges, mainIndex);
    }
    /**
    Create a cursor selection range at the given position. You can
    safely ignore the optional arguments in most situations.
    */
    static cursor(pos, assoc = 0, bidiLevel, goalColumn) {
      return SelectionRange.create(pos, pos, (assoc == 0 ? 0 : assoc < 0 ? 8 : 16) | (bidiLevel == null ? 7 : Math.min(6, bidiLevel)) | (goalColumn !== null && goalColumn !== void 0 ? goalColumn : 16777215) << 6);
    }
    /**
    Create a selection range.
    */
    static range(anchor, head, goalColumn, bidiLevel) {
      let flags = (goalColumn !== null && goalColumn !== void 0 ? goalColumn : 16777215) << 6 | (bidiLevel == null ? 7 : Math.min(6, bidiLevel));
      return head < anchor ? SelectionRange.create(head, anchor, 32 | 16 | flags) : SelectionRange.create(anchor, head, (head > anchor ? 8 : 0) | flags);
    }
    /**
    @internal
    */
    static normalized(ranges, mainIndex = 0) {
      let main = ranges[mainIndex];
      ranges.sort((a2, b2) => a2.from - b2.from);
      mainIndex = ranges.indexOf(main);
      for (let i2 = 1; i2 < ranges.length; i2++) {
        let range2 = ranges[i2], prev = ranges[i2 - 1];
        if (range2.empty ? range2.from <= prev.to : range2.from < prev.to) {
          let from = prev.from, to = Math.max(range2.to, prev.to);
          if (i2 <= mainIndex)
            mainIndex--;
          ranges.splice(--i2, 2, range2.anchor > range2.head ? EditorSelection.range(to, from) : EditorSelection.range(from, to));
        }
      }
      return new EditorSelection(ranges, mainIndex);
    }
  }
  function checkSelection(selection, docLength) {
    for (let range2 of selection.ranges)
      if (range2.to > docLength)
        throw new RangeError("Selection points outside of document");
  }
  let nextID = 0;
  class Facet {
    constructor(combine, compareInput, compare2, isStatic, enables) {
      this.combine = combine;
      this.compareInput = compareInput;
      this.compare = compare2;
      this.isStatic = isStatic;
      this.id = nextID++;
      this.default = combine([]);
      this.extensions = typeof enables == "function" ? enables(this) : enables;
    }
    /**
    Returns a facet reader for this facet, which can be used to
    [read](https://codemirror.net/6/docs/ref/#state.EditorState.facet) it but not to define values for it.
    */
    get reader() {
      return this;
    }
    /**
    Define a new facet.
    */
    static define(config2 = {}) {
      return new Facet(config2.combine || ((a2) => a2), config2.compareInput || ((a2, b2) => a2 === b2), config2.compare || (!config2.combine ? sameArray$1 : (a2, b2) => a2 === b2), !!config2.static, config2.enables);
    }
    /**
    Returns an extension that adds the given value to this facet.
    */
    of(value) {
      return new FacetProvider([], this, 0, value);
    }
    /**
    Create an extension that computes a value for the facet from a
    state. You must take care to declare the parts of the state that
    this value depends on, since your function is only called again
    for a new state when one of those parts changed.
    
    In cases where your value depends only on a single field, you'll
    want to use the [`from`](https://codemirror.net/6/docs/ref/#state.Facet.from) method instead.
    */
    compute(deps, get2) {
      if (this.isStatic)
        throw new Error("Can't compute a static facet");
      return new FacetProvider(deps, this, 1, get2);
    }
    /**
    Create an extension that computes zero or more values for this
    facet from a state.
    */
    computeN(deps, get2) {
      if (this.isStatic)
        throw new Error("Can't compute a static facet");
      return new FacetProvider(deps, this, 2, get2);
    }
    from(field, get2) {
      if (!get2)
        get2 = (x2) => x2;
      return this.compute([field], (state2) => get2(state2.field(field)));
    }
  }
  function sameArray$1(a2, b2) {
    return a2 == b2 || a2.length == b2.length && a2.every((e2, i2) => e2 === b2[i2]);
  }
  class FacetProvider {
    constructor(dependencies, facet, type, value) {
      this.dependencies = dependencies;
      this.facet = facet;
      this.type = type;
      this.value = value;
      this.id = nextID++;
    }
    dynamicSlot(addresses) {
      var _a2;
      let getter = this.value;
      let compare2 = this.facet.compareInput;
      let id2 = this.id, idx = addresses[id2] >> 1, multi = this.type == 2;
      let depDoc = false, depSel = false, depAddrs = [];
      for (let dep of this.dependencies) {
        if (dep == "doc")
          depDoc = true;
        else if (dep == "selection")
          depSel = true;
        else if ((((_a2 = addresses[dep.id]) !== null && _a2 !== void 0 ? _a2 : 1) & 1) == 0)
          depAddrs.push(addresses[dep.id]);
      }
      return {
        create(state2) {
          state2.values[idx] = getter(state2);
          return 1;
        },
        update(state2, tr) {
          if (depDoc && tr.docChanged || depSel && (tr.docChanged || tr.selection) || ensureAll(state2, depAddrs)) {
            let newVal = getter(state2);
            if (multi ? !compareArray(newVal, state2.values[idx], compare2) : !compare2(newVal, state2.values[idx])) {
              state2.values[idx] = newVal;
              return 1;
            }
          }
          return 0;
        },
        reconfigure: (state2, oldState) => {
          let newVal, oldAddr = oldState.config.address[id2];
          if (oldAddr != null) {
            let oldVal = getAddr(oldState, oldAddr);
            if (this.dependencies.every((dep) => {
              return dep instanceof Facet ? oldState.facet(dep) === state2.facet(dep) : dep instanceof StateField ? oldState.field(dep, false) == state2.field(dep, false) : true;
            }) || (multi ? compareArray(newVal = getter(state2), oldVal, compare2) : compare2(newVal = getter(state2), oldVal))) {
              state2.values[idx] = oldVal;
              return 0;
            }
          } else {
            newVal = getter(state2);
          }
          state2.values[idx] = newVal;
          return 1;
        }
      };
    }
  }
  function compareArray(a2, b2, compare2) {
    if (a2.length != b2.length)
      return false;
    for (let i2 = 0; i2 < a2.length; i2++)
      if (!compare2(a2[i2], b2[i2]))
        return false;
    return true;
  }
  function ensureAll(state2, addrs) {
    let changed = false;
    for (let addr of addrs)
      if (ensureAddr(state2, addr) & 1)
        changed = true;
    return changed;
  }
  function dynamicFacetSlot(addresses, facet, providers) {
    let providerAddrs = providers.map((p2) => addresses[p2.id]);
    let providerTypes = providers.map((p2) => p2.type);
    let dynamic = providerAddrs.filter((p2) => !(p2 & 1));
    let idx = addresses[facet.id] >> 1;
    function get2(state2) {
      let values2 = [];
      for (let i2 = 0; i2 < providerAddrs.length; i2++) {
        let value = getAddr(state2, providerAddrs[i2]);
        if (providerTypes[i2] == 2)
          for (let val of value)
            values2.push(val);
        else
          values2.push(value);
      }
      return facet.combine(values2);
    }
    return {
      create(state2) {
        for (let addr of providerAddrs)
          ensureAddr(state2, addr);
        state2.values[idx] = get2(state2);
        return 1;
      },
      update(state2, tr) {
        if (!ensureAll(state2, dynamic))
          return 0;
        let value = get2(state2);
        if (facet.compare(value, state2.values[idx]))
          return 0;
        state2.values[idx] = value;
        return 1;
      },
      reconfigure(state2, oldState) {
        let depChanged = ensureAll(state2, providerAddrs);
        let oldProviders = oldState.config.facets[facet.id], oldValue = oldState.facet(facet);
        if (oldProviders && !depChanged && sameArray$1(providers, oldProviders)) {
          state2.values[idx] = oldValue;
          return 0;
        }
        let value = get2(state2);
        if (facet.compare(value, oldValue)) {
          state2.values[idx] = oldValue;
          return 0;
        }
        state2.values[idx] = value;
        return 1;
      }
    };
  }
  const initField = /* @__PURE__ */ Facet.define({ static: true });
  class StateField {
    constructor(id2, createF, updateF, compareF, spec) {
      this.id = id2;
      this.createF = createF;
      this.updateF = updateF;
      this.compareF = compareF;
      this.spec = spec;
      this.provides = void 0;
    }
    /**
    Define a state field.
    */
    static define(config2) {
      let field = new StateField(nextID++, config2.create, config2.update, config2.compare || ((a2, b2) => a2 === b2), config2);
      if (config2.provide)
        field.provides = config2.provide(field);
      return field;
    }
    create(state2) {
      let init = state2.facet(initField).find((i2) => i2.field == this);
      return ((init === null || init === void 0 ? void 0 : init.create) || this.createF)(state2);
    }
    /**
    @internal
    */
    slot(addresses) {
      let idx = addresses[this.id] >> 1;
      return {
        create: (state2) => {
          state2.values[idx] = this.create(state2);
          return 1;
        },
        update: (state2, tr) => {
          let oldVal = state2.values[idx];
          let value = this.updateF(oldVal, tr);
          if (this.compareF(oldVal, value))
            return 0;
          state2.values[idx] = value;
          return 1;
        },
        reconfigure: (state2, oldState) => {
          if (oldState.config.address[this.id] != null) {
            state2.values[idx] = oldState.field(this);
            return 0;
          }
          state2.values[idx] = this.create(state2);
          return 1;
        }
      };
    }
    /**
    Returns an extension that enables this field and overrides the
    way it is initialized. Can be useful when you need to provide a
    non-default starting value for the field.
    */
    init(create) {
      return [this, initField.of({ field: this, create })];
    }
    /**
    State field instances can be used as
    [`Extension`](https://codemirror.net/6/docs/ref/#state.Extension) values to enable the field in a
    given state.
    */
    get extension() {
      return this;
    }
  }
  const Prec_ = { lowest: 4, low: 3, default: 2, high: 1, highest: 0 };
  function prec(value) {
    return (ext) => new PrecExtension(ext, value);
  }
  const Prec = {
    /**
    The highest precedence level, for extensions that should end up
    near the start of the precedence ordering.
    */
    highest: /* @__PURE__ */ prec(Prec_.highest),
    /**
    A higher-than-default precedence, for extensions that should
    come before those with default precedence.
    */
    high: /* @__PURE__ */ prec(Prec_.high),
    /**
    The default precedence, which is also used for extensions
    without an explicit precedence.
    */
    default: /* @__PURE__ */ prec(Prec_.default),
    /**
    A lower-than-default precedence.
    */
    low: /* @__PURE__ */ prec(Prec_.low),
    /**
    The lowest precedence level. Meant for things that should end up
    near the end of the extension order.
    */
    lowest: /* @__PURE__ */ prec(Prec_.lowest)
  };
  class PrecExtension {
    constructor(inner, prec2) {
      this.inner = inner;
      this.prec = prec2;
    }
  }
  class Compartment {
    /**
    Create an instance of this compartment to add to your [state
    configuration](https://codemirror.net/6/docs/ref/#state.EditorStateConfig.extensions).
    */
    of(ext) {
      return new CompartmentInstance(this, ext);
    }
    /**
    Create an [effect](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) that
    reconfigures this compartment.
    */
    reconfigure(content2) {
      return Compartment.reconfigure.of({ compartment: this, extension: content2 });
    }
    /**
    Get the current content of the compartment in the state, or
    `undefined` if it isn't present.
    */
    get(state2) {
      return state2.config.compartments.get(this);
    }
  }
  class CompartmentInstance {
    constructor(compartment, inner) {
      this.compartment = compartment;
      this.inner = inner;
    }
  }
  class Configuration {
    constructor(base2, compartments, dynamicSlots, address, staticValues, facets) {
      this.base = base2;
      this.compartments = compartments;
      this.dynamicSlots = dynamicSlots;
      this.address = address;
      this.staticValues = staticValues;
      this.facets = facets;
      this.statusTemplate = [];
      while (this.statusTemplate.length < dynamicSlots.length)
        this.statusTemplate.push(
          0
          /* SlotStatus.Unresolved */
        );
    }
    staticFacet(facet) {
      let addr = this.address[facet.id];
      return addr == null ? facet.default : this.staticValues[addr >> 1];
    }
    static resolve(base2, compartments, oldState) {
      let fields = [];
      let facets = /* @__PURE__ */ Object.create(null);
      let newCompartments = /* @__PURE__ */ new Map();
      for (let ext of flatten(base2, compartments, newCompartments)) {
        if (ext instanceof StateField)
          fields.push(ext);
        else
          (facets[ext.facet.id] || (facets[ext.facet.id] = [])).push(ext);
      }
      let address = /* @__PURE__ */ Object.create(null);
      let staticValues = [];
      let dynamicSlots = [];
      for (let field of fields) {
        address[field.id] = dynamicSlots.length << 1;
        dynamicSlots.push((a2) => field.slot(a2));
      }
      let oldFacets = oldState === null || oldState === void 0 ? void 0 : oldState.config.facets;
      for (let id2 in facets) {
        let providers = facets[id2], facet = providers[0].facet;
        let oldProviders = oldFacets && oldFacets[id2] || [];
        if (providers.every(
          (p2) => p2.type == 0
          /* Provider.Static */
        )) {
          address[facet.id] = staticValues.length << 1 | 1;
          if (sameArray$1(oldProviders, providers)) {
            staticValues.push(oldState.facet(facet));
          } else {
            let value = facet.combine(providers.map((p2) => p2.value));
            staticValues.push(oldState && facet.compare(value, oldState.facet(facet)) ? oldState.facet(facet) : value);
          }
        } else {
          for (let p2 of providers) {
            if (p2.type == 0) {
              address[p2.id] = staticValues.length << 1 | 1;
              staticValues.push(p2.value);
            } else {
              address[p2.id] = dynamicSlots.length << 1;
              dynamicSlots.push((a2) => p2.dynamicSlot(a2));
            }
          }
          address[facet.id] = dynamicSlots.length << 1;
          dynamicSlots.push((a2) => dynamicFacetSlot(a2, facet, providers));
        }
      }
      let dynamic = dynamicSlots.map((f2) => f2(address));
      return new Configuration(base2, newCompartments, dynamic, address, staticValues, facets);
    }
  }
  function flatten(extension, compartments, newCompartments) {
    let result = [[], [], [], [], []];
    let seen2 = /* @__PURE__ */ new Map();
    function inner(ext, prec2) {
      let known = seen2.get(ext);
      if (known != null) {
        if (known <= prec2)
          return;
        let found = result[known].indexOf(ext);
        if (found > -1)
          result[known].splice(found, 1);
        if (ext instanceof CompartmentInstance)
          newCompartments.delete(ext.compartment);
      }
      seen2.set(ext, prec2);
      if (Array.isArray(ext)) {
        for (let e2 of ext)
          inner(e2, prec2);
      } else if (ext instanceof CompartmentInstance) {
        if (newCompartments.has(ext.compartment))
          throw new RangeError(`Duplicate use of compartment in extensions`);
        let content2 = compartments.get(ext.compartment) || ext.inner;
        newCompartments.set(ext.compartment, content2);
        inner(content2, prec2);
      } else if (ext instanceof PrecExtension) {
        inner(ext.inner, ext.prec);
      } else if (ext instanceof StateField) {
        result[prec2].push(ext);
        if (ext.provides)
          inner(ext.provides, prec2);
      } else if (ext instanceof FacetProvider) {
        result[prec2].push(ext);
        if (ext.facet.extensions)
          inner(ext.facet.extensions, Prec_.default);
      } else {
        let content2 = ext.extension;
        if (!content2)
          throw new Error(`Unrecognized extension value in extension set (${ext}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);
        inner(content2, prec2);
      }
    }
    inner(extension, Prec_.default);
    return result.reduce((a2, b2) => a2.concat(b2));
  }
  function ensureAddr(state2, addr) {
    if (addr & 1)
      return 2;
    let idx = addr >> 1;
    let status = state2.status[idx];
    if (status == 4)
      throw new Error("Cyclic dependency between fields and/or facets");
    if (status & 2)
      return status;
    state2.status[idx] = 4;
    let changed = state2.computeSlot(state2, state2.config.dynamicSlots[idx]);
    return state2.status[idx] = 2 | changed;
  }
  function getAddr(state2, addr) {
    return addr & 1 ? state2.config.staticValues[addr >> 1] : state2.values[addr >> 1];
  }
  const languageData = /* @__PURE__ */ Facet.define();
  const allowMultipleSelections = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.some((v2) => v2),
    static: true
  });
  const lineSeparator = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.length ? values2[0] : void 0,
    static: true
  });
  const changeFilter = /* @__PURE__ */ Facet.define();
  const transactionFilter = /* @__PURE__ */ Facet.define();
  const transactionExtender = /* @__PURE__ */ Facet.define();
  const readOnly = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.length ? values2[0] : false
  });
  class Annotation {
    /**
    @internal
    */
    constructor(type, value) {
      this.type = type;
      this.value = value;
    }
    /**
    Define a new type of annotation.
    */
    static define() {
      return new AnnotationType();
    }
  }
  class AnnotationType {
    /**
    Create an instance of this annotation.
    */
    of(value) {
      return new Annotation(this, value);
    }
  }
  class StateEffectType {
    /**
    @internal
    */
    constructor(map2) {
      this.map = map2;
    }
    /**
    Create a [state effect](https://codemirror.net/6/docs/ref/#state.StateEffect) instance of this
    type.
    */
    of(value) {
      return new StateEffect(this, value);
    }
  }
  class StateEffect {
    /**
    @internal
    */
    constructor(type, value) {
      this.type = type;
      this.value = value;
    }
    /**
    Map this effect through a position mapping. Will return
    `undefined` when that ends up deleting the effect.
    */
    map(mapping) {
      let mapped = this.type.map(this.value, mapping);
      return mapped === void 0 ? void 0 : mapped == this.value ? this : new StateEffect(this.type, mapped);
    }
    /**
    Tells you whether this effect object is of a given
    [type](https://codemirror.net/6/docs/ref/#state.StateEffectType).
    */
    is(type) {
      return this.type == type;
    }
    /**
    Define a new effect type. The type parameter indicates the type
    of values that his effect holds. It should be a type that
    doesn't include `undefined`, since that is used in
    [mapping](https://codemirror.net/6/docs/ref/#state.StateEffect.map) to indicate that an effect is
    removed.
    */
    static define(spec = {}) {
      return new StateEffectType(spec.map || ((v2) => v2));
    }
    /**
    Map an array of effects through a change set.
    */
    static mapEffects(effects, mapping) {
      if (!effects.length)
        return effects;
      let result = [];
      for (let effect2 of effects) {
        let mapped = effect2.map(mapping);
        if (mapped)
          result.push(mapped);
      }
      return result;
    }
  }
  StateEffect.reconfigure = /* @__PURE__ */ StateEffect.define();
  StateEffect.appendConfig = /* @__PURE__ */ StateEffect.define();
  class Transaction {
    constructor(startState, changes, selection, effects, annotations, scrollIntoView2) {
      this.startState = startState;
      this.changes = changes;
      this.selection = selection;
      this.effects = effects;
      this.annotations = annotations;
      this.scrollIntoView = scrollIntoView2;
      this._doc = null;
      this._state = null;
      if (selection)
        checkSelection(selection, changes.newLength);
      if (!annotations.some((a2) => a2.type == Transaction.time))
        this.annotations = annotations.concat(Transaction.time.of(Date.now()));
    }
    /**
    @internal
    */
    static create(startState, changes, selection, effects, annotations, scrollIntoView2) {
      return new Transaction(startState, changes, selection, effects, annotations, scrollIntoView2);
    }
    /**
    The new document produced by the transaction. Contrary to
    [`.state`](https://codemirror.net/6/docs/ref/#state.Transaction.state)`.doc`, accessing this won't
    force the entire new state to be computed right away, so it is
    recommended that [transaction
    filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) use this getter
    when they need to look at the new document.
    */
    get newDoc() {
      return this._doc || (this._doc = this.changes.apply(this.startState.doc));
    }
    /**
    The new selection produced by the transaction. If
    [`this.selection`](https://codemirror.net/6/docs/ref/#state.Transaction.selection) is undefined,
    this will [map](https://codemirror.net/6/docs/ref/#state.EditorSelection.map) the start state's
    current selection through the changes made by the transaction.
    */
    get newSelection() {
      return this.selection || this.startState.selection.map(this.changes);
    }
    /**
    The new state created by the transaction. Computed on demand
    (but retained for subsequent access), so it is recommended not to
    access it in [transaction
    filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) when possible.
    */
    get state() {
      if (!this._state)
        this.startState.applyTransaction(this);
      return this._state;
    }
    /**
    Get the value of the given annotation type, if any.
    */
    annotation(type) {
      for (let ann of this.annotations)
        if (ann.type == type)
          return ann.value;
      return void 0;
    }
    /**
    Indicates whether the transaction changed the document.
    */
    get docChanged() {
      return !this.changes.empty;
    }
    /**
    Indicates whether this transaction reconfigures the state
    (through a [configuration compartment](https://codemirror.net/6/docs/ref/#state.Compartment) or
    with a top-level configuration
    [effect](https://codemirror.net/6/docs/ref/#state.StateEffect^reconfigure).
    */
    get reconfigured() {
      return this.startState.config != this.state.config;
    }
    /**
    Returns true if the transaction has a [user
    event](https://codemirror.net/6/docs/ref/#state.Transaction^userEvent) annotation that is equal to
    or more specific than `event`. For example, if the transaction
    has `"select.pointer"` as user event, `"select"` and
    `"select.pointer"` will match it.
    */
    isUserEvent(event) {
      let e2 = this.annotation(Transaction.userEvent);
      return !!(e2 && (e2 == event || e2.length > event.length && e2.slice(0, event.length) == event && e2[event.length] == "."));
    }
  }
  Transaction.time = /* @__PURE__ */ Annotation.define();
  Transaction.userEvent = /* @__PURE__ */ Annotation.define();
  Transaction.addToHistory = /* @__PURE__ */ Annotation.define();
  Transaction.remote = /* @__PURE__ */ Annotation.define();
  function joinRanges(a2, b2) {
    let result = [];
    for (let iA = 0, iB = 0; ; ) {
      let from, to;
      if (iA < a2.length && (iB == b2.length || b2[iB] >= a2[iA])) {
        from = a2[iA++];
        to = a2[iA++];
      } else if (iB < b2.length) {
        from = b2[iB++];
        to = b2[iB++];
      } else
        return result;
      if (!result.length || result[result.length - 1] < from)
        result.push(from, to);
      else if (result[result.length - 1] < to)
        result[result.length - 1] = to;
    }
  }
  function mergeTransaction(a2, b2, sequential) {
    var _a2;
    let mapForA, mapForB, changes;
    if (sequential) {
      mapForA = b2.changes;
      mapForB = ChangeSet.empty(b2.changes.length);
      changes = a2.changes.compose(b2.changes);
    } else {
      mapForA = b2.changes.map(a2.changes);
      mapForB = a2.changes.mapDesc(b2.changes, true);
      changes = a2.changes.compose(mapForA);
    }
    return {
      changes,
      selection: b2.selection ? b2.selection.map(mapForB) : (_a2 = a2.selection) === null || _a2 === void 0 ? void 0 : _a2.map(mapForA),
      effects: StateEffect.mapEffects(a2.effects, mapForA).concat(StateEffect.mapEffects(b2.effects, mapForB)),
      annotations: a2.annotations.length ? a2.annotations.concat(b2.annotations) : b2.annotations,
      scrollIntoView: a2.scrollIntoView || b2.scrollIntoView
    };
  }
  function resolveTransactionInner(state2, spec, docSize) {
    let sel = spec.selection, annotations = asArray$1(spec.annotations);
    if (spec.userEvent)
      annotations = annotations.concat(Transaction.userEvent.of(spec.userEvent));
    return {
      changes: spec.changes instanceof ChangeSet ? spec.changes : ChangeSet.of(spec.changes || [], docSize, state2.facet(lineSeparator)),
      selection: sel && (sel instanceof EditorSelection ? sel : EditorSelection.single(sel.anchor, sel.head)),
      effects: asArray$1(spec.effects),
      annotations,
      scrollIntoView: !!spec.scrollIntoView
    };
  }
  function resolveTransaction(state2, specs, filter) {
    let s2 = resolveTransactionInner(state2, specs.length ? specs[0] : {}, state2.doc.length);
    if (specs.length && specs[0].filter === false)
      filter = false;
    for (let i2 = 1; i2 < specs.length; i2++) {
      if (specs[i2].filter === false)
        filter = false;
      let seq = !!specs[i2].sequential;
      s2 = mergeTransaction(s2, resolveTransactionInner(state2, specs[i2], seq ? s2.changes.newLength : state2.doc.length), seq);
    }
    let tr = Transaction.create(state2, s2.changes, s2.selection, s2.effects, s2.annotations, s2.scrollIntoView);
    return extendTransaction(filter ? filterTransaction(tr) : tr);
  }
  function filterTransaction(tr) {
    let state2 = tr.startState;
    let result = true;
    for (let filter of state2.facet(changeFilter)) {
      let value = filter(tr);
      if (value === false) {
        result = false;
        break;
      }
      if (Array.isArray(value))
        result = result === true ? value : joinRanges(result, value);
    }
    if (result !== true) {
      let changes, back;
      if (result === false) {
        back = tr.changes.invertedDesc;
        changes = ChangeSet.empty(state2.doc.length);
      } else {
        let filtered = tr.changes.filter(result);
        changes = filtered.changes;
        back = filtered.filtered.mapDesc(filtered.changes).invertedDesc;
      }
      tr = Transaction.create(state2, changes, tr.selection && tr.selection.map(back), StateEffect.mapEffects(tr.effects, back), tr.annotations, tr.scrollIntoView);
    }
    let filters = state2.facet(transactionFilter);
    for (let i2 = filters.length - 1; i2 >= 0; i2--) {
      let filtered = filters[i2](tr);
      if (filtered instanceof Transaction)
        tr = filtered;
      else if (Array.isArray(filtered) && filtered.length == 1 && filtered[0] instanceof Transaction)
        tr = filtered[0];
      else
        tr = resolveTransaction(state2, asArray$1(filtered), false);
    }
    return tr;
  }
  function extendTransaction(tr) {
    let state2 = tr.startState, extenders = state2.facet(transactionExtender), spec = tr;
    for (let i2 = extenders.length - 1; i2 >= 0; i2--) {
      let extension = extenders[i2](tr);
      if (extension && Object.keys(extension).length)
        spec = mergeTransaction(spec, resolveTransactionInner(state2, extension, tr.changes.newLength), true);
    }
    return spec == tr ? tr : Transaction.create(state2, tr.changes, tr.selection, spec.effects, spec.annotations, spec.scrollIntoView);
  }
  const none$1 = [];
  function asArray$1(value) {
    return value == null ? none$1 : Array.isArray(value) ? value : [value];
  }
  var CharCategory = /* @__PURE__ */ function(CharCategory2) {
    CharCategory2[CharCategory2["Word"] = 0] = "Word";
    CharCategory2[CharCategory2["Space"] = 1] = "Space";
    CharCategory2[CharCategory2["Other"] = 2] = "Other";
    return CharCategory2;
  }(CharCategory || (CharCategory = {}));
  const nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
  let wordChar;
  try {
    wordChar = /* @__PURE__ */ new RegExp("[\\p{Alphabetic}\\p{Number}_]", "u");
  } catch (_2) {
  }
  function hasWordChar(str) {
    if (wordChar)
      return wordChar.test(str);
    for (let i2 = 0; i2 < str.length; i2++) {
      let ch = str[i2];
      if (/\w/.test(ch) || ch > "" && (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch)))
        return true;
    }
    return false;
  }
  function makeCategorizer(wordChars) {
    return (char) => {
      if (!/\S/.test(char))
        return CharCategory.Space;
      if (hasWordChar(char))
        return CharCategory.Word;
      for (let i2 = 0; i2 < wordChars.length; i2++)
        if (char.indexOf(wordChars[i2]) > -1)
          return CharCategory.Word;
      return CharCategory.Other;
    };
  }
  class EditorState {
    constructor(config2, doc2, selection, values2, computeSlot, tr) {
      this.config = config2;
      this.doc = doc2;
      this.selection = selection;
      this.values = values2;
      this.status = config2.statusTemplate.slice();
      this.computeSlot = computeSlot;
      if (tr)
        tr._state = this;
      for (let i2 = 0; i2 < this.config.dynamicSlots.length; i2++)
        ensureAddr(this, i2 << 1);
      this.computeSlot = null;
    }
    field(field, require2 = true) {
      let addr = this.config.address[field.id];
      if (addr == null) {
        if (require2)
          throw new RangeError("Field is not present in this state");
        return void 0;
      }
      ensureAddr(this, addr);
      return getAddr(this, addr);
    }
    /**
    Create a [transaction](https://codemirror.net/6/docs/ref/#state.Transaction) that updates this
    state. Any number of [transaction specs](https://codemirror.net/6/docs/ref/#state.TransactionSpec)
    can be passed. Unless
    [`sequential`](https://codemirror.net/6/docs/ref/#state.TransactionSpec.sequential) is set, the
    [changes](https://codemirror.net/6/docs/ref/#state.TransactionSpec.changes) (if any) of each spec
    are assumed to start in the _current_ document (not the document
    produced by previous specs), and its
    [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection) and
    [effects](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) are assumed to refer
    to the document created by its _own_ changes. The resulting
    transaction contains the combined effect of all the different
    specs. For [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection), later
    specs take precedence over earlier ones.
    */
    update(...specs) {
      return resolveTransaction(this, specs, true);
    }
    /**
    @internal
    */
    applyTransaction(tr) {
      let conf = this.config, { base: base2, compartments } = conf;
      for (let effect2 of tr.effects) {
        if (effect2.is(Compartment.reconfigure)) {
          if (conf) {
            compartments = /* @__PURE__ */ new Map();
            conf.compartments.forEach((val, key) => compartments.set(key, val));
            conf = null;
          }
          compartments.set(effect2.value.compartment, effect2.value.extension);
        } else if (effect2.is(StateEffect.reconfigure)) {
          conf = null;
          base2 = effect2.value;
        } else if (effect2.is(StateEffect.appendConfig)) {
          conf = null;
          base2 = asArray$1(base2).concat(effect2.value);
        }
      }
      let startValues;
      if (!conf) {
        conf = Configuration.resolve(base2, compartments, this);
        let intermediateState = new EditorState(conf, this.doc, this.selection, conf.dynamicSlots.map(() => null), (state2, slot) => slot.reconfigure(state2, this), null);
        startValues = intermediateState.values;
      } else {
        startValues = tr.startState.values.slice();
      }
      let selection = tr.startState.facet(allowMultipleSelections) ? tr.newSelection : tr.newSelection.asSingle();
      new EditorState(conf, tr.newDoc, selection, startValues, (state2, slot) => slot.update(state2, tr), tr);
    }
    /**
    Create a [transaction spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec) that
    replaces every selection range with the given content.
    */
    replaceSelection(text) {
      if (typeof text == "string")
        text = this.toText(text);
      return this.changeByRange((range2) => ({
        changes: { from: range2.from, to: range2.to, insert: text },
        range: EditorSelection.cursor(range2.from + text.length)
      }));
    }
    /**
    Create a set of changes and a new selection by running the given
    function for each range in the active selection. The function
    can return an optional set of changes (in the coordinate space
    of the start document), plus an updated range (in the coordinate
    space of the document produced by the call's own changes). This
    method will merge all the changes and ranges into a single
    changeset and selection, and return it as a [transaction
    spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec), which can be passed to
    [`update`](https://codemirror.net/6/docs/ref/#state.EditorState.update).
    */
    changeByRange(f2) {
      let sel = this.selection;
      let result1 = f2(sel.ranges[0]);
      let changes = this.changes(result1.changes), ranges = [result1.range];
      let effects = asArray$1(result1.effects);
      for (let i2 = 1; i2 < sel.ranges.length; i2++) {
        let result = f2(sel.ranges[i2]);
        let newChanges = this.changes(result.changes), newMapped = newChanges.map(changes);
        for (let j2 = 0; j2 < i2; j2++)
          ranges[j2] = ranges[j2].map(newMapped);
        let mapBy = changes.mapDesc(newChanges, true);
        ranges.push(result.range.map(mapBy));
        changes = changes.compose(newMapped);
        effects = StateEffect.mapEffects(effects, newMapped).concat(StateEffect.mapEffects(asArray$1(result.effects), mapBy));
      }
      return {
        changes,
        selection: EditorSelection.create(ranges, sel.mainIndex),
        effects
      };
    }
    /**
    Create a [change set](https://codemirror.net/6/docs/ref/#state.ChangeSet) from the given change
    description, taking the state's document length and line
    separator into account.
    */
    changes(spec = []) {
      if (spec instanceof ChangeSet)
        return spec;
      return ChangeSet.of(spec, this.doc.length, this.facet(EditorState.lineSeparator));
    }
    /**
    Using the state's [line
    separator](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator), create a
    [`Text`](https://codemirror.net/6/docs/ref/#state.Text) instance from the given string.
    */
    toText(string2) {
      return Text$1.of(string2.split(this.facet(EditorState.lineSeparator) || DefaultSplit));
    }
    /**
    Return the given range of the document as a string.
    */
    sliceDoc(from = 0, to = this.doc.length) {
      return this.doc.sliceString(from, to, this.lineBreak);
    }
    /**
    Get the value of a state [facet](https://codemirror.net/6/docs/ref/#state.Facet).
    */
    facet(facet) {
      let addr = this.config.address[facet.id];
      if (addr == null)
        return facet.default;
      ensureAddr(this, addr);
      return getAddr(this, addr);
    }
    /**
    Convert this state to a JSON-serializable object. When custom
    fields should be serialized, you can pass them in as an object
    mapping property names (in the resulting object, which should
    not use `doc` or `selection`) to fields.
    */
    toJSON(fields) {
      let result = {
        doc: this.sliceDoc(),
        selection: this.selection.toJSON()
      };
      if (fields)
        for (let prop in fields) {
          let value = fields[prop];
          if (value instanceof StateField && this.config.address[value.id] != null)
            result[prop] = value.spec.toJSON(this.field(fields[prop]), this);
        }
      return result;
    }
    /**
    Deserialize a state from its JSON representation. When custom
    fields should be deserialized, pass the same object you passed
    to [`toJSON`](https://codemirror.net/6/docs/ref/#state.EditorState.toJSON) when serializing as
    third argument.
    */
    static fromJSON(json2, config2 = {}, fields) {
      if (!json2 || typeof json2.doc != "string")
        throw new RangeError("Invalid JSON representation for EditorState");
      let fieldInit = [];
      if (fields)
        for (let prop in fields) {
          if (Object.prototype.hasOwnProperty.call(json2, prop)) {
            let field = fields[prop], value = json2[prop];
            fieldInit.push(field.init((state2) => field.spec.fromJSON(value, state2)));
          }
        }
      return EditorState.create({
        doc: json2.doc,
        selection: EditorSelection.fromJSON(json2.selection),
        extensions: config2.extensions ? fieldInit.concat([config2.extensions]) : fieldInit
      });
    }
    /**
    Create a new state. You'll usually only need this when
    initializing an editor—updated states are created by applying
    transactions.
    */
    static create(config2 = {}) {
      let configuration = Configuration.resolve(config2.extensions || [], /* @__PURE__ */ new Map());
      let doc2 = config2.doc instanceof Text$1 ? config2.doc : Text$1.of((config2.doc || "").split(configuration.staticFacet(EditorState.lineSeparator) || DefaultSplit));
      let selection = !config2.selection ? EditorSelection.single(0) : config2.selection instanceof EditorSelection ? config2.selection : EditorSelection.single(config2.selection.anchor, config2.selection.head);
      checkSelection(selection, doc2.length);
      if (!configuration.staticFacet(allowMultipleSelections))
        selection = selection.asSingle();
      return new EditorState(configuration, doc2, selection, configuration.dynamicSlots.map(() => null), (state2, slot) => slot.create(state2), null);
    }
    /**
    The size (in columns) of a tab in the document, determined by
    the [`tabSize`](https://codemirror.net/6/docs/ref/#state.EditorState^tabSize) facet.
    */
    get tabSize() {
      return this.facet(EditorState.tabSize);
    }
    /**
    Get the proper [line-break](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator)
    string for this state.
    */
    get lineBreak() {
      return this.facet(EditorState.lineSeparator) || "\n";
    }
    /**
    Returns true when the editor is
    [configured](https://codemirror.net/6/docs/ref/#state.EditorState^readOnly) to be read-only.
    */
    get readOnly() {
      return this.facet(readOnly);
    }
    /**
    Look up a translation for the given phrase (via the
    [`phrases`](https://codemirror.net/6/docs/ref/#state.EditorState^phrases) facet), or return the
    original string if no translation is found.
    
    If additional arguments are passed, they will be inserted in
    place of markers like `$1` (for the first value) and `$2`, etc.
    A single `$` is equivalent to `$1`, and `$$` will produce a
    literal dollar sign.
    */
    phrase(phrase, ...insert2) {
      for (let map2 of this.facet(EditorState.phrases))
        if (Object.prototype.hasOwnProperty.call(map2, phrase)) {
          phrase = map2[phrase];
          break;
        }
      if (insert2.length)
        phrase = phrase.replace(/\$(\$|\d*)/g, (m2, i2) => {
          if (i2 == "$")
            return "$";
          let n2 = +(i2 || 1);
          return !n2 || n2 > insert2.length ? m2 : insert2[n2 - 1];
        });
      return phrase;
    }
    /**
    Find the values for a given language data field, provided by the
    the [`languageData`](https://codemirror.net/6/docs/ref/#state.EditorState^languageData) facet.
    
    Examples of language data fields are...
    
    - [`"commentTokens"`](https://codemirror.net/6/docs/ref/#commands.CommentTokens) for specifying
      comment syntax.
    - [`"autocomplete"`](https://codemirror.net/6/docs/ref/#autocomplete.autocompletion^config.override)
      for providing language-specific completion sources.
    - [`"wordChars"`](https://codemirror.net/6/docs/ref/#state.EditorState.charCategorizer) for adding
      characters that should be considered part of words in this
      language.
    - [`"closeBrackets"`](https://codemirror.net/6/docs/ref/#autocomplete.CloseBracketConfig) controls
      bracket closing behavior.
    */
    languageDataAt(name2, pos, side = -1) {
      let values2 = [];
      for (let provider of this.facet(languageData)) {
        for (let result of provider(this, pos, side)) {
          if (Object.prototype.hasOwnProperty.call(result, name2))
            values2.push(result[name2]);
        }
      }
      return values2;
    }
    /**
    Return a function that can categorize strings (expected to
    represent a single [grapheme cluster](https://codemirror.net/6/docs/ref/#state.findClusterBreak))
    into one of:
    
     - Word (contains an alphanumeric character or a character
       explicitly listed in the local language's `"wordChars"`
       language data, which should be a string)
     - Space (contains only whitespace)
     - Other (anything else)
    */
    charCategorizer(at) {
      return makeCategorizer(this.languageDataAt("wordChars", at).join(""));
    }
    /**
    Find the word at the given position, meaning the range
    containing all [word](https://codemirror.net/6/docs/ref/#state.CharCategory.Word) characters
    around it. If no word characters are adjacent to the position,
    this returns null.
    */
    wordAt(pos) {
      let { text, from, length } = this.doc.lineAt(pos);
      let cat = this.charCategorizer(pos);
      let start = pos - from, end = pos - from;
      while (start > 0) {
        let prev = findClusterBreak(text, start, false);
        if (cat(text.slice(prev, start)) != CharCategory.Word)
          break;
        start = prev;
      }
      while (end < length) {
        let next = findClusterBreak(text, end);
        if (cat(text.slice(end, next)) != CharCategory.Word)
          break;
        end = next;
      }
      return start == end ? null : EditorSelection.range(start + from, end + from);
    }
  }
  EditorState.allowMultipleSelections = allowMultipleSelections;
  EditorState.tabSize = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.length ? values2[0] : 4
  });
  EditorState.lineSeparator = lineSeparator;
  EditorState.readOnly = readOnly;
  EditorState.phrases = /* @__PURE__ */ Facet.define({
    compare(a2, b2) {
      let kA = Object.keys(a2), kB = Object.keys(b2);
      return kA.length == kB.length && kA.every((k2) => a2[k2] == b2[k2]);
    }
  });
  EditorState.languageData = languageData;
  EditorState.changeFilter = changeFilter;
  EditorState.transactionFilter = transactionFilter;
  EditorState.transactionExtender = transactionExtender;
  Compartment.reconfigure = /* @__PURE__ */ StateEffect.define();
  function combineConfig(configs, defaults2, combine = {}) {
    let result = {};
    for (let config2 of configs)
      for (let key of Object.keys(config2)) {
        let value = config2[key], current = result[key];
        if (current === void 0)
          result[key] = value;
        else if (current === value || value === void 0)
          ;
        else if (Object.hasOwnProperty.call(combine, key))
          result[key] = combine[key](current, value);
        else
          throw new Error("Config merge conflict for field " + key);
      }
    for (let key in defaults2)
      if (result[key] === void 0)
        result[key] = defaults2[key];
    return result;
  }
  class RangeValue {
    /**
    Compare this value with another value. Used when comparing
    rangesets. The default implementation compares by identity.
    Unless you are only creating a fixed number of unique instances
    of your value type, it is a good idea to implement this
    properly.
    */
    eq(other) {
      return this == other;
    }
    /**
    Create a [range](https://codemirror.net/6/docs/ref/#state.Range) with this value.
    */
    range(from, to = from) {
      return Range$1.create(from, to, this);
    }
  }
  RangeValue.prototype.startSide = RangeValue.prototype.endSide = 0;
  RangeValue.prototype.point = false;
  RangeValue.prototype.mapMode = MapMode.TrackDel;
  let Range$1 = class Range {
    constructor(from, to, value) {
      this.from = from;
      this.to = to;
      this.value = value;
    }
    /**
    @internal
    */
    static create(from, to, value) {
      return new Range(from, to, value);
    }
  };
  function cmpRange(a2, b2) {
    return a2.from - b2.from || a2.value.startSide - b2.value.startSide;
  }
  class Chunk {
    constructor(from, to, value, maxPoint) {
      this.from = from;
      this.to = to;
      this.value = value;
      this.maxPoint = maxPoint;
    }
    get length() {
      return this.to[this.to.length - 1];
    }
    // Find the index of the given position and side. Use the ranges'
    // `from` pos when `end == false`, `to` when `end == true`.
    findIndex(pos, side, end, startAt = 0) {
      let arr = end ? this.to : this.from;
      for (let lo = startAt, hi = arr.length; ; ) {
        if (lo == hi)
          return lo;
        let mid = lo + hi >> 1;
        let diff = arr[mid] - pos || (end ? this.value[mid].endSide : this.value[mid].startSide) - side;
        if (mid == lo)
          return diff >= 0 ? lo : hi;
        if (diff >= 0)
          hi = mid;
        else
          lo = mid + 1;
      }
    }
    between(offset, from, to, f2) {
      for (let i2 = this.findIndex(from, -1e9, true), e2 = this.findIndex(to, 1e9, false, i2); i2 < e2; i2++)
        if (f2(this.from[i2] + offset, this.to[i2] + offset, this.value[i2]) === false)
          return false;
    }
    map(offset, changes) {
      let value = [], from = [], to = [], newPos = -1, maxPoint = -1;
      for (let i2 = 0; i2 < this.value.length; i2++) {
        let val = this.value[i2], curFrom = this.from[i2] + offset, curTo = this.to[i2] + offset, newFrom, newTo;
        if (curFrom == curTo) {
          let mapped = changes.mapPos(curFrom, val.startSide, val.mapMode);
          if (mapped == null)
            continue;
          newFrom = newTo = mapped;
          if (val.startSide != val.endSide) {
            newTo = changes.mapPos(curFrom, val.endSide);
            if (newTo < newFrom)
              continue;
          }
        } else {
          newFrom = changes.mapPos(curFrom, val.startSide);
          newTo = changes.mapPos(curTo, val.endSide);
          if (newFrom > newTo || newFrom == newTo && val.startSide > 0 && val.endSide <= 0)
            continue;
        }
        if ((newTo - newFrom || val.endSide - val.startSide) < 0)
          continue;
        if (newPos < 0)
          newPos = newFrom;
        if (val.point)
          maxPoint = Math.max(maxPoint, newTo - newFrom);
        value.push(val);
        from.push(newFrom - newPos);
        to.push(newTo - newPos);
      }
      return { mapped: value.length ? new Chunk(from, to, value, maxPoint) : null, pos: newPos };
    }
  }
  class RangeSet {
    constructor(chunkPos, chunk, nextLayer, maxPoint) {
      this.chunkPos = chunkPos;
      this.chunk = chunk;
      this.nextLayer = nextLayer;
      this.maxPoint = maxPoint;
    }
    /**
    @internal
    */
    static create(chunkPos, chunk, nextLayer, maxPoint) {
      return new RangeSet(chunkPos, chunk, nextLayer, maxPoint);
    }
    /**
    @internal
    */
    get length() {
      let last = this.chunk.length - 1;
      return last < 0 ? 0 : Math.max(this.chunkEnd(last), this.nextLayer.length);
    }
    /**
    The number of ranges in the set.
    */
    get size() {
      if (this.isEmpty)
        return 0;
      let size2 = this.nextLayer.size;
      for (let chunk of this.chunk)
        size2 += chunk.value.length;
      return size2;
    }
    /**
    @internal
    */
    chunkEnd(index2) {
      return this.chunkPos[index2] + this.chunk[index2].length;
    }
    /**
    Update the range set, optionally adding new ranges or filtering
    out existing ones.
    
    (Note: The type parameter is just there as a kludge to work
    around TypeScript variance issues that prevented `RangeSet<X>`
    from being a subtype of `RangeSet<Y>` when `X` is a subtype of
    `Y`.)
    */
    update(updateSpec) {
      let { add: add2 = [], sort = false, filterFrom = 0, filterTo = this.length } = updateSpec;
      let filter = updateSpec.filter;
      if (add2.length == 0 && !filter)
        return this;
      if (sort)
        add2 = add2.slice().sort(cmpRange);
      if (this.isEmpty)
        return add2.length ? RangeSet.of(add2) : this;
      let cur2 = new LayerCursor(this, null, -1).goto(0), i2 = 0, spill = [];
      let builder = new RangeSetBuilder();
      while (cur2.value || i2 < add2.length) {
        if (i2 < add2.length && (cur2.from - add2[i2].from || cur2.startSide - add2[i2].value.startSide) >= 0) {
          let range2 = add2[i2++];
          if (!builder.addInner(range2.from, range2.to, range2.value))
            spill.push(range2);
        } else if (cur2.rangeIndex == 1 && cur2.chunkIndex < this.chunk.length && (i2 == add2.length || this.chunkEnd(cur2.chunkIndex) < add2[i2].from) && (!filter || filterFrom > this.chunkEnd(cur2.chunkIndex) || filterTo < this.chunkPos[cur2.chunkIndex]) && builder.addChunk(this.chunkPos[cur2.chunkIndex], this.chunk[cur2.chunkIndex])) {
          cur2.nextChunk();
        } else {
          if (!filter || filterFrom > cur2.to || filterTo < cur2.from || filter(cur2.from, cur2.to, cur2.value)) {
            if (!builder.addInner(cur2.from, cur2.to, cur2.value))
              spill.push(Range$1.create(cur2.from, cur2.to, cur2.value));
          }
          cur2.next();
        }
      }
      return builder.finishInner(this.nextLayer.isEmpty && !spill.length ? RangeSet.empty : this.nextLayer.update({ add: spill, filter, filterFrom, filterTo }));
    }
    /**
    Map this range set through a set of changes, return the new set.
    */
    map(changes) {
      if (changes.empty || this.isEmpty)
        return this;
      let chunks = [], chunkPos = [], maxPoint = -1;
      for (let i2 = 0; i2 < this.chunk.length; i2++) {
        let start = this.chunkPos[i2], chunk = this.chunk[i2];
        let touch = changes.touchesRange(start, start + chunk.length);
        if (touch === false) {
          maxPoint = Math.max(maxPoint, chunk.maxPoint);
          chunks.push(chunk);
          chunkPos.push(changes.mapPos(start));
        } else if (touch === true) {
          let { mapped, pos } = chunk.map(start, changes);
          if (mapped) {
            maxPoint = Math.max(maxPoint, mapped.maxPoint);
            chunks.push(mapped);
            chunkPos.push(pos);
          }
        }
      }
      let next = this.nextLayer.map(changes);
      return chunks.length == 0 ? next : new RangeSet(chunkPos, chunks, next || RangeSet.empty, maxPoint);
    }
    /**
    Iterate over the ranges that touch the region `from` to `to`,
    calling `f` for each. There is no guarantee that the ranges will
    be reported in any specific order. When the callback returns
    `false`, iteration stops.
    */
    between(from, to, f2) {
      if (this.isEmpty)
        return;
      for (let i2 = 0; i2 < this.chunk.length; i2++) {
        let start = this.chunkPos[i2], chunk = this.chunk[i2];
        if (to >= start && from <= start + chunk.length && chunk.between(start, from - start, to - start, f2) === false)
          return;
      }
      this.nextLayer.between(from, to, f2);
    }
    /**
    Iterate over the ranges in this set, in order, including all
    ranges that end at or after `from`.
    */
    iter(from = 0) {
      return HeapCursor.from([this]).goto(from);
    }
    /**
    @internal
    */
    get isEmpty() {
      return this.nextLayer == this;
    }
    /**
    Iterate over the ranges in a collection of sets, in order,
    starting from `from`.
    */
    static iter(sets, from = 0) {
      return HeapCursor.from(sets).goto(from);
    }
    /**
    Iterate over two groups of sets, calling methods on `comparator`
    to notify it of possible differences.
    */
    static compare(oldSets, newSets, textDiff, comparator2, minPointSize = -1) {
      let a2 = oldSets.filter((set2) => set2.maxPoint > 0 || !set2.isEmpty && set2.maxPoint >= minPointSize);
      let b2 = newSets.filter((set2) => set2.maxPoint > 0 || !set2.isEmpty && set2.maxPoint >= minPointSize);
      let sharedChunks = findSharedChunks(a2, b2, textDiff);
      let sideA = new SpanCursor(a2, sharedChunks, minPointSize);
      let sideB = new SpanCursor(b2, sharedChunks, minPointSize);
      textDiff.iterGaps((fromA, fromB, length) => compare(sideA, fromA, sideB, fromB, length, comparator2));
      if (textDiff.empty && textDiff.length == 0)
        compare(sideA, 0, sideB, 0, 0, comparator2);
    }
    /**
    Compare the contents of two groups of range sets, returning true
    if they are equivalent in the given range.
    */
    static eq(oldSets, newSets, from = 0, to) {
      if (to == null)
        to = 1e9 - 1;
      let a2 = oldSets.filter((set2) => !set2.isEmpty && newSets.indexOf(set2) < 0);
      let b2 = newSets.filter((set2) => !set2.isEmpty && oldSets.indexOf(set2) < 0);
      if (a2.length != b2.length)
        return false;
      if (!a2.length)
        return true;
      let sharedChunks = findSharedChunks(a2, b2);
      let sideA = new SpanCursor(a2, sharedChunks, 0).goto(from), sideB = new SpanCursor(b2, sharedChunks, 0).goto(from);
      for (; ; ) {
        if (sideA.to != sideB.to || !sameValues(sideA.active, sideB.active) || sideA.point && (!sideB.point || !sideA.point.eq(sideB.point)))
          return false;
        if (sideA.to > to)
          return true;
        sideA.next();
        sideB.next();
      }
    }
    /**
    Iterate over a group of range sets at the same time, notifying
    the iterator about the ranges covering every given piece of
    content. Returns the open count (see
    [`SpanIterator.span`](https://codemirror.net/6/docs/ref/#state.SpanIterator.span)) at the end
    of the iteration.
    */
    static spans(sets, from, to, iterator, minPointSize = -1) {
      let cursor = new SpanCursor(sets, null, minPointSize).goto(from), pos = from;
      let openRanges = cursor.openStart;
      for (; ; ) {
        let curTo = Math.min(cursor.to, to);
        if (cursor.point) {
          let active = cursor.activeForPoint(cursor.to);
          let openCount = cursor.pointFrom < from ? active.length + 1 : cursor.point.startSide < 0 ? active.length : Math.min(active.length, openRanges);
          iterator.point(pos, curTo, cursor.point, active, openCount, cursor.pointRank);
          openRanges = Math.min(cursor.openEnd(curTo), active.length);
        } else if (curTo > pos) {
          iterator.span(pos, curTo, cursor.active, openRanges);
          openRanges = cursor.openEnd(curTo);
        }
        if (cursor.to > to)
          return openRanges + (cursor.point && cursor.to > to ? 1 : 0);
        pos = cursor.to;
        cursor.next();
      }
    }
    /**
    Create a range set for the given range or array of ranges. By
    default, this expects the ranges to be _sorted_ (by start
    position and, if two start at the same position,
    `value.startSide`). You can pass `true` as second argument to
    cause the method to sort them.
    */
    static of(ranges, sort = false) {
      let build = new RangeSetBuilder();
      for (let range2 of ranges instanceof Range$1 ? [ranges] : sort ? lazySort(ranges) : ranges)
        build.add(range2.from, range2.to, range2.value);
      return build.finish();
    }
    /**
    Join an array of range sets into a single set.
    */
    static join(sets) {
      if (!sets.length)
        return RangeSet.empty;
      let result = sets[sets.length - 1];
      for (let i2 = sets.length - 2; i2 >= 0; i2--) {
        for (let layer = sets[i2]; layer != RangeSet.empty; layer = layer.nextLayer)
          result = new RangeSet(layer.chunkPos, layer.chunk, result, Math.max(layer.maxPoint, result.maxPoint));
      }
      return result;
    }
  }
  RangeSet.empty = /* @__PURE__ */ new RangeSet([], [], null, -1);
  function lazySort(ranges) {
    if (ranges.length > 1)
      for (let prev = ranges[0], i2 = 1; i2 < ranges.length; i2++) {
        let cur2 = ranges[i2];
        if (cmpRange(prev, cur2) > 0)
          return ranges.slice().sort(cmpRange);
        prev = cur2;
      }
    return ranges;
  }
  RangeSet.empty.nextLayer = RangeSet.empty;
  class RangeSetBuilder {
    finishChunk(newArrays) {
      this.chunks.push(new Chunk(this.from, this.to, this.value, this.maxPoint));
      this.chunkPos.push(this.chunkStart);
      this.chunkStart = -1;
      this.setMaxPoint = Math.max(this.setMaxPoint, this.maxPoint);
      this.maxPoint = -1;
      if (newArrays) {
        this.from = [];
        this.to = [];
        this.value = [];
      }
    }
    /**
    Create an empty builder.
    */
    constructor() {
      this.chunks = [];
      this.chunkPos = [];
      this.chunkStart = -1;
      this.last = null;
      this.lastFrom = -1e9;
      this.lastTo = -1e9;
      this.from = [];
      this.to = [];
      this.value = [];
      this.maxPoint = -1;
      this.setMaxPoint = -1;
      this.nextLayer = null;
    }
    /**
    Add a range. Ranges should be added in sorted (by `from` and
    `value.startSide`) order.
    */
    add(from, to, value) {
      if (!this.addInner(from, to, value))
        (this.nextLayer || (this.nextLayer = new RangeSetBuilder())).add(from, to, value);
    }
    /**
    @internal
    */
    addInner(from, to, value) {
      let diff = from - this.lastTo || value.startSide - this.last.endSide;
      if (diff <= 0 && (from - this.lastFrom || value.startSide - this.last.startSide) < 0)
        throw new Error("Ranges must be added sorted by `from` position and `startSide`");
      if (diff < 0)
        return false;
      if (this.from.length == 250)
        this.finishChunk(true);
      if (this.chunkStart < 0)
        this.chunkStart = from;
      this.from.push(from - this.chunkStart);
      this.to.push(to - this.chunkStart);
      this.last = value;
      this.lastFrom = from;
      this.lastTo = to;
      this.value.push(value);
      if (value.point)
        this.maxPoint = Math.max(this.maxPoint, to - from);
      return true;
    }
    /**
    @internal
    */
    addChunk(from, chunk) {
      if ((from - this.lastTo || chunk.value[0].startSide - this.last.endSide) < 0)
        return false;
      if (this.from.length)
        this.finishChunk(true);
      this.setMaxPoint = Math.max(this.setMaxPoint, chunk.maxPoint);
      this.chunks.push(chunk);
      this.chunkPos.push(from);
      let last = chunk.value.length - 1;
      this.last = chunk.value[last];
      this.lastFrom = chunk.from[last] + from;
      this.lastTo = chunk.to[last] + from;
      return true;
    }
    /**
    Finish the range set. Returns the new set. The builder can't be
    used anymore after this has been called.
    */
    finish() {
      return this.finishInner(RangeSet.empty);
    }
    /**
    @internal
    */
    finishInner(next) {
      if (this.from.length)
        this.finishChunk(false);
      if (this.chunks.length == 0)
        return next;
      let result = RangeSet.create(this.chunkPos, this.chunks, this.nextLayer ? this.nextLayer.finishInner(next) : next, this.setMaxPoint);
      this.from = null;
      return result;
    }
  }
  function findSharedChunks(a2, b2, textDiff) {
    let inA = /* @__PURE__ */ new Map();
    for (let set2 of a2)
      for (let i2 = 0; i2 < set2.chunk.length; i2++)
        if (set2.chunk[i2].maxPoint <= 0)
          inA.set(set2.chunk[i2], set2.chunkPos[i2]);
    let shared = /* @__PURE__ */ new Set();
    for (let set2 of b2)
      for (let i2 = 0; i2 < set2.chunk.length; i2++) {
        let known = inA.get(set2.chunk[i2]);
        if (known != null && (textDiff ? textDiff.mapPos(known) : known) == set2.chunkPos[i2] && !(textDiff === null || textDiff === void 0 ? void 0 : textDiff.touchesRange(known, known + set2.chunk[i2].length)))
          shared.add(set2.chunk[i2]);
      }
    return shared;
  }
  class LayerCursor {
    constructor(layer, skip, minPoint, rank = 0) {
      this.layer = layer;
      this.skip = skip;
      this.minPoint = minPoint;
      this.rank = rank;
    }
    get startSide() {
      return this.value ? this.value.startSide : 0;
    }
    get endSide() {
      return this.value ? this.value.endSide : 0;
    }
    goto(pos, side = -1e9) {
      this.chunkIndex = this.rangeIndex = 0;
      this.gotoInner(pos, side, false);
      return this;
    }
    gotoInner(pos, side, forward) {
      while (this.chunkIndex < this.layer.chunk.length) {
        let next = this.layer.chunk[this.chunkIndex];
        if (!(this.skip && this.skip.has(next) || this.layer.chunkEnd(this.chunkIndex) < pos || next.maxPoint < this.minPoint))
          break;
        this.chunkIndex++;
        forward = false;
      }
      if (this.chunkIndex < this.layer.chunk.length) {
        let rangeIndex = this.layer.chunk[this.chunkIndex].findIndex(pos - this.layer.chunkPos[this.chunkIndex], side, true);
        if (!forward || this.rangeIndex < rangeIndex)
          this.setRangeIndex(rangeIndex);
      }
      this.next();
    }
    forward(pos, side) {
      if ((this.to - pos || this.endSide - side) < 0)
        this.gotoInner(pos, side, true);
    }
    next() {
      for (; ; ) {
        if (this.chunkIndex == this.layer.chunk.length) {
          this.from = this.to = 1e9;
          this.value = null;
          break;
        } else {
          let chunkPos = this.layer.chunkPos[this.chunkIndex], chunk = this.layer.chunk[this.chunkIndex];
          let from = chunkPos + chunk.from[this.rangeIndex];
          this.from = from;
          this.to = chunkPos + chunk.to[this.rangeIndex];
          this.value = chunk.value[this.rangeIndex];
          this.setRangeIndex(this.rangeIndex + 1);
          if (this.minPoint < 0 || this.value.point && this.to - this.from >= this.minPoint)
            break;
        }
      }
    }
    setRangeIndex(index2) {
      if (index2 == this.layer.chunk[this.chunkIndex].value.length) {
        this.chunkIndex++;
        if (this.skip) {
          while (this.chunkIndex < this.layer.chunk.length && this.skip.has(this.layer.chunk[this.chunkIndex]))
            this.chunkIndex++;
        }
        this.rangeIndex = 0;
      } else {
        this.rangeIndex = index2;
      }
    }
    nextChunk() {
      this.chunkIndex++;
      this.rangeIndex = 0;
      this.next();
    }
    compare(other) {
      return this.from - other.from || this.startSide - other.startSide || this.rank - other.rank || this.to - other.to || this.endSide - other.endSide;
    }
  }
  class HeapCursor {
    constructor(heap) {
      this.heap = heap;
    }
    static from(sets, skip = null, minPoint = -1) {
      let heap = [];
      for (let i2 = 0; i2 < sets.length; i2++) {
        for (let cur2 = sets[i2]; !cur2.isEmpty; cur2 = cur2.nextLayer) {
          if (cur2.maxPoint >= minPoint)
            heap.push(new LayerCursor(cur2, skip, minPoint, i2));
        }
      }
      return heap.length == 1 ? heap[0] : new HeapCursor(heap);
    }
    get startSide() {
      return this.value ? this.value.startSide : 0;
    }
    goto(pos, side = -1e9) {
      for (let cur2 of this.heap)
        cur2.goto(pos, side);
      for (let i2 = this.heap.length >> 1; i2 >= 0; i2--)
        heapBubble(this.heap, i2);
      this.next();
      return this;
    }
    forward(pos, side) {
      for (let cur2 of this.heap)
        cur2.forward(pos, side);
      for (let i2 = this.heap.length >> 1; i2 >= 0; i2--)
        heapBubble(this.heap, i2);
      if ((this.to - pos || this.value.endSide - side) < 0)
        this.next();
    }
    next() {
      if (this.heap.length == 0) {
        this.from = this.to = 1e9;
        this.value = null;
        this.rank = -1;
      } else {
        let top2 = this.heap[0];
        this.from = top2.from;
        this.to = top2.to;
        this.value = top2.value;
        this.rank = top2.rank;
        if (top2.value)
          top2.next();
        heapBubble(this.heap, 0);
      }
    }
  }
  function heapBubble(heap, index2) {
    for (let cur2 = heap[index2]; ; ) {
      let childIndex = (index2 << 1) + 1;
      if (childIndex >= heap.length)
        break;
      let child = heap[childIndex];
      if (childIndex + 1 < heap.length && child.compare(heap[childIndex + 1]) >= 0) {
        child = heap[childIndex + 1];
        childIndex++;
      }
      if (cur2.compare(child) < 0)
        break;
      heap[childIndex] = cur2;
      heap[index2] = child;
      index2 = childIndex;
    }
  }
  class SpanCursor {
    constructor(sets, skip, minPoint) {
      this.minPoint = minPoint;
      this.active = [];
      this.activeTo = [];
      this.activeRank = [];
      this.minActive = -1;
      this.point = null;
      this.pointFrom = 0;
      this.pointRank = 0;
      this.to = -1e9;
      this.endSide = 0;
      this.openStart = -1;
      this.cursor = HeapCursor.from(sets, skip, minPoint);
    }
    goto(pos, side = -1e9) {
      this.cursor.goto(pos, side);
      this.active.length = this.activeTo.length = this.activeRank.length = 0;
      this.minActive = -1;
      this.to = pos;
      this.endSide = side;
      this.openStart = -1;
      this.next();
      return this;
    }
    forward(pos, side) {
      while (this.minActive > -1 && (this.activeTo[this.minActive] - pos || this.active[this.minActive].endSide - side) < 0)
        this.removeActive(this.minActive);
      this.cursor.forward(pos, side);
    }
    removeActive(index2) {
      remove(this.active, index2);
      remove(this.activeTo, index2);
      remove(this.activeRank, index2);
      this.minActive = findMinIndex(this.active, this.activeTo);
    }
    addActive(trackOpen) {
      let i2 = 0, { value, to, rank } = this.cursor;
      while (i2 < this.activeRank.length && (rank - this.activeRank[i2] || to - this.activeTo[i2]) > 0)
        i2++;
      insert(this.active, i2, value);
      insert(this.activeTo, i2, to);
      insert(this.activeRank, i2, rank);
      if (trackOpen)
        insert(trackOpen, i2, this.cursor.from);
      this.minActive = findMinIndex(this.active, this.activeTo);
    }
    // After calling this, if `this.point` != null, the next range is a
    // point. Otherwise, it's a regular range, covered by `this.active`.
    next() {
      let from = this.to, wasPoint = this.point;
      this.point = null;
      let trackOpen = this.openStart < 0 ? [] : null;
      for (; ; ) {
        let a2 = this.minActive;
        if (a2 > -1 && (this.activeTo[a2] - this.cursor.from || this.active[a2].endSide - this.cursor.startSide) < 0) {
          if (this.activeTo[a2] > from) {
            this.to = this.activeTo[a2];
            this.endSide = this.active[a2].endSide;
            break;
          }
          this.removeActive(a2);
          if (trackOpen)
            remove(trackOpen, a2);
        } else if (!this.cursor.value) {
          this.to = this.endSide = 1e9;
          break;
        } else if (this.cursor.from > from) {
          this.to = this.cursor.from;
          this.endSide = this.cursor.startSide;
          break;
        } else {
          let nextVal = this.cursor.value;
          if (!nextVal.point) {
            this.addActive(trackOpen);
            this.cursor.next();
          } else if (wasPoint && this.cursor.to == this.to && this.cursor.from < this.cursor.to) {
            this.cursor.next();
          } else {
            this.point = nextVal;
            this.pointFrom = this.cursor.from;
            this.pointRank = this.cursor.rank;
            this.to = this.cursor.to;
            this.endSide = nextVal.endSide;
            this.cursor.next();
            this.forward(this.to, this.endSide);
            break;
          }
        }
      }
      if (trackOpen) {
        this.openStart = 0;
        for (let i2 = trackOpen.length - 1; i2 >= 0 && trackOpen[i2] < from; i2--)
          this.openStart++;
      }
    }
    activeForPoint(to) {
      if (!this.active.length)
        return this.active;
      let active = [];
      for (let i2 = this.active.length - 1; i2 >= 0; i2--) {
        if (this.activeRank[i2] < this.pointRank)
          break;
        if (this.activeTo[i2] > to || this.activeTo[i2] == to && this.active[i2].endSide >= this.point.endSide)
          active.push(this.active[i2]);
      }
      return active.reverse();
    }
    openEnd(to) {
      let open = 0;
      for (let i2 = this.activeTo.length - 1; i2 >= 0 && this.activeTo[i2] > to; i2--)
        open++;
      return open;
    }
  }
  function compare(a2, startA, b2, startB, length, comparator2) {
    a2.goto(startA);
    b2.goto(startB);
    let endB = startB + length;
    let pos = startB, dPos = startB - startA;
    for (; ; ) {
      let diff = a2.to + dPos - b2.to || a2.endSide - b2.endSide;
      let end = diff < 0 ? a2.to + dPos : b2.to, clipEnd = Math.min(end, endB);
      if (a2.point || b2.point) {
        if (!(a2.point && b2.point && (a2.point == b2.point || a2.point.eq(b2.point)) && sameValues(a2.activeForPoint(a2.to), b2.activeForPoint(b2.to))))
          comparator2.comparePoint(pos, clipEnd, a2.point, b2.point);
      } else {
        if (clipEnd > pos && !sameValues(a2.active, b2.active))
          comparator2.compareRange(pos, clipEnd, a2.active, b2.active);
      }
      if (end > endB)
        break;
      pos = end;
      if (diff <= 0)
        a2.next();
      if (diff >= 0)
        b2.next();
    }
  }
  function sameValues(a2, b2) {
    if (a2.length != b2.length)
      return false;
    for (let i2 = 0; i2 < a2.length; i2++)
      if (a2[i2] != b2[i2] && !a2[i2].eq(b2[i2]))
        return false;
    return true;
  }
  function remove(array, index2) {
    for (let i2 = index2, e2 = array.length - 1; i2 < e2; i2++)
      array[i2] = array[i2 + 1];
    array.pop();
  }
  function insert(array, index2, value) {
    for (let i2 = array.length - 1; i2 >= index2; i2--)
      array[i2 + 1] = array[i2];
    array[index2] = value;
  }
  function findMinIndex(value, array) {
    let found = -1, foundPos = 1e9;
    for (let i2 = 0; i2 < array.length; i2++)
      if ((array[i2] - foundPos || value[i2].endSide - value[found].endSide) < 0) {
        found = i2;
        foundPos = array[i2];
      }
    return found;
  }
  function countColumn(string2, tabSize, to = string2.length) {
    let n2 = 0;
    for (let i2 = 0; i2 < to; ) {
      if (string2.charCodeAt(i2) == 9) {
        n2 += tabSize - n2 % tabSize;
        i2++;
      } else {
        n2++;
        i2 = findClusterBreak(string2, i2);
      }
    }
    return n2;
  }
  function findColumn$1(string2, col, tabSize, strict) {
    for (let i2 = 0, n2 = 0; ; ) {
      if (n2 >= col)
        return i2;
      if (i2 == string2.length)
        break;
      n2 += string2.charCodeAt(i2) == 9 ? tabSize - n2 % tabSize : 1;
      i2 = findClusterBreak(string2, i2);
    }
    return strict === true ? -1 : string2.length;
  }
  const C = "ͼ";
  const COUNT = typeof Symbol == "undefined" ? "__" + C : Symbol.for(C);
  const SET = typeof Symbol == "undefined" ? "__styleSet" + Math.floor(Math.random() * 1e8) : Symbol("styleSet");
  const top = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : {};
  class StyleModule {
    // :: (Object<Style>, ?{finish: ?(string) → string})
    // Create a style module from the given spec.
    //
    // When `finish` is given, it is called on regular (non-`@`)
    // selectors (after `&` expansion) to compute the final selector.
    constructor(spec, options) {
      this.rules = [];
      let { finish } = options || {};
      function splitSelector(selector) {
        return /^@/.test(selector) ? [selector] : selector.split(/,\s*/);
      }
      function render2(selectors, spec2, target, isKeyframes) {
        let local = [], isAt = /^@(\w+)\b/.exec(selectors[0]), keyframes = isAt && isAt[1] == "keyframes";
        if (isAt && spec2 == null)
          return target.push(selectors[0] + ";");
        for (let prop in spec2) {
          let value = spec2[prop];
          if (/&/.test(prop)) {
            render2(
              prop.split(/,\s*/).map((part) => selectors.map((sel) => part.replace(/&/, sel))).reduce((a2, b2) => a2.concat(b2)),
              value,
              target
            );
          } else if (value && typeof value == "object") {
            if (!isAt)
              throw new RangeError("The value of a property (" + prop + ") should be a primitive value.");
            render2(splitSelector(prop), value, local, keyframes);
          } else if (value != null) {
            local.push(prop.replace(/_.*/, "").replace(/[A-Z]/g, (l2) => "-" + l2.toLowerCase()) + ": " + value + ";");
          }
        }
        if (local.length || keyframes) {
          target.push((finish && !isAt && !isKeyframes ? selectors.map(finish) : selectors).join(", ") + " {" + local.join(" ") + "}");
        }
      }
      for (let prop in spec)
        render2(splitSelector(prop), spec[prop], this.rules);
    }
    // :: () → string
    // Returns a string containing the module's CSS rules.
    getRules() {
      return this.rules.join("\n");
    }
    // :: () → string
    // Generate a new unique CSS class name.
    static newName() {
      let id2 = top[COUNT] || 1;
      top[COUNT] = id2 + 1;
      return C + id2.toString(36);
    }
    // :: (union<Document, ShadowRoot>, union<[StyleModule], StyleModule>, ?{nonce: ?string})
    //
    // Mount the given set of modules in the given DOM root, which ensures
    // that the CSS rules defined by the module are available in that
    // context.
    //
    // Rules are only added to the document once per root.
    //
    // Rule order will follow the order of the modules, so that rules from
    // modules later in the array take precedence of those from earlier
    // modules. If you call this function multiple times for the same root
    // in a way that changes the order of already mounted modules, the old
    // order will be changed.
    //
    // If a Content Security Policy nonce is provided, it is added to
    // the `<style>` tag generated by the library.
    static mount(root, modules, options) {
      let set2 = root[SET], nonce = options && options.nonce;
      if (!set2)
        set2 = new StyleSet(root, nonce);
      else if (nonce)
        set2.setNonce(nonce);
      set2.mount(Array.isArray(modules) ? modules : [modules]);
    }
  }
  let adoptedSet = /* @__PURE__ */ new Map();
  class StyleSet {
    constructor(root, nonce) {
      this.root = root;
      let doc2 = root.ownerDocument || root, win = doc2.defaultView;
      if (!root.head && root.adoptedStyleSheets && win.CSSStyleSheet) {
        let adopted = adoptedSet.get(doc2);
        if (adopted)
          return root[SET] = adopted;
        this.sheet = new win.CSSStyleSheet();
        adoptedSet.set(doc2, this);
      } else {
        this.styleTag = doc2.createElement("style");
        if (nonce)
          this.styleTag.setAttribute("nonce", nonce);
      }
      this.modules = [];
      root[SET] = this;
    }
    mount(modules) {
      let sheet = this.sheet;
      let pos = 0, j2 = 0;
      for (let i2 = 0; i2 < modules.length; i2++) {
        let mod = modules[i2], index2 = this.modules.indexOf(mod);
        if (index2 < j2 && index2 > -1) {
          this.modules.splice(index2, 1);
          j2--;
          index2 = -1;
        }
        if (index2 == -1) {
          this.modules.splice(j2++, 0, mod);
          if (sheet)
            for (let k2 = 0; k2 < mod.rules.length; k2++)
              sheet.insertRule(mod.rules[k2], pos++);
        } else {
          while (j2 < index2)
            pos += this.modules[j2++].rules.length;
          pos += mod.rules.length;
          j2++;
        }
      }
      if (sheet) {
        if (this.root.adoptedStyleSheets.indexOf(this.sheet) < 0)
          this.root.adoptedStyleSheets = [this.sheet, ...this.root.adoptedStyleSheets];
      } else {
        let text = "";
        for (let i2 = 0; i2 < this.modules.length; i2++)
          text += this.modules[i2].getRules() + "\n";
        this.styleTag.textContent = text;
        let target = this.root.head || this.root;
        if (this.styleTag.parentNode != target)
          target.insertBefore(this.styleTag, target.firstChild);
      }
    }
    setNonce(nonce) {
      if (this.styleTag && this.styleTag.getAttribute("nonce") != nonce)
        this.styleTag.setAttribute("nonce", nonce);
    }
  }
  var base = {
    8: "Backspace",
    9: "Tab",
    10: "Enter",
    12: "NumLock",
    13: "Enter",
    16: "Shift",
    17: "Control",
    18: "Alt",
    20: "CapsLock",
    27: "Escape",
    32: " ",
    33: "PageUp",
    34: "PageDown",
    35: "End",
    36: "Home",
    37: "ArrowLeft",
    38: "ArrowUp",
    39: "ArrowRight",
    40: "ArrowDown",
    44: "PrintScreen",
    45: "Insert",
    46: "Delete",
    59: ";",
    61: "=",
    91: "Meta",
    92: "Meta",
    106: "*",
    107: "+",
    108: ",",
    109: "-",
    110: ".",
    111: "/",
    144: "NumLock",
    145: "ScrollLock",
    160: "Shift",
    161: "Shift",
    162: "Control",
    163: "Control",
    164: "Alt",
    165: "Alt",
    173: "-",
    186: ";",
    187: "=",
    188: ",",
    189: "-",
    190: ".",
    191: "/",
    192: "`",
    219: "[",
    220: "\\",
    221: "]",
    222: "'"
  };
  var shift = {
    48: ")",
    49: "!",
    50: "@",
    51: "#",
    52: "$",
    53: "%",
    54: "^",
    55: "&",
    56: "*",
    57: "(",
    59: ":",
    61: "+",
    173: "_",
    186: ":",
    187: "+",
    188: "<",
    189: "_",
    190: ">",
    191: "?",
    192: "~",
    219: "{",
    220: "|",
    221: "}",
    222: '"'
  };
  var mac = typeof navigator != "undefined" && /Mac/.test(navigator.platform);
  var ie$1 = typeof navigator != "undefined" && /MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent);
  for (var i = 0; i < 10; i++)
    base[48 + i] = base[96 + i] = String(i);
  for (var i = 1; i <= 24; i++)
    base[i + 111] = "F" + i;
  for (var i = 65; i <= 90; i++) {
    base[i] = String.fromCharCode(i + 32);
    shift[i] = String.fromCharCode(i);
  }
  for (var code in base)
    if (!shift.hasOwnProperty(code))
      shift[code] = base[code];
  function keyName(event) {
    var ignoreKey = mac && event.metaKey && event.shiftKey && !event.ctrlKey && !event.altKey || ie$1 && event.shiftKey && event.key && event.key.length == 1 || event.key == "Unidentified";
    var name2 = !ignoreKey && event.key || (event.shiftKey ? shift : base)[event.keyCode] || event.key || "Unidentified";
    if (name2 == "Esc")
      name2 = "Escape";
    if (name2 == "Del")
      name2 = "Delete";
    if (name2 == "Left")
      name2 = "ArrowLeft";
    if (name2 == "Up")
      name2 = "ArrowUp";
    if (name2 == "Right")
      name2 = "ArrowRight";
    if (name2 == "Down")
      name2 = "ArrowDown";
    return name2;
  }
  function getSelection(root) {
    let target;
    if (root.nodeType == 11) {
      target = root.getSelection ? root : root.ownerDocument;
    } else {
      target = root;
    }
    return target.getSelection();
  }
  function contains(dom2, node) {
    return node ? dom2 == node || dom2.contains(node.nodeType != 1 ? node.parentNode : node) : false;
  }
  function deepActiveElement(doc2) {
    let elt = doc2.activeElement;
    while (elt && elt.shadowRoot)
      elt = elt.shadowRoot.activeElement;
    return elt;
  }
  function hasSelection(dom2, selection) {
    if (!selection.anchorNode)
      return false;
    try {
      return contains(dom2, selection.anchorNode);
    } catch (_2) {
      return false;
    }
  }
  function clientRectsFor(dom2) {
    if (dom2.nodeType == 3)
      return textRange(dom2, 0, dom2.nodeValue.length).getClientRects();
    else if (dom2.nodeType == 1)
      return dom2.getClientRects();
    else
      return [];
  }
  function isEquivalentPosition(node, off, targetNode, targetOff) {
    return targetNode ? scanFor(node, off, targetNode, targetOff, -1) || scanFor(node, off, targetNode, targetOff, 1) : false;
  }
  function domIndex(node) {
    for (var index2 = 0; ; index2++) {
      node = node.previousSibling;
      if (!node)
        return index2;
    }
  }
  function scanFor(node, off, targetNode, targetOff, dir) {
    for (; ; ) {
      if (node == targetNode && off == targetOff)
        return true;
      if (off == (dir < 0 ? 0 : maxOffset(node))) {
        if (node.nodeName == "DIV")
          return false;
        let parent = node.parentNode;
        if (!parent || parent.nodeType != 1)
          return false;
        off = domIndex(node) + (dir < 0 ? 0 : 1);
        node = parent;
      } else if (node.nodeType == 1) {
        node = node.childNodes[off + (dir < 0 ? -1 : 0)];
        if (node.nodeType == 1 && node.contentEditable == "false")
          return false;
        off = dir < 0 ? maxOffset(node) : 0;
      } else {
        return false;
      }
    }
  }
  function maxOffset(node) {
    return node.nodeType == 3 ? node.nodeValue.length : node.childNodes.length;
  }
  function flattenRect(rect, left) {
    let x2 = left ? rect.left : rect.right;
    return { left: x2, right: x2, top: rect.top, bottom: rect.bottom };
  }
  function windowRect(win) {
    return {
      left: 0,
      right: win.innerWidth,
      top: 0,
      bottom: win.innerHeight
    };
  }
  function getScale(elt, rect) {
    let scaleX = rect.width / elt.offsetWidth;
    let scaleY = rect.height / elt.offsetHeight;
    if (scaleX > 0.995 && scaleX < 1.005 || !isFinite(scaleX) || Math.abs(rect.width - elt.offsetWidth) < 1)
      scaleX = 1;
    if (scaleY > 0.995 && scaleY < 1.005 || !isFinite(scaleY) || Math.abs(rect.height - elt.offsetHeight) < 1)
      scaleY = 1;
    return { scaleX, scaleY };
  }
  function scrollRectIntoView(dom2, rect, side, x2, y2, xMargin, yMargin, ltr) {
    let doc2 = dom2.ownerDocument, win = doc2.defaultView || window;
    for (let cur2 = dom2, stop2 = false; cur2 && !stop2; ) {
      if (cur2.nodeType == 1) {
        let bounding, top2 = cur2 == doc2.body;
        let scaleX = 1, scaleY = 1;
        if (top2) {
          bounding = windowRect(win);
        } else {
          if (/^(fixed|sticky)$/.test(getComputedStyle(cur2).position))
            stop2 = true;
          if (cur2.scrollHeight <= cur2.clientHeight && cur2.scrollWidth <= cur2.clientWidth) {
            cur2 = cur2.assignedSlot || cur2.parentNode;
            continue;
          }
          let rect2 = cur2.getBoundingClientRect();
          ({ scaleX, scaleY } = getScale(cur2, rect2));
          bounding = {
            left: rect2.left,
            right: rect2.left + cur2.clientWidth * scaleX,
            top: rect2.top,
            bottom: rect2.top + cur2.clientHeight * scaleY
          };
        }
        let moveX = 0, moveY = 0;
        if (y2 == "nearest") {
          if (rect.top < bounding.top) {
            moveY = -(bounding.top - rect.top + yMargin);
            if (side > 0 && rect.bottom > bounding.bottom + moveY)
              moveY = rect.bottom - bounding.bottom + moveY + yMargin;
          } else if (rect.bottom > bounding.bottom) {
            moveY = rect.bottom - bounding.bottom + yMargin;
            if (side < 0 && rect.top - moveY < bounding.top)
              moveY = -(bounding.top + moveY - rect.top + yMargin);
          }
        } else {
          let rectHeight = rect.bottom - rect.top, boundingHeight = bounding.bottom - bounding.top;
          let targetTop = y2 == "center" && rectHeight <= boundingHeight ? rect.top + rectHeight / 2 - boundingHeight / 2 : y2 == "start" || y2 == "center" && side < 0 ? rect.top - yMargin : rect.bottom - boundingHeight + yMargin;
          moveY = targetTop - bounding.top;
        }
        if (x2 == "nearest") {
          if (rect.left < bounding.left) {
            moveX = -(bounding.left - rect.left + xMargin);
            if (side > 0 && rect.right > bounding.right + moveX)
              moveX = rect.right - bounding.right + moveX + xMargin;
          } else if (rect.right > bounding.right) {
            moveX = rect.right - bounding.right + xMargin;
            if (side < 0 && rect.left < bounding.left + moveX)
              moveX = -(bounding.left + moveX - rect.left + xMargin);
          }
        } else {
          let targetLeft = x2 == "center" ? rect.left + (rect.right - rect.left) / 2 - (bounding.right - bounding.left) / 2 : x2 == "start" == ltr ? rect.left - xMargin : rect.right - (bounding.right - bounding.left) + xMargin;
          moveX = targetLeft - bounding.left;
        }
        if (moveX || moveY) {
          if (top2) {
            win.scrollBy(moveX, moveY);
          } else {
            let movedX = 0, movedY = 0;
            if (moveY) {
              let start = cur2.scrollTop;
              cur2.scrollTop += moveY / scaleY;
              movedY = (cur2.scrollTop - start) * scaleY;
            }
            if (moveX) {
              let start = cur2.scrollLeft;
              cur2.scrollLeft += moveX / scaleX;
              movedX = (cur2.scrollLeft - start) * scaleX;
            }
            rect = {
              left: rect.left - movedX,
              top: rect.top - movedY,
              right: rect.right - movedX,
              bottom: rect.bottom - movedY
            };
            if (movedX && Math.abs(movedX - moveX) < 1)
              x2 = "nearest";
            if (movedY && Math.abs(movedY - moveY) < 1)
              y2 = "nearest";
          }
        }
        if (top2)
          break;
        cur2 = cur2.assignedSlot || cur2.parentNode;
      } else if (cur2.nodeType == 11) {
        cur2 = cur2.host;
      } else {
        break;
      }
    }
  }
  function scrollableParent(dom2) {
    let doc2 = dom2.ownerDocument;
    for (let cur2 = dom2.parentNode; cur2; ) {
      if (cur2 == doc2.body) {
        break;
      } else if (cur2.nodeType == 1) {
        if (cur2.scrollHeight > cur2.clientHeight || cur2.scrollWidth > cur2.clientWidth)
          return cur2;
        cur2 = cur2.assignedSlot || cur2.parentNode;
      } else if (cur2.nodeType == 11) {
        cur2 = cur2.host;
      } else {
        break;
      }
    }
    return null;
  }
  class DOMSelectionState {
    constructor() {
      this.anchorNode = null;
      this.anchorOffset = 0;
      this.focusNode = null;
      this.focusOffset = 0;
    }
    eq(domSel) {
      return this.anchorNode == domSel.anchorNode && this.anchorOffset == domSel.anchorOffset && this.focusNode == domSel.focusNode && this.focusOffset == domSel.focusOffset;
    }
    setRange(range2) {
      let { anchorNode, focusNode } = range2;
      this.set(anchorNode, Math.min(range2.anchorOffset, anchorNode ? maxOffset(anchorNode) : 0), focusNode, Math.min(range2.focusOffset, focusNode ? maxOffset(focusNode) : 0));
    }
    set(anchorNode, anchorOffset, focusNode, focusOffset) {
      this.anchorNode = anchorNode;
      this.anchorOffset = anchorOffset;
      this.focusNode = focusNode;
      this.focusOffset = focusOffset;
    }
  }
  let preventScrollSupported = null;
  function focusPreventScroll(dom2) {
    if (dom2.setActive)
      return dom2.setActive();
    if (preventScrollSupported)
      return dom2.focus(preventScrollSupported);
    let stack2 = [];
    for (let cur2 = dom2; cur2; cur2 = cur2.parentNode) {
      stack2.push(cur2, cur2.scrollTop, cur2.scrollLeft);
      if (cur2 == cur2.ownerDocument)
        break;
    }
    dom2.focus(preventScrollSupported == null ? {
      get preventScroll() {
        preventScrollSupported = { preventScroll: true };
        return true;
      }
    } : void 0);
    if (!preventScrollSupported) {
      preventScrollSupported = false;
      for (let i2 = 0; i2 < stack2.length; ) {
        let elt = stack2[i2++], top2 = stack2[i2++], left = stack2[i2++];
        if (elt.scrollTop != top2)
          elt.scrollTop = top2;
        if (elt.scrollLeft != left)
          elt.scrollLeft = left;
      }
    }
  }
  let scratchRange;
  function textRange(node, from, to = from) {
    let range2 = scratchRange || (scratchRange = document.createRange());
    range2.setEnd(node, to);
    range2.setStart(node, from);
    return range2;
  }
  function dispatchKey(elt, name2, code2) {
    let options = { key: name2, code: name2, keyCode: code2, which: code2, cancelable: true };
    let down = new KeyboardEvent("keydown", options);
    down.synthetic = true;
    elt.dispatchEvent(down);
    let up = new KeyboardEvent("keyup", options);
    up.synthetic = true;
    elt.dispatchEvent(up);
    return down.defaultPrevented || up.defaultPrevented;
  }
  function getRoot(node) {
    while (node) {
      if (node && (node.nodeType == 9 || node.nodeType == 11 && node.host))
        return node;
      node = node.assignedSlot || node.parentNode;
    }
    return null;
  }
  function clearAttributes(node) {
    while (node.attributes.length)
      node.removeAttributeNode(node.attributes[0]);
  }
  function atElementStart(doc2, selection) {
    let node = selection.focusNode, offset = selection.focusOffset;
    if (!node || selection.anchorNode != node || selection.anchorOffset != offset)
      return false;
    offset = Math.min(offset, maxOffset(node));
    for (; ; ) {
      if (offset) {
        if (node.nodeType != 1)
          return false;
        let prev = node.childNodes[offset - 1];
        if (prev.contentEditable == "false")
          offset--;
        else {
          node = prev;
          offset = maxOffset(node);
        }
      } else if (node == doc2) {
        return true;
      } else {
        offset = domIndex(node);
        node = node.parentNode;
      }
    }
  }
  function isScrolledToBottom(elt) {
    return elt.scrollTop > Math.max(1, elt.scrollHeight - elt.clientHeight - 4);
  }
  class DOMPos {
    constructor(node, offset, precise = true) {
      this.node = node;
      this.offset = offset;
      this.precise = precise;
    }
    static before(dom2, precise) {
      return new DOMPos(dom2.parentNode, domIndex(dom2), precise);
    }
    static after(dom2, precise) {
      return new DOMPos(dom2.parentNode, domIndex(dom2) + 1, precise);
    }
  }
  const noChildren = [];
  class ContentView {
    constructor() {
      this.parent = null;
      this.dom = null;
      this.flags = 2;
    }
    get overrideDOMText() {
      return null;
    }
    get posAtStart() {
      return this.parent ? this.parent.posBefore(this) : 0;
    }
    get posAtEnd() {
      return this.posAtStart + this.length;
    }
    posBefore(view) {
      let pos = this.posAtStart;
      for (let child of this.children) {
        if (child == view)
          return pos;
        pos += child.length + child.breakAfter;
      }
      throw new RangeError("Invalid child in posBefore");
    }
    posAfter(view) {
      return this.posBefore(view) + view.length;
    }
    sync(view, track2) {
      if (this.flags & 2) {
        let parent = this.dom;
        let prev = null, next;
        for (let child of this.children) {
          if (child.flags & 7) {
            if (!child.dom && (next = prev ? prev.nextSibling : parent.firstChild)) {
              let contentView = ContentView.get(next);
              if (!contentView || !contentView.parent && contentView.canReuseDOM(child))
                child.reuseDOM(next);
            }
            child.sync(view, track2);
            child.flags &= ~7;
          }
          next = prev ? prev.nextSibling : parent.firstChild;
          if (track2 && !track2.written && track2.node == parent && next != child.dom)
            track2.written = true;
          if (child.dom.parentNode == parent) {
            while (next && next != child.dom)
              next = rm$1(next);
          } else {
            parent.insertBefore(child.dom, next);
          }
          prev = child.dom;
        }
        next = prev ? prev.nextSibling : parent.firstChild;
        if (next && track2 && track2.node == parent)
          track2.written = true;
        while (next)
          next = rm$1(next);
      } else if (this.flags & 1) {
        for (let child of this.children)
          if (child.flags & 7) {
            child.sync(view, track2);
            child.flags &= ~7;
          }
      }
    }
    reuseDOM(_dom) {
    }
    localPosFromDOM(node, offset) {
      let after;
      if (node == this.dom) {
        after = this.dom.childNodes[offset];
      } else {
        let bias = maxOffset(node) == 0 ? 0 : offset == 0 ? -1 : 1;
        for (; ; ) {
          let parent = node.parentNode;
          if (parent == this.dom)
            break;
          if (bias == 0 && parent.firstChild != parent.lastChild) {
            if (node == parent.firstChild)
              bias = -1;
            else
              bias = 1;
          }
          node = parent;
        }
        if (bias < 0)
          after = node;
        else
          after = node.nextSibling;
      }
      if (after == this.dom.firstChild)
        return 0;
      while (after && !ContentView.get(after))
        after = after.nextSibling;
      if (!after)
        return this.length;
      for (let i2 = 0, pos = 0; ; i2++) {
        let child = this.children[i2];
        if (child.dom == after)
          return pos;
        pos += child.length + child.breakAfter;
      }
    }
    domBoundsAround(from, to, offset = 0) {
      let fromI = -1, fromStart = -1, toI = -1, toEnd = -1;
      for (let i2 = 0, pos = offset, prevEnd = offset; i2 < this.children.length; i2++) {
        let child = this.children[i2], end = pos + child.length;
        if (pos < from && end > to)
          return child.domBoundsAround(from, to, pos);
        if (end >= from && fromI == -1) {
          fromI = i2;
          fromStart = pos;
        }
        if (pos > to && child.dom.parentNode == this.dom) {
          toI = i2;
          toEnd = prevEnd;
          break;
        }
        prevEnd = end;
        pos = end + child.breakAfter;
      }
      return {
        from: fromStart,
        to: toEnd < 0 ? offset + this.length : toEnd,
        startDOM: (fromI ? this.children[fromI - 1].dom.nextSibling : null) || this.dom.firstChild,
        endDOM: toI < this.children.length && toI >= 0 ? this.children[toI].dom : null
      };
    }
    markDirty(andParent = false) {
      this.flags |= 2;
      this.markParentsDirty(andParent);
    }
    markParentsDirty(childList) {
      for (let parent = this.parent; parent; parent = parent.parent) {
        if (childList)
          parent.flags |= 2;
        if (parent.flags & 1)
          return;
        parent.flags |= 1;
        childList = false;
      }
    }
    setParent(parent) {
      if (this.parent != parent) {
        this.parent = parent;
        if (this.flags & 7)
          this.markParentsDirty(true);
      }
    }
    setDOM(dom2) {
      if (this.dom == dom2)
        return;
      if (this.dom)
        this.dom.cmView = null;
      this.dom = dom2;
      dom2.cmView = this;
    }
    get rootView() {
      for (let v2 = this; ; ) {
        let parent = v2.parent;
        if (!parent)
          return v2;
        v2 = parent;
      }
    }
    replaceChildren(from, to, children = noChildren) {
      this.markDirty();
      for (let i2 = from; i2 < to; i2++) {
        let child = this.children[i2];
        if (child.parent == this && children.indexOf(child) < 0)
          child.destroy();
      }
      this.children.splice(from, to - from, ...children);
      for (let i2 = 0; i2 < children.length; i2++)
        children[i2].setParent(this);
    }
    ignoreMutation(_rec) {
      return false;
    }
    ignoreEvent(_event) {
      return false;
    }
    childCursor(pos = this.length) {
      return new ChildCursor(this.children, pos, this.children.length);
    }
    childPos(pos, bias = 1) {
      return this.childCursor().findPos(pos, bias);
    }
    toString() {
      let name2 = this.constructor.name.replace("View", "");
      return name2 + (this.children.length ? "(" + this.children.join() + ")" : this.length ? "[" + (name2 == "Text" ? this.text : this.length) + "]" : "") + (this.breakAfter ? "#" : "");
    }
    static get(node) {
      return node.cmView;
    }
    get isEditable() {
      return true;
    }
    get isWidget() {
      return false;
    }
    get isHidden() {
      return false;
    }
    merge(from, to, source, hasStart, openStart, openEnd) {
      return false;
    }
    become(other) {
      return false;
    }
    canReuseDOM(other) {
      return other.constructor == this.constructor && !((this.flags | other.flags) & 8);
    }
    // When this is a zero-length view with a side, this should return a
    // number <= 0 to indicate it is before its position, or a
    // number > 0 when after its position.
    getSide() {
      return 0;
    }
    destroy() {
      for (let child of this.children)
        if (child.parent == this)
          child.destroy();
      this.parent = null;
    }
  }
  ContentView.prototype.breakAfter = 0;
  function rm$1(dom2) {
    let next = dom2.nextSibling;
    dom2.parentNode.removeChild(dom2);
    return next;
  }
  class ChildCursor {
    constructor(children, pos, i2) {
      this.children = children;
      this.pos = pos;
      this.i = i2;
      this.off = 0;
    }
    findPos(pos, bias = 1) {
      for (; ; ) {
        if (pos > this.pos || pos == this.pos && (bias > 0 || this.i == 0 || this.children[this.i - 1].breakAfter)) {
          this.off = pos - this.pos;
          return this;
        }
        let next = this.children[--this.i];
        this.pos -= next.length + next.breakAfter;
      }
    }
  }
  function replaceRange(parent, fromI, fromOff, toI, toOff, insert2, breakAtStart, openStart, openEnd) {
    let { children } = parent;
    let before = children.length ? children[fromI] : null;
    let last = insert2.length ? insert2[insert2.length - 1] : null;
    let breakAtEnd = last ? last.breakAfter : breakAtStart;
    if (fromI == toI && before && !breakAtStart && !breakAtEnd && insert2.length < 2 && before.merge(fromOff, toOff, insert2.length ? last : null, fromOff == 0, openStart, openEnd))
      return;
    if (toI < children.length) {
      let after = children[toI];
      if (after && (toOff < after.length || after.breakAfter && (last === null || last === void 0 ? void 0 : last.breakAfter))) {
        if (fromI == toI) {
          after = after.split(toOff);
          toOff = 0;
        }
        if (!breakAtEnd && last && after.merge(0, toOff, last, true, 0, openEnd)) {
          insert2[insert2.length - 1] = after;
        } else {
          if (toOff || after.children.length && !after.children[0].length)
            after.merge(0, toOff, null, false, 0, openEnd);
          insert2.push(after);
        }
      } else if (after === null || after === void 0 ? void 0 : after.breakAfter) {
        if (last)
          last.breakAfter = 1;
        else
          breakAtStart = 1;
      }
      toI++;
    }
    if (before) {
      before.breakAfter = breakAtStart;
      if (fromOff > 0) {
        if (!breakAtStart && insert2.length && before.merge(fromOff, before.length, insert2[0], false, openStart, 0)) {
          before.breakAfter = insert2.shift().breakAfter;
        } else if (fromOff < before.length || before.children.length && before.children[before.children.length - 1].length == 0) {
          before.merge(fromOff, before.length, null, false, openStart, 0);
        }
        fromI++;
      }
    }
    while (fromI < toI && insert2.length) {
      if (children[toI - 1].become(insert2[insert2.length - 1])) {
        toI--;
        insert2.pop();
        openEnd = insert2.length ? 0 : openStart;
      } else if (children[fromI].become(insert2[0])) {
        fromI++;
        insert2.shift();
        openStart = insert2.length ? 0 : openEnd;
      } else {
        break;
      }
    }
    if (!insert2.length && fromI && toI < children.length && !children[fromI - 1].breakAfter && children[toI].merge(0, 0, children[fromI - 1], false, openStart, openEnd))
      fromI--;
    if (fromI < toI || insert2.length)
      parent.replaceChildren(fromI, toI, insert2);
  }
  function mergeChildrenInto(parent, from, to, insert2, openStart, openEnd) {
    let cur2 = parent.childCursor();
    let { i: toI, off: toOff } = cur2.findPos(to, 1);
    let { i: fromI, off: fromOff } = cur2.findPos(from, -1);
    let dLen = from - to;
    for (let view of insert2)
      dLen += view.length;
    parent.length += dLen;
    replaceRange(parent, fromI, fromOff, toI, toOff, insert2, 0, openStart, openEnd);
  }
  let nav = typeof navigator != "undefined" ? navigator : { userAgent: "", vendor: "", platform: "" };
  let doc = typeof document != "undefined" ? document : { documentElement: { style: {} } };
  const ie_edge = /* @__PURE__ */ /Edge\/(\d+)/.exec(nav.userAgent);
  const ie_upto10 = /* @__PURE__ */ /MSIE \d/.test(nav.userAgent);
  const ie_11up = /* @__PURE__ */ /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(nav.userAgent);
  const ie = !!(ie_upto10 || ie_11up || ie_edge);
  const gecko = !ie && /* @__PURE__ */ /gecko\/(\d+)/i.test(nav.userAgent);
  const chrome = !ie && /* @__PURE__ */ /Chrome\/(\d+)/.exec(nav.userAgent);
  const webkit = "webkitFontSmoothing" in doc.documentElement.style;
  const safari = !ie && /* @__PURE__ */ /Apple Computer/.test(nav.vendor);
  const ios = safari && (/* @__PURE__ */ /Mobile\/\w+/.test(nav.userAgent) || nav.maxTouchPoints > 2);
  var browser = {
    mac: ios || /* @__PURE__ */ /Mac/.test(nav.platform),
    windows: /* @__PURE__ */ /Win/.test(nav.platform),
    linux: /* @__PURE__ */ /Linux|X11/.test(nav.platform),
    ie,
    ie_version: ie_upto10 ? doc.documentMode || 6 : ie_11up ? +ie_11up[1] : ie_edge ? +ie_edge[1] : 0,
    gecko,
    gecko_version: gecko ? +(/* @__PURE__ */ /Firefox\/(\d+)/.exec(nav.userAgent) || [0, 0])[1] : 0,
    chrome: !!chrome,
    chrome_version: chrome ? +chrome[1] : 0,
    ios,
    android: /* @__PURE__ */ /Android\b/.test(nav.userAgent),
    webkit,
    safari,
    webkit_version: webkit ? +(/* @__PURE__ */ /\bAppleWebKit\/(\d+)/.exec(navigator.userAgent) || [0, 0])[1] : 0,
    tabSize: doc.documentElement.style.tabSize != null ? "tab-size" : "-moz-tab-size"
  };
  const MaxJoinLen = 256;
  class TextView extends ContentView {
    constructor(text) {
      super();
      this.text = text;
    }
    get length() {
      return this.text.length;
    }
    createDOM(textDOM) {
      this.setDOM(textDOM || document.createTextNode(this.text));
    }
    sync(view, track2) {
      if (!this.dom)
        this.createDOM();
      if (this.dom.nodeValue != this.text) {
        if (track2 && track2.node == this.dom)
          track2.written = true;
        this.dom.nodeValue = this.text;
      }
    }
    reuseDOM(dom2) {
      if (dom2.nodeType == 3)
        this.createDOM(dom2);
    }
    merge(from, to, source) {
      if (this.flags & 8 || source && (!(source instanceof TextView) || this.length - (to - from) + source.length > MaxJoinLen || source.flags & 8))
        return false;
      this.text = this.text.slice(0, from) + (source ? source.text : "") + this.text.slice(to);
      this.markDirty();
      return true;
    }
    split(from) {
      let result = new TextView(this.text.slice(from));
      this.text = this.text.slice(0, from);
      this.markDirty();
      result.flags |= this.flags & 8;
      return result;
    }
    localPosFromDOM(node, offset) {
      return node == this.dom ? offset : offset ? this.text.length : 0;
    }
    domAtPos(pos) {
      return new DOMPos(this.dom, pos);
    }
    domBoundsAround(_from, _to, offset) {
      return { from: offset, to: offset + this.length, startDOM: this.dom, endDOM: this.dom.nextSibling };
    }
    coordsAt(pos, side) {
      return textCoords(this.dom, pos, side);
    }
  }
  class MarkView extends ContentView {
    constructor(mark, children = [], length = 0) {
      super();
      this.mark = mark;
      this.children = children;
      this.length = length;
      for (let ch of children)
        ch.setParent(this);
    }
    setAttrs(dom2) {
      clearAttributes(dom2);
      if (this.mark.class)
        dom2.className = this.mark.class;
      if (this.mark.attrs)
        for (let name2 in this.mark.attrs)
          dom2.setAttribute(name2, this.mark.attrs[name2]);
      return dom2;
    }
    canReuseDOM(other) {
      return super.canReuseDOM(other) && !((this.flags | other.flags) & 8);
    }
    reuseDOM(node) {
      if (node.nodeName == this.mark.tagName.toUpperCase()) {
        this.setDOM(node);
        this.flags |= 4 | 2;
      }
    }
    sync(view, track2) {
      if (!this.dom)
        this.setDOM(this.setAttrs(document.createElement(this.mark.tagName)));
      else if (this.flags & 4)
        this.setAttrs(this.dom);
      super.sync(view, track2);
    }
    merge(from, to, source, _hasStart, openStart, openEnd) {
      if (source && (!(source instanceof MarkView && source.mark.eq(this.mark)) || from && openStart <= 0 || to < this.length && openEnd <= 0))
        return false;
      mergeChildrenInto(this, from, to, source ? source.children.slice() : [], openStart - 1, openEnd - 1);
      this.markDirty();
      return true;
    }
    split(from) {
      let result = [], off = 0, detachFrom = -1, i2 = 0;
      for (let elt of this.children) {
        let end = off + elt.length;
        if (end > from)
          result.push(off < from ? elt.split(from - off) : elt);
        if (detachFrom < 0 && off >= from)
          detachFrom = i2;
        off = end;
        i2++;
      }
      let length = this.length - from;
      this.length = from;
      if (detachFrom > -1) {
        this.children.length = detachFrom;
        this.markDirty();
      }
      return new MarkView(this.mark, result, length);
    }
    domAtPos(pos) {
      return inlineDOMAtPos(this, pos);
    }
    coordsAt(pos, side) {
      return coordsInChildren(this, pos, side);
    }
  }
  function textCoords(text, pos, side) {
    let length = text.nodeValue.length;
    if (pos > length)
      pos = length;
    let from = pos, to = pos, flatten2 = 0;
    if (pos == 0 && side < 0 || pos == length && side >= 0) {
      if (!(browser.chrome || browser.gecko)) {
        if (pos) {
          from--;
          flatten2 = 1;
        } else if (to < length) {
          to++;
          flatten2 = -1;
        }
      }
    } else {
      if (side < 0)
        from--;
      else if (to < length)
        to++;
    }
    let rects = textRange(text, from, to).getClientRects();
    if (!rects.length)
      return null;
    let rect = rects[(flatten2 ? flatten2 < 0 : side >= 0) ? 0 : rects.length - 1];
    if (browser.safari && !flatten2 && rect.width == 0)
      rect = Array.prototype.find.call(rects, (r2) => r2.width) || rect;
    return flatten2 ? flattenRect(rect, flatten2 < 0) : rect || null;
  }
  class WidgetView extends ContentView {
    static create(widget, length, side) {
      return new WidgetView(widget, length, side);
    }
    constructor(widget, length, side) {
      super();
      this.widget = widget;
      this.length = length;
      this.side = side;
      this.prevWidget = null;
    }
    split(from) {
      let result = WidgetView.create(this.widget, this.length - from, this.side);
      this.length -= from;
      return result;
    }
    sync(view) {
      if (!this.dom || !this.widget.updateDOM(this.dom, view)) {
        if (this.dom && this.prevWidget)
          this.prevWidget.destroy(this.dom);
        this.prevWidget = null;
        this.setDOM(this.widget.toDOM(view));
        if (!this.widget.editable)
          this.dom.contentEditable = "false";
      }
    }
    getSide() {
      return this.side;
    }
    merge(from, to, source, hasStart, openStart, openEnd) {
      if (source && (!(source instanceof WidgetView) || !this.widget.compare(source.widget) || from > 0 && openStart <= 0 || to < this.length && openEnd <= 0))
        return false;
      this.length = from + (source ? source.length : 0) + (this.length - to);
      return true;
    }
    become(other) {
      if (other instanceof WidgetView && other.side == this.side && this.widget.constructor == other.widget.constructor) {
        if (!this.widget.compare(other.widget))
          this.markDirty(true);
        if (this.dom && !this.prevWidget)
          this.prevWidget = this.widget;
        this.widget = other.widget;
        this.length = other.length;
        return true;
      }
      return false;
    }
    ignoreMutation() {
      return true;
    }
    ignoreEvent(event) {
      return this.widget.ignoreEvent(event);
    }
    get overrideDOMText() {
      if (this.length == 0)
        return Text$1.empty;
      let top2 = this;
      while (top2.parent)
        top2 = top2.parent;
      let { view } = top2, text = view && view.state.doc, start = this.posAtStart;
      return text ? text.slice(start, start + this.length) : Text$1.empty;
    }
    domAtPos(pos) {
      return (this.length ? pos == 0 : this.side > 0) ? DOMPos.before(this.dom) : DOMPos.after(this.dom, pos == this.length);
    }
    domBoundsAround() {
      return null;
    }
    coordsAt(pos, side) {
      let custom = this.widget.coordsAt(this.dom, pos, side);
      if (custom)
        return custom;
      let rects = this.dom.getClientRects(), rect = null;
      if (!rects.length)
        return null;
      let fromBack = this.side ? this.side < 0 : pos > 0;
      for (let i2 = fromBack ? rects.length - 1 : 0; ; i2 += fromBack ? -1 : 1) {
        rect = rects[i2];
        if (pos > 0 ? i2 == 0 : i2 == rects.length - 1 || rect.top < rect.bottom)
          break;
      }
      return flattenRect(rect, !fromBack);
    }
    get isEditable() {
      return false;
    }
    get isWidget() {
      return true;
    }
    get isHidden() {
      return this.widget.isHidden;
    }
    destroy() {
      super.destroy();
      if (this.dom)
        this.widget.destroy(this.dom);
    }
  }
  class WidgetBufferView extends ContentView {
    constructor(side) {
      super();
      this.side = side;
    }
    get length() {
      return 0;
    }
    merge() {
      return false;
    }
    become(other) {
      return other instanceof WidgetBufferView && other.side == this.side;
    }
    split() {
      return new WidgetBufferView(this.side);
    }
    sync() {
      if (!this.dom) {
        let dom2 = document.createElement("img");
        dom2.className = "cm-widgetBuffer";
        dom2.setAttribute("aria-hidden", "true");
        this.setDOM(dom2);
      }
    }
    getSide() {
      return this.side;
    }
    domAtPos(pos) {
      return this.side > 0 ? DOMPos.before(this.dom) : DOMPos.after(this.dom);
    }
    localPosFromDOM() {
      return 0;
    }
    domBoundsAround() {
      return null;
    }
    coordsAt(pos) {
      return this.dom.getBoundingClientRect();
    }
    get overrideDOMText() {
      return Text$1.empty;
    }
    get isHidden() {
      return true;
    }
  }
  TextView.prototype.children = WidgetView.prototype.children = WidgetBufferView.prototype.children = noChildren;
  function inlineDOMAtPos(parent, pos) {
    let dom2 = parent.dom, { children } = parent, i2 = 0;
    for (let off = 0; i2 < children.length; i2++) {
      let child = children[i2], end = off + child.length;
      if (end == off && child.getSide() <= 0)
        continue;
      if (pos > off && pos < end && child.dom.parentNode == dom2)
        return child.domAtPos(pos - off);
      if (pos <= off)
        break;
      off = end;
    }
    for (let j2 = i2; j2 > 0; j2--) {
      let prev = children[j2 - 1];
      if (prev.dom.parentNode == dom2)
        return prev.domAtPos(prev.length);
    }
    for (let j2 = i2; j2 < children.length; j2++) {
      let next = children[j2];
      if (next.dom.parentNode == dom2)
        return next.domAtPos(0);
    }
    return new DOMPos(dom2, 0);
  }
  function joinInlineInto(parent, view, open) {
    let last, { children } = parent;
    if (open > 0 && view instanceof MarkView && children.length && (last = children[children.length - 1]) instanceof MarkView && last.mark.eq(view.mark)) {
      joinInlineInto(last, view.children[0], open - 1);
    } else {
      children.push(view);
      view.setParent(parent);
    }
    parent.length += view.length;
  }
  function coordsInChildren(view, pos, side) {
    let before = null, beforePos = -1, after = null, afterPos = -1;
    function scan(view2, pos2) {
      for (let i2 = 0, off = 0; i2 < view2.children.length && off <= pos2; i2++) {
        let child = view2.children[i2], end = off + child.length;
        if (end >= pos2) {
          if (child.children.length) {
            scan(child, pos2 - off);
          } else if ((!after || after.isHidden && side > 0) && (end > pos2 || off == end && child.getSide() > 0)) {
            after = child;
            afterPos = pos2 - off;
          } else if (off < pos2 || off == end && child.getSide() < 0 && !child.isHidden) {
            before = child;
            beforePos = pos2 - off;
          }
        }
        off = end;
      }
    }
    scan(view, pos);
    let target = (side < 0 ? before : after) || before || after;
    if (target)
      return target.coordsAt(Math.max(0, target == before ? beforePos : afterPos), side);
    return fallbackRect(view);
  }
  function fallbackRect(view) {
    let last = view.dom.lastChild;
    if (!last)
      return view.dom.getBoundingClientRect();
    let rects = clientRectsFor(last);
    return rects[rects.length - 1] || null;
  }
  function combineAttrs(source, target) {
    for (let name2 in source) {
      if (name2 == "class" && target.class)
        target.class += " " + source.class;
      else if (name2 == "style" && target.style)
        target.style += ";" + source.style;
      else
        target[name2] = source[name2];
    }
    return target;
  }
  const noAttrs = /* @__PURE__ */ Object.create(null);
  function attrsEq(a2, b2, ignore) {
    if (a2 == b2)
      return true;
    if (!a2)
      a2 = noAttrs;
    if (!b2)
      b2 = noAttrs;
    let keysA = Object.keys(a2), keysB = Object.keys(b2);
    if (keysA.length - (ignore && keysA.indexOf(ignore) > -1 ? 1 : 0) != keysB.length - (ignore && keysB.indexOf(ignore) > -1 ? 1 : 0))
      return false;
    for (let key of keysA) {
      if (key != ignore && (keysB.indexOf(key) == -1 || a2[key] !== b2[key]))
        return false;
    }
    return true;
  }
  function updateAttrs(dom2, prev, attrs) {
    let changed = false;
    if (prev) {
      for (let name2 in prev)
        if (!(attrs && name2 in attrs)) {
          changed = true;
          if (name2 == "style")
            dom2.style.cssText = "";
          else
            dom2.removeAttribute(name2);
        }
    }
    if (attrs) {
      for (let name2 in attrs)
        if (!(prev && prev[name2] == attrs[name2])) {
          changed = true;
          if (name2 == "style")
            dom2.style.cssText = attrs[name2];
          else
            dom2.setAttribute(name2, attrs[name2]);
        }
    }
    return changed;
  }
  function getAttrs$1(dom2) {
    let attrs = /* @__PURE__ */ Object.create(null);
    for (let i2 = 0; i2 < dom2.attributes.length; i2++) {
      let attr = dom2.attributes[i2];
      attrs[attr.name] = attr.value;
    }
    return attrs;
  }
  class LineView extends ContentView {
    constructor() {
      super(...arguments);
      this.children = [];
      this.length = 0;
      this.prevAttrs = void 0;
      this.attrs = null;
      this.breakAfter = 0;
    }
    // Consumes source
    merge(from, to, source, hasStart, openStart, openEnd) {
      if (source) {
        if (!(source instanceof LineView))
          return false;
        if (!this.dom)
          source.transferDOM(this);
      }
      if (hasStart)
        this.setDeco(source ? source.attrs : null);
      mergeChildrenInto(this, from, to, source ? source.children.slice() : [], openStart, openEnd);
      return true;
    }
    split(at) {
      let end = new LineView();
      end.breakAfter = this.breakAfter;
      if (this.length == 0)
        return end;
      let { i: i2, off } = this.childPos(at);
      if (off) {
        end.append(this.children[i2].split(off), 0);
        this.children[i2].merge(off, this.children[i2].length, null, false, 0, 0);
        i2++;
      }
      for (let j2 = i2; j2 < this.children.length; j2++)
        end.append(this.children[j2], 0);
      while (i2 > 0 && this.children[i2 - 1].length == 0)
        this.children[--i2].destroy();
      this.children.length = i2;
      this.markDirty();
      this.length = at;
      return end;
    }
    transferDOM(other) {
      if (!this.dom)
        return;
      this.markDirty();
      other.setDOM(this.dom);
      other.prevAttrs = this.prevAttrs === void 0 ? this.attrs : this.prevAttrs;
      this.prevAttrs = void 0;
      this.dom = null;
    }
    setDeco(attrs) {
      if (!attrsEq(this.attrs, attrs)) {
        if (this.dom) {
          this.prevAttrs = this.attrs;
          this.markDirty();
        }
        this.attrs = attrs;
      }
    }
    append(child, openStart) {
      joinInlineInto(this, child, openStart);
    }
    // Only called when building a line view in ContentBuilder
    addLineDeco(deco) {
      let attrs = deco.spec.attributes, cls = deco.spec.class;
      if (attrs)
        this.attrs = combineAttrs(attrs, this.attrs || {});
      if (cls)
        this.attrs = combineAttrs({ class: cls }, this.attrs || {});
    }
    domAtPos(pos) {
      return inlineDOMAtPos(this, pos);
    }
    reuseDOM(node) {
      if (node.nodeName == "DIV") {
        this.setDOM(node);
        this.flags |= 4 | 2;
      }
    }
    sync(view, track2) {
      var _a2;
      if (!this.dom) {
        this.setDOM(document.createElement("div"));
        this.dom.className = "cm-line";
        this.prevAttrs = this.attrs ? null : void 0;
      } else if (this.flags & 4) {
        clearAttributes(this.dom);
        this.dom.className = "cm-line";
        this.prevAttrs = this.attrs ? null : void 0;
      }
      if (this.prevAttrs !== void 0) {
        updateAttrs(this.dom, this.prevAttrs, this.attrs);
        this.dom.classList.add("cm-line");
        this.prevAttrs = void 0;
      }
      super.sync(view, track2);
      let last = this.dom.lastChild;
      while (last && ContentView.get(last) instanceof MarkView)
        last = last.lastChild;
      if (!last || !this.length || last.nodeName != "BR" && ((_a2 = ContentView.get(last)) === null || _a2 === void 0 ? void 0 : _a2.isEditable) == false && (!browser.ios || !this.children.some((ch) => ch instanceof TextView))) {
        let hack = document.createElement("BR");
        hack.cmIgnore = true;
        this.dom.appendChild(hack);
      }
    }
    measureTextSize() {
      if (this.children.length == 0 || this.length > 20)
        return null;
      let totalWidth = 0, textHeight;
      for (let child of this.children) {
        if (!(child instanceof TextView) || /[^ -~]/.test(child.text))
          return null;
        let rects = clientRectsFor(child.dom);
        if (rects.length != 1)
          return null;
        totalWidth += rects[0].width;
        textHeight = rects[0].height;
      }
      return !totalWidth ? null : {
        lineHeight: this.dom.getBoundingClientRect().height,
        charWidth: totalWidth / this.length,
        textHeight
      };
    }
    coordsAt(pos, side) {
      let rect = coordsInChildren(this, pos, side);
      if (!this.children.length && rect && this.parent) {
        let { heightOracle } = this.parent.view.viewState, height = rect.bottom - rect.top;
        if (Math.abs(height - heightOracle.lineHeight) < 2 && heightOracle.textHeight < height) {
          let dist2 = (height - heightOracle.textHeight) / 2;
          return { top: rect.top + dist2, bottom: rect.bottom - dist2, left: rect.left, right: rect.left };
        }
      }
      return rect;
    }
    become(_other) {
      return false;
    }
    covers() {
      return true;
    }
    static find(docView, pos) {
      for (let i2 = 0, off = 0; i2 < docView.children.length; i2++) {
        let block = docView.children[i2], end = off + block.length;
        if (end >= pos) {
          if (block instanceof LineView)
            return block;
          if (end > pos)
            break;
        }
        off = end + block.breakAfter;
      }
      return null;
    }
  }
  class BlockWidgetView extends ContentView {
    constructor(widget, length, deco) {
      super();
      this.widget = widget;
      this.length = length;
      this.deco = deco;
      this.breakAfter = 0;
      this.prevWidget = null;
    }
    merge(from, to, source, _takeDeco, openStart, openEnd) {
      if (source && (!(source instanceof BlockWidgetView) || !this.widget.compare(source.widget) || from > 0 && openStart <= 0 || to < this.length && openEnd <= 0))
        return false;
      this.length = from + (source ? source.length : 0) + (this.length - to);
      return true;
    }
    domAtPos(pos) {
      return pos == 0 ? DOMPos.before(this.dom) : DOMPos.after(this.dom, pos == this.length);
    }
    split(at) {
      let len = this.length - at;
      this.length = at;
      let end = new BlockWidgetView(this.widget, len, this.deco);
      end.breakAfter = this.breakAfter;
      return end;
    }
    get children() {
      return noChildren;
    }
    sync(view) {
      if (!this.dom || !this.widget.updateDOM(this.dom, view)) {
        if (this.dom && this.prevWidget)
          this.prevWidget.destroy(this.dom);
        this.prevWidget = null;
        this.setDOM(this.widget.toDOM(view));
        if (!this.widget.editable)
          this.dom.contentEditable = "false";
      }
    }
    get overrideDOMText() {
      return this.parent ? this.parent.view.state.doc.slice(this.posAtStart, this.posAtEnd) : Text$1.empty;
    }
    domBoundsAround() {
      return null;
    }
    become(other) {
      if (other instanceof BlockWidgetView && other.widget.constructor == this.widget.constructor) {
        if (!other.widget.compare(this.widget))
          this.markDirty(true);
        if (this.dom && !this.prevWidget)
          this.prevWidget = this.widget;
        this.widget = other.widget;
        this.length = other.length;
        this.deco = other.deco;
        this.breakAfter = other.breakAfter;
        return true;
      }
      return false;
    }
    ignoreMutation() {
      return true;
    }
    ignoreEvent(event) {
      return this.widget.ignoreEvent(event);
    }
    get isEditable() {
      return false;
    }
    get isWidget() {
      return true;
    }
    coordsAt(pos, side) {
      return this.widget.coordsAt(this.dom, pos, side);
    }
    destroy() {
      super.destroy();
      if (this.dom)
        this.widget.destroy(this.dom);
    }
    covers(side) {
      let { startSide, endSide } = this.deco;
      return startSide == endSide ? false : side < 0 ? startSide < 0 : endSide > 0;
    }
  }
  class WidgetType {
    /**
    Compare this instance to another instance of the same type.
    (TypeScript can't express this, but only instances of the same
    specific class will be passed to this method.) This is used to
    avoid redrawing widgets when they are replaced by a new
    decoration of the same type. The default implementation just
    returns `false`, which will cause new instances of the widget to
    always be redrawn.
    */
    eq(widget) {
      return false;
    }
    /**
    Update a DOM element created by a widget of the same type (but
    different, non-`eq` content) to reflect this widget. May return
    true to indicate that it could update, false to indicate it
    couldn't (in which case the widget will be redrawn). The default
    implementation just returns false.
    */
    updateDOM(dom2, view) {
      return false;
    }
    /**
    @internal
    */
    compare(other) {
      return this == other || this.constructor == other.constructor && this.eq(other);
    }
    /**
    The estimated height this widget will have, to be used when
    estimating the height of content that hasn't been drawn. May
    return -1 to indicate you don't know. The default implementation
    returns -1.
    */
    get estimatedHeight() {
      return -1;
    }
    /**
    For inline widgets that are displayed inline (as opposed to
    `inline-block`) and introduce line breaks (through `<br>` tags
    or textual newlines), this must indicate the amount of line
    breaks they introduce. Defaults to 0.
    */
    get lineBreaks() {
      return 0;
    }
    /**
    Can be used to configure which kinds of events inside the widget
    should be ignored by the editor. The default is to ignore all
    events.
    */
    ignoreEvent(event) {
      return true;
    }
    /**
    Override the way screen coordinates for positions at/in the
    widget are found. `pos` will be the offset into the widget, and
    `side` the side of the position that is being queried—less than
    zero for before, greater than zero for after, and zero for
    directly at that position.
    */
    coordsAt(dom2, pos, side) {
      return null;
    }
    /**
    @internal
    */
    get isHidden() {
      return false;
    }
    /**
    @internal
    */
    get editable() {
      return false;
    }
    /**
    This is called when the an instance of the widget is removed
    from the editor view.
    */
    destroy(dom2) {
    }
  }
  var BlockType = /* @__PURE__ */ function(BlockType2) {
    BlockType2[BlockType2["Text"] = 0] = "Text";
    BlockType2[BlockType2["WidgetBefore"] = 1] = "WidgetBefore";
    BlockType2[BlockType2["WidgetAfter"] = 2] = "WidgetAfter";
    BlockType2[BlockType2["WidgetRange"] = 3] = "WidgetRange";
    return BlockType2;
  }(BlockType || (BlockType = {}));
  class Decoration extends RangeValue {
    constructor(startSide, endSide, widget, spec) {
      super();
      this.startSide = startSide;
      this.endSide = endSide;
      this.widget = widget;
      this.spec = spec;
    }
    /**
    @internal
    */
    get heightRelevant() {
      return false;
    }
    /**
    Create a mark decoration, which influences the styling of the
    content in its range. Nested mark decorations will cause nested
    DOM elements to be created. Nesting order is determined by
    precedence of the [facet](https://codemirror.net/6/docs/ref/#view.EditorView^decorations), with
    the higher-precedence decorations creating the inner DOM nodes.
    Such elements are split on line boundaries and on the boundaries
    of lower-precedence decorations.
    */
    static mark(spec) {
      return new MarkDecoration(spec);
    }
    /**
    Create a widget decoration, which displays a DOM element at the
    given position.
    */
    static widget(spec) {
      let side = Math.max(-1e4, Math.min(1e4, spec.side || 0)), block = !!spec.block;
      side += block && !spec.inlineOrder ? side > 0 ? 3e8 : -4e8 : side > 0 ? 1e8 : -1e8;
      return new PointDecoration(spec, side, side, block, spec.widget || null, false);
    }
    /**
    Create a replace decoration which replaces the given range with
    a widget, or simply hides it.
    */
    static replace(spec) {
      let block = !!spec.block, startSide, endSide;
      if (spec.isBlockGap) {
        startSide = -5e8;
        endSide = 4e8;
      } else {
        let { start, end } = getInclusive(spec, block);
        startSide = (start ? block ? -3e8 : -1 : 5e8) - 1;
        endSide = (end ? block ? 2e8 : 1 : -6e8) + 1;
      }
      return new PointDecoration(spec, startSide, endSide, block, spec.widget || null, true);
    }
    /**
    Create a line decoration, which can add DOM attributes to the
    line starting at the given position.
    */
    static line(spec) {
      return new LineDecoration(spec);
    }
    /**
    Build a [`DecorationSet`](https://codemirror.net/6/docs/ref/#view.DecorationSet) from the given
    decorated range or ranges. If the ranges aren't already sorted,
    pass `true` for `sort` to make the library sort them for you.
    */
    static set(of, sort = false) {
      return RangeSet.of(of, sort);
    }
    /**
    @internal
    */
    hasHeight() {
      return this.widget ? this.widget.estimatedHeight > -1 : false;
    }
  }
  Decoration.none = RangeSet.empty;
  class MarkDecoration extends Decoration {
    constructor(spec) {
      let { start, end } = getInclusive(spec);
      super(start ? -1 : 5e8, end ? 1 : -6e8, null, spec);
      this.tagName = spec.tagName || "span";
      this.class = spec.class || "";
      this.attrs = spec.attributes || null;
    }
    eq(other) {
      var _a2, _b;
      return this == other || other instanceof MarkDecoration && this.tagName == other.tagName && (this.class || ((_a2 = this.attrs) === null || _a2 === void 0 ? void 0 : _a2.class)) == (other.class || ((_b = other.attrs) === null || _b === void 0 ? void 0 : _b.class)) && attrsEq(this.attrs, other.attrs, "class");
    }
    range(from, to = from) {
      if (from >= to)
        throw new RangeError("Mark decorations may not be empty");
      return super.range(from, to);
    }
  }
  MarkDecoration.prototype.point = false;
  class LineDecoration extends Decoration {
    constructor(spec) {
      super(-2e8, -2e8, null, spec);
    }
    eq(other) {
      return other instanceof LineDecoration && this.spec.class == other.spec.class && attrsEq(this.spec.attributes, other.spec.attributes);
    }
    range(from, to = from) {
      if (to != from)
        throw new RangeError("Line decoration ranges must be zero-length");
      return super.range(from, to);
    }
  }
  LineDecoration.prototype.mapMode = MapMode.TrackBefore;
  LineDecoration.prototype.point = true;
  class PointDecoration extends Decoration {
    constructor(spec, startSide, endSide, block, widget, isReplace) {
      super(startSide, endSide, widget, spec);
      this.block = block;
      this.isReplace = isReplace;
      this.mapMode = !block ? MapMode.TrackDel : startSide <= 0 ? MapMode.TrackBefore : MapMode.TrackAfter;
    }
    // Only relevant when this.block == true
    get type() {
      return this.startSide != this.endSide ? BlockType.WidgetRange : this.startSide <= 0 ? BlockType.WidgetBefore : BlockType.WidgetAfter;
    }
    get heightRelevant() {
      return this.block || !!this.widget && (this.widget.estimatedHeight >= 5 || this.widget.lineBreaks > 0);
    }
    eq(other) {
      return other instanceof PointDecoration && widgetsEq(this.widget, other.widget) && this.block == other.block && this.startSide == other.startSide && this.endSide == other.endSide;
    }
    range(from, to = from) {
      if (this.isReplace && (from > to || from == to && this.startSide > 0 && this.endSide <= 0))
        throw new RangeError("Invalid range for replacement decoration");
      if (!this.isReplace && to != from)
        throw new RangeError("Widget decorations can only have zero-length ranges");
      return super.range(from, to);
    }
  }
  PointDecoration.prototype.point = true;
  function getInclusive(spec, block = false) {
    let { inclusiveStart: start, inclusiveEnd: end } = spec;
    if (start == null)
      start = spec.inclusive;
    if (end == null)
      end = spec.inclusive;
    return { start: start !== null && start !== void 0 ? start : block, end: end !== null && end !== void 0 ? end : block };
  }
  function widgetsEq(a2, b2) {
    return a2 == b2 || !!(a2 && b2 && a2.compare(b2));
  }
  function addRange(from, to, ranges, margin = 0) {
    let last = ranges.length - 1;
    if (last >= 0 && ranges[last] + margin >= from)
      ranges[last] = Math.max(ranges[last], to);
    else
      ranges.push(from, to);
  }
  class ContentBuilder {
    constructor(doc2, pos, end, disallowBlockEffectsFor) {
      this.doc = doc2;
      this.pos = pos;
      this.end = end;
      this.disallowBlockEffectsFor = disallowBlockEffectsFor;
      this.content = [];
      this.curLine = null;
      this.breakAtStart = 0;
      this.pendingBuffer = 0;
      this.bufferMarks = [];
      this.atCursorPos = true;
      this.openStart = -1;
      this.openEnd = -1;
      this.text = "";
      this.textOff = 0;
      this.cursor = doc2.iter();
      this.skip = pos;
    }
    posCovered() {
      if (this.content.length == 0)
        return !this.breakAtStart && this.doc.lineAt(this.pos).from != this.pos;
      let last = this.content[this.content.length - 1];
      return !(last.breakAfter || last instanceof BlockWidgetView && last.deco.endSide < 0);
    }
    getLine() {
      if (!this.curLine) {
        this.content.push(this.curLine = new LineView());
        this.atCursorPos = true;
      }
      return this.curLine;
    }
    flushBuffer(active = this.bufferMarks) {
      if (this.pendingBuffer) {
        this.curLine.append(wrapMarks(new WidgetBufferView(-1), active), active.length);
        this.pendingBuffer = 0;
      }
    }
    addBlockWidget(view) {
      this.flushBuffer();
      this.curLine = null;
      this.content.push(view);
    }
    finish(openEnd) {
      if (this.pendingBuffer && openEnd <= this.bufferMarks.length)
        this.flushBuffer();
      else
        this.pendingBuffer = 0;
      if (!this.posCovered() && !(openEnd && this.content.length && this.content[this.content.length - 1] instanceof BlockWidgetView))
        this.getLine();
    }
    buildText(length, active, openStart) {
      while (length > 0) {
        if (this.textOff == this.text.length) {
          let { value, lineBreak, done } = this.cursor.next(this.skip);
          this.skip = 0;
          if (done)
            throw new Error("Ran out of text content when drawing inline views");
          if (lineBreak) {
            if (!this.posCovered())
              this.getLine();
            if (this.content.length)
              this.content[this.content.length - 1].breakAfter = 1;
            else
              this.breakAtStart = 1;
            this.flushBuffer();
            this.curLine = null;
            this.atCursorPos = true;
            length--;
            continue;
          } else {
            this.text = value;
            this.textOff = 0;
          }
        }
        let take = Math.min(
          this.text.length - this.textOff,
          length,
          512
          /* T.Chunk */
        );
        this.flushBuffer(active.slice(active.length - openStart));
        this.getLine().append(wrapMarks(new TextView(this.text.slice(this.textOff, this.textOff + take)), active), openStart);
        this.atCursorPos = true;
        this.textOff += take;
        length -= take;
        openStart = 0;
      }
    }
    span(from, to, active, openStart) {
      this.buildText(to - from, active, openStart);
      this.pos = to;
      if (this.openStart < 0)
        this.openStart = openStart;
    }
    point(from, to, deco, active, openStart, index2) {
      if (this.disallowBlockEffectsFor[index2] && deco instanceof PointDecoration) {
        if (deco.block)
          throw new RangeError("Block decorations may not be specified via plugins");
        if (to > this.doc.lineAt(this.pos).to)
          throw new RangeError("Decorations that replace line breaks may not be specified via plugins");
      }
      let len = to - from;
      if (deco instanceof PointDecoration) {
        if (deco.block) {
          if (deco.startSide > 0 && !this.posCovered())
            this.getLine();
          this.addBlockWidget(new BlockWidgetView(deco.widget || new NullWidget("div"), len, deco));
        } else {
          let view = WidgetView.create(deco.widget || new NullWidget("span"), len, len ? 0 : deco.startSide);
          let cursorBefore = this.atCursorPos && !view.isEditable && openStart <= active.length && (from < to || deco.startSide > 0);
          let cursorAfter = !view.isEditable && (from < to || openStart > active.length || deco.startSide <= 0);
          let line = this.getLine();
          if (this.pendingBuffer == 2 && !cursorBefore && !view.isEditable)
            this.pendingBuffer = 0;
          this.flushBuffer(active);
          if (cursorBefore) {
            line.append(wrapMarks(new WidgetBufferView(1), active), openStart);
            openStart = active.length + Math.max(0, openStart - active.length);
          }
          line.append(wrapMarks(view, active), openStart);
          this.atCursorPos = cursorAfter;
          this.pendingBuffer = !cursorAfter ? 0 : from < to || openStart > active.length ? 1 : 2;
          if (this.pendingBuffer)
            this.bufferMarks = active.slice();
        }
      } else if (this.doc.lineAt(this.pos).from == this.pos) {
        this.getLine().addLineDeco(deco);
      }
      if (len) {
        if (this.textOff + len <= this.text.length) {
          this.textOff += len;
        } else {
          this.skip += len - (this.text.length - this.textOff);
          this.text = "";
          this.textOff = 0;
        }
        this.pos = to;
      }
      if (this.openStart < 0)
        this.openStart = openStart;
    }
    static build(text, from, to, decorations2, dynamicDecorationMap) {
      let builder = new ContentBuilder(text, from, to, dynamicDecorationMap);
      builder.openEnd = RangeSet.spans(decorations2, from, to, builder);
      if (builder.openStart < 0)
        builder.openStart = builder.openEnd;
      builder.finish(builder.openEnd);
      return builder;
    }
  }
  function wrapMarks(view, active) {
    for (let mark of active)
      view = new MarkView(mark, [view], view.length);
    return view;
  }
  class NullWidget extends WidgetType {
    constructor(tag) {
      super();
      this.tag = tag;
    }
    eq(other) {
      return other.tag == this.tag;
    }
    toDOM() {
      return document.createElement(this.tag);
    }
    updateDOM(elt) {
      return elt.nodeName.toLowerCase() == this.tag;
    }
    get isHidden() {
      return true;
    }
  }
  var Direction = /* @__PURE__ */ function(Direction2) {
    Direction2[Direction2["LTR"] = 0] = "LTR";
    Direction2[Direction2["RTL"] = 1] = "RTL";
    return Direction2;
  }(Direction || (Direction = {}));
  const LTR = Direction.LTR, RTL = Direction.RTL;
  function dec(str) {
    let result = [];
    for (let i2 = 0; i2 < str.length; i2++)
      result.push(1 << +str[i2]);
    return result;
  }
  const LowTypes = /* @__PURE__ */ dec("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008");
  const ArabicTypes = /* @__PURE__ */ dec("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333");
  const Brackets = /* @__PURE__ */ Object.create(null), BracketStack = [];
  for (let p2 of ["()", "[]", "{}"]) {
    let l2 = /* @__PURE__ */ p2.charCodeAt(0), r2 = /* @__PURE__ */ p2.charCodeAt(1);
    Brackets[l2] = r2;
    Brackets[r2] = -l2;
  }
  function charType(ch) {
    return ch <= 247 ? LowTypes[ch] : 1424 <= ch && ch <= 1524 ? 2 : 1536 <= ch && ch <= 1785 ? ArabicTypes[ch - 1536] : 1774 <= ch && ch <= 2220 ? 4 : 8192 <= ch && ch <= 8204 ? 256 : 64336 <= ch && ch <= 65023 ? 4 : 1;
  }
  const BidiRE = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;
  class BidiSpan {
    /**
    The direction of this span.
    */
    get dir() {
      return this.level % 2 ? RTL : LTR;
    }
    /**
    @internal
    */
    constructor(from, to, level) {
      this.from = from;
      this.to = to;
      this.level = level;
    }
    /**
    @internal
    */
    side(end, dir) {
      return this.dir == dir == end ? this.to : this.from;
    }
    /**
    @internal
    */
    forward(forward, dir) {
      return forward == (this.dir == dir);
    }
    /**
    @internal
    */
    static find(order, index2, level, assoc) {
      let maybe = -1;
      for (let i2 = 0; i2 < order.length; i2++) {
        let span = order[i2];
        if (span.from <= index2 && span.to >= index2) {
          if (span.level == level)
            return i2;
          if (maybe < 0 || (assoc != 0 ? assoc < 0 ? span.from < index2 : span.to > index2 : order[maybe].level > span.level))
            maybe = i2;
        }
      }
      if (maybe < 0)
        throw new RangeError("Index out of range");
      return maybe;
    }
  }
  function isolatesEq(a2, b2) {
    if (a2.length != b2.length)
      return false;
    for (let i2 = 0; i2 < a2.length; i2++) {
      let iA = a2[i2], iB = b2[i2];
      if (iA.from != iB.from || iA.to != iB.to || iA.direction != iB.direction || !isolatesEq(iA.inner, iB.inner))
        return false;
    }
    return true;
  }
  const types = [];
  function computeCharTypes(line, rFrom, rTo, isolates, outerType) {
    for (let iI = 0; iI <= isolates.length; iI++) {
      let from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
      let prevType = iI ? 256 : outerType;
      for (let i2 = from, prev = prevType, prevStrong = prevType; i2 < to; i2++) {
        let type = charType(line.charCodeAt(i2));
        if (type == 512)
          type = prev;
        else if (type == 8 && prevStrong == 4)
          type = 16;
        types[i2] = type == 4 ? 2 : type;
        if (type & 7)
          prevStrong = type;
        prev = type;
      }
      for (let i2 = from, prev = prevType, prevStrong = prevType; i2 < to; i2++) {
        let type = types[i2];
        if (type == 128) {
          if (i2 < to - 1 && prev == types[i2 + 1] && prev & 24)
            type = types[i2] = prev;
          else
            types[i2] = 256;
        } else if (type == 64) {
          let end = i2 + 1;
          while (end < to && types[end] == 64)
            end++;
          let replace = i2 && prev == 8 || end < rTo && types[end] == 8 ? prevStrong == 1 ? 1 : 8 : 256;
          for (let j2 = i2; j2 < end; j2++)
            types[j2] = replace;
          i2 = end - 1;
        } else if (type == 8 && prevStrong == 1) {
          types[i2] = 1;
        }
        prev = type;
        if (type & 7)
          prevStrong = type;
      }
    }
  }
  function processBracketPairs(line, rFrom, rTo, isolates, outerType) {
    let oppositeType = outerType == 1 ? 2 : 1;
    for (let iI = 0, sI = 0, context = 0; iI <= isolates.length; iI++) {
      let from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
      for (let i2 = from, ch, br, type; i2 < to; i2++) {
        if (br = Brackets[ch = line.charCodeAt(i2)]) {
          if (br < 0) {
            for (let sJ = sI - 3; sJ >= 0; sJ -= 3) {
              if (BracketStack[sJ + 1] == -br) {
                let flags = BracketStack[sJ + 2];
                let type2 = flags & 2 ? outerType : !(flags & 4) ? 0 : flags & 1 ? oppositeType : outerType;
                if (type2)
                  types[i2] = types[BracketStack[sJ]] = type2;
                sI = sJ;
                break;
              }
            }
          } else if (BracketStack.length == 189) {
            break;
          } else {
            BracketStack[sI++] = i2;
            BracketStack[sI++] = ch;
            BracketStack[sI++] = context;
          }
        } else if ((type = types[i2]) == 2 || type == 1) {
          let embed = type == outerType;
          context = embed ? 0 : 1;
          for (let sJ = sI - 3; sJ >= 0; sJ -= 3) {
            let cur2 = BracketStack[sJ + 2];
            if (cur2 & 2)
              break;
            if (embed) {
              BracketStack[sJ + 2] |= 2;
            } else {
              if (cur2 & 4)
                break;
              BracketStack[sJ + 2] |= 4;
            }
          }
        }
      }
    }
  }
  function processNeutrals(rFrom, rTo, isolates, outerType) {
    for (let iI = 0, prev = outerType; iI <= isolates.length; iI++) {
      let from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
      for (let i2 = from; i2 < to; ) {
        let type = types[i2];
        if (type == 256) {
          let end = i2 + 1;
          for (; ; ) {
            if (end == to) {
              if (iI == isolates.length)
                break;
              end = isolates[iI++].to;
              to = iI < isolates.length ? isolates[iI].from : rTo;
            } else if (types[end] == 256) {
              end++;
            } else {
              break;
            }
          }
          let beforeL = prev == 1;
          let afterL = (end < rTo ? types[end] : outerType) == 1;
          let replace = beforeL == afterL ? beforeL ? 1 : 2 : outerType;
          for (let j2 = end, jI = iI, fromJ = jI ? isolates[jI - 1].to : rFrom; j2 > i2; ) {
            if (j2 == fromJ) {
              j2 = isolates[--jI].from;
              fromJ = jI ? isolates[jI - 1].to : rFrom;
            }
            types[--j2] = replace;
          }
          i2 = end;
        } else {
          prev = type;
          i2++;
        }
      }
    }
  }
  function emitSpans(line, from, to, level, baseLevel, isolates, order) {
    let ourType = level % 2 ? 2 : 1;
    if (level % 2 == baseLevel % 2) {
      for (let iCh = from, iI = 0; iCh < to; ) {
        let sameDir = true, isNum = false;
        if (iI == isolates.length || iCh < isolates[iI].from) {
          let next = types[iCh];
          if (next != ourType) {
            sameDir = false;
            isNum = next == 16;
          }
        }
        let recurse = !sameDir && ourType == 1 ? [] : null;
        let localLevel = sameDir ? level : level + 1;
        let iScan = iCh;
        run:
          for (; ; ) {
            if (iI < isolates.length && iScan == isolates[iI].from) {
              if (isNum)
                break run;
              let iso = isolates[iI];
              if (!sameDir)
                for (let upto = iso.to, jI = iI + 1; ; ) {
                  if (upto == to)
                    break run;
                  if (jI < isolates.length && isolates[jI].from == upto)
                    upto = isolates[jI++].to;
                  else if (types[upto] == ourType)
                    break run;
                  else
                    break;
                }
              iI++;
              if (recurse) {
                recurse.push(iso);
              } else {
                if (iso.from > iCh)
                  order.push(new BidiSpan(iCh, iso.from, localLevel));
                let dirSwap = iso.direction == LTR != !(localLevel % 2);
                computeSectionOrder(line, dirSwap ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order);
                iCh = iso.to;
              }
              iScan = iso.to;
            } else if (iScan == to || (sameDir ? types[iScan] != ourType : types[iScan] == ourType)) {
              break;
            } else {
              iScan++;
            }
          }
        if (recurse)
          emitSpans(line, iCh, iScan, level + 1, baseLevel, recurse, order);
        else if (iCh < iScan)
          order.push(new BidiSpan(iCh, iScan, localLevel));
        iCh = iScan;
      }
    } else {
      for (let iCh = to, iI = isolates.length; iCh > from; ) {
        let sameDir = true, isNum = false;
        if (!iI || iCh > isolates[iI - 1].to) {
          let next = types[iCh - 1];
          if (next != ourType) {
            sameDir = false;
            isNum = next == 16;
          }
        }
        let recurse = !sameDir && ourType == 1 ? [] : null;
        let localLevel = sameDir ? level : level + 1;
        let iScan = iCh;
        run:
          for (; ; ) {
            if (iI && iScan == isolates[iI - 1].to) {
              if (isNum)
                break run;
              let iso = isolates[--iI];
              if (!sameDir)
                for (let upto = iso.from, jI = iI; ; ) {
                  if (upto == from)
                    break run;
                  if (jI && isolates[jI - 1].to == upto)
                    upto = isolates[--jI].from;
                  else if (types[upto - 1] == ourType)
                    break run;
                  else
                    break;
                }
              if (recurse) {
                recurse.push(iso);
              } else {
                if (iso.to < iCh)
                  order.push(new BidiSpan(iso.to, iCh, localLevel));
                let dirSwap = iso.direction == LTR != !(localLevel % 2);
                computeSectionOrder(line, dirSwap ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order);
                iCh = iso.from;
              }
              iScan = iso.from;
            } else if (iScan == from || (sameDir ? types[iScan - 1] != ourType : types[iScan - 1] == ourType)) {
              break;
            } else {
              iScan--;
            }
          }
        if (recurse)
          emitSpans(line, iScan, iCh, level + 1, baseLevel, recurse, order);
        else if (iScan < iCh)
          order.push(new BidiSpan(iScan, iCh, localLevel));
        iCh = iScan;
      }
    }
  }
  function computeSectionOrder(line, level, baseLevel, isolates, from, to, order) {
    let outerType = level % 2 ? 2 : 1;
    computeCharTypes(line, from, to, isolates, outerType);
    processBracketPairs(line, from, to, isolates, outerType);
    processNeutrals(from, to, isolates, outerType);
    emitSpans(line, from, to, level, baseLevel, isolates, order);
  }
  function computeOrder(line, direction, isolates) {
    if (!line)
      return [new BidiSpan(0, 0, direction == RTL ? 1 : 0)];
    if (direction == LTR && !isolates.length && !BidiRE.test(line))
      return trivialOrder(line.length);
    if (isolates.length)
      while (line.length > types.length)
        types[types.length] = 256;
    let order = [], level = direction == LTR ? 0 : 1;
    computeSectionOrder(line, level, level, isolates, 0, line.length, order);
    return order;
  }
  function trivialOrder(length) {
    return [new BidiSpan(0, length, 0)];
  }
  let movedOver = "";
  function moveVisually(line, order, dir, start, forward) {
    var _a2;
    let startIndex = start.head - line.from;
    let spanI = BidiSpan.find(order, startIndex, (_a2 = start.bidiLevel) !== null && _a2 !== void 0 ? _a2 : -1, start.assoc);
    let span = order[spanI], spanEnd = span.side(forward, dir);
    if (startIndex == spanEnd) {
      let nextI = spanI += forward ? 1 : -1;
      if (nextI < 0 || nextI >= order.length)
        return null;
      span = order[spanI = nextI];
      startIndex = span.side(!forward, dir);
      spanEnd = span.side(forward, dir);
    }
    let nextIndex = findClusterBreak(line.text, startIndex, span.forward(forward, dir));
    if (nextIndex < span.from || nextIndex > span.to)
      nextIndex = spanEnd;
    movedOver = line.text.slice(Math.min(startIndex, nextIndex), Math.max(startIndex, nextIndex));
    let nextSpan = spanI == (forward ? order.length - 1 : 0) ? null : order[spanI + (forward ? 1 : -1)];
    if (nextSpan && nextIndex == spanEnd && nextSpan.level + (forward ? 0 : 1) < span.level)
      return EditorSelection.cursor(nextSpan.side(!forward, dir) + line.from, nextSpan.forward(forward, dir) ? 1 : -1, nextSpan.level);
    return EditorSelection.cursor(nextIndex + line.from, span.forward(forward, dir) ? -1 : 1, span.level);
  }
  function autoDirection(text, from, to) {
    for (let i2 = from; i2 < to; i2++) {
      let type = charType(text.charCodeAt(i2));
      if (type == 1)
        return LTR;
      if (type == 2 || type == 4)
        return RTL;
    }
    return LTR;
  }
  const clickAddsSelectionRange = /* @__PURE__ */ Facet.define();
  const dragMovesSelection$1 = /* @__PURE__ */ Facet.define();
  const mouseSelectionStyle = /* @__PURE__ */ Facet.define();
  const exceptionSink = /* @__PURE__ */ Facet.define();
  const updateListener = /* @__PURE__ */ Facet.define();
  const inputHandler$1 = /* @__PURE__ */ Facet.define();
  const focusChangeEffect = /* @__PURE__ */ Facet.define();
  const perLineTextDirection = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.some((x2) => x2)
  });
  const nativeSelectionHidden = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.some((x2) => x2)
  });
  class ScrollTarget {
    constructor(range2, y2 = "nearest", x2 = "nearest", yMargin = 5, xMargin = 5, isSnapshot = false) {
      this.range = range2;
      this.y = y2;
      this.x = x2;
      this.yMargin = yMargin;
      this.xMargin = xMargin;
      this.isSnapshot = isSnapshot;
    }
    map(changes) {
      return changes.empty ? this : new ScrollTarget(this.range.map(changes), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
    }
    clip(state2) {
      return this.range.to <= state2.doc.length ? this : new ScrollTarget(EditorSelection.cursor(state2.doc.length), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
    }
  }
  const scrollIntoView$1 = /* @__PURE__ */ StateEffect.define({ map: (t2, ch) => t2.map(ch) });
  function logException(state2, exception, context) {
    let handler = state2.facet(exceptionSink);
    if (handler.length)
      handler[0](exception);
    else if (window.onerror)
      window.onerror(String(exception), context, void 0, void 0, exception);
    else if (context)
      console.error(context + ":", exception);
    else
      console.error(exception);
  }
  const editable = /* @__PURE__ */ Facet.define({ combine: (values2) => values2.length ? values2[0] : true });
  let nextPluginID = 0;
  const viewPlugin = /* @__PURE__ */ Facet.define();
  class ViewPlugin {
    constructor(id2, create, domEventHandlers, domEventObservers, buildExtensions) {
      this.id = id2;
      this.create = create;
      this.domEventHandlers = domEventHandlers;
      this.domEventObservers = domEventObservers;
      this.extension = buildExtensions(this);
    }
    /**
    Define a plugin from a constructor function that creates the
    plugin's value, given an editor view.
    */
    static define(create, spec) {
      const { eventHandlers, eventObservers, provide: provide2, decorations: deco } = spec || {};
      return new ViewPlugin(nextPluginID++, create, eventHandlers, eventObservers, (plugin) => {
        let ext = [viewPlugin.of(plugin)];
        if (deco)
          ext.push(decorations.of((view) => {
            let pluginInst = view.plugin(plugin);
            return pluginInst ? deco(pluginInst) : Decoration.none;
          }));
        if (provide2)
          ext.push(provide2(plugin));
        return ext;
      });
    }
    /**
    Create a plugin for a class whose constructor takes a single
    editor view as argument.
    */
    static fromClass(cls, spec) {
      return ViewPlugin.define((view) => new cls(view), spec);
    }
  }
  class PluginInstance {
    constructor(spec) {
      this.spec = spec;
      this.mustUpdate = null;
      this.value = null;
    }
    update(view) {
      if (!this.value) {
        if (this.spec) {
          try {
            this.value = this.spec.create(view);
          } catch (e2) {
            logException(view.state, e2, "CodeMirror plugin crashed");
            this.deactivate();
          }
        }
      } else if (this.mustUpdate) {
        let update = this.mustUpdate;
        this.mustUpdate = null;
        if (this.value.update) {
          try {
            this.value.update(update);
          } catch (e2) {
            logException(update.state, e2, "CodeMirror plugin crashed");
            if (this.value.destroy)
              try {
                this.value.destroy();
              } catch (_2) {
              }
            this.deactivate();
          }
        }
      }
      return this;
    }
    destroy(view) {
      var _a2;
      if ((_a2 = this.value) === null || _a2 === void 0 ? void 0 : _a2.destroy) {
        try {
          this.value.destroy();
        } catch (e2) {
          logException(view.state, e2, "CodeMirror plugin crashed");
        }
      }
    }
    deactivate() {
      this.spec = this.value = null;
    }
  }
  const editorAttributes = /* @__PURE__ */ Facet.define();
  const contentAttributes = /* @__PURE__ */ Facet.define();
  const decorations = /* @__PURE__ */ Facet.define();
  const outerDecorations = /* @__PURE__ */ Facet.define();
  const atomicRanges = /* @__PURE__ */ Facet.define();
  const bidiIsolatedRanges = /* @__PURE__ */ Facet.define();
  function getIsolatedRanges(view, line) {
    let isolates = view.state.facet(bidiIsolatedRanges);
    if (!isolates.length)
      return isolates;
    let sets = isolates.map((i2) => i2 instanceof Function ? i2(view) : i2);
    let result = [];
    RangeSet.spans(sets, line.from, line.to, {
      point() {
      },
      span(fromDoc, toDoc, active, open) {
        let from = fromDoc - line.from, to = toDoc - line.from;
        let level = result;
        for (let i2 = active.length - 1; i2 >= 0; i2--, open--) {
          let direction = active[i2].spec.bidiIsolate, update;
          if (direction == null)
            direction = autoDirection(line.text, from, to);
          if (open > 0 && level.length && (update = level[level.length - 1]).to == from && update.direction == direction) {
            update.to = to;
            level = update.inner;
          } else {
            let add2 = { from, to, direction, inner: [] };
            level.push(add2);
            level = add2.inner;
          }
        }
      }
    });
    return result;
  }
  const scrollMargins = /* @__PURE__ */ Facet.define();
  function getScrollMargins(view) {
    let left = 0, right = 0, top2 = 0, bottom = 0;
    for (let source of view.state.facet(scrollMargins)) {
      let m2 = source(view);
      if (m2) {
        if (m2.left != null)
          left = Math.max(left, m2.left);
        if (m2.right != null)
          right = Math.max(right, m2.right);
        if (m2.top != null)
          top2 = Math.max(top2, m2.top);
        if (m2.bottom != null)
          bottom = Math.max(bottom, m2.bottom);
      }
    }
    return { left, right, top: top2, bottom };
  }
  const styleModule = /* @__PURE__ */ Facet.define();
  class ChangedRange {
    constructor(fromA, toA, fromB, toB) {
      this.fromA = fromA;
      this.toA = toA;
      this.fromB = fromB;
      this.toB = toB;
    }
    join(other) {
      return new ChangedRange(Math.min(this.fromA, other.fromA), Math.max(this.toA, other.toA), Math.min(this.fromB, other.fromB), Math.max(this.toB, other.toB));
    }
    addToSet(set2) {
      let i2 = set2.length, me2 = this;
      for (; i2 > 0; i2--) {
        let range2 = set2[i2 - 1];
        if (range2.fromA > me2.toA)
          continue;
        if (range2.toA < me2.fromA)
          break;
        me2 = me2.join(range2);
        set2.splice(i2 - 1, 1);
      }
      set2.splice(i2, 0, me2);
      return set2;
    }
    static extendWithRanges(diff, ranges) {
      if (ranges.length == 0)
        return diff;
      let result = [];
      for (let dI = 0, rI = 0, posA = 0, posB = 0; ; dI++) {
        let next = dI == diff.length ? null : diff[dI], off = posA - posB;
        let end = next ? next.fromB : 1e9;
        while (rI < ranges.length && ranges[rI] < end) {
          let from = ranges[rI], to = ranges[rI + 1];
          let fromB = Math.max(posB, from), toB = Math.min(end, to);
          if (fromB <= toB)
            new ChangedRange(fromB + off, toB + off, fromB, toB).addToSet(result);
          if (to > end)
            break;
          else
            rI += 2;
        }
        if (!next)
          return result;
        new ChangedRange(next.fromA, next.toA, next.fromB, next.toB).addToSet(result);
        posA = next.toA;
        posB = next.toB;
      }
    }
  }
  class ViewUpdate {
    constructor(view, state2, transactions) {
      this.view = view;
      this.state = state2;
      this.transactions = transactions;
      this.flags = 0;
      this.startState = view.state;
      this.changes = ChangeSet.empty(this.startState.doc.length);
      for (let tr of transactions)
        this.changes = this.changes.compose(tr.changes);
      let changedRanges = [];
      this.changes.iterChangedRanges((fromA, toA, fromB, toB) => changedRanges.push(new ChangedRange(fromA, toA, fromB, toB)));
      this.changedRanges = changedRanges;
    }
    /**
    @internal
    */
    static create(view, state2, transactions) {
      return new ViewUpdate(view, state2, transactions);
    }
    /**
    Tells you whether the [viewport](https://codemirror.net/6/docs/ref/#view.EditorView.viewport) or
    [visible ranges](https://codemirror.net/6/docs/ref/#view.EditorView.visibleRanges) changed in this
    update.
    */
    get viewportChanged() {
      return (this.flags & 4) > 0;
    }
    /**
    Indicates whether the height of a block element in the editor
    changed in this update.
    */
    get heightChanged() {
      return (this.flags & 2) > 0;
    }
    /**
    Returns true when the document was modified or the size of the
    editor, or elements within the editor, changed.
    */
    get geometryChanged() {
      return this.docChanged || (this.flags & (8 | 2)) > 0;
    }
    /**
    True when this update indicates a focus change.
    */
    get focusChanged() {
      return (this.flags & 1) > 0;
    }
    /**
    Whether the document changed in this update.
    */
    get docChanged() {
      return !this.changes.empty;
    }
    /**
    Whether the selection was explicitly set in this update.
    */
    get selectionSet() {
      return this.transactions.some((tr) => tr.selection);
    }
    /**
    @internal
    */
    get empty() {
      return this.flags == 0 && this.transactions.length == 0;
    }
  }
  class DocView extends ContentView {
    get length() {
      return this.view.state.doc.length;
    }
    constructor(view) {
      super();
      this.view = view;
      this.decorations = [];
      this.dynamicDecorationMap = [];
      this.domChanged = null;
      this.hasComposition = null;
      this.markedForComposition = /* @__PURE__ */ new Set();
      this.minWidth = 0;
      this.minWidthFrom = 0;
      this.minWidthTo = 0;
      this.impreciseAnchor = null;
      this.impreciseHead = null;
      this.forceSelection = false;
      this.lastUpdate = Date.now();
      this.setDOM(view.contentDOM);
      this.children = [new LineView()];
      this.children[0].setParent(this);
      this.updateDeco();
      this.updateInner([new ChangedRange(0, 0, 0, view.state.doc.length)], 0, null);
    }
    // Update the document view to a given state.
    update(update) {
      var _a2;
      let changedRanges = update.changedRanges;
      if (this.minWidth > 0 && changedRanges.length) {
        if (!changedRanges.every(({ fromA, toA }) => toA < this.minWidthFrom || fromA > this.minWidthTo)) {
          this.minWidth = this.minWidthFrom = this.minWidthTo = 0;
        } else {
          this.minWidthFrom = update.changes.mapPos(this.minWidthFrom, 1);
          this.minWidthTo = update.changes.mapPos(this.minWidthTo, 1);
        }
      }
      let readCompositionAt = -1;
      if (this.view.inputState.composing >= 0) {
        if ((_a2 = this.domChanged) === null || _a2 === void 0 ? void 0 : _a2.newSel)
          readCompositionAt = this.domChanged.newSel.head;
        else if (!touchesComposition(update.changes, this.hasComposition) && !update.selectionSet)
          readCompositionAt = update.state.selection.main.head;
      }
      let composition = readCompositionAt > -1 ? findCompositionRange(this.view, update.changes, readCompositionAt) : null;
      this.domChanged = null;
      if (this.hasComposition) {
        this.markedForComposition.clear();
        let { from, to } = this.hasComposition;
        changedRanges = new ChangedRange(from, to, update.changes.mapPos(from, -1), update.changes.mapPos(to, 1)).addToSet(changedRanges.slice());
      }
      this.hasComposition = composition ? { from: composition.range.fromB, to: composition.range.toB } : null;
      if ((browser.ie || browser.chrome) && !composition && update && update.state.doc.lines != update.startState.doc.lines)
        this.forceSelection = true;
      let prevDeco = this.decorations, deco = this.updateDeco();
      let decoDiff = findChangedDeco(prevDeco, deco, update.changes);
      changedRanges = ChangedRange.extendWithRanges(changedRanges, decoDiff);
      if (!(this.flags & 7) && changedRanges.length == 0) {
        return false;
      } else {
        this.updateInner(changedRanges, update.startState.doc.length, composition);
        if (update.transactions.length)
          this.lastUpdate = Date.now();
        return true;
      }
    }
    // Used by update and the constructor do perform the actual DOM
    // update
    updateInner(changes, oldLength, composition) {
      this.view.viewState.mustMeasureContent = true;
      this.updateChildren(changes, oldLength, composition);
      let { observer } = this.view;
      observer.ignore(() => {
        this.dom.style.height = this.view.viewState.contentHeight / this.view.scaleY + "px";
        this.dom.style.flexBasis = this.minWidth ? this.minWidth + "px" : "";
        let track2 = browser.chrome || browser.ios ? { node: observer.selectionRange.focusNode, written: false } : void 0;
        this.sync(this.view, track2);
        this.flags &= ~7;
        if (track2 && (track2.written || observer.selectionRange.focusNode != track2.node))
          this.forceSelection = true;
        this.dom.style.height = "";
      });
      this.markedForComposition.forEach(
        (cView) => cView.flags &= ~8
        /* ViewFlag.Composition */
      );
      let gaps = [];
      if (this.view.viewport.from || this.view.viewport.to < this.view.state.doc.length) {
        for (let child of this.children)
          if (child instanceof BlockWidgetView && child.widget instanceof BlockGapWidget)
            gaps.push(child.dom);
      }
      observer.updateGaps(gaps);
    }
    updateChildren(changes, oldLength, composition) {
      let ranges = composition ? composition.range.addToSet(changes.slice()) : changes;
      let cursor = this.childCursor(oldLength);
      for (let i2 = ranges.length - 1; ; i2--) {
        let next = i2 >= 0 ? ranges[i2] : null;
        if (!next)
          break;
        let { fromA, toA, fromB, toB } = next, content2, breakAtStart, openStart, openEnd;
        if (composition && composition.range.fromB < toB && composition.range.toB > fromB) {
          let before = ContentBuilder.build(this.view.state.doc, fromB, composition.range.fromB, this.decorations, this.dynamicDecorationMap);
          let after = ContentBuilder.build(this.view.state.doc, composition.range.toB, toB, this.decorations, this.dynamicDecorationMap);
          breakAtStart = before.breakAtStart;
          openStart = before.openStart;
          openEnd = after.openEnd;
          let compLine = this.compositionView(composition);
          if (after.breakAtStart) {
            compLine.breakAfter = 1;
          } else if (after.content.length && compLine.merge(compLine.length, compLine.length, after.content[0], false, after.openStart, 0)) {
            compLine.breakAfter = after.content[0].breakAfter;
            after.content.shift();
          }
          if (before.content.length && compLine.merge(0, 0, before.content[before.content.length - 1], true, 0, before.openEnd)) {
            before.content.pop();
          }
          content2 = before.content.concat(compLine).concat(after.content);
        } else {
          ({ content: content2, breakAtStart, openStart, openEnd } = ContentBuilder.build(this.view.state.doc, fromB, toB, this.decorations, this.dynamicDecorationMap));
        }
        let { i: toI, off: toOff } = cursor.findPos(toA, 1);
        let { i: fromI, off: fromOff } = cursor.findPos(fromA, -1);
        replaceRange(this, fromI, fromOff, toI, toOff, content2, breakAtStart, openStart, openEnd);
      }
      if (composition)
        this.fixCompositionDOM(composition);
    }
    compositionView(composition) {
      let cur2 = new TextView(composition.text.nodeValue);
      cur2.flags |= 8;
      for (let { deco } of composition.marks)
        cur2 = new MarkView(deco, [cur2], cur2.length);
      let line = new LineView();
      line.append(cur2, 0);
      return line;
    }
    fixCompositionDOM(composition) {
      let fix = (dom2, cView2) => {
        cView2.flags |= 8 | (cView2.children.some(
          (c2) => c2.flags & 7
          /* ViewFlag.Dirty */
        ) ? 1 : 0);
        this.markedForComposition.add(cView2);
        let prev = ContentView.get(dom2);
        if (prev && prev != cView2)
          prev.dom = null;
        cView2.setDOM(dom2);
      };
      let pos = this.childPos(composition.range.fromB, 1);
      let cView = this.children[pos.i];
      fix(composition.line, cView);
      for (let i2 = composition.marks.length - 1; i2 >= -1; i2--) {
        pos = cView.childPos(pos.off, 1);
        cView = cView.children[pos.i];
        fix(i2 >= 0 ? composition.marks[i2].node : composition.text, cView);
      }
    }
    // Sync the DOM selection to this.state.selection
    updateSelection(mustRead = false, fromPointer = false) {
      if (mustRead || !this.view.observer.selectionRange.focusNode)
        this.view.observer.readSelectionRange();
      let activeElt = this.view.root.activeElement, focused = activeElt == this.dom;
      let selectionNotFocus = !focused && hasSelection(this.dom, this.view.observer.selectionRange) && !(activeElt && this.dom.contains(activeElt));
      if (!(focused || fromPointer || selectionNotFocus))
        return;
      let force = this.forceSelection;
      this.forceSelection = false;
      let main = this.view.state.selection.main;
      let anchor = this.moveToLine(this.domAtPos(main.anchor));
      let head = main.empty ? anchor : this.moveToLine(this.domAtPos(main.head));
      if (browser.gecko && main.empty && !this.hasComposition && betweenUneditable(anchor)) {
        let dummy = document.createTextNode("");
        this.view.observer.ignore(() => anchor.node.insertBefore(dummy, anchor.node.childNodes[anchor.offset] || null));
        anchor = head = new DOMPos(dummy, 0);
        force = true;
      }
      let domSel = this.view.observer.selectionRange;
      if (force || !domSel.focusNode || (!isEquivalentPosition(anchor.node, anchor.offset, domSel.anchorNode, domSel.anchorOffset) || !isEquivalentPosition(head.node, head.offset, domSel.focusNode, domSel.focusOffset)) && !this.suppressWidgetCursorChange(domSel, main)) {
        this.view.observer.ignore(() => {
          if (browser.android && browser.chrome && this.dom.contains(domSel.focusNode) && inUneditable(domSel.focusNode, this.dom)) {
            this.dom.blur();
            this.dom.focus({ preventScroll: true });
          }
          let rawSel = getSelection(this.view.root);
          if (!rawSel)
            ;
          else if (main.empty) {
            if (browser.gecko) {
              let nextTo = nextToUneditable(anchor.node, anchor.offset);
              if (nextTo && nextTo != (1 | 2)) {
                let text = nearbyTextNode(anchor.node, anchor.offset, nextTo == 1 ? 1 : -1);
                if (text)
                  anchor = new DOMPos(text.node, text.offset);
              }
            }
            rawSel.collapse(anchor.node, anchor.offset);
            if (main.bidiLevel != null && rawSel.caretBidiLevel !== void 0)
              rawSel.caretBidiLevel = main.bidiLevel;
          } else if (rawSel.extend) {
            rawSel.collapse(anchor.node, anchor.offset);
            try {
              rawSel.extend(head.node, head.offset);
            } catch (_2) {
            }
          } else {
            let range2 = document.createRange();
            if (main.anchor > main.head)
              [anchor, head] = [head, anchor];
            range2.setEnd(head.node, head.offset);
            range2.setStart(anchor.node, anchor.offset);
            rawSel.removeAllRanges();
            rawSel.addRange(range2);
          }
          if (selectionNotFocus && this.view.root.activeElement == this.dom) {
            this.dom.blur();
            if (activeElt)
              activeElt.focus();
          }
        });
        this.view.observer.setSelectionRange(anchor, head);
      }
      this.impreciseAnchor = anchor.precise ? null : new DOMPos(domSel.anchorNode, domSel.anchorOffset);
      this.impreciseHead = head.precise ? null : new DOMPos(domSel.focusNode, domSel.focusOffset);
    }
    // If a zero-length widget is inserted next to the cursor during
    // composition, avoid moving it across it and disrupting the
    // composition.
    suppressWidgetCursorChange(sel, cursor) {
      return this.hasComposition && cursor.empty && isEquivalentPosition(sel.focusNode, sel.focusOffset, sel.anchorNode, sel.anchorOffset) && this.posFromDOM(sel.focusNode, sel.focusOffset) == cursor.head;
    }
    enforceCursorAssoc() {
      if (this.hasComposition)
        return;
      let { view } = this, cursor = view.state.selection.main;
      let sel = getSelection(view.root);
      let { anchorNode, anchorOffset } = view.observer.selectionRange;
      if (!sel || !cursor.empty || !cursor.assoc || !sel.modify)
        return;
      let line = LineView.find(this, cursor.head);
      if (!line)
        return;
      let lineStart = line.posAtStart;
      if (cursor.head == lineStart || cursor.head == lineStart + line.length)
        return;
      let before = this.coordsAt(cursor.head, -1), after = this.coordsAt(cursor.head, 1);
      if (!before || !after || before.bottom > after.top)
        return;
      let dom2 = this.domAtPos(cursor.head + cursor.assoc);
      sel.collapse(dom2.node, dom2.offset);
      sel.modify("move", cursor.assoc < 0 ? "forward" : "backward", "lineboundary");
      view.observer.readSelectionRange();
      let newRange = view.observer.selectionRange;
      if (view.docView.posFromDOM(newRange.anchorNode, newRange.anchorOffset) != cursor.from)
        sel.collapse(anchorNode, anchorOffset);
    }
    // If a position is in/near a block widget, move it to a nearby text
    // line, since we don't want the cursor inside a block widget.
    moveToLine(pos) {
      let dom2 = this.dom, newPos;
      if (pos.node != dom2)
        return pos;
      for (let i2 = pos.offset; !newPos && i2 < dom2.childNodes.length; i2++) {
        let view = ContentView.get(dom2.childNodes[i2]);
        if (view instanceof LineView)
          newPos = view.domAtPos(0);
      }
      for (let i2 = pos.offset - 1; !newPos && i2 >= 0; i2--) {
        let view = ContentView.get(dom2.childNodes[i2]);
        if (view instanceof LineView)
          newPos = view.domAtPos(view.length);
      }
      return newPos ? new DOMPos(newPos.node, newPos.offset, true) : pos;
    }
    nearest(dom2) {
      for (let cur2 = dom2; cur2; ) {
        let domView = ContentView.get(cur2);
        if (domView && domView.rootView == this)
          return domView;
        cur2 = cur2.parentNode;
      }
      return null;
    }
    posFromDOM(node, offset) {
      let view = this.nearest(node);
      if (!view)
        throw new RangeError("Trying to find position for a DOM position outside of the document");
      return view.localPosFromDOM(node, offset) + view.posAtStart;
    }
    domAtPos(pos) {
      let { i: i2, off } = this.childCursor().findPos(pos, -1);
      for (; i2 < this.children.length - 1; ) {
        let child = this.children[i2];
        if (off < child.length || child instanceof LineView)
          break;
        i2++;
        off = 0;
      }
      return this.children[i2].domAtPos(off);
    }
    coordsAt(pos, side) {
      let best = null, bestPos = 0;
      for (let off = this.length, i2 = this.children.length - 1; i2 >= 0; i2--) {
        let child = this.children[i2], end = off - child.breakAfter, start = end - child.length;
        if (end < pos)
          break;
        if (start <= pos && (start < pos || child.covers(-1)) && (end > pos || child.covers(1)) && (!best || child instanceof LineView && !(best instanceof LineView && side >= 0))) {
          best = child;
          bestPos = start;
        }
        off = start;
      }
      return best ? best.coordsAt(pos - bestPos, side) : null;
    }
    coordsForChar(pos) {
      let { i: i2, off } = this.childPos(pos, 1), child = this.children[i2];
      if (!(child instanceof LineView))
        return null;
      while (child.children.length) {
        let { i: i22, off: childOff } = child.childPos(off, 1);
        for (; ; i22++) {
          if (i22 == child.children.length)
            return null;
          if ((child = child.children[i22]).length)
            break;
        }
        off = childOff;
      }
      if (!(child instanceof TextView))
        return null;
      let end = findClusterBreak(child.text, off);
      if (end == off)
        return null;
      let rects = textRange(child.dom, off, end).getClientRects();
      for (let i22 = 0; i22 < rects.length; i22++) {
        let rect = rects[i22];
        if (i22 == rects.length - 1 || rect.top < rect.bottom && rect.left < rect.right)
          return rect;
      }
      return null;
    }
    measureVisibleLineHeights(viewport) {
      let result = [], { from, to } = viewport;
      let contentWidth = this.view.contentDOM.clientWidth;
      let isWider = contentWidth > Math.max(this.view.scrollDOM.clientWidth, this.minWidth) + 1;
      let widest = -1, ltr = this.view.textDirection == Direction.LTR;
      for (let pos = 0, i2 = 0; i2 < this.children.length; i2++) {
        let child = this.children[i2], end = pos + child.length;
        if (end > to)
          break;
        if (pos >= from) {
          let childRect = child.dom.getBoundingClientRect();
          result.push(childRect.height);
          if (isWider) {
            let last = child.dom.lastChild;
            let rects = last ? clientRectsFor(last) : [];
            if (rects.length) {
              let rect = rects[rects.length - 1];
              let width = ltr ? rect.right - childRect.left : childRect.right - rect.left;
              if (width > widest) {
                widest = width;
                this.minWidth = contentWidth;
                this.minWidthFrom = pos;
                this.minWidthTo = end;
              }
            }
          }
        }
        pos = end + child.breakAfter;
      }
      return result;
    }
    textDirectionAt(pos) {
      let { i: i2 } = this.childPos(pos, 1);
      return getComputedStyle(this.children[i2].dom).direction == "rtl" ? Direction.RTL : Direction.LTR;
    }
    measureTextSize() {
      for (let child of this.children) {
        if (child instanceof LineView) {
          let measure = child.measureTextSize();
          if (measure)
            return measure;
        }
      }
      let dummy = document.createElement("div"), lineHeight, charWidth, textHeight;
      dummy.className = "cm-line";
      dummy.style.width = "99999px";
      dummy.style.position = "absolute";
      dummy.textContent = "abc def ghi jkl mno pqr stu";
      this.view.observer.ignore(() => {
        this.dom.appendChild(dummy);
        let rect = clientRectsFor(dummy.firstChild)[0];
        lineHeight = dummy.getBoundingClientRect().height;
        charWidth = rect ? rect.width / 27 : 7;
        textHeight = rect ? rect.height : lineHeight;
        dummy.remove();
      });
      return { lineHeight, charWidth, textHeight };
    }
    childCursor(pos = this.length) {
      let i2 = this.children.length;
      if (i2)
        pos -= this.children[--i2].length;
      return new ChildCursor(this.children, pos, i2);
    }
    computeBlockGapDeco() {
      let deco = [], vs = this.view.viewState;
      for (let pos = 0, i2 = 0; ; i2++) {
        let next = i2 == vs.viewports.length ? null : vs.viewports[i2];
        let end = next ? next.from - 1 : this.length;
        if (end > pos) {
          let height = (vs.lineBlockAt(end).bottom - vs.lineBlockAt(pos).top) / this.view.scaleY;
          deco.push(Decoration.replace({
            widget: new BlockGapWidget(height),
            block: true,
            inclusive: true,
            isBlockGap: true
          }).range(pos, end));
        }
        if (!next)
          break;
        pos = next.to + 1;
      }
      return Decoration.set(deco);
    }
    updateDeco() {
      let allDeco = this.view.state.facet(decorations).map((d2, i2) => {
        let dynamic = this.dynamicDecorationMap[i2] = typeof d2 == "function";
        return dynamic ? d2(this.view) : d2;
      });
      let dynamicOuter = false, outerDeco = this.view.state.facet(outerDecorations).map((d2, i2) => {
        let dynamic = typeof d2 == "function";
        if (dynamic)
          dynamicOuter = true;
        return dynamic ? d2(this.view) : d2;
      });
      if (outerDeco.length) {
        this.dynamicDecorationMap[allDeco.length] = dynamicOuter;
        allDeco.push(RangeSet.join(outerDeco));
      }
      for (let i2 = allDeco.length; i2 < allDeco.length + 3; i2++)
        this.dynamicDecorationMap[i2] = false;
      return this.decorations = [
        ...allDeco,
        this.computeBlockGapDeco(),
        this.view.viewState.lineGapDeco
      ];
    }
    scrollIntoView(target) {
      if (target.isSnapshot) {
        let ref2 = this.view.viewState.lineBlockAt(target.range.head);
        this.view.scrollDOM.scrollTop = ref2.top - target.yMargin;
        this.view.scrollDOM.scrollLeft = target.xMargin;
        return;
      }
      let { range: range2 } = target;
      let rect = this.coordsAt(range2.head, range2.empty ? range2.assoc : range2.head > range2.anchor ? -1 : 1), other;
      if (!rect)
        return;
      if (!range2.empty && (other = this.coordsAt(range2.anchor, range2.anchor > range2.head ? -1 : 1)))
        rect = {
          left: Math.min(rect.left, other.left),
          top: Math.min(rect.top, other.top),
          right: Math.max(rect.right, other.right),
          bottom: Math.max(rect.bottom, other.bottom)
        };
      let margins = getScrollMargins(this.view);
      let targetRect = {
        left: rect.left - margins.left,
        top: rect.top - margins.top,
        right: rect.right + margins.right,
        bottom: rect.bottom + margins.bottom
      };
      let { offsetWidth, offsetHeight } = this.view.scrollDOM;
      scrollRectIntoView(this.view.scrollDOM, targetRect, range2.head < range2.anchor ? -1 : 1, target.x, target.y, Math.max(Math.min(target.xMargin, offsetWidth), -offsetWidth), Math.max(Math.min(target.yMargin, offsetHeight), -offsetHeight), this.view.textDirection == Direction.LTR);
    }
  }
  function betweenUneditable(pos) {
    return pos.node.nodeType == 1 && pos.node.firstChild && (pos.offset == 0 || pos.node.childNodes[pos.offset - 1].contentEditable == "false") && (pos.offset == pos.node.childNodes.length || pos.node.childNodes[pos.offset].contentEditable == "false");
  }
  class BlockGapWidget extends WidgetType {
    constructor(height) {
      super();
      this.height = height;
    }
    toDOM() {
      let elt = document.createElement("div");
      elt.className = "cm-gap";
      this.updateDOM(elt);
      return elt;
    }
    eq(other) {
      return other.height == this.height;
    }
    updateDOM(elt) {
      elt.style.height = this.height + "px";
      return true;
    }
    get editable() {
      return true;
    }
    get estimatedHeight() {
      return this.height;
    }
    ignoreEvent() {
      return false;
    }
  }
  function findCompositionNode(view, headPos) {
    let sel = view.observer.selectionRange;
    let textNode = sel.focusNode && nearbyTextNode(sel.focusNode, sel.focusOffset, 0);
    if (!textNode)
      return null;
    let from = headPos - textNode.offset;
    return { from, to: from + textNode.node.nodeValue.length, node: textNode.node };
  }
  function findCompositionRange(view, changes, headPos) {
    let found = findCompositionNode(view, headPos);
    if (!found)
      return null;
    let { node: textNode, from, to } = found, text = textNode.nodeValue;
    if (/[\n\r]/.test(text))
      return null;
    if (view.state.doc.sliceString(found.from, found.to) != text)
      return null;
    let inv = changes.invertedDesc;
    let range2 = new ChangedRange(inv.mapPos(from), inv.mapPos(to), from, to);
    let marks = [];
    for (let parent = textNode.parentNode; ; parent = parent.parentNode) {
      let parentView = ContentView.get(parent);
      if (parentView instanceof MarkView)
        marks.push({ node: parent, deco: parentView.mark });
      else if (parentView instanceof LineView || parent.nodeName == "DIV" && parent.parentNode == view.contentDOM)
        return { range: range2, text: textNode, marks, line: parent };
      else if (parent != view.contentDOM)
        marks.push({ node: parent, deco: new MarkDecoration({
          inclusive: true,
          attributes: getAttrs$1(parent),
          tagName: parent.tagName.toLowerCase()
        }) });
      else
        return null;
    }
  }
  function nearbyTextNode(startNode, startOffset, side) {
    if (side <= 0)
      for (let node = startNode, offset = startOffset; ; ) {
        if (node.nodeType == 3)
          return { node, offset };
        if (node.nodeType == 1 && offset > 0) {
          node = node.childNodes[offset - 1];
          offset = maxOffset(node);
        } else {
          break;
        }
      }
    if (side >= 0)
      for (let node = startNode, offset = startOffset; ; ) {
        if (node.nodeType == 3)
          return { node, offset };
        if (node.nodeType == 1 && offset < node.childNodes.length && side >= 0) {
          node = node.childNodes[offset];
          offset = 0;
        } else {
          break;
        }
      }
    return null;
  }
  function nextToUneditable(node, offset) {
    if (node.nodeType != 1)
      return 0;
    return (offset && node.childNodes[offset - 1].contentEditable == "false" ? 1 : 0) | (offset < node.childNodes.length && node.childNodes[offset].contentEditable == "false" ? 2 : 0);
  }
  let DecorationComparator$1 = class DecorationComparator {
    constructor() {
      this.changes = [];
    }
    compareRange(from, to) {
      addRange(from, to, this.changes);
    }
    comparePoint(from, to) {
      addRange(from, to, this.changes);
    }
  };
  function findChangedDeco(a2, b2, diff) {
    let comp = new DecorationComparator$1();
    RangeSet.compare(a2, b2, diff, comp);
    return comp.changes;
  }
  function inUneditable(node, inside2) {
    for (let cur2 = node; cur2 && cur2 != inside2; cur2 = cur2.assignedSlot || cur2.parentNode) {
      if (cur2.nodeType == 1 && cur2.contentEditable == "false") {
        return true;
      }
    }
    return false;
  }
  function touchesComposition(changes, composition) {
    let touched = false;
    if (composition)
      changes.iterChangedRanges((from, to) => {
        if (from < composition.to && to > composition.from)
          touched = true;
      });
    return touched;
  }
  function groupAt(state2, pos, bias = 1) {
    let categorize = state2.charCategorizer(pos);
    let line = state2.doc.lineAt(pos), linePos = pos - line.from;
    if (line.length == 0)
      return EditorSelection.cursor(pos);
    if (linePos == 0)
      bias = 1;
    else if (linePos == line.length)
      bias = -1;
    let from = linePos, to = linePos;
    if (bias < 0)
      from = findClusterBreak(line.text, linePos, false);
    else
      to = findClusterBreak(line.text, linePos);
    let cat = categorize(line.text.slice(from, to));
    while (from > 0) {
      let prev = findClusterBreak(line.text, from, false);
      if (categorize(line.text.slice(prev, from)) != cat)
        break;
      from = prev;
    }
    while (to < line.length) {
      let next = findClusterBreak(line.text, to);
      if (categorize(line.text.slice(to, next)) != cat)
        break;
      to = next;
    }
    return EditorSelection.range(from + line.from, to + line.from);
  }
  function getdx(x2, rect) {
    return rect.left > x2 ? rect.left - x2 : Math.max(0, x2 - rect.right);
  }
  function getdy(y2, rect) {
    return rect.top > y2 ? rect.top - y2 : Math.max(0, y2 - rect.bottom);
  }
  function yOverlap(a2, b2) {
    return a2.top < b2.bottom - 1 && a2.bottom > b2.top + 1;
  }
  function upTop(rect, top2) {
    return top2 < rect.top ? { top: top2, left: rect.left, right: rect.right, bottom: rect.bottom } : rect;
  }
  function upBot(rect, bottom) {
    return bottom > rect.bottom ? { top: rect.top, left: rect.left, right: rect.right, bottom } : rect;
  }
  function domPosAtCoords(parent, x2, y2) {
    let closest, closestRect, closestX, closestY, closestOverlap = false;
    let above, below, aboveRect, belowRect;
    for (let child = parent.firstChild; child; child = child.nextSibling) {
      let rects = clientRectsFor(child);
      for (let i2 = 0; i2 < rects.length; i2++) {
        let rect = rects[i2];
        if (closestRect && yOverlap(closestRect, rect))
          rect = upTop(upBot(rect, closestRect.bottom), closestRect.top);
        let dx = getdx(x2, rect), dy = getdy(y2, rect);
        if (dx == 0 && dy == 0)
          return child.nodeType == 3 ? domPosInText(child, x2, y2) : domPosAtCoords(child, x2, y2);
        if (!closest || closestY > dy || closestY == dy && closestX > dx) {
          closest = child;
          closestRect = rect;
          closestX = dx;
          closestY = dy;
          let side = dy ? y2 < rect.top ? -1 : 1 : dx ? x2 < rect.left ? -1 : 1 : 0;
          closestOverlap = !side || (side > 0 ? i2 < rects.length - 1 : i2 > 0);
        }
        if (dx == 0) {
          if (y2 > rect.bottom && (!aboveRect || aboveRect.bottom < rect.bottom)) {
            above = child;
            aboveRect = rect;
          } else if (y2 < rect.top && (!belowRect || belowRect.top > rect.top)) {
            below = child;
            belowRect = rect;
          }
        } else if (aboveRect && yOverlap(aboveRect, rect)) {
          aboveRect = upBot(aboveRect, rect.bottom);
        } else if (belowRect && yOverlap(belowRect, rect)) {
          belowRect = upTop(belowRect, rect.top);
        }
      }
    }
    if (aboveRect && aboveRect.bottom >= y2) {
      closest = above;
      closestRect = aboveRect;
    } else if (belowRect && belowRect.top <= y2) {
      closest = below;
      closestRect = belowRect;
    }
    if (!closest)
      return { node: parent, offset: 0 };
    let clipX = Math.max(closestRect.left, Math.min(closestRect.right, x2));
    if (closest.nodeType == 3)
      return domPosInText(closest, clipX, y2);
    if (closestOverlap && closest.contentEditable != "false")
      return domPosAtCoords(closest, clipX, y2);
    let offset = Array.prototype.indexOf.call(parent.childNodes, closest) + (x2 >= (closestRect.left + closestRect.right) / 2 ? 1 : 0);
    return { node: parent, offset };
  }
  function domPosInText(node, x2, y2) {
    let len = node.nodeValue.length;
    let closestOffset = -1, closestDY = 1e9, generalSide = 0;
    for (let i2 = 0; i2 < len; i2++) {
      let rects = textRange(node, i2, i2 + 1).getClientRects();
      for (let j2 = 0; j2 < rects.length; j2++) {
        let rect = rects[j2];
        if (rect.top == rect.bottom)
          continue;
        if (!generalSide)
          generalSide = x2 - rect.left;
        let dy = (rect.top > y2 ? rect.top - y2 : y2 - rect.bottom) - 1;
        if (rect.left - 1 <= x2 && rect.right + 1 >= x2 && dy < closestDY) {
          let right = x2 >= (rect.left + rect.right) / 2, after = right;
          if (browser.chrome || browser.gecko) {
            let rectBefore = textRange(node, i2).getBoundingClientRect();
            if (rectBefore.left == rect.right)
              after = !right;
          }
          if (dy <= 0)
            return { node, offset: i2 + (after ? 1 : 0) };
          closestOffset = i2 + (after ? 1 : 0);
          closestDY = dy;
        }
      }
    }
    return { node, offset: closestOffset > -1 ? closestOffset : generalSide > 0 ? node.nodeValue.length : 0 };
  }
  function posAtCoords(view, coords, precise, bias = -1) {
    var _a2, _b;
    let content2 = view.contentDOM.getBoundingClientRect(), docTop = content2.top + view.viewState.paddingTop;
    let block, { docHeight } = view.viewState;
    let { x: x2, y: y2 } = coords, yOffset = y2 - docTop;
    if (yOffset < 0)
      return 0;
    if (yOffset > docHeight)
      return view.state.doc.length;
    for (let halfLine = view.viewState.heightOracle.textHeight / 2, bounced = false; ; ) {
      block = view.elementAtHeight(yOffset);
      if (block.type == BlockType.Text)
        break;
      for (; ; ) {
        yOffset = bias > 0 ? block.bottom + halfLine : block.top - halfLine;
        if (yOffset >= 0 && yOffset <= docHeight)
          break;
        if (bounced)
          return precise ? null : 0;
        bounced = true;
        bias = -bias;
      }
    }
    y2 = docTop + yOffset;
    let lineStart = block.from;
    if (lineStart < view.viewport.from)
      return view.viewport.from == 0 ? 0 : precise ? null : posAtCoordsImprecise(view, content2, block, x2, y2);
    if (lineStart > view.viewport.to)
      return view.viewport.to == view.state.doc.length ? view.state.doc.length : precise ? null : posAtCoordsImprecise(view, content2, block, x2, y2);
    let doc2 = view.dom.ownerDocument;
    let root = view.root.elementFromPoint ? view.root : doc2;
    let element = root.elementFromPoint(x2, y2);
    if (element && !view.contentDOM.contains(element))
      element = null;
    if (!element) {
      x2 = Math.max(content2.left + 1, Math.min(content2.right - 1, x2));
      element = root.elementFromPoint(x2, y2);
      if (element && !view.contentDOM.contains(element))
        element = null;
    }
    let node, offset = -1;
    if (element && ((_a2 = view.docView.nearest(element)) === null || _a2 === void 0 ? void 0 : _a2.isEditable) != false) {
      if (doc2.caretPositionFromPoint) {
        let pos = doc2.caretPositionFromPoint(x2, y2);
        if (pos)
          ({ offsetNode: node, offset } = pos);
      } else if (doc2.caretRangeFromPoint) {
        let range2 = doc2.caretRangeFromPoint(x2, y2);
        if (range2) {
          ({ startContainer: node, startOffset: offset } = range2);
          if (!view.contentDOM.contains(node) || browser.safari && isSuspiciousSafariCaretResult(node, offset, x2) || browser.chrome && isSuspiciousChromeCaretResult(node, offset, x2))
            node = void 0;
        }
      }
    }
    if (!node || !view.docView.dom.contains(node)) {
      let line = LineView.find(view.docView, lineStart);
      if (!line)
        return yOffset > block.top + block.height / 2 ? block.to : block.from;
      ({ node, offset } = domPosAtCoords(line.dom, x2, y2));
    }
    let nearest = view.docView.nearest(node);
    if (!nearest)
      return null;
    if (nearest.isWidget && ((_b = nearest.dom) === null || _b === void 0 ? void 0 : _b.nodeType) == 1) {
      let rect = nearest.dom.getBoundingClientRect();
      return coords.y < rect.top || coords.y <= rect.bottom && coords.x <= (rect.left + rect.right) / 2 ? nearest.posAtStart : nearest.posAtEnd;
    } else {
      return nearest.localPosFromDOM(node, offset) + nearest.posAtStart;
    }
  }
  function posAtCoordsImprecise(view, contentRect, block, x2, y2) {
    let into = Math.round((x2 - contentRect.left) * view.defaultCharacterWidth);
    if (view.lineWrapping && block.height > view.defaultLineHeight * 1.5) {
      let textHeight = view.viewState.heightOracle.textHeight;
      let line = Math.floor((y2 - block.top - (view.defaultLineHeight - textHeight) * 0.5) / textHeight);
      into += line * view.viewState.heightOracle.lineLength;
    }
    let content2 = view.state.sliceDoc(block.from, block.to);
    return block.from + findColumn$1(content2, into, view.state.tabSize);
  }
  function isSuspiciousSafariCaretResult(node, offset, x2) {
    let len;
    if (node.nodeType != 3 || offset != (len = node.nodeValue.length))
      return false;
    for (let next = node.nextSibling; next; next = next.nextSibling)
      if (next.nodeType != 1 || next.nodeName != "BR")
        return false;
    return textRange(node, len - 1, len).getBoundingClientRect().left > x2;
  }
  function isSuspiciousChromeCaretResult(node, offset, x2) {
    if (offset != 0)
      return false;
    for (let cur2 = node; ; ) {
      let parent = cur2.parentNode;
      if (!parent || parent.nodeType != 1 || parent.firstChild != cur2)
        return false;
      if (parent.classList.contains("cm-line"))
        break;
      cur2 = parent;
    }
    let rect = node.nodeType == 1 ? node.getBoundingClientRect() : textRange(node, 0, Math.max(node.nodeValue.length, 1)).getBoundingClientRect();
    return x2 - rect.left > 5;
  }
  function blockAt(view, pos) {
    let line = view.lineBlockAt(pos);
    if (Array.isArray(line.type))
      for (let l2 of line.type) {
        if (l2.to > pos || l2.to == pos && (l2.to == line.to || l2.type == BlockType.Text))
          return l2;
      }
    return line;
  }
  function moveToLineBoundary(view, start, forward, includeWrap) {
    let line = blockAt(view, start.head);
    let coords = !includeWrap || line.type != BlockType.Text || !(view.lineWrapping || line.widgetLineBreaks) ? null : view.coordsAtPos(start.assoc < 0 && start.head > line.from ? start.head - 1 : start.head);
    if (coords) {
      let editorRect = view.dom.getBoundingClientRect();
      let direction = view.textDirectionAt(line.from);
      let pos = view.posAtCoords({
        x: forward == (direction == Direction.LTR) ? editorRect.right - 1 : editorRect.left + 1,
        y: (coords.top + coords.bottom) / 2
      });
      if (pos != null)
        return EditorSelection.cursor(pos, forward ? -1 : 1);
    }
    return EditorSelection.cursor(forward ? line.to : line.from, forward ? -1 : 1);
  }
  function moveByChar(view, start, forward, by) {
    let line = view.state.doc.lineAt(start.head), spans = view.bidiSpans(line);
    let direction = view.textDirectionAt(line.from);
    for (let cur2 = start, check = null; ; ) {
      let next = moveVisually(line, spans, direction, cur2, forward), char = movedOver;
      if (!next) {
        if (line.number == (forward ? view.state.doc.lines : 1))
          return cur2;
        char = "\n";
        line = view.state.doc.line(line.number + (forward ? 1 : -1));
        spans = view.bidiSpans(line);
        next = view.visualLineSide(line, !forward);
      }
      if (!check) {
        if (!by)
          return next;
        check = by(char);
      } else if (!check(char)) {
        return cur2;
      }
      cur2 = next;
    }
  }
  function byGroup(view, pos, start) {
    let categorize = view.state.charCategorizer(pos);
    let cat = categorize(start);
    return (next) => {
      let nextCat = categorize(next);
      if (cat == CharCategory.Space)
        cat = nextCat;
      return cat == nextCat;
    };
  }
  function moveVertically(view, start, forward, distance) {
    let startPos = start.head, dir = forward ? 1 : -1;
    if (startPos == (forward ? view.state.doc.length : 0))
      return EditorSelection.cursor(startPos, start.assoc);
    let goal = start.goalColumn, startY;
    let rect = view.contentDOM.getBoundingClientRect();
    let startCoords = view.coordsAtPos(startPos, start.assoc || -1), docTop = view.documentTop;
    if (startCoords) {
      if (goal == null)
        goal = startCoords.left - rect.left;
      startY = dir < 0 ? startCoords.top : startCoords.bottom;
    } else {
      let line = view.viewState.lineBlockAt(startPos);
      if (goal == null)
        goal = Math.min(rect.right - rect.left, view.defaultCharacterWidth * (startPos - line.from));
      startY = (dir < 0 ? line.top : line.bottom) + docTop;
    }
    let resolvedGoal = rect.left + goal;
    let dist2 = distance !== null && distance !== void 0 ? distance : view.viewState.heightOracle.textHeight >> 1;
    for (let extra = 0; ; extra += 10) {
      let curY = startY + (dist2 + extra) * dir;
      let pos = posAtCoords(view, { x: resolvedGoal, y: curY }, false, dir);
      if (curY < rect.top || curY > rect.bottom || (dir < 0 ? pos < startPos : pos > startPos)) {
        let charRect = view.docView.coordsForChar(pos);
        let assoc = !charRect || curY < charRect.top ? -1 : 1;
        return EditorSelection.cursor(pos, assoc, void 0, goal);
      }
    }
  }
  function skipAtomicRanges(atoms, pos, bias) {
    for (; ; ) {
      let moved = 0;
      for (let set2 of atoms) {
        set2.between(pos - 1, pos + 1, (from, to, value) => {
          if (pos > from && pos < to) {
            let side = moved || bias || (pos - from < to - pos ? -1 : 1);
            pos = side < 0 ? from : to;
            moved = side;
          }
        });
      }
      if (!moved)
        return pos;
    }
  }
  function skipAtoms(view, oldPos, pos) {
    let newPos = skipAtomicRanges(view.state.facet(atomicRanges).map((f2) => f2(view)), pos.from, oldPos.head > pos.from ? -1 : 1);
    return newPos == pos.from ? pos : EditorSelection.cursor(newPos, newPos < pos.from ? 1 : -1);
  }
  class InputState {
    setSelectionOrigin(origin) {
      this.lastSelectionOrigin = origin;
      this.lastSelectionTime = Date.now();
    }
    constructor(view) {
      this.view = view;
      this.lastKeyCode = 0;
      this.lastKeyTime = 0;
      this.lastTouchTime = 0;
      this.lastFocusTime = 0;
      this.lastScrollTop = 0;
      this.lastScrollLeft = 0;
      this.pendingIOSKey = void 0;
      this.lastSelectionOrigin = null;
      this.lastSelectionTime = 0;
      this.lastEscPress = 0;
      this.lastContextMenu = 0;
      this.scrollHandlers = [];
      this.handlers = /* @__PURE__ */ Object.create(null);
      this.composing = -1;
      this.compositionFirstChange = null;
      this.compositionEndedAt = 0;
      this.compositionPendingKey = false;
      this.compositionPendingChange = false;
      this.mouseSelection = null;
      this.draggedContent = null;
      this.handleEvent = this.handleEvent.bind(this);
      this.notifiedFocused = view.hasFocus;
      if (browser.safari)
        view.contentDOM.addEventListener("input", () => null);
      if (browser.gecko)
        firefoxCopyCutHack(view.contentDOM.ownerDocument);
    }
    handleEvent(event) {
      if (!eventBelongsToEditor(this.view, event) || this.ignoreDuringComposition(event))
        return;
      if (event.type == "keydown" && this.keydown(event))
        return;
      this.runHandlers(event.type, event);
    }
    runHandlers(type, event) {
      let handlers2 = this.handlers[type];
      if (handlers2) {
        for (let observer of handlers2.observers)
          observer(this.view, event);
        for (let handler of handlers2.handlers) {
          if (event.defaultPrevented)
            break;
          if (handler(this.view, event)) {
            event.preventDefault();
            break;
          }
        }
      }
    }
    ensureHandlers(plugins) {
      let handlers2 = computeHandlers(plugins), prev = this.handlers, dom2 = this.view.contentDOM;
      for (let type in handlers2)
        if (type != "scroll") {
          let passive = !handlers2[type].handlers.length;
          let exists = prev[type];
          if (exists && passive != !exists.handlers.length) {
            dom2.removeEventListener(type, this.handleEvent);
            exists = null;
          }
          if (!exists)
            dom2.addEventListener(type, this.handleEvent, { passive });
        }
      for (let type in prev)
        if (type != "scroll" && !handlers2[type])
          dom2.removeEventListener(type, this.handleEvent);
      this.handlers = handlers2;
    }
    keydown(event) {
      this.lastKeyCode = event.keyCode;
      this.lastKeyTime = Date.now();
      if (event.keyCode == 9 && Date.now() < this.lastEscPress + 2e3)
        return true;
      if (event.keyCode != 27 && modifierCodes.indexOf(event.keyCode) < 0)
        this.view.inputState.lastEscPress = 0;
      if (browser.android && browser.chrome && !event.synthetic && (event.keyCode == 13 || event.keyCode == 8)) {
        this.view.observer.delayAndroidKey(event.key, event.keyCode);
        return true;
      }
      let pending;
      if (browser.ios && !event.synthetic && !event.altKey && !event.metaKey && ((pending = PendingKeys.find((key) => key.keyCode == event.keyCode)) && !event.ctrlKey || EmacsyPendingKeys.indexOf(event.key) > -1 && event.ctrlKey && !event.shiftKey)) {
        this.pendingIOSKey = pending || event;
        setTimeout(() => this.flushIOSKey(), 250);
        return true;
      }
      if (event.keyCode != 229)
        this.view.observer.forceFlush();
      return false;
    }
    flushIOSKey() {
      let key = this.pendingIOSKey;
      if (!key)
        return false;
      this.pendingIOSKey = void 0;
      return dispatchKey(this.view.contentDOM, key.key, key.keyCode);
    }
    ignoreDuringComposition(event) {
      if (!/^key/.test(event.type))
        return false;
      if (this.composing > 0)
        return true;
      if (browser.safari && !browser.ios && this.compositionPendingKey && Date.now() - this.compositionEndedAt < 100) {
        this.compositionPendingKey = false;
        return true;
      }
      return false;
    }
    startMouseSelection(mouseSelection) {
      if (this.mouseSelection)
        this.mouseSelection.destroy();
      this.mouseSelection = mouseSelection;
    }
    update(update) {
      if (this.mouseSelection)
        this.mouseSelection.update(update);
      if (this.draggedContent && update.docChanged)
        this.draggedContent = this.draggedContent.map(update.changes);
      if (update.transactions.length)
        this.lastKeyCode = this.lastSelectionTime = 0;
    }
    destroy() {
      if (this.mouseSelection)
        this.mouseSelection.destroy();
    }
  }
  function bindHandler(plugin, handler) {
    return (view, event) => {
      try {
        return handler.call(plugin, event, view);
      } catch (e2) {
        logException(view.state, e2);
      }
    };
  }
  function computeHandlers(plugins) {
    let result = /* @__PURE__ */ Object.create(null);
    function record(type) {
      return result[type] || (result[type] = { observers: [], handlers: [] });
    }
    for (let plugin of plugins) {
      let spec = plugin.spec;
      if (spec && spec.domEventHandlers)
        for (let type in spec.domEventHandlers) {
          let f2 = spec.domEventHandlers[type];
          if (f2)
            record(type).handlers.push(bindHandler(plugin.value, f2));
        }
      if (spec && spec.domEventObservers)
        for (let type in spec.domEventObservers) {
          let f2 = spec.domEventObservers[type];
          if (f2)
            record(type).observers.push(bindHandler(plugin.value, f2));
        }
    }
    for (let type in handlers)
      record(type).handlers.push(handlers[type]);
    for (let type in observers)
      record(type).observers.push(observers[type]);
    return result;
  }
  const PendingKeys = [
    { key: "Backspace", keyCode: 8, inputType: "deleteContentBackward" },
    { key: "Enter", keyCode: 13, inputType: "insertParagraph" },
    { key: "Enter", keyCode: 13, inputType: "insertLineBreak" },
    { key: "Delete", keyCode: 46, inputType: "deleteContentForward" }
  ];
  const EmacsyPendingKeys = "dthko";
  const modifierCodes = [16, 17, 18, 20, 91, 92, 224, 225];
  const dragScrollMargin = 6;
  function dragScrollSpeed(dist2) {
    return Math.max(0, dist2) * 0.7 + 8;
  }
  function dist(a2, b2) {
    return Math.max(Math.abs(a2.clientX - b2.clientX), Math.abs(a2.clientY - b2.clientY));
  }
  class MouseSelection {
    constructor(view, startEvent, style, mustSelect) {
      this.view = view;
      this.startEvent = startEvent;
      this.style = style;
      this.mustSelect = mustSelect;
      this.scrollSpeed = { x: 0, y: 0 };
      this.scrolling = -1;
      this.lastEvent = startEvent;
      this.scrollParent = scrollableParent(view.contentDOM);
      this.atoms = view.state.facet(atomicRanges).map((f2) => f2(view));
      let doc2 = view.contentDOM.ownerDocument;
      doc2.addEventListener("mousemove", this.move = this.move.bind(this));
      doc2.addEventListener("mouseup", this.up = this.up.bind(this));
      this.extend = startEvent.shiftKey;
      this.multiple = view.state.facet(EditorState.allowMultipleSelections) && addsSelectionRange(view, startEvent);
      this.dragging = isInPrimarySelection(view, startEvent) && getClickType(startEvent) == 1 ? null : false;
    }
    start(event) {
      if (this.dragging === false)
        this.select(event);
    }
    move(event) {
      var _a2;
      if (event.buttons == 0)
        return this.destroy();
      if (this.dragging || this.dragging == null && dist(this.startEvent, event) < 10)
        return;
      this.select(this.lastEvent = event);
      let sx = 0, sy = 0;
      let rect = ((_a2 = this.scrollParent) === null || _a2 === void 0 ? void 0 : _a2.getBoundingClientRect()) || { left: 0, top: 0, right: this.view.win.innerWidth, bottom: this.view.win.innerHeight };
      let margins = getScrollMargins(this.view);
      if (event.clientX - margins.left <= rect.left + dragScrollMargin)
        sx = -dragScrollSpeed(rect.left - event.clientX);
      else if (event.clientX + margins.right >= rect.right - dragScrollMargin)
        sx = dragScrollSpeed(event.clientX - rect.right);
      if (event.clientY - margins.top <= rect.top + dragScrollMargin)
        sy = -dragScrollSpeed(rect.top - event.clientY);
      else if (event.clientY + margins.bottom >= rect.bottom - dragScrollMargin)
        sy = dragScrollSpeed(event.clientY - rect.bottom);
      this.setScrollSpeed(sx, sy);
    }
    up(event) {
      if (this.dragging == null)
        this.select(this.lastEvent);
      if (!this.dragging)
        event.preventDefault();
      this.destroy();
    }
    destroy() {
      this.setScrollSpeed(0, 0);
      let doc2 = this.view.contentDOM.ownerDocument;
      doc2.removeEventListener("mousemove", this.move);
      doc2.removeEventListener("mouseup", this.up);
      this.view.inputState.mouseSelection = this.view.inputState.draggedContent = null;
    }
    setScrollSpeed(sx, sy) {
      this.scrollSpeed = { x: sx, y: sy };
      if (sx || sy) {
        if (this.scrolling < 0)
          this.scrolling = setInterval(() => this.scroll(), 50);
      } else if (this.scrolling > -1) {
        clearInterval(this.scrolling);
        this.scrolling = -1;
      }
    }
    scroll() {
      if (this.scrollParent) {
        this.scrollParent.scrollLeft += this.scrollSpeed.x;
        this.scrollParent.scrollTop += this.scrollSpeed.y;
      } else {
        this.view.win.scrollBy(this.scrollSpeed.x, this.scrollSpeed.y);
      }
      if (this.dragging === false)
        this.select(this.lastEvent);
    }
    skipAtoms(sel) {
      let ranges = null;
      for (let i2 = 0; i2 < sel.ranges.length; i2++) {
        let range2 = sel.ranges[i2], updated = null;
        if (range2.empty) {
          let pos = skipAtomicRanges(this.atoms, range2.from, 0);
          if (pos != range2.from)
            updated = EditorSelection.cursor(pos, -1);
        } else {
          let from = skipAtomicRanges(this.atoms, range2.from, -1);
          let to = skipAtomicRanges(this.atoms, range2.to, 1);
          if (from != range2.from || to != range2.to)
            updated = EditorSelection.range(range2.from == range2.anchor ? from : to, range2.from == range2.head ? from : to);
        }
        if (updated) {
          if (!ranges)
            ranges = sel.ranges.slice();
          ranges[i2] = updated;
        }
      }
      return ranges ? EditorSelection.create(ranges, sel.mainIndex) : sel;
    }
    select(event) {
      let { view } = this, selection = this.skipAtoms(this.style.get(event, this.extend, this.multiple));
      if (this.mustSelect || !selection.eq(view.state.selection, this.dragging === false))
        this.view.dispatch({
          selection,
          userEvent: "select.pointer"
        });
      this.mustSelect = false;
    }
    update(update) {
      if (this.style.update(update))
        setTimeout(() => this.select(this.lastEvent), 20);
    }
  }
  function addsSelectionRange(view, event) {
    let facet = view.state.facet(clickAddsSelectionRange);
    return facet.length ? facet[0](event) : browser.mac ? event.metaKey : event.ctrlKey;
  }
  function dragMovesSelection(view, event) {
    let facet = view.state.facet(dragMovesSelection$1);
    return facet.length ? facet[0](event) : browser.mac ? !event.altKey : !event.ctrlKey;
  }
  function isInPrimarySelection(view, event) {
    let { main } = view.state.selection;
    if (main.empty)
      return false;
    let sel = getSelection(view.root);
    if (!sel || sel.rangeCount == 0)
      return true;
    let rects = sel.getRangeAt(0).getClientRects();
    for (let i2 = 0; i2 < rects.length; i2++) {
      let rect = rects[i2];
      if (rect.left <= event.clientX && rect.right >= event.clientX && rect.top <= event.clientY && rect.bottom >= event.clientY)
        return true;
    }
    return false;
  }
  function eventBelongsToEditor(view, event) {
    if (!event.bubbles)
      return true;
    if (event.defaultPrevented)
      return false;
    for (let node = event.target, cView; node != view.contentDOM; node = node.parentNode)
      if (!node || node.nodeType == 11 || (cView = ContentView.get(node)) && cView.ignoreEvent(event))
        return false;
    return true;
  }
  const handlers = /* @__PURE__ */ Object.create(null);
  const observers = /* @__PURE__ */ Object.create(null);
  const brokenClipboardAPI = browser.ie && browser.ie_version < 15 || browser.ios && browser.webkit_version < 604;
  function capturePaste(view) {
    let parent = view.dom.parentNode;
    if (!parent)
      return;
    let target = parent.appendChild(document.createElement("textarea"));
    target.style.cssText = "position: fixed; left: -10000px; top: 10px";
    target.focus();
    setTimeout(() => {
      view.focus();
      target.remove();
      doPaste(view, target.value);
    }, 50);
  }
  function doPaste(view, input) {
    let { state: state2 } = view, changes, i2 = 1, text = state2.toText(input);
    let byLine = text.lines == state2.selection.ranges.length;
    let linewise = lastLinewiseCopy != null && state2.selection.ranges.every((r2) => r2.empty) && lastLinewiseCopy == text.toString();
    if (linewise) {
      let lastLine = -1;
      changes = state2.changeByRange((range2) => {
        let line = state2.doc.lineAt(range2.from);
        if (line.from == lastLine)
          return { range: range2 };
        lastLine = line.from;
        let insert2 = state2.toText((byLine ? text.line(i2++).text : input) + state2.lineBreak);
        return {
          changes: { from: line.from, insert: insert2 },
          range: EditorSelection.cursor(range2.from + insert2.length)
        };
      });
    } else if (byLine) {
      changes = state2.changeByRange((range2) => {
        let line = text.line(i2++);
        return {
          changes: { from: range2.from, to: range2.to, insert: line.text },
          range: EditorSelection.cursor(range2.from + line.length)
        };
      });
    } else {
      changes = state2.replaceSelection(text);
    }
    view.dispatch(changes, {
      userEvent: "input.paste",
      scrollIntoView: true
    });
  }
  observers.scroll = (view) => {
    view.inputState.lastScrollTop = view.scrollDOM.scrollTop;
    view.inputState.lastScrollLeft = view.scrollDOM.scrollLeft;
  };
  handlers.keydown = (view, event) => {
    view.inputState.setSelectionOrigin("select");
    if (event.keyCode == 27)
      view.inputState.lastEscPress = Date.now();
    return false;
  };
  observers.touchstart = (view, e2) => {
    view.inputState.lastTouchTime = Date.now();
    view.inputState.setSelectionOrigin("select.pointer");
  };
  observers.touchmove = (view) => {
    view.inputState.setSelectionOrigin("select.pointer");
  };
  handlers.mousedown = (view, event) => {
    view.observer.flush();
    if (view.inputState.lastTouchTime > Date.now() - 2e3)
      return false;
    let style = null;
    for (let makeStyle of view.state.facet(mouseSelectionStyle)) {
      style = makeStyle(view, event);
      if (style)
        break;
    }
    if (!style && event.button == 0)
      style = basicMouseSelection(view, event);
    if (style) {
      let mustFocus = !view.hasFocus;
      view.inputState.startMouseSelection(new MouseSelection(view, event, style, mustFocus));
      if (mustFocus)
        view.observer.ignore(() => focusPreventScroll(view.contentDOM));
      let mouseSel = view.inputState.mouseSelection;
      if (mouseSel) {
        mouseSel.start(event);
        return mouseSel.dragging === false;
      }
    }
    return false;
  };
  function rangeForClick(view, pos, bias, type) {
    if (type == 1) {
      return EditorSelection.cursor(pos, bias);
    } else if (type == 2) {
      return groupAt(view.state, pos, bias);
    } else {
      let visual = LineView.find(view.docView, pos), line = view.state.doc.lineAt(visual ? visual.posAtEnd : pos);
      let from = visual ? visual.posAtStart : line.from, to = visual ? visual.posAtEnd : line.to;
      if (to < view.state.doc.length && to == line.to)
        to++;
      return EditorSelection.range(from, to);
    }
  }
  let insideY = (y2, rect) => y2 >= rect.top && y2 <= rect.bottom;
  let inside = (x2, y2, rect) => insideY(y2, rect) && x2 >= rect.left && x2 <= rect.right;
  function findPositionSide(view, pos, x2, y2) {
    let line = LineView.find(view.docView, pos);
    if (!line)
      return 1;
    let off = pos - line.posAtStart;
    if (off == 0)
      return 1;
    if (off == line.length)
      return -1;
    let before = line.coordsAt(off, -1);
    if (before && inside(x2, y2, before))
      return -1;
    let after = line.coordsAt(off, 1);
    if (after && inside(x2, y2, after))
      return 1;
    return before && insideY(y2, before) ? -1 : 1;
  }
  function queryPos(view, event) {
    let pos = view.posAtCoords({ x: event.clientX, y: event.clientY }, false);
    return { pos, bias: findPositionSide(view, pos, event.clientX, event.clientY) };
  }
  const BadMouseDetail = browser.ie && browser.ie_version <= 11;
  let lastMouseDown = null, lastMouseDownCount = 0, lastMouseDownTime = 0;
  function getClickType(event) {
    if (!BadMouseDetail)
      return event.detail;
    let last = lastMouseDown, lastTime = lastMouseDownTime;
    lastMouseDown = event;
    lastMouseDownTime = Date.now();
    return lastMouseDownCount = !last || lastTime > Date.now() - 400 && Math.abs(last.clientX - event.clientX) < 2 && Math.abs(last.clientY - event.clientY) < 2 ? (lastMouseDownCount + 1) % 3 : 1;
  }
  function basicMouseSelection(view, event) {
    let start = queryPos(view, event), type = getClickType(event);
    let startSel = view.state.selection;
    return {
      update(update) {
        if (update.docChanged) {
          start.pos = update.changes.mapPos(start.pos);
          startSel = startSel.map(update.changes);
        }
      },
      get(event2, extend2, multiple) {
        let cur2 = queryPos(view, event2), removed;
        let range2 = rangeForClick(view, cur2.pos, cur2.bias, type);
        if (start.pos != cur2.pos && !extend2) {
          let startRange = rangeForClick(view, start.pos, start.bias, type);
          let from = Math.min(startRange.from, range2.from), to = Math.max(startRange.to, range2.to);
          range2 = from < range2.from ? EditorSelection.range(from, to) : EditorSelection.range(to, from);
        }
        if (extend2)
          return startSel.replaceRange(startSel.main.extend(range2.from, range2.to));
        else if (multiple && type == 1 && startSel.ranges.length > 1 && (removed = removeRangeAround(startSel, cur2.pos)))
          return removed;
        else if (multiple)
          return startSel.addRange(range2);
        else
          return EditorSelection.create([range2]);
      }
    };
  }
  function removeRangeAround(sel, pos) {
    for (let i2 = 0; i2 < sel.ranges.length; i2++) {
      let { from, to } = sel.ranges[i2];
      if (from <= pos && to >= pos)
        return EditorSelection.create(sel.ranges.slice(0, i2).concat(sel.ranges.slice(i2 + 1)), sel.mainIndex == i2 ? 0 : sel.mainIndex - (sel.mainIndex > i2 ? 1 : 0));
    }
    return null;
  }
  handlers.dragstart = (view, event) => {
    let { selection: { main: range2 } } = view.state;
    if (event.target.draggable) {
      let cView = view.docView.nearest(event.target);
      if (cView && cView.isWidget) {
        let from = cView.posAtStart, to = from + cView.length;
        if (from >= range2.to || to <= range2.from)
          range2 = EditorSelection.range(from, to);
      }
    }
    let { inputState } = view;
    if (inputState.mouseSelection)
      inputState.mouseSelection.dragging = true;
    inputState.draggedContent = range2;
    if (event.dataTransfer) {
      event.dataTransfer.setData("Text", view.state.sliceDoc(range2.from, range2.to));
      event.dataTransfer.effectAllowed = "copyMove";
    }
    return false;
  };
  handlers.dragend = (view) => {
    view.inputState.draggedContent = null;
    return false;
  };
  function dropText(view, event, text, direct) {
    if (!text)
      return;
    let dropPos = view.posAtCoords({ x: event.clientX, y: event.clientY }, false);
    let { draggedContent } = view.inputState;
    let del = direct && draggedContent && dragMovesSelection(view, event) ? { from: draggedContent.from, to: draggedContent.to } : null;
    let ins = { from: dropPos, insert: text };
    let changes = view.state.changes(del ? [del, ins] : ins);
    view.focus();
    view.dispatch({
      changes,
      selection: { anchor: changes.mapPos(dropPos, -1), head: changes.mapPos(dropPos, 1) },
      userEvent: del ? "move.drop" : "input.drop"
    });
    view.inputState.draggedContent = null;
  }
  handlers.drop = (view, event) => {
    if (!event.dataTransfer)
      return false;
    if (view.state.readOnly)
      return true;
    let files = event.dataTransfer.files;
    if (files && files.length) {
      let text = Array(files.length), read = 0;
      let finishFile = () => {
        if (++read == files.length)
          dropText(view, event, text.filter((s2) => s2 != null).join(view.state.lineBreak), false);
      };
      for (let i2 = 0; i2 < files.length; i2++) {
        let reader = new FileReader();
        reader.onerror = finishFile;
        reader.onload = () => {
          if (!/[\x00-\x08\x0e-\x1f]{2}/.test(reader.result))
            text[i2] = reader.result;
          finishFile();
        };
        reader.readAsText(files[i2]);
      }
      return true;
    } else {
      let text = event.dataTransfer.getData("Text");
      if (text) {
        dropText(view, event, text, true);
        return true;
      }
    }
    return false;
  };
  handlers.paste = (view, event) => {
    if (view.state.readOnly)
      return true;
    view.observer.flush();
    let data = brokenClipboardAPI ? null : event.clipboardData;
    if (data) {
      doPaste(view, data.getData("text/plain") || data.getData("text/uri-text"));
      return true;
    } else {
      capturePaste(view);
      return false;
    }
  };
  function captureCopy(view, text) {
    let parent = view.dom.parentNode;
    if (!parent)
      return;
    let target = parent.appendChild(document.createElement("textarea"));
    target.style.cssText = "position: fixed; left: -10000px; top: 10px";
    target.value = text;
    target.focus();
    target.selectionEnd = text.length;
    target.selectionStart = 0;
    setTimeout(() => {
      target.remove();
      view.focus();
    }, 50);
  }
  function copiedRange(state2) {
    let content2 = [], ranges = [], linewise = false;
    for (let range2 of state2.selection.ranges)
      if (!range2.empty) {
        content2.push(state2.sliceDoc(range2.from, range2.to));
        ranges.push(range2);
      }
    if (!content2.length) {
      let upto = -1;
      for (let { from } of state2.selection.ranges) {
        let line = state2.doc.lineAt(from);
        if (line.number > upto) {
          content2.push(line.text);
          ranges.push({ from: line.from, to: Math.min(state2.doc.length, line.to + 1) });
        }
        upto = line.number;
      }
      linewise = true;
    }
    return { text: content2.join(state2.lineBreak), ranges, linewise };
  }
  let lastLinewiseCopy = null;
  handlers.copy = handlers.cut = (view, event) => {
    let { text, ranges, linewise } = copiedRange(view.state);
    if (!text && !linewise)
      return false;
    lastLinewiseCopy = linewise ? text : null;
    if (event.type == "cut" && !view.state.readOnly)
      view.dispatch({
        changes: ranges,
        scrollIntoView: true,
        userEvent: "delete.cut"
      });
    let data = brokenClipboardAPI ? null : event.clipboardData;
    if (data) {
      data.clearData();
      data.setData("text/plain", text);
      return true;
    } else {
      captureCopy(view, text);
      return false;
    }
  };
  const isFocusChange = /* @__PURE__ */ Annotation.define();
  function focusChangeTransaction(state2, focus) {
    let effects = [];
    for (let getEffect of state2.facet(focusChangeEffect)) {
      let effect2 = getEffect(state2, focus);
      if (effect2)
        effects.push(effect2);
    }
    return effects ? state2.update({ effects, annotations: isFocusChange.of(true) }) : null;
  }
  function updateForFocusChange(view) {
    setTimeout(() => {
      let focus = view.hasFocus;
      if (focus != view.inputState.notifiedFocused) {
        let tr = focusChangeTransaction(view.state, focus);
        if (tr)
          view.dispatch(tr);
        else
          view.update([]);
      }
    }, 10);
  }
  observers.focus = (view) => {
    view.inputState.lastFocusTime = Date.now();
    if (!view.scrollDOM.scrollTop && (view.inputState.lastScrollTop || view.inputState.lastScrollLeft)) {
      view.scrollDOM.scrollTop = view.inputState.lastScrollTop;
      view.scrollDOM.scrollLeft = view.inputState.lastScrollLeft;
    }
    updateForFocusChange(view);
  };
  observers.blur = (view) => {
    view.observer.clearSelectionRange();
    updateForFocusChange(view);
  };
  observers.compositionstart = observers.compositionupdate = (view) => {
    if (view.inputState.compositionFirstChange == null)
      view.inputState.compositionFirstChange = true;
    if (view.inputState.composing < 0) {
      view.inputState.composing = 0;
    }
  };
  observers.compositionend = (view) => {
    view.inputState.composing = -1;
    view.inputState.compositionEndedAt = Date.now();
    view.inputState.compositionPendingKey = true;
    view.inputState.compositionPendingChange = view.observer.pendingRecords().length > 0;
    view.inputState.compositionFirstChange = null;
    if (browser.chrome && browser.android) {
      view.observer.flushSoon();
    } else if (view.inputState.compositionPendingChange) {
      Promise.resolve().then(() => view.observer.flush());
    } else {
      setTimeout(() => {
        if (view.inputState.composing < 0 && view.docView.hasComposition)
          view.update([]);
      }, 50);
    }
  };
  observers.contextmenu = (view) => {
    view.inputState.lastContextMenu = Date.now();
  };
  handlers.beforeinput = (view, event) => {
    var _a2;
    let pending;
    if (browser.chrome && browser.android && (pending = PendingKeys.find((key) => key.inputType == event.inputType))) {
      view.observer.delayAndroidKey(pending.key, pending.keyCode);
      if (pending.key == "Backspace" || pending.key == "Delete") {
        let startViewHeight = ((_a2 = window.visualViewport) === null || _a2 === void 0 ? void 0 : _a2.height) || 0;
        setTimeout(() => {
          var _a3;
          if ((((_a3 = window.visualViewport) === null || _a3 === void 0 ? void 0 : _a3.height) || 0) > startViewHeight + 10 && view.hasFocus) {
            view.contentDOM.blur();
            view.focus();
          }
        }, 100);
      }
    }
    return false;
  };
  const appliedFirefoxHack = /* @__PURE__ */ new Set();
  function firefoxCopyCutHack(doc2) {
    if (!appliedFirefoxHack.has(doc2)) {
      appliedFirefoxHack.add(doc2);
      doc2.addEventListener("copy", () => {
      });
      doc2.addEventListener("cut", () => {
      });
    }
  }
  const wrappingWhiteSpace = ["pre-wrap", "normal", "pre-line", "break-spaces"];
  class HeightOracle {
    constructor(lineWrapping) {
      this.lineWrapping = lineWrapping;
      this.doc = Text$1.empty;
      this.heightSamples = {};
      this.lineHeight = 14;
      this.charWidth = 7;
      this.textHeight = 14;
      this.lineLength = 30;
      this.heightChanged = false;
    }
    heightForGap(from, to) {
      let lines = this.doc.lineAt(to).number - this.doc.lineAt(from).number + 1;
      if (this.lineWrapping)
        lines += Math.max(0, Math.ceil((to - from - lines * this.lineLength * 0.5) / this.lineLength));
      return this.lineHeight * lines;
    }
    heightForLine(length) {
      if (!this.lineWrapping)
        return this.lineHeight;
      let lines = 1 + Math.max(0, Math.ceil((length - this.lineLength) / (this.lineLength - 5)));
      return lines * this.lineHeight;
    }
    setDoc(doc2) {
      this.doc = doc2;
      return this;
    }
    mustRefreshForWrapping(whiteSpace) {
      return wrappingWhiteSpace.indexOf(whiteSpace) > -1 != this.lineWrapping;
    }
    mustRefreshForHeights(lineHeights) {
      let newHeight = false;
      for (let i2 = 0; i2 < lineHeights.length; i2++) {
        let h2 = lineHeights[i2];
        if (h2 < 0) {
          i2++;
        } else if (!this.heightSamples[Math.floor(h2 * 10)]) {
          newHeight = true;
          this.heightSamples[Math.floor(h2 * 10)] = true;
        }
      }
      return newHeight;
    }
    refresh(whiteSpace, lineHeight, charWidth, textHeight, lineLength, knownHeights) {
      let lineWrapping = wrappingWhiteSpace.indexOf(whiteSpace) > -1;
      let changed = Math.round(lineHeight) != Math.round(this.lineHeight) || this.lineWrapping != lineWrapping;
      this.lineWrapping = lineWrapping;
      this.lineHeight = lineHeight;
      this.charWidth = charWidth;
      this.textHeight = textHeight;
      this.lineLength = lineLength;
      if (changed) {
        this.heightSamples = {};
        for (let i2 = 0; i2 < knownHeights.length; i2++) {
          let h2 = knownHeights[i2];
          if (h2 < 0)
            i2++;
          else
            this.heightSamples[Math.floor(h2 * 10)] = true;
        }
      }
      return changed;
    }
  }
  class MeasuredHeights {
    constructor(from, heights) {
      this.from = from;
      this.heights = heights;
      this.index = 0;
    }
    get more() {
      return this.index < this.heights.length;
    }
  }
  class BlockInfo {
    /**
    @internal
    */
    constructor(from, length, top2, height, _content) {
      this.from = from;
      this.length = length;
      this.top = top2;
      this.height = height;
      this._content = _content;
    }
    /**
    The type of element this is. When querying lines, this may be
    an array of all the blocks that make up the line.
    */
    get type() {
      return typeof this._content == "number" ? BlockType.Text : Array.isArray(this._content) ? this._content : this._content.type;
    }
    /**
    The end of the element as a document position.
    */
    get to() {
      return this.from + this.length;
    }
    /**
    The bottom position of the element.
    */
    get bottom() {
      return this.top + this.height;
    }
    /**
    If this is a widget block, this will return the widget
    associated with it.
    */
    get widget() {
      return this._content instanceof PointDecoration ? this._content.widget : null;
    }
    /**
    If this is a textblock, this holds the number of line breaks
    that appear in widgets inside the block.
    */
    get widgetLineBreaks() {
      return typeof this._content == "number" ? this._content : 0;
    }
    /**
    @internal
    */
    join(other) {
      let content2 = (Array.isArray(this._content) ? this._content : [this]).concat(Array.isArray(other._content) ? other._content : [other]);
      return new BlockInfo(this.from, this.length + other.length, this.top, this.height + other.height, content2);
    }
  }
  var QueryType = /* @__PURE__ */ function(QueryType2) {
    QueryType2[QueryType2["ByPos"] = 0] = "ByPos";
    QueryType2[QueryType2["ByHeight"] = 1] = "ByHeight";
    QueryType2[QueryType2["ByPosNoHeight"] = 2] = "ByPosNoHeight";
    return QueryType2;
  }(QueryType || (QueryType = {}));
  const Epsilon = 1e-3;
  class HeightMap {
    constructor(length, height, flags = 2) {
      this.length = length;
      this.height = height;
      this.flags = flags;
    }
    get outdated() {
      return (this.flags & 2) > 0;
    }
    set outdated(value) {
      this.flags = (value ? 2 : 0) | this.flags & ~2;
    }
    setHeight(oracle, height) {
      if (this.height != height) {
        if (Math.abs(this.height - height) > Epsilon)
          oracle.heightChanged = true;
        this.height = height;
      }
    }
    // Base case is to replace a leaf node, which simply builds a tree
    // from the new nodes and returns that (HeightMapBranch and
    // HeightMapGap override this to actually use from/to)
    replace(_from, _to, nodes) {
      return HeightMap.of(nodes);
    }
    // Again, these are base cases, and are overridden for branch and gap nodes.
    decomposeLeft(_to, result) {
      result.push(this);
    }
    decomposeRight(_from, result) {
      result.push(this);
    }
    applyChanges(decorations2, oldDoc, oracle, changes) {
      let me2 = this, doc2 = oracle.doc;
      for (let i2 = changes.length - 1; i2 >= 0; i2--) {
        let { fromA, toA, fromB, toB } = changes[i2];
        let start = me2.lineAt(fromA, QueryType.ByPosNoHeight, oracle.setDoc(oldDoc), 0, 0);
        let end = start.to >= toA ? start : me2.lineAt(toA, QueryType.ByPosNoHeight, oracle, 0, 0);
        toB += end.to - toA;
        toA = end.to;
        while (i2 > 0 && start.from <= changes[i2 - 1].toA) {
          fromA = changes[i2 - 1].fromA;
          fromB = changes[i2 - 1].fromB;
          i2--;
          if (fromA < start.from)
            start = me2.lineAt(fromA, QueryType.ByPosNoHeight, oracle, 0, 0);
        }
        fromB += start.from - fromA;
        fromA = start.from;
        let nodes = NodeBuilder.build(oracle.setDoc(doc2), decorations2, fromB, toB);
        me2 = me2.replace(fromA, toA, nodes);
      }
      return me2.updateHeight(oracle, 0);
    }
    static empty() {
      return new HeightMapText(0, 0);
    }
    // nodes uses null values to indicate the position of line breaks.
    // There are never line breaks at the start or end of the array, or
    // two line breaks next to each other, and the array isn't allowed
    // to be empty (same restrictions as return value from the builder).
    static of(nodes) {
      if (nodes.length == 1)
        return nodes[0];
      let i2 = 0, j2 = nodes.length, before = 0, after = 0;
      for (; ; ) {
        if (i2 == j2) {
          if (before > after * 2) {
            let split2 = nodes[i2 - 1];
            if (split2.break)
              nodes.splice(--i2, 1, split2.left, null, split2.right);
            else
              nodes.splice(--i2, 1, split2.left, split2.right);
            j2 += 1 + split2.break;
            before -= split2.size;
          } else if (after > before * 2) {
            let split2 = nodes[j2];
            if (split2.break)
              nodes.splice(j2, 1, split2.left, null, split2.right);
            else
              nodes.splice(j2, 1, split2.left, split2.right);
            j2 += 2 + split2.break;
            after -= split2.size;
          } else {
            break;
          }
        } else if (before < after) {
          let next = nodes[i2++];
          if (next)
            before += next.size;
        } else {
          let next = nodes[--j2];
          if (next)
            after += next.size;
        }
      }
      let brk = 0;
      if (nodes[i2 - 1] == null) {
        brk = 1;
        i2--;
      } else if (nodes[i2] == null) {
        brk = 1;
        j2++;
      }
      return new HeightMapBranch(HeightMap.of(nodes.slice(0, i2)), brk, HeightMap.of(nodes.slice(j2)));
    }
  }
  HeightMap.prototype.size = 1;
  class HeightMapBlock extends HeightMap {
    constructor(length, height, deco) {
      super(length, height);
      this.deco = deco;
    }
    blockAt(_height, _oracle, top2, offset) {
      return new BlockInfo(offset, this.length, top2, this.height, this.deco || 0);
    }
    lineAt(_value, _type, oracle, top2, offset) {
      return this.blockAt(0, oracle, top2, offset);
    }
    forEachLine(from, to, oracle, top2, offset, f2) {
      if (from <= offset + this.length && to >= offset)
        f2(this.blockAt(0, oracle, top2, offset));
    }
    updateHeight(oracle, offset = 0, _force = false, measured) {
      if (measured && measured.from <= offset && measured.more)
        this.setHeight(oracle, measured.heights[measured.index++]);
      this.outdated = false;
      return this;
    }
    toString() {
      return `block(${this.length})`;
    }
  }
  class HeightMapText extends HeightMapBlock {
    constructor(length, height) {
      super(length, height, null);
      this.collapsed = 0;
      this.widgetHeight = 0;
      this.breaks = 0;
    }
    blockAt(_height, _oracle, top2, offset) {
      return new BlockInfo(offset, this.length, top2, this.height, this.breaks);
    }
    replace(_from, _to, nodes) {
      let node = nodes[0];
      if (nodes.length == 1 && (node instanceof HeightMapText || node instanceof HeightMapGap && node.flags & 4) && Math.abs(this.length - node.length) < 10) {
        if (node instanceof HeightMapGap)
          node = new HeightMapText(node.length, this.height);
        else
          node.height = this.height;
        if (!this.outdated)
          node.outdated = false;
        return node;
      } else {
        return HeightMap.of(nodes);
      }
    }
    updateHeight(oracle, offset = 0, force = false, measured) {
      if (measured && measured.from <= offset && measured.more)
        this.setHeight(oracle, measured.heights[measured.index++]);
      else if (force || this.outdated)
        this.setHeight(oracle, Math.max(this.widgetHeight, oracle.heightForLine(this.length - this.collapsed)) + this.breaks * oracle.lineHeight);
      this.outdated = false;
      return this;
    }
    toString() {
      return `line(${this.length}${this.collapsed ? -this.collapsed : ""}${this.widgetHeight ? ":" + this.widgetHeight : ""})`;
    }
  }
  class HeightMapGap extends HeightMap {
    constructor(length) {
      super(length, 0);
    }
    heightMetrics(oracle, offset) {
      let firstLine = oracle.doc.lineAt(offset).number, lastLine = oracle.doc.lineAt(offset + this.length).number;
      let lines = lastLine - firstLine + 1;
      let perLine, perChar = 0;
      if (oracle.lineWrapping) {
        let totalPerLine = Math.min(this.height, oracle.lineHeight * lines);
        perLine = totalPerLine / lines;
        if (this.length > lines + 1)
          perChar = (this.height - totalPerLine) / (this.length - lines - 1);
      } else {
        perLine = this.height / lines;
      }
      return { firstLine, lastLine, perLine, perChar };
    }
    blockAt(height, oracle, top2, offset) {
      let { firstLine, lastLine, perLine, perChar } = this.heightMetrics(oracle, offset);
      if (oracle.lineWrapping) {
        let guess = offset + Math.round(Math.max(0, Math.min(1, (height - top2) / this.height)) * this.length);
        let line = oracle.doc.lineAt(guess), lineHeight = perLine + line.length * perChar;
        let lineTop = Math.max(top2, height - lineHeight / 2);
        return new BlockInfo(line.from, line.length, lineTop, lineHeight, 0);
      } else {
        let line = Math.max(0, Math.min(lastLine - firstLine, Math.floor((height - top2) / perLine)));
        let { from, length } = oracle.doc.line(firstLine + line);
        return new BlockInfo(from, length, top2 + perLine * line, perLine, 0);
      }
    }
    lineAt(value, type, oracle, top2, offset) {
      if (type == QueryType.ByHeight)
        return this.blockAt(value, oracle, top2, offset);
      if (type == QueryType.ByPosNoHeight) {
        let { from, to } = oracle.doc.lineAt(value);
        return new BlockInfo(from, to - from, 0, 0, 0);
      }
      let { firstLine, perLine, perChar } = this.heightMetrics(oracle, offset);
      let line = oracle.doc.lineAt(value), lineHeight = perLine + line.length * perChar;
      let linesAbove = line.number - firstLine;
      let lineTop = top2 + perLine * linesAbove + perChar * (line.from - offset - linesAbove);
      return new BlockInfo(line.from, line.length, Math.max(top2, Math.min(lineTop, top2 + this.height - lineHeight)), lineHeight, 0);
    }
    forEachLine(from, to, oracle, top2, offset, f2) {
      from = Math.max(from, offset);
      to = Math.min(to, offset + this.length);
      let { firstLine, perLine, perChar } = this.heightMetrics(oracle, offset);
      for (let pos = from, lineTop = top2; pos <= to; ) {
        let line = oracle.doc.lineAt(pos);
        if (pos == from) {
          let linesAbove = line.number - firstLine;
          lineTop += perLine * linesAbove + perChar * (from - offset - linesAbove);
        }
        let lineHeight = perLine + perChar * line.length;
        f2(new BlockInfo(line.from, line.length, lineTop, lineHeight, 0));
        lineTop += lineHeight;
        pos = line.to + 1;
      }
    }
    replace(from, to, nodes) {
      let after = this.length - to;
      if (after > 0) {
        let last = nodes[nodes.length - 1];
        if (last instanceof HeightMapGap)
          nodes[nodes.length - 1] = new HeightMapGap(last.length + after);
        else
          nodes.push(null, new HeightMapGap(after - 1));
      }
      if (from > 0) {
        let first = nodes[0];
        if (first instanceof HeightMapGap)
          nodes[0] = new HeightMapGap(from + first.length);
        else
          nodes.unshift(new HeightMapGap(from - 1), null);
      }
      return HeightMap.of(nodes);
    }
    decomposeLeft(to, result) {
      result.push(new HeightMapGap(to - 1), null);
    }
    decomposeRight(from, result) {
      result.push(null, new HeightMapGap(this.length - from - 1));
    }
    updateHeight(oracle, offset = 0, force = false, measured) {
      let end = offset + this.length;
      if (measured && measured.from <= offset + this.length && measured.more) {
        let nodes = [], pos = Math.max(offset, measured.from), singleHeight = -1;
        if (measured.from > offset)
          nodes.push(new HeightMapGap(measured.from - offset - 1).updateHeight(oracle, offset));
        while (pos <= end && measured.more) {
          let len = oracle.doc.lineAt(pos).length;
          if (nodes.length)
            nodes.push(null);
          let height = measured.heights[measured.index++];
          if (singleHeight == -1)
            singleHeight = height;
          else if (Math.abs(height - singleHeight) >= Epsilon)
            singleHeight = -2;
          let line = new HeightMapText(len, height);
          line.outdated = false;
          nodes.push(line);
          pos += len + 1;
        }
        if (pos <= end)
          nodes.push(null, new HeightMapGap(end - pos).updateHeight(oracle, pos));
        let result = HeightMap.of(nodes);
        if (singleHeight < 0 || Math.abs(result.height - this.height) >= Epsilon || Math.abs(singleHeight - this.heightMetrics(oracle, offset).perLine) >= Epsilon)
          oracle.heightChanged = true;
        return result;
      } else if (force || this.outdated) {
        this.setHeight(oracle, oracle.heightForGap(offset, offset + this.length));
        this.outdated = false;
      }
      return this;
    }
    toString() {
      return `gap(${this.length})`;
    }
  }
  class HeightMapBranch extends HeightMap {
    constructor(left, brk, right) {
      super(left.length + brk + right.length, left.height + right.height, brk | (left.outdated || right.outdated ? 2 : 0));
      this.left = left;
      this.right = right;
      this.size = left.size + right.size;
    }
    get break() {
      return this.flags & 1;
    }
    blockAt(height, oracle, top2, offset) {
      let mid = top2 + this.left.height;
      return height < mid ? this.left.blockAt(height, oracle, top2, offset) : this.right.blockAt(height, oracle, mid, offset + this.left.length + this.break);
    }
    lineAt(value, type, oracle, top2, offset) {
      let rightTop = top2 + this.left.height, rightOffset = offset + this.left.length + this.break;
      let left = type == QueryType.ByHeight ? value < rightTop : value < rightOffset;
      let base2 = left ? this.left.lineAt(value, type, oracle, top2, offset) : this.right.lineAt(value, type, oracle, rightTop, rightOffset);
      if (this.break || (left ? base2.to < rightOffset : base2.from > rightOffset))
        return base2;
      let subQuery = type == QueryType.ByPosNoHeight ? QueryType.ByPosNoHeight : QueryType.ByPos;
      if (left)
        return base2.join(this.right.lineAt(rightOffset, subQuery, oracle, rightTop, rightOffset));
      else
        return this.left.lineAt(rightOffset, subQuery, oracle, top2, offset).join(base2);
    }
    forEachLine(from, to, oracle, top2, offset, f2) {
      let rightTop = top2 + this.left.height, rightOffset = offset + this.left.length + this.break;
      if (this.break) {
        if (from < rightOffset)
          this.left.forEachLine(from, to, oracle, top2, offset, f2);
        if (to >= rightOffset)
          this.right.forEachLine(from, to, oracle, rightTop, rightOffset, f2);
      } else {
        let mid = this.lineAt(rightOffset, QueryType.ByPos, oracle, top2, offset);
        if (from < mid.from)
          this.left.forEachLine(from, mid.from - 1, oracle, top2, offset, f2);
        if (mid.to >= from && mid.from <= to)
          f2(mid);
        if (to > mid.to)
          this.right.forEachLine(mid.to + 1, to, oracle, rightTop, rightOffset, f2);
      }
    }
    replace(from, to, nodes) {
      let rightStart = this.left.length + this.break;
      if (to < rightStart)
        return this.balanced(this.left.replace(from, to, nodes), this.right);
      if (from > this.left.length)
        return this.balanced(this.left, this.right.replace(from - rightStart, to - rightStart, nodes));
      let result = [];
      if (from > 0)
        this.decomposeLeft(from, result);
      let left = result.length;
      for (let node of nodes)
        result.push(node);
      if (from > 0)
        mergeGaps(result, left - 1);
      if (to < this.length) {
        let right = result.length;
        this.decomposeRight(to, result);
        mergeGaps(result, right);
      }
      return HeightMap.of(result);
    }
    decomposeLeft(to, result) {
      let left = this.left.length;
      if (to <= left)
        return this.left.decomposeLeft(to, result);
      result.push(this.left);
      if (this.break) {
        left++;
        if (to >= left)
          result.push(null);
      }
      if (to > left)
        this.right.decomposeLeft(to - left, result);
    }
    decomposeRight(from, result) {
      let left = this.left.length, right = left + this.break;
      if (from >= right)
        return this.right.decomposeRight(from - right, result);
      if (from < left)
        this.left.decomposeRight(from, result);
      if (this.break && from < right)
        result.push(null);
      result.push(this.right);
    }
    balanced(left, right) {
      if (left.size > 2 * right.size || right.size > 2 * left.size)
        return HeightMap.of(this.break ? [left, null, right] : [left, right]);
      this.left = left;
      this.right = right;
      this.height = left.height + right.height;
      this.outdated = left.outdated || right.outdated;
      this.size = left.size + right.size;
      this.length = left.length + this.break + right.length;
      return this;
    }
    updateHeight(oracle, offset = 0, force = false, measured) {
      let { left, right } = this, rightStart = offset + left.length + this.break, rebalance = null;
      if (measured && measured.from <= offset + left.length && measured.more)
        rebalance = left = left.updateHeight(oracle, offset, force, measured);
      else
        left.updateHeight(oracle, offset, force);
      if (measured && measured.from <= rightStart + right.length && measured.more)
        rebalance = right = right.updateHeight(oracle, rightStart, force, measured);
      else
        right.updateHeight(oracle, rightStart, force);
      if (rebalance)
        return this.balanced(left, right);
      this.height = this.left.height + this.right.height;
      this.outdated = false;
      return this;
    }
    toString() {
      return this.left + (this.break ? " " : "-") + this.right;
    }
  }
  function mergeGaps(nodes, around) {
    let before, after;
    if (nodes[around] == null && (before = nodes[around - 1]) instanceof HeightMapGap && (after = nodes[around + 1]) instanceof HeightMapGap)
      nodes.splice(around - 1, 3, new HeightMapGap(before.length + 1 + after.length));
  }
  const relevantWidgetHeight = 5;
  class NodeBuilder {
    constructor(pos, oracle) {
      this.pos = pos;
      this.oracle = oracle;
      this.nodes = [];
      this.lineStart = -1;
      this.lineEnd = -1;
      this.covering = null;
      this.writtenTo = pos;
    }
    get isCovered() {
      return this.covering && this.nodes[this.nodes.length - 1] == this.covering;
    }
    span(_from, to) {
      if (this.lineStart > -1) {
        let end = Math.min(to, this.lineEnd), last = this.nodes[this.nodes.length - 1];
        if (last instanceof HeightMapText)
          last.length += end - this.pos;
        else if (end > this.pos || !this.isCovered)
          this.nodes.push(new HeightMapText(end - this.pos, -1));
        this.writtenTo = end;
        if (to > end) {
          this.nodes.push(null);
          this.writtenTo++;
          this.lineStart = -1;
        }
      }
      this.pos = to;
    }
    point(from, to, deco) {
      if (from < to || deco.heightRelevant) {
        let height = deco.widget ? deco.widget.estimatedHeight : 0;
        let breaks = deco.widget ? deco.widget.lineBreaks : 0;
        if (height < 0)
          height = this.oracle.lineHeight;
        let len = to - from;
        if (deco.block) {
          this.addBlock(new HeightMapBlock(len, height, deco));
        } else if (len || breaks || height >= relevantWidgetHeight) {
          this.addLineDeco(height, breaks, len);
        }
      } else if (to > from) {
        this.span(from, to);
      }
      if (this.lineEnd > -1 && this.lineEnd < this.pos)
        this.lineEnd = this.oracle.doc.lineAt(this.pos).to;
    }
    enterLine() {
      if (this.lineStart > -1)
        return;
      let { from, to } = this.oracle.doc.lineAt(this.pos);
      this.lineStart = from;
      this.lineEnd = to;
      if (this.writtenTo < from) {
        if (this.writtenTo < from - 1 || this.nodes[this.nodes.length - 1] == null)
          this.nodes.push(this.blankContent(this.writtenTo, from - 1));
        this.nodes.push(null);
      }
      if (this.pos > from)
        this.nodes.push(new HeightMapText(this.pos - from, -1));
      this.writtenTo = this.pos;
    }
    blankContent(from, to) {
      let gap = new HeightMapGap(to - from);
      if (this.oracle.doc.lineAt(from).to == to)
        gap.flags |= 4;
      return gap;
    }
    ensureLine() {
      this.enterLine();
      let last = this.nodes.length ? this.nodes[this.nodes.length - 1] : null;
      if (last instanceof HeightMapText)
        return last;
      let line = new HeightMapText(0, -1);
      this.nodes.push(line);
      return line;
    }
    addBlock(block) {
      this.enterLine();
      let deco = block.deco;
      if (deco && deco.startSide > 0 && !this.isCovered)
        this.ensureLine();
      this.nodes.push(block);
      this.writtenTo = this.pos = this.pos + block.length;
      if (deco && deco.endSide > 0)
        this.covering = block;
    }
    addLineDeco(height, breaks, length) {
      let line = this.ensureLine();
      line.length += length;
      line.collapsed += length;
      line.widgetHeight = Math.max(line.widgetHeight, height);
      line.breaks += breaks;
      this.writtenTo = this.pos = this.pos + length;
    }
    finish(from) {
      let last = this.nodes.length == 0 ? null : this.nodes[this.nodes.length - 1];
      if (this.lineStart > -1 && !(last instanceof HeightMapText) && !this.isCovered)
        this.nodes.push(new HeightMapText(0, -1));
      else if (this.writtenTo < this.pos || last == null)
        this.nodes.push(this.blankContent(this.writtenTo, this.pos));
      let pos = from;
      for (let node of this.nodes) {
        if (node instanceof HeightMapText)
          node.updateHeight(this.oracle, pos);
        pos += node ? node.length : 1;
      }
      return this.nodes;
    }
    // Always called with a region that on both sides either stretches
    // to a line break or the end of the document.
    // The returned array uses null to indicate line breaks, but never
    // starts or ends in a line break, or has multiple line breaks next
    // to each other.
    static build(oracle, decorations2, from, to) {
      let builder = new NodeBuilder(from, oracle);
      RangeSet.spans(decorations2, from, to, builder, 0);
      return builder.finish(from);
    }
  }
  function heightRelevantDecoChanges(a2, b2, diff) {
    let comp = new DecorationComparator2();
    RangeSet.compare(a2, b2, diff, comp, 0);
    return comp.changes;
  }
  class DecorationComparator2 {
    constructor() {
      this.changes = [];
    }
    compareRange() {
    }
    comparePoint(from, to, a2, b2) {
      if (from < to || a2 && a2.heightRelevant || b2 && b2.heightRelevant)
        addRange(from, to, this.changes, 5);
    }
  }
  function visiblePixelRange(dom2, paddingTop) {
    let rect = dom2.getBoundingClientRect();
    let doc2 = dom2.ownerDocument, win = doc2.defaultView || window;
    let left = Math.max(0, rect.left), right = Math.min(win.innerWidth, rect.right);
    let top2 = Math.max(0, rect.top), bottom = Math.min(win.innerHeight, rect.bottom);
    for (let parent = dom2.parentNode; parent && parent != doc2.body; ) {
      if (parent.nodeType == 1) {
        let elt = parent;
        let style = window.getComputedStyle(elt);
        if ((elt.scrollHeight > elt.clientHeight || elt.scrollWidth > elt.clientWidth) && style.overflow != "visible") {
          let parentRect = elt.getBoundingClientRect();
          left = Math.max(left, parentRect.left);
          right = Math.min(right, parentRect.right);
          top2 = Math.max(top2, parentRect.top);
          bottom = parent == dom2.parentNode ? parentRect.bottom : Math.min(bottom, parentRect.bottom);
        }
        parent = style.position == "absolute" || style.position == "fixed" ? elt.offsetParent : elt.parentNode;
      } else if (parent.nodeType == 11) {
        parent = parent.host;
      } else {
        break;
      }
    }
    return {
      left: left - rect.left,
      right: Math.max(left, right) - rect.left,
      top: top2 - (rect.top + paddingTop),
      bottom: Math.max(top2, bottom) - (rect.top + paddingTop)
    };
  }
  function fullPixelRange(dom2, paddingTop) {
    let rect = dom2.getBoundingClientRect();
    return {
      left: 0,
      right: rect.right - rect.left,
      top: paddingTop,
      bottom: rect.bottom - (rect.top + paddingTop)
    };
  }
  class LineGap {
    constructor(from, to, size2) {
      this.from = from;
      this.to = to;
      this.size = size2;
    }
    static same(a2, b2) {
      if (a2.length != b2.length)
        return false;
      for (let i2 = 0; i2 < a2.length; i2++) {
        let gA = a2[i2], gB = b2[i2];
        if (gA.from != gB.from || gA.to != gB.to || gA.size != gB.size)
          return false;
      }
      return true;
    }
    draw(viewState, wrapping) {
      return Decoration.replace({
        widget: new LineGapWidget(this.size * (wrapping ? viewState.scaleY : viewState.scaleX), wrapping)
      }).range(this.from, this.to);
    }
  }
  class LineGapWidget extends WidgetType {
    constructor(size2, vertical) {
      super();
      this.size = size2;
      this.vertical = vertical;
    }
    eq(other) {
      return other.size == this.size && other.vertical == this.vertical;
    }
    toDOM() {
      let elt = document.createElement("div");
      if (this.vertical) {
        elt.style.height = this.size + "px";
      } else {
        elt.style.width = this.size + "px";
        elt.style.height = "2px";
        elt.style.display = "inline-block";
      }
      return elt;
    }
    get estimatedHeight() {
      return this.vertical ? this.size : -1;
    }
  }
  class ViewState {
    constructor(state2) {
      this.state = state2;
      this.pixelViewport = { left: 0, right: window.innerWidth, top: 0, bottom: 0 };
      this.inView = true;
      this.paddingTop = 0;
      this.paddingBottom = 0;
      this.contentDOMWidth = 0;
      this.contentDOMHeight = 0;
      this.editorHeight = 0;
      this.editorWidth = 0;
      this.scrollTop = 0;
      this.scrolledToBottom = true;
      this.scaleX = 1;
      this.scaleY = 1;
      this.scrollAnchorPos = 0;
      this.scrollAnchorHeight = -1;
      this.scaler = IdScaler;
      this.scrollTarget = null;
      this.printing = false;
      this.mustMeasureContent = true;
      this.defaultTextDirection =