import { Err } from '..';
/** Catch errors in user code in Result operators, and instead return `Err` instances. */
export function withCatch(fn) {
    return ((...args) => {
        try {
            return fn(...args);
        }
        catch (err) {
            return new Err(err);
        }
    });
}
