import { Err, Ok } from '.';
import { curry } from '../fn/curry';
import { withCatch } from './lib/with-catch';
/** @tags result, wrap, invoke */
export const fromGuard = curry(withCatch(function fromGuard(guard, error, value) {
    return guard(value) ? new Ok(value) : new Err(error);
}), 3);
