import { Err } from '.';
import { curry } from '../fn/curry';
import { isOk } from './is-ok';
import { withCatch } from './lib/with-catch';
/** @tags result, right-biased */
export const filter = curry(withCatch((guard, msg, res) => {
    if (isOk(res) && guard(res.value))
        return res;
    return new Err(new Error(`${msg}: ${res.value}`));
}), 3);
