import type { Result } from '.';
/**
 * Takes an array of `Result` values and returns a `Result` containing an array of `Ok` values if all input values are
 * `Ok`. If any input value is an `Err`, returns an `Err` containing an array of all encountered `Err` values.
 *
 * @tags result, array
 */
export declare const all: <OkT, ErrT>(results: Result<OkT, ErrT>[]) => Result<OkT[], ErrT[]>;
