import { curry } from '../fn/curry';
import { isNonEmptyArray } from './is-non-empty-array';
/**
 * Returns true if array is not empty and any member of the array passes the guard
 *
 * @tags guard
 */
export const some = curry((guard, array) => isNonEmptyArray(array) && array.some(guard), 2);
