import { curry } from '../fn/curry';
/**
 * Returns whether both values are referentially equal, ie. `a === b`. This will be the case when both values are
 * primitives (undefined, number, null, string, or boolean) or they are objects which both point to the same address in
 * memory.
 *
 * @tags guard, comparator
 */
export const is = curry((b, a) => b === a, 2);
