import { curry } from '../fn/curry';
import { isGreaterThanOrEqualTo } from './is-greater-than-or-equal-to';
import { isLessThanOrEqualTo } from './is-less-than-or-equal-to';
/**
 * Asserts that a value is a `Number` which is both greater than or equal to `floor` and less than or equal to
 * `ceiling`.
 *
 * @tags guard, numbers
 */
export const isWithinRange = curry((floor, ceiling, value) => isLessThanOrEqualTo(ceiling, value) && isGreaterThanOrEqualTo(floor, value), 3);
