import { curry } from '../fn/curry';
import { isWithinRange } from './is-within-range';
/**
 * Asserts that a value is a number within the given acceptable distance from another.
 *
 * @tags guard, numbers, comparator
 */
export const isNear = curry((otherNumber, epsilon, value) => isWithinRange(otherNumber - epsilon, otherNumber + epsilon, value), 3);
