import { isCalculable } from './is-calculable';
import { isString } from './is-string';
/**
 * Asserts that a value is a `String` of valid JSON.
 *
 * @tags guard, strings, JSON
 */
export const isJsonString = (value) => {
    try {
        return (value === 'null' ||
            (isString(value) && (isCalculable(value) || JSON.parse(value) !== null)));
    }
    catch (err) {
        return false;
    }
};
