import { curry } from '../fn/curry';
import { isDate } from './is-date';
import { isNumber } from './is-number';
/**
 * Asserts that a value is an instance of `Date` occurring on the given day of the month, where the first day of the
 * month is `1` and last is `31`.
 *
 * @tags guard, dates, comparator
 */
export const isDateOnDayOfMonth = curry((dayOfMonth, value) => isDate(value) && isNumber(dayOfMonth) && value.getDate() === dayOfMonth, 2);
