import { curry } from '../fn/curry';
import { isArray } from './is-array';
/**
 * Asserts that a value is an `Array` containing a specific number of values.
 *
 * @tags guard, arrays, array-length
 */
export const isArrayOfSize = curry((size, value) => isArray(value) && value.length === size, 2);
