import { curry } from '../fn/curry';
import { isArray } from './is-array';
import { isJestEqual } from './is-jest-equal';
import { some } from './some';
/**
 * Asserts that `value` is an `Array` including at least one of the members of `allowedValues`.
 *
 * @tags guard, arrays, multiple-conditions
 */
export const isArrayIncludingAnyOf = curry((allowedValues, value) => isArray(allowedValues) &&
    isArray(value) &&
    some((allowedValue) => some(isJestEqual(allowedValue), value), allowedValues), 2);
