import { curry } from '../fn/curry';
import { every } from './every';
import { isArray } from './is-array';
import { isJestEqual } from './is-jest-equal';
import { some } from './some';
/**
 * Asserts that `value` is an `Array` including all of the values provided in `requiredValues`. It could also include
 * additional values or be in a different order, but if every value in `requiredValues` features in `value` then this
 * will return `true`.
 *
 * @tags guard, arrays, multiple-conditions
 */
export const isArrayIncludingAllOf = curry((requiredValues, value) => isArray(requiredValues) &&
    isArray(value) &&
    every((requiredValue) => some(isJestEqual(requiredValue), value), requiredValues), 2);
