import { curry } from '../fn/curry';
import { isDate } from './is-date';
/**
 * Asserts that a value is a valid instance of `Date` whose value occurs after that of another.
 *
 * @tags guard, dates, comparator
 */
export const isAfter = curry((otherDate, date) => isDate(date) && isDate(otherDate) && date.getTime() > otherDate.getTime(), 2);
