/**
 * Takes a value and passes it through a sequence of functions in left-to-right order.
 *
 * A Function that takes an initial value of any type (`unknown`), followed by any number of functions as arguments. It
 * returns the result of passing the initial value through each of the functions, one by one, in the order that they
 * were passed in. It provides a way to easily chain together multiple functions in a pipeline, where the output of each
 * function becomes the input for the next one.
 *
 * ## Example
 *
 * In this example, we have three functions: `add`, `multiply`, and `square`. We want to pass a value through these
 * functions in a specific order and get the final result.
 *
 * ```ts
 * import { pipe } from 'tightrope/fn/pipe';
 * import { add } from 'tightrope/number/add';
 * import { multiply } from 'tightrope/number/multiply';
 * import { square } from 'tightrope/number/square';
 *
 * const result = pipe(2, add(3), multiply(4), square);
 *
 * console.log(result); // Output: 400
 * ```
 *
 * @tags composition
 */
export declare function pipe<A0, A1>(value: A0, fn0: (a0: A0) => A1): A1;
export declare function pipe<A0, A1, A2>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2): A2;
export declare function pipe<A0, A1, A2, A3>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3): A3;
export declare function pipe<A0, A1, A2, A3, A4>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4): A4;
export declare function pipe<A0, A1, A2, A3, A4, A5>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5): A5;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6): A6;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7): A7;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8): A8;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9): A9;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10): A10;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11): A11;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12): A12;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13): A13;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14): A14;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15): A15;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16): A16;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17): A17;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18): A18;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19): A19;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20): A20;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21): A21;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22): A22;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23): A23;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24): A24;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25): A25;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26): A26;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27): A27;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28): A28;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29): A29;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30): A30;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31): A31;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32): A32;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33): A33;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34): A34;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35): A35;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36): A36;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37): A37;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38): A38;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39): A39;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40): A40;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41): A41;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42): A42;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43): A43;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44): A44;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45): A45;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46): A46;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47): A47;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48): A48;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49): A49;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50): A50;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51): A51;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52): A52;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53): A53;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54): A54;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55): A55;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56): A56;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57): A57;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58): A58;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59): A59;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60): A60;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61): A61;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62): A62;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63): A63;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64): A64;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65): A65;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66): A66;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67): A67;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68): A68;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69): A69;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70): A70;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71): A71;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72): A72;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73): A73;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73, fn73: (a73: A73) => A74): A74;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73, fn73: (a73: A73) => A74, fn74: (a74: A74) => A75): A75;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75, A76>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73, fn73: (a73: A73) => A74, fn74: (a74: A74) => A75, fn75: (a75: A75) => A76): A76;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75, A76, A77>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73, fn73: (a73: A73) => A74, fn74: (a74: A74) => A75, fn75: (a75: A75) => A76, fn76: (a76: A76) => A77): A77;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75, A76, A77, A78>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73, fn73: (a73: A73) => A74, fn74: (a74: A74) => A75, fn75: (a75: A75) => A76, fn76: (a76: A76) => A77, fn77: (a77: A77) => A78): A78;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75, A76, A77, A78, A79>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73, fn73: (a73: A73) => A74, fn74: (a74: A74) => A75, fn75: (a75: A75) => A76, fn76: (a76: A76) => A77, fn77: (a77: A77) => A78, fn78: (a78: A78) => A79): A79;
export declare function pipe<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75, A76, A77, A78, A79, A80>(value: A0, fn0: (a0: A0) => A1, fn1: (a1: A1) => A2, fn2: (a2: A2) => A3, fn3: (a3: A3) => A4, fn4: (a4: A4) => A5, fn5: (a5: A5) => A6, fn6: (a6: A6) => A7, fn7: (a7: A7) => A8, fn8: (a8: A8) => A9, fn9: (a9: A9) => A10, fn10: (a10: A10) => A11, fn11: (a11: A11) => A12, fn12: (a12: A12) => A13, fn13: (a13: A13) => A14, fn14: (a14: A14) => A15, fn15: (a15: A15) => A16, fn16: (a16: A16) => A17, fn17: (a17: A17) => A18, fn18: (a18: A18) => A19, fn19: (a19: A19) => A20, fn20: (a20: A20) => A21, fn21: (a21: A21) => A22, fn22: (a22: A22) => A23, fn23: (a23: A23) => A24, fn24: (a24: A24) => A25, fn25: (a25: A25) => A26, fn26: (a26: A26) => A27, fn27: (a27: A27) => A28, fn28: (a28: A28) => A29, fn29: (a29: A29) => A30, fn30: (a30: A30) => A31, fn31: (a31: A31) => A32, fn32: (a32: A32) => A33, fn33: (a33: A33) => A34, fn34: (a34: A34) => A35, fn35: (a35: A35) => A36, fn36: (a36: A36) => A37, fn37: (a37: A37) => A38, fn38: (a38: A38) => A39, fn39: (a39: A39) => A40, fn40: (a40: A40) => A41, fn41: (a41: A41) => A42, fn42: (a42: A42) => A43, fn43: (a43: A43) => A44, fn44: (a44: A44) => A45, fn45: (a45: A45) => A46, fn46: (a46: A46) => A47, fn47: (a47: A47) => A48, fn48: (a48: A48) => A49, fn49: (a49: A49) => A50, fn50: (a50: A50) => A51, fn51: (a51: A51) => A52, fn52: (a52: A52) => A53, fn53: (a53: A53) => A54, fn54: (a54: A54) => A55, fn55: (a55: A55) => A56, fn56: (a56: A56) => A57, fn57: (a57: A57) => A58, fn58: (a58: A58) => A59, fn59: (a59: A59) => A60, fn60: (a60: A60) => A61, fn61: (a61: A61) => A62, fn62: (a62: A62) => A63, fn63: (a63: A63) => A64, fn64: (a64: A64) => A65, fn65: (a65: A65) => A66, fn66: (a66: A66) => A67, fn67: (a67: A67) => A68, fn68: (a68: A68) => A69, fn69: (a69: A69) => A70, fn70: (a70: A70) => A71, fn71: (a71: A71) => A72, fn72: (a72: A72) => A73, fn73: (a73: A73) => A74, fn74: (a74: A74) => A75, fn75: (a75: A75) => A76, fn76: (a76: A76) => A77, fn77: (a77: A77) => A78, fn78: (a78: A78) => A79, fn79: (a79: A79) => A80): A80;
