/**
 * A function that does nothing.
 *
 * It is commonly used as a placeholder function in cases where a function is required but there is no action that needs
 * to be performed
 *
 * The `noOp` function can be useful in situations where you need to pass a function to another function, but you don't
 * actually need the function to perform any action. This can be useful for example in tests, or when defining default
 * values for functions that are not meant to be called.
 *
 * @tags composition
 */
export function noOp() {
    /* no-op */
}
