"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sequence = void 0;
const _1 = require(".");
const is_ok_1 = require("./is-ok");
/**
 * Takes an array of `Result` values and returns a `Result` containing an array of `Ok` values if all the input values
 * are `Ok`. If any input value is an `Err`, returns the first encountered `Err`.
 *
 * @tags result, array
 */
function sequence(results) {
    const okValues = [];
    for (const result of results) {
        if ((0, is_ok_1.isOk)(result)) {
            okValues.push(result.value);
        }
        else {
            return result;
        }
    }
    return new _1.Ok(okValues);
}
exports.sequence = sequence;
