"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ok = void 0;
const option_1 = require("../option");
const is_ok_1 = require("./is-ok");
/**
 * Transforms `Result<T, E>` into `Option<T>`, mapping `Ok(v)` to `Some(v)` and `Err(e)` to `None`.
 *
 * @tags result, option, transform, transform-result
 */
function ok(res) {
    return (0, is_ok_1.isOk)(res) ? new option_1.Some(res.value) : option_1.none;
}
exports.ok = ok;
