import type { AnyResult, ResOk } from '../fn/types';
import type { Option } from '../option';
/**
 * Transforms `Result<T, E>` into `Option<T>`, mapping `Ok(v)` to `Some(v)` and `Err(e)` to `None`.
 *
 * @tags result, option, transform, transform-result
 */
export declare function ok<Res extends AnyResult>(res: Res): Option<ResOk<Res>>;
