"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapOr = void 0;
const curry_1 = require("../fn/curry");
const is_ok_1 = require("./is-ok");
const with_catch_1 = require("./lib/with-catch");
/**
 * Returns the provided default (if `Err`), or applies a function to the contained value (if `Ok`),
 *
 * Arguments passed to `mapOr` are eagerly evaluated; if you are passing the result of a function call, it is
 * recommended to use `mapOrElse`, which is lazily evaluated.
 *
 * @tags result, transform, transform-result, right-biased, unwrap
 */
exports.mapOr = (0, curry_1.curry)((0, with_catch_1.withCatch)((defaultValue, mapOkFn, result) => {
    return (0, is_ok_1.isOk)(result) ? mapOkFn(result.value) : defaultValue;
}), 3);
