"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapOrElse = void 0;
const curry_1 = require("../fn/curry");
const is_ok_1 = require("./is-ok");
const with_catch_1 = require("./lib/with-catch");
/**
 * Maps a `Result` by applying fallback function default to a contained `Err` value, or a function to a contained `Ok`
 * value.
 *
 * This function can be used to unpack a successful result while handling an error.
 *
 * @tags result, transform, transform-result, right-biased, unwrap
 */
exports.mapOrElse = (0, curry_1.curry)((0, with_catch_1.withCatch)((mapErrFn, mapOkFn, result) => {
    return (0, is_ok_1.isOk)(result)
        ? mapOkFn(result.value)
        : mapErrFn(result.value);
}), 3);
