import type { AnyResult, ResErr, ResOk } from '../fn/types';
export type MapOrElse = {
    <Res extends AnyResult, Next>(mapErrFn: (err: ResErr<Res>) => Next, mapOkFn: (value: ResOk<Res>) => Next, result: Res): Next;
    <Res extends AnyResult, Next>(mapErrFn: (err: ResErr<Res>) => Next, mapOkFn: (value: ResOk<Res>) => Next): {
        (result: Res): Next;
    };
    <Res extends AnyResult, Next>(mapErrFn: (err: ResErr<Res>) => Next): {
        <Res extends AnyResult, Next>(mapOkFn: (value: ResOk<Res>) => Next): {
            (result: Res): Next;
        };
        <Res extends AnyResult, Next>(mapOkFn: (value: ResOk<Res>) => Next, result: Res): Next;
    };
};
/**
 * Maps a `Result` by applying fallback function default to a contained `Err` value, or a function to a contained `Ok`
 * value.
 *
 * This function can be used to unpack a successful result while handling an error.
 *
 * @tags result, transform, transform-result, right-biased, unwrap
 */
export declare const mapOrElse: MapOrElse;
