"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withCatch = void 0;
const __1 = require("..");
/** Catch errors in user code in Result operators, and instead return `Err` instances. */
function withCatch(fn) {
    return ((...args) => {
        try {
            return fn(...args);
        }
        catch (err) {
            return new __1.Err(err);
        }
    });
}
exports.withCatch = withCatch;
