"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isResult = void 0;
const is_err_1 = require("./is-err");
const is_ok_1 = require("./is-ok");
/**
 * Check if value is an instance of either the `Ok` or `Err` classes.
 *
 * You would use `isResult` when you want to check if a value is a `Result` instance, regardless of whether it contains
 * an `Ok` or `Err` variant.
 *
 * @tags result, guard
 */
function isResult(value) {
    return (0, is_ok_1.isOk)(value) || (0, is_err_1.isErr)(value);
}
exports.isResult = isResult;
