"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filter = void 0;
const _1 = require(".");
const curry_1 = require("../fn/curry");
const is_ok_1 = require("./is-ok");
const with_catch_1 = require("./lib/with-catch");
/** @tags result, right-biased */
exports.filter = (0, curry_1.curry)((0, with_catch_1.withCatch)((guard, msg, res) => {
    if ((0, is_ok_1.isOk)(res) && guard(res.value))
        return res;
    return new _1.Err(new Error(`${msg}: ${res.value}`));
}), 3);
