"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.all = void 0;
const _1 = require(".");
const is_ok_1 = require("./is-ok");
const with_catch_1 = require("./lib/with-catch");
/**
 * Takes an array of `Result` values and returns a `Result` containing an array of `Ok` values if all input values are
 * `Ok`. If any input value is an `Err`, returns an `Err` containing an array of all encountered `Err` values.
 *
 * @tags result, array
 */
exports.all = (0, with_catch_1.withCatch)(function all(results) {
    const okValues = [];
    const errValues = [];
    for (const result of results) {
        if ((0, is_ok_1.isOk)(result)) {
            okValues.push(result.value);
        }
        else {
            errValues.push(result.value);
        }
    }
    return errValues.length > 0 ? new _1.Err(errValues) : new _1.Ok(okValues);
});
