"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSome = void 0;
const _1 = require(".");
/**
 * Determines whether a value is an instance of `Some`.
 *
 * ## Example
 *
 * ```ts
 * import { isSome } from 'tightrope/option/is-some';
 * import { Some } from 'tightrope/option';
 *
 * console.log(isSome(new Some('hello'))); // true
 * console.log(isSome('not a some')); // false
 * ```
 *
 * @param value The value to check.
 * @returns `true` if the value is a `Some`, `false` otherwise.
 * @tags option, guard
 */
function isSome(value) {
    return value instanceof _1.Some && value._tag === 'Some';
}
exports.isSome = isSome;
