"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNone = void 0;
const is_object_1 = require("../guard/is-object");
/**
 * Returns true if the given value is a `None` instance, false otherwise.
 *
 * ## Example
 *
 * ```ts
 * import { isNone } from 'tightrope/option/is-none';
 * import { none } from 'tightrope/option';
 * import { Some } from 'tightrope/option';
 *
 * isNone(none); // true
 * isNone(new Some(1)); // false
 * isNone(null); // false
 * ```
 *
 * @param value - The value to check.
 * @returns A boolean indicating whether the given value is a `None` instance.
 * @tags option, guard, errors
 */
function isNone(value) {
    return (0, is_object_1.isObject)(value) && value._tag === 'None';
}
exports.isNone = isNone;
