"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.divide = void 0;
const curry_1 = require("../fn/curry");
const result_1 = require("../result");
/**
 * Divide one number by another.
 *
 * @tags numbers, transform, transform-value
 */
exports.divide = (0, curry_1.curry)((divisor, value) => {
    if (divisor === 0) {
        return new result_1.Err(new Error('Cannot divide by zero'));
    }
    return new result_1.Ok(value / divisor);
}, 2);
