"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clamp = void 0;
const curry_1 = require("../fn/curry");
/**
 * Returns a number within the specified range, if the original value is not already within that range.
 *
 * @tags numbers, transform, transform-value
 */
exports.clamp = (0, curry_1.curry)((floor, ceiling, value) => {
    return Math.max(floor, Math.min(ceiling, value));
}, 3);
