"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwsErrorOfType = void 0;
const curry_1 = require("../fn/curry");
const has_type_1 = require("./has-type");
const is_function_1 = require("./is-function");
/**
 * Asserts that a value is a `Function` which throws an `Error` of the given type.
 *
 * @tags guard, functions, errors
 */
exports.throwsErrorOfType = (0, curry_1.curry)((typeName, value) => {
    try {
        if (!(0, is_function_1.isFunction)(value))
            return false;
        value();
        return false;
    }
    catch (err) {
        return (0, has_type_1.hasType)(typeName, err);
    }
}, 2);
